/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualEditor;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualEditorFactory;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.util.VpePlatformUtil;
import org.jboss.tools.vpe.preview.editor.VpvEditorPart;

public class VpeEditorPartFactory
implements IVisualEditorFactory {
    public IVisualEditor createVisualEditor(EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        String fileExtension;
        if (VpePlatformUtil.isXulrunnerEnabled()) {
            return this.getVpeEditor(multiPageEditor, textEditor, visualMode, bundleMap);
        }
        IEditorInput editorInput = multiPageEditor.getEditorInput();
        boolean isHtmlFile = false;
        isHtmlFile = editorInput instanceof IFileEditorInput ? "html".equals(fileExtension = ((IFileEditorInput)editorInput).getFile().getFileExtension()) || "htm".equals(fileExtension) : true;
        if (isHtmlFile) {
            return this.getPreviewEditor(multiPageEditor, textEditor, visualMode, bundleMap);
        }
        return this.getVpeEditor(multiPageEditor, textEditor, visualMode, bundleMap);
    }

    private IVisualEditor getVpeEditor(final EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        return new VpeEditorPart(multiPageEditor, textEditor, visualMode, bundleMap){

            public void doSave(IProgressMonitor monitor) {
                multiPageEditor.doSave(monitor);
            }
        };
    }

    private IVisualEditor getPreviewEditor(EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        return new VpvEditorPart(multiPageEditor, textEditor, visualMode, bundleMap);
    }
}

