/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.internal.identification;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.jboss.tools.maven.core.internal.identification.AbstractArtifactIdentifier;

public class MavenPropertiesIdentifier
extends AbstractArtifactIdentifier {
    public MavenPropertiesIdentifier() {
        super("Maven Properties identifier");
    }

    @Override
    public ArtifactKey identify(File file) throws CoreException {
        return this.identify(file, null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ArtifactKey identify(File file, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ZipFile jar = null;
        jar = new ZipFile(file);
        monitor.setTaskName("Checking for maven properties in " + file.getName());
        ArtifactKey artifactKey = MavenPropertiesIdentifier.getArtifactFromMetaInf(jar);
        if (jar == null) return artifactKey;
        try {
            jar.close();
            return artifactKey;
        }
        catch (IOException iOException) {}
        return artifactKey;
        catch (ZipException e) {
            e.printStackTrace();
            if (jar == null) return null;
            try {
                jar.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            if (jar == null) return null;
            {
                catch (Throwable throwable) {
                    if (jar == null) throw throwable;
                    try {
                        jar.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                jar.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    protected static ArtifactKey getArtifactFromMetaInf(ZipFile jar) throws IOException {
        ZipEntry mavenEntry = jar.getEntry("META-INF/maven");
        if (mavenEntry == null) {
            return null;
        }
        String entryName = mavenEntry.getName();
        Enumeration<? extends ZipEntry> zipEntries = jar.entries();
        ArtifactKey artifact = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!zipEntry.getName().endsWith("pom.properties") || !zipEntry.getName().startsWith(entryName)) continue;
            if (artifact != null) {
                return null;
            }
            Properties props = new Properties();
            props.load(jar.getInputStream(zipEntry));
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            String version = props.getProperty("version");
            String classifier = props.getProperty("classifier");
            if (groupId == null || artifactId == null || version == null) continue;
            artifact = new ArtifactKey(groupId, artifactId, version, classifier);
        }
        return artifact;
    }
}

