/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.internal.identification;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.osgi.util.NLS;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.common.util.HttpUtil;
import org.jboss.tools.maven.core.identification.IdentificationUtil;
import org.jboss.tools.maven.core.internal.identification.AbstractArtifactIdentifier;

public class MavenCentralIdentifier
extends AbstractArtifactIdentifier {
    private String SHA1_SEARCH_QUERY = "http://search.maven.org/solrsearch/select?q=1:%22{0}%22&rows=1&wt=json";
    private String NAME_VERSION_SEARCH_QUERY = "http://search.maven.org/solrsearch/select?q=a:%22{0}%22%20AND%20v:%22{1}%22&rows=2&wt=json";

    @Override
    @Deprecated
    public ArtifactKey identify(File file) throws CoreException {
        return this.identify(file, null);
    }

    @Override
    public ArtifactKey identify(File file, IProgressMonitor monitor) throws CoreException {
        ArtifactKey key = this.sha1Search(file, monitor);
        if (key == null) {
            key = this.nameVersionSearch(file, monitor);
        }
        return key;
    }

    private ArtifactKey sha1Search(File file, IProgressMonitor monitor) {
        String sha1;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        try {
            sha1 = IdentificationUtil.getSHA1(file);
        }
        catch (Exception exception) {
            return null;
        }
        String searchUrl = NLS.bind((String)this.SHA1_SEARCH_QUERY, (Object)sha1);
        return this.find(searchUrl);
    }

    private ArtifactKey nameVersionSearch(File file, IProgressMonitor monitor) {
        Manifest manifest;
        block18: {
            JarFile jar = null;
            manifest = null;
            try {
                try {
                    jar = new JarFile(file);
                    manifest = jar.getManifest();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
        if (manifest == null) {
            return null;
        }
        String version = manifest.getMainAttributes().getValue("Implementation-Version");
        String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (version == null || version.trim().isEmpty() || name == null || name.trim().isEmpty()) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        String searchUrl = NLS.bind((String)this.NAME_VERSION_SEARCH_QUERY, (Object)name, (Object)version);
        return this.find(searchUrl);
    }

    private ArtifactKey find(String searchUrl) {
        InputStream is = null;
        try {
            is = HttpUtil.getInputStreamFromUrlByGetMethod((String)searchUrl);
            ModelNode modelNode = ModelNode.fromJSONStream((InputStream)is);
            if (modelNode.isDefined()) {
                ArtifactKey artifactKey = this.extractKey(modelNode);
                return artifactKey;
            }
        }
        catch (IOException ioe) {
            System.err.println("MavenCentralIdentifier can't connect to " + searchUrl + " : " + ioe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        return null;
    }

    private ArtifactKey extractKey(ModelNode modelNode) {
        ModelNode docs;
        int num;
        ModelNode response = modelNode.get("response");
        if (response != null && (num = response.get("numFound").asInt()) > 0 && (docs = response.get("docs")).isDefined()) {
            String a = null;
            String g = null;
            String v = null;
            for (ModelNode n : docs.asList()) {
                if (!n.hasDefined("a") || !n.hasDefined("g") || !n.hasDefined("v")) continue;
                a = n.get("a").asString();
                g = n.get("g").asString();
                v = n.get("v").asString();
                if (a == null || g == null || v == null) continue;
                return new ArtifactKey(g, a, v, null);
            }
        }
        return null;
    }
}

