/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.identification;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class IdentificationUtil {
    private static final String CLASSIFIER_SOURCES = "sources";
    private static final String CLASSIFIER_TESTS = "tests";
    private static final String CLASSIFIER_TESTSOURCES = "test-sources";

    private IdentificationUtil() {
    }

    public static String getSHA1(File file) throws IOException, NoSuchAlgorithmException {
        if (file == null) {
            return null;
        }
        InputStream inputStream = null;
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            inputStream = new FileInputStream(file);
            byte[] bytes = new byte[16384];
            int count = 0;
            while ((count = inputStream.read(bytes)) != -1) {
                md.update(bytes, 0, count);
            }
            byte[] digestBytes = md.digest();
            int i = 0;
            while (i < digestBytes.length) {
                sb.append(Integer.toString((digestBytes[i] & 0xFF) + 256, 16).substring(1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    public static String getSourcesClassifier(String baseClassifier) {
        return CLASSIFIER_TESTS.equals(baseClassifier) ? CLASSIFIER_TESTSOURCES : CLASSIFIER_SOURCES;
    }
}

