/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.service.support;

import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.insight.log.service.Logs;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class MavenCoordinates {
    private static Map<String, String> MAVEN_COORDINATES = new ConcurrentHashMap<String, String>();

    public static void addMavenCoord(Map<String, String> properties) {
        String mavenCoord;
        if (properties.get("maven.coordinates") == null && (mavenCoord = MavenCoordinates.getMavenCoordinates(properties)) != null && !mavenCoord.isEmpty()) {
            properties.put("maven.coordinates", mavenCoord);
        }
    }

    public static String[] addMavenCoord(String[] throwable) {
        if (throwable != null) {
            String[] newThrowable = new String[throwable.length];
            for (int i = 0; i < newThrowable.length; ++i) {
                newThrowable[i] = MavenCoordinates.addMavenCoord(throwable[i]);
            }
            return newThrowable;
        }
        return throwable;
    }

    private static String addMavenCoord(String line) {
        String idStr;
        String mvn;
        String str;
        int index;
        if (line.endsWith("]") && (index = line.lastIndexOf(91)) > 0 && (index = (str = line.substring(index + 1, line.length() - 1)).indexOf(58)) > 0 && (mvn = MavenCoordinates.getMavenCoordinates(idStr = str.substring(0, index))) != null) {
            return line + "[" + mvn + "]";
        }
        return line;
    }

    private static String getMavenCoordinates(Map props) {
        Object id;
        Object object = id = props != null ? (Object)props.get("bundle.id") : null;
        if (id == null) {
            return null;
        }
        return MavenCoordinates.getMavenCoordinates(id.toString());
    }

    private static String getMavenCoordinates(String bundleIdStr) {
        long bundleId;
        try {
            bundleId = Long.parseLong(bundleIdStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return MavenCoordinates.getMavenCoordinates(bundleId);
    }

    public static Bundle getBundle(long bundleId) {
        Bundle logBundle = FrameworkUtil.getBundle(Logs.class);
        BundleContext bundleContext = logBundle != null ? logBundle.getBundleContext() : null;
        Bundle bundle = bundleContext != null ? bundleContext.getBundle(bundleId) : null;
        return bundle;
    }

    public static String getMavenCoordinates(long bundleId) {
        Bundle bundle = MavenCoordinates.getBundle(bundleId);
        if (bundle == null) {
            return null;
        }
        String id = Long.toString(bundle.getBundleId()) + ":" + Long.toString(bundle.getLastModified());
        String maven = MAVEN_COORDINATES.get(id);
        if (maven == null) {
            if (bundle.getState() >= 4) {
                try {
                    Enumeration e = bundle.findEntries("META-INF/maven/", "pom.properties", true);
                    StringBuilder buf = new StringBuilder();
                    while (e != null && e.hasMoreElements()) {
                        URL url = (URL)e.nextElement();
                        org.fusesource.insight.log.support.MavenCoordinates.appendMavenCoordinateFromPomProperties(url.openStream(), buf);
                    }
                    maven = buf.toString();
                }
                catch (Throwable t) {
                    maven = "";
                }
                MAVEN_COORDINATES.put(id, maven);
            } else {
                maven = "";
            }
        }
        return maven;
    }
}

