/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard.workflow;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;

public class DownloadManagerTermsAndConditionsFragment
extends WizardFragment {
    public static final String WORKFLOW_NEXT_STEP_KEY = "WORKFLOW_NEXT_STEP_KEY_TC";
    private static final String DOWNLOAD_RUNTIME_SECTION = "downloadRuntimeSection";
    private IDialogSettings downloadRuntimeSection;
    private IWizardHandle handle;
    private Combo country;
    private Button acceptButton;
    private WizardFragment nextWorkflowFragment = null;
    private String tocText;
    private String tcUrl;
    private String tcAcceptUrl;
    private HashMap<String, String> countryMap = null;
    private ArrayList<String> countryList = null;
    private String downloadURL = null;
    private boolean initialized = false;
    private Browser browser;

    public DownloadManagerTermsAndConditionsFragment() {
        IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
        this.downloadRuntimeSection = dialogSettings.getSection(DOWNLOAD_RUNTIME_SECTION);
        if (this.downloadRuntimeSection == null) {
            this.downloadRuntimeSection = dialogSettings.addNewSection(DOWNLOAD_RUNTIME_SECTION);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.nextWorkflowFragment != null) {
            list.add(this.nextWorkflowFragment);
        }
    }

    public void enter() {
        this.setComplete(false);
        if (!this.initialized) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerTermsAndConditionsFragment.this.deferredEntry();
                }
            });
        }
    }

    private void deferredEntry() {
        try {
            this.handle.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DownloadManagerTermsAndConditionsFragment.this.initializeModel(monitor);
                }
            });
            this.fillWidgets();
            this.initialized = true;
            this.handle.update();
        }
        catch (Exception e) {
            RuntimeUIActivator.pluginLog().logError((Throwable)e);
        }
    }

    protected void initializeModel(IProgressMonitor monitor) {
        String plaintext;
        monitor.beginTask("Loading Terms and Conditions", 1000);
        String workflowResponse = (String)this.getTaskModel().getObject("WORKFLOW_NEXT_STEP_KEY");
        XMLMemento m = XMLMemento.createReadRoot((InputStream)new ByteArrayInputStream(workflowResponse.getBytes()));
        IMemento workflow = m.getChild("workflow");
        IMemento tc = workflow.getChild("tc");
        IMemento tcAccept = workflow.getChild("tc-accept");
        this.tcUrl = ((XMLMemento)tc).getTextData();
        this.tcAcceptUrl = ((XMLMemento)tcAccept).getTextData();
        monitor.worked(100);
        String tcResponseString = null;
        try {
            tcResponseString = this.getTCResponseString((IProgressMonitor)new SubProgressMonitor(monitor, 800));
        }
        catch (Exception e) {
            final String msg = "An error occurred while loading the terms and conditions: " + e.getClass().getName() + " - " + e.getMessage();
            RuntimeCoreActivator.pluginLog().logError(msg, (Throwable)e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerTermsAndConditionsFragment.this.handle.setMessage(msg, 3);
                }
            });
            return;
        }
        XMLMemento tocResponseMemento = XMLMemento.createReadRoot((InputStream)new ByteArrayInputStream(tcResponseString.getBytes()));
        IMemento customParamsMemento = tocResponseMemento.getChild("customParams");
        IMemento[] params = customParamsMemento.getChildren("param");
        IMemento countryParam = null;
        IMemento downloadURLParam = null;
        int i = 0;
        while (i < params.length) {
            String name = params[i].getString("name");
            if (name.equals("country")) {
                countryParam = params[i];
            }
            if (name.equals("downloadURL")) {
                downloadURLParam = params[i];
            }
            ++i;
        }
        IMemento countryOptions = countryParam.getChild("options");
        IMemento[] countries = countryOptions.getChildren("option");
        this.countryMap = new HashMap();
        this.countryList = new ArrayList();
        int i2 = 0;
        while (i2 < countries.length) {
            this.countryList.add(countries[i2].getString("key"));
            this.countryMap.put(countries[i2].getString("key"), countries[i2].getString("value"));
            ++i2;
        }
        IMemento downloadURLOptions = downloadURLParam.getChild("options");
        IMemento downloadURLOption = downloadURLOptions.getChild("option");
        this.downloadURL = downloadURLOption.getString("key");
        IMemento tcPlainTextMemento = tocResponseMemento.getChild("htmlText");
        this.tocText = plaintext = ((XMLMemento)tcPlainTextMemento).getTextData();
        monitor.worked(100);
        monitor.done();
    }

    private void fillWidgets() {
        if (this.browser != null && !this.browser.isDisposed() && this.tocText != null) {
            this.browser.setText(this.tocText);
        }
        if (this.country != null && !this.country.isDisposed() && this.countryMap != null) {
            String[] asArr = this.countryList.toArray(new String[this.countryList.size()]);
            this.country.setItems(asArr);
        }
    }

    private String getTCResponseString(IProgressMonitor monitor) throws Exception {
        String line;
        String result = "";
        HttpURLConnection con = (HttpURLConnection)new URL(this.tcUrl).openConnection();
        con.setRequestMethod("GET");
        InputStream stream = con.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        while ((line = br.readLine()) != null) {
            result = String.valueOf(result) + line;
        }
        con.disconnect();
        br.close();
        return result;
    }

    public Composite createComposite(Composite parent, final IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle("JBoss.org Terms and Conditions");
        this.getPage().setDescription("Please select your country and accept the terms and conditions to complete this download by clicking \"Accept Now\". This will formally accept the usage license for the selected runtime.");
        Composite contents = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new FormLayout());
        this.acceptButton = new Button(contents, 8);
        this.acceptButton.setText("Accept Now");
        this.acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadManagerTermsAndConditionsFragment.this.acceptPressed();
                handle.update();
            }
        });
        FormData fd = new FormData();
        fd.bottom = new FormAttachment(100, -5);
        fd.right = new FormAttachment(100, -5);
        this.acceptButton.setLayoutData((Object)fd);
        this.acceptButton.setEnabled(false);
        Label countryLabel = new Label(contents, 0);
        countryLabel.setText("Please choose the country of use: ");
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment(100, -5);
        countryLabel.setLayoutData((Object)fd);
        this.country = new Combo(contents, 12);
        fd = new FormData();
        fd.left = new FormAttachment((Control)countryLabel, 5);
        fd.bottom = new FormAttachment(100, -5);
        fd.right = new FormAttachment(80, -5);
        this.country.setLayoutData((Object)fd);
        this.country.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = DownloadManagerTermsAndConditionsFragment.this.country.getSelectionIndex();
                if (index != -1) {
                    DownloadManagerTermsAndConditionsFragment.this.acceptButton.setEnabled(true);
                }
            }
        });
        try {
            this.browser = new Browser(contents, 2048);
        }
        catch (Exception exception) {
            this.browser = new Browser(contents, 67584);
        }
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)this.acceptButton, -5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.top = new FormAttachment(0, 5);
        this.browser.setLayoutData((Object)fd);
        this.setComplete(false);
        this.fillWidgets();
        return contents;
    }

    protected void acceptPressed() {
        final Exception[] error = new Exception[]{null};
        try {
            final String countryString = this.country.getItem(this.country.getSelectionIndex());
            this.handle.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DownloadManagerTermsAndConditionsFragment.this.sendAccepted(countryString);
                    }
                    catch (Exception e) {
                        RuntimeUIActivator.pluginLog().logError((Throwable)e);
                        error[0] = e;
                    }
                }
            });
        }
        catch (InterruptedException ie) {
            error[0] = ie;
        }
        catch (InvocationTargetException ite) {
            error[0] = ite;
        }
        if (error[0] != null) {
            this.handle.setMessage("Unable to accept terms and conditions: " + error[0].getClass().getName() + " - " + error[0].getMessage(), 3);
        } else {
            this.setComplete(true);
        }
    }

    protected void sendAccepted(String countryString) throws Exception {
        String urlParameters = "country=" + URLEncoder.encode(countryString);
        urlParameters = String.valueOf(urlParameters) + "&downloadURL=" + URLEncoder.encode(this.downloadURL);
        String user = (String)this.getTaskModel().getObject("dl.runtime.username");
        String pass = (String)this.getTaskModel().getObject("dl.runtime.password");
        String userCredentials = String.valueOf(user) + ":" + pass;
        new Base64();
        String basicAuth = "Basic " + new String(Base64.encode((byte[])userCredentials.getBytes()));
        HttpURLConnection con = (HttpURLConnection)new URL(this.tcAcceptUrl).openConnection();
        con.setRequestProperty("Authorization", basicAuth);
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("charset", "utf-8");
        con.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
        con.setUseCaches(false);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(urlParameters);
        wr.flush();
        wr.close();
        con.getResponseCode();
        con.getResponseMessage();
        InputStream is = con.getInputStream();
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String read = br.readLine();
        while (read != null) {
            sb.append(read);
            read = br.readLine();
        }
        con.disconnect();
    }

    public void finishPage() {
    }
}

