/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard.workflow;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.wizard.workflow.DownloadManagerWorkflowUtility;

public class DownloadManagerCredentialsFragment
extends WizardFragment {
    public static final String WORKFLOW_NEXT_STEP_KEY = "WORKFLOW_NEXT_STEP_KEY";
    private String JBOSS_ORG_SIGNUP_URL = "https://community.jboss.org/register.jspa";
    private static final String DOWNLOAD_RUNTIME_SECTION = "downloadRuntimeSection";
    private IDialogSettings downloadRuntimeSection;
    private IWizardHandle handle;
    private Text userText;
    private Text passText;
    private int headerResponse = -1;
    private WizardFragment nextWorkflowFragment = null;

    public DownloadManagerCredentialsFragment() {
        IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
        this.downloadRuntimeSection = dialogSettings.getSection(DOWNLOAD_RUNTIME_SECTION);
        if (this.downloadRuntimeSection == null) {
            this.downloadRuntimeSection = dialogSettings.addNewSection(DOWNLOAD_RUNTIME_SECTION);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.nextWorkflowFragment != null) {
            list.add(this.nextWorkflowFragment);
        }
    }

    public void enter() {
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle("JBoss.org Credentials");
        this.getPage().setDescription("Please use your jboss.org single sign-on credentials to begin your download.");
        Composite contents = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        Composite wrap = new Composite(contents, 0);
        wrap.setLayout((Layout)new GridLayout(2, false));
        Link l = new Link(wrap, 64);
        l.setText("Please enter your jboss.org credentials below.\nIf you do not have a jboss.org account, please sign up <a>here</a>");
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 2;
        l.setLayoutData((Object)gd1);
        l.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadManagerCredentialsFragment.this.createJBossOrgAccount();
            }
        });
        Label userLabel = new Label(wrap, 0);
        userLabel.setText("Username: ");
        this.userText = new Text(wrap, 2048);
        Label passLabel = new Label(wrap, 0);
        passLabel.setText("Password: ");
        this.passText = new Text(wrap, 0x400800);
        this.userText.setText("");
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadManagerCredentialsFragment.this.getTaskModel().putObject("dl.runtime.username", (Object)DownloadManagerCredentialsFragment.this.userText.getText());
                DownloadManagerCredentialsFragment.this.validateFragment();
            }
        });
        this.passText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadManagerCredentialsFragment.this.getTaskModel().putObject("dl.runtime.password", (Object)DownloadManagerCredentialsFragment.this.passText.getText());
                DownloadManagerCredentialsFragment.this.validateFragment();
            }
        });
        GridData gd2 = new GridData();
        gd2.widthHint = 200;
        this.userText.setLayoutData((Object)gd2);
        this.passText.setLayoutData((Object)gd2);
        wrap.setLayoutData((Object)gd);
        this.setComplete(false);
        return contents;
    }

    protected void createJBossOrgAccount() {
        new BrowserUtility().checkedCreateExternalBrowser(this.JBOSS_ORG_SIGNUP_URL, "org.jboss.tools.runtime.ui", RuntimeUIActivator.getDefault().getLog());
    }

    protected void validateFragment() {
        String tempName = (String)this.getTaskModel().getObject("dl.runtime.username");
        String tempPass = (String)this.getTaskModel().getObject("dl.runtime.password");
        boolean nameEmpty = tempName == null || tempName.trim().length() == 0;
        boolean passEmpty = tempPass == null || tempPass.trim().length() == 0;
        this.setComplete(!nameEmpty && !passEmpty);
        this.headerResponse = -1;
        this.handle.update();
    }

    private void validationPressed() {
        final String userS = this.userText.getText();
        final String passS = this.passText.getText();
        final String[] error = new String[1];
        try {
            this.handle.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Validating Credentials", 100);
                    monitor.worked(10);
                    error[0] = DownloadManagerCredentialsFragment.this.validateCredentials(userS, passS);
                    monitor.done();
                }
            });
            if (error[0] != null) {
                this.handle.setMessage(error[0], 3);
            } else {
                this.handle.setMessage(null, 0);
            }
            this.handle.update();
        }
        catch (InterruptedException ie) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ite);
        }
    }

    private String validateCredentials(String userS, String passS) {
        int response;
        block7: {
            block6: {
                try {
                    response = DownloadManagerWorkflowUtility.getWorkflowStatus(this.getDownloadRuntimeFromTaskModel(), userS, passS);
                    if (response != 2) break block6;
                    return "Your credentials are incorrect. Please review the values and try again.";
                }
                catch (Exception e) {
                    RuntimeUIActivator.pluginLog().logError((Throwable)e);
                    return "An error occurred while validating your credentials. " + e.getClass().getName() + " - " + e.getMessage();
                }
            }
            if (response != 3) break block7;
            String responseContent = DownloadManagerWorkflowUtility.getWorkflowResponseContent(this.getDownloadRuntimeFromTaskModel(), userS, passS);
            this.getTaskModel().putObject(WORKFLOW_NEXT_STEP_KEY, (Object)responseContent);
            this.nextWorkflowFragment = DownloadManagerWorkflowUtility.getNextWorkflowFragment(responseContent);
            if (this.nextWorkflowFragment == null) {
                return "Unable to display the next workflow step. To download, please visit " + this.getDownloadRuntimeFromTaskModel().getUrl();
            }
            return null;
        }
        if (response == 1) {
            this.nextWorkflowFragment = null;
            return null;
        }
        return null;
    }

    private DownloadRuntime getDownloadRuntimeFromTaskModel() {
        return (DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop");
    }

    protected boolean hasActionOnNextPressed() {
        return true;
    }

    protected boolean performNextPressedAction() {
        this.validationPressed();
        String msg = this.handle.getMessage();
        if (msg != null) {
            this.setComplete(false);
            this.handle.update();
        }
        return msg == null;
    }
}

