/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;

public class DownloadRuntimeLicenseFragment
extends WizardFragment {
    private static final String DOWNLOAD_RUNTIME_SECTION = "downloadRuntimeSection";
    private Button accept;
    private Button decline;
    private Browser browser;
    private DownloadRuntime dlrt;
    private IDialogSettings downloadRuntimeSection;
    private IWizardHandle handle;

    public DownloadRuntimeLicenseFragment() {
        IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
        this.downloadRuntimeSection = dialogSettings.getSection(DOWNLOAD_RUNTIME_SECTION);
        if (this.downloadRuntimeSection == null) {
            this.downloadRuntimeSection = dialogSettings.addNewSection(DOWNLOAD_RUNTIME_SECTION);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    protected void createChildFragments(List<WizardFragment> list) {
    }

    public void enter() {
        DownloadRuntime tmp = this.getDownloadRuntimeFromTaskModel();
        if (tmp != null && !tmp.equals((Object)this.dlrt)) {
            this.dlrt = tmp;
            this.setDownloadRuntime(this.dlrt);
        }
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle(Messages.DownloadRuntimeLicensePage_Runtime_License);
        this.getPage().setDescription(Messages.DownloadRuntimeLicensePage_This_license_must_be_accepted);
        Composite contents = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        Composite wrap = new Composite(contents, 2048);
        wrap.setLayout((Layout)new GridLayout(1, false));
        try {
            this.browser = new Browser(wrap, 0);
        }
        catch (Exception exception) {
            this.browser = new Browser(wrap, 65536);
        }
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 150;
        this.browser.setLayoutData((Object)gd);
        wrap.setLayoutData((Object)gd);
        this.accept = new Button(contents, 16);
        this.accept.setText(Messages.DownloadRuntimeLicensePage_I_accept_the_terms);
        this.accept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadRuntimeLicenseFragment.this.setComplete(DownloadRuntimeLicenseFragment.this.accept.getSelection());
                DownloadRuntimeLicenseFragment.this.handle.update();
            }
        });
        this.decline = new Button(contents, 16);
        this.decline.setText(Messages.DownloadRuntimeLicensePage_I_do_not_accept_the_terms);
        this.decline.setSelection(true);
        this.decline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DownloadRuntimeLicenseFragment.this.setComplete(DownloadRuntimeLicenseFragment.this.accept.getSelection());
                DownloadRuntimeLicenseFragment.this.handle.update();
            }
        });
        this.setDownloadRuntime(this.getDownloadRuntimeFromTaskModel());
        return contents;
    }

    private void setDownloadRuntime(DownloadRuntime downloadRuntime) {
        if (downloadRuntime != null) {
            if (this.browser != null && downloadRuntime.getLicenceURL() != null && !downloadRuntime.getLicenceURL().isEmpty()) {
                this.browser.setText("<html></html>");
                this.browser.setUrl(downloadRuntime.getLicenceURL());
            }
            this.getPage().setTitle(NLS.bind((String)Messages.DownloadRuntimeLicensePage_Runtime, (Object)downloadRuntime.getName()));
            boolean accepted = this.isAccepted(downloadRuntime);
            if (this.decline != null) {
                this.decline.setSelection(!accepted);
                this.accept.setSelection(accepted);
                this.setComplete(accepted);
            }
        } else if (this.decline != null) {
            this.decline.setSelection(true);
            this.accept.setSelection(false);
            this.setComplete(false);
        }
        this.handle.update();
    }

    public boolean isAccepted(DownloadRuntime downloadRuntime) {
        if (downloadRuntime == null) {
            return false;
        }
        if (downloadRuntime != null && (downloadRuntime.getLicenceURL() == null || downloadRuntime.getLicenceURL().isEmpty())) {
            return true;
        }
        return this.downloadRuntimeSection.getBoolean(downloadRuntime.getId());
    }

    public void finishPage() {
        DownloadRuntime dl = this.getDownloadRuntimeFromTaskModel();
        if (dl != null && this.accept != null && !this.accept.isDisposed()) {
            this.downloadRuntimeSection.put(dl.getId(), this.accept.getSelection());
        }
    }

    private DownloadRuntime getDownloadRuntimeFromTaskModel() {
        return (DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop");
    }
}

