/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.jboss.tools.runtime.ui.internal.preferences.RuntimePreferencePage;

public class RuntimeWorkbenchUtils {
    public static void refreshServersView() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view;
                if (PlatformUI.isWorkbenchRunning() && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.wst.server.ui.ServersView")) instanceof CommonNavigator) {
                    CommonNavigator navigator = (CommonNavigator)view;
                    navigator.getCommonViewer().refresh();
                }
            }
        });
    }

    public static void refreshPreferencePage(final Shell shell) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RuntimeWorkbenchUtils.refreshPreferencePageUIThread(shell);
            }
        });
    }

    public static void refreshPreferencePageUIThread(Shell shell) {
        RuntimeWorkbenchUtils.refreshPreferencePageUIThread(shell, RuntimePreferencePage.ID);
    }

    public static void refreshPreferencePageUIThread(Shell shell, String pageId) {
        Shell mainShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.close();
        }
        if ((shell = Display.getCurrent().getActiveShell()) != mainShell && shell != null) {
            shell.close();
        }
        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)pageId, null, null);
        preferenceDialog.open();
    }
}

