/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.core.jsdi.Variable;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.Tracing;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFArrayReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFFunctionReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFLocation;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFObjectReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFScriptReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFThreadReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVariable;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.Messages;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFRequestPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFResponsePacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;

public class CFStackFrame
extends CFMirror
implements StackFrame {
    private int index = -1;
    private String scriptUrl = null;
    private String funcname = null;
    private int linenumber = -1;
    private List vars = null;
    private Variable thisvar = null;
    private CFLocation loc = null;
    private CFThreadReference thread = null;

    public CFStackFrame(VirtualMachine vm, CFThreadReference thread, Map json) {
        super(vm);
        this.thread = thread;
        Number value = (Number)json.get("index");
        if (value != null) {
            this.index = value.intValue();
        }
        if ((value = (Number)json.get("line")) != null) {
            this.linenumber = value.intValue();
        }
        this.scriptUrl = (String)json.get("url");
        this.funcname = (String)json.get("functionName");
        this.parseLocals((Map)json.get("locals"));
        this.parseScopes((List)json.get("scopes"));
    }

    void parseScopes(List list) {
        if (list != null) {
            if (this.vars == null) {
                this.vars = new ArrayList(list.size());
            }
            for (Map map : list) {
                Map scope;
                String name = (String)map.get("name");
                if (name == null) {
                    name = Messages.CFStackFrame_0;
                }
                if ((scope = (Map)map.get("scope")) == null) continue;
                this.vars.add(0, new CFVariable(this.crossfire(), this, name, (Number)scope.get("handle"), scope));
            }
        }
    }

    void parseLocals(Map json) {
        if (json != null) {
            Object val = json.get("value");
            if (val instanceof Map) {
                Map locals = (Map)json.get("value");
                if (locals != null) {
                    this.vars = new ArrayList(locals.size());
                    this.parseVariables(locals, this.vars);
                }
            } else {
                this.vars = new ArrayList();
            }
            Map thismap = (Map)json.get("this");
            this.thisvar = new CFVariable(this.crossfire(), this, "this", null, thismap);
        }
    }

    void parseVariables(Map map, List varcollector) {
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
            if (!(entry2.getValue() instanceof Map)) continue;
            Map info = (Map)entry2.getValue();
            Object obj = info.get("handle");
            Number ref = null;
            if (obj instanceof Number) {
                ref = (Number)obj;
            }
            varcollector.add(new CFVariable(this.crossfire(), this, (String)entry2.getKey(), ref, info));
        }
    }

    public Variable thisObject() {
        return this.thisvar;
    }

    public synchronized List variables() {
        if (this.vars != null) {
            return this.vars;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized Location location() {
        CFScriptReference script;
        if (this.loc == null && (script = this.crossfire().findScript(this.scriptUrl)) != null) {
            this.loc = new CFLocation(this.crossfire(), script, this.funcname, this.linenumber);
        }
        return this.loc;
    }

    public Value evaluate(String expression) {
        CFRequestPacket request = new CFRequestPacket("evaluate", this.thread.id());
        request.setArgument("frameIndex", new Integer(this.index));
        request.setArgument("expression", expression);
        CFResponsePacket response = this.crossfire().sendRequest(request);
        if (response.isSuccess()) {
            return this.createValue(response.getBody().get("result"));
        }
        if (TRACE) {
            Tracing.writeString("STACKFRAME [failed evaluate request]: " + JSON.serialize(request));
        }
        return this.virtualMachine().mirrorOfNull();
    }

    public int frameindex() {
        return this.index;
    }

    public Value lookup(Number ref) {
        if (ref != null) {
            CFRequestPacket request = new CFRequestPacket("lookup", this.thread.id());
            request.setArgument("handles", Arrays.asList(ref));
            request.setArgument("includeSource", Boolean.TRUE);
            CFResponsePacket response = this.crossfire().sendRequest(request);
            if (response.isSuccess()) {
                List list = (List)response.getBody().get("values");
                if (list != null && list.size() > 0) {
                    return this.createValue(list.get(0));
                }
            } else if (TRACE) {
                Tracing.writeString("STACKFRAME [request for value lookup failed]: " + JSON.serialize(request));
            }
        }
        return this.crossfire().mirrorOfNull();
    }

    Value createValue(Object val) {
        if (val instanceof Map) {
            Map values = (Map)val;
            String type = (String)values.get("type");
            if (type != null) {
                return this.createTypeValue(type, values);
            }
        } else {
            if (val instanceof String) {
                String str = (String)val;
                if ("undefined".equals(str)) {
                    return this.crossfire().mirrorOfUndefined();
                }
                return this.crossfire().mirrorOf((String)val);
            }
            if (val instanceof Number) {
                return this.crossfire().mirrorOf((Number)val);
            }
        }
        return this.crossfire().mirrorOfNull();
    }

    Value createTypeValue(String type, Map map) {
        if ("undefined".equals(type)) {
            return this.crossfire().mirrorOfUndefined();
        }
        if ("number".equals(type)) {
            Object o = map.get("value");
            if (o instanceof Number) {
                return this.crossfire().mirrorOf((Number)o);
            }
            if (o instanceof String) {
                return this.crossfire().mirrorOf((String)o);
            }
        }
        if ("string".equals(type)) {
            return this.crossfire().mirrorOf(map.get("value").toString());
        }
        if ("object".equals(type) || "ref".equals(type)) {
            return new CFObjectReference(this.crossfire(), this, map);
        }
        if ("array".equals(type)) {
            return new CFArrayReference(this.crossfire(), this, map);
        }
        if ("function".equals(type)) {
            return new CFFunctionReference(this.crossfire(), this, map);
        }
        return this.crossfire().mirrorOfNull();
    }

    public synchronized boolean isVisible(CFVariable variable) {
        return this.vars != null && (this.thisvar == variable || this.vars.contains(variable));
    }

    void allScopes() {
        CFRequestPacket request = new CFRequestPacket("scopes", this.thread.id());
        request.setArgument("frameIndex", new Integer(this.index));
        CFResponsePacket response = this.crossfire().sendRequest(request);
        if (response.isSuccess()) {
            List list = (List)response.getBody().get("scopes");
            if (list != null) {
                this.parseScopes(list);
            }
        } else if (TRACE) {
            Tracing.writeString("VM [failed scopes request]: " + JSON.serialize(request));
        }
    }

    void scope(int frameindex, int scopeindex) {
        CFRequestPacket request = new CFRequestPacket("scopes", this.thread.id());
        request.setArgument("frameIndex", new Integer(frameindex));
        request.setArgument("scopeIndexes", Arrays.asList(new Integer(scopeindex)));
        CFResponsePacket response = this.crossfire().sendRequest(request);
        if (response.isSuccess()) {
            List list;
            if (this.vars == null) {
                this.vars = new ArrayList();
            }
            if ((list = (List)response.getBody().get("scopes")) != null && list.size() > 0) {
                Map scope = (Map)list.get(0);
                this.vars.add(0, new CFVariable(this.crossfire(), this, "Enclosing Scope", (Number)scope.get("handle"), scope));
            }
        } else if (TRACE) {
            Tracing.writeString("VM [failed scopes request]: " + JSON.serialize(request));
        }
    }
}

