/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.views.logs.actions;

import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.views.logs.LogEventBean;
import org.fusesource.ide.fabric.views.logs.Logs;
import org.fusesource.ide.fabric.views.logs.LogsView;

public class OpenStackTraceAction
extends ActionSupport {
    private static final String NEW_LINE = System.getProperty("line.separator");
    LogsView view;
    JavaStackTraceConsole console;

    public OpenStackTraceAction(LogsView view, String text) {
        super(text, FabricPlugin.getDefault().getImageDescriptor("stckframe_obj.gif"));
        this.view = view;
        this.initConsole();
    }

    public void run() {
        LogEventBean event = this.view.getSelectedEvent();
        if (event == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        String[] lines = Logs.getThrowableRep(event);
        if (lines != null && lines.length > 0) {
            int i = 0;
            while (i < lines.length) {
                buf.append(lines[i]).append(NEW_LINE);
                ++i;
            }
        } else {
            String className = event.getClassName();
            String methodName = event.getMethodName();
            String fileName = event.getFileName();
            String lineNumber = event.getLineNumber();
            if (Strings.isBlank((String)className) || Strings.isBlank((String)methodName) || Strings.isBlank((String)fileName) || Strings.isBlank((String)lineNumber)) {
                return;
            }
            buf.append(event.getMessage()).append(NEW_LINE);
            buf.append("\tat " + className + "." + methodName + "(" + fileName + ":" + lineNumber + ")").append(NEW_LINE);
        }
        boolean stillRegistered = this.checkRegistration();
        if (!stillRegistered) {
            this.registerConsole();
        }
        this.console.clearConsole();
        this.console.getDocument().set(buf.toString());
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
    }

    private boolean checkRegistration() {
        IConsole[] consoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoleArray.length) {
            IConsole c = consoleArray[i];
            if (c == this.console) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void registerConsole() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    private void initConsole() {
        this.console = new JavaStackTraceConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }
}

