/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.views.logs;

import com.google.common.collect.Lists;
import io.fabric8.jolokia.facade.JolokiaFabricConnector;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.views.logs.ILogBrowser;
import org.fusesource.ide.fabric.views.logs.JsonHelper;
import org.fusesource.ide.fabric.views.logs.LogContext;
import org.fusesource.ide.fabric.views.logs.LogEventBean;
import org.fusesource.insight.log.LogEvent;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.LogResults;
import org.jolokia.client.J4pClient;

public abstract class LogBrowserSupport
implements ILogBrowser {
    private static final String INSIGHT_MBEAN_URL = "org.fusesource.insight:type=LogQuery";
    private static final String LOG_QUERY_OPERATION = "jsonQueryLogResults(java.lang.String)";
    private ObjectMapper mapper = new ObjectMapper();

    public LogBrowserSupport() {
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void queryLogs(LogContext context, boolean filterChanged) throws IOException {
        LogResults results;
        LogFilter logFilter = context.getLogFilter();
        String queryJson = JsonHelper.toJSON(this.mapper, logFilter);
        FabricPlugin.getLogger().debug("Query JSON: " + queryJson);
        String json = this.filterLogEvents(queryJson);
        FabricPlugin.getLogger().debug("===== JSON: " + json);
        ArrayList answer = Lists.newArrayList();
        if (json != null && !(json = json.trim()).equals("[]") && json.length() > 2 && (results = (LogResults)this.mapper.reader(LogResults.class).readValue(json)) != null) {
            List events;
            Long to = results.getToTimestamp();
            if (to != null) {
                logFilter.setAfterTimestamp(to);
            }
            if ((events = results.getEvents()) != null) {
                for (LogEvent event : events) {
                    if (event.getHost() == null) {
                        event.setHost(results.getHost());
                    }
                    answer.add(LogEventBean.toLogEventBean(event));
                }
            }
        }
        context.addLogResults(answer);
    }

    protected abstract String getJolokiaUser();

    protected abstract String getJolokiaPassword();

    protected abstract String getJolokiaUrl();

    private String filterLogEvents(String queryJSON) {
        String result = null;
        String jUser = this.getJolokiaUser();
        if (jUser.isEmpty()) {
            return "";
        }
        JolokiaFabricConnector connector = JolokiaFabricConnector.getFabricConnector((String)jUser, (String)this.getJolokiaPassword(), (String)this.getJolokiaUrl());
        result = Helpers.execCustomToJSON((J4pClient)connector.getJolokiaClient(), (String)INSIGHT_MBEAN_URL, (String)LOG_QUERY_OPERATION, (Object[])new Object[]{queryJSON});
        return result;
    }
}

