/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.views;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.fusesource.fon.util.messages.Exchanges;
import org.fusesource.fon.util.messages.IExchangeBrowser;
import org.fusesource.fon.util.messages.contenttype.MessagesNamespaceXmlContentDescriber;
import org.fusesource.ide.fabric.FabricPlugin;

public class ExchangeBrowsers {
    public static IExchangeBrowser getSelectedExchangeBrowser(ISelection selection) {
        IExchangeBrowser answer = null;
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            answer = ExchangeBrowsers.toIExchangeBrowser(input);
        }
        return answer;
    }

    public static IExchangeBrowser toIExchangeBrowser(Object input) {
        IExchangeBrowser answer = null;
        if (input instanceof IExchangeBrowser) {
            answer = (IExchangeBrowser)input;
        } else if (input != null) {
            answer = Exchanges.asExchangeList((Object)input);
            if (answer == null && input instanceof IFile) {
                IFile file = (IFile)input;
                try {
                    boolean messagesXml = MessagesNamespaceXmlContentDescriber.isXmlFormat((IFile)file);
                    if (messagesXml) {
                        answer = Exchanges.loadExchanges((Object)file, (InputStream)file.getContents());
                    }
                }
                catch (Exception e) {
                    FabricPlugin.getLogger().info("Failed to parse " + file + " as message exchange XML: " + e, (Throwable)e);
                }
            }
            if (answer == null) {
                answer = (IExchangeBrowser)Platform.getAdapterManager().getAdapter(input, IExchangeBrowser.class);
            }
        }
        return answer;
    }
}

