/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.navigator.osgi.CompositeDataPropertySource;

public class TabularDataHelper {
    public static List<IPropertySource> toPropertySources(TabularData tabularData) {
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        try {
            if (tabularData != null) {
                Collection<?> rows = tabularData.values();
                for (Object row : rows) {
                    if (row instanceof CompositeData) {
                        CompositeData cd = (CompositeData)row;
                        answer.add(new CompositeDataPropertySource(cd));
                        continue;
                    }
                    FabricPlugin.getLogger().debug("===== uknown row type: " + row + " of type " + Objects.typeName(row));
                }
            }
        }
        catch (Exception e) {
            FabricPlugin.getLogger().error("Failed to convert TabularData to List<IPropertySource>: " + e, (Throwable)e);
        }
        return answer;
    }
}

