/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator.osgi;

import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.TabularData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.navigator.osgi.OsgiFacade;
import org.fusesource.ide.fabric.navigator.osgi.ServicesTableSheetPage;
import org.fusesource.ide.fabric.navigator.osgi.TabularDataHelper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ServicesNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final OsgiFacade facade;

    public ServicesNode(Node parent, OsgiFacade facade) {
        super(parent);
        this.facade = facade;
    }

    public String toString() {
        return "Services";
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("container.png");
    }

    protected void loadChildren() {
    }

    public OsgiFacade getFacade() {
        return this.facade;
    }

    protected PropertySourceTableSheetPage createPropertySourceTableSheetPage() {
        return new ServicesTableSheetPage(this);
    }

    public List<IPropertySource> getPropertySourceList() {
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        try {
            TabularData tabularData = this.facade.listServices();
            return TabularDataHelper.toPropertySources(tabularData);
        }
        catch (Exception e) {
            FabricPlugin.getLogger().error("Failed to fetch bundle state: " + e, (Throwable)e);
            return answer;
        }
    }
}

