/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;
import org.fusesource.ide.commons.properties.ComplexPropertyDescriptor;
import org.fusesource.ide.commons.properties.ListPropertyDescriptor;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric.FabricPlugin;

public class CompositeDataPropertySource
implements IPropertySource {
    final CompositeData cd;
    private IPropertyDescriptor[] descriptors;
    private Set<String> keyNames = new HashSet<String>();
    private static Map<String, Class<?>> nameToClassIndex = new HashMap();

    static {
        CompositeDataPropertySource.addClasses(String.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class);
    }

    private static void addClasses(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aClass = classArray[n2];
            nameToClassIndex.put(aClass.getName(), aClass);
            ++n2;
        }
    }

    public CompositeDataPropertySource(CompositeData cd) {
        this.cd = cd;
        ArrayList<ListPropertyDescriptor> properties = new ArrayList<ListPropertyDescriptor>();
        CompositeType compositeType = cd.getCompositeType();
        Set<String> keys = compositeType.keySet();
        for (String key : keys) {
            Class<?> aClass;
            String keyText = key.toString();
            this.keyNames.add(keyText);
            OpenType<?> type = compositeType.getType(keyText);
            if (type == null) continue;
            String className = type.getClassName();
            Object descriptor = type.isArray() ? new ListPropertyDescriptor((Object)key, keyText) : (className.equals("java.lang.String") ? new TextPropertyDescriptor((Object)key, keyText) : (className.equals("java.lang.Boolean") ? new BooleanPropertyDescriptor((Object)key, keyText) : ((aClass = nameToClassIndex.get(className)) != null ? new ComplexPropertyDescriptor((Object)key, keyText, aClass) : new PropertyDescriptor((Object)key, keyText))));
            properties.add((ListPropertyDescriptor)descriptor);
        }
        this.descriptors = properties.toArray(new IPropertyDescriptor[properties.size()]);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        String idText = Strings.getOrElse((Object)id);
        if (!this.keyNames.contains(idText)) {
            FabricPlugin.getLogger().error("Error: No such key " + idText + " on " + this + " with keys: " + this.keyNames);
            return null;
        }
        Object answer = this.cd.get(idText);
        if (answer instanceof Object[]) {
            return Arrays.asList((Object[])answer);
        }
        return answer;
    }

    public boolean isPropertySet(Object id) {
        Object value = this.getPropertyValue(id);
        return value != null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

