/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator.jmx;

import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.RefreshableNode;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.jmx.JmxNode;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.providers.DefaultConnectionProvider;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.ui.ImageProvider;

public class FabricConnectionWrapper
extends RefreshableNode
implements ImageProvider,
IConnectionWrapper,
HasRefreshableUI {
    private final ContainerNode agentNode;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private Root root;
    private boolean isConnected;

    public FabricConnectionWrapper(ContainerNode agentNode) {
        super((Node)agentNode);
        this.agentNode = agentNode;
        String jmxUrl = agentNode.getContainer().getJmxUrl();
        this.isConnected = !Strings.isBlank((String)jmxUrl);
    }

    public String toString() {
        return "JMX";
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.tools.jmx.core.providers.DefaultConnectionProvider");
    }

    public boolean canControl() {
        return true;
    }

    public RefreshableUI getRefreshableUI() {
        return this.agentNode.getRefreshableUI();
    }

    public synchronized void connect() throws IOException {
        this.isConnected = true;
        this.fireConnectionChanged();
        this.refresh();
    }

    public synchronized void disconnect() throws IOException {
        this.root = null;
        this.isConnected = false;
        this.connector = null;
        this.connection = null;
        this.clearChildren();
        this.fireConnectionChanged();
        this.refresh();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public Root getRoot() {
        return this.root;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("releng_gears.gif");
    }

    public void loadRoot() {
        if (this.isConnected && this.root == null) {
            try {
                this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                this.root = new Root((IConnectionWrapper)this);
            }
        }
    }

    protected void loadChildren() {
        this.root = null;
        this.loadChildren((Node)this);
    }

    public void loadChildren(Node parent) {
        this.loadRoot();
        System.err.println("FabricConnectionWrapper:loadChildren(Node)...root == null ? " + (this.root == null));
        if (this.root != null) {
            Node[] children;
            Node[] nodeArray = children = this.root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                parent.addChild(node);
                ++n2;
            }
        }
    }

    public void loadChildren(JmxNode jmxNode) {
        this.loadRoot();
    }

    protected void fireConnectionChanged() {
        DefaultConnectionProvider provider = (DefaultConnectionProvider)this.getProvider();
        provider.fireChanged((IConnectionWrapper)this);
    }

    public void run(IJMXRunnable runnable) throws JMXException {
    }

    public void loadRoot(IProgressMonitor monitor) throws CoreException {
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
    }
}

