/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator.cloud;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.commons.ui.actions.SeparatorFactory;
import org.fusesource.ide.commons.ui.actions.ToggleAction;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.jclouds.JClouds;
import org.fusesource.ide.fabric.navigator.cloud.CloudNode;
import org.fusesource.ide.fabric.navigator.cloud.NodeTable;
import org.fusesource.ide.server.view.ITerminalConnectionListener;
import org.fusesource.ide.server.view.SshView;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;

public class NodeTabSection
extends TableViewSupport {
    public static final Joiner spaceJoiner = Joiner.on((String)" ");
    protected static final String VIEW_ID = NodeTable.class.getName();
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(VIEW_ID);
    private CloudNode current;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private Separator separator3 = separatorFactory.createSeparator();
    private ToggleAction suspendResumeAction = new ToggleAction();
    private Action suspendAction;
    private Action resumeAction;
    private Action rebootAction;
    private Action destroyAction;
    private ActionSupport addAction;
    private ActionSupport openTerminalAction;
    private Set<String> selectedIds;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        CloudNode node = (CloudNode)((Object)Selections.getFirstSelection((ISelection)selection));
        if (node == this.current) {
            return;
        }
        this.current = node;
        WritableList nodes = node.getNodes();
        this.setInput(nodes);
        this.getViewer().setInput((Object)nodes);
        this.getViewer().refresh(true);
    }

    public ComputeService getComputeService() {
        return this.current.getComputeService();
    }

    protected void createColumns() {
        this.clearColumns();
        int bounds = 150;
        int column = 0;
        Object function = new Function1(){

            public Object apply(Object element) {
                ComputeMetadata value = JClouds.asComputeMetadata(element);
                if (value != null) {
                    return value.getId();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Id");
        function = new Function1(){

            public Object apply(Object element) {
                ComputeMetadata value = JClouds.asComputeMetadata(element);
                if (value != null) {
                    return value.getName();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Name");
        function = new Function1(){

            public Object apply(Object element) {
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null) {
                    return value.getStatus();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "State");
        function = new Function1(){

            public Object apply(Object element) {
                Hardware hardware;
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null && (hardware = value.getHardware()) != null) {
                    return JClouds.text(hardware);
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Hardware");
        function = new Function1(){

            public Object apply(Object element) {
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null) {
                    return value.getImageId();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Image");
        function = new Function1(){

            public Object apply(Object element) {
                OperatingSystem operatingSystem;
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null && (operatingSystem = value.getOperatingSystem()) != null) {
                    return JClouds.text(operatingSystem);
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "OS");
        function = new Function1(){

            public Object apply(Object element) {
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null) {
                    return value.getGroup();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Group");
        function = new Function1(){

            public Object apply(Object element) {
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null) {
                    return NodeTabSection.this.joinSpaces(value.getPublicAddresses());
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Public IPs");
        function = new Function1(){

            public Object apply(Object element) {
                NodeMetadata value = JClouds.asNodeMetadata(element);
                if (value != null) {
                    return NodeTabSection.this.joinSpaces(value.getPrivateAddresses());
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Private IPs");
        function = new Function1(){

            public Object apply(Object element) {
                Location value = JClouds.asLocation(element);
                if (value != null) {
                    return value.getDescription();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Location");
        function = new Function1(){

            public Object apply(Object element) {
                ComputeMetadata value = JClouds.asComputeMetadata(element);
                if (value != null) {
                    return value.getUri();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "URI");
        function = new Function1(){

            public Object apply(Object element) {
                ComputeMetadata value = JClouds.asComputeMetadata(element);
                if (value != null) {
                    return NodeTabSection.this.joinSpaces(value.getTags());
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Tags");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NodeTabSection.this.selectionUpdated();
            }
        });
        this.addAction = new ActionSupport(Messages.jcloud_addNodeButton, Messages.jcloud_addNodeButtonTooktip, FabricPlugin.getPlugin().getImageDescriptor("add_obj.gif")){

            public void run() {
            }
        };
        this.openTerminalAction = new ActionSupport(Messages.jcloud_openTerminalLabel, Messages.jcloud_openTerminalTooltip, FabricPlugin.getPlugin().getImageDescriptor("terminal_view.gif")){

            public void run() {
                NodeTabSection.this.openTerminal();
            }
        };
        this.suspendAction = new ActionSupport(Messages.jcloud_suspendNodeButton, Messages.jcloud_suspendNodeButtonTooktip, FabricPlugin.getPlugin().getImageDescriptor("stop_task.gif")){

            public void run() {
                final List<ComputeMetadata> selectedNodes = NodeTabSection.this.getSelectedNodes();
                String message = NodeTabSection.this.makeNodesString(selectedNodes, "Suspending ", "");
                Jobs.schedule((String)message, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NodeTabSection.this.foreachNode(selectedNodes, "Suspend node failed", new Function<ComputeMetadata, Void>(){

                            public Void apply(ComputeMetadata node) {
                                String id = JClouds.id(node);
                                if (id != null) {
                                    NodeTabSection.this.getComputeService().suspendNode(id);
                                }
                                return null;
                            }
                        });
                        NodeTabSection.this.asyncReload();
                    }
                });
            }
        };
        this.resumeAction = new ActionSupport(Messages.jcloud_resumeNodeButton, Messages.jcloud_resumeNodeButtonTooktip, FabricPlugin.getPlugin().getImageDescriptor("start_task.gif")){

            public void run() {
                final List<ComputeMetadata> selectedNodes = NodeTabSection.this.getSelectedNodes();
                String message = NodeTabSection.this.makeNodesString(selectedNodes, "Resuming ", "");
                Jobs.schedule((String)message, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NodeTabSection.this.foreachNode(selectedNodes, "Resume node failed", new Function<ComputeMetadata, Void>(){

                            public Void apply(ComputeMetadata node) {
                                String id = JClouds.id(node);
                                if (id != null) {
                                    NodeTabSection.this.getComputeService().resumeNode(id);
                                }
                                return null;
                            }
                        });
                        NodeTabSection.this.asyncReload();
                    }
                });
            }
        };
        this.rebootAction = new ActionSupport(Messages.jcloud_rebootNodeButton, Messages.jcloud_rebootNodeButtonTooktip, FabricPlugin.getPlugin().getImageDescriptor("restart_task.gif")){

            public void run() {
                final List<ComputeMetadata> selectedNodes = NodeTabSection.this.getSelectedNodes();
                String message = NodeTabSection.this.makeNodesString(selectedNodes, "Rebooting ", "");
                Jobs.schedule((String)message, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NodeTabSection.this.foreachNode(selectedNodes, "Reboot node failed", new Function<ComputeMetadata, Void>(){

                            public Void apply(ComputeMetadata node) {
                                String id = JClouds.id(node);
                                if (id != null) {
                                    NodeTabSection.this.getComputeService().rebootNode(id);
                                }
                                return null;
                            }
                        });
                        NodeTabSection.this.asyncReload();
                    }
                });
            }
        };
        this.destroyAction = new ActionSupport(Messages.jcloud_destroyNodeButton, Messages.jcloud_destroyNodeButtonTooktip, FabricPlugin.getPlugin().getImageDescriptor("delete.gif")){

            public void run() {
                final List<ComputeMetadata> selectedNodes = NodeTabSection.this.getSelectedNodes();
                if (!selectedNodes.isEmpty()) {
                    String message = NodeTabSection.this.makeNodesString(selectedNodes, "Destroy ", "?");
                    boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)"Delete Compute Nodes", (String)message);
                    if (confirm) {
                        Jobs.schedule((String)NodeTabSection.this.makeNodesString(selectedNodes, "Destroying ", ""), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NodeTabSection.this.foreachNode(selectedNodes, "Destroy node failed", new Function<ComputeMetadata, Void>(){

                                    public Void apply(ComputeMetadata node) {
                                        String id = JClouds.id(node);
                                        if (id != null) {
                                            NodeTabSection.this.getComputeService().destroyNode(id);
                                        }
                                        return null;
                                    }
                                });
                                NodeTabSection.this.asyncReload();
                            }
                        });
                    }
                }
            }
        };
        this.suspendResumeAction.setCurrentAction(this.suspendAction);
        this.selectionUpdated();
        this.addLocalMenuActions(new Object[]{this.separator1, this.openTerminalAction, this.separator2, this.suspendAction, this.resumeAction, this.rebootAction, this.separator3, this.destroyAction});
        this.addToolBarActions(new Object[]{this.openTerminalAction, this.suspendAction, this.resumeAction, this.rebootAction, this.destroyAction});
        this.setDoubleClickAction((Action)this.openTerminalAction);
    }

    protected void foreachSelectedNode(String title, Function<ComputeMetadata, Void> function) {
        List<ComputeMetadata> selectedNodes = this.getSelectedNodes();
        this.foreachNode(selectedNodes, title, function);
    }

    protected void foreachNode(List<ComputeMetadata> selectedNodes, String title, Function<ComputeMetadata, Void> function) {
        for (ComputeMetadata md : selectedNodes) {
            if (md == null) continue;
            try {
                function.apply((Object)md);
            }
            catch (Exception e) {
                FabricPlugin.showUserError(title, e.getMessage(), e);
                break;
            }
        }
    }

    protected void configureViewer() {
        this.setInput(this.getNodes());
    }

    public WritableList getNodes() {
        return this.current == null ? WritableList.withElementType(ComputeMetadata.class) : this.current.getNodes();
    }

    public void refresh() {
        if (this.current != null) {
            this.current.reloadNodes();
        }
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected String getHelpID() {
        return NodeTable.class.getName();
    }

    public String getColumnConfigurationId() {
        return NodeTable.class.getName();
    }

    public ComputeMetadata getSelectedNode() {
        return JClouds.asComputeMetadata(Selections.getFirstSelection((Viewer)this.getViewer()));
    }

    public List<ComputeMetadata> getSelectedNodes() {
        List list = Selections.getSelectionList((Viewer)this.getViewer());
        ArrayList<ComputeMetadata> answer = new ArrayList<ComputeMetadata>();
        for (Object object : list) {
            ComputeMetadata metadata = JClouds.asComputeMetadata(object);
            if (metadata == null) continue;
            answer.add(metadata);
        }
        return answer;
    }

    public Set<String> getSelectedStates() {
        HashSet<String> answer = new HashSet<String>();
        List list = Selections.getSelectionList((Viewer)this.getViewer());
        for (Object object : list) {
            NodeMetadata.Status state;
            NodeMetadata value = JClouds.asNodeMetadata(object);
            if (value == null || (state = (NodeMetadata.Status)value.getStatus()) == null) continue;
            answer.add(state.toString());
        }
        return answer;
    }

    protected void selectionUpdated() {
        ComputeMetadata n = this.getSelectedNode();
        boolean selected = n != null;
        List<ComputeMetadata> selectedNodes = this.getSelectedNodes();
        if (!this.getNodes().isEmpty()) {
            HashSet<String> idSet = new HashSet<String>();
            for (ComputeMetadata node : selectedNodes) {
                String id = node.getId();
                if (id == null) continue;
                idSet.add(id);
            }
            this.selectedIds = idSet;
        }
        if (selected) {
            NodeMetadata.Status state = JClouds.getState(n);
            Action action = this.suspendAction;
            if (state != NodeMetadata.Status.RUNNING) {
                action = this.resumeAction;
            }
            this.suspendResumeAction.setCurrentAction(action);
        }
        this.openTerminalAction.setEnabled(selectedNodes.size() == 1 && this.selectedStatesOnly("RUNNING"));
        this.suspendAction.setEnabled(this.selectedStatesOnly("RUNNING"));
        this.resumeAction.setEnabled(this.selectedStatesOnly("SUSPENDED"));
        this.rebootAction.setEnabled(selected);
        this.destroyAction.setEnabled(selectedNodes.size() > 0 && !this.getSelectedStates().contains("TERMINATED"));
    }

    protected void refreshViewerOnChange() {
        super.refreshViewerOnChange();
        if (this.selectedIds != null) {
            ArrayList selected = new ArrayList();
            WritableList nodes = this.getNodes();
            for (Object object : nodes) {
                String id;
                ComputeMetadata md = JClouds.asComputeMetadata(object);
                if (md == null || !this.selectedIds.contains(id = md.getId())) continue;
                selected.add(object);
            }
            if (!selected.isEmpty()) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(selected));
            }
        }
    }

    protected boolean selectedStatesOnly(String state) {
        Set<String> selectedStates = this.getSelectedStates();
        return selectedStates.size() == 1 && selectedStates.contains(state);
    }

    public Object joinSpaces(Set<String> tags) {
        if (tags != null) {
            return spaceJoiner.join(new TreeSet<String>(tags));
        }
        return null;
    }

    protected void openTerminal() {
        IViewPart vp;
        ArrayList publicAddresses;
        String id = ((Object)((Object)this)).getClass().getName();
        ComputeMetadata computeNode = this.getSelectedNode();
        if (!(computeNode instanceof NodeMetadata)) {
            return;
        }
        NodeMetadata node = (NodeMetadata)computeNode;
        String host = node.getHostname();
        Set addressSet = node.getPublicAddresses();
        if (addressSet != null && (publicAddresses = new ArrayList(addressSet)).size() > 0) {
            host = (String)publicAddresses.get(0);
        }
        int port = node.getLoginPort();
        LoginCredentials credentials = node.getCredentials();
        String user = "admin";
        String password = null;
        if (credentials != null) {
            user = credentials.getUser();
            password = credentials.getPassword();
        }
        if ((vp = FabricPlugin.openTerminalView()) == null || !(vp instanceof SshView)) {
            FabricPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        final SshView connectorView = (SshView)vp;
        connectorView.setPartName(id);
        connectorView.addConnectionListener(new ITerminalConnectionListener(){

            public void onDisconnect() {
            }

            public void onConnect() {
                connectorView.setFocus();
            }
        });
        try {
            FabricPlugin.getLogger().debug("Creating the connection if it doesn't exist for host: " + host + " port " + port + " user " + user);
            connectorView.createConnectionIfNotExists(host, port, user, password);
        }
        catch (Exception ex) {
            FabricPlugin.getLogger().error("Unable to connect via SSH", (Throwable)ex);
        }
    }

    protected String makeNodesString(List<ComputeMetadata> selectedNodes, String prefix, String postfix) {
        boolean first = true;
        StringBuilder builder = new StringBuilder(prefix);
        for (ComputeMetadata node : selectedNodes) {
            if (first) {
                first = false;
            } else {
                builder.append(",\n");
            }
            builder.append(node.getId());
        }
        builder.append(postfix);
        String message = builder.toString();
        return message;
    }

    protected void asyncReload() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                NodeTabSection.this.refresh();
            }
        });
    }
}

