/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import io.fabric8.api.Version;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.CreateVersionAction;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric.navigator.VersionNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class VersionsNode
extends FabricNodeSupport
implements ImageProvider,
ContextMenuProvider {
    private Map<String, VersionNode> map = new HashMap<String, VersionNode>();

    public VersionsNode(Fabric fabric) {
        super((Node)fabric, fabric);
    }

    public String toString() {
        return "Versions";
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("version_folder.png");
    }

    protected void loadChildren() {
        this.map.clear();
        Version[] versions = this.getFabric().getFabricService().getVersions();
        if (versions != null) {
            Version[] versionArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                Version version = versionArray[n2];
                VersionNode node = new VersionNode(this, version);
                this.map.put(node.getVersionId(), node);
                this.addChild((Node)node);
                ++n2;
            }
        }
    }

    public VersionNode getVersionNode(String version) {
        return this.map.get(version);
    }

    public VersionNode getDefaultVersionNode() {
        this.checkLoaded();
        List childrenList = this.getChildrenList();
        for (Node node : childrenList) {
            if (!(node instanceof VersionNode)) continue;
            VersionNode answer = (VersionNode)node;
            answer.getChildren();
            return answer;
        }
        return null;
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new CreateVersionAction(this));
    }
}

