/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.Messages;
import org.fusesource.ide.fabric.actions.ProfileTreeSelectionFormSupport;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import scala.actors.threadpool.Arrays;

public class ProfileTreeForm
extends ProfileTreeSelectionFormSupport {
    private final ContainerNode node;
    private boolean selectionChanged = false;

    public ProfileTreeForm(ContainerNode node) {
        this.node = node;
        this.selectionChanged = false;
    }

    public void setFocus() {
        this.getProfilesViewer().getControl().setFocus();
    }

    protected void createTextFields(Composite parent) {
        Composite outer = this.createSectionComposite(Messages.profilesForm_header, new GridData(1808));
        GridLayout layout = new GridLayout();
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        outer.setLayout((Layout)layout);
        this.createColumnsViewer(outer);
        this.createButtons(parent);
        this.setProfilesViewerInput((Object)this.node.getVersionNode());
        Profile[] profiles = this.node.getContainer().getProfiles();
        this.setCheckedProfiles(profiles);
        this.getProfilesViewer().getTree().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (ProfileTreeForm.this.selectionChanged) {
                    if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.confirmProfileSelectionChangesTitle, (String)Messages.confirmProfileSelectionChangesText)) {
                        if (ProfileTreeForm.this.isValid()) {
                            ProfileTreeForm.this.okPressed();
                        }
                    } else {
                        ProfileTreeForm.this.getProfilesViewer().getTree().deselectAll();
                        ProfileTreeForm.this.setProfilesViewerInput((Object)ProfileTreeForm.this.node.getVersionNode());
                        Profile[] profiles = ProfileTreeForm.this.node.getContainer().getProfiles();
                        ProfileTreeForm.this.setCheckedProfiles(profiles);
                        ProfileTreeForm.this.getProfilesViewer().refresh();
                    }
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    @Override
    protected void onProfileSelectionChanged() {
        super.onProfileSelectionChanged();
        this.selectionChanged = true;
    }

    public void okPressed() {
        Object[] profiles = this.getSelectedProfileArray();
        Container agent = this.node.getContainer();
        FabricPlugin.getLogger().debug("Updating the profiles of " + agent + " to: " + Arrays.asList((Object[])profiles));
        agent.setProfiles((Profile[])profiles);
        this.node.refresh();
        this.selectionChanged = false;
    }

    @Override
    protected Composite createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        button.setLayoutData((Object)gridData);
    }
}

