/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.ProfileTreeSelectionFormSupport;
import org.fusesource.ide.fabric.navigator.ProfileNode;
import org.fusesource.ide.fabric.navigator.ProfileParentsContentProvider;
import org.fusesource.ide.fabric.navigator.ProfilesFormSupport;

public class ProfileRequirementsForm
extends ProfilesFormSupport {
    private final ProfileNode node;
    private RequirementsBean formModel = new RequirementsBean();
    private Text minInstances;
    private Text maxInstances;
    private ProfileRequirements pReqs;
    private IObservableValue minInstancesTextObservable;
    private IObservableValue minInstancesModelObservable;
    private IObservableValue maxInstancesTextObservable;
    private IObservableValue maxInstancesModelObservable;
    private Binding minInstancesBinding;
    private Binding maxInstancesBinding;
    private PropertyChangeListener modelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProfileRequirementsForm.this.saveRequirements();
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }

        public void focusGained(FocusEvent e) {
            ProfileRequirementsForm.this.minInstancesBinding.validateTargetToModel();
            ProfileRequirementsForm.this.maxInstancesBinding.validateTargetToModel();
        }
    };
    ProfileTreeSelectionFormSupport parentsForm = new ProfileTreeSelectionFormSupport(){

        public void setFocus() {
            this.getProfilesViewer().getControl().setFocus();
        }

        protected void createTextFields(Composite parent) {
        }

        @Override
        protected void onProfileSelectionChanged() {
            super.onProfileSelectionChanged();
            this.okPressed();
        }

        public void okPressed() {
            Profile[] profiles = this.getSelectedProfileArray();
            ProfileRequirementsForm.this.node.getProfile().setParents(profiles);
        }

        public FormToolkit getToolkit() {
            return ProfileRequirementsForm.this.getToolkit();
        }
    };

    public ProfileRequirementsForm(ProfileNode node) {
        this.node = node;
    }

    private void saveRequirements() {
        FabricRequirements reqs = this.node.getFabric().getFabricService().getRequirements();
        try {
            if (this.formModel.getMinInstances() == null && this.formModel.getMaxInstances() == null && this.formModel.getDependencies().size() == 0) {
                if (reqs.findProfileRequirements(this.node.getProfile().getId()) == null) {
                    return;
                }
                reqs.removeProfileRequirements(this.node.getProfile().getId());
                return;
            }
            this.pReqs = reqs.getOrCreateProfileRequirement(this.node.getProfile().getId());
            this.pReqs.setMinimumInstances(this.formModel.getMinInstances());
            this.pReqs.setMaximumInstances(this.formModel.getMaxInstances());
            ArrayList<String> profileDepList = new ArrayList<String>();
            for (Profile p : this.formModel.getDependencies()) {
                profileDepList.add(p.getId());
            }
            this.pReqs.setDependentProfiles(profileDepList);
            reqs.addOrUpdateProfileRequirements(this.pReqs);
        }
        finally {
            try {
                this.node.getFabric().getFabricService().setRequirements(reqs);
            }
            catch (IOException ex) {
                FabricPlugin.getLogger().error((Throwable)ex);
            }
        }
    }

    protected void createTextFields(Composite parent) {
        Profile profile = this.node.getProfile();
        String sectionTitle = profile.getId();
        Composite inner = this.createSectionComposite(sectionTitle, new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, "Minimum Instances");
        GridData data = new GridData(16384, 128, true, false, 2, 1);
        data.minimumWidth = 60;
        this.minInstances = this.createText(inner, 133120);
        this.minInstances.setLayoutData((Object)data);
        this.minInstances.addFocusListener(this.focusListener);
        this.createLabel(inner, "Maximum Instances");
        data = new GridData(16384, 128, true, false, 2, 1);
        data.minimumWidth = 60;
        this.maxInstances = this.createText(inner, 133120);
        this.maxInstances.setLayoutData((Object)data);
        this.maxInstances.addFocusListener(this.focusListener);
        this.createLabel(inner, "Dependencies");
        this.parentsForm.createColumnsViewer(inner);
        this.parentsForm.setProfilesViewerInput((Object)this.node.getVersionNode());
        this.parentsForm.getProfilesViewer().setContentProvider((IContentProvider)new ProfileParentsContentProvider(this.node));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.parentsForm.getProfilesViewer().getTree().setLayoutData((Object)gridData);
        this.parentsForm.getProfilesViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileRequirementsForm.this.processDependenciesChange(Selections.getSelectionList((Viewer)ProfileRequirementsForm.this.parentsForm.getProfilesViewer()));
            }
        });
        this.createLabel(inner, "");
        Button clearSelectionBtn = new Button(inner, 2056);
        data = new GridData(16384, 128, true, false, 2, 1);
        clearSelectionBtn.setLayoutData((Object)data);
        clearSelectionBtn.setText("Deselect All");
        clearSelectionBtn.setToolTipText("Clears the selection...");
        clearSelectionBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfileRequirementsForm.this.parentsForm.getProfilesViewer().setSelection((ISelection)new StructuredSelection());
                Viewers.refreshAsync((Viewer)ProfileRequirementsForm.this.parentsForm.getProfilesViewer());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.bindValues();
        this.init();
        this.formModel.addPropertyChangeListener("minInstances", this.modelListener);
        this.formModel.addPropertyChangeListener("maxInstances", this.modelListener);
        this.formModel.addPropertyChangeListener("dependencies", this.modelListener);
    }

    private void processDependenciesChange(List dependencies) {
        this.formModel.clearDependencies();
        for (Object o : dependencies) {
            ProfileNode p = (ProfileNode)((Object)o);
            this.formModel.addDependency(p.getProfile());
        }
    }

    private void init() {
        FabricRequirements reqs = this.node.getFabric().getFabricService().getRequirements();
        this.pReqs = reqs.findProfileRequirements(this.node.getProfile().getId());
        if (this.pReqs != null) {
            this.formModel.setMinInstances(this.pReqs.getMinimumInstances());
            this.formModel.setMaxInstances(this.pReqs.getMaximumInstances());
            for (String pId : this.pReqs.getDependentProfiles()) {
                Profile p = this.node.getFabric().getFabricService().getProfile(this.node.getVersionNode().getVersionId(), pId);
                this.formModel.addDependency(p);
            }
        }
        this.parentsForm.setCheckedProfiles(this.formModel.getDependencies().toArray(new Profile[this.formModel.getDependencies().size()]));
    }

    private void bindValues() {
        DataBindingContext ctx = new DataBindingContext();
        this.minInstancesTextObservable = WidgetProperties.text((int)24).observe((Widget)this.minInstances);
        this.minInstancesModelObservable = BeanProperties.value((String)"minInstances").observe((Object)this.formModel);
        this.maxInstancesTextObservable = WidgetProperties.text((int)24).observe((Widget)this.maxInstances);
        this.maxInstancesModelObservable = BeanProperties.value((String)"maxInstances").observe((Object)this.formModel);
        IValidator optionalNumbersOnlyValidator = new IValidator(){

            public IStatus validate(Object value) {
                String s = String.valueOf(value);
                if (s.trim().length() < 1) {
                    return ValidationStatus.ok();
                }
                if (s.matches("\\d*")) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.error((String)"Please enter a valid number of instances...");
            }
        };
        IValidator instancesValidator = new IValidator(){

            public IStatus validate(Object value) {
                Integer max;
                String smin = (String)ProfileRequirementsForm.this.minInstancesTextObservable.getValue();
                String smax = (String)ProfileRequirementsForm.this.maxInstancesTextObservable.getValue();
                Integer min = smin.trim().length() > 0 ? Integer.valueOf(Integer.parseInt(smin)) : null;
                Integer n = max = smax.trim().length() > 0 ? Integer.valueOf(Integer.parseInt(smax)) : null;
                if (min != null && max != null && min > max) {
                    return ValidationStatus.error((String)"The maximum instances count can't be lower than the minimum count!");
                }
                return ValidationStatus.ok();
            }
        };
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE);
        targetToModel.setAfterGetValidator(optionalNumbersOnlyValidator);
        targetToModel.setBeforeSetValidator(instancesValidator);
        targetToModel.setConverter(new IConverter(){

            public Object getToType() {
                return new Integer(-1);
            }

            public Object getFromType() {
                return new String();
            }

            public Object convert(Object fromObject) {
                String s;
                if (fromObject instanceof String && (s = (String)fromObject).trim().length() > 0) {
                    try {
                        return Integer.parseInt(s);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return null;
            }
        });
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        this.minInstancesBinding = ctx.bindValue(this.minInstancesTextObservable, this.minInstancesModelObservable, targetToModel, modelToTarget);
        ControlDecorationSupport.create((ValidationStatusProvider)this.minInstancesBinding, (int)131200);
        this.maxInstancesBinding = ctx.bindValue(this.maxInstancesTextObservable, this.maxInstancesModelObservable, targetToModel, modelToTarget);
        ControlDecorationSupport.create((ValidationStatusProvider)this.maxInstancesBinding, (int)131200);
    }

    protected Label createLabel(Composite inner, String text) {
        Label label = super.createLabel(inner, text);
        GridData data = new GridData(2);
        label.setLayoutData((Object)data);
        return label;
    }

    @Override
    public void setFocus() {
        this.minInstances.setFocus();
    }

    private class RequirementsBean
    implements PropertyChangeListener {
        private Integer minInstances;
        private Integer maxInstances;
        private List<Profile> dependencies = new ArrayList<Profile>();
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public Integer getMinInstances() {
            return this.minInstances;
        }

        public void setMinInstances(Integer minInstances) {
            this.minInstances = minInstances;
            this.propertyChangeSupport.firePropertyChange("minInstances", this.minInstances, this.minInstances);
        }

        public Integer getMaxInstances() {
            return this.maxInstances;
        }

        public void setMaxInstances(Integer maxInstances) {
            this.maxInstances = maxInstances;
            this.propertyChangeSupport.firePropertyChange("maxInstances", this.maxInstances, this.maxInstances);
        }

        public List<Profile> getDependencies() {
            return this.dependencies;
        }

        public void clearDependencies() {
            this.dependencies.clear();
            this.propertyChangeSupport.firePropertyChange("dependencies", null, this.dependencies);
        }

        public void addDependency(Profile p) {
            if (this.dependencies.contains(p)) {
                return;
            }
            this.dependencies.add(p);
            this.propertyChangeSupport.firePropertyChange("dependencies", null, this.dependencies);
        }

        public void removeDependency(Profile p) {
            if (!this.dependencies.contains(p)) {
                return;
            }
            this.dependencies.remove(p);
            this.propertyChangeSupport.firePropertyChange("dependencies", null, this.dependencies);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChangeSupport.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

