/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import io.fabric8.api.Profile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.properties.PropertySources;
import org.fusesource.ide.commons.tree.GraphableNode;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.drop.DropHandler;
import org.fusesource.ide.commons.ui.drop.DropHandlerFactory;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.ProfileAddAction;
import org.fusesource.ide.fabric.actions.ProfileDeleteAction;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.IdBasedFabricNode;
import org.fusesource.ide.fabric.navigator.ProfileBean;
import org.fusesource.ide.fabric.navigator.ProfileTabViewPage;
import org.fusesource.ide.fabric.navigator.VersionNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ProfileNode
extends IdBasedFabricNode
implements HasRefreshableUI,
ImageProvider,
GraphableNode,
ContextMenuProvider,
DropHandlerFactory {
    private static final String AGENT_PID = "io.fabric8.agent";
    private static final boolean addContainersToTree = false;
    private Map<String, ProfileNode> map = new HashMap<String, ProfileNode>();
    private final Fabric fabric;
    private final Profile profile;
    private final VersionNode versionNode;

    public ProfileNode getProfileNode(String profileId) {
        this.checkLoaded();
        ProfileNode answer = this.map.get(profileId);
        if (answer == null) {
            answer = ProfileNode.getProfileNode(profileId, this.getProfileChildren());
        }
        return answer;
    }

    public ProfileNode(VersionNode versionNode, Node parent, Profile profile) {
        super(parent, versionNode.getFabric(), profile.getId());
        this.versionNode = versionNode;
        this.fabric = versionNode.getFabric();
        this.profile = profile;
        this.setPropertyBean((Object)new ProfileBean(profile));
    }

    public ProfileNode(VersionNode parent, Profile profile) {
        this(parent, (Node)parent, profile);
    }

    public List<Node> getChildrenGraph() {
        HashSet answer = new HashSet();
        answer.addAll(this.getChildrenList());
        return new ArrayList<Node>(answer);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new ProfileTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        this.checkLoaded();
        this.getVersionNode().getChildren();
        return false;
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("profile.png");
    }

    protected void loadChildren() {
        Set<Profile> childProfiles = this.versionNode.getChildProfiles(this.getProfileId());
        if (childProfiles != null) {
            for (Profile profile : childProfiles) {
                this.addChild((Node)this.versionNode.createProfile((Node)this, profile));
            }
        }
    }

    public List<ContainerNode> getContainerNodes() {
        return this.getFabric().getAgentsFor(this.getProfile());
    }

    public static ProfileNode getProfileNode(String profileId, ProfileNode[] children) {
        ProfileNode answer = null;
        ProfileNode[] profileNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileNode child = profileNodeArray[n2];
            answer = child.getProfileNode(profileId);
            if (answer != null) {
                return answer;
            }
            ++n2;
        }
        return answer;
    }

    public ProfileNode[] getProfileChildren() {
        return (ProfileNode[])Objects.getArrayOf((Collection)this.getChildrenList(), ProfileNode.class);
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return null;
    }

    @Override
    public Fabric getFabric() {
        return this.fabric;
    }

    public String getMavenDeployParameter() {
        Fabric theFabric = this.getFabric();
        URI u = theFabric.getFabricService().getMavenRepoUploadURI();
        try {
            String uriText;
            boolean addUserPasswordToUrl = false;
            if (addUserPasswordToUrl) {
                String userInfo = String.valueOf(theFabric.getUserName()) + ":" + theFabric.getPassword();
                URI mavenRepoURI = new URI(u.getScheme(), userInfo, u.getHost(), u.getPort(), u.getPath(), u.getQuery(), u.getFragment());
                uriText = mavenRepoURI.toString();
            } else {
                uriText = u.toString();
            }
            FabricPlugin.getLogger().debug("===== deploying to the mavenRepoURL: " + uriText + " based on the URI from Fabric: " + u);
            return String.valueOf(this.getFabricNameWithoutSpaces()) + "::default::" + uriText;
        }
        catch (URISyntaxException e) {
            FabricPlugin.getLogger().error("Failed to create upload URI from " + u + ". Reason: " + e, (Throwable)e);
            return null;
        }
    }

    public String getFabricNameWithoutSpaces() {
        return this.getFabric().getName().replace(' ', '_');
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getProfileId() {
        return this.profile.getId();
    }

    public VersionNode getVersionNode() {
        return this.versionNode;
    }

    public void addAndDescendants(Set<Node> answer) {
        answer.add((Node)this);
        Node p = this.getParent();
        if (p instanceof ProfileNode) {
            ProfileNode parentNode = (ProfileNode)p;
            parentNode.addAndDescendants(answer);
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new ProfileAddAction(this));
        menu.add((IAction)new ProfileDeleteAction(this));
    }

    public List<IPropertySource> getContainerPropertySourceList() {
        return PropertySources.toPropertySourceList(this.getContainerNodes());
    }
}

