/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import io.fabric8.api.Profile;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fusesource.ide.commons.ui.ICanValidate;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.ProfileTreeSelectionFormSupport;
import org.fusesource.ide.fabric.navigator.ProfileNode;
import org.fusesource.ide.fabric.navigator.ProfileParentsContentProvider;
import org.fusesource.ide.fabric.navigator.ProfilesFormSupport;

public class ProfileDetailsForm
extends ProfilesFormSupport {
    private final ProfileNode node;
    ProfileTreeSelectionFormSupport parentsForm = new ProfileTreeSelectionFormSupport(){

        public void setFocus() {
            this.getProfilesViewer().getControl().setFocus();
        }

        protected void createTextFields(Composite parent) {
        }

        @Override
        protected void onProfileSelectionChanged() {
            super.onProfileSelectionChanged();
            this.okPressed();
        }

        public void okPressed() {
            Profile[] profiles = this.getSelectedProfileArray();
            ProfileDetailsForm.this.node.getProfile().setParents(profiles);
        }

        public FormToolkit getToolkit() {
            return ProfileDetailsForm.this.getToolkit();
        }
    };

    public ProfileDetailsForm(ICanValidate validator, ProfileNode node) {
        super(validator);
        this.node = node;
    }

    public void createTextFields(Composite parent) {
        this.featuresList = null;
        Profile profile = this.node.getProfile();
        String sectionTitle = profile.getId();
        Composite inner = this.createSectionComposite(sectionTitle, new GridData(1808));
        this.createProfileForm(profile, inner);
        this.createLabel(inner, Messages.profileParentsLabel);
        this.parentsForm.createColumnsViewer(inner);
        this.parentsForm.setProfilesViewerInput((Object)this.node.getVersionNode());
        this.parentsForm.getProfilesViewer().setContentProvider((IContentProvider)new ProfileParentsContentProvider(this.node));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.parentsForm.getProfilesViewer().getTree().setLayoutData((Object)gridData);
        this.parentsForm.setCheckedProfiles(profile.getParents());
    }

    protected Label createLabel(Composite inner, String text) {
        Label label = super.createLabel(inner, text);
        GridData data = new GridData(2);
        label.setLayoutData((Object)data);
        return label;
    }

    @Override
    public void setFocus() {
        this.parentsForm.setFocus();
    }
}

