/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.navigator.FabricEvent;
import org.fusesource.ide.fabric.navigator.FabricListener;
import org.fusesource.ide.fabric.navigator.FabricNavigator;
import org.fusesource.ide.fabric.navigator.INode;
import org.fusesource.ide.fabric.navigator.jmx.FabricConnectionWrapper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerContentProvider;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerLabelProvider;

public class FabricsContentProvider
implements ITreeContentProvider,
ILabelProvider,
IStructuredContentProvider,
FabricListener,
IChangeListener {
    private MBeanExplorerContentProvider delegate = new MBeanExplorerContentProvider();
    private MBeanExplorerLabelProvider delegateLabelProvider = new MBeanExplorerLabelProvider();
    private Viewer viewer;
    private FabricNavigator navigator;

    public void dispose() {
        this.removeFabricListener();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (newInput instanceof FabricNavigator) {
            this.removeFabricListener();
            this.navigator = (FabricNavigator)((Object)newInput);
            this.navigator.getFabrics().addFabricListener(this);
            this.navigator.getCloudsNode().addChangeListener(this);
        }
        this.delegate.inputChanged(viewer, oldInput, newInput);
    }

    protected void removeFabricListener() {
        if (this.navigator != null) {
            this.navigator.getFabrics().removeFabricListener(this);
            this.navigator.getCloudsNode().removeChangeListener(this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof FabricNavigator) {
            FabricNavigator navigator = (FabricNavigator)((Object)parentElement);
            return new Object[]{navigator.getFabrics(), navigator.getCloudsNode()};
        }
        if (parentElement instanceof Node) {
            Node node = (Node)parentElement;
            return node.getChildren();
        }
        return this.delegate.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (this.isFabricNode(element)) {
            return null;
        }
        return this.delegate.getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (this.isFabricNode(element)) {
            return true;
        }
        return this.delegate.hasChildren(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegateLabelProvider.addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.isFabricNode(element)) {
            return true;
        }
        return this.delegateLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegateLabelProvider.removeListener(listener);
    }

    public Image getImage(Object element) {
        ImageProvider provider;
        Image image;
        if (element instanceof ImageProvider && (image = (provider = (ImageProvider)element).getImage()) != null) {
            return image;
        }
        if (this.isFabricNode(element)) {
            return FabricPlugin.getDefault().getImage("fabric_folder.png");
        }
        return this.delegateLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof FabricNavigator) {
            return "Fabrics";
        }
        if (element instanceof FabricConnectionWrapper) {
            return "JMX";
        }
        if (element instanceof INode) {
            return element.toString();
        }
        return this.delegateLabelProvider.getText(element);
    }

    protected boolean isFabricNode(Object element) {
        return element instanceof FabricNavigator || element instanceof INode;
    }

    @Override
    public void onFabricEvent(FabricEvent fabricEvent) {
        this.fireRefresh(fabricEvent.getFabric(), true);
    }

    public void handleChange(ChangeEvent event) {
        this.fireRefresh((Object)this.navigator.getCloudsNode(), true);
    }

    private void fireRefresh(Object node, boolean full) {
        FabricsContentProvider.refreshTreeViewer(this.viewer, node, full);
    }

    public static void refreshTreeViewer(final Viewer viewer, final Object node, final boolean full) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Viewers.isValid((Viewer)viewer)) {
                    if (full || node == null || !(viewer instanceof StructuredViewer)) {
                        viewer.refresh();
                    } else {
                        ((StructuredViewer)viewer).refresh(node);
                    }
                }
            }
        });
    }
}

