/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ResourceTransfer;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.HasViewer;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.drop.DelegateDropListener;
import org.fusesource.ide.fabric.navigator.Fabrics;
import org.fusesource.ide.fabric.navigator.cloud.CloudsNode;
import org.jboss.tools.jmx.ui.internal.actions.RefreshAction;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;

public class FabricNavigator
extends JMXNavigator {
    public static String ID = "org.fusesource.ide.fabric.navigator";
    protected RefreshableUI refreshableUI = new RefreshableUIImplementation();
    private Fabrics fabrics = new Fabrics(this.refreshableUI);
    private CloudsNode clouds = new CloudsNode(this.refreshableUI);

    protected IAdaptable getInitialInput() {
        return this;
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        CommonViewer viewer = this.getCommonViewer();
        viewer.setExpandedElements(new Object[]{this.clouds, this.fabrics});
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 772){

            public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
                super.addDragSupport(operations, transferTypes, listener);
            }

            public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
                Transfer[] newTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), ResourceTransfer.getInstance(), TextTransfer.getInstance()};
                super.addDropSupport(operations, newTransferTypes, (DropTargetListener)new DelegateDropListener((Viewer)this, listener));
            }
        };
    }

    public CloudsNode getCloudsNode() {
        return this.clouds;
    }

    public Fabrics getFabrics() {
        return this.fabrics;
    }

    public void fillActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.fabrics.getAddAction());
        toolBarManager.add((IAction)new RefreshAction(this.getViewSite().getId()));
        toolBarManager.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public final class RefreshableUIImplementation
    implements RefreshableUI,
    HasViewer {
        public void fireRefresh(final Object node, final boolean full) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FabricNavigator.this.getCommonViewer().refresh(node, full);
                }
            });
        }

        public void fireRefresh() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Viewers.refresh((Viewer)FabricNavigator.this.getCommonViewer());
                }
            });
        }

        public Viewer getViewer() {
            return FabricNavigator.this.getCommonViewer();
        }
    }
}

