/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import com.google.common.base.Objects;
import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileStatus;
import io.fabric8.api.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.tree.GraphableNode;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.HasViewer;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.actions.HasDoubleClickAction;
import org.fusesource.ide.fabric.FabricConnector;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.FabricConnectAction;
import org.fusesource.ide.fabric.actions.FabricDetails;
import org.fusesource.ide.fabric.actions.FabricDetailsDeleteAction;
import org.fusesource.ide.fabric.actions.FabricDetailsEditAction;
import org.fusesource.ide.fabric.actions.FabricDisconnectAction;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.ContainersNode;
import org.fusesource.ide.fabric.navigator.FabricTabViewPage;
import org.fusesource.ide.fabric.navigator.Fabrics;
import org.fusesource.ide.fabric.navigator.ProfileNode;
import org.fusesource.ide.fabric.navigator.VersionNode;
import org.fusesource.ide.fabric.navigator.VersionsNode;
import org.fusesource.ide.fabric.views.logs.FabricLogBrowser;
import org.fusesource.ide.fabric.views.logs.HasLogBrowser;
import org.fusesource.ide.fabric.views.logs.ILogBrowser;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class Fabric
extends RefreshableCollectionNode
implements ImageProvider,
HasRefreshableUI,
GraphableNode,
HasLogBrowser,
ContextMenuProvider,
HasDoubleClickAction {
    public static final String DEFAULT_NAME = "Fabric";
    private static final boolean changeSelectionOnCreate = false;
    private static final boolean changeSelectionOnConnect = false;
    private String userName = "admin";
    private String password = "admin";
    private FabricConnector connector;
    private final Fabrics fabrics;
    private ContainersNode containersNode;
    private VersionsNode versionsNode;
    private FabricLogBrowser logBrowser;
    private FabricDetailsEditAction editAction;
    private FabricDetailsDeleteAction deleteAction;
    private FabricDetails details;
    private boolean selectContainersOnCreate = true;
    private Set<Runnable> fabricUpdateTasks = new HashSet<Runnable>();

    public Fabric(Fabrics fabrics, FabricDetails details) {
        super((Node)fabrics);
        this.fabrics = fabrics;
        this.details = details;
        this.userName = details.getUserName();
        this.password = details.getPassword();
        this.editAction = new FabricDetailsEditAction(){

            @Override
            protected FabricDetails getSelectedFabricDetails() {
                return Fabric.this.getDetails();
            }

            @Override
            protected void onFabricDetailsEdited(FabricDetails found) {
                Fabric.this.setDetails(found);
            }
        };
        this.deleteAction = new FabricDetailsDeleteAction(){

            @Override
            protected FabricDetails getSelectedFabricDetails() {
                return Fabric.this.getDetails();
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new FabricTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    public FabricService getFabricService() {
        if (this.connector != null) {
            return this.connector.getFabricService();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public FabricDetails getDetails() {
        return this.details;
    }

    public void addFabricUpdateRunnable(Runnable runnable) {
        this.fabricUpdateTasks.add(runnable);
        FabricPlugin.getLogger().debug("=============== Now have " + this.fabricUpdateTasks.size() + " runnables");
    }

    public void removeFabricUpdateRunnable(Runnable runnable) {
        this.fabricUpdateTasks.remove(runnable);
    }

    public void setDetails(FabricDetails details) {
        String oldUrls = this.details.getUrls();
        this.details = details;
        String newUrls = details.getUrls();
        if (!Objects.equal((Object)oldUrls, (Object)newUrls)) {
            if (this.connector != null) {
                this.connector.dispose();
            }
            this.connector = new FabricConnector(this);
            this.setPropertyBean(this.connector);
        }
    }

    public RefreshableUI getRefreshableUI() {
        return this.fabrics.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("fabric.png");
    }

    protected void loadChildren() {
        if (!this.isConnected()) {
            return;
        }
        this.containersNode = new ContainersNode(this);
        this.versionsNode = new VersionsNode(this);
        this.addChild((Node)this.containersNode);
        this.addChild((Node)this.versionsNode);
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new FabricConnectAction(this));
        menu.add((IAction)new FabricDisconnectAction(this));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editAction);
        menu.add((IAction)this.deleteAction);
    }

    public VersionNode getDefaultVersionNode() {
        if (!this.isConnected() || this.versionsNode == null) {
            return null;
        }
        return this.versionsNode.getDefaultVersionNode();
    }

    public List<Node> getChildrenGraph() {
        ContainersNode node;
        HashSet answer = new HashSet();
        if (this.isConnected() && (node = this.getContainersNode()) != null) {
            answer.addAll(node.getChildrenList());
        }
        return new ArrayList<Node>(answer);
    }

    @Override
    public ILogBrowser getLogBrowser() {
        return this.logBrowser;
    }

    public Action getDoubleClickAction() {
        return new FabricConnectAction(this);
    }

    protected void addChildren(Set<Node> set, Node node, boolean showVersions) {
        if (node != null && this.isConnected()) {
            List childrenList = node.getChildrenList();
            for (Node child : childrenList) {
                if (child instanceof ProfileNode || child instanceof VersionNode) {
                    this.addChildren(set, child, showVersions);
                } else if (!(child instanceof ContainerNode) && !showVersions && child instanceof VersionNode) continue;
                set.add(child);
            }
        }
    }

    public List<ContainerNode> getAgentsFor(Profile profile) {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        if (this.containersNode != null && this.isConnected()) {
            Node[] children;
            Node[] nodeArray = children = this.containersNode.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerNode agent;
                Node node = nodeArray[n2];
                if (node instanceof ContainerNode && (agent = (ContainerNode)node).matches(profile)) {
                    answer.add(agent);
                }
                ++n2;
            }
        }
        return answer;
    }

    public ContainersNode getContainersNode() {
        return this.containersNode;
    }

    public VersionsNode getVersionsNode() {
        return this.versionsNode;
    }

    public String getName() {
        return this.details.getName();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public FabricConnector getConnector() {
        return this.connector;
    }

    public void setConnector(FabricConnector conn) {
        if (conn == null && this.connector != null) {
            this.connector.dispose();
        }
        this.connector = conn;
        this.setPropertyBean(this.connector);
    }

    public boolean isConnected() {
        if (this.connector == null) {
            return false;
        }
        return this.connector.isConnected();
    }

    public Collection<ProfileNode> getProfileNodes(Profile[] profiles) {
        HashSet<ProfileNode> answer = new HashSet<ProfileNode>();
        if (this.isConnected()) {
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileNode profileNode;
                Profile profile = profileArray[n2];
                VersionNode version = this.getVersionNode(profile.getVersion());
                if (version != null && (profileNode = version.getProfileNode(profile)) != null) {
                    answer.add(profileNode);
                }
                ++n2;
            }
        }
        return answer;
    }

    public VersionNode getVersionNode(String version) {
        if (this.versionsNode != null) {
            return this.versionsNode.getVersionNode(version);
        }
        return null;
    }

    public Version getVersion(String versionName) {
        VersionNode node = this.getVersionNode(versionName);
        if (node != null) {
            return node.getVersion();
        }
        return null;
    }

    public void createContainer(final Container agent, final Profile[] profiles, final CreateContainerOptions args) {
        if (!this.isConnected()) {
            return;
        }
        try {
            Jobs.schedule((Job[])new Job[]{new Job("Create container"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        FabricService fabricService = Fabric.this.getFabricService();
                        final CreateContainerMetadata[] newAgents = agent != null ? fabricService.createContainers(args) : fabricService.createContainers(args);
                        Viewers.async((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CreateContainerMetadata[] createContainerMetadataArray = newAgents;
                                int n = newAgents.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CreateContainerMetadata metadata = createContainerMetadataArray[n2];
                                    Container newContainer = metadata.getContainer();
                                    if (newContainer != null) {
                                        Fabric.this.setContainerProfiles(newContainer, profiles);
                                        Fabric.this.refreshCreatedAgent(args.getName());
                                    }
                                    ++n2;
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (Throwable e) {
                        return new Status(4, "org.fusesource.ide.fabric", "Failed to create container: " + e, e);
                    }
                }
            }});
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to create new child container of " + this, e.getMessage(), e);
        }
    }

    public void setContainerProfiles(Container newContainer, Profile[] profiles) {
        if (!this.isConnected() || newContainer == null) {
            return;
        }
        Version version = this.getProfilesVersion(profiles);
        if (version != null) {
            newContainer.setVersion(version);
        }
        newContainer.setProfiles(profiles);
    }

    public Version getProfilesVersion(Profile[] profiles) {
        Version version = null;
        if (this.isConnected()) {
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                String versionName = profile.getVersion();
                if (versionName != null) {
                    version = this.getVersion(versionName);
                }
                ++n2;
            }
        }
        return version;
    }

    public void refreshCreatedAgent(String agentName) {
        if (!this.isConnected()) {
            return;
        }
        Fabric fabric = this;
        ContainersNode containers = this.getContainersNode();
        if (containers != null) {
            containers.refresh();
        }
    }

    public String getNewAgentName() {
        return "container" + (this.getContainersNode().getChildCount() + 1);
    }

    public void onConnect() {
        RefreshableUI refreshableUI = this.getRefreshableUI();
        if (refreshableUI instanceof HasViewer) {
            HasViewer hv = (HasViewer)refreshableUI;
            Viewer viewer = hv.getViewer();
            final Fabric fabric = this;
            if (viewer instanceof CommonViewer) {
                final CommonViewer cv = (CommonViewer)viewer;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ContainersNode containersNode = Fabric.this.getContainersNode();
                        Fabric.this.getVersionsNode();
                        if (containersNode != null) {
                            cv.setExpandedElements(new Object[]{fabric, containersNode});
                        }
                    }
                });
            }
        }
    }

    public void onDisconnect() {
        FabricConnector conn = this.getConnector();
        if (conn != null) {
            conn.dispose();
        }
        this.setConnector(null);
        this.refresh();
    }

    public List<ContainerNode> getRootContainers() {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        if (this.containersNode != null) {
            for (ContainerNode node : this.containersNode.getContainerNodes()) {
                if (!node.getContainer().isRoot()) continue;
                answer.add(node);
            }
        }
        return answer;
    }

    public void onZooKeeperUpdate() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                FabricPlugin.getLogger().debug("Refreshing Fabric " + this + " due to ZK change!");
                Fabric.this.getContainersNode().refresh();
                for (Runnable task : Fabric.this.fabricUpdateTasks) {
                    task.run();
                }
            }
        });
    }

    public Collection<ProfileStatus> getProfileStatuses() {
        FabricService service = this.getFabricService();
        if (service == null || !this.isConnected()) {
            return new ArrayList<ProfileStatus>();
        }
        return service.getFabricStatus().getProfileStatusMap().values();
    }
}

