/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import io.fabric8.api.Container;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.CreateChildContainerAction;
import org.fusesource.ide.fabric.actions.CreateSshContainerAction;
import org.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.ContainerTableSheetPage;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric.navigator.IdBasedFabricNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ContainersNode
extends FabricNodeSupport
implements ImageProvider {
    public ContainersNode(Fabric fabric) {
        super((Node)fabric, fabric);
    }

    public String toString() {
        return "Containers";
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("container_folder.png");
    }

    protected void loadChildren() {
        Container[] agents = this.getFabric().getConnector().getAgents();
        if (agents != null) {
            IdBasedFabricNode[] cfr_ignored_0 = new IdBasedFabricNode[agents.length];
            Container[] containerArray = agents;
            int n = agents.length;
            int n2 = 0;
            while (n2 < n) {
                Container agent = containerArray[n2];
                ContainerNode agentNode = new ContainerNode(this, agent);
                this.addChild((Node)agentNode);
                ++n2;
            }
        }
    }

    public ContainerNode getContainerNode(String agentName) {
        List childrenList = this.getChildrenList();
        for (Node node : childrenList) {
            ContainerNode an;
            if (!(node instanceof ContainerNode) || !Objects.equal((Object)agentName, (Object)(an = (ContainerNode)node).getId())) continue;
            return an;
        }
        return null;
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.checkLoaded();
            if (this.getFabric() != null) {
                return new ContainerTableSheetPage(this.getFabric());
            }
        }
        return super.getAdapter(adapter);
    }

    protected PropertySourceTableSheetPage createPropertySourceTableSheetPage() {
        return new ContainerTableSheetPage(this.getFabric());
    }

    public List<ContainerNode> getContainerNodes() {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        Node[] children = this.getChildren();
        if (children != null) {
            Node[] nodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                if (node instanceof ContainerNode) {
                    answer.add((ContainerNode)node);
                }
                ++n2;
            }
        }
        return answer;
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        CreateChildContainerAction.addIfSingleRootContainer(menu, this.getFabric());
        menu.add((IAction)new CreateJCloudsContainerAction(this.getFabric()));
        menu.add((IAction)new CreateSshContainerAction(this.getFabric()));
    }
}

