/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import java.util.List;
import org.fusesource.ide.commons.ui.propsrc.BeanPropertySource;
import org.fusesource.ide.fabric.navigator.Fabrics;
import scala.actors.threadpool.Arrays;

public class ContainerViewBean {
    public static final Joiner spaceJoiner = Joiner.on((String)" ");
    private final Container container;

    public static ContainerViewBean toContainerViewBean(Object element) {
        if (element instanceof BeanPropertySource) {
            BeanPropertySource source = (BeanPropertySource)element;
            return ContainerViewBean.toContainerViewBean(source.getBean());
        }
        if (element instanceof ContainerViewBean) {
            return (ContainerViewBean)element;
        }
        if (element instanceof Container) {
            return new ContainerViewBean((Container)element);
        }
        return null;
    }

    public ContainerViewBean(Container container) {
        this.container = container;
    }

    public Container[] getChildren() {
        return this.container.getChildren();
    }

    public String getId() {
        return this.container.getId();
    }

    public String getVersion() {
        return Fabrics.getVersionName(this.version());
    }

    public Version version() {
        return this.container.getVersion();
    }

    public List<String> getJmxDomains() {
        return this.container.getJmxDomains();
    }

    public String getJmxUrl() {
        return this.container.getJmxUrl();
    }

    public String getLocation() {
        return this.container.getLocation();
    }

    public Container getParent() {
        return this.container.getParent();
    }

    public String getProfileIds() {
        Object[] profiles = this.getProfiles();
        if (profiles == null || profiles.length == 0) {
            return null;
        }
        Iterable ids = Iterables.transform((Iterable)Arrays.asList((Object[])profiles), (Function)new Function<Profile, String>(){

            public String apply(Profile profile) {
                return profile.getId();
            }
        });
        return spaceJoiner.join(ids);
    }

    public Profile[] getProfiles() {
        return this.container.getProfiles();
    }

    public String getSshUrl() {
        return this.container.getSshUrl();
    }

    public String getType() {
        return this.container.getType();
    }

    public boolean isAlive() {
        return this.container.isAlive();
    }

    public String getStatus() {
        String status = this.container.getProvisionStatus();
        if ((this.isRoot() || !this.isAlive()) && status != null && status.startsWith("not provisioned")) {
            return "";
        }
        return status;
    }

    public boolean isProvisioningComplete() {
        return this.container.isProvisioningComplete();
    }

    public boolean isRoot() {
        return this.container.isRoot();
    }

    public void setLocation(String arg0) {
        this.container.setLocation(arg0);
    }

    public void setProfiles(Profile[] arg0) {
        this.container.setProfiles(arg0);
    }

    public void setVersion(Version arg0) {
        this.container.setVersion(arg0);
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public Container container() {
        return this.container;
    }
}

