/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.fabric8.api.Container;
import io.fabric8.api.Version;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.tree.Refreshables;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.commons.ui.actions.SeparatorFactory;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableView;
import org.fusesource.ide.commons.ui.views.IViewPage;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.CreateChildContainerAction;
import org.fusesource.ide.fabric.actions.CreateSshContainerAction;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.ContainerTableView;
import org.fusesource.ide.fabric.navigator.ContainersNode;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.jboss.tools.jmx.core.tree.Node;

public class ContainerTableSheetPage
extends PropertySourceTableSheetPage {
    protected static final String VIEW_ID = ContainerTableSheetPage.class.getName();
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(VIEW_ID);
    private final Fabric fabric;
    private Action openTerminalAction;
    private Action startAction;
    private Action stopAction;
    private Action destroyAction;
    private CreateChildContainerAction createChildContainerAction;
    private CreateJCloudsContainerAction createCloudContainerAction;
    private CreateSshContainerAction createSshContainerAction;
    private MenuManager setVersionMenu;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private Separator separator3 = separatorFactory.createSeparator();
    private Separator separator4 = separatorFactory.createSeparator();
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            ContainerTableSheetPage.this.refresh();
        }
    };

    public ContainerTableSheetPage(Fabric fabric) {
        super((Node)fabric, VIEW_ID, (PropertySourceTableView)new ContainerTableView(VIEW_ID));
        this.fabric = fabric;
        this.openTerminalAction = new ActionSupport(Messages.openTerminalLabel, Messages.openTerminalToolTip, FabricPlugin.getDefault().getImageDescriptor("terminal_view.gif")){

            public void run() {
                Container container;
                List<Container> selectedContainers = ContainerTableSheetPage.this.getSelectedContainers();
                if (selectedContainers.size() > 0 && (container = selectedContainers.get(0)) != null) {
                    ContainerNode.openTerminal(ContainerTableSheetPage.this.getFabric(), container, null);
                }
            }
        };
        this.startAction = new ActionSupport(Messages.StartAgentAction, Messages.StartAgentActionToolTip, FabricPlugin.getDefault().getImageDescriptor("start_task.gif")){

            public void run() {
                ContainerTableSheetPage.this.start();
            }
        };
        this.stopAction = new ActionSupport(Messages.StopAgentAction, Messages.StopAgentActionToolTip, FabricPlugin.getDefault().getImageDescriptor("stop_task.gif")){

            public void run() {
                ContainerTableSheetPage.this.stop();
            }
        };
        this.destroyAction = new ActionSupport(Messages.DestroyContainerAction, Messages.DestroyContainerActionToolTip, FabricPlugin.getDefault().getImageDescriptor("delete.gif")){

            public void run() {
                ContainerTableSheetPage.this.destroy();
            }
        };
        this.setVersionMenu = new MenuManager("Set Version", FabricPlugin.getDefault().getImageDescriptor("version.png"), "org.fusesource.ide.actions.update.version");
        this.setVersionMenu.setRemoveAllWhenShown(true);
        this.setVersionMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Version[] versions = ContainerTableSheetPage.this.getFabric().getFabricService().getVersions();
                Set<String> selectedVersionNames = ContainerTableSheetPage.this.getSelectedVersionNames();
                Version[] versionArray = versions;
                int n = versions.length;
                int n2 = 0;
                while (n2 < n) {
                    final Version version = versionArray[n2];
                    Action action = new Action(version.getName()){

                        public void run() {
                            ContainerTableSheetPage.this.setSelectedContainersVersion(version);
                        }
                    };
                    action.setEnabled(ContainerTableSheetPage.this.hasVersionApartFrom(selectedVersionNames, version));
                    ContainerTableSheetPage.this.setVersionMenu.add((IAction)action);
                    ++n2;
                }
            }
        });
        this.updateActionStatus();
    }

    public void dispose() {
        super.dispose();
        this.fabric.removeFabricUpdateRunnable(this.refreshRunnable);
    }

    public void setPropertySources(List<IPropertySource> propertySources) {
        super.setPropertySources(propertySources);
        this.getCreateChildContainerAction().updateEnabled();
    }

    protected void stop() {
        final List<Container> containers = this.getSelectedContainers();
        String message = Objects.makeString((String)"Stopping ", (String)", ", (String)"", this.getSelectedIds());
        Jobs.schedule((String)message, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (Container container : containers) {
                    if (!container.isAlive()) continue;
                    container.stop();
                }
                ContainerTableSheetPage.this.refresh();
            }
        });
    }

    protected void start() {
        final List<Container> containers = this.getSelectedContainers();
        String message = Objects.makeString((String)"Starting ", (String)", ", (String)"", this.getSelectedIds());
        Jobs.schedule((String)message, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (Container container : containers) {
                    if (container.isAlive()) continue;
                    container.start();
                }
                ContainerTableSheetPage.this.refresh();
            }
        });
    }

    protected void destroy() {
        final List<Container> containers = this.getSelectedContainers();
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)"Destroy Container(s)", (String)Objects.makeString((String)"Do you really want to destroy the selected container(s) ", (String)", ", (String)"?\nThis will terminate the container process and removes it from Fabric!", this.getSelectedIds()));
        if (confirm) {
            Jobs.schedule((String)Objects.makeString((String)"Destroying container(s) ", (String)", ", (String)"", this.getSelectedIds()), (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Container container : containers) {
                        container.destroy();
                    }
                    ContainerTableSheetPage.this.refresh();
                }
            });
        }
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                Set<String> selectedIds = ContainerTableSheetPage.this.getSelectedIds();
                Refreshables.refresh((Object)((Object)ContainerTableSheetPage.this.fabric.getContainersNode()));
                ContainerTableSheetPage.this.updateData();
                Refreshables.refresh((Object)ContainerTableSheetPage.this.getTableView());
                ContainerTableSheetPage.this.setSelectedContainerIds(selectedIds);
                ContainerTableSheetPage.this.updateActionStatus();
            }
        });
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public void createControl(Composite parent) {
        this.getTableView().addToolBarActions(new Object[]{this.openTerminalAction, this.startAction, this.stopAction, this.destroyAction});
        this.getTableView().addLocalMenuActions(new Object[]{this.separator1, this.openTerminalAction, this.startAction, this.stopAction, this.destroyAction, this.separator2, this.setVersionMenu, this.separator3, this.getCreateChildContainerAction(), this.getCreateCloudContainerAction(), this.getCreateSshContainerAction(), this.separator4});
        this.getTableView().addToolBarActions(new Object[]{this.openTerminalAction, this.setVersionMenu, this.startAction, this.stopAction, this.destroyAction});
        this.getTableView().setDoubleClickAction(new Action(){

            public void run() {
                Container container;
                ContainerNode containerNode;
                List<Container> selectedContainers;
                ContainersNode containersNode = ContainerTableSheetPage.this.fabric.getContainersNode();
                if (containersNode != null && !(selectedContainers = ContainerTableSheetPage.this.getSelectedContainers()).isEmpty() && (containerNode = containersNode.getContainerNode((container = selectedContainers.get(0)).getId())) != null) {
                    Selections.setSingleSelection((RefreshableUI)ContainerTableSheetPage.this.fabric.getRefreshableUI(), (Object)containerNode);
                }
            }
        });
        super.createControl(parent);
        this.getTableView().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ContainerTableSheetPage.this.updateActionStatus();
            }
        });
        this.fabric.addFabricUpdateRunnable(this.refreshRunnable);
    }

    protected int countStarted(List<Container> containers, boolean flag) {
        int counter = 0;
        for (Container container : containers) {
            boolean alive = container.isAlive();
            if (alive != flag) continue;
            ++counter;
        }
        return counter;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
    }

    protected List<Container> getSelectedContainers() {
        ArrayList<Container> containers = new ArrayList<Container>();
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Container container = ContainerNode.toContainer(iterator.next());
                if (container == null) continue;
                containers.add(container);
            }
        }
        return containers;
    }

    protected IStructuredSelection getSelection() {
        return Selections.getStructuredSelection((Viewer)this.getTableView().getViewer());
    }

    protected Set<String> getSelectedVersionNames() {
        HashSet<String> answer = new HashSet<String>();
        List<Container> containers = this.getSelectedContainers();
        for (Container container : containers) {
            String name;
            Version version = container.getVersion();
            if (version == null || (name = version.getName()) == null) continue;
            answer.add(name);
        }
        return answer;
    }

    protected Set<String> getSelectedIds() {
        HashSet<String> answer = new HashSet<String>();
        List<Container> containers = this.getSelectedContainers();
        for (Container container : containers) {
            String id = container.getId();
            if (id == null) continue;
            answer.add(id);
        }
        return answer;
    }

    protected void setSelectedContainerIds(Set<String> selectedIds) {
        TableViewer viewer = this.getTableView().getViewer();
        if (viewer != null) {
            List propertySources = this.getPropertySources();
            ArrayList selected = new ArrayList();
            for (Object object : propertySources) {
                IPropertySource source;
                Object value;
                if (!(object instanceof IPropertySource) || !((value = (source = (IPropertySource)object).getPropertyValue((Object)"id")) instanceof String) || !selectedIds.contains(value.toString())) continue;
                selected.add(object);
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
            if (selected.size() == 1) {
                Object first = selected.get(0);
                viewer.reveal(first);
            }
        }
    }

    protected void setSelectedContainersVersion(Version version) {
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            boolean changed = false;
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                ContainerNode agentNode = ContainerNode.toContainerNode(iterator.next());
                if (agentNode == null || agentNode.matches(version)) continue;
                agentNode.getContainer().setVersion(version);
                changed = true;
            }
            if (changed) {
                IViewPage view = this.getView();
                if (view instanceof ISection) {
                    ISection section = (ISection)view;
                    section.refresh();
                }
                this.getFabric().getContainersNode().refresh();
                this.getFabric().getVersionsNode().refresh();
            }
        }
    }

    protected void updateData() {
        ContainersNode containersNode = this.fabric.getContainersNode();
        if (containersNode != null) {
            this.setPropertySources(containersNode.getPropertySourceList());
        }
    }

    protected boolean hasVersionApartFrom(Set<String> names, Version version) {
        int minSize;
        int n = minSize = names.contains(version.getName()) ? 2 : 1;
        return names.size() >= minSize;
    }

    protected CreateChildContainerAction getCreateChildContainerAction() {
        if (this.createChildContainerAction == null) {
            this.createChildContainerAction = this.createChildContainerAction(this.fabric);
            this.createChildContainerAction.updateEnabled();
        }
        return this.createChildContainerAction;
    }

    protected void setCreateChildContainerAction(CreateChildContainerAction createChildContainerAction) {
        this.createChildContainerAction = createChildContainerAction;
    }

    protected CreateJCloudsContainerAction getCreateCloudContainerAction() {
        if (this.createCloudContainerAction == null) {
            this.createCloudContainerAction = this.createCloudContainerAction(this.fabric);
        }
        return this.createCloudContainerAction;
    }

    protected void setCreateCloudContainerAction(CreateJCloudsContainerAction createCloudContainerAction) {
        this.createCloudContainerAction = createCloudContainerAction;
    }

    protected CreateSshContainerAction getCreateSshContainerAction() {
        if (this.createSshContainerAction == null) {
            this.createSshContainerAction = this.createSshContainerAction(this.fabric);
        }
        return this.createSshContainerAction;
    }

    protected void setCreateSshContainerAction(CreateSshContainerAction createSshContainerAction) {
        this.createSshContainerAction = createSshContainerAction;
    }

    protected CreateJCloudsContainerAction createCloudContainerAction(Fabric fabric) {
        return new CreateJCloudsContainerAction(fabric);
    }

    protected CreateSshContainerAction createSshContainerAction(Fabric fabric) {
        return new CreateSshContainerAction(fabric);
    }

    protected CreateChildContainerAction createChildContainerAction(Fabric fabric) {
        return new CreateChildContainerAction(fabric);
    }

    protected void updateActionStatus() {
        List<Container> selectedContainers = this.getSelectedContainers();
        ContainerNode containerNode = this.getSingleSelectedRootContainerNode(selectedContainers);
        this.getCreateChildContainerAction().setContainerNode(containerNode);
        this.getCreateChildContainerAction().updateEnabled();
        int selectedContainerSize = selectedContainers.size();
        this.openTerminalAction.setEnabled(selectedContainerSize > 0);
        this.startAction.setEnabled(this.countStarted(selectedContainers, false) > 0);
        this.stopAction.setEnabled(this.countStarted(selectedContainers, true) > 0);
        this.destroyAction.setEnabled(this.countStarted(selectedContainers, true) > 0);
    }

    protected ContainerNode getSingleSelectedRootContainerNode(List<Container> selectedContainers) {
        ArrayList rootContainers = Lists.newArrayList((Iterable)Iterables.filter(selectedContainers, (Predicate)new Predicate<Container>(){

            public boolean apply(Container container) {
                return container != null && container.isRoot();
            }
        }));
        if (rootContainers.size() == 1 && this.fabric != null) {
            Container rootContainer = (Container)rootContainers.get(0);
            ContainersNode containersNode = this.fabric.getContainersNode();
            if (containersNode != null) {
                return containersNode.getContainerNode(rootContainer.getId());
            }
        }
        return null;
    }
}

