/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.navigator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.fabric8.api.Container;
import io.fabric8.api.Version;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.tree.Refreshables;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.commons.ui.actions.SeparatorFactory;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.CreateChildContainerAction;
import org.fusesource.ide.fabric.actions.CreateSshContainerAction;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.ContainerTableSheetPage;
import org.fusesource.ide.fabric.navigator.ContainerTableView;
import org.fusesource.ide.fabric.navigator.ContainersNode;
import org.fusesource.ide.fabric.navigator.Fabric;

public abstract class AbstractContainersTabSection
extends ContainerTableView {
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(ContainerTableSheetPage.VIEW_ID);
    private Fabric fabric;
    private Object current;
    private Action openTerminalAction;
    private Action startAction;
    private Action stopAction;
    private Action destroyAction;
    private ActionWrapper createContainerAction;
    private ActionWrapper createCloudAction;
    private ActionWrapper createSshAction;
    private CreateChildContainerAction createChildContainerAction;
    private CreateJCloudsContainerAction createCloudContainerAction;
    private CreateSshContainerAction createSshContainerAction;
    private MenuManager setVersionMenu;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private Separator separator3 = separatorFactory.createSeparator();
    private Separator separator4 = separatorFactory.createSeparator();
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            Viewers.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AbstractContainersTabSection.this.fabric == null) {
                        return;
                    }
                    Set<String> selectedIds = AbstractContainersTabSection.this.getSelectedIds();
                    Refreshables.refresh((Object)((Object)AbstractContainersTabSection.this.fabric.getContainersNode()));
                    AbstractContainersTabSection.this.updateData();
                    Refreshables.refresh((Object)this);
                    AbstractContainersTabSection.this.setSelectedContainerIds(selectedIds);
                    AbstractContainersTabSection.this.updateActionStatus();
                }
            });
        }
    };

    public AbstractContainersTabSection() {
        super(ContainerTableSheetPage.VIEW_ID);
        this.openTerminalAction = new ActionSupport(Messages.openTerminalLabel, Messages.openTerminalToolTip, FabricPlugin.getDefault().getImageDescriptor("terminal_view.gif")){

            public void run() {
                Container container;
                List<Container> selectedContainers = AbstractContainersTabSection.this.getSelectedContainers();
                if (selectedContainers.size() > 0 && (container = selectedContainers.get(0)) != null) {
                    ContainerNode.openTerminal(AbstractContainersTabSection.this.getFabric(), container, null);
                }
            }
        };
        this.startAction = new ActionSupport(Messages.StartAgentAction, Messages.StartAgentActionToolTip, FabricPlugin.getDefault().getImageDescriptor("start_task.gif")){

            public void run() {
                AbstractContainersTabSection.this.start();
            }

            public boolean isEnabled() {
                Container container;
                List<Container> selectedContainers = AbstractContainersTabSection.this.getSelectedContainers();
                return selectedContainers.size() <= 0 || (container = selectedContainers.get(0)) == null || !container.isRoot();
            }
        };
        this.stopAction = new ActionSupport(Messages.StopAgentAction, Messages.StopAgentActionToolTip, FabricPlugin.getDefault().getImageDescriptor("stop_task.gif")){

            public void run() {
                AbstractContainersTabSection.this.stop();
            }

            public boolean isEnabled() {
                Container container;
                List<Container> selectedContainers = AbstractContainersTabSection.this.getSelectedContainers();
                return selectedContainers.size() <= 0 || (container = selectedContainers.get(0)) == null || !container.isRoot();
            }
        };
        this.destroyAction = new ActionSupport(Messages.DestroyContainerAction, Messages.DestroyContainerActionToolTip, FabricPlugin.getDefault().getImageDescriptor("delete.gif")){

            public void run() {
                AbstractContainersTabSection.this.destroy();
            }

            public boolean isEnabled() {
                Container container;
                List<Container> selectedContainers = AbstractContainersTabSection.this.getSelectedContainers();
                return selectedContainers.size() <= 0 || (container = selectedContainers.get(0)) == null || !container.isRoot();
            }
        };
        this.setVersionMenu = new MenuManager("Set Version", FabricPlugin.getDefault().getImageDescriptor("version.png"), "org.fusesource.ide.actions.update.version");
        this.setVersionMenu.setRemoveAllWhenShown(true);
        this.setVersionMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Version[] versions = AbstractContainersTabSection.this.getFabric().getFabricService().getVersions();
                Set<String> selectedVersionNames = AbstractContainersTabSection.this.getSelectedVersionNames();
                Version[] versionArray = versions;
                int n = versions.length;
                int n2 = 0;
                while (n2 < n) {
                    final Version version = versionArray[n2];
                    Action action = new Action(version.getName()){

                        public void run() {
                            AbstractContainersTabSection.this.setSelectedContainersVersion(version);
                        }
                    };
                    action.setEnabled(AbstractContainersTabSection.this.hasVersionApartFrom(selectedVersionNames, version));
                    AbstractContainersTabSection.this.setVersionMenu.add((IAction)action);
                    ++n2;
                }
            }
        });
        this.createContainerAction = new ActionWrapper(Messages.createChildAgentMenuLabel, Messages.createChildAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("add_obj.gif")){

            @Override
            protected Action getDelegate() {
                return AbstractContainersTabSection.this.createChildContainerAction;
            }
        };
        this.createCloudAction = new ActionWrapper(Messages.createJCloudsAgentMenuLabel, Messages.createJCloudsAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("new_cloud_container.png")){

            @Override
            protected Action getDelegate() {
                return AbstractContainersTabSection.this.createCloudContainerAction;
            }
        };
        this.createSshAction = new ActionWrapper(Messages.createSshAgentMenuLabel, Messages.createSshAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("new_ssh_container.png")){

            @Override
            protected Action getDelegate() {
                return AbstractContainersTabSection.this.createSshContainerAction;
            }
        };
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object containers = Selections.getFirstSelection((ISelection)selection);
        if (containers == this.current) {
            return;
        }
        if (this.fabric != null) {
            this.fabric.removeFabricUpdateRunnable(this.refreshRunnable);
        }
        this.current = containers;
        this.fabric = this.getFabricForNode(containers);
        if (this.fabric != null) {
            this.fabric.addFabricUpdateRunnable(this.refreshRunnable);
        }
        List<?> propertySources = this.getPropertySourcesForNode(containers);
        this.setPropertySources(propertySources);
        if (this.getViewer() == null) {
            this.createViewer();
        }
        this.getViewer().setInput(propertySources);
        this.recreateColumns();
        this.getViewer().refresh(true);
        this.createChildContainerAction = this.createChildContainerAction(this.current);
        this.createCloudContainerAction = this.createCloudContainerAction(this.current);
        this.createSshContainerAction = this.createSshContainerAction(this.current);
        this.updateActionStatus();
    }

    protected abstract Fabric getFabricForNode(Object var1);

    protected abstract List<?> getPropertySourcesForNode(Object var1);

    protected void recreateColumns() {
        if (this.current != null) {
            super.recreateColumns();
        }
    }

    public void dispose() {
        if (this.fabric != null) {
            this.fabric.removeFabricUpdateRunnable(this.refreshRunnable);
        }
        super.dispose();
    }

    protected void stop() {
        final List<Container> containers = this.getSelectedContainers();
        String message = Objects.makeString((String)"Stopping ", (String)", ", (String)"", this.getSelectedIds());
        Jobs.schedule((String)message, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (Container container : containers) {
                    if (!container.isAlive()) continue;
                    container.stop();
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractContainersTabSection.this.fabric.getContainersNode().refresh();
                        AbstractContainersTabSection.this.updateData();
                        AbstractContainersTabSection.this.refresh();
                    }
                });
            }
        });
    }

    protected void start() {
        final List<Container> containers = this.getSelectedContainers();
        String message = Objects.makeString((String)"Starting ", (String)", ", (String)"", this.getSelectedIds());
        Jobs.schedule((String)message, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (Container container : containers) {
                    if (container.isAlive()) continue;
                    container.start();
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractContainersTabSection.this.fabric.getContainersNode().refresh();
                        AbstractContainersTabSection.this.updateData();
                        AbstractContainersTabSection.this.refresh();
                    }
                });
            }
        });
    }

    protected void destroy() {
        final List<Container> containers = this.getSelectedContainers();
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)"Destroy Container(s)", (String)Objects.makeString((String)"Do you really want to destroy the selected container(s) ", (String)", ", (String)"?\nThis will terminate the container process and removes it from Fabric!", this.getSelectedIds()));
        if (confirm) {
            Jobs.schedule((String)Objects.makeString((String)"Destroying container(s) ", (String)", ", (String)"", this.getSelectedIds()), (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Container container : containers) {
                        container.destroy();
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractContainersTabSection.this.fabric.getContainersNode().refresh();
                            AbstractContainersTabSection.this.updateData();
                            AbstractContainersTabSection.this.refresh();
                        }
                    });
                }
            });
        }
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.addToolBarActions(new Object[]{this.openTerminalAction, this.startAction, this.stopAction, this.destroyAction});
        this.addLocalMenuActions(new Object[]{this.separator1, this.openTerminalAction, this.startAction, this.stopAction, this.destroyAction, this.separator2, this.setVersionMenu, this.separator3, this.createContainerAction, this.createCloudAction, this.createSshAction, this.separator4});
        this.addToolBarActions(new Object[]{this.openTerminalAction, this.setVersionMenu, this.startAction, this.stopAction, this.destroyAction});
        this.setDoubleClickAction(new Action(){

            public void run() {
                Container container;
                ContainerNode containerNode;
                List<Container> selectedContainers;
                if (AbstractContainersTabSection.this.fabric == null) {
                    return;
                }
                ContainersNode containersNode = AbstractContainersTabSection.this.fabric.getContainersNode();
                if (containersNode != null && !(selectedContainers = AbstractContainersTabSection.this.getSelectedContainers()).isEmpty() && (containerNode = containersNode.getContainerNode((container = selectedContainers.get(0)).getId())) != null) {
                    Selections.setSingleSelection((RefreshableUI)AbstractContainersTabSection.this.fabric.getRefreshableUI(), (Object)containerNode);
                }
            }
        });
        if (this.getViewer() == null) {
            this.createViewer();
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractContainersTabSection.this.updateActionStatus();
            }
        });
    }

    protected int countStarted(List<Container> containers, boolean flag) {
        int counter = 0;
        for (Container container : containers) {
            boolean alive = container.isAlive();
            if (alive != flag) continue;
            ++counter;
        }
        return counter;
    }

    protected List<Container> getSelectedContainers() {
        ArrayList<Container> containers = new ArrayList<Container>();
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Container container = ContainerNode.toContainer(iterator.next());
                if (container == null) continue;
                containers.add(container);
            }
        }
        return containers;
    }

    protected IStructuredSelection getSelection() {
        return Selections.getStructuredSelection((Viewer)this.getViewer());
    }

    protected Set<String> getSelectedVersionNames() {
        HashSet<String> answer = new HashSet<String>();
        List<Container> containers = this.getSelectedContainers();
        for (Container container : containers) {
            String name;
            Version version = container.getVersion();
            if (version == null || (name = version.getName()) == null) continue;
            answer.add(name);
        }
        return answer;
    }

    protected Set<String> getSelectedIds() {
        HashSet<String> answer = new HashSet<String>();
        List<Container> containers = this.getSelectedContainers();
        for (Container container : containers) {
            String id = container.getId();
            if (id == null) continue;
            answer.add(id);
        }
        return answer;
    }

    protected void setSelectedContainerIds(Set<String> selectedIds) {
        TableViewer viewer = this.getViewer();
        if (viewer != null) {
            List propertySources = this.getPropertySources();
            ArrayList selected = new ArrayList();
            for (Object object : propertySources) {
                IPropertySource source;
                Object value;
                if (!(object instanceof IPropertySource) || !((value = (source = (IPropertySource)object).getPropertyValue((Object)"id")) instanceof String) || !selectedIds.contains(value.toString())) continue;
                selected.add(object);
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
            if (selected.size() == 1) {
                Object first = selected.get(0);
                viewer.reveal(first);
            }
        }
    }

    protected void setSelectedContainersVersion(Version version) {
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            boolean changed = false;
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                ContainerNode agentNode = ContainerNode.toContainerNode(iterator.next());
                if (agentNode == null || agentNode.matches(version)) continue;
                agentNode.getContainer().setVersion(version);
                changed = true;
            }
            if (changed) {
                this.refresh();
                this.getFabric().getContainersNode().refresh();
                this.getFabric().getVersionsNode().refresh();
            }
        }
    }

    protected void updateData() {
        this.setPropertySources(this.getPropertySourcesForNode(this.current));
    }

    protected boolean hasVersionApartFrom(Set<String> names, Version version) {
        int minSize;
        int n = minSize = names.contains(version.getName()) ? 2 : 1;
        return names.size() >= minSize;
    }

    protected abstract CreateJCloudsContainerAction createCloudContainerAction(Object var1);

    protected abstract CreateSshContainerAction createSshContainerAction(Object var1);

    protected abstract CreateChildContainerAction createChildContainerAction(Object var1);

    protected void updateActionStatus() {
        List<Container> selectedContainers = this.getSelectedContainers();
        ContainerNode containerNode = this.getSingleSelectedRootContainerNode(selectedContainers);
        this.createChildContainerAction.setContainerNode(containerNode);
        this.createChildContainerAction.updateEnabled();
        int selectedContainerSize = selectedContainers.size();
        this.openTerminalAction.setEnabled(selectedContainerSize > 0);
        boolean isRootContainerSelected = false;
        if (selectedContainers.size() > 0 && selectedContainers.get(0).isRoot()) {
            isRootContainerSelected = true;
        }
        this.startAction.setEnabled(!isRootContainerSelected);
        this.stopAction.setEnabled(!isRootContainerSelected);
        this.destroyAction.setEnabled(!isRootContainerSelected);
    }

    protected ContainerNode getSingleSelectedRootContainerNode(List<Container> selectedContainers) {
        ArrayList rootContainers = Lists.newArrayList((Iterable)Iterables.filter(selectedContainers, (Predicate)new Predicate<Container>(){

            public boolean apply(Container container) {
                return container != null && container.isRoot();
            }
        }));
        if (rootContainers.size() == 1 && this.fabric != null) {
            Container rootContainer = (Container)rootContainers.get(0);
            ContainersNode containersNode = this.fabric.getContainersNode();
            if (containersNode != null) {
                return containersNode.getContainerNode(rootContainer.getId());
            }
        }
        return null;
    }

    private static abstract class ActionWrapper
    extends ActionSupport {
        public ActionWrapper(String text, String tooltip, ImageDescriptor image) {
            super(text, tooltip, image);
        }

        public boolean isEnabled() {
            return this.getDelegate() != null && this.getDelegate().isEnabled();
        }

        public void run() {
            if (this.getDelegate() == null) {
                return;
            }
            this.getDelegate().run();
        }

        protected abstract Action getDelegate();
    }
}

