/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions.jclouds;

import org.eclipse.jface.wizard.IWizard;
import org.fusesource.ide.commons.ui.Wizards;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerWizard;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.ProfileNode;
import org.fusesource.ide.fabric.navigator.VersionNode;

public class CreateJCloudsContainerAction
extends ActionSupport {
    public static final boolean createLocalAgents = true;
    private VersionNode versionNode;
    private ContainerNode agentNode;
    private ProfileNode profileNode;
    private Fabric fabric;

    public CreateJCloudsContainerAction(Fabric fabric) {
        super(Messages.createJCloudsAgentMenuLabel, Messages.createJCloudsAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("new_cloud_container.png"));
        this.fabric = fabric;
    }

    public CreateJCloudsContainerAction(VersionNode versionNode, ContainerNode agentNode, ProfileNode selectedProfile) {
        this(null);
        this.versionNode = versionNode;
        this.agentNode = agentNode;
        this.profileNode = selectedProfile;
    }

    public void run() {
        this.showCreateAgentDialog();
    }

    public ProfileNode getProfileNode() {
        return this.profileNode;
    }

    public void setProfileNode(ProfileNode profileNode) {
        this.profileNode = profileNode;
    }

    public void setFabric(Fabric fabric) {
        this.fabric = fabric;
    }

    protected void showCreateAgentDialog() {
        if (this.versionNode == null && this.fabric != null) {
            this.versionNode = this.fabric.getDefaultVersionNode();
        }
        CreateJCloudsContainerWizard wizard = new CreateJCloudsContainerWizard(this.versionNode, this.agentNode, this.versionNode.getFabric().getNewAgentName(), this.profileNode);
        Wizards.openWizardDialog((IWizard)wizard);
    }
}

