/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions.jclouds;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.jface.action.Action;
import org.fusesource.ide.commons.ui.config.ConfigurationDetails;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric.actions.jclouds.CloudDetailsDialog;

public abstract class CloudDetailsEditAction
extends Action {
    public CloudDetailsEditAction() {
        super(Messages.jcloud_editCloudButton);
        this.setToolTipText(Messages.jcloud_editCloudButtonTooktip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("prop_ps.gif"));
    }

    protected abstract CloudDetails getSelectedCloudDetails();

    protected abstract void onCloudDetailsEdited(Object var1);

    public void run() {
        CloudDetailsDialog dialog = new CloudDetailsDialog(){

            protected void okPressed() {
                CloudDetails details = this.getCloudDetails();
                super.okPressed();
                CloudDetailsEditAction.this.editCloud(details);
            }
        };
        CloudDetails selectedCloud = this.getSelectedCloudDetails();
        if (selectedCloud != null) {
            CloudDetails copy = CloudDetails.copy(selectedCloud);
            dialog.getForm().setDetails(copy);
        }
        dialog.open();
    }

    protected void editCloud(final ConfigurationDetails cloudDetails) {
        cloudDetails.flush();
        try {
            CloudDetails.reloadCloudDetailList();
        }
        catch (Exception e) {
            FabricPlugin.getLogger().error((Throwable)e);
        }
        Object found = Iterables.find((Iterable)CloudDetails.getCloudDetailList(), (Predicate)new Predicate<CloudDetails>(){

            public boolean apply(CloudDetails details) {
                return Objects.equal((Object)cloudDetails.getId(), (Object)details.getId());
            }
        });
        if (found != null) {
            this.onCloudDetailsEdited(found);
        }
    }
}

