/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions.jclouds;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.internal.expressions.util.LRUCache;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.jobs.LoadListJobSupport;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.jclouds.CloudConnectJob;
import org.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric.actions.jclouds.CloudDetailsKey;
import org.fusesource.ide.fabric.actions.jclouds.JClouds;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;

public class CloudDetailsCachedData {
    protected static LRUCache cache = new LRUCache(5);
    private final CloudDetails details;
    private final WritableList imageList = WritableList.withElementType(Image.class);
    private final WritableList hardwareList = WritableList.withElementType(Hardware.class);
    private final WritableList locationList = WritableList.withElementType(Location.class);
    private final WritableList nodePropertyList = WritableList.withElementType(ComputeMetadata.class);
    private LinkedList<OsFamily> familiesList = new LinkedList();
    private LinkedList<String> versionsList = new LinkedList();
    private ComputeService computeClient;
    private CloudConnectJob createClientJob;
    private LoadListJobSupport locationsJob;
    private LoadListJobSupport hardwareJob;
    private LoadListJobSupport imageJob;
    private CloudConnectJob reloadJob;

    public static synchronized CloudDetailsCachedData getInstance(CloudDetails selectedCloud) {
        CloudDetailsCachedData answer = null;
        if (selectedCloud == null) {
            answer = new CloudDetailsCachedData(selectedCloud);
        } else {
            CloudDetailsKey key = selectedCloud.getCacheKey();
            answer = (CloudDetailsCachedData)cache.get((Object)key);
            if (answer == null) {
                answer = new CloudDetailsCachedData(selectedCloud);
                cache.put((Object)key, (Object)answer);
            }
        }
        return answer;
    }

    public CloudDetailsCachedData(CloudDetails details) {
        this.details = details;
    }

    public CloudDetails getDetails() {
        return this.details;
    }

    public WritableList getImageList() {
        return this.imageList;
    }

    public WritableList getHardwareList() {
        return this.hardwareList;
    }

    public WritableList getLocationList() {
        return this.locationList;
    }

    public synchronized List getOsFamilyList() {
        if (this.familiesList.isEmpty()) {
            OsFamily[] osFamilyArray = OsFamily.values();
            int n = osFamilyArray.length;
            int n2 = 0;
            while (n2 < n) {
                OsFamily fam = osFamilyArray[n2];
                this.familiesList.add(fam);
                ++n2;
            }
        }
        return this.familiesList;
    }

    public synchronized List getOsVersionList() {
        if (this.versionsList.isEmpty()) {
            this.versionsList.add("");
            int i = 1;
            while (i < 20) {
                this.versionsList.add("" + i);
                ++i;
            }
        }
        return this.versionsList;
    }

    public WritableList getNodePropertyList() {
        return this.nodePropertyList;
    }

    public void startLoadingDataJobs() {
        if (this.details == null || !this.getImageList().isEmpty()) {
            return;
        }
        this.cancelLoadingJobs();
        this.locationsJob = new LoadListJobSupport("Loading cloud locations", this.locationList){

            protected List<?> loadList() {
                if (CloudDetailsCachedData.this.computeClient == null) {
                    return Collections.EMPTY_LIST;
                }
                return JClouds.sortedLocationList(CloudDetailsCachedData.this.computeClient.listAssignableLocations());
            }
        };
        this.hardwareJob = new LoadListJobSupport("Loading cloud hardware", this.hardwareList){

            protected List<?> loadList() {
                if (CloudDetailsCachedData.this.computeClient == null) {
                    return Collections.EMPTY_LIST;
                }
                return JClouds.sortedList(CloudDetailsCachedData.this.computeClient.listHardwareProfiles());
            }
        };
        this.imageJob = new LoadListJobSupport("Loading cloud images", this.imageList){

            protected List<?> loadList() {
                if (CloudDetailsCachedData.this.computeClient == null) {
                    return Collections.EMPTY_LIST;
                }
                return JClouds.sortedList(CloudDetailsCachedData.this.computeClient.listImages());
            }
        };
        this.createClientJob = !this.imageList.isEmpty() ? new CloudConnectJob(this, new Job[]{this.imageJob, this.locationsJob, this.hardwareJob}) : new CloudConnectJob(this, new Job[]{this.locationsJob, this.hardwareJob, this.imageJob});
        Jobs.schedule((Job[])new Job[]{this.createClientJob});
    }

    public void cancelLoadingJobs() {
        Jobs.cancel((Job[])new Job[]{this.createClientJob, this.locationsJob, this.hardwareJob, this.imageJob});
        this.createClientJob = null;
        this.locationsJob = null;
        this.hardwareJob = null;
        this.imageJob = null;
    }

    public ComputeService getComputeClient() {
        return this.computeClient;
    }

    public void setComputeClient(ComputeService computeClient) {
        this.computeClient = computeClient;
    }

    public void reloadNodes() {
        this.getReloadJob().schedule();
    }

    protected CloudConnectJob getReloadJob() {
        if (this.reloadJob != null) {
            this.reloadJob.cancel();
        }
        this.reloadJob = new CloudConnectJob(this, new Job[0]){

            @Override
            protected void onConnected(ComputeService client, IProgressMonitor monitor) {
                super.onConnected(client, monitor);
                this.setName("Loading nodes");
                monitor.setTaskName("Loading nodes");
                final Set listNodes = client.listNodes();
                FabricPlugin.getLogger().debug("==============  Loaded " + listNodes.size() + " nodes!");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CloudDetailsCachedData.this.nodePropertyList.clear();
                        CloudDetailsCachedData.this.nodePropertyList.addAll((Collection)listNodes);
                        FabricPlugin.getLogger().debug("==============  Added " + listNodes.size() + " nodes!");
                    }
                });
            }
        };
        return this.reloadJob;
    }
}

