/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions.jclouds;

import io.fabric8.api.Profile;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.service.jclouds.JCloudsInstanceType;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.ui.ICanValidate;
import org.fusesource.ide.fabric.actions.CreateContainerFormSupport;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric.actions.jclouds.CloudDetailsCachedData;
import org.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerArgumentsBean;
import org.fusesource.ide.fabric.actions.jclouds.JCloudsLabelProvider;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.ProfileNode;
import org.fusesource.ide.fabric.navigator.VersionNode;
import org.jclouds.compute.domain.Image;

public class CloudContainerDetailsForm
extends CreateContainerFormSupport {
    private static final String PROP_OS_VERSION = "osVersion";
    private static final String PROP_OS_FAMILY = "family";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_HARDWARE = "hardware";
    private static final String PROP_LOCATION = "location";
    private static final String PROP_USER = "user";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_ZKPASSWORD = "zookeeperPassword";
    private static final String PROP_GROUP = "group";
    private final ContainerNode selectedAgent;
    private final ProfileNode selectedProfile;
    private final Fabric fabric;
    private CreateJCloudsContainerArgumentsBean args = new CreateJCloudsContainerArgumentsBean();
    private ComboViewer imageField;
    private ComboViewer hardwareField;
    private ComboViewer locationField;
    private ComboViewer osFamilyField;
    private ComboViewer osVersionField;
    private CloudDetails selectedCloud;
    private Text userField;
    private Text passwordField;
    private Text zkPasswordField;
    private Text groupField;
    private CloudDetailsCachedData cloudCacheData = new CloudDetailsCachedData(null);
    private ImageViewerFilter imageFilter = new ImageViewerFilter(null);
    private boolean isAWSEC2;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            CloudContainerDetailsForm.this.validate();
        }
    };

    public CloudContainerDetailsForm(ICanValidate validator, VersionNode versionNode, ContainerNode selectedAgent, String defaultAgentName, ProfileNode selectedProfile) {
        super(validator, versionNode, defaultAgentName);
        this.selectedAgent = selectedAgent;
        this.selectedProfile = selectedProfile;
        Fabric fabric = versionNode != null ? versionNode.getFabric() : (selectedProfile != null ? selectedProfile.getFabric() : (this.fabric = selectedAgent != null ? selectedAgent.getFabric() : null));
        if (this.fabric != null) {
            this.args.setUser(this.fabric.getUserName());
        } else {
            this.args.setUser("admin");
        }
        this.args.setGroup("fabric");
    }

    private void presetCloudDetails() {
        if (this.selectedCloud != null) {
            this.args.setProperties(this.selectedCloud);
        }
        this.args.setInstanceType(JCloudsInstanceType.Smallest);
    }

    protected boolean isMandatory(Object bean, String propertyName) {
        return !propertyName.equals(PROP_IMAGE) && !propertyName.equals(PROP_OS_FAMILY) && !propertyName.equals(PROP_OS_VERSION);
    }

    public CreateJCloudsContainerOptions.Builder getCreateCloudArguments() {
        CreateJCloudsContainerOptions.Builder answer = this.args.getBuilder();
        return answer;
    }

    @Override
    public void setFocus() {
        this.groupField.setFocus();
    }

    public CloudDetails getSelectedCloud() {
        return this.selectedCloud;
    }

    public void setSelectedCloud(CloudDetails selectedCloud) {
        if (this.cloudCacheData != null) {
            this.cloudCacheData.cancelLoadingJobs();
        }
        this.selectedCloud = selectedCloud;
        this.cloudCacheData = CloudDetailsCachedData.getInstance(selectedCloud);
        this.setCloudDataInputs();
        this.cloudCacheData.startLoadingDataJobs();
        this.presetCloudDetails();
        this.restoreAll();
    }

    protected void setInput(final ComboViewer viewer, WritableList list) {
        list.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                CloudContainerDetailsForm.this.restoreSettings(viewer);
                Viewers.refresh((Viewer)viewer);
            }
        });
        viewer.setInput((Object)list);
    }

    public WritableList getImageList() {
        return this.cloudCacheData.getImageList();
    }

    public List getOSFamilyList() {
        return this.cloudCacheData.getOsFamilyList();
    }

    public List getOSVersionList() {
        return this.cloudCacheData.getOsVersionList();
    }

    public WritableList getHardwareList() {
        return this.cloudCacheData.getHardwareList();
    }

    public WritableList getLocationList() {
        return this.cloudCacheData.getLocationList();
    }

    @Override
    protected void loadPreference() {
        Profile profile;
        if (this.selectedProfile != null && (profile = this.selectedProfile.getProfile()) != null) {
            this.setCheckedProfiles(profile);
        }
        super.loadPreference();
    }

    @Override
    protected void createTextFields(Composite inner) {
        super.createTextFields(inner);
        this.groupField = this.createBeanPropertyTextField(inner, (Object)this.args, PROP_GROUP, Messages.jclouds_groupLabel, Messages.jclouds_groupTooltip);
        this.userField = this.createBeanPropertyTextField(inner, (Object)this.args, PROP_USER, Messages.jclouds_userLabel, Messages.jclouds_userTooltip);
        this.passwordField = this.createBeanPropertyPasswordField(inner, (Object)this.args, PROP_PASSWORD, Messages.jclouds_passwordLabel, Messages.jclouds_passwordTooltip);
        this.zkPasswordField = this.createBeanPropertyPasswordField(inner, (Object)this.args, PROP_ZKPASSWORD, Messages.jclouds_zkPasswordLabel, Messages.jclouds_zkPasswordTooltip);
        this.locationField = this.createBeanPropertyCombo(inner, (Object)this.args, PROP_LOCATION, Messages.jclouds_locationIdLabel, Messages.jclouds_locationIdTooltip, (List<?>)this.getLocationList());
        this.locationField.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CloudContainerDetailsForm.this.isAWSEC2) {
                    return;
                }
                CloudContainerDetailsForm.this.imageField.setFilters(new ViewerFilter[0]);
                CloudContainerDetailsForm.this.imageFilter = new ImageViewerFilter(CloudContainerDetailsForm.this.locationField.getCombo().getText());
                CloudContainerDetailsForm.this.imageField.setFilters(new ViewerFilter[]{CloudContainerDetailsForm.this.imageFilter});
            }
        });
        this.hardwareField = this.createBeanPropertyCombo(inner, (Object)this.args, PROP_HARDWARE, Messages.jclouds_hardwareIdLabel, Messages.jclouds_hardwareIdTooltip, (List<?>)this.getHardwareList());
        this.osFamilyField = this.createBeanPropertyCombo(inner, (Object)this.args, PROP_OS_FAMILY, Messages.jclouds_osFamilyLabel, Messages.jclouds_osFamilyTooltip, this.getOSFamilyList());
        this.osFamilyField.addSelectionChangedListener(this.selectionListener);
        this.osVersionField = this.createBeanPropertyCombo(inner, (Object)this.args, PROP_OS_VERSION, Messages.jclouds_osVersionLabel, Messages.jclouds_osVersionTooltip, this.getOSVersionList());
        this.osVersionField.addSelectionChangedListener(this.selectionListener);
        this.imageField = this.createBeanPropertyCombo(inner, (Object)this.args, PROP_IMAGE, Messages.jclouds_imageIdLabel, Messages.jclouds_imageIdTooltip, (List<?>)this.getImageList());
        this.imageField.addSelectionChangedListener(this.selectionListener);
        Composite btn_bar = new Composite(inner, 0);
        btn_bar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 2, 1));
        btn_bar.setLayout((Layout)new FillLayout(256));
        Button btn_Clear = new Button(btn_bar, 8);
        btn_Clear.setText(Messages.clearLabel);
        btn_Clear.setToolTipText(Messages.clearTooltip);
        btn_Clear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CloudContainerDetailsForm.this.reset();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button btn_Reset = new Button(btn_bar, 8);
        btn_Reset.setText(Messages.defaultsLabel);
        btn_Reset.setToolTipText(Messages.defaultsTooltip);
        btn_Reset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CloudContainerDetailsForm.this.reset();
                CloudContainerDetailsForm.this.restoreAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setCloudDataInputs();
    }

    protected void setCloudDataInputs() {
        this.setInput(this.imageField, this.getImageList());
        this.setInput(this.hardwareField, this.getHardwareList());
        this.setInput(this.locationField, this.getLocationList());
        this.osFamilyField.setInput((Object)this.getOSFamilyList());
        this.osVersionField.setInput((Object)this.getOSVersionList());
    }

    private void reset() {
        this.imageField.setSelection(null);
        this.hardwareField.setSelection(null);
        this.locationField.setSelection(null);
        this.osFamilyField.setSelection(null);
        this.osVersionField.setSelection(null);
        if (this.fabric != null) {
            this.args.setUser(this.fabric.getUserName());
        } else {
            this.args.setUser("admin");
        }
        this.groupField.setText("");
        this.userField.setText("");
        this.passwordField.setText("");
        this.zkPasswordField.setText("");
    }

    private void restoreAll() {
        this.restoreSettings();
        this.restoreSettings(this.hardwareField);
        this.restoreSettings(this.locationField);
        this.restoreSettings(this.imageField);
    }

    protected ComboViewer createBeanPropertyCombo(Composite parent, Object bean, String propertyName, String labelText, String tooltip, List<?> input) {
        ComboViewer answer = this.createBeanPropertyCombo(parent, bean, propertyName, labelText, tooltip, 2056);
        answer.setInput(input);
        answer.setLabelProvider((IBaseLabelProvider)JCloudsLabelProvider.getInstance());
        return answer;
    }

    @Override
    public void okPressed() {
    }

    @Override
    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return valid;
        }
        String imgTxt = this.imageField.getCombo().getText();
        String osFamTxt = this.osFamilyField.getCombo().getText();
        if (imgTxt.trim().length() > 0 || osFamTxt.trim().length() > 0) {
            return valid;
        }
        return false;
    }

    @Override
    protected String getFormHeader() {
        return Messages.createCloudContainerDetailsFormHeaderLabel;
    }

    @Override
    protected String getSectionHeader() {
        return Messages.createCloudContainerDetailsFormSectionHeaderLabel;
    }

    public void saveSettings() {
        if (!this.userField.isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_USER, this.userField.getText());
        }
        if (!this.passwordField.isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_PASSWORD, this.passwordField.getText());
        }
        if (!this.zkPasswordField.isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_ZKPASSWORD, this.zkPasswordField.getText());
        }
        if (!this.groupField.isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_GROUP, this.groupField.getText());
        }
        if (!this.imageField.getCombo().isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_IMAGE, this.imageField.getCombo().getText());
        }
        if (!this.hardwareField.getCombo().isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_HARDWARE, this.hardwareField.getCombo().getText());
        }
        if (!this.locationField.getCombo().isDisposed()) {
            this.cloudCacheData.getDetails().addSetting(PROP_LOCATION, this.locationField.getCombo().getText());
        }
        if (!this.osFamilyField.getCombo().isDisposed()) {
            this.cloudCacheData.getDetails().addSetting("osfamily", this.osFamilyField.getCombo().getText());
        }
        if (!this.osVersionField.getCombo().isDisposed()) {
            this.cloudCacheData.getDetails().addSetting("osversion", this.osVersionField.getCombo().getText());
        }
        this.cloudCacheData.getDetails().flush();
    }

    public void restoreSettings(final ComboViewer viewer) {
        if (this.cloudCacheData == null || this.cloudCacheData.getDetails() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (viewer.getCombo().isDisposed()) {
                    return;
                }
                if (viewer.equals(CloudContainerDetailsForm.this.hardwareField)) {
                    CloudContainerDetailsForm.this.preSelectItem(CloudContainerDetailsForm.this.hardwareField, CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_HARDWARE, CloudContainerDetailsForm.this.hardwareField.getCombo().getText()));
                } else if (viewer.equals(CloudContainerDetailsForm.this.locationField)) {
                    CloudContainerDetailsForm.this.preSelectItem(CloudContainerDetailsForm.this.locationField, CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_LOCATION, CloudContainerDetailsForm.this.locationField.getCombo().getText()));
                } else if (viewer.equals(CloudContainerDetailsForm.this.hardwareField)) {
                    CloudContainerDetailsForm.this.preSelectItem(CloudContainerDetailsForm.this.imageField, CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_IMAGE, CloudContainerDetailsForm.this.imageField.getCombo().getText()));
                }
                CloudContainerDetailsForm.this.validate();
            }
        });
    }

    public void restoreSettings() {
        if (this.cloudCacheData.getDetails() == null) {
            return;
        }
        this.isAWSEC2 = this.cloudCacheData.getDetails().getProviderId().equals("aws-ec2");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CloudContainerDetailsForm.this.userField.isDisposed()) {
                    CloudContainerDetailsForm.this.userField.setText(CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_USER, CloudContainerDetailsForm.this.userField.getText()));
                }
                if (!CloudContainerDetailsForm.this.passwordField.isDisposed()) {
                    CloudContainerDetailsForm.this.passwordField.setText(CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_PASSWORD, CloudContainerDetailsForm.this.passwordField.getText()));
                }
                if (!CloudContainerDetailsForm.this.zkPasswordField.isDisposed()) {
                    CloudContainerDetailsForm.this.zkPasswordField.setText(CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_ZKPASSWORD, CloudContainerDetailsForm.this.zkPasswordField.getText()));
                }
                if (!CloudContainerDetailsForm.this.groupField.isDisposed()) {
                    CloudContainerDetailsForm.this.groupField.setText(CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting(CloudContainerDetailsForm.PROP_GROUP, CloudContainerDetailsForm.this.groupField.getText()));
                }
                if (!CloudContainerDetailsForm.this.osFamilyField.getCombo().isDisposed()) {
                    CloudContainerDetailsForm.this.preSelectItem(CloudContainerDetailsForm.this.osFamilyField, CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting("osfamily", CloudContainerDetailsForm.this.osFamilyField.getCombo().getText()));
                }
                if (!CloudContainerDetailsForm.this.osVersionField.getCombo().isDisposed()) {
                    CloudContainerDetailsForm.this.preSelectItem(CloudContainerDetailsForm.this.osVersionField, CloudContainerDetailsForm.this.cloudCacheData.getDetails().getSetting("osversion", CloudContainerDetailsForm.this.osVersionField.getCombo().getText()));
                }
            }
        });
    }

    private void preSelectItem(ComboViewer viewer, String itemToSelect) {
        for (Object o : (List)viewer.getInput()) {
            String oName = JCloudsLabelProvider.getInstance().getText(o);
            if (!oName.equals(itemToSelect)) continue;
            viewer.setSelection((ISelection)new StructuredSelection(o), true);
        }
    }

    private class ImageViewerFilter
    extends ViewerFilter {
        private String selectedLocation;

        public ImageViewerFilter(String filter) {
            this.selectedLocation = filter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.selectedLocation == null || this.selectedLocation.trim().length() < 1) {
                return true;
            }
            return ((Image)element).getId().startsWith(this.selectedLocation);
        }
    }
}

