/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.navigator.ProfileNode;
import org.fusesource.ide.fabric.navigator.VersionNode;

public class ProfileAddAction
extends Action {
    private final VersionNode versionNode;
    private ProfileNode profileNode;

    public ProfileAddAction(VersionNode versionNode) {
        super(Messages.profileAddLabel);
        this.versionNode = versionNode;
        this.setToolTipText(Messages.profileAddTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("new_profile.png"));
    }

    public ProfileAddAction(ProfileNode profileNode) {
        this(profileNode.getVersionNode());
        this.profileNode = profileNode;
    }

    public void run() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.profileAddDialogTitle, Messages.profileAddDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getValue();
            this.createProfile(name);
        }
    }

    protected void createProfile(String name) {
        String versionId = this.versionNode.getVersionId();
        FabricService service = this.versionNode.getFabric().getFabricService();
        Profile profile = service.getVersion(versionId).createProfile(name);
        if (this.profileNode != null) {
            Profile parentProfile = this.profileNode.getProfile();
            profile.setParents(new Profile[]{parentProfile});
        }
        this.versionNode.refresh();
    }
}

