/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.HasViewer;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.config.ConfigurationDetails;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.FabricDetails;
import org.fusesource.ide.fabric.actions.FabricDetailsDialog;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.Fabrics;

public class FabricDetailsAddAction
extends Action {
    private final Fabrics fabrics;

    public FabricDetailsAddAction(Fabrics fabrics) {
        super(Messages.fabricAddButton);
        this.fabrics = fabrics;
        this.setToolTipText(Messages.fabricAddButtonTooktip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("new_fabric.png"));
    }

    public void run() {
        FabricDetailsDialog dialog = new FabricDetailsDialog(){

            protected void okPressed() {
                FabricDetails details = this.getFabricDetails();
                FabricDetailsAddAction.this.addCloud(details);
                super.okPressed();
            }
        };
        dialog.open();
    }

    public void addCloud(FabricDetails details) {
        if (!FabricDetails.getDetailList().contains((Object)details)) {
            Fabric node = this.fabrics.addFabric(details);
            Viewer viewer = this.fabrics.getViewer();
            Viewers.expand((Viewer)viewer, (Object)node, (int)2);
            FabricDetails.getDetailList().add((Object)details);
            this.onFabricDetailsAdded(details);
        }
    }

    protected void onFabricDetailsAdded(ConfigurationDetails details) {
        RefreshableUI refreshableUI = this.fabrics.getRefreshableUI();
        if (refreshableUI instanceof HasViewer) {
            HasViewer v = (HasViewer)refreshableUI;
            v.getViewer().setSelection((ISelection)new StructuredSelection((Object)details));
        }
    }
}

