/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions;

import org.eclipse.jface.action.Action;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.fabric.FabricConnector;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.navigator.Fabric;

public class FabricConnectAction
extends Action {
    private Fabric fabric;

    public FabricConnectAction(Fabric fabric) {
        super(Messages.fabricConnectButton);
        this.setToolTipText(Messages.fabricConnectButtonTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("connect.gif"));
        this.fabric = fabric;
    }

    public boolean isEnabled() {
        return this.fabric != null && !this.fabric.isConnected();
    }

    public void run() {
        if (this.fabric == null) {
            return;
        }
        Jobs.schedule((String)("Connecting to Fabric at " + this.fabric.getDetails().getUrls() + " ..."), (Runnable)new Runnable(){

            @Override
            public void run() {
                FabricConnectAction.this.fabric.setConnector(new FabricConnector(FabricConnectAction.this.fabric));
                FabricConnectAction.this.fabric.onConnect();
                FabricConnectAction.this.fabric.refresh();
            }
        });
    }
}

