/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.VersionNode;

public class DeleteVersionAction
extends Action {
    private final Fabric fabric;
    private VersionNode versionNode;

    public DeleteVersionAction(VersionNode versionNode) {
        this.init();
        this.versionNode = versionNode;
        this.fabric = versionNode.getFabric();
    }

    private void init() {
        this.setText(Messages.deleteVersionMenuLabel);
        this.setToolTipText(Messages.deleteVersionDescription);
        this.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("delete.gif"));
    }

    public boolean isEnabled() {
        return this.isDeletePossible();
    }

    private boolean isDeletePossible() {
        return false;
    }

    public void run() {
        if (MessageDialog.openQuestion((Shell)Shells.getShell(), (String)Messages.deleteVersionDialogTitle, (String)Messages.deleteVersionDialogMessage)) {
            this.deleteVersion();
        }
    }

    protected void deleteVersion() {
        FabricPlugin.getLogger().debug("Deleting version " + this.versionNode.getVersionId() + "...");
        this.fabric.getFabricService().deleteVersion(this.versionNode.getVersionId());
        this.fabric.getVersionsNode().refresh();
    }
}

