/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.ProfileStatus;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.properties.PropertySheet;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.FabricTabViewPage;

public class DeleteProfileRequirementAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection isel = (IStructuredSelection)sel;
            for (Object o : isel.toList()) {
                if (!(o instanceof ProfileStatus)) continue;
                this.deleteRequirementsForProfile(event, ((ProfileStatus)o).getProfile());
            }
        }
        return null;
    }

    private void deleteRequirementsForProfile(ExecutionEvent event, String profileId) {
        Fabric fabricNode = this.getSelectedFabric();
        FabricRequirements reqs = fabricNode.getFabricService().getRequirements();
        try {
            if (reqs.findProfileRequirements(profileId) != null) {
                reqs.removeProfileRequirements(profileId);
                return;
            }
        }
        finally {
            block21: {
                PropertySheet ps;
                try {
                    try {
                        fabricNode.getFabricService().setRequirements(reqs);
                    }
                    catch (IOException ex) {
                        PropertySheet ps2;
                        FabricPlugin.getLogger().error((Throwable)ex);
                        IWorkbenchPart wp = HandlerUtil.getActivePart((ExecutionEvent)event);
                        if (wp instanceof PropertySheet && (ps2 = (PropertySheet)wp).getCurrentPage() instanceof FabricTabViewPage) {
                            FabricTabViewPage ftvp = (FabricTabViewPage)ps2.getCurrentPage();
                            ftvp.refresh();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    PropertySheet ps3;
                    IWorkbenchPart wp = HandlerUtil.getActivePart((ExecutionEvent)event);
                    if (wp instanceof PropertySheet && (ps3 = (PropertySheet)wp).getCurrentPage() instanceof FabricTabViewPage) {
                        FabricTabViewPage ftvp = (FabricTabViewPage)ps3.getCurrentPage();
                        ftvp.refresh();
                    }
                    throw throwable;
                }
                IWorkbenchPart wp = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (wp instanceof PropertySheet && (ps = (PropertySheet)wp).getCurrentPage() instanceof FabricTabViewPage) {
                    FabricTabViewPage ftvp = (FabricTabViewPage)ps.getCurrentPage();
                    ftvp.refresh();
                }
            }
        }
    }

    private Fabric getSelectedFabric() {
        Fabric f = null;
        Object selectedFabricObject = Selections.getFirstSelection((ISelection)FabricPlugin.getFabricNavigator().getCommonViewer().getSelection());
        if (selectedFabricObject != null && selectedFabricObject instanceof Fabric) {
            f = (Fabric)selectedFabricObject;
        }
        return f;
    }
}

