/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.actions;

import com.google.common.base.Supplier;
import io.fabric8.api.Version;
import io.fabric8.api.VersionSequence;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.Messages;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.fusesource.ide.fabric.navigator.Fabrics;
import org.fusesource.ide.fabric.navigator.VersionNode;
import org.fusesource.ide.fabric.navigator.VersionsNode;

public class CreateVersionAction
extends Action {
    private final Supplier<Version> oldVersionSupplier;
    private final Fabric fabric;

    public CreateVersionAction(VersionsNode versionsNode) {
        this.init();
        this.fabric = versionsNode.getFabric();
        this.oldVersionSupplier = new Supplier<Version>(){

            public Version get() {
                return CreateVersionAction.this.getLatestVersion();
            }
        };
    }

    public CreateVersionAction(final VersionNode versionNode) {
        this.init();
        this.fabric = versionNode.getFabric();
        this.oldVersionSupplier = new Supplier<Version>(){

            public Version get() {
                return versionNode.getVersion();
            }
        };
    }

    private void init() {
        this.setText(Messages.createVersionMenuLabel);
        this.setToolTipText(Messages.createVersionDescription);
        this.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("new_version.png"));
    }

    public void run() {
        InputDialog dialog;
        int result;
        VersionSequence next;
        String defaultValue = "";
        Version latestVersion = this.getLatestVersion();
        if (latestVersion != null && (next = latestVersion.getSequence().next()) != null) {
            defaultValue = next.getName();
        }
        if ((result = (dialog = new InputDialog(Shells.getShell(), Messages.createVersionDialogTitle, Messages.createVersionDialogMessage, defaultValue, null)).open()) == 0) {
            String newVersion = dialog.getValue();
            this.createVersion(newVersion);
        }
    }

    protected void createVersion(String newVersion) {
        Version oldVersion = (Version)this.oldVersionSupplier.get();
        FabricPlugin.getLogger().debug("Creating new version " + newVersion + " from old " + Fabrics.getVersionName(oldVersion));
        if (oldVersion != null) {
            this.fabric.getFabricService().createVersion(oldVersion, newVersion);
        } else {
            this.fabric.getFabricService().createVersion(newVersion);
        }
        this.fabric.getVersionsNode().refresh();
    }

    public Version getLatestVersion() {
        return Fabrics.getLatestVersion(this.fabric.getFabricService());
    }
}

