/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric;

import io.fabric8.api.FabricException;
import io.fabric8.service.JmxTemplateSupport;
import io.fabric8.service.LocalJMXConnector;
import javax.management.MBeanServerConnection;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.RethrowRuntimeException;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class JmxPluginJmxTemplate
extends JmxTemplateSupport {
    private final IConnectionWrapper connectionWrapper;

    public JmxPluginJmxTemplate(IConnectionWrapper connectionWrapper) {
        this.connectionWrapper = connectionWrapper;
    }

    public <T> T execute(final JmxTemplateSupport.JmxConnectorCallback<T> callback) {
        final Object[] answerHolder = new Object[1];
        try {
            this.connectionWrapper.run(new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws JMXException {
                    try {
                        Object answer;
                        LocalJMXConnector connector = null;
                        if (connector == null) {
                            connector = new LocalJMXConnector(connection);
                        }
                        answerHolder[0] = answer = callback.doWithJmxConnector(connector);
                    }
                    catch (Exception e) {
                        FabricPlugin.getLogger().warning("Failed to connect to JMX: " + e, (Throwable)e);
                    }
                }
            });
            return (T)answerHolder[0];
        }
        catch (Exception e) {
            throw new FabricException((Throwable)e);
        }
    }

    public <T> T executeAndThrow(final JmxTemplateSupport.JmxConnectorCallback<T> callback) throws Exception {
        final Object[] answerHolder = new Object[1];
        try {
            this.connectionWrapper.run(new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws JMXException {
                    try {
                        Object answer;
                        LocalJMXConnector connector = null;
                        if (connector == null) {
                            connector = new LocalJMXConnector(connection);
                        }
                        answerHolder[0] = answer = callback.doWithJmxConnector(connector);
                    }
                    catch (Exception e) {
                        throw new RethrowRuntimeException(e);
                    }
                }
            });
            return (T)answerHolder[0];
        }
        catch (RethrowRuntimeException e) {
            e.rethrowCause();
            return null;
        }
    }
}

