/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.FabricStatus;
import io.fabric8.api.Version;
import io.fabric8.jolokia.facade.JolokiaFabricConnector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.ui.statushandlers.StatusManager;
import org.fusesource.ide.fabric.FabricNotConnectedException;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.actions.FabricDetails;
import org.fusesource.ide.fabric.navigator.Fabric;
import org.osgi.framework.BundleContext;

public class FabricConnector {
    private final Fabric fabric;
    private final FabricDetails details;
    private final String url;
    private FabricService fabricService;
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean connected = new AtomicBoolean(false);
    private JolokiaFabricConnector connector;

    public FabricConnector(Fabric fabric) {
        this.fabric = fabric;
        this.details = fabric.getDetails();
        this.url = this.details.getUrls();
    }

    protected void initialised() throws Exception {
        FabricPlugin.getLogger().debug("Starting to connect Fabric on: " + this.url);
        this.connector = JolokiaFabricConnector.getFabricConnector((String)this.details.getUserName(), (String)this.details.getPassword(), (String)this.details.getUrls());
        if (this.fabricService == null) {
            this.fabricService = this.connector.getFabricServiceFacade();
        }
        this.checkConnected();
    }

    public Container[] getAgents() {
        FabricService service = this.getFabricService();
        if (service == null) {
            return null;
        }
        return service.getContainers();
    }

    public Version[] getVersions() {
        FabricService service = this.getFabricService();
        if (service == null) {
            return null;
        }
        return service.getVersions();
    }

    public BundleContext getBundleContext() {
        return FabricPlugin.getDefault().getBundle().getBundleContext();
    }

    public String getName() {
        return this.details.getName();
    }

    public String getUrl() {
        return this.url;
    }

    public String getDefaultVersionId() {
        Version defaultVersion;
        FabricService service = this.getFabricService();
        if (service != null && (defaultVersion = service.getDefaultVersion()) != null) {
            return defaultVersion.getId();
        }
        return null;
    }

    public JolokiaFabricConnector getConnector() {
        return this.connector;
    }

    public FabricService getFabricService() {
        this.checkConnected();
        return this.fabricService;
    }

    public void checkConnected() {
        if (this.initialised.compareAndSet(false, true)) {
            try {
                this.initialised();
            }
            catch (Exception e) {
                FabricNotConnectedException fnce = new FabricNotConnectedException(this, e);
                MultiStatus status = new MultiStatus("org.fusesource.ide.fabric", 1, "Unable to connect to Fabric. Please make sure Fabric is running on the specified host, the used ports are not blocked and the ZooKeeper password is correct.", (Throwable)fnce);
                StatusManager.getManager().handle((IStatus)status, 2);
                this.fabric.onDisconnect();
                throw fnce;
            }
        }
        try {
            FabricStatus status = this.fabricService.getFabricStatus();
            this.connected.set(status != null);
        }
        catch (Exception ex) {
            this.connected.set(false);
            throw new FabricNotConnectedException(this, ex);
        }
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public boolean isConnected() {
        try {
            this.checkConnected();
        }
        catch (Exception e) {
            FabricPlugin.getLogger().debug("Fabric " + this + " is not connected  " + e);
            this.fabric.onDisconnect();
            return false;
        }
        return this.connected.get();
    }

    public void dispose() {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        this.connector = null;
        this.fabricService = null;
    }
}

