(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("../lib/infer"), require("../lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define(["../lib/infer", "../lib/tern"], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";
  
  function Component() {
    this.use = null;
  }
  
  function getComponent(data, name) {
    return data.components[name];// || (data.modules[name] = new infer.AVal);
  }
  
  function Module() {
    this.def = null;
    this.requires = null;
  }
  
  function getOrCreateModule(data, name) {
    var module = data.modules[name];
    if (!module) {
      module = new Module();
      data.modules[name] = module;
    }
    return module;
  }
  
  function getModule(data, name) {
    if (!data.initialized) {
      //infer.def.load(yuiOop);
      //infer.def.load(yuiEventAndNode);
      data.initialized = true;
    }    
    return data.modules[name];// || (data.modules[name] = new infer.AVal);
  }
  
  function injectModule(Y, name) {
    var cx = infer.cx(), server = cx.parent, data = server._yui, module = getModule(data, name);
    if (module) { 
      var def = module.def, requires = module.requires;
      if (def) {
        def.getType().propagate(Y);        
      }
      if (requires) {
        for ( var i = 0; i < requires.length; i++) {
          var moduleName = requires[i];
          injectModule(Y, moduleName);
        }
      }
    } else {
      var component = getComponent(data, name);
      if (component && component.use) {
        for ( var i = 0; i < component.use.length; i++) {
          var moduleName = component.use[i];
          injectModule(Y, moduleName);
        }
      }
    }
  }
  
  function getFnIndex(argNodes) {
    for ( var i = 0; i < argNodes.length; i++) {
      if (argNodes[i].type == "FunctionExpression") {
        return i;
      }
    }
  }
  
  infer.registerFunction("yui_add", function(self, args, argNodes) {
    var yui = self.getType();
    if (yui && argNodes) {
      var index = getFnIndex(argNodes);
      if (index) {
        var fn = args[index];
        if (fn.argNames  && fn.argNames.length > 0) {        
          var Y = fn.args[0];
          yui.getProp("prototype").getType().propagate(Y); 
        }
      }      
    }
  });
  
  infer.registerFunction("yui_use", function(self, args, argNodes) {
    var yui = self.getType();
    if (yui && argNodes) {
      var index = getFnIndex(argNodes);
      if (index) {
        var fn = args[index];
        if (fn.argNames  && fn.argNames.length > 0) {              
          var Y = fn.args[0];
          Y.getType = function(guess) {
              if (this.types.length == 0 && guess !== false) return this.makeupType();
              if (this.types.length == 1) return this.types[0];
              return this;
          }
          yui.propagate(Y);        
          
          var cx = infer.cx(), defs = cx.definitions["yui"];
          for ( var name in defs) {
              defs[name].getType().propagate(Y);
          }
          
          for ( var i = 0; i < argNodes.length - 1; i++) {
            var node = argNodes[i];
            if (node.type == "Literal" && typeof node.value == "string") {
              injectModule(Y, node.value);
            } else if (node.type == "ArrayExpression") for (var i = 0; i < node.elements.length; ++i) {
              var elt = node.elements[i];
              if (elt.type == "Literal" && typeof elt.value == "string") {
                injectModule(Y, elt.value);
              }
            }
          }
        }        
      }
    }
  });
  
  function preCondenseReach(state) {
    
  }

  function postLoadDef(json) {
    var cx = infer.cx(), defName = json["!name"], defs = cx.definitions[defName], server = cx.parent, _yui = server._yui, yuiModule = defName && defName.slice(0, 'yui-'.length) == 'yui-';
    if (defs && yuiModule) for (var name in defs) {
      var obj = defs[name].getType();
      if (obj.metaData) {
        // it's a component
        var metaData = obj.metaData, componentName = null;
        for ( componentName in metaData) {
          var c = metaData[componentName];
          for(var prop in c) {
            switch(prop) {
            case 'plugins':
              break;
            case 'submodules':
              var submodules = c[prop];
              for ( var submoduleName in submodules) {
                var submodule = submodules[submoduleName];
                var module = getOrCreateModule(_yui, submoduleName);
                module.requires = submodule.requires;
              }
              break;
            case 'use':
              var component = new Component();
              component.use = c[prop];
              _yui.components[componentName] = component;
              break;            
            }
          } 
        }       
      } else {
        // it's a module
        var moduleName = name.replace(/_/g, '-')
        var module = getOrCreateModule(_yui, moduleName);
        module.def = obj;
      }
    }
  }

  tern.registerPlugin("yui", function(server, options) {
    server._yui = {
        components: Object.create(null),
        modules: Object.create(null)
    };
    
    server.on("reset", function() {
      this._yui.initialized = false;
      this._yui.modules = Object.create(null);      
    });
    
    return {
      defs: defs,
      passes: {
        preCondenseReach: preCondenseReach,
        postLoadDef: postLoadDef
      },
    };
  });
  
  var defs = {
 "!name": "yui",
 "!define": {
  "anim": {
   "Anim": {
    "!type": "fn() -> +anim.Anim",
    "!proto": "base.Base",
    "!doc": "A class for constructing animation instances.",
    "!url": "http://yuilibrary.com/classes/Anim.html",
    "getBezier": {
     "!type": "fn(points: [number], t: number) -> [number]",
     "!doc": "Get the current position of the animated element based on t.\nEach point is an array of \"x\" and \"y\" values (0 = x, 1 = y)\nAt least 2 points are required (start and end).\nFirst point is start. Last point is end.\nAdditional control points are optional.",
     "!url": "http://yuilibrary.com/classes/Anim.html#method_getBezier"
    },
    "prototype": {
     "start": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation begins.",
      "!url": "http://yuilibrary.com/classes/Anim.html#event_start"
     },
     "tween": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires every frame of the animation.",
      "!url": "http://yuilibrary.com/classes/Anim.html#event_tween"
     },
     "end": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires after the animation completes.",
      "!url": "http://yuilibrary.com/classes/Anim.html#event_end"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The object to be animated.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_node"
     },
     "duration": {
      "!type": "fn()",
      "!doc": "The length of the animation.  Defaults to \"1\" (second).",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_duration"
     },
     "easing": {
      "!type": "fn()",
      "!doc": "The method that will provide values to the attribute(s) during the animation.\nDefaults to \"Easing.easeNone\".",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_easing"
     },
     "from": {
      "!type": "fn()",
      "!doc": "The starting values for the animated properties.\n\nFields may be strings, numbers, or functions.\nIf a function is used, the return value becomes the from value.\nIf no from value is specified, the DEFAULT_GETTER will be used.\nSupports any unit, provided it matches the \"to\" (or default)\nunit (e.g. `{width: '10em', color: 'rgb(0, 0, 0)', borderColor: '#ccc'}`).\n\nIf using the default ('px' for length-based units), the unit may be omitted\n(e.g. `{width: 100}, borderColor: 'ccc'}`, which defaults to pixels\nand hex, respectively).",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_from"
     },
     "to": {
      "!type": "fn()",
      "!doc": "The ending values for the animated properties.\n\nFields may be strings, numbers, or functions.\nSupports any unit, provided it matches the \"from\" (or default)\nunit (e.g. `{width: '50%', color: 'red', borderColor: '#ccc'}`).\n\nIf using the default ('px' for length-based units), the unit may be omitted\n(e.g. `{width: 100, borderColor: 'ccc'}`, which defaults to pixels\nand hex, respectively).",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_to"
     },
     "startTime": {
      "!type": "fn()",
      "!doc": "Date stamp for the first frame of the animation.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_startTime"
     },
     "elapsedTime": {
      "!type": "fn()",
      "!doc": "Current time the animation has been running.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_elapsedTime"
     },
     "running": {
      "!type": "fn()",
      "!doc": "Whether or not the animation is currently running.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_running"
     },
     "iterations": {
      "!type": "fn()",
      "!doc": "The number of times the animation should run",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_iterations"
     },
     "iterationCount": {
      "!type": "fn()",
      "!doc": "The number of iterations that have occurred.\nResets when an animation ends (reaches iteration count or stop() called).",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_iterationCount"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "How iterations of the animation should behave.\nPossible values are \"normal\" and \"alternate\".\nNormal will repeat the animation, alternate will reverse on every other pass.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_direction"
     },
     "paused": {
      "!type": "fn()",
      "!doc": "Whether or not the animation is currently paused.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_paused"
     },
     "reverse": {
      "!type": "fn()",
      "!doc": "If true, the `from` and `to` attributes are swapped, \nand the animation is then run starting from `from`.",
      "!url": "http://yuilibrary.com/classes/Anim.html#attribute_reverse"
     },
     "run": {
      "!type": "fn() -> !this",
      "!doc": "Starts or resumes an animation.",
      "!url": "http://yuilibrary.com/classes/Anim.html#method_run"
     },
     "pause": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation is paused.",
      "!url": "http://yuilibrary.com/classes/Anim.html#event_pause"
     },
     "stop": {
      "!type": "fn(finish: bool) -> !this",
      "!doc": "Stops the animation and resets its time.",
      "!url": "http://yuilibrary.com/classes/Anim.html#method_stop"
     },
     "resume": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation is resumed (run from pause).",
      "!url": "http://yuilibrary.com/classes/Anim.html#event_resume"
     },
     "iteration": {
      "!type": "fn(ev: event.Event)",
      "!doc": "fires when an animation begins an iteration.",
      "!url": "http://yuilibrary.com/classes/Anim.html#event_iteration"
     }
    },
    "RE_DEFAULT_UNIT": {
     "!type": "?",
     "!doc": "Regex of properties that should use the default unit.",
     "!url": "http://yuilibrary.com/classes/Anim.html#property_RE_DEFAULT_UNIT"
    },
    "DEFAULT_UNIT": {
     "!type": "?",
     "!doc": "The default unit to use with properties that pass the RE_DEFAULT_UNIT test.",
     "!url": "http://yuilibrary.com/classes/Anim.html#property_DEFAULT_UNIT"
    },
    "intervalTime": {
     "!type": "?",
     "!doc": "Time in milliseconds passed to setInterval for frame processing",
     "!url": "http://yuilibrary.com/classes/Anim.html#property_intervalTime"
    },
    "behaviors": {
     "!type": "?",
     "!doc": "Bucket for custom getters and setters",
     "!url": "http://yuilibrary.com/classes/Anim.html#property_behaviors"
    },
    "DEFAULT_SETTER": {
     "!type": "?",
     "!doc": "The default setter to use when setting object properties.",
     "!url": "http://yuilibrary.com/classes/Anim.html#property_DEFAULT_SETTER"
    },
    "DEFAULT_GETTER": {
     "!type": "?",
     "!doc": "The default getter to use when getting object properties.",
     "!url": "http://yuilibrary.com/classes/Anim.html#property_DEFAULT_GETTER"
    },
    "run": {
     "!type": "fn()",
     "!doc": "Runs all animation instances.",
     "!url": "http://yuilibrary.com/classes/Anim.html#method_run"
    },
    "pause": {
     "!type": "fn()",
     "!doc": "Pauses all animation instances.",
     "!url": "http://yuilibrary.com/classes/Anim.html#method_pause"
    },
    "stop": {
     "!type": "fn()",
     "!doc": "Stops all animation instances.",
     "!url": "http://yuilibrary.com/classes/Anim.html#method_stop"
    }
   },
   "Easing": {
    "!type": "fn()",
    "!doc": "The easing module provides methods for customizing\nhow an animation behaves during each run.",
    "!url": "http://yuilibrary.com/classes/Easing.html",
    "prototype": {
     "easeNone": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Uniform speed between points.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeNone"
     },
     "easeIn": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and accelerates towards end. (quadratic)",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeIn"
     },
     "easeOut": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins quickly and decelerates towards end.  (quadratic)",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeOut"
     },
     "easeBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and decelerates towards end. (quadratic)",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeBoth"
     },
     "easeInStrong": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and accelerates towards end. (quartic)",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeInStrong"
     },
     "easeOutStrong": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins quickly and decelerates towards end.  (quartic)",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeOutStrong"
     },
     "easeBothStrong": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Begins slowly and decelerates towards end. (quartic)",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_easeBothStrong"
     },
     "elasticIn": {
      "!type": "fn(t: number, b: number, c: number, d: number, a: number, p: number) -> number",
      "!doc": "Snap in elastic effect.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_elasticIn"
     },
     "elasticOut": {
      "!type": "fn(t: number, b: number, c: number, d: number, a: number, p: number) -> number",
      "!doc": "Snap out elastic effect.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_elasticOut"
     },
     "elasticBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number, a: number, p: number) -> number",
      "!doc": "Snap both elastic effect.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_elasticBoth"
     },
     "backIn": {
      "!type": "fn(t: number, b: number, c: number, d: number, s: number) -> number",
      "!doc": "Backtracks slightly, then reverses direction and moves to end.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_backIn"
     },
     "backOut": {
      "!type": "fn(t: number, b: number, c: number, d: number, s: number) -> number",
      "!doc": "Overshoots end, then reverses and comes back to end.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_backOut"
     },
     "backBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number, s: number) -> number",
      "!doc": "Backtracks slightly, then reverses direction, overshoots end,\nthen reverses and comes back to end.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_backBoth"
     },
     "bounceIn": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Bounce off of start.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_bounceIn"
     },
     "bounceOut": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Bounces off end.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_bounceOut"
     },
     "bounceBoth": {
      "!type": "fn(t: number, b: number, c: number, d: number) -> number",
      "!doc": "Bounces off start and end.",
      "!url": "http://yuilibrary.com/classes/Easing.html#method_bounceBoth"
     }
    }
   }
  },
  "app": {
   "App.Content": {
    "!type": "fn()",
    "!doc": "`Y.App` extension that provides pjax-style content fetching and handling.\n\nThis makes it easy to fetch server rendered content for URLs using Ajax. The\nHTML content returned from the server will be view-ified and set as the app's\nmain content, making it seamless to use a mixture of server and client rendered\nviews.\n\nWhen the `\"app-content\"` module is used, it will automatically mix itself into\n`Y.App`, and it provides three main features:\n\n  - **`Y.App.Content.route`**: A stack of middleware which forms a pjax-style\n    content route.\n\n  - **`loadContent()`**: Route middleware which load content from a server. This\n    makes an Ajax request for the requested URL, parses the returned content and\n    puts it on the route's response object.\n\n  - **`showContent()`**: Method which provides an easy way to view-ify HTML\n    content which should be shown as an app's active/visible view.\n\nThe following is an example of how these features can be used:\n\n    // Creates a new app and registers the `\"post\"` view.\n    var app = new Y.App({\n        views: {\n            post: {type: Y.PostView}\n        }\n    });\n\n    // Uses a simple server rendered content route for the About page.\n    app.route('/about/', Y.App.Content.route);\n\n    // Uses the `loadContent()` middleware to fetch the contents of the post\n    // from the server and shows that content in a `\"post\"` view.\n    app.route('/posts/:id/', 'loadContent', function (req, res, next) {\n        this.showContent(res.content.node, {view: 'post'});\n    });",
    "!url": "http://yuilibrary.com/classes/App.Content.html",
    "route": {
     "!type": "+yui.Array",
     "!doc": "A stack of middleware which forms a pjax-style content route.\n\nThis route will load the rendered HTML content from the server, then create and\nshow a new view using those contents.",
     "!url": "http://yuilibrary.com/classes/App.Content.html#property_route"
    },
    "prototype": {
     "showContent": {
      "!type": "fn(content: HTMLElement, options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Sets this app's `activeView` attribute using the specified `content`.\n\nThis provides an easy way to view-ify HTML content which should be shown as\nthis app's active/visible view. This method will determine the appropriate\nview `container` node based on the specified `content`. By default, a new\n`Y.View` instance will be created unless `options.view` is specified.\n\nUnder the hood, this method calls the `showView()` method, so refer to its\ndocs for more information.",
      "!url": "http://yuilibrary.com/classes/App.Content.html#method_showContent"
     }
    }
   },
   "App.Transitions": {
    "!type": "fn()",
    "!doc": "`Y.App` extension that provides view transitions in browsers which support\nnative CSS3 transitions.\n\nView transitions provide an nice way to move from one \"page\" to the next that is\nboth pleasant to the user and helps to communicate a hierarchy between sections\nof an application.\n\nWhen the `\"app-transitions\"` module is used, it will automatically mix itself\ninto `Y.App` and transition between `activeView` changes using the following\neffects:\n\n  - **`fade`**: Cross-fades between the old an new active views.\n\n  - **`slideLeft`**: The old and new active views are positioned next to each\n    other and both slide to the left.\n\n  - **`slideRight`**: The old and new active views are positioned next to each\n    other and both slide to the right.\n\n**Note:** Transitions are an opt-in feature and are enabled via an app's\n`transitions` attribute.",
    "!url": "http://yuilibrary.com/classes/App.Transitions.html",
    "prototype": {
     "transitions": {
      "!type": "+yui.Object",
      "!doc": "Default transitions to use when the `activeView` changes.\n\nThe following are types of changes for which transitions can be defined that\ncorrespond to the relationship between the new and previous `activeView`:\n\n  * `navigate`: The default transition to use when changing the `activeView`\n    of the application.\n\n  * `toChild`: The transition to use when the new `activeView` is configured\n    as a child of the previously active view via its `parent` property as\n    defined in this app's `views`.\n\n  * `toParent`: The transition to use when the new `activeView` is\n    configured as the `parent` of the previously active view as defined in\n    this app's `views`.\n\n**Note:** Transitions are an opt-in feature and will only be used in\nbrowsers which support native CSS3 transitions.",
      "!url": "http://yuilibrary.com/classes/App.Transitions.html#property_transitions"
     },
     "showView": {
      "!type": "fn(view: string, config?: yui.Object, options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Sets which view is active/visible for the application. This will set the\napp's `activeView` attribute to the specified `view`.\n\nThe `view` will be \"attached\" to this app, meaning it will be both rendered\ninto this app's `viewContainer` node and all of its events will bubble to\nthe app. The previous `activeView` will be \"detached\" from this app.\n\nWhen a string-name is provided for a view which has been registered on this\napp's `views` object, the referenced metadata will be used and the\n`activeView` will be set to either a preserved view instance, or a new\ninstance of the registered view will be created using the specified `config`\nobject passed-into this method.\n\nA callback function can be specified as either the third or fourth argument,\nand this function will be called after the new `view` becomes the\n`activeView`, is rendered to the `viewContainer`, and is ready to use.",
      "!url": "http://yuilibrary.com/classes/App.Transitions.html#method_showView"
     }
    },
    "FX": {
     "!type": "+yui.Object",
     "!doc": "Collect of transitions -> fx.\n\nA transition (e.g. \"fade\") is a simple name given to a configuration of fx to\napply, consisting of `viewIn` and `viewOut` properties who's values are names of\nfx registered on `Y.Transition.fx`.\n\nBy default transitions: `fade`, `slideLeft`, and `slideRight` have fx defined.",
     "!url": "http://yuilibrary.com/classes/App.Transitions.html#property_FX"
    }
   },
   "ModelSync.Local": {
    "!type": "fn()",
    "!doc": "An extension which provides a sync implementation through locally stored\nkey value pairs, either through the HTML localStorage API or falling back\nonto an in-memory cache, that can be mixed into a Model or ModelList subclass.\n\nA group of Models/ModelLists is serialized in localStorage by either its\nclass name, or a specified 'root' that is provided.\n\n    var User = Y.Base.create('user', Y.Model, [Y.ModelSync.Local], {\n        root: 'user'\n    });\n\n    var Users = Y.Base.create('users', Y.ModelList, [Y.ModelSync.Local], {\n        model: User,\n    });",
    "!url": "http://yuilibrary.com/classes/ModelSync.Local.html",
    "prototype": {
     "root": {
      "!type": "string",
      "!doc": "Root used as the key inside of localStorage and/or the in-memory store.",
      "!url": "http://yuilibrary.com/classes/ModelSync.Local.html#property_root"
     },
     "storage": {
      "!type": "+Storage",
      "!doc": "Shortcut for access to localStorage.",
      "!url": "http://yuilibrary.com/classes/ModelSync.Local.html#property_storage"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Creates a synchronization layer with the localStorage API, if available.\nOtherwise, falls back to a in-memory data store.\n\nThis method is called internally by load(), save(), and destroy().",
      "!url": "http://yuilibrary.com/classes/ModelSync.Local.html#method_sync"
     }
    }
   },
   "ModelSync.REST": {
    "!type": "fn()",
    "!doc": "An extension which provides a RESTful XHR sync implementation that can be mixed\ninto a Model or ModelList subclass.\n\nThis makes it trivial for your Model or ModelList subclasses communicate and\ntransmit their data via RESTful XHRs. In most cases you'll only need to provide\na value for `root` when sub-classing `Y.Model`.\n\n    Y.User = Y.Base.create('user', Y.Model, [Y.ModelSync.REST], {\n        root: '/users'\n    });\n\n    Y.Users = Y.Base.create('users', Y.ModelList, [Y.ModelSync.REST], {\n        // By convention `Y.User`'s `root` will be used for the lists' URL.\n        model: Y.User\n    });\n\n    var users = new Y.Users();\n\n    // GET users list from: \"/users\"\n    users.load(function () {\n        var firstUser = users.item(0);\n\n        firstUser.get('id'); // => \"1\"\n\n        // PUT updated user data at: \"/users/1\"\n        firstUser.set('name', 'Eric').save();\n    });",
    "!url": "http://yuilibrary.com/classes/ModelSync.REST.html",
    "CSRF_TOKEN": {
     "!type": "string",
     "!doc": "A request authenticity token to validate HTTP requests made by this extension\nwith the server when the request results in changing persistent state. This\nallows you to protect your server from Cross-Site Request Forgery attacks.\n\nA CSRF token provided by the server can be embedded in the HTML document and\nassigned to `YUI.Env.CSRF_TOKEN` like this:\n\n    <script>\n        YUI.Env.CSRF_TOKEN = {{session.authenticityToken}};\n    </script>\n\nThe above should come after YUI seed file so that `YUI.Env` will be defined.\n\n**Note:** This can be overridden on a per-request basis. See `sync()` method.\n\nWhen a value for the CSRF token is provided, either statically or via `options`\npassed to the `save()` and `destroy()` methods, the applicable HTTP requests\nwill have a `X-CSRF-Token` header added with the token value.",
     "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_CSRF_TOKEN"
    },
    "EMULATE_HTTP": {
     "!type": "bool",
     "!doc": "Static flag to use the HTTP POST method instead of PUT or DELETE.\n\nIf the server-side HTTP framework isn't RESTful, setting this flag to `true`\nwill cause all PUT and DELETE requests to instead use the POST HTTP method, and\nadd a `X-HTTP-Method-Override` HTTP header with the value of the method type\nwhich was overridden.",
     "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_EMULATE_HTTP"
    },
    "HTTP_HEADERS": {
     "!type": "+yui.Object",
     "!doc": "Default headers used with all XHRs.\n\nBy default the `Accept` and `Content-Type` headers are set to\n\"application/json\", this signals to the HTTP server to process the request\nbodies as JSON and send JSON responses. If you're sending and receiving content\nother than JSON, you can override these headers and the `parse()` and\n`serialize()` methods.\n\n**Note:** These headers will be merged with any request-specific headers, and\nthe request-specific headers will take precedence.",
     "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_HTTP_HEADERS"
    },
    "HTTP_METHODS": {
     "!type": "+yui.Object",
     "!doc": "Static mapping of RESTful HTTP methods corresponding to CRUD actions.",
     "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_HTTP_METHODS"
    },
    "HTTP_TIMEOUT": {
     "!type": "number",
     "!doc": "The number of milliseconds before the XHRs will timeout/abort. This defaults to\n30 seconds.\n\n**Note:** This can be overridden on a per-request basis. See `sync()` method.",
     "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_HTTP_TIMEOUT"
    },
    "prototype": {
     "root": {
      "!type": "string",
      "!doc": "A string which represents the root or collection part of the URL which\nrelates to a Model or ModelList. Usually this value should be same for all\ninstances of a specific Model/ModelList subclass.\n\nWhen sub-classing `Y.Model`, usually you'll only need to override this\nproperty, which lets the URLs for the XHRs be generated by convention. If\nthe `root` string ends with a trailing-slash, XHR URLs will also end with a\n\"/\", and if the `root` does not end with a slash, neither will the XHR URLs.",
      "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_root"
     },
     "url": {
      "!type": "string",
      "!doc": "A string which specifies the URL to use when making XHRs, if not value is\nprovided, the URLs used to make XHRs will be generated by convention.\n\nWhile a `url` can be provided for each Model/ModelList instance, usually\nyou'll want to either rely on the default convention or provide a tokenized\nstring on the prototype which can be used for all instances.\n\nWhen sub-classing `Y.Model`, you will probably be able to rely on the\ndefault convention of generating URLs in conjunction with the `root`\nproperty and whether the model is new or not (i.e. has an `id`). If the\n`root` property ends with a trailing-slash, the generated URL for the\nspecific model will also end with a trailing-slash.",
      "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#property_url"
     },
     "getURL": {
      "!type": "fn(action?: string, options?: yui.Object) -> string",
      "!doc": "Returns the URL for this model or model list for the given `action` and\n`options`, if specified.\n\nThis method correctly handles the variations of `root` and `url` values and\nis called by the `sync()` method to get the URLs used to make the XHRs.\n\nYou can override this method if you need to provide a specific\nimplementation for how the URLs of your Model and ModelList subclasses need\nto be generated.",
      "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#method_getURL"
     },
     "parseIOResponse": {
      "!type": "fn(response: yui.Object) -> +Any",
      "!doc": "Called to parse the response object returned from `Y.io()`. This method\nreceives the full response object and is expected to \"prep\" a response which\nis suitable to pass to the `parse()` method.\n\nBy default the response body is returned (`responseText`), because it\nusually represents the entire entity of this model on the server.\n\nIf you need to parse data out of the response's headers you should do so by\noverriding this method. If you'd like the entire response object from the\nXHR to be passed to your `parse()` method, you can simply assign this\nproperty to `false`.",
      "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#method_parseIOResponse"
     },
     "serialize": {
      "!type": "fn(action?: string) -> string",
      "!doc": "Serializes `this` model to be used as the HTTP request entity body.\n\nBy default this model will be serialized to a JSON string via its `toJSON()`\nmethod.\n\nYou can override this method when the HTTP server expects a different\nrepresentation of this model's data that is different from the default JSON\nserialization. If you're sending and receive content other than JSON, be\nsure change the `Accept` and `Content-Type` `HTTP_HEADERS` as well.\n\n**Note:** A model's `toJSON()` method can also be overridden. If you only\nneed to modify which attributes are serialized to JSON, that's a better\nplace to start.",
      "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#method_serialize"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Communicates with a RESTful HTTP server by sending and receiving data via\nXHRs. This method is called internally by load(), save(), and destroy().\n\nThe URL used for each XHR will be retrieved by calling the `getURL()` method\nand passing it the specified `action` and `options`.\n\nThis method relies heavily on standard RESTful HTTP conventions",
      "!url": "http://yuilibrary.com/classes/ModelSync.REST.html#method_sync"
     }
    }
   },
   "View.NodeMap": {
    "!type": "fn()",
    "!doc": "View extension that adds a static `getByNode()` method that returns the nearest\nView instance associated with the given Node (similar to Widget's `getByNode()`\nmethod).\n\nNote that it's important to call `destroy()` on a View instance using this\nextension when you plan to stop using it. This ensures that all internal\nreferences to that View are cleared to prevent memory leaks.",
    "!url": "http://yuilibrary.com/classes/View.NodeMap.html",
    "getByNode": {
     "!type": "fn(node: node.Node) -> +app.View",
     "!doc": "Returns the nearest View instance associated with the given Node. The Node may\nbe a View container or any child of a View container.\n\nNote that only instances of Views that have the Y.View.NodeMap extension mixed\nin will be returned. The base View class doesn't provide this functionality by\ndefault due to the additional memory management overhead involved in maintaining\na mapping of Nodes to View instances.",
     "!url": "http://yuilibrary.com/classes/View.NodeMap.html#method_getByNode"
    }
   },
   "App.Base": {
    "!type": "fn(config?: yui.Object) -> +app.App.Base",
    "!proto": "base.Base",
    "!doc": "Provides a top-level application component which manages navigation and views.\n\nThis gives you a foundation and structure on which to build your application; it\ncombines robust URL navigation with powerful routing and flexible view\nmanagement.",
    "!url": "http://yuilibrary.com/classes/App.Base.html",
    "prototype": {
     "views": {
      "!type": "+yui.Object",
      "!doc": "Hash of view-name to metadata used to declaratively describe an\napplication's views and their relationship with the app and its other views.\n\nThe view metadata is composed of Objects keyed to a view-name that can have\nany or all of the following properties:\n\n  * `type`: Function or a string representing the view constructor to use to\n    create view instances. If a string is used, the constructor function is\n    assumed to be on the `Y` object; e.g. `\"SomeView\"` -> `Y.SomeView`.\n\n  * `preserve`: Boolean for whether the view instance should be retained. By\n    default, the view instance will be destroyed when it is no longer the\n    `activeView`. If `true` the view instance will simply be `removed()`\n    from the DOM when it is no longer active. This is useful when the view\n    is frequently used and may be expensive to re-create.\n\n  * `parent`: String to another named view in this hash that represents the\n    parent view within the application's view hierarchy; e.g. a `\"photo\"`\n    view could have `\"album\"` has its `parent` view. This parent/child\n    relationship is a useful cue for things like transitions.\n\n  * `instance`: Used internally to manage the current instance of this named\n    view. This can be used if your view instance is created up-front, or if\n    you would rather manage the View lifecycle, but you probably should just\n    let this be handled for you.\n\nIf `views` are specified at instantiation time, the metadata in the `views`\nObject here will be used as defaults when creating the instance's `views`.\n\nEvery `Y.App` instance gets its own copy of a `views` object so this Object\non the prototype will not be polluted.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#property_views"
     },
     "createView": {
      "!type": "fn(name: string, config?: yui.Object) -> +app.View",
      "!doc": "Creates and returns a new view instance using the provided `name` to look up\nthe view info metadata defined in the `views` object. The passed-in `config`\nobject is passed to the view constructor function.\n\nThis function also maps a view instance back to its view info metadata.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#method_createView"
     },
     "getViewInfo": {
      "!type": "fn(view: app.View) -> +yui.Object",
      "!doc": "Returns the metadata associated with a view instance or view name defined on\nthe `views` object.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#method_getViewInfo"
     },
     "navigate": {
      "!type": "fn(url: string, options?: yui.Object)",
      "!doc": "Navigates to the specified URL if there is a route handler that matches. In\nbrowsers capable of using HTML5 history or when `serverRouting` is falsy,\nthe navigation will be enhanced by firing the `navigate` event and having\nthe app handle the \"request\". When `serverRouting` is `true`, non-HTML5\nbrowsers will navigate to the new URL via a full page reload.\n\nWhen there is a route handler for the specified URL and it is being\nnavigated to, this method will return `true`, otherwise it will return\n`false`.\n\n**Note:** The specified URL _must_ be of the same origin as the current URL,\notherwise an error will be logged and navigation will not occur. This is\nintended as both a security constraint and a purposely imposed limitation as\nit does not make sense to tell the app to navigate to a URL on a\ndifferent scheme, host, or port.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#method_navigate"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Renders this application by appending the `viewContainer` node to the\n`container` node if it isn't already a child of the container, and the\n`activeView` will be appended the view container, if it isn't already.\n\nYou should call this method at least once, usually after the initialization\nof your app instance so the proper DOM structure is setup and optionally\nappend the container to the DOM if it's not there already.\n\nYou may override this method to customize the app's rendering, but you\nshould expect that the `viewContainer`'s contents will be modified by the\napp for the purpose of rendering the `activeView` when it changes.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#method_render"
     },
     "showView": {
      "!type": "fn(view: string, config?: yui.Object, options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Sets which view is active/visible for the application. This will set the\napp's `activeView` attribute to the specified `view`.\n\nThe `view` will be \"attached\" to this app, meaning it will be both rendered\ninto this app's `viewContainer` node and all of its events will bubble to\nthe app. The previous `activeView` will be \"detached\" from this app.\n\nWhen a string-name is provided for a view which has been registered on this\napp's `views` object, the referenced metadata will be used and the\n`activeView` will be set to either a preserved view instance, or a new\ninstance of the registered view will be created using the specified `config`\nobject passed-into this method.\n\nA callback function can be specified as either the third or fourth argument,\nand this function will be called after the new `view` becomes the\n`activeView`, is rendered to the `viewContainer`, and is ready to use.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#method_showView"
     },
     "activeView": {
      "!type": "fn()",
      "!doc": "The application's active/visible view.\n\nThis attribute is read-only, to set the `activeView` use the\n`showView()` method.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#attribute_activeView"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Container node which represents the application's bounding-box, into\nwhich this app's content will be rendered.\n\nThe container node serves as the host for all DOM events attached by the\napp. Delegation is used to handle events on children of the container,\nallowing the container's contents to be re-rendered at any time without\nlosing event subscriptions.\n\nThe default container is the `<body>` Node, but you can override this in\na subclass, or by passing in a custom `container` config value at\ninstantiation time.\n\nWhen `container` is overridden by a subclass or passed as a config\noption at instantiation time, it may be provided as a selector string, a\nDOM element, or a `Y.Node` instance. During initialization, this app's\n`create()` method will be called to convert the container into a\n`Y.Node` instance if it isn't one already and stamp it with the CSS\nclass: `\"yui3-app\"`.\n\nThe container is not added to the page automatically. This allows you to\nhave full control over how and when your app is actually rendered to\nthe page.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#attribute_container"
     },
     "html5": {
      "!type": "fn()",
      "!doc": "Whether or not this browser is capable of using HTML5 history.\n\nThis value is dependent on the value of `serverRouting` and will default\naccordingly.\n\nSetting this to `false` will force the use of hash-based history even on\nHTML5 browsers, but please don't do this unless you understand the\nconsequences.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#attribute_html5"
     },
     "linkSelector": {
      "!type": "fn()",
      "!doc": "CSS selector string used to filter link click events so that only the\nlinks which match it will have the enhanced-navigation behavior of pjax\napplied.\n\nWhen a link is clicked and that link matches this selector, navigating\nto the link's `href` URL using the enhanced, pjax, behavior will be\nattempted; and the browser's default way to navigate to new pages will\nbe the fallback.\n\nBy default this selector will match _all_ links on the page.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#attribute_linkSelector"
     },
     "serverRouting": {
      "!type": "fn()",
      "!doc": "Whether or not this application's server is capable of properly routing\nall requests and rendering the initial state in the HTML responses.\n\nThis can have three different values, each having particular\nimplications on how the app will handle routing and navigation:\n\n  * `undefined`: The best form of URLs will be chosen based on the\n    capabilities of the browser. Given no information about the server\n    environmentm a balanced approach to routing and navigation is\n    chosen.\n\n    The server should be capable of handling full-path requests, since\n    full-URLs will be generated by browsers using HTML5 history. If this\n    is a client-side-only app the server could handle full-URL requests\n    by sending a redirect back to the root with a hash-based URL, e.g:\n\n        Request:     http://example.com/users/1\n        Redirect to: http://example.com/#/users/1\n\n  * `true`: The server is *fully* capable of properly handling requests\n    to all full-path URLs the app can produce.\n\n    This is the best option for progressive-enhancement because it will\n    cause **all URLs to always have full-paths**, which means the server\n    will be able to accurately handle all URLs this app produces. e.g.\n\n        http://example.com/users/1\n\n    To meet this strict full-URL requirement, browsers which are not\n    capable of using HTML5 history will make requests to the server\n    resulting in full-page reloads.\n\n  * `false`: The server is *not* capable of properly handling requests\n    to all full-path URLs the app can produce, therefore all routing\n    will be handled by this App instance.\n\n    Be aware that this will cause **all URLs to always be hash-based**,\n    even in browsers that are capable of using HTML5 history. e.g.\n\n        http://example.com/#/users/1\n\n    A single-page or client-side-only app where the server sends a\n    \"shell\" page with JavaScript to the client might have this\n    restriction. If you're setting this to `false`, read the following:\n\n**Note:** When this is set to `false`, the server will *never* receive\nthe full URL because browsers do not send the fragment-part to the\nserver, that is everything after and including the \"#\".\n\nConsider the following example:\n\n    URL shown in browser: http://example.com/#/users/1\n    URL sent to server:   http://example.com/\n\nYou should feel bad about hurting our precious web if you forcefully set\neither `serverRouting` or `html5` to `false`, because you're basically\npunching the web in the face here with your lossy URLs! Please make sure\nyou know what you're doing and that you understand the implications.\n\nIdeally you should always prefer full-path URLs (not /#/foo/), and want\nfull-page reloads when the client's browser is not capable of enhancing\nthe experience using the HTML5 history APIs. Setting this to `true` is\nthe best option for progressive-enhancement (and graceful-degradation).",
      "!url": "http://yuilibrary.com/classes/App.Base.html#attribute_serverRouting"
     },
     "viewContainer": {
      "!type": "fn()",
      "!doc": "The node into which this app's `views` will be rendered when they become\nthe `activeView`.\n\nThe view container node serves as the container to hold the app's\n`activeView`. Each time the `activeView` is set via `showView()`, the\nprevious view will be removed from this node, and the new active view's\n`container` node will be appended.\n\nThe default view container is a `<div>` Node, but you can override this\nin a subclass, or by passing in a custom `viewContainer` config value at\ninstantiation time. The `viewContainer` may be provided as a selector\nstring, DOM element, or a `Y.Node` instance (having the `viewContainer`\nand the `container` be the same node is also supported).\n\nThe app's `render()` method will stamp the view container with the CSS\nclass `\"yui3-app-views\"` and append it to the app's `container` node if\nit isn't already, and any `activeView` will be appended to this node if\nit isn't already.",
      "!url": "http://yuilibrary.com/classes/App.Base.html#attribute_viewContainer"
     }
    }
   },
   "App": {
    "!type": "fn(config?: yui.Object) -> +app.App",
    "!proto": "app.App.Base",
    "!doc": "Provides a top-level application component which manages navigation and views.\n\nThis gives you a foundation and structure on which to build your application; it\ncombines robust URL navigation with powerful routing and flexible view\nmanagement.\n\n`Y.App` is both a namespace and constructor function. The `Y.App` class is\nspecial in that any `Y.App` class extensions that are included in the YUI\ninstance will be **auto-mixed** on to the `Y.App` class. Consider this example:\n\n    YUI().use('app-base', 'app-transitions', function (Y) {\n        // This will create two YUI Apps, `basicApp` will not have transitions,\n        // but `fancyApp` will have transitions support included and turn it on.\n        var basicApp = new Y.App.Base(),\n            fancyApp = new Y.App({transitions: true});\n    });",
    "!url": "http://yuilibrary.com/classes/App.html",
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "CSS classes used by `Y.App`.",
     "!url": "http://yuilibrary.com/classes/App.html#property_CLASS_NAMES"
    },
    "serverRouting": {
     "!type": "bool",
     "!doc": "Default `serverRouting` attribute value for all apps.",
     "!url": "http://yuilibrary.com/classes/App.html#property_serverRouting"
    }
   },
   "LazyModelList": {
    "!type": "fn() -> +app.LazyModelList",
    "!proto": "app.ModelList",
    "!doc": "LazyModelList is a subclass of ModelList that maintains a list of plain\nJavaScript objects rather than a list of Model instances. This makes it\nwell-suited for managing large amounts of data (on the order of thousands of\nitems) that would tend to bog down a vanilla ModelList.\n\nThe API presented by LazyModelList is the same as that of ModelList, except that\nin every case where ModelList would provide a Model instance, LazyModelList\nprovides a plain JavaScript object. LazyModelList also provides a `revive()`\nmethod that can convert the plain object at a given index into a full Model\ninstance.\n\nSince the items stored in a LazyModelList are plain objects and not full Model\ninstances, there are a few caveats to be aware of:\n\n  * Since items are plain objects and not Model instances, they contain\n    properties rather than Model attributes. To retrieve a property, use\n    `item.foo` rather than `item.get('foo')`. To set a property, use\n    `item.foo = 'bar'` rather than `item.set('foo', 'bar')`.\n\n  * Model attribute getters and setters aren't supported, since items in the\n    LazyModelList are stored and manipulated as plain objects with simple\n    properties rather than YUI attributes.\n\n  * Changes made to the plain object version of an item will not trigger or\n    bubble up Model `change` events. However, once an item is revived into a\n    full Model using the `revive()` method, changes to that Model instance\n    will trigger and bubble change events as expected.\n\n  * Custom `idAttribute` fields are not supported.\n\n  * `id` and `clientId` properties _are_ supported. If an item doesn't have a\n    `clientId` property, one will be generated automatically when the item is\n    added to a LazyModelList.\n\nLazyModelList is generally much more memory efficient than ModelList when\nmanaging large numbers of items, and adding/removing items is significantly\nfaster. However, the tradeoff is that LazyModelList is only well-suited for\nstoring very simple items without complex attributes, and consumers must\nexplicitly revive items into full Model instances as needed (this is not done\ntransparently for performance reasons).",
    "!url": "http://yuilibrary.com/classes/LazyModelList.html",
    "prototype": {
     "free": {
      "!type": "fn(model?: app.Model) -> !this",
      "!doc": "Deletes the specified model from the model cache to release memory. The\nmodel won't be destroyed or removed from the list, just freed from the\ncache; it can still be instantiated again using `revive()`.\n\nIf no model or model index is specified, all cached models in this list will\nbe freed.\n\nNote: Specifying an index is faster than specifying a model instance, since\nthe latter requires an `indexOf()` call.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_free"
     },
     "get": {
      "!type": "fn(name: string) -> [string]",
      "!doc": "Overrides ModelList#get() to return a map of property values rather than\nperforming attribute lookups.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_get"
     },
     "getAsHTML": {
      "!type": "fn(name: string) -> [string]",
      "!doc": "Overrides ModelList#getAsHTML() to return a map of HTML-escaped property\nvalues rather than performing attribute lookups.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_getAsHTML"
     },
     "getAsURL": {
      "!type": "fn(name: string) -> [string]",
      "!doc": "Overrides ModelList#getAsURL() to return a map of URL-encoded property\nvalues rather than performing attribute lookups.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_getAsURL"
     },
     "indexOf": {
      "!type": "fn(needle: app.Model) -> number",
      "!doc": "Returns the index of the given object or Model instance in this\nLazyModelList.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_indexOf"
     },
     "reset": {
      "!type": "fn(models?: [yui.Object], options?: yui.Object) -> !this",
      "!doc": "Overrides ModelList#reset() to work with plain objects.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_reset"
     },
     "revive": {
      "!type": "fn(item?: number) -> +app.Model",
      "!doc": "Revives an item (or all items) into a full Model instance. The _item_\nargument may be the index of an object in this list, an actual object (which\nmust exist in the list), or may be omitted to revive all items in the list.\n\nOnce revived, Model instances are attached to this list and cached so that\nreviving them in the future doesn't require another Model instantiation. Use\nthe `free()` method to explicitly uncache and detach a previously revived\nModel instance.\n\nNote: Specifying an index rather than an object will be faster, since\nobjects require an `indexOf()` lookup in order to retrieve the index.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_revive"
     },
     "toJSON": {
      "!type": "fn() -> [+yui.Object]",
      "!doc": "Overrides ModelList#toJSON() to use toArray() instead, since it's more\nefficient for LazyModelList.",
      "!url": "http://yuilibrary.com/classes/LazyModelList.html#method_toJSON"
     }
    }
   },
   "ModelList": {
    "!type": "fn(config: yui.Object) -> +app.ModelList",
    "!proto": "base.Base",
    "!doc": "Provides an API for managing an ordered list of Model instances.\n\nIn addition to providing convenient `add`, `create`, `reset`, and `remove`\nmethods for managing the models in the list, ModelLists are also bubble targets\nfor events on the model instances they contain. This means, for example, that\nyou can add several models to a list, and then subscribe to the `*:change` event\non the list to be notified whenever any model in the list changes.\n\nModelLists also maintain sort order efficiently as models are added and removed,\nbased on a custom `comparator` function you may define (if no comparator is\ndefined, models are sorted in insertion order).",
    "!url": "http://yuilibrary.com/classes/ModelList.html",
    "prototype": {
     "add": {
      "!type": "fn(models: app.Model, options?: yui.Object) -> +app.Model",
      "!doc": "Adds the specified model or array of models to this list. You may also pass\nanother ModelList instance, in which case all the models in that list will\nbe added to this one as well.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_add"
     },
     "create": {
      "!type": "fn(model: app.Model, options?: yui.Object, callback?: fn()) -> +app.Model",
      "!doc": "Creates or updates the specified model on the server, then adds it to this\nlist if the server indicates success.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_create"
     },
     "error": {
      "!type": "fn(error: Any, src: string)",
      "!doc": "Fired when an error occurs, such as when an attempt is made to add a\nduplicate model to the list, or when a sync layer response can't be parsed.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#event_error"
     },
     "load": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Loads this list of models from the server.\n\nThis method delegates to the `sync()` method to perform the actual load\noperation, which is an asynchronous action. Specify a _callback_ function to\nbe notified of success or failure.\n\nIf the load operation succeeds, a `reset` event will be fired.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_load"
     },
     "remove": {
      "!type": "fn(models: app.Model, options?: yui.Object) -> +app.Model",
      "!doc": "Removes the specified model or array of models from this list. You may also\npass another ModelList instance to remove all the models that are in both\nthat instance and this instance, or pass numerical indices to remove the\nmodels at those indices.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_remove"
     },
     "reset": {
      "!type": "fn(models?: [app.Model], options?: yui.Object) -> !this",
      "!doc": "Completely replaces all models in the list with those specified, and fires a\nsingle `reset` event.\n\nUse `reset` when you want to add or remove a large number of items at once\nwith less overhead, and without firing `add` or `remove` events for each\none.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_reset"
     },
     "model": {
      "!type": "+app.Model",
      "!doc": "The `Model` class or subclass of the models in this list.\n\nThe class specified here will be used to create model instances\nautomatically based on attribute hashes passed to the `add()`, `create()`,\nand `reset()` methods.\n\nYou may specify the class as an actual class reference or as a string that\nresolves to a class reference at runtime (the latter can be useful if the\nspecified class will be loaded lazily).",
      "!url": "http://yuilibrary.com/classes/ModelList.html#property_model"
     },
     "comparator": {
      "!type": "fn(model: app.Model) -> number",
      "!doc": "Define this method to provide a function that takes a model as a parameter\nand returns a value by which that model should be sorted relative to other\nmodels in this list.\n\nBy default, no comparator is defined, meaning that models will not be sorted\n(they'll be stored in the order they're added).",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_comparator"
     },
     "each": {
      "!type": "fn(callback: fn(), thisObj?: yui.Object) -> !this",
      "!doc": "Executes the supplied function on each model in this list.\n\nBy default, the callback function's `this` object will refer to the model\ncurrently being iterated. Specify a `thisObj` to override the `this` object\nif desired.\n\nNote: Iteration is performed on a copy of the internal array of models, so\nit's safe to delete a model from the list during iteration.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_each"
     },
     "filter": {
      "!type": "fn(options?: yui.Object, callback: fn()) -> [+app.Model]",
      "!doc": "Executes the supplied function on each model in this list. Returns an array\ncontaining the models for which the supplied function returned a truthy\nvalue.\n\nThe callback function's `this` object will refer to this ModelList. Use\n`Y.bind()` to bind the `this` object to another object if desired.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_filter"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "If _name_ refers to an attribute on this ModelList instance, returns the\nvalue of that attribute. Otherwise, returns an array containing the values\nof the specified attribute from each model in this list.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_get"
     },
     "getAsHTML": {
      "!type": "fn(name: string) -> string",
      "!doc": "If _name_ refers to an attribute on this ModelList instance, returns the\nHTML-escaped value of that attribute. Otherwise, returns an array containing\nthe HTML-escaped values of the specified attribute from each model in this\nlist.\n\nThe values are escaped using `Escape.html()`.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_getAsHTML"
     },
     "getAsURL": {
      "!type": "fn(name: string) -> string",
      "!doc": "If _name_ refers to an attribute on this ModelList instance, returns the\nURL-encoded value of that attribute. Otherwise, returns an array containing\nthe URL-encoded values of the specified attribute from each model in this\nlist.\n\nThe values are encoded using the native `encodeURIComponent()` function.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_getAsURL"
     },
     "getByClientId": {
      "!type": "fn(clientId: string) -> +app.Model",
      "!doc": "Returns the model with the specified _clientId_, or `null` if not found.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_getByClientId"
     },
     "getById": {
      "!type": "fn(id: string) -> +app.Model",
      "!doc": "Returns the model with the specified _id_, or `null` if not found.\n\nNote that models aren't expected to have an id until they're saved, so if\nyou're working with unsaved models, it may be safer to call\n`getByClientId()`.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_getById"
     },
     "invoke": {
      "!type": "fn(name: string, args?: Any) -> [+Any]",
      "!doc": "Calls the named method on every model in the list. Any arguments provided\nafter _name_ will be passed on to the invoked method.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_invoke"
     },
     "item": {
      "!type": "fn(index: number) -> +app.Model",
      "!doc": "Returns the model at the specified _index_.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_item"
     },
     "map": {
      "!type": "fn(fn: fn(), thisObj?: yui.Object) -> +yui.Array",
      "!doc": "Executes the specified function on each model in this list and returns an\narray of the function's collected return values.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_map"
     },
     "parse": {
      "!type": "fn(response: Any) -> [+yui.Object]",
      "!doc": "Called to parse the _response_ when the list is loaded from the server.\nThis method receives a server _response_ and is expected to return an array\nof model attribute hashes.\n\nThe default implementation assumes that _response_ is either an array of\nattribute hashes or a JSON string that can be parsed into an array of\nattribute hashes. If _response_ is a JSON string and either `Y.JSON` or the\nnative `JSON` object are available, it will be parsed automatically. If a\nparse error occurs, an `error` event will be fired and the model will not be\nupdated.\n\nYou may override this method to implement custom parsing logic if necessary.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_parse"
     },
     "some": {
      "!type": "fn(callback: fn(), thisObj?: yui.Object) -> bool",
      "!doc": "Executes the supplied function on each model in this list, and stops\niterating if the callback returns `true`.\n\nBy default, the callback function's `this` object will refer to the model\ncurrently being iterated. Specify a `thisObj` to override the `this` object\nif desired.\n\nNote: Iteration is performed on a copy of the internal array of models, so\nit's safe to delete a model from the list during iteration.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_some"
     },
     "sort": {
      "!type": "fn(options?: yui.Object) -> !this",
      "!doc": "Forcibly re-sorts the list.\n\nUsually it shouldn't be necessary to call this method since the list\nmaintains its sort order when items are added and removed, but if you change\nthe `comparator` function after items are already in the list, you'll need\nto re-sort.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_sort"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Override this method to provide a custom persistence implementation for this\nlist. The default method just calls the callback without actually doing\nanything.\n\nThis method is called internally by `load()` and its implementations relies\non the callback being called. This effectively means that when a callback is\nprovided, it must be called at some point for the class to operate correctly.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_sync"
     },
     "toArray": {
      "!type": "fn() -> [+app.Model]",
      "!doc": "Returns an array containing the models in this list.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_toArray"
     },
     "toJSON": {
      "!type": "fn() -> [+yui.Object]",
      "!doc": "Returns an array containing attribute hashes for each model in this list,\nsuitable for being passed to `Y.JSON.stringify()`.\n\nUnder the hood, this method calls `toJSON()` on each model in the list and\npushes the results into an array.",
      "!url": "http://yuilibrary.com/classes/ModelList.html#method_toJSON"
     }
    }
   },
   "Model": {
    "!type": "fn() -> +app.Model",
    "!proto": "base.Base",
    "!doc": "Attribute-based data model with APIs for getting, setting, validating, and\nsyncing attribute values, as well as events for being notified of model changes.\n\nIn most cases, you'll want to create your own subclass of `Y.Model` and\ncustomize it to meet your needs. In particular, the `sync()` and `validate()`\nmethods are meant to be overridden by custom implementations. You may also want\nto override the `parse()` method to parse non-generic server responses.",
    "!url": "http://yuilibrary.com/classes/Model.html",
    "prototype": {
     "change": {
      "!type": "fn(changed: yui.Object)",
      "!doc": "Fired when one or more attributes on this model are changed.",
      "!url": "http://yuilibrary.com/classes/Model.html#event_change"
     },
     "error": {
      "!type": "fn(error: Any, src: string)",
      "!doc": "Fired when an error occurs, such as when the model doesn't validate or when\na sync layer response can't be parsed.",
      "!url": "http://yuilibrary.com/classes/Model.html#event_error"
     },
     "load": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Loads this model from the server.\n\nThis method delegates to the `sync()` method to perform the actual load\noperation, which is an asynchronous action. Specify a _callback_ function to\nbe notified of success or failure.\n\nA successful load operation will fire a `load` event, while an unsuccessful\nload operation will fire an `error` event with the `src` value \"load\".\n\nIf the load operation succeeds and one or more of the loaded attributes\ndiffer from this model's current attributes, a `change` event will be fired.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_load"
     },
     "save": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Saves this model to the server.\n\nThis method delegates to the `sync()` method to perform the actual save\noperation, which is an asynchronous action. Specify a _callback_ function to\nbe notified of success or failure.\n\nA successful save operation will fire a `save` event, while an unsuccessful\nsave operation will fire an `error` event with the `src` value \"save\".\n\nIf the save operation succeeds and one or more of the attributes returned in\nthe server's response differ from this model's current attributes, a\n`change` event will be fired.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_save"
     },
     "changed": {
      "!type": "+yui.Object",
      "!doc": "Hash of attributes that have changed since the last time this model was\nsaved.",
      "!url": "http://yuilibrary.com/classes/Model.html#property_changed"
     },
     "idAttribute": {
      "!type": "string",
      "!doc": "Name of the attribute to use as the unique id (or primary key) for this\nmodel.\n\nThe default is `id`, but if your persistence layer uses a different name for\nthe primary key (such as `_id` or `uid`), you can specify that here.\n\nThe built-in `id` attribute will always be an alias for whatever attribute\nname you specify here, so getting and setting `id` will always behave the\nsame as getting and setting your custom id attribute.",
      "!url": "http://yuilibrary.com/classes/Model.html#property_idAttribute"
     },
     "lastChange": {
      "!type": "+yui.Object",
      "!doc": "Hash of attributes that were changed in the last `change` event. Each item\nin this hash is an object with the following properties:\n\n  * `newVal`: The new value of the attribute after it changed.\n  * `prevVal`: The old value of the attribute before it changed.\n  * `src`: The source of the change, or `null` if no source was specified.",
      "!url": "http://yuilibrary.com/classes/Model.html#property_lastChange"
     },
     "lists": {
      "!type": "[+app.ModelList]",
      "!doc": "Array of `ModelList` instances that contain this model.\n\nWhen a model is in one or more lists, the model's events will bubble up to\nthose lists. You can subscribe to a model event on a list to be notified\nwhen any model in the list fires that event.\n\nThis property is updated automatically when this model is added to or\nremoved from a `ModelList` instance. You shouldn't alter it manually. When\nworking with models in a list, you should always add and remove models using\nthe list's `add()` and `remove()` methods.",
      "!url": "http://yuilibrary.com/classes/Model.html#property_lists"
     },
     "destroy": {
      "!type": "fn(options?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Destroys this model instance and removes it from its containing lists, if\nany.\n\nThe _callback_, if one is provided, will be called after the model is\ndestroyed.\n\nIf `options.remove` is `true`, then this method delegates to the `sync()`\nmethod to delete the model from the persistence layer, which is an\nasynchronous action. In this case, the _callback_ (if provided) will be\ncalled after the sync layer indicates success or failure of the delete\noperation.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_destroy"
     },
     "generateClientId": {
      "!type": "fn() -> string",
      "!doc": "Returns a clientId string that's unique among all models on the current page\n(even models in other YUI instances). Uniqueness across pageviews is\nunlikely.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_generateClientId"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "Returns the value of the specified attribute.\n\nIf the attribute's value is an object, _name_ may use dot notation to\nspecify the path to a specific property within the object, and the value of\nthat property will be returned.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_get"
     },
     "getAsHTML": {
      "!type": "fn(name: string) -> string",
      "!doc": "Returns an HTML-escaped version of the value of the specified string\nattribute. The value is escaped using `Y.Escape.html()`.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_getAsHTML"
     },
     "getAsURL": {
      "!type": "fn(name: string) -> string",
      "!doc": "Returns a URL-encoded version of the value of the specified string\nattribute. The value is encoded using the native `encodeURIComponent()`\nfunction.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_getAsURL"
     },
     "isModified": {
      "!type": "fn() -> bool",
      "!doc": "Returns `true` if any attribute of this model has been changed since the\nmodel was last saved.\n\nNew models (models for which `isNew()` returns `true`) are implicitly\nconsidered to be \"modified\" until the first time they're saved.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_isModified"
     },
     "isNew": {
      "!type": "fn() -> bool",
      "!doc": "Returns `true` if this model is \"new\", meaning it hasn't been saved since it\nwas created.\n\nNewness is determined by checking whether the model's `id` attribute has\nbeen set. An empty id is assumed to indicate a new model, whereas a\nnon-empty id indicates a model that was either loaded or has been saved\nsince it was created.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_isNew"
     },
     "parse": {
      "!type": "fn(response: Any) -> +yui.Object",
      "!doc": "Called to parse the _response_ when the model is loaded from the server.\nThis method receives a server _response_ and is expected to return an\nattribute hash.\n\nThe default implementation assumes that _response_ is either an attribute\nhash or a JSON string that can be parsed into an attribute hash. If\n_response_ is a JSON string and either `Y.JSON` or the native `JSON` object\nare available, it will be parsed automatically. If a parse error occurs, an\n`error` event will be fired and the model will not be updated.\n\nYou may override this method to implement custom parsing logic if necessary.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_parse"
     },
     "set": {
      "!type": "fn(name: string, value: Any, options?: yui.Object) -> !this",
      "!doc": "Sets the value of a single attribute. If model validation fails, the\nattribute will not be set and an `error` event will be fired.\n\nUse `setAttrs()` to set multiple attributes at once.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attributes: yui.Object, options?: yui.Object) -> !this",
      "!doc": "Sets the values of multiple attributes at once. If model validation fails,\nthe attributes will not be set and an `error` event will be fired.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_setAttrs"
     },
     "sync": {
      "!type": "fn(action: string, options?: yui.Object, callback?: fn())",
      "!doc": "Override this method to provide a custom persistence implementation for this\nmodel. The default just calls the callback without actually doing anything.\n\nThis method is called internally by `load()`, `save()`, and `destroy()`, and\ntheir implementations rely on the callback being called. This effectively\nmeans that when a callback is provided, it must be called at some point for\nthe class to operate correctly.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_sync"
     },
     "toJSON": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns a copy of this model's attributes that can be passed to\n`Y.JSON.stringify()` or used for other nefarious purposes.\n\nThe `clientId` attribute is not included in the returned object.\n\nIf you've specified a custom attribute name in the `idAttribute` property,\nthe default `id` attribute will not be included in the returned object.\n\nNote: The ECMAScript 5 specification states that objects may implement a\n`toJSON` method to provide an alternate object representation to serialize\nwhen passed to `JSON.stringify(obj)`.  This allows class instances to be\nserialized as if they were plain objects.  This is why Model's `toJSON`\nreturns an object, not a JSON string.\n\nSee <http://es5.github.com/#x15.12.3> for details.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_toJSON"
     },
     "undo": {
      "!type": "fn(attrNames?: [string], options?: yui.Object) -> !this",
      "!doc": "Reverts the last change to the model.\n\nIf an _attrNames_ array is provided, then only the named attributes will be\nreverted (and only if they were modified in the previous change). If no\n_attrNames_ array is provided, then all changed attributes will be reverted\nto their previous values.\n\nNote that only one level of undo is available: from the current state to the\nprevious state. If `undo()` is called when no previous state is available,\nit will simply do nothing.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_undo"
     },
     "validate": {
      "!type": "fn(attrs: yui.Object, callback: fn())",
      "!doc": "Override this method to provide custom validation logic for this model.\n\nWhile attribute-specific validators can be used to validate individual\nattributes, this method gives you a hook to validate a hash of all\nattributes before the model is saved. This method is called automatically\nbefore `save()` takes any action. If validation fails, the `save()` call\nwill be aborted.\n\nIn your validation method, call the provided `callback` function with no\narguments to indicate success. To indicate failure, pass a single argument,\nwhich may contain an error message, an array of error messages, or any other\nvalue. This value will be passed along to the `error` event.",
      "!url": "http://yuilibrary.com/classes/Model.html#method_validate"
     },
     "clientId": {
      "!type": "fn()",
      "!doc": "A client-only identifier for this model.\n\nLike the `id` attribute, `clientId` may be used to retrieve model\ninstances from lists. Unlike the `id` attribute, `clientId` is\nautomatically generated, and is only intended to be used on the client\nduring the current pageview.",
      "!url": "http://yuilibrary.com/classes/Model.html#attribute_clientId"
     },
     "id": {
      "!type": "fn()",
      "!doc": "A unique identifier for this model. Among other things, this id may be\nused to retrieve model instances from lists, so it should be unique.\n\nIf the id is empty, this model instance is assumed to represent a new\nitem that hasn't yet been saved.\n\nIf you would prefer to use a custom attribute as this model's id instead\nof using the `id` attribute (for example, maybe you'd rather use `_id`\nor `uid` as the primary id), you may set the `idAttribute` property to\nthe name of your custom id attribute. The `id` attribute will then\nact as an alias for your custom attribute.",
      "!url": "http://yuilibrary.com/classes/Model.html#attribute_id"
     }
    }
   },
   "Router": {
    "!type": "fn(config?: yui.Object) -> +app.Router",
    "!proto": "base.Base",
    "!doc": "Provides URL-based routing using HTML5 `pushState()` or the location hash.\n\nThis makes it easy to wire up route handlers for different application states\nwhile providing full back/forward navigation support and bookmarkable, shareable\nURLs.",
    "!url": "http://yuilibrary.com/classes/Router.html",
    "prototype": {
     "ready": {
      "!type": "fn(dispatched: bool)",
      "!doc": "Fired when the router is ready to begin dispatching to route handlers.\n\nYou shouldn't need to wait for this event unless you plan to implement some\nkind of custom dispatching logic. It's used internally in order to avoid\ndispatching to an initial route if a browser history change occurs first.",
      "!url": "http://yuilibrary.com/classes/Router.html#event_ready"
     },
     "dispatch": {
      "!type": "fn() -> !this",
      "!doc": "Dispatches to the first route handler that matches the current URL, if any.\n\nIf `dispatch()` is called before the `ready` event has fired, it will\nautomatically wait for the `ready` event before dispatching. Otherwise it\nwill dispatch immediately.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_dispatch"
     },
     "getPath": {
      "!type": "fn() -> string",
      "!doc": "Gets the current route path.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_getPath"
     },
     "hasRoute": {
      "!type": "fn(url: string) -> bool",
      "!doc": "Returns `true` if this router has at least one route that matches the\nspecified URL, `false` otherwise.\n\nThis method enforces the same-origin security constraint on the specified\n`url`; any URL which is not from the same origin as the current URL will\nalways return `false`.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_hasRoute"
     },
     "match": {
      "!type": "fn(path: string) -> [+yui.Object]",
      "!doc": "Returns an array of route objects that match the specified URL path.\n\nIf this router has a `root`, then the specified `path` _must_ be\nsemantically within the `root` path to match any routes.\n\nThis method is called internally to determine which routes match the current\npath whenever the URL changes. You may override it if you want to customize\nthe route matching logic, although this usually shouldn't be necessary.\n\nEach returned route object has the following properties:\n\n  * `callback`: A function or a string representing the name of a function\n    this router that should be executed when the route is triggered.\n\n  * `keys`: An array of strings representing the named parameters defined in\n    the route's path specification, if any.\n\n  * `path`: The route's path specification, which may be either a string or\n    a regex.\n\n  * `regex`: A regular expression version of the route's path specification.\n    This regex is used to determine whether the route matches a given path.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_match"
     },
     "param": {
      "!type": "fn(name: string, handler: fn()) -> !this",
      "!doc": "Adds a handler for a route param specified by _name_.\n\nParam handlers can be registered via this method and are used to\nvalidate/format values of named params in routes before dispatching to the\nroute's handler functions. Using param handlers allows routes to defined\nusing string paths which allows for `req.params` to use named params, but\nstill applying extra validation or formatting to the param values parsed\nfrom the URL.\n\nIf a param handler regex or function returns a value of `false`, `null`,\n`undefined`, or `NaN`, the current route will not match and be skipped. All\nother return values will be used in place of the original param value parsed\nfrom the URL.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_param"
     },
     "removeRoot": {
      "!type": "fn(url: string) -> string",
      "!doc": "Removes the `root` URL from the front of _url_ (if it's there) and returns\nthe result. The returned path will always have a leading `/`.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_removeRoot"
     },
     "removeQuery": {
      "!type": "fn(url: string) -> string",
      "!doc": "Removes a query string from the end of the _url_ (if one exists) and returns\nthe result.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_removeQuery"
     },
     "replace": {
      "!type": "fn(url?: string) -> !this",
      "!doc": "Replaces the current browser history entry with a new one, and dispatches to\nthe first matching route handler, if any.\n\nBehind the scenes, this method uses HTML5 `pushState()` in browsers that\nsupport it (or the location hash in older browsers and IE) to change the\nURL.\n\nThe specified URL must share the same origin (i.e., protocol, host, and\nport) as the current page, or an error will occur.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_replace"
     },
     "route": {
      "!type": "fn(route: string, callbacks: yui.Array) -> !this",
      "!doc": "Adds a route handler for the specified `route`.\n\nThe `route` parameter may be a string or regular expression to represent a\nURL path, or a route object. If it's a string (which is most common), it may\ncontain named parameters: `:param` will match any single part of a URL path\n(not including `/` characters), and `*param` will match any number of parts\nof a URL path (including `/` characters). These named parameters will be\nmade available as keys on the `req.params` object that's passed to route\nhandlers.\n\nIf the `route` parameter is a regex, all pattern matches will be made\navailable as numbered keys on `req.params`, starting with `0` for the full\nmatch, then `1` for the first subpattern match, and so on.\n\nAlternatively, an object can be provided to represent the route and it may\ncontain a `path` property which is a string or regular expression which\ncauses the route to be process as described above. If the route object\nalready contains a `regex` or `regexp` property, the route will be\nconsidered fully-processed and will be associated with any `callacks`\nspecified on the object and those specified as parameters to this method.\n**Note:** Any additional data contained on the route object will be\npreserved.\n\nHere's a set of sample routes along with URL paths that they match:\n\n  * Route: `/photos/:tag/:page`\n    * URL: `/photos/kittens/1`, params: `{tag: 'kittens', page: '1'}`\n    * URL: `/photos/puppies/2`, params: `{tag: 'puppies', page: '2'}`\n\n  * Route: `/file/*path`\n    * URL: `/file/foo/bar/baz.txt`, params: `{path: 'foo/bar/baz.txt'}`\n    * URL: `/file/foo`, params: `{path: 'foo'}`\n\n**Middleware**: Routes also support an arbitrary number of callback\nfunctions. This allows you to easily reuse parts of your route-handling code\nwith different route. This method is liberal in how it processes the\nspecified `callbacks`, you can specify them as separate arguments, or as\narrays, or both.\n\nIf multiple route match a given URL, they will be executed in the order they\nwere added. The first route that was added will be the first to be executed.\n\n**Passing Control**: Invoking the `next()` function within a route callback\nwill pass control to the next callback function (if any) or route handler\n(if any). If a value is passed to `next()`, it's assumed to be an error,\ntherefore stopping the dispatch chain, unless that value is: `\"route\"`,\nwhich is special case and dispatching will skip to the next route handler.\nThis allows middleware to skip any remaining middleware for a particular\nroute.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_route"
     },
     "save": {
      "!type": "fn(url?: string) -> !this",
      "!doc": "Saves a new browser history entry and dispatches to the first matching route\nhandler, if any.\n\nBehind the scenes, this method uses HTML5 `pushState()` in browsers that\nsupport it (or the location hash in older browsers and IE) to change the\nURL and create a history entry.\n\nThe specified URL must share the same origin (i.e., protocol, host, and\nport) as the current page, or an error will occur.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_save"
     },
     "upgrade": {
      "!type": "fn() -> bool",
      "!doc": "Upgrades a hash-based URL to an HTML5 URL if necessary. In non-HTML5\nbrowsers, this method is a noop.",
      "!url": "http://yuilibrary.com/classes/Router.html#method_upgrade"
     },
     "html5": {
      "!type": "fn()",
      "!doc": "Whether or not this browser is capable of using HTML5 history.\n\nSetting this to `false` will force the use of hash-based history even on\nHTML5 browsers, but please don't do this unless you understand the\nconsequences.",
      "!url": "http://yuilibrary.com/classes/Router.html#attribute_html5"
     },
     "params": {
      "!type": "fn()",
      "!doc": "Map of params handlers in the form: `name` -> RegExp | Function.\n\nIf a param handler regex or function returns a value of `false`, `null`,\n`undefined`, or `NaN`, the current route will not match and be skipped.\nAll other return values will be used in place of the original param\nvalue parsed from the URL.\n\nThis attribute is intended to be used to set params at init time, or to\ncompletely reset all params after init. To add params after init without\nresetting all existing params, use the `param()` method.",
      "!url": "http://yuilibrary.com/classes/Router.html#attribute_params"
     },
     "root": {
      "!type": "fn()",
      "!doc": "Absolute root path from which all routes should be evaluated.\n\nFor example, if your router is running on a page at\n`http://example.com/myapp/` and you add a route with the path `/`, your\nroute will never execute, because the path will always be preceded by\n`/myapp`. Setting `root` to `/myapp` would cause all routes to be\nevaluated relative to that root URL, so the `/` route would then execute\nwhen the user browses to `http://example.com/myapp/`.",
      "!url": "http://yuilibrary.com/classes/Router.html#attribute_root"
     },
     "routes": {
      "!type": "fn()",
      "!doc": "Array of route objects.\n\nEach item in the array must be an object with the following properties\nin order to be processed by the router:\n\n  * `path`: String or regex representing the path to match. See the docs\n    for the `route()` method for more details.\n\n  * `callbacks`: Function or a string representing the name of a\n    function on this router instance that should be called when the\n    route is triggered. An array of functions and/or strings may also be\n    provided. See the docs for the `route()` method for more details.\n\nIf a route object contains a `regex` or `regexp` property, or if its\n`path` is a regular express, then the route will be considered to be\nfully-processed. Any fully-processed routes may contain the following\nproperties:\n\n  * `regex`: The regular expression representing the path to match, this\n    property may also be named `regexp` for greater compatibility.\n\n  * `keys`: Array of named path parameters used to populate `req.params`\n    objects when dispatching to route handlers.\n\nAny additional data contained on these route objects will be retained.\nThis is useful to store extra metadata about a route; e.g., a `name` to\ngive routes logical names.\n\nThis attribute is intended to be used to set routes at init time, or to\ncompletely reset all routes after init. To add routes after init without\nresetting all existing routes, use the `route()` method.",
      "!url": "http://yuilibrary.com/classes/Router.html#attribute_routes"
     }
    },
    "dispatch": {
     "!type": "fn()",
     "!doc": "Dispatches to the first route handler that matches the specified `path` for\nall active router instances.\n\nThis provides a mechanism to cause all active router instances to dispatch\nto their route handlers without needing to change the URL or fire the\n`history:change` or `hashchange` event.",
     "!url": "http://yuilibrary.com/classes/Router.html#method_dispatch"
    }
   },
   "View": {
    "!type": "fn() -> +app.View",
    "!proto": "base.Base",
    "!doc": "Represents a logical piece of an application's user interface, and provides a\nlightweight, overridable API for rendering content and handling delegated DOM\nevents on a container element.\n\nThe View class imposes little structure and provides only minimal functionality\nof its own: it's basically just an overridable API interface that helps you\nimplement custom views.\n\nAs of YUI 3.5.0, View allows ad-hoc attributes to be specified at instantiation\ntime, so you don't need to subclass `Y.View` to add custom attributes. Just pass\nthem to the constructor:\n\n    var view = new Y.View({foo: 'bar'});\n    view.get('foo'); // => \"bar\"",
    "!url": "http://yuilibrary.com/classes/View.html",
    "prototype": {
     "containerTemplate": {
      "!type": "string",
      "!doc": "Template for this view's container.",
      "!url": "http://yuilibrary.com/classes/View.html#property_containerTemplate"
     },
     "events": {
      "!type": "+yui.Object",
      "!doc": "Hash of CSS selectors mapped to events to delegate to elements matching\nthose selectors.\n\nCSS selectors are relative to the `container` element. Events are attached\nto the container, and delegation is used so that subscribers are only\nnotified of events that occur on elements inside the container that match\nthe specified selectors. This allows the container's contents to be re-\nrendered as needed without losing event subscriptions.\n\nEvent handlers can be specified either as functions or as strings that map\nto function names on this view instance or its prototype.\n\nThe `this` object in event handlers will refer to this view instance. If\nyou'd prefer `this` to be something else, use `Y.bind()` to bind a custom\n`this` object.",
      "!url": "http://yuilibrary.com/classes/View.html#property_events"
     },
     "template": {
      "!type": "+mixed",
      "!doc": "Template for this view's contents.\n\nThis is a convenience property that has no default behavior of its own.\nIt's only provided as a convention to allow you to store whatever you\nconsider to be a template, whether that's an HTML string, a `Y.Node`\ninstance, a Mustache template, or anything else your little heart\ndesires.\n\nHow this template gets used is entirely up to you and your custom\n`render()` method.",
      "!url": "http://yuilibrary.com/classes/View.html#property_template"
     },
     "destroy": {
      "!type": "fn(options?: yui.Object) -> !this",
      "!doc": "Destroys this View, detaching any DOM events and optionally also destroying\nits container node.\n\nBy default, the container node will not be destroyed. Pass an _options_\nobject with a truthy `remove` property to destroy the container as well.",
      "!url": "http://yuilibrary.com/classes/View.html#method_destroy"
     },
     "attachEvents": {
      "!type": "fn(events?: yui.Object) -> !this",
      "!doc": "Attaches delegated event handlers to this view's container element. This\nmethod is called internally to subscribe to events configured in the\n`events` attribute when the view is initialized.\n\nYou may override this method to customize the event attaching logic.",
      "!url": "http://yuilibrary.com/classes/View.html#method_attachEvents"
     },
     "create": {
      "!type": "fn(container?: HTMLElement) -> +node.Node",
      "!doc": "Creates and returns a container node for this view.\n\nBy default, the container is created from the HTML template specified in the\n`containerTemplate` property, and is _not_ added to the DOM automatically.\n\nYou may override this method to customize how the container node is created\n(such as by rendering it from a custom template format). Your method must\nreturn a `Y.Node` instance.",
      "!url": "http://yuilibrary.com/classes/View.html#method_create"
     },
     "detachEvents": {
      "!type": "fn() -> !this",
      "!doc": "Detaches DOM events that have previously been attached to the container by\n`attachEvents()`.",
      "!url": "http://yuilibrary.com/classes/View.html#method_detachEvents"
     },
     "remove": {
      "!type": "fn() -> !this",
      "!doc": "Removes this view's container element from the DOM (if it's in the DOM),\nbut doesn't destroy it or any event listeners attached to it.",
      "!url": "http://yuilibrary.com/classes/View.html#method_remove"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Renders this view.\n\nThis method is a noop by default. Override it to provide a custom\nimplementation that renders this view's content and appends it to the\ncontainer element. Ideally your `render` method should also return `this` as\nthe end to allow chaining, but that's up to you.\n\nSince there's no default renderer, you're free to render your view however\nyou see fit, whether that means manipulating the DOM directly, dumping\nstrings into `innerHTML`, or using a template language of some kind.\n\nFor basic templating needs, `Y.Node.create()` and `Y.Lang.sub()` may\nsuffice, but there are no restrictions on what tools or techniques you can\nuse to render your view. All you need to do is append something to the\ncontainer element at some point, and optionally append the container\nto the DOM if it's not there already.",
      "!url": "http://yuilibrary.com/classes/View.html#method_render"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Container node into which this view's content will be rendered.\n\nThe container node serves as the host for all DOM events attached by the\nview. Delegation is used to handle events on children of the container,\nallowing the container's contents to be re-rendered at any time without\nlosing event subscriptions.\n\nThe default container is a `<div>` Node, but you can override this in\na subclass, or by passing in a custom `container` config value at\ninstantiation time. If you override the default container in a subclass\nusing `ATTRS`, you must use the `valueFn` property. The view's constructor\nwill ignore any assignments using `value`.\n\nWhen `container` is overridden by a subclass or passed as a config\noption at instantiation time, you can provide it as a selector string, a\nDOM element, a `Y.Node` instance, or (if you are subclassing and modifying\nthe attribute), a `valueFn` function that returns a `Y.Node` instance.\nThe value will be converted into a `Y.Node` instance if it isn't one\nalready.\n\nThe container is not added to the page automatically. This allows you to\nhave full control over how and when your view is actually rendered to\nthe page.",
      "!url": "http://yuilibrary.com/classes/View.html#attribute_container"
     }
    }
   }
  },
  "arraysort": {
   "ArraySort": {
    "!type": "fn()",
    "!doc": "Provides comparator functions useful for sorting arrays.",
    "!url": "http://yuilibrary.com/classes/ArraySort.html",
    "compare": {
     "!type": "fn(a: yui.Object, b: yui.Object, desc: bool) -> bool",
     "!doc": "Comparator function for simple case-insensitive sorting of an array of\nstrings.",
     "!url": "http://yuilibrary.com/classes/ArraySort.html#method_compare"
    },
    "naturalCompare": {
     "!type": "fn(a: number, b: number, options?: yui.Object) -> number",
     "!doc": "Performs a natural-order comparison of two strings or numbers (or a string\nand a number). This ensures that a value like 'foo2' will be sorted before\n'foo10', whereas a standard ASCII sort would sort 'foo10' first.",
     "!url": "http://yuilibrary.com/classes/ArraySort.html#method_naturalCompare"
    }
   }
  },
  "async_queue": {
   "AsyncQueue": {
    "!type": "fn(callback: fn()) -> +async_queue.AsyncQueue",
    "!proto": "event_custom.EventTarget",
    "!doc": "<p>A specialized queue class that supports scheduling callbacks to execute\nsequentially, iteratively, even asynchronously.</p>\n\n<p>Callbacks can be function refs or objects with the following keys.  Only\nthe <code>fn</code> key is required.</p>\n\n<ul>\n<li><code>fn</code> -- The callback function</li>\n<li><code>context</code> -- The execution context for the callbackFn.</li>\n<li><code>args</code> -- Arguments to pass to callbackFn.</li>\n<li><code>timeout</code> -- Millisecond delay before executing callbackFn.\n                    (Applies to each iterative execution of callback)</li>\n<li><code>iterations</code> -- Number of times to repeat the callback.\n<li><code>until</code> -- Repeat the callback until this function returns\n                        true.  This setting trumps iterations.</li>\n<li><code>autoContinue</code> -- Set to false to prevent the AsyncQueue from\n                       executing the next callback in the Queue after\n                       the callback completes.</li>\n<li><code>id</code> -- Name that can be used to get, promote, get the\n                       indexOf, or delete this callback.</li>\n</ul>",
    "!url": "http://yuilibrary.com/classes/AsyncQueue.html",
    "defaults": {
     "!type": "+yui.Object",
     "!doc": "<p>Static default values used to populate callback configuration properties.\nPreconfigured defaults include:</p>\n\n<ul>\n <li><code>autoContinue</code>: <code>true</code></li>\n <li><code>iterations</code>: 1</li>\n <li><code>timeout</code>: 10 (10ms between callbacks)</li>\n <li><code>until</code>: (function to run until iterations &lt;= 0)</li>\n</ul>",
     "!url": "http://yuilibrary.com/classes/AsyncQueue.html#property_defaults"
    },
    "prototype": {
     "defaults": {
      "!type": "+yui.Object",
      "!doc": "Callback defaults for this instance.  Static defaults that are not\noverridden are also included.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#property_defaults"
     },
     "next": {
      "!type": "fn() -> fn()",
      "!doc": "Returns the next callback needing execution.  If a callback is\nconfigured to repeat via iterations or until, it will be returned until\nthe completion criteria is met.\n\nWhen the queue is empty, null is returned.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_next"
     },
     "run": {
      "!type": "fn() -> !this",
      "!doc": "Sets the queue in motion.  All queued callbacks will be executed in\norder unless pause() or stop() is called or if one of the callbacks is\nconfigured with autoContinue: false.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_run"
     },
     "complete": {
      "!type": "fn()",
      "!doc": "Event fired when there is no remaining callback in the running queue. Also fired after stop().",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#event_complete"
     },
     "isRunning": {
      "!type": "fn() -> bool",
      "!doc": "Determines if the queue is waiting for a callback to complete execution.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_isRunning"
     },
     "add": {
      "!type": "fn(callback: fn()) -> !this",
      "!doc": "Add any number of callbacks to the end of the queue. Callbacks may be\nprovided as functions or objects.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_add"
     },
     "pause": {
      "!type": "fn() -> !this",
      "!doc": "Pause the execution of the queue after the execution of the current\ncallback completes.  If called from code outside of a queued callback,\nclears the timeout for the pending callback. Paused queue can be\nrestarted with q.run()",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_pause"
     },
     "stop": {
      "!type": "fn() -> !this",
      "!doc": "Stop and clear the queue after the current execution of the\ncurrent callback completes.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_stop"
     },
     "indexOf": {
      "!type": "fn(callback: string) -> number",
      "!doc": "Returns the current index of a callback.  Pass in either the id or\ncallback function from getCallback.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_indexOf"
     },
     "getCallback": {
      "!type": "fn(id: string) -> +yui.Object",
      "!doc": "Retrieve a callback by its id.  Useful to modify the configuration\nwhile the queue is running.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_getCallback"
     },
     "promote": {
      "!type": "fn(callback: string) -> !this",
      "!doc": "Promotes the named callback to the top of the queue. If a callback is\ncurrently executing or looping (via until or iterations), the promotion\nis scheduled to occur after the current callback has completed.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_promote"
     },
     "remove": {
      "!type": "fn(callback: string) -> !this",
      "!doc": "Removes the callback from the queue.  If the queue is active, the\nremoval is scheduled to occur after the current callback has completed.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_remove"
     },
     "size": {
      "!type": "fn() -> number",
      "!doc": "Returns the number of callbacks in the queue.",
      "!url": "http://yuilibrary.com/classes/AsyncQueue.html#method_size"
     }
    }
   }
  },
  "attribute": {
   "Attribute": {
    "!type": "fn(attrs: yui.Object, values: yui.Object, lazy: bool)",
    "!doc": "<p>\nAttribute provides configurable attribute support along with attribute change events. It is designed to be\naugmented on to a host class, and provides the host with the ability to configure attributes to store and retrieve state,\nalong with attribute change events.\n</p>\n<p>For example, attributes added to the host can be configured:</p>\n<ul>\n    <li>As read only.</li>\n    <li>As write once.</li>\n    <li>With a setter function, which can be used to manipulate\n    values passed to Attribute's <a href=\"#method_set\">set</a> method, before they are stored.</li>\n    <li>With a getter function, which can be used to manipulate stored values,\n    before they are returned by Attribute's <a href=\"#method_get\">get</a> method.</li>\n    <li>With a validator function, to validate values before they are stored.</li>\n</ul>\n\n<p>See the <a href=\"#method_addAttr\">addAttr</a> method, for the complete set of configuration\noptions available for attributes.</p>\n\n<p><strong>NOTE:</strong> Most implementations will be better off extending the <a href=\"Base.html\">Base</a> class,\ninstead of augmenting Attribute directly. Base augments Attribute and will handle the initial configuration\nof attributes for derived classes, accounting for values passed into the constructor.</p>",
    "!url": "http://yuilibrary.com/classes/Attribute.html",
    "INVALID_VALUE": {
     "!type": "+yui.Object",
     "!doc": "<p>The value to return from an attribute setter in order to prevent the set from going through.</p>\n\n<p>You can return this value from your setter if you wish to combine validator and setter\nfunctionality into a single setter function, which either returns the massaged value to be stored or\nAttributeCore.INVALID_VALUE to prevent invalid values from being stored.</p>",
     "!url": "http://yuilibrary.com/classes/Attribute.html#property_INVALID_VALUE"
    },
    "protectAttrs": {
     "!type": "fn(attrs: yui.Object) -> +yui.Object",
     "!doc": "Utility method to protect an attribute configuration hash, by merging the\nentire object and the individual attr config objects.",
     "!url": "http://yuilibrary.com/classes/Attribute.html#method_protectAttrs"
    }
   },
   "AttributeCore": {
    "!type": "fn(attrs: yui.Object, values: yui.Object, lazy: bool)",
    "!doc": "<p>\nAttributeCore provides the lightest level of configurable attribute support. It is designed to be\naugmented on to a host class, and provides the host with the ability to configure\nattributes to store and retrieve state, <strong>but without support for attribute change events</strong>.\n</p>\n<p>For example, attributes added to the host can be configured:</p>\n<ul>\n    <li>As read only.</li>\n    <li>As write once.</li>\n    <li>With a setter function, which can be used to manipulate\n    values passed to Attribute's <a href=\"#method_set\">set</a> method, before they are stored.</li>\n    <li>With a getter function, which can be used to manipulate stored values,\n    before they are returned by Attribute's <a href=\"#method_get\">get</a> method.</li>\n    <li>With a validator function, to validate values before they are stored.</li>\n</ul>\n\n<p>See the <a href=\"#method_addAttr\">addAttr</a> method, for the complete set of configuration\noptions available for attributes.</p>\n\n<p>Object/Classes based on AttributeCore can augment <a href=\"AttributeObservable.html\">AttributeObservable</a>\n(with true for overwrite) and <a href=\"AttributeExtras.html\">AttributeExtras</a> to add attribute event and\nadditional, less commonly used attribute methods, such as `modifyAttr`, `removeAttr` and `reset`.</p>",
    "!url": "http://yuilibrary.com/classes/AttributeCore.html",
    "INVALID_VALUE": {
     "!type": "+yui.Object",
     "!doc": "<p>The value to return from an attribute setter in order to prevent the set from going through.</p>\n\n<p>You can return this value from your setter if you wish to combine validator and setter\nfunctionality into a single setter function, which either returns the massaged value to be stored or\nAttributeCore.INVALID_VALUE to prevent invalid values from being stored.</p>",
     "!url": "http://yuilibrary.com/classes/AttributeCore.html#property_INVALID_VALUE"
    },
    "protectAttrs": {
     "!type": "fn(attrs: yui.Object) -> +yui.Object",
     "!doc": "Utility method to protect an attribute configuration hash, by merging the\nentire object and the individual attr config objects.",
     "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_protectAttrs"
    },
    "prototype": {
     "addAttr": {
      "!type": "fn(name: string, config: yui.Object, lazy: bool) -> !this",
      "!doc": "<p>\nAdds an attribute with the provided configuration to the host object.\n</p>\n<p>\nThe config argument object supports the following properties:\n</p>\n\n<dl>\n   <dt>value &#60;Any&#62;</dt>\n   <dd>The initial value to set on the attribute</dd>\n\n   <dt>valueFn &#60;Function | String&#62;</dt>\n   <dd>\n   <p>A function, which will return the initial value to set on the attribute. This is useful\n   for cases where the attribute configuration is defined statically, but needs to\n   reference the host instance (\"this\") to obtain an initial value. If both the value and valueFn properties are defined,\n   the value returned by the valueFn has precedence over the value property, unless it returns undefined, in which\n   case the value property is used.</p>\n\n   <p>valueFn can also be set to a string, representing the name of the instance method to be used to retrieve the value.</p>\n   </dd>\n\n   <dt>readOnly &#60;boolean&#62;</dt>\n   <dd>Whether or not the attribute is read only. Attributes having readOnly set to true\n       cannot be modified by invoking the set method.</dd>\n\n   <dt>writeOnce &#60;boolean&#62; or &#60;string&#62;</dt>\n   <dd>\n       Whether or not the attribute is \"write once\". Attributes having writeOnce set to true,\n       can only have their values set once, be it through the default configuration,\n       constructor configuration arguments, or by invoking set.\n       <p>The writeOnce attribute can also be set to the string \"initOnly\",\n        in which case the attribute can only be set during initialization\n       (when used with Base, this means it can only be set during construction)</p>\n   </dd>\n\n   <dt>setter &#60;Function | String&#62;</dt>\n   <dd>\n   <p>The setter function used to massage or normalize the value passed to the set method for the attribute.\n   The value returned by the setter will be the final stored value. Returning\n   <a href=\"#property_Attribute.INVALID_VALUE\">Attribute.INVALID_VALUE</a>, from the setter will prevent\n   the value from being stored.\n   </p>\n\n   <p>setter can also be set to a string, representing the name of the instance method to be used as the setter function.</p>\n   </dd>\n\n   <dt>getter &#60;Function | String&#62;</dt>\n   <dd>\n   <p>\n   The getter function used to massage or normalize the value returned by the get method for the attribute.\n   The value returned by the getter function is the value which will be returned to the user when they\n   invoke get.\n   </p>\n\n   <p>getter can also be set to a string, representing the name of the instance method to be used as the getter function.</p>\n   </dd>\n\n   <dt>validator &#60;Function | String&#62;</dt>\n   <dd>\n   <p>\n   The validator function invoked prior to setting the stored value. Returning\n   false from the validator function will prevent the value from being stored.\n   </p>\n\n   <p>validator can also be set to a string, representing the name of the instance method to be used as the validator function.</p>\n   </dd>\n\n   <dt>lazyAdd &#60;boolean&#62;</dt>\n   <dd>Whether or not to delay initialization of the attribute until the first call to get/set it.\n   This flag can be used to over-ride lazy initialization on a per attribute basis, when adding multiple attributes through\n   the <a href=\"#method_addAttrs\">addAttrs</a> method.</dd>\n\n</dl>\n\n<p>The setter, getter and validator are invoked with the value and name passed in as the first and second arguments, and with\nthe context (\"this\") set to the host object.</p>\n\n<p>Configuration properties outside of the list mentioned above are considered private properties used internally by attribute,\nand are not intended for public use.</p>",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_addAttr"
     },
     "attrAdded": {
      "!type": "fn(name: string) -> bool",
      "!doc": "Checks if the given attribute has been added to the host",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_attrAdded"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "Returns the current value of the attribute. If the attribute\nhas been configured with a 'getter' function, this method will delegate\nto the 'getter' to obtain the value of the attribute.",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_get"
     },
     "set": {
      "!type": "fn(name: string, value: Any, opts?: yui.Object) -> !this",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attrs: yui.Object, opts?: yui.Object) -> !this",
      "!doc": "Sets multiple attribute values.",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_setAttrs"
     },
     "getAttrs": {
      "!type": "fn(attrs: [string]) -> +yui.Object",
      "!doc": "Gets multiple attribute values.",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_getAttrs"
     },
     "addAttrs": {
      "!type": "fn(cfgs: yui.Object, values: yui.Object, lazy: bool) -> !this",
      "!doc": "Configures a group of attributes, and sets initial values.\n\n<p>\n<strong>NOTE:</strong> This method does not isolate the configuration object by merging/cloning.\nThe caller is responsible for merging/cloning the configuration object if required.\n</p>",
      "!url": "http://yuilibrary.com/classes/AttributeCore.html#method_addAttrs"
     }
    }
   },
   "AttributeExtras": {
    "!type": "fn()",
    "!doc": "A augmentable implementation for AttributeCore, providing less frequently used\nmethods for Attribute management such as modifyAttrs(), removeAttr and reset()",
    "!url": "http://yuilibrary.com/classes/AttributeExtras.html",
    "prototype": {
     "modifyAttr": {
      "!type": "fn(name: string, config: yui.Object)",
      "!doc": "Updates the configuration of an attribute which has already been added.\n<p>\nThe properties which can be modified through this interface are limited\nto the following subset of attributes, which can be safely modified\nafter a value has already been set on the attribute: readOnly, writeOnce,\nbroadcast and getter.\n</p>",
      "!url": "http://yuilibrary.com/classes/AttributeExtras.html#method_modifyAttr"
     },
     "removeAttr": {
      "!type": "fn(name: string)",
      "!doc": "Removes an attribute from the host object",
      "!url": "http://yuilibrary.com/classes/AttributeExtras.html#method_removeAttr"
     },
     "reset": {
      "!type": "fn(name: string) -> !this",
      "!doc": "Resets the attribute (or all attributes) to its initial value, as long as\nthe attribute is not readOnly, or writeOnce.",
      "!url": "http://yuilibrary.com/classes/AttributeExtras.html#method_reset"
     }
    }
   },
   "AttributeObservable": {
    "!type": "fn()",
    "!doc": "Provides an augmentable implementation of attribute change events for\nAttributeCore.",
    "!url": "http://yuilibrary.com/classes/AttributeObservable.html",
    "prototype": {
     "set": {
      "!type": "fn(name: string, value: Any, opts: yui.Object) -> !this",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/AttributeObservable.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attrs: yui.Object, opts: yui.Object) -> !this",
      "!doc": "Sets multiple attribute values.",
      "!url": "http://yuilibrary.com/classes/AttributeObservable.html#method_setAttrs"
     }
    }
   },
   "State": {
    "!type": "fn() -> +attribute.State",
    "!doc": "The State class maintains state for a collection of named items, with\na varying number of properties defined.\n\nIt avoids the need to create a separate class for the item, and separate instances\nof these classes for each item, by storing the state in a 2 level hash table,\nimproving performance when the number of items is likely to be large.",
    "!url": "http://yuilibrary.com/classes/State.html",
    "prototype": {
     "data": {
      "!type": "?",
      "!doc": "Hash of attributes",
      "!url": "http://yuilibrary.com/classes/State.html#property_data"
     },
     "add": {
      "!type": "fn(name: string, key: string, val: Any)",
      "!doc": "Adds a property to an item.",
      "!url": "http://yuilibrary.com/classes/State.html#method_add"
     },
     "addAll": {
      "!type": "fn(name: string, obj: yui.Object)",
      "!doc": "Adds multiple properties to an item.",
      "!url": "http://yuilibrary.com/classes/State.html#method_addAll"
     },
     "remove": {
      "!type": "fn(name: string, key: string)",
      "!doc": "Removes a property from an item.",
      "!url": "http://yuilibrary.com/classes/State.html#method_remove"
     },
     "removeAll": {
      "!type": "fn(name: string, obj: yui.Object)",
      "!doc": "Removes multiple properties from an item, or removes the item completely.",
      "!url": "http://yuilibrary.com/classes/State.html#method_removeAll"
     },
     "get": {
      "!type": "fn(name: string, key: string) -> +Any",
      "!doc": "For a given item, returns the value of the property requested, or undefined if not found.",
      "!url": "http://yuilibrary.com/classes/State.html#method_get"
     },
     "getAll": {
      "!type": "fn(name: string, reference: bool) -> +yui.Object",
      "!doc": "For the given item, returns an object with all of the\nitem's property/value pairs. By default the object returned\nis a shallow copy of the stored data, but passing in true\nas the second parameter will return a reference to the stored\ndata.",
      "!url": "http://yuilibrary.com/classes/State.html#method_getAll"
     }
    }
   }
  },
  "autocomplete": {
   "AutoCompleteBase": {
    "!type": "fn()",
    "!doc": "Extension that provides core autocomplete logic (but no UI implementation) for a\ntext input field or textarea.\n\nThe `AutoCompleteBase` class provides events and attributes that abstract away\ncore autocomplete logic and configuration, but does not provide a widget\nimplementation or suggestion UI. For a prepackaged autocomplete widget, see\n`AutoCompleteList`.\n\nThis extension cannot be instantiated directly, since it doesn't provide an\nactual implementation. It's intended to be mixed into a `Y.Base`-based class or\nwidget.\n\n`Y.Widget`-based example:\n\n    YUI().use('autocomplete-base', 'widget', function (Y) {\n        var MyAC = Y.Base.create('myAC', Y.Widget, [Y.AutoCompleteBase], {\n            // Custom prototype methods and properties.\n        }, {\n            // Custom static methods and properties.\n        });\n\n        // Custom implementation code.\n    });\n\n`Y.Base`-based example:\n\n    YUI().use('autocomplete-base', function (Y) {\n        var MyAC = Y.Base.create('myAC', Y.Base, [Y.AutoCompleteBase], {\n            initializer: function () {\n                this._bindUIACBase();\n                this._syncUIACBase();\n            },\n\n            // Custom prototype methods and properties.\n        }, {\n            // Custom static methods and properties.\n        });\n\n        // Custom implementation code.\n    });",
    "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html",
    "prototype": {
     "clear": {
      "!type": "fn(prevVal: string, src: string)",
      "!doc": "Fires after the query has been completely cleared or no longer meets the\nminimum query length requirement.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#event_clear"
     },
     "query": {
      "!type": "fn()",
      "!doc": "Current query, or `null` if there is no current query.\n\nThe query might not be the same as the current value of the input node, both\nfor timing reasons (due to `queryDelay`) and because when one or more\n`queryDelimiter` separators are in use, only the last portion of the\ndelimited input string will be used as the query value.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_query"
     },
     "results": {
      "!type": "fn()",
      "!doc": "Current results, or an empty array if there are no results.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_results"
     },
     "clearCache": {
      "!type": "fn() -> !this",
      "!doc": "Clears the result cache.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#method_clearCache"
     },
     "sendRequest": {
      "!type": "fn(query?: string, requestTemplate?: fn()) -> !this",
      "!doc": "Sends a request to the configured source. If no source is configured, this\nmethod won't do anything.\n\nUsually there's no reason to call this method manually; it will be called\nautomatically when user input causes a `query` event to be fired. The only\ntime you'll need to call this method manually is if you want to force a\nrequest to be sent when no user input has occurred.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#method_sendRequest"
     },
     "allowBrowserAutocomplete": {
      "!type": "fn()",
      "!doc": "Whether or not to enable the browser's built-in autocomplete functionality\nfor input fields.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_allowBrowserAutocomplete"
     },
     "allowTrailingDelimiter": {
      "!type": "fn()",
      "!doc": "When a `queryDelimiter` is set, trailing delimiters will automatically be\nstripped from the input value by default when the input node loses focus.\nSet this to `true` to allow trailing delimiters.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_allowTrailingDelimiter"
     },
     "enableCache": {
      "!type": "fn()",
      "!doc": "Whether or not to enable in-memory caching in result sources that support\nit.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_enableCache"
     },
     "inputNode": {
      "!type": "fn()",
      "!doc": "Node to monitor for changes, which will generate `query` events when\nappropriate. May be either an `<input>` or a `<textarea>`.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_inputNode"
     },
     "maxResults": {
      "!type": "fn()",
      "!doc": "Maximum number of results to return. A value of `0` or less will allow an\nunlimited number of results.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_maxResults"
     },
     "minQueryLength": {
      "!type": "fn()",
      "!doc": "Minimum number of characters that must be entered before a `query` event\nwill be fired. A value of `0` allows empty queries; a negative value will\neffectively disable all `query` events.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_minQueryLength"
     },
     "queryDelay": {
      "!type": "fn()",
      "!doc": "Number of milliseconds to delay after input before triggering a `query`\nevent. If new input occurs before this delay is over, the previous input\nevent will be ignored and a new delay will begin.\n\nThis can be useful both to throttle queries to a remote data source and to\navoid distracting the user by showing them less relevant results before\nthey've paused their typing.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_queryDelay"
     },
     "queryDelimiter": {
      "!type": "fn()",
      "!doc": "Query delimiter string. When a delimiter is configured, the input value\nwill be split on the delimiter, and only the last portion will be used in\nautocomplete queries and updated when the `query` attribute is\nmodified.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_queryDelimiter"
     },
     "requestTemplate": {
      "!type": "fn()",
      "!doc": "Source request template. This can be a function that accepts a query as a\nparameter and returns a request string, or it can be a string containing the\nplaceholder \"{query}\", which will be replaced with the actual URI-encoded\nquery. In either case, the resulting string will be appended to the request\nURL when the `source` attribute is set to a remote DataSource, JSONP URL, or\nXHR URL (it will not be appended to YQL URLs).\n\nWhile `requestTemplate` may be set to either a function or a string, it will\nalways be returned as a function that accepts a query argument and returns a\nstring.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_requestTemplate"
     },
     "resultFilters": {
      "!type": "fn()",
      "!doc": "Array of local result filter functions. If provided, each filter will be\ncalled with two arguments when results are received: the query and an array\nof result objects. See the documentation for the `results` event for a list\nof the properties available on each result object.\n\nEach filter is expected to return a filtered or modified version of the\nresults array, which will then be passed on to subsequent filters, then the\n`resultHighlighter` function (if set), then the `resultFormatter` function\n(if set), and finally to subscribers to the `results` event.\n\nIf no `source` is set, result filters will not be called.\n\nPrepackaged result filters provided by the autocomplete-filters and\nautocomplete-filters-accentfold modules can be used by specifying the filter\nname as a string, such as `'phraseMatch'` (assuming the necessary filters\nmodule is loaded).",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_resultFilters"
     },
     "resultFormatter": {
      "!type": "fn()",
      "!doc": "Function which will be used to format results. If provided, this function\nwill be called with two arguments after results have been received and\nfiltered: the query and an array of result objects. The formatter is\nexpected to return an array of HTML strings or Node instances containing the\ndesired HTML for each result.\n\nSee the documentation for the `results` event for a list of the properties\navailable on each result object.\n\nIf no `source` is set, the formatter will not be called.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_resultFormatter"
     },
     "resultHighlighter": {
      "!type": "fn()",
      "!doc": "Function which will be used to highlight results. If provided, this function\nwill be called with two arguments after results have been received and\nfiltered: the query and an array of filtered result objects. The highlighter\nis expected to return an array of highlighted result text in the form of\nHTML strings.\n\nSee the documentation for the `results` event for a list of the properties\navailable on each result object.\n\nIf no `source` is set, the highlighter will not be called.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_resultHighlighter"
     },
     "resultListLocator": {
      "!type": "fn()",
      "!doc": "Locator that should be used to extract an array of results from a non-array\nresponse.\n\nBy default, no locator is applied, and all responses are assumed to be\narrays by default. If all responses are already arrays, you don't need to\ndefine a locator.\n\nThe locator may be either a function (which will receive the raw response as\nan argument and must return an array) or a string representing an object\npath, such as \"foo.bar.baz\" (which would return the value of\n`result.foo.bar.baz` if the response is an object).\n\nWhile `resultListLocator` may be set to either a function or a string, it\nwill always be returned as a function that accepts a response argument and\nreturns an array.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_resultListLocator"
     },
     "resultTextLocator": {
      "!type": "fn()",
      "!doc": "Locator that should be used to extract a plain text string from a non-string\nresult item. The resulting text value will typically be the value that ends\nup being inserted into an input field or textarea when the user of an\nautocomplete implementation selects a result.\n\nBy default, no locator is applied, and all results are assumed to be plain\ntext strings. If all results are already plain text strings, you don't need\nto define a locator.\n\nThe locator may be either a function (which will receive the raw result as\nan argument and must return a string) or a string representing an object\npath, such as \"foo.bar.baz\" (which would return the value of\n`result.foo.bar.baz` if the result is an object).\n\nWhile `resultTextLocator` may be set to either a function or a string, it\nwill always be returned as a function that accepts a result argument and\nreturns a string.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_resultTextLocator"
     },
     "source": {
      "!type": "fn()",
      "!doc": "Source for autocomplete results. The following source types are supported:\n\n<dl>\n  <dt>Array</dt>\n  <dd>\n    <p>\n    The full array will be provided to any configured filters for each\n    query. This is an easy way to create a fully client-side autocomplete\n    implementation.\n    </p>\n\n    <p>\n    Example: `['first result', 'second result', 'etc']`\n    </p>\n  </dd>\n\n  <dt>DataSource</dt>\n  <dd>\n    A `DataSource` instance or other object that provides a DataSource-like\n    `sendRequest` method. See the `DataSource` documentation for details.\n  </dd>\n\n  <dt>Function</dt>\n  <dd>\n    <p>\n    A function source will be called with the current query and a\n    callback function as parameters, and should either return an array of\n    results (for synchronous operation) or return nothing and pass an\n    array of results to the provided callback (for asynchronous\n    operation).\n    </p>\n\n    <p>\n    Example (synchronous):\n    </p>\n\n    <pre>\n    function (query) {\n        return ['foo', 'bar'];\n    }\n    </pre>\n\n    <p>\n    Example (async):\n    </p>\n\n    <pre>\n    function (query, callback) {\n        callback(['foo', 'bar']);\n    }\n    </pre>\n  </dd>\n\n  <dt>Object</dt>\n  <dd>\n    <p>\n    An object will be treated as a query hashmap. If a property on the\n    object matches the current query, the value of that property will be\n    used as the response.\n    </p>\n\n    <p>\n    The response is assumed to be an array of results by default. If the\n    response is not an array, provide a `resultListLocator` to\n    process the response and return an array.\n    </p>\n\n    <p>\n    Example: `{foo: ['foo result 1', 'foo result 2'], bar: ['bar result']}`\n    </p>\n  </dd>\n</dl>\n\nIf the optional `autocomplete-sources` module is loaded, then\nthe following additional source types will be supported as well:\n\n<dl>\n  <dt>&lt;select&gt; Node</dt>\n  <dd>\n    You may provide a YUI Node instance wrapping a &lt;select&gt;\n    element, and the options in the list will be used as results. You\n    will also need to specify a `resultTextLocator` of 'text'\n    or 'value', depending on what you want to use as the text of the\n    result.\n\n    Each result will be an object with the following properties:\n\n    <dl>\n      <dt>html (String)</dt>\n      <dd>\n        <p>HTML content of the &lt;option&gt; element.</p>\n      </dd>\n\n      <dt>index (Number)</dt>\n      <dd>\n        <p>Index of the &lt;option&gt; element in the list.</p>\n      </dd>\n\n      <dt>node (Y.Node)</dt>\n      <dd>\n        <p>Node instance referring to the original &lt;option&gt; element.</p>\n      </dd>\n\n      <dt>selected (Boolean)</dt>\n      <dd>\n        <p>Whether or not this item is currently selected in the\n        &lt;select&gt; list.</p>\n      </dd>\n\n      <dt>text (String)</dt>\n      <dd>\n        <p>Text content of the &lt;option&gt; element.</p>\n      </dd>\n\n      <dt>value (String)</dt>\n      <dd>\n        <p>Value of the &lt;option&gt; element.</p>\n      </dd>\n    </dl>\n  </dd>\n\n  <dt>String (JSONP URL)</dt>\n  <dd>\n    <p>\n    If a URL with a `{callback}` placeholder is provided, it will be used to\n    make a JSONP request. The `{query}` placeholder will be replaced with\n    the current query, and the `{callback}` placeholder will be replaced\n    with an internally-generated JSONP callback name. Both placeholders must\n    appear in the URL, or the request will fail. An optional `{maxResults}`\n    placeholder may also be provided, and will be replaced with the value of\n    the maxResults attribute (or 1000 if the maxResults attribute is 0 or\n    less).\n    </p>\n\n    <p>\n    The response is assumed to be an array of results by default. If the\n    response is not an array, provide a `resultListLocator` to process the\n    response and return an array.\n    </p>\n\n    <p>\n    <strong>The `jsonp` module must be loaded in order for\n    JSONP URL sources to work.</strong> If the `jsonp` module\n    is not already loaded, it will be loaded on demand if possible.\n    </p>\n\n    <p>\n    Example: `'http://example.com/search?q={query}&callback={callback}'`\n    </p>\n  </dd>\n\n  <dt>String (XHR URL)</dt>\n  <dd>\n    <p>\n    If a URL without a `{callback}` placeholder is provided, it will be used\n    to make a same-origin XHR request. The `{query}` placeholder will be\n    replaced with the current query. An optional `{maxResults}` placeholder\n    may also be provided, and will be replaced with the value of the\n    maxResults attribute (or 1000 if the maxResults attribute is 0 or less).\n    </p>\n\n    <p>\n    The response is assumed to be a JSON array of results by default. If the\n    response is a JSON object and not an array, provide a\n    `resultListLocator` to process the response and return an array. If the\n    response is in some form other than JSON, you will need to use a custom\n    DataSource instance as the source.\n    </p>\n\n    <p>\n    <strong>The `io-base` and `json-parse` modules\n    must be loaded in order for XHR URL sources to work.</strong> If\n    these modules are not already loaded, they will be loaded on demand\n    if possible.\n    </p>\n\n    <p>\n    Example: `'http://example.com/search?q={query}'`\n    </p>\n  </dd>\n\n  <dt>String (YQL query)</dt>\n  <dd>\n    <p>\n    If a YQL query is provided, it will be used to make a YQL request. The\n    `{query}` placeholder will be replaced with the current autocomplete\n    query. This placeholder must appear in the YQL query, or the request\n    will fail. An optional `{maxResults}` placeholder may also be provided,\n    and will be replaced with the value of the maxResults attribute (or 1000\n    if the maxResults attribute is 0 or less).\n    </p>\n\n    <p>\n    <strong>The `yql` module must be loaded in order for YQL\n    sources to work.</strong> If the `yql` module is not\n    already loaded, it will be loaded on demand if possible.\n    </p>\n\n    <p>\n    Example: `'select * from search.suggest where query=\"{query}\"'`\n    </p>\n  </dd>\n</dl>\n\nAs an alternative to providing a source, you could simply listen for `query`\nevents and handle them any way you see fit. Providing a source is optional,\nbut will usually be simpler.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_source"
     },
     "sourceType": {
      "!type": "fn()",
      "!doc": "May be used to force a specific source type, overriding the automatic source\ntype detection. It should almost never be necessary to do this, but as they\ntaught us in the Boy Scouts, one should always be prepared, so it's here if\nyou need it. Be warned that if you set this attribute and something breaks,\nit's your own fault.\n\nSupported `sourceType` values are: 'array', 'datasource', 'function', and\n'object'.\n\nIf the `autocomplete-sources` module is loaded, the following additional\nsource types are supported: 'io', 'jsonp', 'select', 'string', 'yql'",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_sourceType"
     },
     "tokenInput": {
      "!type": "fn()",
      "!doc": "If the `inputNode` specified at instantiation time has a `node-tokeninput`\nplugin attached to it, this attribute will be a reference to the\n`Y.Plugin.TokenInput` instance.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_tokenInput"
     },
     "value": {
      "!type": "fn()",
      "!doc": "Current value of the input node.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_value"
     },
     "yqlEnv": {
      "!type": "fn()",
      "!doc": "YQL environment file URL to load when the `source` is set to a YQL query.\nSet this to `null` to use the default Open Data Tables environment file\n(http://datatables.org/alltables.env).",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_yqlEnv"
     },
     "yqlProtocol": {
      "!type": "fn()",
      "!doc": "URL protocol to use when the `source` is set to a YQL query.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#attribute_yqlProtocol"
     }
    },
    "SOURCE_TYPES": {
     "!type": "+yui.Object",
     "!doc": "Mapping of built-in source types to their setter functions. DataSource instances\nand DataSource-like objects are handled natively, so are not mapped here.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteBase.html#property_SOURCE_TYPES"
    }
   },
   "AutoCompleteFilters": {
    "!type": "fn()",
    "!doc": "Provides pre-built result matching filters for AutoComplete.",
    "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html",
    "charMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `charMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_charMatchFold"
    },
    "phraseMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `phraseMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_phraseMatchFold"
    },
    "startsWithFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `startsWith()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_startsWithFold"
    },
    "subWordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `subWordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_subWordMatchFold"
    },
    "wordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent folding version of `wordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_wordMatchFold"
    },
    "charMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that contain all of the characters in the query,\nin any order (not necessarily consecutive). Case-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_charMatch"
    },
    "charMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `charMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_charMatchCase"
    },
    "phraseMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that contain the complete query as a phrase.\nCase-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_phraseMatch"
    },
    "phraseMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `phraseMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_phraseMatchCase"
    },
    "startsWith": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that start with the complete query as a phrase.\nCase-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_startsWith"
    },
    "startsWithCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `startsWith()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_startsWithCase"
    },
    "subWordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results in which all the words of the query match either\nwhole words or parts of words in the result. Non-word characters like\nwhitespace and certain punctuation are ignored. Case-insensitive.\n\nThis is basically a combination of `wordMatch()` (by ignoring whitespace and\nword order) and `phraseMatch()` (by allowing partial matching instead of\nrequiring the entire word to match).\n\nExample use case: Trying to find personal names independently of name order\n(Western or Eastern order) and supporting immediate feedback by allowing\npartial occurences. So queries like \"J. Doe\", \"Doe, John\", and \"J. D.\" would\nall match \"John Doe\".",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_subWordMatch"
    },
    "subWordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `subWordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_subWordMatchCase"
    },
    "wordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Returns an array of results that contain all of the words in the query, in\nany order. Non-word characters like whitespace and certain punctuation are\nignored. Case-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_wordMatch"
    },
    "wordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `wordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteFilters.html#method_wordMatchCase"
    }
   },
   "AutoCompleteHighlighters": {
    "!type": "fn()",
    "!doc": "Provides pre-built result highlighters for AutoComplete.",
    "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html",
    "charMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `charMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_charMatchFold"
    },
    "phraseMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `phraseMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_phraseMatchFold"
    },
    "startsWithFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `startsWith()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_startsWithFold"
    },
    "subWordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `subWordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_subWordMatchFold"
    },
    "wordMatchFold": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Accent-folding version of `wordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_wordMatchFold"
    },
    "charMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights any individual query character that occurs anywhere in a result.\nCase-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_charMatch"
    },
    "charMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `charMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_charMatchCase"
    },
    "phraseMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights the complete query as a phrase anywhere within a result. Case-\ninsensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_phraseMatch"
    },
    "phraseMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `phraseMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_phraseMatchCase"
    },
    "startsWith": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights the complete query as a phrase at the beginning of a result.\nCase-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_startsWith"
    },
    "startsWithCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `startsWith()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_startsWithCase"
    },
    "subWordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights portions of results in which words from the query match either\nwhole words or parts of words in the result. Non-word characters like\nwhitespace and certain punctuation are ignored. Case-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_subWordMatch"
    },
    "subWordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `subWordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_subWordMatchCase"
    },
    "wordMatch": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Highlights individual words in results that are also in the query. Non-word\ncharacters like punctuation are ignored. Case-insensitive.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_wordMatch"
    },
    "wordMatchCase": {
     "!type": "fn(query: string, results: yui.Array) -> +yui.Array",
     "!doc": "Case-sensitive version of `wordMatch()`.",
     "!url": "http://yuilibrary.com/classes/AutoCompleteHighlighters.html#method_wordMatchCase"
    }
   },
   "AutoCompleteList": {
    "!type": "fn(config: yui.Object) -> +autocomplete.AutoCompleteList",
    "!proto": "widget.Widget",
    "!doc": "Traditional autocomplete dropdown list widget, just like Mom used to make.",
    "!url": "http://yuilibrary.com/classes/AutoCompleteList.html",
    "prototype": {
     "select": {
      "!type": "fn(itemNode: node.Node, result: yui.Object)",
      "!doc": "Fires when an autocomplete suggestion is selected from the list,\ntypically via a keyboard action or mouse click.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#event_select"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Hides the list, unless the `alwaysShowList` attribute is `true`.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#method_hide"
     },
     "selectItem": {
      "!type": "fn(itemNode?: node.Node, originEvent?: event_custom.EventFacade) -> !this",
      "!doc": "Selects the specified _itemNode_, or the current `activeItem` if _itemNode_\nis not specified.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#method_selectItem"
     },
     "activateFirstItem": {
      "!type": "fn()",
      "!doc": "If `true`, the first item in the list will be activated by default when\nthe list is initially displayed and when results change.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_activateFirstItem"
     },
     "activeItem": {
      "!type": "fn()",
      "!doc": "Item that's currently active, if any. When the user presses enter, this\nis the item that will be selected.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_activeItem"
     },
     "alwaysShowList": {
      "!type": "fn()",
      "!doc": "If `true`, the list will remain visible even when there are no results\nto display.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_alwaysShowList"
     },
     "circular": {
      "!type": "fn()",
      "!doc": "If `true`, keyboard navigation will wrap around to the opposite end of\nthe list when navigating past the first or last item.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_circular"
     },
     "hoveredItem": {
      "!type": "fn()",
      "!doc": "Item currently being hovered over by the mouse, if any.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_hoveredItem"
     },
     "listNode": {
      "!type": "fn()",
      "!doc": "Node that will contain result items.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_listNode"
     },
     "scrollIntoView": {
      "!type": "fn()",
      "!doc": "If `true`, the viewport will be scrolled to ensure that the active list\nitem is visible when necessary.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_scrollIntoView"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Translatable strings used by the AutoCompleteList widget.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_strings"
     },
     "tabSelect": {
      "!type": "fn()",
      "!doc": "If `true`, pressing the tab key while the list is visible will select\nthe active item, if any.",
      "!url": "http://yuilibrary.com/classes/AutoCompleteList.html#attribute_tabSelect"
     }
    }
   }
  },
  "base": {
   "Base": {
    "!type": "fn(config: yui.Object) -> +base.Base",
    "!doc": "<p>\nA base class which objects requiring attributes and custom event support can\nextend. Base also handles the chaining of initializer and destructor methods across\nthe hierarchy as part of object construction and destruction. Additionally, attributes configured\nthrough the static <a href=\"#property_ATTRS\">ATTRS</a> property for each class\nin the hierarchy will be initialized by Base.\n</p>\n\n<p>\n**NOTE:** Prior to version 3.11.0, ATTRS would get added a class at a time. That is,\nBase would loop through each class in the hierarchy, and add the class' ATTRS, and\nthen call it's initializer, and move on to the subclass' ATTRS and initializer. As of\n3.11.0, ATTRS from all classes in the hierarchy are added in one `addAttrs` call before\nany initializers are called. This fixes subtle edge-case issues with subclass ATTRS overriding\nsuperclass `setter`, `getter` or `valueFn` definitions and being unable to get/set attributes\ndefined by the subclass. This order of operation change may impact `setter`, `getter` or `valueFn`\ncode which expects a superclass' initializer to have run. This is expected to be rare, but to support\nit, Base supports a `_preAddAttrs()`, method hook (same signature as `addAttrs`). Components can\nimplement this method on their prototype for edge cases which do require finer control over\nthe order in which attributes are added (see widget-htmlparser).\n</p>\n\n<p>\nThe static <a href=\"#property_NAME\">NAME</a> property of each class extending\nfrom Base will be used as the identifier for the class, and is used by Base to prefix\nall events fired by instances of that class.\n</p>",
    "!url": "http://yuilibrary.com/classes/Base.html",
    "NAME": {
     "!type": "string",
     "!doc": "<p>\nThe string to be used to identify instances of\nthis class, for example in prefixing events.\n</p>\n<p>\nClasses extending Base, should define their own\nstatic NAME property, which should be camelCase by\nconvention (e.g. MyClass.NAME = \"myClass\";).\n</p>",
     "!url": "http://yuilibrary.com/classes/Base.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "The default set of attributes which will be available for instances of this class, and\ntheir configuration. In addition to the configuration properties listed by\nAttribute's <a href=\"Attribute.html#method_addAttr\">addAttr</a> method, the attribute\ncan also be configured with a \"cloneDefaultValue\" property, which defines how the statically\ndefined value field should be protected (\"shallow\", \"deep\" and false are supported values).\n\nBy default if the value is an object literal or an array it will be \"shallow\" cloned, to\nprotect the default value.",
     "!url": "http://yuilibrary.com/classes/Base.html#property_ATTRS"
    },
    "modifyAttrs": {
     "!type": "fn(ctor?: fn(), configs: yui.Object)",
     "!doc": "Provides a way to safely modify a `Y.Base` subclass' static `ATTRS` after\nthe class has been defined or created.\n\nBase-based classes cache information about the class hierarchy in order to\nefficiently create instances. This cache includes includes the aggregated\n`ATTRS` configs. If the static `ATTRS` configs need to be modified after the\nclass has been defined or create, then use this method which will make sure\nto clear any cached data before making any modifications.",
     "!url": "http://yuilibrary.com/classes/Base.html#method_modifyAttrs"
    },
    "build": {
     "!type": "fn(name: fn(), main: fn(), extensions: fn(), cfg: yui.Object) -> fn()",
     "!doc": "<p>\nBuilds a custom constructor function (class) from the\nmain function, and array of extension functions (classes)\nprovided. The NAME field for the constructor function is\ndefined by the first argument passed in.\n</p>\n<p>\nThe cfg object supports the following properties\n</p>\n<dl>\n   <dt>dynamic &#60;boolean&#62;</dt>\n   <dd>\n   <p>If true (default), a completely new class\n   is created which extends the main class, and acts as the\n   host on which the extension classes are augmented.</p>\n   <p>If false, the extensions classes are augmented directly to\n   the main class, modifying the main class' prototype.</p>\n   </dd>\n   <dt>aggregates &#60;String[]&#62;</dt>\n   <dd>An array of static property names, which will get aggregated\n   on to the built class, in addition to the default properties build\n   will always aggregate as defined by the main class' static _buildCfg\n   property.\n   </dd>\n</dl>",
     "!url": "http://yuilibrary.com/classes/Base.html#method_build"
    },
    "create": {
     "!type": "fn(name: string, main: fn(), extensions: fn(), px: yui.Object, sx: yui.Object) -> fn()",
     "!doc": "Creates a new class (constructor function) which extends the base class passed in as the second argument,\nand mixes in the array of extensions provided.\n\nPrototype properties or methods can be added to the new class, using the px argument (similar to Y.extend).\n\nStatic properties or methods can be added to the new class, using the sx argument (similar to Y.extend).\n\n**NOTE FOR COMPONENT DEVELOPERS**: Both the `base` class, and `extensions` can define static a `_buildCfg`\nproperty, which acts as class creation meta-data, and drives how special static properties from the base\nclass, or extensions should be copied, aggregated or (custom) mixed into the newly created class.\n\nThe `_buildCfg` property is a hash with 3 supported properties: `statics`, `aggregates` and `custom`, e.g:\n\n    // If the Base/Main class is the thing introducing the property:\n\n    MyBaseClass._buildCfg = {\n\n       // Static properties/methods to copy (Alias) to the built class.\n       statics: [\"CopyThisMethod\", \"CopyThisProperty\"],\n\n       // Static props to aggregate onto the built class.\n       aggregates: [\"AggregateThisProperty\"],\n\n       // Static properties which need custom handling (e.g. deep merge etc.)\n       custom: {\n          \"CustomProperty\" : function(property, Receiver, Supplier) {\n             ...\n             var triggers = Receiver.CustomProperty.triggers;\n             Receiver.CustomProperty.triggers = triggers.concat(Supplier.CustomProperty.triggers);\n             ...\n          }\n       }\n    };\n\n    MyBaseClass.CopyThisMethod = function() {...};\n    MyBaseClass.CopyThisProperty = \"foo\";\n    MyBaseClass.AggregateThisProperty = {...};\n    MyBaseClass.CustomProperty = {\n       triggers: [...]\n    }\n\n    // Or, if the Extension is the thing introducing the property:\n\n    MyExtension._buildCfg = {\n        statics : ...\n        aggregates : ...\n        custom : ...\n    }\n\nThis way, when users pass your base or extension class to `Y.Base.create` or `Y.Base.mix`, they don't need to\nknow which properties need special handling. `Y.Base` has a buildCfg which defines `ATTRS` for custom mix handling\n(to protect the static config objects), and `Y.Widget` has a buildCfg which specifies `HTML_PARSER` for\nstraight up aggregation.",
     "!url": "http://yuilibrary.com/classes/Base.html#method_create"
    },
    "mix": {
     "!type": "fn(main: fn(), extensions: fn()) -> fn()",
     "!doc": "<p>Mixes in a list of extensions to an existing class.</p>",
     "!url": "http://yuilibrary.com/classes/Base.html#method_mix"
    },
    "plug": {
     "!type": "fn()",
     "!doc": "Alias for <a href=\"Plugin.Host.html#method_Plugin.Host.plug\">Plugin.Host.plug</a>. See aliased\nmethod for argument and return value details.",
     "!url": "http://yuilibrary.com/classes/Base.html#method_plug"
    },
    "unplug": {
     "!type": "fn()",
     "!doc": "Alias for <a href=\"Plugin.Host.html#method_Plugin.Host.unplug\">Plugin.Host.unplug</a>. See the\naliased method for argument and return value details.",
     "!url": "http://yuilibrary.com/classes/Base.html#method_unplug"
    }
   },
   "BaseCore": {
    "!type": "fn(cfg: yui.Object) -> +base.BaseCore",
    "!doc": "The BaseCore class, is the lightest version of Base, and provides Base's\nbasic lifecycle management and ATTRS construction support, but doesn't\nfire init/destroy or attribute change events.\n\nBaseCore also handles the chaining of initializer and destructor methods across\nthe hierarchy as part of object construction and destruction. Additionally, attributes\nconfigured through the static <a href=\"#property_BaseCore.ATTRS\">ATTRS</a>\nproperty for each class in the hierarchy will be initialized by BaseCore.\n\nClasses which require attribute support, but don't intend to use/expose attribute\nchange events can extend BaseCore instead of Base for optimal kweight and\nruntime performance.\n\n**3.11.0 BACK COMPAT NOTE FOR COMPONENT DEVELOPERS**\n\nPrior to version 3.11.0, ATTRS would get added a class at a time. That is:\n\n<pre>\n   for each (class in the hierarchy) {\n      Call the class Extension constructors.\n\n      Add the class ATTRS.\n\n      Call the class initializer\n      Call the class Extension initializers.\n   }\n</pre>\n\nAs of 3.11.0, ATTRS from all classes in the hierarchy are added in one `addAttrs` call\nbefore **any** initializers are called. That is, the flow becomes:\n\n<pre>\n   for each (class in the hierarchy) {\n      Call the class Extension constructors.\n   }\n\n   Add ATTRS for all classes\n\n   for each (class in the hierarchy) {\n      Call the class initializer.\n      Call the class Extension initializers.\n   }\n</pre>\n\nAdding all ATTRS at once fixes subtle edge-case issues with subclass ATTRS overriding\nsuperclass `setter`, `getter` or `valueFn` definitions and being unable to get/set attributes\ndefined by the subclass. It also leaves us with a cleaner order of operation flow moving\nforward.\n\nHowever, it may require component developers to upgrade their components, for the following\nscenarios:\n\n1. It impacts components which may have `setter`, `getter` or `valueFn` code which\nexpects a superclass' initializer to have run.\n\nThis is expected to be rare, but to support it, Base now supports a `_preAddAttrs()`, method\nhook (same signature as `addAttrs`). Components can implement this method on their prototype\nfor edge cases which do require finer control over the order in which attributes are added\n(see widget-htmlparser for example).\n\n2. Extension developers may need to move code from Extension constructors to `initializer`s\n\nOlder extensions, which were written before `initializer` support was added, had a lot of\ninitialization code in their constructors. For example, code which acccessed superclass\nattributes. With the new flow this code would not be able to see attributes. The recommendation\nis to move this initialization code to an `initializer` on the Extension, which was the\nrecommendation for anything created after `initializer` support for Extensions was added.",
    "!url": "http://yuilibrary.com/classes/BaseCore.html",
    "NAME": {
     "!type": "string",
     "!doc": "The string to be used to identify instances of this class.\n\nClasses extending BaseCore, should define their own\nstatic NAME property, which should be camelCase by\nconvention (e.g. MyClass.NAME = \"myClass\";).",
     "!url": "http://yuilibrary.com/classes/BaseCore.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "The default set of attributes which will be available for instances of this class, and\ntheir configuration. In addition to the configuration properties listed by\nAttributeCore's <a href=\"AttributeCore.html#method_addAttr\">addAttr</a> method,\nthe attribute can also be configured with a \"cloneDefaultValue\" property, which\ndefines how the statically defined value field should be protected\n(\"shallow\", \"deep\" and false are supported values).\n\nBy default if the value is an object literal or an array it will be \"shallow\"\ncloned, to protect the default value.",
     "!url": "http://yuilibrary.com/classes/BaseCore.html#property_ATTRS"
    },
    "prototype": {
     "initialized": {
      "!type": "fn()",
      "!doc": "Flag indicating whether or not this object\nhas been through the init lifecycle phase.",
      "!url": "http://yuilibrary.com/classes/BaseCore.html#attribute_initialized"
     },
     "destroyed": {
      "!type": "fn()",
      "!doc": "Flag indicating whether or not this object\nhas been through the destroy lifecycle phase.",
      "!url": "http://yuilibrary.com/classes/BaseCore.html#attribute_destroyed"
     },
     "name": {
      "!type": "string",
      "!doc": "The string used to identify the class of this object.",
      "!url": "http://yuilibrary.com/classes/BaseCore.html#property_name"
     },
     "init": {
      "!type": "fn(cfg: yui.Object) -> !this",
      "!doc": "Init lifecycle method, invoked during construction. Sets up attributes\nand invokes initializers for the class hierarchy.",
      "!url": "http://yuilibrary.com/classes/BaseCore.html#method_init"
     },
     "destroy": {
      "!type": "fn() -> !this",
      "!doc": "Destroy lifecycle method. Invokes destructors for the class hierarchy.",
      "!url": "http://yuilibrary.com/classes/BaseCore.html#method_destroy"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "Default toString implementation. Provides the constructor NAME\nand the instance guid, if set.",
      "!url": "http://yuilibrary.com/classes/BaseCore.html#method_toString"
     }
    },
    "modifyAttrs": {
     "!type": "fn(ctor?: fn(), configs: yui.Object)",
     "!doc": "Provides a way to safely modify a `Y.BaseCore` subclass' static `ATTRS`\nafter the class has been defined or created.\n\nBaseCore-based classes cache information about the class hierarchy in order\nto efficiently create instances. This cache includes includes the aggregated\n`ATTRS` configs. If the static `ATTRS` configs need to be modified after the\nclass has been defined or create, then use this method which will make sure\nto clear any cached data before making any modifications.",
     "!url": "http://yuilibrary.com/classes/BaseCore.html#method_modifyAttrs"
    }
   },
   "BaseObservable": {
    "!type": "fn()",
    "!doc": "Provides an augmentable implementation of lifecycle and attribute events for\n`BaseCore`.",
    "!url": "http://yuilibrary.com/classes/BaseObservable.html",
    "prototype": {
     "init": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "<p>\nLifecycle event for the init phase, fired prior to initialization.\nInvoking the preventDefault() method on the event object provided\nto subscribers will prevent initialization from occuring.\n</p>\n<p>\nSubscribers to the \"after\" momemt of this event, will be notified\nafter initialization of the object is complete (and therefore\ncannot prevent initialization).\n</p>",
      "!url": "http://yuilibrary.com/classes/BaseObservable.html#event_init"
     },
     "destroy": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "<p>\nLifecycle event for the destroy phase,\nfired prior to destruction. Invoking the preventDefault\nmethod on the event object provided to subscribers will\nprevent destruction from proceeding.\n</p>\n<p>\nSubscribers to the \"after\" moment of this event, will be notified\nafter destruction is complete (and as a result cannot prevent\ndestruction).\n</p>",
      "!url": "http://yuilibrary.com/classes/BaseObservable.html#event_destroy"
     }
    }
   }
  },
  "button": {
   "Button": {
    "!type": "fn(config: yui.Object) -> +button.Button",
    "!proto": "widget.Widget",
    "!doc": "Creates a Button",
    "!url": "http://yuilibrary.com/classes/Button.html",
    "prototype": {
     "BOUNDING_TEMPLATE": {
      "!type": "string",
      "!doc": "Bounding box template that will contain the Button's DOM subtree.",
      "!url": "http://yuilibrary.com/classes/Button.html#property_BOUNDING_TEMPLATE"
     },
     "CONTENT_TEMPLATE": {
      "!type": "string",
      "!doc": "Content box template",
      "!url": "http://yuilibrary.com/classes/Button.html#property_CONTENT_TEMPLATE"
     },
     "label": {
      "!type": "fn()",
      "!doc": "The text of the button's label",
      "!url": "http://yuilibrary.com/classes/Button.html#attribute_label"
     },
     "labelHTML": {
      "!type": "fn()",
      "!doc": "The HTML of the button's label\n\nThis attribute accepts HTML and inserts it into the DOM **without**\nsanitization.  This attribute should only be used with HTML that has\neither been escaped (using `Y.Escape.html`), or sanitized according to\nthe requirements of your application.\n\nIf all you need is support for text labels, please use the `label`\nattribute instead.",
      "!url": "http://yuilibrary.com/classes/Button.html#attribute_labelHTML"
     }
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "List of class names used in the Button's DOM",
     "!url": "http://yuilibrary.com/classes/Button.html#property_CLASS_NAMES"
    }
   },
   "ToggleButton": {
    "!type": "fn(config: yui.Object) -> +button.ToggleButton",
    "!proto": "button.Button",
    "!doc": "Creates a ToggleButton",
    "!url": "http://yuilibrary.com/classes/ToggleButton.html",
    "prototype": {
     "trigger": {
      "!type": "string",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#property_trigger"
     },
     "selectedAttrName": {
      "!type": "string",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#property_selectedAttrName"
     },
     "initializer": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#method_initializer"
     },
     "destructor": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#method_destructor"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "Hooks up events for the widget",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#method_bindUI"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Syncs the UI for the widget",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#method_syncUI"
     },
     "toggle": {
      "!type": "fn()",
      "!doc": "Toggles the selected/pressed/checked state of a ToggleButton",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#method_toggle"
     },
     "type": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/ToggleButton.html#attribute_type"
     }
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "Array of static constants used to identify the classnames applied to DOM nodes",
     "!url": "http://yuilibrary.com/classes/ToggleButton.html#property_CLASS_NAMES"
    }
   }
  },
  "button_core": {
   "ButtonCore": {
    "!type": "fn(config: yui.Object) -> +button_core.ButtonCore",
    "!doc": "Creates a button",
    "!url": "http://yuilibrary.com/classes/ButtonCore.html",
    "prototype": {
     "TEMPLATE": {
      "!type": "string",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#property_TEMPLATE"
     },
     "enable": {
      "!type": "fn()",
      "!doc": "Sets the button's `disabled` DOM attribute to `false`",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#method_enable"
     },
     "disable": {
      "!type": "fn()",
      "!doc": "Sets the button's `disabled` DOM attribute to `true`",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#method_disable"
     },
     "getNode": {
      "!type": "fn() -> +node.Node",
      "!doc": "Gets the button's host node",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#method_getNode"
     },
     "label": {
      "!type": "fn()",
      "!doc": "The text of the button's label",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#config_label"
     },
     "labelHTML": {
      "!type": "fn()",
      "!doc": "The HTML of the button's label\n\nThis attribute accepts HTML and inserts it into the DOM **without**\nsanitization.  This attribute should only be used with HTML that has\neither been escaped (using `Y.Escape.html`), or sanitized according to\nthe requirements of your application.\n\nIf all you need is support for text labels, please use the `label`\nattribute instead.",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#config_labelHTML"
     },
     "disabled": {
      "!type": "fn()",
      "!doc": "The button's enabled/disabled state",
      "!url": "http://yuilibrary.com/classes/ButtonCore.html#config_disabled"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Name of this component.",
     "!url": "http://yuilibrary.com/classes/ButtonCore.html#property_NAME"
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "Array of static constants used to identify the classnames applied to DOM nodes",
     "!url": "http://yuilibrary.com/classes/ButtonCore.html#property_CLASS_NAMES"
    }
   }
  },
  "button_group": {
   "ButtonGroup": {
    "!type": "fn(config: yui.Object) -> +button_group.ButtonGroup",
    "!proto": "widget.Widget",
    "!doc": "Creates a ButtonGroup",
    "!url": "http://yuilibrary.com/classes/ButtonGroup.html",
    "prototype": {
     "renderUI": {
      "!type": "fn()",
      "!doc": "Creates a visual representation of the widget based on existing parameters.",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#method_renderUI"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "Hooks up events for the widget",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#method_bindUI"
     },
     "getButtons": {
      "!type": "fn()",
      "!doc": "Returns all buttons inside this this button group",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#method_getButtons"
     },
     "getSelectedButtons": {
      "!type": "fn()",
      "!doc": "Returns all Y.Buttons instances that are selected",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#method_getSelectedButtons"
     },
     "getSelectedValues": {
      "!type": "fn()",
      "!doc": "Returns the values of all Y.Button instances that are selected",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#method_getSelectedValues"
     },
     "selectionChange": {
      "!type": "fn(the: event.Event)",
      "!doc": "fires when any button in the group changes its checked status",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#event_selectionChange"
     },
     "type": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#attribute_type"
     },
     "BUTTON_SELECTOR": {
      "!type": "string",
      "!doc": "Selector used to find buttons inside a ButtonGroup",
      "!url": "http://yuilibrary.com/classes/ButtonGroup.html#property_BUTTON_SELECTOR"
     }
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "List of class names to use for ButtonGroups",
     "!url": "http://yuilibrary.com/classes/ButtonGroup.html#property_CLASS_NAMES"
    }
   }
  },
  "button_plugin": {
   "Plugin.Button": {
    "!type": "fn(config: yui.Object) -> +button_plugin.Plugin.Button",
    "!proto": "button_core.ButtonCore",
    "!url": "http://yuilibrary.com/classes/Plugin.Button.html",
    "NAME": {
     "!type": "string",
     "!doc": "Name of this component.",
     "!url": "http://yuilibrary.com/classes/Plugin.Button.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "Namespace of this component.",
     "!url": "http://yuilibrary.com/classes/Plugin.Button.html#property_NS"
    },
    "prototype": {
     "createNode": {
      "!type": "fn(node: yui.Object, config: yui.Object) -> +yui.Object",
      "!doc": "A factory that plugs a Y.Node instance with Y.Plugin.Button",
      "!url": "http://yuilibrary.com/classes/Plugin.Button.html#method_createNode"
     }
    }
   }
  },
  "cache": {
   "Cache": {
    "!type": "fn() -> +cache.Cache",
    "!proto": "base.Base",
    "!doc": "Base class for the YUI Cache utility.",
    "!url": "http://yuilibrary.com/classes/Cache.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/Cache.html#property_NAME"
    },
    "prototype": {
     "max": {
      "!type": "fn()",
      "!doc": "Maximum number of entries the Cache can hold.\nSet to 0 to turn off caching.",
      "!url": "http://yuilibrary.com/classes/Cache.html#attribute_max"
     },
     "size": {
      "!type": "fn()",
      "!doc": "Number of entries currently cached.",
      "!url": "http://yuilibrary.com/classes/Cache.html#attribute_size"
     },
     "uniqueKeys": {
      "!type": "fn()",
      "!doc": "Validate uniqueness of stored keys. Default is false and\nis more performant.",
      "!url": "http://yuilibrary.com/classes/Cache.html#attribute_uniqueKeys"
     },
     "expires": {
      "!type": "fn()",
      "!doc": "Absolute Date when data expires or\nrelative number of milliseconds. Zero disables expiration.",
      "!url": "http://yuilibrary.com/classes/Cache.html#attribute_expires"
     },
     "entries": {
      "!type": "fn()",
      "!doc": "Cached entries.",
      "!url": "http://yuilibrary.com/classes/Cache.html#attribute_entries"
     },
     "add": {
      "!type": "fn(request: yui.Object, response: yui.Object)",
      "!doc": "Adds a new entry to the cache of the format\n{request:request, response:response, cached:cached, expires:expires}.\nIf cache is full, evicts the stalest entry before adding the new one.",
      "!url": "http://yuilibrary.com/classes/Cache.html#method_add"
     },
     "flush": {
      "!type": "fn()",
      "!doc": "Flushes cache.",
      "!url": "http://yuilibrary.com/classes/Cache.html#method_flush"
     },
     "request": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when an entry is requested from the cache.",
      "!url": "http://yuilibrary.com/classes/Cache.html#event_request"
     },
     "retrieve": {
      "!type": "fn(request: yui.Object) -> +yui.Object",
      "!doc": "Retrieves cached object for given request, if available, and refreshes\nentry in the cache. Returns null if there is no cache match.",
      "!url": "http://yuilibrary.com/classes/Cache.html#method_retrieve"
     }
    }
   },
   "CacheOffline": {
    "!type": "fn() -> +cache.CacheOffline",
    "!proto": "cache.Cache",
    "!doc": "Extends Cache utility with offline functionality.",
    "!url": "http://yuilibrary.com/classes/CacheOffline.html",
    "prototype": {
     "error": {
      "!type": "fn()",
      "!doc": "Fired when an entry could not be added, most likely due to\nexceeded browser quota.\n<dl>\n<dt>error (Object)</dt> <dd>The error object.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#event_error"
     },
     "sandbox": {
      "!type": "fn()",
      "!doc": "A string that must be passed in via the constructor.\nThis identifier is used to sandbox one cache instance's entries\nfrom another. Calling the cache instance's flush and length methods\nor get(\"entries\") will apply to only these sandboxed entries.",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#attribute_sandbox"
     },
     "expires": {
      "!type": "fn()",
      "!doc": "Absolute Date when data expires or\nrelative number of milliseconds. Zero disables expiration.",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#attribute_expires"
     },
     "max": {
      "!type": "fn()",
      "!doc": "Disabled.",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#attribute_max"
     },
     "uniqueKeys": {
      "!type": "fn()",
      "!doc": "Always true for CacheOffline.",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#attribute_uniqueKeys"
     },
     "add": {
      "!type": "fn(request: yui.Object, response: yui.Object)",
      "!doc": "Adds a new entry to the cache of the format\n{request:request, response:response, cached:cached, expires: expires}.",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#method_add"
     },
     "retrieve": {
      "!type": "fn(request: yui.Object) -> +yui.Object",
      "!doc": "Retrieves cached object for given request, if available.\nReturns null if there is no cache match.",
      "!url": "http://yuilibrary.com/classes/CacheOffline.html#method_retrieve"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/CacheOffline.html#property_NAME"
    },
    "flushAll": {
     "!type": "fn()",
     "!doc": "Removes all items from all sandboxes. Useful if localStorage has\nexceeded quota. Only supported on browsers that implement HTML 5\nlocalStorage.",
     "!url": "http://yuilibrary.com/classes/CacheOffline.html#method_flushAll"
    }
   },
   "Plugin.Cache": {
    "!type": "fn()",
    "!proto": "cache.Cache",
    "!doc": "Plugin.Cache adds pluginizability to Cache.",
    "!url": "http://yuilibrary.com/classes/Plugin.Cache.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/Plugin.Cache.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/Plugin.Cache.html#property_NAME"
    }
   }
  },
  "calendar": {
   "CalendarBase": {
    "!type": "fn(config: yui.Object) -> +calendar.CalendarBase",
    "!proto": "widget.Widget",
    "!doc": "month range of dates, rendered as a grid with date and\nweekday labels.",
    "!url": "http://yuilibrary.com/classes/CalendarBase.html",
    "prototype": {
     "initializer": {
      "!type": "fn()",
      "!doc": "Designated initializer\nInitializes instance-level properties of\ncalendar.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#method_initializer"
     },
     "renderUI": {
      "!type": "fn()",
      "!doc": "renderUI implementation\n\nCreates a visual representation of the calendar based on existing parameters.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#method_renderUI"
     },
     "bindUI": {
      "!type": "fn()",
      "!doc": "bindUI implementation\n\nAssigns listeners to relevant events that change the state\nof the calendar.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#method_bindUI"
     },
     "selectDates": {
      "!type": "fn(dates: datatype_date.Date) -> !this",
      "!doc": "Selects a given date or array of dates.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#method_selectDates"
     },
     "deselectDates": {
      "!type": "fn(dates?: datatype_date.Date) -> !this",
      "!doc": "Deselects a given date or array of dates, or deselects\nall dates if no argument is specified.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#method_deselectDates"
     },
     "selectionChange": {
      "!type": "fn()",
      "!doc": "Fired when the set of selected dates changes. Contains a payload with\na `newSelection` property with an array of selected dates.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#event_selectionChange"
     },
     "date": {
      "!type": "fn()",
      "!doc": "The date corresponding to the current calendar view. Always\nnormalized to the first of the month that contains the date\nat assignment time. Used as the first date visible in the\ncalendar.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_date"
     },
     "showPrevMonth": {
      "!type": "fn()",
      "!doc": "A setting specifying whether to shows days from the previous\nmonth in the visible month's grid, if there are empty preceding\ncells available.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_showPrevMonth"
     },
     "showNextMonth": {
      "!type": "fn()",
      "!doc": "A setting specifying whether to shows days from the next\nmonth in the visible month's grid, if there are empty\ncells available at the end.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_showNextMonth"
     },
     "headerRenderer": {
      "!type": "fn()",
      "!doc": "Custom header renderer for the calendar.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_headerRenderer"
     },
     "enabledDatesRule": {
      "!type": "fn()",
      "!doc": "The name of the rule which all enabled dates should match.\nEither disabledDatesRule or enabledDatesRule should be specified,\nor neither, but not both.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_enabledDatesRule"
     },
     "disabledDatesRule": {
      "!type": "fn()",
      "!doc": "The name of the rule which all disabled dates should match.\nEither disabledDatesRule or enabledDatesRule should be specified,\nor neither, but not both.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_disabledDatesRule"
     },
     "selectedDates": {
      "!type": "fn()",
      "!doc": "A read-only attribute providing a list of currently selected dates.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_selectedDates"
     },
     "customRenderer": {
      "!type": "fn()",
      "!doc": "An object of the form {rules:Object, filterFunction:Function},\nproviding  set of rules and a custom rendering function for\ncustomizing specific calendar cells.",
      "!url": "http://yuilibrary.com/classes/CalendarBase.html#attribute_customRenderer"
     }
    }
   },
   "Calendar": {
    "!type": "fn(config: yui.Object) -> +calendar.Calendar",
    "!proto": "calendar.CalendarBase",
    "!doc": "month range of dates, rendered as a grid with date and\nweekday labels.",
    "!url": "http://yuilibrary.com/classes/Calendar.html",
    "prototype": {
     "initializer": {
      "!type": "fn()",
      "!doc": "Designated initializer. Activates the navigation plugin for the calendar.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#method_initializer"
     },
     "dateClick": {
      "!type": "fn()",
      "!doc": "Fired when a specific date cell in the calendar is clicked. The event carries a\npayload which includes a `cell` property corresponding to the node of the actual\ndate cell, and a `date` property, with the `Date` that was clicked.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#event_dateClick"
     },
     "prevMonthClick": {
      "!type": "fn()",
      "!doc": "Fired when any of the previous month's days displayed before the calendar grid\nare clicked.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#event_prevMonthClick"
     },
     "nextMonthClick": {
      "!type": "fn()",
      "!doc": "Fired when any of the next month's days displayed after the calendar grid\nare clicked.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#event_nextMonthClick"
     },
     "subtractMonth": {
      "!type": "fn() -> !this",
      "!doc": "Subtracts one month from the current calendar view.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#method_subtractMonth"
     },
     "subtractYear": {
      "!type": "fn() -> !this",
      "!doc": "Subtracts one year from the current calendar view.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#method_subtractYear"
     },
     "addMonth": {
      "!type": "fn() -> !this",
      "!doc": "Adds one month to the current calendar view.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#method_addMonth"
     },
     "addYear": {
      "!type": "fn() -> !this",
      "!doc": "Adds one year to the current calendar view.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#method_addYear"
     },
     "selectionMode": {
      "!type": "fn()",
      "!doc": "A setting specifying the type of selection the calendar allows.\nPossible values include:\n<ul>\n  <li>`single` - One date at a time</li>\n  <li>`multiple-sticky` - Multiple dates, selected one at a time (the dates \"stick\"). This option\n  is appropriate for mobile devices, where function keys from the keyboard are not available.</li>\n  <li>`multiple` - Multiple dates, selected with Ctrl/Meta keys for additional single\n  dates, and Shift key for date ranges.</li>",
      "!url": "http://yuilibrary.com/classes/Calendar.html#attribute_selectionMode"
     },
     "date": {
      "!type": "fn()",
      "!doc": "The date corresponding to the current calendar view. Always\nnormalized to the first of the month that contains the date\nat assignment time. Used as the first date visible in the\ncalendar.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#attribute_date"
     },
     "minimumDate": {
      "!type": "fn()",
      "!doc": "Unless minimumDate is null, it will not be possible to display and select dates earlier than this one.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#attribute_minimumDate"
     },
     "maximumDate": {
      "!type": "fn()",
      "!doc": "Unless maximumDate is null, it will not be possible to display and select dates later than this one.",
      "!url": "http://yuilibrary.com/classes/Calendar.html#attribute_maximumDate"
     }
    }
   }
  },
  "calendarnavigator": {
   "Plugin.CalendarNavigator": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "A plugin class which adds navigation controls to Calendar.",
    "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the widget, which will\nreference the plugin instance, when it's plugged in.",
     "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "The NAME of the CalendarNavigator class. Used to prefix events generated\nby the plugin class.",
     "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the plugin.",
     "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html#property_ATTRS"
    },
    "prototype": {
     "shiftByMonths": {
      "!type": "fn()",
      "!doc": "The number of months to shift by when the control arrows are clicked.",
      "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html#attribute_shiftByMonths"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "The initializer lifecycle implementation. Modifies the host widget's\nrender to add navigation controls.",
      "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html#method_initializer"
     },
     "destructor": {
      "!type": "fn()",
      "!doc": "The initializer destructor implementation. Responsible for destroying the initialized\ncontrol mechanisms.",
      "!url": "http://yuilibrary.com/classes/Plugin.CalendarNavigator.html#method_destructor"
     }
    }
   }
  },
  "charts": {
   "AreaSeries": {
    "!type": "fn(config: yui.Object) -> +charts.AreaSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The AreaSeries class renders quantitative data on a graph by creating a fill between 0\nand the relevant data points.",
    "!url": "http://yuilibrary.com/classes/AreaSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/AreaSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:\n\n <dl>\n     <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be\n     retrieved from the following array:\n     `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n     </dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/AreaSeries.html#attribute_styles"
     }
    }
   },
   "AreaSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.AreaSplineSeries",
    "!proto": "charts.AreaSeries",
    "!doc": "AreaSplineSeries renders an area graph with data points connected by a curve.",
    "!url": "http://yuilibrary.com/classes/AreaSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/AreaSplineSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:\n\n <dl>\n     <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be\n     retrieved from the following array:\n     `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n     </dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/AreaSplineSeries.html#attribute_styles"
     }
    }
   },
   "Axis": {
    "!type": "fn(config: yui.Object) -> +charts.Axis",
    "!proto": "widget.Widget",
    "!doc": "An abstract class that provides the core functionality for draw a chart axis. Axis is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"StackedAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/Axis.html",
    "prototype": {
     "getLabelByIndex": {
      "!type": "fn(i: number, l: number) -> ?",
      "!doc": "Calculates and returns a value based on the number of labels and the index of\nthe current label.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getLabelByIndex"
     },
     "getMaxLabelBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the coordinates (top, right, bottom, left) for the bounding box of the last label.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getMaxLabelBounds"
     },
     "getMinLabelBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the coordinates (top, right, bottom, left) for the bounding box of the first label.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getMinLabelBounds"
     },
     "getTotalMajorUnits": {
      "!type": "fn() -> ?",
      "!doc": "Returns the total number of majorUnits that will appear on an axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getTotalMajorUnits"
     },
     "getMajorUnitDistance": {
      "!type": "fn(len: number, uiLen: number, majorUnit: yui.Object) -> ?",
      "!doc": "Returns the distance between major units on an axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getMajorUnitDistance"
     },
     "getMinimumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the first label on an\naxis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getMinimumValue"
     },
     "getMaximumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the last label on an\naxis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#method_getMaximumValue"
     },
     "width": {
      "!type": "fn()",
      "!doc": "When set, defines the width of a vertical axis instance. By default, vertical axes automatically size based\non their contents. When the width attribute is set, the axis will not calculate its width. When the width\nattribute is explicitly set, axis labels will postion themselves off of the the inner edge of the axis and the\ntitle, if present, will position itself off of the outer edge. If a specified width is less than the sum of\nthe axis' contents, excess content will overflow.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "When set, defines the height of a horizontal axis instance. By default, horizontal axes automatically size based\non their contents. When the height attribute is set, the axis will not calculate its height. When the height\nattribute is explicitly set, axis labels will postion themselves off of the the inner edge of the axis and the\ntitle, if present, will position itself off of the outer edge. If a specified height is less than the sum of\nthe axis' contents, excess content will overflow.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_height"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which the axis line and ticks will be rendered.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_graphic"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Contains the contents of the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_node"
     },
     "position": {
      "!type": "fn()",
      "!doc": "Direction of the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_position"
     },
     "topTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the top of the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_topTickOffset"
     },
     "bottomTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the bottom of the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_bottomTickOffset"
     },
     "leftTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the left of the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_leftTickOffset"
     },
     "rightTickOffset": {
      "!type": "fn()",
      "!doc": "Distance determined by the tick styles used to calculate the distance between the axis\nline in relation to the right side of the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_rightTickOffset"
     },
     "labels": {
      "!type": "fn()",
      "!doc": "Collection of labels used to render the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_labels"
     },
     "tickPoints": {
      "!type": "fn()",
      "!doc": "Collection of points used for placement of labels and ticks along the axis.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_tickPoints"
     },
     "overlapGraph": {
      "!type": "fn()",
      "!doc": "Indicates whether the axis overlaps the graph. If an axis is the inner most axis on a given\nposition and the tick position is inside or cross, the axis will need to overlap the graph.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_overlapGraph"
     },
     "title": {
      "!type": "fn()",
      "!doc": "Title for the axis. When specified, the title will display. The position of the title is determined by the axis position.\n<dl>\n    <dt>top</dt><dd>Appears above the axis and it labels. The default rotation is 0.</dd>\n    <dt>right</dt><dd>Appears to the right of the axis and its labels. The default rotation is 90.</dd>\n    <dt>bottom</dt><dd>Appears below the axis and its labels. The default rotation is 0.</dd>\n    <dt>left</dt><dd>Appears to the left of the axis and its labels. The default rotation is -90.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_title"
     },
     "appendLabelFunction": {
      "!type": "fn()",
      "!doc": "Function used to append an axis value to an axis label. This function has the following signature:\n <dl>\n     <dt>textField</dt><dd>The axis label to be appended. (`HTMLElement`)</dd>\n     <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`\n     or a `String`. This method does not use (`HTMLElement` | `String`)</dd>\n </dl>\nThe default method appends a value to the `HTMLElement` using the `appendChild` method. If the given\nvalue is a `String`, the method will convert the the value to a `textNode` before appending to the\n`HTMLElement`. This method will not convert an `HTMLString` to an `HTMLElement`.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_appendLabelFunction"
     },
     "appendTitleFunction": {
      "!type": "fn()",
      "!doc": "Function used to append a title value to the title object. This function has the following signature:\n <dl>\n     <dt>textField</dt><dd>The title text field to be appended. (`HTMLElement`)</dd>\n     <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`\n     or a `String`. This method does not use (`HTMLElement` | `String`)</dd>\n </dl>\nThe default method appends a value to the `HTMLElement` using the `appendChild` method. If the given\nvalue is a `String`, the method will convert the the value to a `textNode` before appending to the\n`HTMLElement` element. This method will not convert an `HTMLString` to an `HTMLElement`.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_appendTitleFunction"
     },
     "labelValues": {
      "!type": "fn()",
      "!doc": "An array containing the unformatted values of the axis labels. By default, TimeAxis, NumericAxis and\nStackedAxis labelValues are determined by the majorUnit style. By default, CategoryAxis labels are\ndetermined by the values of the dataProvider.\n<p>When the labelValues attribute is explicitly set, the labelValues are dictated by the set value and\nthe position of ticks and labels are determined by where those values would fall on the axis. </p>",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_labelValues"
     },
     "hideFirstMajorUnit": {
      "!type": "fn()",
      "!doc": "Suppresses the creation of the the first visible label and tick.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_hideFirstMajorUnit"
     },
     "hideLastMajorUnit": {
      "!type": "fn()",
      "!doc": "Suppresses the creation of the the last visible label and tick.",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_hideLastMajorUnit"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing an axis. This attribute is inherited from `Renderer`. Below are the default values:\n <dl>\n     <dt>majorTicks</dt><dd>Properties used for drawing ticks.\n         <dl>\n             <dt>display</dt><dd>Position of the tick. Possible values are `inside`, `outside`, `cross` and `none`.\n             The default value is `inside`.</dd>\n             <dt>length</dt><dd>The length (in pixels) of the tick. The default value is 4.</dd>\n             <dt>color</dt><dd>The color of the tick. The default value is `#dad8c9`</dd>\n             <dt>weight</dt><dd>Number indicating the width of the tick. The default value is 1.</dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>line</dt><dd>Properties used for drawing the axis line.\n         <dl>\n             <dt>weight</dt><dd>Number indicating the width of the axis line. The default value is 1.</dd>\n             <dt>color</dt><dd>The color of the axis line. The default value is `#dad8c9`.</dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>majorUnit</dt><dd>Properties used to calculate the `majorUnit` for the axis.\n         <dl>\n             <dt>determinant</dt><dd>The algorithm used for calculating distance between ticks. The possible options are\n             `count` and `distance`. If the `determinant` is `count`, the axis ticks will spaced so that a specified number\n             of ticks appear on the axis. If the `determinant` is `distance`, the axis ticks will spaced out according to\n             the specified distance. The default value is `count`.</dd>\n             <dt>count</dt><dd>Number of ticks to appear on the axis when the `determinant` is `count`. The default value is 11.</dd>\n             <dt>distance</dt><dd>The distance (in pixels) between ticks when the `determinant` is `distance`. The default\n             value is 75.</dd>\n         </dl>\n     </dd>\n     <dt>label</dt><dd>Properties and styles applied to the axis labels.\n         <dl>\n             <dt>color</dt><dd>The color of the labels. The default value is `#808080`.</dd>\n             <dt>alpha</dt><dd>Number between 0 and 1 indicating the opacity of the labels. The default value is 1.</dd>\n             <dt>fontSize</dt><dd>The font-size of the labels. The default value is 85%</dd>\n             <dt>rotation</dt><dd>The rotation, in degrees (between -90 and 90) of the labels. The default value is 0.</dd>\n             <dt>offset</td><dd>A number between 0 and 1 indicating the relationship of the label to a tick. For a horizontal axis\n             label, a value of 0 will position the label's left side even to the the tick. A position of 1 would position the\n             right side of the label with the tick. A position of 0.5 would center the label horizontally with the tick. For a\n             vertical axis, a value of 0 would position the top of the label with the tick, a value of 1 would position the bottom\n             of the label with the tick and a value 0 would center the label vertically with the tick. The default value is 0.5.</dd>\n             <dt>margin</dt><dd>The distance between the label and the axis/tick. Depending on the position of the `Axis`,\n             only one of the properties used.\n                 <dl>\n                     <dt>top</dt><dd>Pixel value used for an axis with a `position` of `bottom`. The default value is 4.</dd>\n                     <dt>right</dt><dd>Pixel value used for an axis with a `position` of `left`. The default value is 4.</dd>\n                     <dt>bottom</dt><dd>Pixel value used for an axis with a `position` of `top`. The default value is 4.</dd>\n                     <dt>left</dt><dd>Pixel value used for an axis with a `position` of `right`. The default value is 4.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/Axis.html#attribute_styles"
     }
    }
   },
   "AxisBase": {
    "!type": "fn(config: yui.Object) -> +charts.AxisBase",
    "!proto": "base.Base",
    "!doc": "An abstract class that provides the core functionality used by the following classes:\n<ul>\n     <li>{{#crossLink \"CategoryAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"StackedAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"StackedAxis\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/AxisBase.html",
    "prototype": {
     "getOrigin": {
      "!type": "fn() -> ?",
      "!doc": "Returns the value corresponding to the origin on the axis.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_getOrigin"
     },
     "addKey": {
      "!type": "fn(value)",
      "!doc": "Adds an array to the key hash.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_addKey"
     },
     "removeKey": {
      "!type": "fn(value: string)",
      "!doc": "Removes an array from the key hash.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_removeKey"
     },
     "getKeyValueAt": {
      "!type": "fn(key: string, index: number) -> ?",
      "!doc": "Returns a value based of a key value and an index.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_getKeyValueAt"
     },
     "getDataByKey": {
      "!type": "fn(value: string) -> ?",
      "!doc": "Returns values based on key identifiers. When a string is passed as an argument, an array of values is returned.\nWhen an array of keys is passed as an argument, an object literal with an array of values mapped to each key is\nreturned.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_getDataByKey"
     },
     "getTotalMajorUnits": {
      "!type": "fn() -> ?",
      "!doc": "Returns the total number of majorUnits that will appear on an axis.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_getTotalMajorUnits"
     },
     "getEdgeOffset": {
      "!type": "fn(ct: number, l: number) -> ?",
      "!doc": "Gets the distance that the first and last ticks are offset from there respective\nedges.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#method_getEdgeOffset"
     },
     "calculateEdgeOffset": {
      "!type": "fn()",
      "!doc": "Determines whether and offset is automatically calculated for the edges of the axis.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_calculateEdgeOffset"
     },
     "keys": {
      "!type": "fn()",
      "!doc": "Hash of array identifed by a string value.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_keys"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Returns the type of axis data\n  <dl>\n      <dt>time</dt><dd>Manages time data</dd>\n      <dt>stacked</dt><dd>Manages stacked numeric data</dd>\n      <dt>numeric</dt><dd>Manages numeric data</dd>\n      <dt>category</dt><dd>Manages categorical data</dd>\n  </dl>",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_type"
     },
     "dataProvider": {
      "!type": "fn()",
      "!doc": "Instance of `ChartDataProvider` that the class uses\nto build its own data.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_dataProvider"
     },
     "dataMaximum": {
      "!type": "fn()",
      "!doc": "The maximum value contained in the `data` array. Used for\n`maximum` when `autoMax` is true.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_dataMaximum"
     },
     "maximum": {
      "!type": "fn()",
      "!doc": "The maximum value that will appear on an axis.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_maximum"
     },
     "dataMinimum": {
      "!type": "fn()",
      "!doc": "The minimum value contained in the `data` array. Used for\n`minimum` when `autoMin` is true.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_dataMinimum"
     },
     "minimum": {
      "!type": "fn()",
      "!doc": "The minimum value that will appear on an axis.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_minimum"
     },
     "setMax": {
      "!type": "fn()",
      "!doc": "Determines whether the maximum is calculated or explicitly\nset by the user.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_setMax"
     },
     "setMin": {
      "!type": "fn()",
      "!doc": "Determines whether the minimum is calculated or explicitly\nset by the user.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_setMin"
     },
     "data": {
      "!type": "fn()",
      "!doc": "Array of axis data",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_data"
     },
     "keyCollection": {
      "!type": "fn()",
      "!doc": "Array containing all the keys in the axis.",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_keyCollection"
     },
     "labelFunctionScope": {
      "!type": "fn()",
      "!doc": "Object which should have by the labelFunction",
      "!url": "http://yuilibrary.com/classes/AxisBase.html#attribute_labelFunctionScope"
     }
    }
   },
   "BarSeries": {
    "!type": "fn(config: yui.Object) -> +charts.BarSeries",
    "!proto": "charts.MarkerSeries",
    "!doc": "The BarSeries class renders bars positioned vertically along a category or time axis. The bars'\nlengths are proportional to the values they represent along a horizontal axis.\nand the relevant data points.",
    "!url": "http://yuilibrary.com/classes/BarSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/BarSeries.html#attribute_type"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Indicates the direction of the category axis that the bars are plotted against.",
      "!url": "http://yuilibrary.com/classes/BarSeries.html#attribute_direction"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>height</dt><dd>indicates the width of the marker. The default value is 12.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/BarSeries.html#attribute_styles"
     }
    }
   },
   "CandlestickSeries": {
    "!type": "fn(config: yui.Object) -> +charts.CandlestickSeries",
    "!proto": "charts.RangeSeries",
    "!doc": "The CandlestickSeries class renders columns (candles) and lines (wicks) representing the open, high, low and close\nvalues for a chart.",
    "!url": "http://yuilibrary.com/classes/CandlestickSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/CandlestickSeries.html#attribute_type"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://yuilibrary.com/classes/CandlestickSeries.html#attribute_graphic"
     },
     "upcandle": {
      "!type": "fn()",
      "!doc": "Reference to the candlestick used when the close value is higher than the open value.",
      "!url": "http://yuilibrary.com/classes/CandlestickSeries.html#attribute_upcandle"
     },
     "downcandle": {
      "!type": "fn()",
      "!doc": "Reference to the candlestick used when the open value is higher than the close value.",
      "!url": "http://yuilibrary.com/classes/CandlestickSeries.html#attribute_downcandle"
     },
     "wick": {
      "!type": "fn()",
      "!doc": "Reference to the line drawn between the high and low values.",
      "!url": "http://yuilibrary.com/classes/CandlestickSeries.html#attribute_wick"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing candles and wicks. This attribute is inherited from `RangeSeries`. Below are the default values:\n <dl>\n     <dt>upcandle</dt><dd>Properties for a candle representing a period that closes higher than it opens.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#00aa00\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>downcandle</dt><dd>Properties for a candle representing a period that opens higher than it closes.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#aa0000\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>wick</dt><dd>Properties for the wick, which is a line drawn from the high point of the period to the low point of the period.\n         <dl>\n             <dt>color</dt><dd>The color of the wick. The default value is \"#000000\".</dd>\n             <dt>weight</dt><dd>The weight of the wick. The default value is 1.</dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the wick. The default value is 1.</dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/CandlestickSeries.html#attribute_styles"
     }
    }
   },
   "CartesianChart": {
    "!type": "fn() -> +charts.CartesianChart",
    "!proto": "charts.ChartBase",
    "!doc": "The CartesianChart class creates a chart with horizontal and vertical axes.",
    "!url": "http://yuilibrary.com/classes/CartesianChart.html",
    "prototype": {
     "planarEvent:mouseover": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `planar` and a series' marker plane has received a mouseover event.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#event_planarEvent:mouseover"
     },
     "planarEvent:mouseout": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `planar` and a series' marker plane has received a mouseout event.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#event_planarEvent:mouseout"
     },
     "_addToAxesCollection": {
      "!type": "fn(position: string, axis: charts.Axis)",
      "!doc": "Adds axis instance to the appropriate array based on position",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#method__addToAxesCollection"
     },
     "getSeriesItems": {
      "!type": "fn(series: charts.CartesianSeries, index: number) -> ?",
      "!doc": "Returns an object literal containing a categoryItem and a valueItem for a given series index. Below is the structure of each:",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#method_getSeriesItems"
     },
     "_getAriaMessage": {
      "!type": "fn(key: number) -> ?",
      "!doc": "Returns the appropriate message based on the key press.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#method__getAriaMessage"
     },
     "allowContentOverflow": {
      "!type": "fn()",
      "!doc": "Indicates whether axis labels are allowed to overflow beyond the bounds of the chart's content box.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_allowContentOverflow"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties for the chart. Contains a key indexed hash of the following:\n <dl>\n     <dt>series</dt><dd>A key indexed hash containing references to the `styles` attribute for each series in the chart.\n     Specific style attributes vary depending on the series:\n     <ul>\n         <li><a href=\"AreaSeries.html#attr_styles\">AreaSeries</a></li>\n         <li><a href=\"BarSeries.html#attr_styles\">BarSeries</a></li>\n         <li><a href=\"ColumnSeries.html#attr_styles\">ColumnSeries</a></li>\n         <li><a href=\"ComboSeries.html#attr_styles\">ComboSeries</a></li>\n         <li><a href=\"LineSeries.html#attr_styles\">LineSeries</a></li>\n         <li><a href=\"MarkerSeries.html#attr_styles\">MarkerSeries</a></li>\n         <li><a href=\"SplineSeries.html#attr_styles\">SplineSeries</a></li>\n     </ul>\n     </dd>\n     <dt>axes</dt><dd>A key indexed hash containing references to the `styles` attribute for each axes in the chart. Specific\n     style attributes can be found in the <a href=\"Axis.html#attr_styles\">Axis</a> class.</dd>\n     <dt>graph</dt><dd>A reference to the `styles` attribute in the chart. Specific style attributes can be found in the\n     <a href=\"Graph.html#attr_styles\">Graph</a> class.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_styles"
     },
     "axes": {
      "!type": "fn()",
      "!doc": "Axes to appear in the chart. This can be a key indexed hash of axis instances or object literals\nused to construct the appropriate axes.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_axes"
     },
     "seriesCollection": {
      "!type": "fn()",
      "!doc": "Collection of series to appear on the chart. This can be an array of Series instances or object literals\nused to construct the appropriate series.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_seriesCollection"
     },
     "stacked": {
      "!type": "fn()",
      "!doc": "Indicates whether or not the chart is stacked.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_stacked"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Direction of chart's category axis when there is no series collection specified. Charts can\nbe horizontal or vertical. When the chart type is column, the chart is horizontal.\nWhen the chart type is bar, the chart is vertical.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_direction"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether or not an area is filled in a combo chart.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_showAreaFill"
     },
     "showMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether to display markers in a combo chart.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_showMarkers"
     },
     "showLines": {
      "!type": "fn()",
      "!doc": "Indicates whether to display lines in a combo chart.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_showLines"
     },
     "categoryAxisName": {
      "!type": "fn()",
      "!doc": "Indicates the key value used to identify a category axis in the `axes` hash. If\nnot specified, the categoryKey attribute value will be used.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_categoryAxisName"
     },
     "valueAxisName": {
      "!type": "fn()",
      "!doc": "Indicates the key value used to identify a the series axis when an axis not generated.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_valueAxisName"
     },
     "horizontalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the horizontalGridlines for the chart.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_horizontalGridlines"
     },
     "verticalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the verticalGridlines for the chart.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_verticalGridlines"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Type of chart when there is no series collection specified.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_type"
     },
     "categoryAxis": {
      "!type": "fn()",
      "!doc": "Reference to the category axis used by the chart.",
      "!url": "http://yuilibrary.com/classes/CartesianChart.html#attribute_categoryAxis"
     }
    }
   },
   "CartesianSeries": {
    "!type": "fn(config: yui.Object) -> +charts.CartesianSeries",
    "!proto": "charts.SeriesBase",
    "!doc": "An abstract class for creating series instances with horizontal and vertical axes.\nCartesianSeries provides the core functionality used by the following classes:\n<ul>\n     <li>{{#crossLink \"LineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"MarkerSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"AreaSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"SplineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"AreaSplineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"ComboSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"ComboSplineSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"Histogram\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/CartesianSeries.html",
    "prototype": {
     "seriesTypeCollection": {
      "!type": "fn()",
      "!doc": "An array of all series of the same type used within a chart application.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_seriesTypeCollection"
     },
     "xDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying data related to the x-coordinate.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xDisplayName"
     },
     "yDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying data related to the y-coordinate.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_yDisplayName"
     },
     "categoryDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying category data",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_categoryDisplayName"
     },
     "valueDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying value data",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_valueDisplayName"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_type"
     },
     "order": {
      "!type": "fn()",
      "!doc": "Order of this instance of this `type`.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_order"
     },
     "graphOrder": {
      "!type": "fn()",
      "!doc": "Order of the instance",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_graphOrder"
     },
     "xcoords": {
      "!type": "fn()",
      "!doc": "x coordinates for the series.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xcoords"
     },
     "ycoords": {
      "!type": "fn()",
      "!doc": "y coordinates for the series",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_ycoords"
     },
     "xAxis": {
      "!type": "fn()",
      "!doc": "Reference to the `Axis` instance used for assigning\nx-values to the graph.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xAxis"
     },
     "yAxis": {
      "!type": "fn()",
      "!doc": "Reference to the `Axis` instance used for assigning\ny-values to the graph.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_yAxis"
     },
     "xKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe x-axis `Axis` instance.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xKey"
     },
     "yKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe y-axis `Axis` instance.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_yKey"
     },
     "xData": {
      "!type": "fn()",
      "!doc": "Array of x values for the series.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xData"
     },
     "yData": {
      "!type": "fn()",
      "!doc": "Array of y values for the series.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_yData"
     },
     "xMarkerPlane": {
      "!type": "fn()",
      "!doc": "Collection of area maps along the xAxis. Used to determine mouseover for multiple\nseries.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xMarkerPlane"
     },
     "yMarkerPlane": {
      "!type": "fn()",
      "!doc": "Collection of area maps along the yAxis. Used to determine mouseover for multiple\nseries.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_yMarkerPlane"
     },
     "xMarkerPlaneOffset": {
      "!type": "fn()",
      "!doc": "Distance from a data coordinate to the left/right for setting a hotspot.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_xMarkerPlaneOffset"
     },
     "yMarkerPlaneOffset": {
      "!type": "fn()",
      "!doc": "Distance from a data coordinate to the top/bottom for setting a hotspot.",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_yMarkerPlaneOffset"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Direction of the series",
      "!url": "http://yuilibrary.com/classes/CartesianSeries.html#attribute_direction"
     }
    }
   },
   "CategoryAxis": {
    "!type": "fn(config: yui.Object) -> +charts.CategoryAxis",
    "!proto": "charts.Axis",
    "!doc": "CategoryAxis draws a category axis for a chart.",
    "!url": "http://yuilibrary.com/classes/CategoryAxis.html",
    "prototype": {
     "getMinimumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the first label on an\naxis.",
      "!url": "http://yuilibrary.com/classes/CategoryAxis.html#method_getMinimumValue"
     },
     "getMaximumValue": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string corresponding to the last label on an\naxis.",
      "!url": "http://yuilibrary.com/classes/CategoryAxis.html#method_getMaximumValue"
     }
    }
   },
   "CategoryImpl": {
    "!type": "fn() -> +charts.CategoryImpl",
    "!doc": "CategoryImpl contains logic for managing category data. CategoryImpl is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CategoryAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"CategoryAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/CategoryImpl.html",
    "prototype": {
     "labelFormat": {
      "!type": "fn()",
      "!doc": "Pattern used by the `labelFunction` to format a label. The default `labelFunction` values for\n`CategoryAxis` and `CategoryAxisBase` do not accept a format object. This value can be used by\na custom method.",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#attribute_labelFormat"
     },
     "calculateEdgeOffset": {
      "!type": "fn()",
      "!doc": "Determines whether and offset is automatically calculated for the edges of the axis.",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#attribute_calculateEdgeOffset"
     },
     "labelFunction": {
      "!type": "fn()",
      "!doc": "Method used for formatting a label. This attribute allows for the default label formatting method to overridden.\nThe method use would need to implement the arguments below and return a `String` or `HTMLElement`.\n<dl>\n     <dt>val</dt><dd>Label to be formatted. (`String`)</dd>\n     <dt>format</dt><dd>Template for formatting label. (optional)</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#attribute_labelFunction"
     },
     "formatLabel": {
      "!type": "fn(value: yui.Object) -> ?",
      "!doc": "Formats a label based on the axis type and optionally specified format.",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#method_formatLabel"
     },
     "getDataByKey": {
      "!type": "fn(value: string) -> ?",
      "!doc": "Returns an array of values based on an identifier key.",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#method_getDataByKey"
     },
     "getTotalMajorUnits": {
      "!type": "fn(majorUnit: yui.Object, len: number) -> ?",
      "!doc": "Returns the total number of majorUnits that will appear on an axis.",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#method_getTotalMajorUnits"
     },
     "getKeyValueAt": {
      "!type": "fn(key: string, index: number) -> ?",
      "!doc": "Returns a value based of a key value and an index.",
      "!url": "http://yuilibrary.com/classes/CategoryImpl.html#method_getKeyValueAt"
     }
    }
   },
   "ChartBase": {
    "!type": "fn() -> +charts.ChartBase",
    "!doc": "The ChartBase class is an abstract class used to create charts.",
    "!url": "http://yuilibrary.com/classes/ChartBase.html",
    "prototype": {
     "dataProvider": {
      "!type": "fn()",
      "!doc": "Data used to generate the chart.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_dataProvider"
     },
     "seriesKeys": {
      "!type": "fn()",
      "!doc": "A collection of keys that map to the series axes. If no keys are set,\nthey will be generated automatically depending on the data structure passed into\nthe chart.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_seriesKeys"
     },
     "ariaLabel": {
      "!type": "fn()",
      "!doc": "Sets the `aria-label` for the chart.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_ariaLabel"
     },
     "ariaDescription": {
      "!type": "fn()",
      "!doc": "Sets the aria description for the chart.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_ariaDescription"
     },
     "tooltip": {
      "!type": "fn()",
      "!doc": "Reference to the default tooltip available for the chart.\n<p>Contains the following properties:</p>\n <dl>\n     <dt>node</dt><dd>Reference to the actual dom node</dd>\n     <dt>showEvent</dt><dd>Event that should trigger the tooltip</dd>\n     <dt>hideEvent</dt><dd>Event that should trigger the removal of a tooltip (can be an event or an array of events)</dd>\n     <dt>styles</dt><dd>A hash of style properties that will be applied to the tooltip node</dd>\n     <dt>show</dt><dd>Indicates whether or not to show the tooltip</dd>\n     <dt>markerEventHandler</dt><dd>Displays and hides tooltip based on marker events</dd>\n     <dt>planarEventHandler</dt><dd>Displays and hides tooltip based on planar events</dd>\n     <dt>markerLabelFunction</dt><dd>Reference to the function used to format a marker event triggered tooltip's text.\n     The method contains the following arguments:\n <dl>\n     <dt>categoryItem</dt><dd>An object containing the following:\n <dl>\n     <dt>axis</dt><dd>The axis to which the category is bound.</dd>\n     <dt>displayName</dt><dd>The display name set to the category (defaults to key if not provided).</dd>\n     <dt>key</dt><dd>The key of the category.</dd>\n     <dt>value</dt><dd>The value of the category.</dd>\n </dl>\n </dd>\n <dt>valueItem</dt><dd>An object containing the following:\n     <dl>\n         <dt>axis</dt><dd>The axis to which the item's series is bound.</dd>\n         <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>\n         <dt>key</dt><dd>The key for the series.</dd>\n         <dt>value</dt><dd>The value for the series item.</dd>\n     </dl>\n </dd>\n <dt>itemIndex</dt><dd>The index of the item within the series.</dd>\n <dt>series</dt><dd> The `CartesianSeries` instance of the item.</dd>\n <dt>seriesIndex</dt><dd>The index of the series in the `seriesCollection`.</dd>\n </dl>\n The method returns an `HTMLElement` which is written into the DOM using `appendChild`. If you override this method and choose\n to return an html string, you will also need to override the tooltip's `setTextFunction` method to accept an html string.\n </dd>\n <dt>planarLabelFunction</dt><dd>Reference to the function used to format a planar event triggered tooltip's text\n <dl>\n     <dt>categoryAxis</dt><dd> `CategoryAxis` Reference to the categoryAxis of the chart.\n     <dt>valueItems</dt><dd>Array of objects for each series that has a data point in the coordinate plane of the event. Each\n     object contains the following data:\n <dl>\n     <dt>axis</dt><dd>The value axis of the series.</dd>\n     <dt>key</dt><dd>The key for the series.</dd>\n     <dt>value</dt><dd>The value for the series item.</dd>\n     <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>\n </dl>\n </dd>\n     <dt>index</dt><dd>The index of the item within its series.</dd>\n     <dt>seriesArray</dt><dd>Array of series instances for each value item.</dd>\n     <dt>seriesIndex</dt><dd>The index of the series in the `seriesCollection`.</dd>\n </dl>\n </dd>\n </dl>\n The method returns an `HTMLElement` which is written into the DOM using `appendChild`. If you override this method and choose\n to return an html string, you will also need to override the tooltip's `setTextFunction` method to accept an html string.\n </dd>\n <dt>setTextFunction</dt><dd>Method that writes content returned from `planarLabelFunction` or `markerLabelFunction` into the\n the tooltip node. Has the following signature:\n <dl>\n     <dt>label</dt><dd>The `HTMLElement` that the content is to be added.</dd>\n     <dt>val</dt><dd>The content to be rendered into tooltip. This can be a `String` or `HTMLElement`. If an HTML string is used,\n     it will be rendered as a string.</dd>\n </dl>\n </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_tooltip"
     },
     "categoryKey": {
      "!type": "fn()",
      "!doc": "The key value used for the chart's category axis.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_categoryKey"
     },
     "categoryType": {
      "!type": "fn()",
      "!doc": "Indicates the type of axis to use for the category axis.\n\n <dl>\n     <dt>category</dt><dd>Specifies a `CategoryAxis`.</dd>\n     <dt>time</dt><dd>Specifies a `TimeAxis</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_categoryType"
     },
     "interactionType": {
      "!type": "fn()",
      "!doc": "Indicates the the type of interactions that will fire events.\n\n <dl>\n     <dt>marker</dt><dd>Events will be broadcasted when the mouse interacts with individual markers.</dd>\n     <dt>planar</dt><dd>Events will be broadcasted when the mouse intersects the plane of any markers on the chart.</dd>\n     <dt>none</dt><dd>No events will be broadcasted.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_interactionType"
     },
     "axesCollection": {
      "!type": "fn()",
      "!doc": "Reference to all the axes in the chart.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_axesCollection"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Reference to graph instance.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_graph"
     },
     "groupMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#attribute_groupMarkers"
     },
     "getSeries": {
      "!type": "fn(val) -> ?",
      "!doc": "Returns a series instance by index or key value.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#method_getSeries"
     },
     "getAxisByKey": {
      "!type": "fn(val: string) -> ?",
      "!doc": "Returns an `Axis` instance by key reference. If the axis was explicitly set through the `axes` attribute,\nthe key will be the same as the key used in the `axes` object. For default axes, the key for\nthe category axis is the value of the `categoryKey` (`category`). For the value axis, the default\nkey is `values`.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#method_getAxisByKey"
     },
     "getCategoryAxis": {
      "!type": "fn() -> ?",
      "!doc": "Returns the category axis for the chart.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#method_getCategoryAxis"
     },
     "markerEvent:mouseover": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseover event.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#event_markerEvent:mouseover"
     },
     "markerEvent:mouseout": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseout event.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#event_markerEvent:mouseout"
     },
     "markerEvent:mousedown": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mousedown event.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#event_markerEvent:mousedown"
     },
     "markerEvent:mouseup": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseup event.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#event_markerEvent:mouseup"
     },
     "markerEvent:click": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Broadcasts when `interactionType` is set to `marker` and a series marker has received a click event.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#event_markerEvent:click"
     },
     "toggleTooltip": {
      "!type": "fn(e: yui.Object)",
      "!doc": "Event listener for toggling the tooltip. If a tooltip is visible, hide it. If not, it\nwill create and show a tooltip based on the event object.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#method_toggleTooltip"
     },
     "hideTooltip": {
      "!type": "fn()",
      "!doc": "Hides the default tooltip",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#method_hideTooltip"
     },
     "_getAllKeys": {
      "!type": "fn(dp: yui.Array) -> ?",
      "!doc": "Returns all the keys contained in a  `dataProvider`.",
      "!url": "http://yuilibrary.com/classes/ChartBase.html#method__getAllKeys"
     }
    }
   },
   "ChartLegend": {
    "!type": "fn()",
    "!proto": "widget.Widget",
    "!doc": "ChartLegend provides a legend for a chart.",
    "!url": "http://yuilibrary.com/classes/ChartLegend.html",
    "prototype": {
     "chart": {
      "!type": "fn()",
      "!doc": "Reference to the `Chart` instance.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_chart"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Indicates the direction in relation of the legend's layout. The `direction` of the legend is determined by its\n`position` value.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_direction"
     },
     "position": {
      "!type": "fn()",
      "!doc": "Indicates the position and direction of the legend. Possible values are `left`, `top`, `right` and `bottom`.\nValues of `left` and `right` values have a `direction` of `vertical`. Values of `top` and `bottom` values have\na `direction` of `horizontal`.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_position"
     },
     "width": {
      "!type": "fn()",
      "!doc": "The width of the legend. Depending on the implementation of the ChartLegend, this value is `readOnly`.\nBy default, the legend is included in the layout of the `Chart` that it references. Under this circumstance,\n`width` is always `readOnly`. When the legend is rendered in its own dom element, the `readOnly` status is\ndetermined by the direction of the legend. If the `position` is `left` or `right` or the `direction` is\n`vertical`, width is `readOnly`. If the position is `top` or `bottom` or the `direction` is `horizontal`,\nwidth can be explicitly set. If width is not explicitly set, the width will be determined by the width of the\nlegend's parent element.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "The height of the legend. Depending on the implementation of the ChartLegend, this value is `readOnly`.\nBy default, the legend is included in the layout of the `Chart` that it references. Under this circumstance,\n`height` is always `readOnly`. When the legend is rendered in its own dom element, the `readOnly` status is\ndetermined by the direction of the legend. If the `position` is `top` or `bottom` or the `direction` is\n`horizontal`, height is `readOnly`. If the position is `left` or `right` or the `direction` is `vertical`,\nheight can be explicitly set. If height is not explicitly set, the height will be determined by the width of the\nlegend's parent element.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_height"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x position of legend.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y position of legend.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_y"
     },
     "items": {
      "!type": "fn()",
      "!doc": "Array of items contained in the legend. Each item is an object containing the following properties:\n\n<dl>\n     <dt>node</dt><dd>Node containing text for the legend item.</dd>\n     <dt>marker</dt><dd>Shape for the legend item.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_items"
     },
     "background": {
      "!type": "fn()",
      "!doc": "Background for the legend.",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_background"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Properties used to display and style the ChartLegend.  This attribute is inherited from `Renderer`.\nBelow are the default values:\n\n <dl>\n     <dt>gap</dt><dd>Distance, in pixels, between the `ChartLegend` instance and the chart's content. When `ChartLegend`\n     is rendered within a `Chart` instance this value is applied.</dd>\n     <dt>hAlign</dt><dd>Defines the horizontal alignment of the `items` in a `ChartLegend` rendered in a horizontal direction.\n     This value is applied when the instance's `position` is set to top or bottom. This attribute can be set to left, center\n     or right. The default value is center.</dd>\n     <dt>vAlign</dt><dd>Defines the vertical alignment of the `items` in a `ChartLegend` rendered in vertical direction. This\n     value is applied when the instance's `position` is set to left or right. The attribute can be set to top, middle or\n     bottom. The default value is middle.</dd>\n     <dt>item</dt><dd>Set of style properties applied to the `items` of the `ChartLegend`.\n         <dl>\n             <dt>hSpacing</dt><dd>Horizontal distance, in pixels, between legend `items`.</dd>\n             <dt>vSpacing</dt><dd>Vertical distance, in pixels, between legend `items`.</dd>\n             <dt>label</dt><dd>Properties for the text of an `item`.\n                 <dl>\n                     <dt>color</dt><dd>Color of the text. The default values is \"#808080\".</dd>\n                     <dt>fontSize</dt><dd>Font size for the text. The default value is \"85%\".</dd>\n                 </dl>\n             </dd>\n             <dt>marker</dt><dd>Properties for the `item` markers.\n                 <dl>\n                     <dt>width</dt><dd>Specifies the width of the markers.</dd>\n                     <dt>height</dt><dd>Specifies the height of the markers.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>background</dt><dd>Properties for the `ChartLegend` background.\n         <dl>\n             <dt>fill</dt><dd>Properties for the background fill.\n                 <dl>\n                     <dt>color</dt><dd>Color for the fill. The default value is \"#faf9f2\".</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>Properties for the background border.\n                 <dl>\n                     <dt>color</dt><dd>Color for the border. The default value is \"#dad8c9\".</dd>\n                     <dt>weight</dt><dd>Weight of the border. The default values is 1.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/ChartLegend.html#attribute_styles"
     }
    }
   },
   "ColumnSeries": {
    "!type": "fn(config: yui.Object) -> +charts.ColumnSeries",
    "!proto": "charts.MarkerSeries",
    "!doc": "The ColumnSeries class renders columns positioned horizontally along a category or time axis. The columns'\nlengths are proportional to the values they represent along a vertical axis.\nand the relevant data points.",
    "!url": "http://yuilibrary.com/classes/ColumnSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/ColumnSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 12.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ColumnSeries.html#attribute_styles"
     }
    }
   },
   "ComboSeries": {
    "!type": "fn(config: yui.Object) -> +charts.ComboSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The ComboSeries class renders a combination of lines, plots and area fills in a single series.\nEach series type has a corresponding boolean attribute indicating if it is rendered. By default,\nlines and plots are rendered and area is not.",
    "!url": "http://yuilibrary.com/classes/ComboSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_type"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether a fill is displayed.",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_showAreaFill"
     },
     "showLines": {
      "!type": "fn()",
      "!doc": "Indicates whether lines are displayed.",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_showLines"
     },
     "showMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether markers are displayed.",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_showMarkers"
     },
     "marker": {
      "!type": "fn()",
      "!doc": "Reference to the styles of the markers. These styles can also\nbe accessed through the `styles` attribute. Below are default\nvalues:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the\n             graph. The color will be retrieved from the below array:<br/>\n             `[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph.\n             The color will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>\n     <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_marker"
     },
     "line": {
      "!type": "fn()",
      "!doc": "Reference to the styles of the lines. These styles can also be accessed through the `styles` attribute.\nBelow are the default values:\n <dl>\n     <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color\n     will be retrieved from the following array:\n     `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`\n     <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>\n     <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd>\n     <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>\n     <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>\n     <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value\n     between points. The default value is true.</dd>\n     <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default\n     value is solid.</dd>\n     <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default\n     value is 10.</dd>\n     <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default\n     value is 10.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_line"
     },
     "area": {
      "!type": "fn()",
      "!doc": "Reference to the styles of the area fills. These styles can also be accessed through the `styles` attribute.\nBelow are the default values:\n\n <dl>\n     <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the\n     graph. The color will be retrieved from the following array:\n     `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n     </dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_area"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties for the series. Contains a key indexed hash of the following:\n <dl>\n     <dt>marker</dt><dd>Style properties for the markers in the series. Specific style attributes are listed\n     <a href=\"#attr_marker\">here</a>.</dd>\n     <dt>line</dt><dd>Style properties for the lines in the series. Specific\n     style attributes are listed <a href=\"#attr_line\">here</a>.</dd>\n     <dt>area</dt><dd>Style properties for the area fills in the series. Specific style attributes are listed\n     <a href=\"#attr_area\">here</a>.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/ComboSeries.html#attribute_styles"
     }
    }
   },
   "ComboSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.ComboSplineSeries",
    "!proto": "charts.ComboSeries",
    "!doc": "The ComboSplineSeries class renders a combination of splines, plots and areaspline fills in a single series. Each\nseries type has a corresponding boolean attribute indicating if it is rendered. By default, splines and plots\nare rendered and areaspline is not.",
    "!url": "http://yuilibrary.com/classes/ComboSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/ComboSplineSeries.html#attribute_type"
     }
    }
   },
   "Graph": {
    "!type": "fn() -> +charts.Graph",
    "!proto": "widget.Widget",
    "!doc": "Graph manages and contains series instances for a `CartesianChart`\ninstance.",
    "!url": "http://yuilibrary.com/classes/Graph.html",
    "prototype": {
     "getSeriesByIndex": {
      "!type": "fn(val: number) -> ?",
      "!doc": "Returns a series instance based on an index.",
      "!url": "http://yuilibrary.com/classes/Graph.html#method_getSeriesByIndex"
     },
     "getSeriesByKey": {
      "!type": "fn(val: string) -> ?",
      "!doc": "Returns a series instance based on a key value.",
      "!url": "http://yuilibrary.com/classes/Graph.html#method_getSeriesByKey"
     },
     "chart": {
      "!type": "fn()",
      "!doc": "Reference to the chart instance using the graph.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_chart"
     },
     "seriesCollection": {
      "!type": "fn()",
      "!doc": "Collection of series. When setting the `seriesCollection` the array can contain a combination of either\n`CartesianSeries` instances or object literals with properties that will define a series.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_seriesCollection"
     },
     "showBackground": {
      "!type": "fn()",
      "!doc": "Indicates whether the `Graph` has a background.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_showBackground"
     },
     "seriesDictionary": {
      "!type": "fn()",
      "!doc": "Read-only hash lookup for all series on in the `Graph`.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_seriesDictionary"
     },
     "horizontalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the horizontal `Gridlines` instance.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_horizontalGridlines"
     },
     "verticalGridlines": {
      "!type": "fn()",
      "!doc": "Reference to the vertical `Gridlines` instance.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_verticalGridlines"
     },
     "background": {
      "!type": "fn()",
      "!doc": "Reference to graphic instance used for the background.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_background"
     },
     "gridlines": {
      "!type": "fn()",
      "!doc": "Reference to graphic instance used for gridlines.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_gridlines"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Reference to graphic instance used for series.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_graphic"
     },
     "groupMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_groupMarkers"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing a background. Below are the default values:\n <dl>\n     <dt>background</dt><dd>An object containing the following values:\n         <dl>\n             <dt>fill</dt><dd>Defines the style properties for the fill. Contains the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is #faf9f2.</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the background fill.\n                     The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>Defines the style properties for the border. Contains the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is #dad8c9.</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the background border.\n                     The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/Graph.html#attribute_styles"
     }
    }
   },
   "Gridlines": {
    "!type": "fn(config: yui.Object) -> +charts.Gridlines",
    "!proto": "base.Base",
    "!doc": "Gridlines draws gridlines on a Graph.",
    "!url": "http://yuilibrary.com/classes/Gridlines.html",
    "prototype": {
     "direction": {
      "!type": "fn()",
      "!doc": "Indicates the direction of the gridline.",
      "!url": "http://yuilibrary.com/classes/Gridlines.html#attribute_direction"
     },
     "axis": {
      "!type": "fn()",
      "!doc": "Indicate the `Axis` in which to bind\nthe gridlines.",
      "!url": "http://yuilibrary.com/classes/Gridlines.html#attribute_axis"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Indicates the `Graph` in which the gridlines\nare drawn.",
      "!url": "http://yuilibrary.com/classes/Gridlines.html#attribute_graph"
     },
     "count": {
      "!type": "fn()",
      "!doc": "Indicates the number of gridlines to display. If no value is set, gridlines will equal the number of ticks in\nthe corresponding axis.",
      "!url": "http://yuilibrary.com/classes/Gridlines.html#attribute_count"
     }
    }
   },
   "LineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.LineSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The LineSeries class renders quantitative data on a graph by connecting relevant data points.",
    "!url": "http://yuilibrary.com/classes/LineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/LineSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing lines. This attribute is inherited from `Renderer`. Below are the\ndefault values:\n <dl>\n     <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series\n     on the graph. The color will be retrieved from the following array:\n     `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`\n     <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>\n     <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd>\n     <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default\n     value is 10.</dd>\n     <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default\n     value is 10.</dd>\n     <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing\n     or null value between points. The default value is true.</dd>\n     <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed.\n     The default value is solid.</dd>\n     <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the\n     dash. The default value is 10.</dd>\n     <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between\n     dashes. The default value is 10.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/LineSeries.html#attribute_styles"
     }
    }
   },
   "MarkerSeries": {
    "!type": "fn(config: yui.Object) -> +charts.MarkerSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "The MarkerSeries class renders quantitative data by plotting relevant data points\non a graph.",
    "!url": "http://yuilibrary.com/classes/MarkerSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/MarkerSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `Renderer`. Below are the default\nvalues:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on\n             the graph. The color will be retrieved from the below array:<br/>\n             `[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on\n             the graph. The color will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>\n     <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/MarkerSeries.html#attribute_styles"
     }
    }
   },
   "NumericImpl": {
    "!type": "fn() -> +charts.NumericImpl",
    "!doc": "NumericImpl contains logic for numeric data. NumericImpl is used by the following classes:\n<ul>\n     <li>{{#crossLink \"NumericAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"NumericAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/NumericImpl.html",
    "prototype": {
     "alwaysShowZero": {
      "!type": "fn()",
      "!doc": "Indicates whether 0 should always be displayed.",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html#attribute_alwaysShowZero"
     },
     "labelFunction": {
      "!type": "fn()",
      "!doc": "Method used for formatting a label. This attribute allows for the default label formatting method to overridden.\nThe method use would need to implement the arguments below and return a `String` or an `HTMLElement`. The default\nimplementation of the method returns a `String`. The output of this method will be rendered to the DOM using\n`appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override\nthe Data' `appendLabelFunction` to accept html as a `String`.\n<dl>\n     <dt>val</dt><dd>Label to be formatted. (`String`)</dd>\n     <dt>format</dt><dd>Object containing properties used to format the label. (optional)</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html#attribute_labelFunction"
     },
     "labelFormat": {
      "!type": "fn()",
      "!doc": "Object containing properties used by the `labelFunction` to format a\nlabel.",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html#attribute_labelFormat"
     },
     "roundingMethod": {
      "!type": "fn()",
      "!doc": "Indicates how to round unit values.\n  <dl>\n      <dt>niceNumber</dt><dd>Units will be smoothed based on the number of ticks and data range.</dd>\n      <dt>auto</dt><dd>If the range is greater than 1, the units will be rounded.</dd>\n      <dt>numeric value</dt><dd>Units will be equal to the numeric value.</dd>\n      <dt>null</dt><dd>No rounding will occur.</dd>\n  </dl>",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html#attribute_roundingMethod"
     },
     "": {
      "!type": "fn(value: yui.Object, format: yui.Object) -> ?",
      "!doc": "Formats a label based on the axis type and optionally specified format.",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html"
     },
     "getTotalByKey": {
      "!type": "fn(key: string) -> ?",
      "!doc": "Returns the sum of all values per key.",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html#method_getTotalByKey"
     },
     "getOrigin": {
      "!type": "fn() -> ?",
      "!doc": "Returns the value corresponding to the origin on the axis.",
      "!url": "http://yuilibrary.com/classes/NumericImpl.html#method_getOrigin"
     }
    }
   },
   "OHLCSeries": {
    "!type": "fn(config: yui.Object) -> +charts.OHLCSeries",
    "!proto": "charts.RangeSeries",
    "!doc": "The OHLCSeries class renders lines representing the open, high, low and close\nvalues for a chart.",
    "!url": "http://yuilibrary.com/classes/OHLCSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/OHLCSeries.html#attribute_type"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://yuilibrary.com/classes/OHLCSeries.html#attribute_graphic"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `RangeSeries`. Below are the default values:\n <dl>\n     <dt>upmarker</dt><dd>Properties for a marker representing a period that closes higher than it opens.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#00aa00\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n     <dt>downmarker</dt><dd>Properties for a marker representing a period that opens higher than it closes.\n         <dl>\n             <dt>fill</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the fill. The default value is \"#aa0000\".</dd>\n                     </dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n                 </dl>\n             </dd>\n             <dt>border</dt><dd>A hash containing the following values:\n                 <dl>\n                     <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>\n                     <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n                     <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>\n                 </dl>\n             </dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/OHLCSeries.html#attribute_styles"
     }
    }
   },
   "PieChart": {
    "!type": "fn() -> +charts.PieChart",
    "!proto": "charts.ChartBase",
    "!doc": "The PieChart class creates a pie chart",
    "!url": "http://yuilibrary.com/classes/PieChart.html",
    "prototype": {
     "getSeriesItem": {
      "!type": "fn(series, index) -> ?",
      "!doc": "Returns an object literal containing a categoryItem and a valueItem for a given series index.",
      "!url": "http://yuilibrary.com/classes/PieChart.html#method_getSeriesItem"
     },
     "_getAriaMessage": {
      "!type": "fn(key: number) -> ?",
      "!doc": "Returns the appropriate message based on the key press.",
      "!url": "http://yuilibrary.com/classes/PieChart.html#method__getAriaMessage"
     },
     "ariaDescription": {
      "!type": "fn()",
      "!doc": "Sets the aria description for the chart.",
      "!url": "http://yuilibrary.com/classes/PieChart.html#attribute_ariaDescription"
     },
     "axes": {
      "!type": "fn()",
      "!doc": "Axes to appear in the chart.",
      "!url": "http://yuilibrary.com/classes/PieChart.html#attribute_axes"
     },
     "seriesCollection": {
      "!type": "fn()",
      "!doc": "Collection of series to appear on the chart. This can be an array of Series instances or object literals\nused to describe a Series instance.",
      "!url": "http://yuilibrary.com/classes/PieChart.html#attribute_seriesCollection"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Type of chart when there is no series collection specified.",
      "!url": "http://yuilibrary.com/classes/PieChart.html#attribute_type"
     }
    }
   },
   "PieSeries": {
    "!type": "fn(config: yui.Object) -> +charts.PieSeries",
    "!proto": "charts.SeriesBase",
    "!doc": "PieSeries visualizes data as a circular chart divided into wedges which represent data as a\npercentage of a whole.",
    "!url": "http://yuilibrary.com/classes/PieSeries.html",
    "prototype": {
     "": {
      "!type": "fn()",
      "!doc": "The legend for the chart.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html"
     },
     "getTotalValues": {
      "!type": "fn() -> ?",
      "!doc": "Returns the sum of all values for the series.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#method_getTotalValues"
     },
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_type"
     },
     "order": {
      "!type": "fn()",
      "!doc": "Order of this instance of this `type`.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_order"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Reference to the `Graph` in which the series is drawn into.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_graph"
     },
     "categoryAxis": {
      "!type": "fn()",
      "!doc": "Reference to the `Axis` instance used for assigning\nseries values to the graph.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_categoryAxis"
     },
     "categoryKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe category `Axis` instance.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_categoryKey"
     },
     "valueKey": {
      "!type": "fn()",
      "!doc": "Indicates which array to from the hash of value arrays in\nthe value `Axis` instance.",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_valueKey"
     },
     "categoryDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying category data",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_categoryDisplayName"
     },
     "valueDisplayName": {
      "!type": "fn()",
      "!doc": "Name used for for displaying value data",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_valueDisplayName"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are  the default\nvalues:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>colors</dt><dd>An array of colors to be used for the marker fills. The color for each marker  is\n             retrieved from the array below:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alphas</dt><dd>An array of alpha references (Number from 0 to 1) indicating the opacity of each marker\n             fill. The default value is [1].</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>An array of colors to be used for the marker borders. The color for each marker is\n             retrieved from the array below:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/PieSeries.html#attribute_styles"
     }
    }
   },
   "RangeSeries": {
    "!type": "fn(config: yui.Object) -> +charts.RangeSeries",
    "!proto": "charts.CartesianSeries",
    "!doc": "An abstract class for creating range series instances.\nRangeSeries is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CandlestickSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"OHLCSeries\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/RangeSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/RangeSeries.html#attribute_type"
     },
     "ohlc": {
      "!type": "fn()",
      "!doc": "Values to be used for open, high, low and close keys.",
      "!url": "http://yuilibrary.com/classes/RangeSeries.html#attribute_ohlc"
     }
    }
   },
   "Renderer": {
    "!type": "fn()",
    "!doc": "The Renderer class is a base class for chart components that use the `styles`\nattribute.",
    "!url": "http://yuilibrary.com/classes/Renderer.html",
    "prototype": {
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties for class",
      "!url": "http://yuilibrary.com/classes/Renderer.html#attribute_styles"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://yuilibrary.com/classes/Renderer.html#attribute_graphic"
     }
    }
   },
   "SeriesBase": {
    "!type": "fn(config: yui.Object) -> +charts.SeriesBase",
    "!proto": "base.Base",
    "!doc": "An abstract class for creating series instances.\nSeriesBase is used by the following classes:\n<ul>\n     <li>{{#crossLink \"CartesianSeries\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"PieSeries\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/SeriesBase.html",
    "prototype": {
     "getTotalValues": {
      "!type": "fn() -> ?",
      "!doc": "Returns the sum of all values for the series.",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#method_getTotalValues"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Returns the height of the parent graph",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_height"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "The graphic in which drawings will be rendered.",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_graphic"
     },
     "chart": {
      "!type": "fn()",
      "!doc": "Reference to the `Chart` application. If no `Chart` application is present,\na reference to the `Graphic` instance that the series is drawn into will be returned.",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_chart"
     },
     "graph": {
      "!type": "fn()",
      "!doc": "Reference to the `Graph` in which the series is drawn into.",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_graph"
     },
     "rendered": {
      "!type": "fn()",
      "!doc": "Indicates whether the Series has been through its initial set up.",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_rendered"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether to show the series",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_visible"
     },
     "groupMarkers": {
      "!type": "fn()",
      "!doc": "Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.",
      "!url": "http://yuilibrary.com/classes/SeriesBase.html#attribute_groupMarkers"
     }
    }
   },
   "SplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.SplineSeries",
    "!proto": "charts.LineSeries",
    "!doc": "SplineSeries renders a graph with data points connected by a curve.",
    "!url": "http://yuilibrary.com/classes/SplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/SplineSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing lines. This attribute is inherited from `Renderer`.\nBelow are the default values:\n <dl>\n     <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on\n     the graph. The color will be retrieved from the following array:\n     `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`\n     <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>\n     <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>\n     <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd>\n     <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value\n     is 10.</dd>\n     <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is\n     10.</dd>\n     <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null\n     value between points. The default value is true.</dd>\n     <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The\n     default value is solid.</dd>\n     <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash.\n     The default value is 10.</dd>\n     <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes.\n     The default value is 10.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/SplineSeries.html#attribute_styles"
     }
    }
   },
   "StackedAreaSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedAreaSeries",
    "!proto": "charts.AreaSeries",
    "!doc": "StackedAreaSeries area fills to display data showing its contribution to a whole.",
    "!url": "http://yuilibrary.com/classes/StackedAreaSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedAreaSeries.html#attribute_type"
     }
    }
   },
   "StackedAreaSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedAreaSplineSeries",
    "!proto": "charts.AreaSeries",
    "!doc": "StackedAreaSplineSeries creates a stacked area chart with points data points connected by a curve.",
    "!url": "http://yuilibrary.com/classes/StackedAreaSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedAreaSplineSeries.html#attribute_type"
     }
    }
   },
   "StackedBarSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedBarSeries",
    "!proto": "charts.BarSeries",
    "!doc": "The StackedBarSeries renders bar chart in which series are stacked horizontally to show\ntheir contribution to the cumulative total.",
    "!url": "http://yuilibrary.com/classes/StackedBarSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedBarSeries.html#attribute_type"
     },
     "direction": {
      "!type": "fn()",
      "!doc": "Direction of the series",
      "!url": "http://yuilibrary.com/classes/StackedBarSeries.html#attribute_direction"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `BarSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>height</dt><dd>indicates the width of the marker. The default value is 24.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/StackedBarSeries.html#attribute_styles"
     }
    }
   },
   "StackedColumnSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedColumnSeries",
    "!proto": "charts.ColumnSeries",
    "!doc": "The StackedColumnSeries renders column chart in which series are stacked vertically to show\ntheir contribution to the cumulative total.",
    "!url": "http://yuilibrary.com/classes/StackedColumnSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedColumnSeries.html#attribute_type"
     },
     "styles": {
      "!type": "fn()",
      "!doc": "Style properties used for drawing markers. This attribute is inherited from `ColumnSeries`. Below are the default values:\n <dl>\n     <dt>fill</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`\n             </dd>\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>border</dt><dd>A hash containing the following values:\n         <dl>\n             <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color\n             will be retrieved from the below array:<br/>\n             `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`\n             <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>\n             <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>\n         </dl>\n     </dd>\n     <dt>width</dt><dd>indicates the width of the marker. The default value is 24.</dd>\n     <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default\n     values for each style is null. When an over style is not set, the non-over value will be used. For example,\n     the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/StackedColumnSeries.html#attribute_styles"
     }
    }
   },
   "StackedComboSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedComboSeries",
    "!proto": "charts.ComboSeries",
    "!doc": "The StackedComboSeries class renders a combination of lines, plots and area fills in a single series. Series\nare stacked along the value axis to indicate each series contribution to a cumulative total. Each\nseries type has a corresponding boolean attribute indicating if it is rendered. By default, all three types are\nrendered.",
    "!url": "http://yuilibrary.com/classes/StackedComboSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedComboSeries.html#attribute_type"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether a fill is displayed.",
      "!url": "http://yuilibrary.com/classes/StackedComboSeries.html#attribute_showAreaFill"
     }
    }
   },
   "StackedComboSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedComboSplineSeries",
    "!proto": "charts.StackedComboSeries",
    "!doc": "The StackedComboSplineSeries class renders a combination of splines, plots and areaspline fills in a single series. Series\nare stacked along the value axis to indicate each series contribution to a cumulative total. Each\nseries type has a corresponding boolean attribute indicating if it is rendered. By default, all three types are\nrendered.",
    "!url": "http://yuilibrary.com/classes/StackedComboSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedComboSplineSeries.html#attribute_type"
     },
     "showAreaFill": {
      "!type": "fn()",
      "!doc": "Indicates whether a fill is displayed.",
      "!url": "http://yuilibrary.com/classes/StackedComboSplineSeries.html#attribute_showAreaFill"
     }
    }
   },
   "StackedLineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedLineSeries",
    "!proto": "charts.LineSeries",
    "!doc": "StackedLineSeries creates line graphs in which the different series are stacked along a value axis\nto indicate their contribution to a cumulative total.",
    "!url": "http://yuilibrary.com/classes/StackedLineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedLineSeries.html#attribute_type"
     }
    }
   },
   "StackedMarkerSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedMarkerSeries",
    "!proto": "charts.MarkerSeries",
    "!doc": "StackedMarkerSeries plots markers with different series stacked along the value axis to indicate each\nseries' contribution to a cumulative total.",
    "!url": "http://yuilibrary.com/classes/StackedMarkerSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedMarkerSeries.html#attribute_type"
     }
    }
   },
   "StackedSplineSeries": {
    "!type": "fn(config: yui.Object) -> +charts.StackedSplineSeries",
    "!proto": "charts.SplineSeries",
    "!doc": "StackedSplineSeries creates spline graphs in which the different series are stacked along a value axis\nto indicate their contribution to a cumulative total.",
    "!url": "http://yuilibrary.com/classes/StackedSplineSeries.html",
    "prototype": {
     "type": {
      "!type": "fn()",
      "!doc": "Read-only attribute indicating the type of series.",
      "!url": "http://yuilibrary.com/classes/StackedSplineSeries.html#attribute_type"
     }
    }
   },
   "TimeImpl": {
    "!type": "fn() -> +charts.TimeImpl",
    "!doc": "TimeImpl contains logic for time data. TimeImpl is used by the following classes:\n<ul>\n     <li>{{#crossLink \"TimeAxisBase\"}}{{/crossLink}}</li>\n     <li>{{#crossLink \"TimeAxis\"}}{{/crossLink}}</li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/TimeImpl.html",
    "prototype": {
     "labelFunction": {
      "!type": "fn()",
      "!doc": "Method used for formatting a label. This attribute allows for the default label formatting method to overridden.\nThe method use would need to implement the arguments below and return a `String` or an `HTMLElement`. The default\nimplementation of the method returns a `String`. The output of this method will be rendered to the DOM using\n`appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override\nthe Axis' `appendLabelFunction` to accept html as a `String`.\n<dl>\n     <dt>val</dt><dd>Label to be formatted. (`String`)</dd>\n     <dt>format</dt><dd>STRFTime string used to format the label. (optional)</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/TimeImpl.html#attribute_labelFunction"
     },
     "labelFormat": {
      "!type": "fn()",
      "!doc": "Pattern used by the `labelFunction` to format a label.",
      "!url": "http://yuilibrary.com/classes/TimeImpl.html#attribute_labelFormat"
     },
     "formatLabel": {
      "!type": "fn(value: yui.Object, format: yui.Object) -> ?",
      "!doc": "Formats a label based on the axis type and optionally specified format.",
      "!url": "http://yuilibrary.com/classes/TimeImpl.html#method_formatLabel"
     }
    }
   }
  },
  "classnamemanager": {
   "ClassNameManager": {
    "!type": "fn()",
    "!doc": "A singleton class providing:\n\n<ul>\n   <li>Easy creation of prefixed class names</li>\n   <li>Caching of previously created class names for improved performance.</li>\n</ul>",
    "!url": "http://yuilibrary.com/classes/ClassNameManager.html",
    "classNamePrefix": {
     "!type": "string",
     "!doc": "Configuration property indicating the prefix for all CSS class names in this YUI instance.",
     "!url": "http://yuilibrary.com/classes/ClassNameManager.html#property_classNamePrefix"
    },
    "classNameDelimiter": {
     "!type": "string",
     "!doc": "Configuration property indicating the delimiter used to compose all CSS class names in\nthis YUI instance.",
     "!url": "http://yuilibrary.com/classes/ClassNameManager.html#property_classNameDelimiter"
    },
    "prototype": {
     "getClassName": {
      "!type": "fn(classnameSection?: string, skipPrefix: bool)",
      "!doc": "Returns a class name prefixed with the the value of the\n<code>Y.config.classNamePrefix</code> attribute + the provided strings.\nUses the <code>Y.config.classNameDelimiter</code> attribute to delimit the\nprovided strings. E.g. Y.ClassNameManager.getClassName('foo','bar'); // yui-foo-bar",
      "!url": "http://yuilibrary.com/classes/ClassNameManager.html#method_getClassName"
     }
    }
   }
  },
  "collection": {
   "Array": {
    "!type": "fn(thing: Any, startIndex?: number, force?: bool) -> +yui.Array",
    "!doc": "Provides utility methods for working with arrays. Additional array helpers can\nbe found in the `collection` and `array-extras` modules.\n\n`Y.Array(thing)` returns a native array created from _thing_. Depending on\n_thing_'s type, one of the following will happen:\n\n  * Arrays are returned unmodified unless a non-zero _startIndex_ is\n    specified.\n  * Array-like collections (see `Array.test()`) are converted to arrays.\n  * For everything else, a new array is created with _thing_ as the sole\n    item.\n\nNote: elements that are also collections, such as `<form>` and `<select>`\nelements, are not automatically converted to arrays. To force a conversion,\npass `true` as the value of the _force_ parameter.",
    "!url": "http://yuilibrary.com/classes/Array.html",
    "lastIndexOf": {
     "!type": "fn(a: yui.Array, val: Any, fromIndex?: number) -> number",
     "!doc": "Returns the index of the last item in the array that contains the specified\nvalue, or `-1` if the value isn't found.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_lastIndexOf"
    },
    "unique": {
     "!type": "fn(array: yui.Array, testFn?: fn()) -> +yui.Array",
     "!doc": "Returns a copy of the input array with duplicate items removed.\n\nNote: If the input array only contains strings, the `Y.Array.dedupe()` method is\na much faster alternative.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_unique"
    },
    "filter": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Array",
     "!doc": "Executes the supplied function on each item in the array. Returns a new array\ncontaining the items for which the supplied function returned a truthy value.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_filter"
    },
    "reject": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Array",
     "!doc": "The inverse of `Array.filter()`. Executes the supplied function on each item.\nReturns a new array containing the items for which the supplied function\nreturned `false`.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_reject"
    },
    "every": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> bool",
     "!doc": "Executes the supplied function on each item in the array. Iteration stops if the\nsupplied function does not return a truthy value.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_every"
    },
    "map": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Array",
     "!doc": "Executes the supplied function on each item in the array and returns a new array\ncontaining all the values returned by the supplied function.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_map"
    },
    "reduce": {
     "!type": "fn(a: yui.Array, init: Any, f: fn(), o?: yui.Object) -> +Any",
     "!doc": "Executes the supplied function on each item in the array, \"folding\" the array\ninto a single value.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_reduce"
    },
    "find": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Object",
     "!doc": "Executes the supplied function on each item in the array, searching for the\nfirst item that matches the supplied function.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_find"
    },
    "grep": {
     "!type": "fn(a: yui.Array, pattern: RegExp) -> +yui.Array",
     "!doc": "Iterates over an array, returning a new array of all the elements that match the\nsupplied regular expression.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_grep"
    },
    "partition": {
     "!type": "fn(a: yui.Array, f: fn(), o?: yui.Object) -> +yui.Object",
     "!doc": "Partitions an array into two new arrays, one with the items for which the\nsupplied function returns `true`, and one with the items for which the function\nreturns `false`.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_partition"
    },
    "zip": {
     "!type": "fn(a: yui.Array, a2: yui.Array) -> +yui.Array",
     "!doc": "Creates an array of arrays by pairing the corresponding elements of two arrays\ntogether into a new array.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_zip"
    },
    "flatten": {
     "!type": "fn(a: yui.Array) -> +yui.Array",
     "!doc": "Flattens an array of nested arrays at any abitrary depth into a single, flat\narray.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_flatten"
    },
    "invoke": {
     "!type": "fn(items: yui.Array, name: string, args?: Any) -> +yui.Array",
     "!doc": "Executes a named method on each item in an array of objects. Items in the array\nthat do not have a function by that name will be skipped.",
     "!url": "http://yuilibrary.com/classes/Array.html#method_invoke"
    }
   },
   "ArrayList": {
    "!type": "fn(items: yui.Array) -> +collection.ArrayList",
    "!doc": "Generic ArrayList class for managing lists of items and iterating operations\nover them.  The targeted use for this class is for augmentation onto a\nclass that is responsible for managing multiple instances of another class\n(e.g. NodeList for Nodes).  The recommended use is to augment your class with\nArrayList, then use ArrayList.addMethod to mirror the API of the constituent\nitems on the list's API.\n\nThe default implementation creates immutable lists, but mutability can be\nprovided via the arraylist-add submodule or by implementing mutation methods\ndirectly on the augmented class's prototype.",
    "!url": "http://yuilibrary.com/classes/ArrayList.html",
    "prototype": {
     "add": {
      "!type": "fn(item: Mixed, index: number) -> !this",
      "!doc": "Add a single item to the ArrayList.  Does not prevent duplicates.",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_add"
     },
     "remove": {
      "!type": "fn(needle: Mixed, all: bool, comparator: fn()) -> !this",
      "!doc": "Removes first or all occurrences of an item to the ArrayList.  If a\ncomparator is not provided, uses itemsAreEqual method to determine\nmatches.",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_remove"
     },
     "itemsAreEqual": {
      "!type": "fn(a: Mixed, b: Mixed) -> bool",
      "!doc": "Default comparator for items stored in this list.  Used by remove().",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_itemsAreEqual"
     },
     "filter": {
      "!type": "fn(validator: fn()) -> +collection.ArrayList",
      "!doc": "<p>Create a new ArrayList (or augmenting class instance) from a subset\nof items as determined by the boolean function passed as the\nargument.  The original ArrayList is unchanged.</p>\n\n<p>The validator signature is <code>validator( item )</code>.</p>",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_filter"
     },
     "item": {
      "!type": "fn(i: Integer) -> +Mixed",
      "!doc": "Get an item by index from the list.  Override this method if managing a\nlist of objects that have a different public representation (e.g. Node\ninstances vs DOM nodes).  The iteration methods that accept a user\nfunction will use this method for access list items for operation.",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_item"
     },
     "each": {
      "!type": "fn(fn: fn(), context: Mixed) -> !this",
      "!doc": "<p>Execute a function on each item of the list, optionally providing a\ncustom execution context.  Default context is the item.</p>\n\n<p>The callback signature is <code>callback( item, index )</code>.</p>",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_each"
     },
     "some": {
      "!type": "fn(fn: fn(), context: Mixed) -> bool",
      "!doc": "<p>Execute a function on each item of the list, optionally providing a\ncustom execution context.  Default context is the item.</p>\n\n<p>The callback signature is <code>callback( item, index )</code>.</p>\n\n<p>Unlike <code>each</code>, if the callback returns true, the\niteration will stop.</p>",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_some"
     },
     "indexOf": {
      "!type": "fn(needle: Mixed) -> +Integer",
      "!doc": "Finds the first index of the needle in the managed array of items.",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_indexOf"
     },
     "size": {
      "!type": "fn() -> +Integer",
      "!doc": "How many items are in this list?",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_size"
     },
     "isEmpty": {
      "!type": "fn() -> bool",
      "!doc": "Is this instance managing any items?",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_isEmpty"
     },
     "toJSON": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Provides an array-like representation for JSON.stringify.",
      "!url": "http://yuilibrary.com/classes/ArrayList.html#method_toJSON"
     }
    },
    "addMethod": {
     "!type": "fn(dest: yui.Object, name: string)",
     "!doc": "<p>Adds a pass through method to dest (typically the prototype of a list\nclass) that calls the named method on each item in the list with\nwhatever parameters are passed in.  Allows for API indirection via list\ninstances.</p>\n\n<p>Accepts a single string name or an array of string names.</p>\n\n<pre><code>list.each( function ( item ) {\n    item.methodName( 1, 2, 3 );\n} );\n// becomes\nlist.methodName( 1, 2, 3 );</code></pre>\n\n<p>Additionally, the pass through methods use the item retrieved by the\n<code>_item</code> method in case there is any special behavior that is\nappropriate for API mirroring.</p>\n\n<p>If the iterated method returns a value, the return value from the\nadded method will be an array of values with each value being at the\ncorresponding index for that item.  If the iterated method does not\nreturn a value, the added method will be chainable.",
     "!url": "http://yuilibrary.com/classes/ArrayList.html#method_addMethod"
    }
   }
  },
  "color": {
   "Color": {
    "!type": "fn()",
    "!doc": "Color provides static methods for color conversion.\n\n    Y.Color.toRGB('f00'); // rgb(255, 0, 0)\n\n    Y.Color.toHex('rgb(255, 255, 0)'); // #ffff00",
    "!url": "http://yuilibrary.com/classes/Color.html",
    "KEYWORDS": {
     "!type": "+yui.Object",
     "!url": "http://yuilibrary.com/classes/Color.html#property_KEYWORDS"
    },
    "REGEX_HEX": {
     "!type": "+RegExp",
     "!doc": "NOTE: `(\\ufffe)?` is added to the Regular Expression to carve out a\nplace for the alpha channel that is returned from toArray\nwithout compromising any usage of the Regular Expression",
     "!url": "http://yuilibrary.com/classes/Color.html#property_REGEX_HEX"
    },
    "REGEX_HEX3": {
     "!type": "+RegExp",
     "!doc": "NOTE: `(\\ufffe)?` is added to the Regular Expression to carve out a\nplace for the alpha channel that is returned from toArray\nwithout compromising any usage of the Regular Expression",
     "!url": "http://yuilibrary.com/classes/Color.html#property_REGEX_HEX3"
    },
    "REGEX_RGB": {
     "!type": "+RegExp",
     "!url": "http://yuilibrary.com/classes/Color.html#property_REGEX_RGB"
    },
    "STR_HEX": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.html#property_STR_HEX"
    },
    "STR_RGB": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.html#property_STR_RGB"
    },
    "STR_RGBA": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.html#property_STR_RGBA"
    },
    "TYPES": {
     "!type": "+yui.Object",
     "!url": "http://yuilibrary.com/classes/Color.html#property_TYPES"
    },
    "CONVERTS": {
     "!type": "+yui.Object",
     "!url": "http://yuilibrary.com/classes/Color.html#property_CONVERTS"
    },
    "prototype": {
     "convert": {
      "!type": "fn(str: string, to: string) -> string",
      "!doc": "Converts the provided string to the provided type.\nYou can use the `Y.Color.TYPES` to get a valid `to` type.\nIf the color cannot be converted, the original color will be returned.",
      "!url": "http://yuilibrary.com/classes/Color.html#method_convert"
     },
     "toHex": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to a hex value string",
      "!url": "http://yuilibrary.com/classes/Color.html#method_toHex"
     },
     "toRGB": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an RGB value string",
      "!url": "http://yuilibrary.com/classes/Color.html#method_toRGB"
     },
     "toRGBA": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an RGB value string",
      "!url": "http://yuilibrary.com/classes/Color.html#method_toRGBA"
     },
     "toArray": {
      "!type": "fn(str: string) -> +yui.Array",
      "!doc": "Converts the provided color string to an array of values where the\n    last value is the alpha value. Will return an empty array if\n    the provided string is not able to be parsed.\n\n    NOTE: `(\\ufffe)?` is added to `HEX` and `HEX3` Regular Expressions to\n    carve out a place for the alpha channel that is returned from\n    toArray without compromising any usage of the Regular Expression\n\n    Y.Color.toArray('fff');              // ['ff', 'ff', 'ff', 1]\n    Y.Color.toArray('rgb(0, 0, 0)');     // ['0', '0', '0', 1]\n    Y.Color.toArray('rgba(0, 0, 0, 0)'); // ['0', '0', '0', 1]",
      "!url": "http://yuilibrary.com/classes/Color.html#method_toArray"
     },
     "fromArray": {
      "!type": "fn(arr: yui.Array, template: string) -> string",
      "!doc": "Converts the array of values to a string based on the provided template.",
      "!url": "http://yuilibrary.com/classes/Color.html#method_fromArray"
     },
     "findType": {
      "!type": "fn(str: string) -> string",
      "!doc": "Finds the value type based on the str value provided.",
      "!url": "http://yuilibrary.com/classes/Color.html#method_findType"
     }
    }
   },
   "Color.Harmony": {
    "!type": "fn()",
    "!doc": "Color Harmony provides methods useful for color combination discovery.",
    "!url": "http://yuilibrary.com/classes/Color.Harmony.html",
    "prototype": {
     "getComplementary": {
      "!type": "fn(str: string, to?: string) -> +yui.Array",
      "!doc": "Returns an Array of two colors. The first color in the Array\n  will be the color passed in. The second will be the\n  complementary color of the color provided",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getComplementary"
     },
     "getSplit": {
      "!type": "fn(str: string, offset?: number, to?: string) -> string",
      "!doc": "Returns an Array of three colors. The first color in the Array\n  will be the color passed in. The second two will be split\n  complementary colors.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getSplit"
     },
     "getAnalogous": {
      "!type": "fn(str: string, offset?: number, to?: string) -> string",
      "!doc": "Returns an Array of five colors. The first color in the Array\n  will be the color passed in. The remaining four will be\n  analogous colors two in either direction from the initially\n  provided color.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getAnalogous"
     },
     "getTriad": {
      "!type": "fn(str: string, to?: string) -> string",
      "!doc": "Returns an Array of three colors. The first color in the Array\n  will be the color passed in. The second two will be equidistant\n  from the start color and each other.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getTriad"
     },
     "getTetrad": {
      "!type": "fn(str: string, offset?: number, to?: string) -> string",
      "!doc": "Returns an Array of four colors. The first color in the Array\n  will be the color passed in. The remaining three colors are\n  equidistant offsets from the starting color and each other.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getTetrad"
     },
     "getSquare": {
      "!type": "fn(str: string, to?: string) -> string",
      "!doc": "Returns an Array of four colors. The first color in the Array\n  will be the color passed in. The remaining three colors are\n  equidistant offsets from the starting color and each other.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getSquare"
     },
     "getMonochrome": {
      "!type": "fn(str: string, count?: number, to?: string) -> string",
      "!doc": "Calculates lightness offsets resulting in a monochromatic Array\n  of values.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getMonochrome"
     },
     "getSimilar": {
      "!type": "fn(str: string, offset?: number, count?: number, to?: string) -> string",
      "!doc": "Creates an Array of similar colors. Returned Array is prepended\n   with the color provided followed a number of colors decided\n   by count",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getSimilar"
     },
     "getOffset": {
      "!type": "fn(str: string, adjust: yui.Object, to?: string) -> string",
      "!doc": "Adjusts the provided color by the offset(s) given. You may\n  adjust hue, saturation, and/or luminance in one step.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getOffset"
     },
     "getBrightness": {
      "!type": "fn(str: string) -> number",
      "!doc": "Returns 0 - 100 percentage of brightness from `0` (black) being the\n  darkest to `100` (white) being the brightest.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getBrightness"
     },
     "getSimilarBrightness": {
      "!type": "fn(str: string, match: string, to?: string) -> string",
      "!doc": "Returns a new color value with adjusted luminance so that the\n  brightness of the return color matches the perceived brightness\n  of the `match` color provided.",
      "!url": "http://yuilibrary.com/classes/Color.Harmony.html#method_getSimilarBrightness"
     }
    }
   },
   "Color.HSL": {
    "!type": "fn()",
    "!doc": "Color provides static methods for color conversion to hsl values.\n\n    Y.Color.toHSL('f00'); // hsl(0, 100%, 50%)\n\n    Y.Color.toHSLA('rgb(255, 255, 0'); // hsla(60, 100%, 50%, 1)",
    "!url": "http://yuilibrary.com/classes/Color.HSL.html",
    "REGEX_HSL": {
     "!type": "+RegExp",
     "!url": "http://yuilibrary.com/classes/Color.HSL.html#property_REGEX_HSL"
    },
    "STR_HSL": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.HSL.html#property_STR_HSL"
    },
    "STR_HSLA": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.HSL.html#property_STR_HSLA"
    },
    "prototype": {
     "toHSL": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSL string.",
      "!url": "http://yuilibrary.com/classes/Color.HSL.html#method_toHSL"
     },
     "toHSLA": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSLA string.",
      "!url": "http://yuilibrary.com/classes/Color.HSL.html#method_toHSLA"
     }
    }
   },
   "Color.HSV": {
    "!type": "fn()",
    "!doc": "Color provides static methods for color conversion hsv values.\n\n    Y.Color.toHSV('f00'); // hsv(0, 100%, 100%)\n\n    Y.Color.toHSVA('rgb(255, 255, 0'); // hsva(60, 100%, 100%, 1)",
    "!url": "http://yuilibrary.com/classes/Color.HSV.html",
    "REGEX_HSV": {
     "!type": "+RegExp",
     "!url": "http://yuilibrary.com/classes/Color.HSV.html#property_REGEX_HSV"
    },
    "STR_HSV": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.HSV.html#property_STR_HSV"
    },
    "STR_HSVA": {
     "!type": "string",
     "!url": "http://yuilibrary.com/classes/Color.HSV.html#property_STR_HSVA"
    },
    "prototype": {
     "toHSV": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSV string.",
      "!url": "http://yuilibrary.com/classes/Color.HSV.html#method_toHSV"
     },
     "toHSVA": {
      "!type": "fn(str: string) -> string",
      "!doc": "Converts provided color value to an HSVA string.",
      "!url": "http://yuilibrary.com/classes/Color.HSV.html#method_toHSVA"
     }
    }
   }
  },
  "console_filters": {
   "Plugin.ConsoleFilters": {
    "!type": "fn()",
    "!doc": "<p>Provides Plugin.ConsoleFilters plugin class.</p>\n\n<p>This plugin adds the ability to control which Console entries display by filtering on category and source. Two groups of checkboxes are added to the Console footer, one for categories and the other for sources.  Only those messages that match a checked category or source are displayed.</p>",
    "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html",
    "prototype": {
     "syncUI": {
      "!type": "fn()",
      "!doc": "Updates the UI to be in accordance with the current state of the plugin.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#method_syncUI"
     },
     "refreshConsole": {
      "!type": "fn()",
      "!doc": "Repopulates the Console with entries appropriate to the current filter\nsettings.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#method_refreshConsole"
     },
     "hideCategory": {
      "!type": "fn(cat: string)",
      "!doc": "Hides any number of categories from the UI.  Convenience method for\nmyConsole.filter.set('category.foo', false); set('category.bar', false);\nand so on.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#method_hideCategory"
     },
     "showCategory": {
      "!type": "fn(cat: string)",
      "!doc": "Shows any number of categories in the UI.  Convenience method for\nmyConsole.filter.set('category.foo', true); set('category.bar', true);\nand so on.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#method_showCategory"
     },
     "hideSource": {
      "!type": "fn(src: string)",
      "!doc": "Hides any number of sources from the UI.  Convenience method for\nmyConsole.filter.set('source.foo', false); set('source.bar', false);\nand so on.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#method_hideSource"
     },
     "showSource": {
      "!type": "fn(src: string)",
      "!doc": "Shows any number of sources in the UI.  Convenience method for\nmyConsole.filter.set('source.foo', true); set('source.bar', true);\nand so on.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#method_showSource"
     },
     "defaultVisibility": {
      "!type": "fn()",
      "!doc": "Default visibility applied to new categories and sources.",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#attribute_defaultVisibility"
     },
     "category": {
      "!type": "fn()",
      "!doc": "<p>Map of entry categories to their visibility status.  Update a\nparticular category's visibility by setting the subattribute to true\n(visible) or false (hidden).</p>\n\n<p>For example, yconsole.filter.set('category.info', false) to hide\nlog entries with the category/logLevel of 'info'.</p>\n\n<p>Similarly, yconsole.filter.get('category.warn') will return a\nboolean indicating whether that category is currently being included\nin the UI.</p>\n\n<p>Unlike the YUI instance configuration's logInclude and logExclude\nproperties, filtered entries are only hidden from the UI, but\ncan be made visible again.</p>",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#attribute_category"
     },
     "source": {
      "!type": "fn()",
      "!doc": "<p>Map of entry sources to their visibility status.  Update a\nparticular sources's visibility by setting the subattribute to true\n(visible) or false (hidden).</p>\n\n<p>For example, yconsole.filter.set('sources.slider', false) to hide\nlog entries originating from Y.Slider.</p>",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#attribute_source"
     },
     "cacheLimit": {
      "!type": "fn()",
      "!doc": "Maximum number of entries to store in the message cache.  Use this to\nlimit the memory footprint in environments with heavy log usage.\nBy default, there is no limit (Number.POSITIVE_INFINITY).",
      "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#attribute_cacheLimit"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "Plugin name.",
     "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace hung off the host object that this plugin will inhabit.",
     "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#property_NS"
    },
    "CATEGORIES_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to create the container for the category filters.",
     "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#property_CATEGORIES_TEMPLATE"
    },
    "SOURCES_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to create the container for the source filters.",
     "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#property_SOURCES_TEMPLATE"
    },
    "FILTER_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to create the category and source filter checkboxes.",
     "!url": "http://yuilibrary.com/classes/Plugin.ConsoleFilters.html#property_FILTER_TEMPLATE"
    }
   }
  },
  "console": {
   "Console": {
    "!type": "fn(config?: yui.Object) -> +console.Console",
    "!proto": "widget.Widget",
    "!doc": "A basic console that displays messages logged throughout your application.",
    "!url": "http://yuilibrary.com/classes/Console.html",
    "prototype": {
     "log": {
      "!type": "fn(arg: MIXED) -> !this",
      "!doc": "Wrapper for <code>Y.log</code>.",
      "!url": "http://yuilibrary.com/classes/Console.html#method_log"
     },
     "clearConsole": {
      "!type": "fn() -> !this",
      "!doc": "Clear the console of messages and flush the buffer of pending messages.",
      "!url": "http://yuilibrary.com/classes/Console.html#method_clearConsole"
     },
     "reset": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Triggers the reset behavior via the default logic in _defResetFn.",
      "!url": "http://yuilibrary.com/classes/Console.html#event_reset"
     },
     "collapse": {
      "!type": "fn() -> !this",
      "!doc": "Collapses the body and footer.",
      "!url": "http://yuilibrary.com/classes/Console.html#method_collapse"
     },
     "expand": {
      "!type": "fn() -> !this",
      "!doc": "Expands the body and footer if collapsed.",
      "!url": "http://yuilibrary.com/classes/Console.html#method_expand"
     },
     "printBuffer": {
      "!type": "fn(limit: number) -> !this",
      "!doc": "Outputs buffered messages to the console UI.  This is typically called\nfrom a scheduled interval until the buffer is empty (referred to as the\nprint loop).  The number of buffered messages output to the Console is\nlimited to the number provided as an argument.  If no limit is passed,\nall buffered messages are rendered.",
      "!url": "http://yuilibrary.com/classes/Console.html#method_printBuffer"
     },
     "entry": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Transfers a received message to the print loop buffer.  Default\nbehavior defined in _defEntryFn.",
      "!url": "http://yuilibrary.com/classes/Console.html#event_entry"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Sync the UI state to the current attribute state.",
      "!url": "http://yuilibrary.com/classes/Console.html#method_syncUI"
     },
     "scrollToLatest": {
      "!type": "fn() -> !this",
      "!doc": "Scrolls to the most recent entry",
      "!url": "http://yuilibrary.com/classes/Console.html#method_scrollToLatest"
     },
     "logEvent": {
      "!type": "fn()",
      "!doc": "Name of the custom event that will communicate log messages.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_logEvent"
     },
     "logSource": {
      "!type": "fn()",
      "!doc": "Object that will emit the log events.  By default the YUI instance.\nTo have a single Console capture events from all YUI instances, set\nthis to the Y.Global object.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_logSource"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Collection of strings used to label elements in the Console UI.\nDefault collection contains the following name:value pairs:\n\n<ul>\n  <li>title : &quot;Log Console&quot;</li>\n  <li>pause : &quot;Pause&quot;</li>\n  <li>clear : &quot;Clear&quot;</li>\n  <li>collapse : &quot;Collapse&quot;</li>\n  <li>expand : &quot;Expand&quot;</li>\n</ul>",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_strings"
     },
     "paused": {
      "!type": "fn()",
      "!doc": "Boolean to pause the outputting of new messages to the console.\nWhen paused, messages will accumulate in the buffer.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_paused"
     },
     "defaultCategory": {
      "!type": "fn()",
      "!doc": "If a category is not specified in the Y.log(..) statement, this\ncategory will be used. Categories &quot;info&quot;,\n&quot;warn&quot;, and &quot;error&quot; are also called log level.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_defaultCategory"
     },
     "defaultSource": {
      "!type": "fn()",
      "!doc": "If a source is not specified in the Y.log(..) statement, this\nsource will be used.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_defaultSource"
     },
     "entryTemplate": {
      "!type": "fn()",
      "!doc": "Markup template used to create the DOM structure for Console entries.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_entryTemplate"
     },
     "logLevel": {
      "!type": "fn()",
      "!doc": "Minimum entry log level to render into the Console.  The initial\nlogLevel value for all Console instances defaults from the\nY.config.logLevel YUI configuration, or Console.LOG_LEVEL_INFO if\nthat configuration is not set.\n\nPossible values are &quot;info&quot;, &quot;warn&quot;,\n&quot;error&quot; (case insensitive), or their corresponding statics\nConsole.LOG_LEVEL_INFO and so on.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_logLevel"
     },
     "printTimeout": {
      "!type": "fn()",
      "!doc": "Millisecond timeout between iterations of the print loop, moving\nentries from the buffer to the UI.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_printTimeout"
     },
     "printLimit": {
      "!type": "fn()",
      "!doc": "Maximum number of entries printed in each iteration of the print\nloop. This is used to prevent excessive logging locking the page UI.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_printLimit"
     },
     "consoleLimit": {
      "!type": "fn()",
      "!doc": "Maximum number of Console entries allowed in the Console body at one\ntime.  This is used to keep acquired messages from exploding the\nDOM tree and impacting page performance.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_consoleLimit"
     },
     "newestOnTop": {
      "!type": "fn()",
      "!doc": "New entries should display at the top of the Console or the bottom?",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_newestOnTop"
     },
     "scrollIntoView": {
      "!type": "fn()",
      "!doc": "When new entries are added to the Console UI, should they be\nscrolled into view?",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_scrollIntoView"
     },
     "startTime": {
      "!type": "fn()",
      "!doc": "The baseline time for this Console instance, used to measure elapsed\ntime from the moment the console module is <code>use</code>d to the\nmoment each new entry is logged (not rendered).\n\nThis value is reset by the instance method myConsole.reset().",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_startTime"
     },
     "lastTime": {
      "!type": "fn()",
      "!doc": "The precise time the last entry was logged.  Used to measure elapsed\ntime between log messages.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_lastTime"
     },
     "collapsed": {
      "!type": "fn()",
      "!doc": "Controls the collapsed state of the Console",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_collapsed"
     },
     "height": {
      "!type": "fn()",
      "!doc": "String with units, or number, representing the height of the Console,\ninclusive of header and footer. If a number is provided, the default\nunit, defined by Widget's DEF_UNIT, property is used.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_height"
     },
     "width": {
      "!type": "fn()",
      "!doc": "String with units, or number, representing the width of the Console.\nIf a number is provided, the default unit, defined by Widget's\nDEF_UNIT, property is used.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_width"
     },
     "useBrowserConsole": {
      "!type": "fn()",
      "!doc": "Pass through to the YUI instance useBrowserConsole configuration.\nBy default this is set to false, which will disable logging to the\nbrowser console when a Console instance is created.  If the\nlogSource is not a YUI instance, this has no effect.",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_useBrowserConsole"
     },
     "style": {
      "!type": "fn()",
      "!doc": "Allows the Console to flow in the document.  Available values are\n'inline', 'block', and 'separate' (the default).",
      "!url": "http://yuilibrary.com/classes/Console.html#attribute_style"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "The identity of the widget.",
     "!url": "http://yuilibrary.com/classes/Console.html#property_NAME"
    },
    "LOG_LEVEL_INFO": {
     "!type": "string",
     "!doc": "Static identifier for logLevel configuration setting to allow all\nincoming messages to generate Console entries.",
     "!url": "http://yuilibrary.com/classes/Console.html#property_LOG_LEVEL_INFO"
    },
    "LOG_LEVEL_WARN": {
     "!type": "string",
     "!doc": "Static identifier for logLevel configuration setting to allow only\nincoming messages of logLevel &quot;warn&quot; or &quot;error&quot;\nto generate Console entries.",
     "!url": "http://yuilibrary.com/classes/Console.html#property_LOG_LEVEL_WARN"
    },
    "LOG_LEVEL_ERROR": {
     "!type": "string",
     "!doc": "Static identifier for logLevel configuration setting to allow only\nincoming messages of logLevel &quot;error&quot; to generate\nConsole entries.",
     "!url": "http://yuilibrary.com/classes/Console.html#property_LOG_LEVEL_ERROR"
    },
    "ENTRY_CLASSES": {
     "!type": "+yui.Object",
     "!doc": "Map (object) of classNames used to populate the placeholders in the\nConsole.ENTRY_TEMPLATE markup when rendering a new Console entry.\n\n<p>By default, the keys contained in the object are:</p>\n<ul>\n   <li>entry_class</li>\n   <li>entry_meta_class</li>\n   <li>entry_cat_class</li>\n   <li>entry_src_class</li>\n   <li>entry_time_class</li>\n   <li>entry_content_class</li>\n</ul>",
     "!url": "http://yuilibrary.com/classes/Console.html#property_ENTRY_CLASSES"
    },
    "CHROME_CLASSES": {
     "!type": "+yui.Object",
     "!doc": "Map (object) of classNames used to populate the placeholders in the\nConsole.HEADER_TEMPLATE, Console.BODY_TEMPLATE, and\nConsole.FOOTER_TEMPLATE markup when rendering the Console UI.\n\n<p>By default, the keys contained in the object are:</p>\n<ul>\n  <li>console_hd_class</li>\n  <li>console_bd_class</li>\n  <li>console_ft_class</li>\n  <li>console_controls_class</li>\n  <li>console_checkbox_class</li>\n  <li>console_pause_class</li>\n  <li>console_pause_label_class</li>\n  <li>console_button_class</li>\n  <li>console_clear_class</li>\n  <li>console_collapse_class</li>\n  <li>console_title_class</li>\n</ul>",
     "!url": "http://yuilibrary.com/classes/Console.html#property_CHROME_CLASSES"
    },
    "HEADER_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to generate the DOM structure for the header\nsection of the Console when it is rendered.  The template includes\nthese {placeholder}s:\n\n<ul>\n  <li>console_button_class - contributed by Console.CHROME_CLASSES</li>\n  <li>console_collapse_class - contributed by Console.CHROME_CLASSES</li>\n  <li>console_hd_class - contributed by Console.CHROME_CLASSES</li>\n  <li>console_title_class - contributed by Console.CHROME_CLASSES</li>\n  <li>str_collapse - pulled from attribute strings.collapse</li>\n  <li>str_title - pulled from attribute strings.title</li>\n</ul>",
     "!url": "http://yuilibrary.com/classes/Console.html#property_HEADER_TEMPLATE"
    },
    "BODY_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to generate the DOM structure for the Console body\n(where the messages are inserted) when it is rendered.  The template\nincludes only the {placeholder} &quot;console_bd_class&quot;, which is\nconstributed by Console.CHROME_CLASSES.",
     "!url": "http://yuilibrary.com/classes/Console.html#property_BODY_TEMPLATE"
    },
    "FOOTER_TEMPLATE": {
     "!type": "string",
     "!doc": "Markup template used to generate the DOM structure for the footer\nsection of the Console when it is rendered.  The template includes\nmany of the {placeholder}s from Console.CHROME_CLASSES as well as:\n\n<ul>\n  <li>id_guid - generated unique id, relates the label and checkbox</li>\n  <li>str_pause - pulled from attribute strings.pause</li>\n  <li>str_clear - pulled from attribute strings.clear</li>\n</ul>",
     "!url": "http://yuilibrary.com/classes/Console.html#property_FOOTER_TEMPLATE"
    },
    "ENTRY_TEMPLATE": {
     "!type": "string",
     "!doc": "Default markup template used to create the DOM structure for Console\nentries. The markup contains {placeholder}s for content and classes\nthat are replaced via Y.Lang.sub.  The default template contains\nthe {placeholder}s identified in Console.ENTRY_CLASSES as well as the\nfollowing placeholders that will be populated by the log entry data:\n\n<ul>\n  <li>cat_class</li>\n  <li>src_class</li>\n  <li>totalTime</li>\n  <li>elapsedTime</li>\n  <li>localTime</li>\n  <li>sourceAndDetail</li>\n  <li>message</li>\n</ul>",
     "!url": "http://yuilibrary.com/classes/Console.html#property_ENTRY_TEMPLATE"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute configuration of\nthe Widget.",
     "!url": "http://yuilibrary.com/classes/Console.html#property_ATTRS"
    }
   }
  },
  "cookie": {
   "Cookie": {
    "!type": "fn()",
    "!doc": "Cookie utility.",
    "!url": "http://yuilibrary.com/classes/Cookie.html",
    "exists": {
     "!type": "fn(name: string) -> bool",
     "!doc": "Determines if the cookie with the given name exists. This is useful for\nBoolean cookies (those that do not follow the name=value convention).",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_exists"
    },
    "get": {
     "!type": "fn(name: string, options: fn()) -> +Any",
     "!doc": "Returns the cookie value for the given name.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_get"
    },
    "getSub": {
     "!type": "fn(name: string, subName: string, converter: fn(), options: yui.Object) -> +Any",
     "!doc": "Returns the value of a subcookie.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_getSub"
    },
    "getSubs": {
     "!type": "fn(name: string, options: yui.Object) -> +yui.Object",
     "!doc": "Returns an object containing name-value pairs stored in the cookie with the given name.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_getSubs"
    },
    "remove": {
     "!type": "fn(name: string, options: yui.Object) -> string",
     "!doc": "Removes a cookie from the machine by setting its expiration date to\nsometime in the past.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_remove"
    },
    "removeSub": {
     "!type": "fn(name: string, subName: string, options: yui.Object) -> string",
     "!doc": "Removes a sub cookie with a given name.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_removeSub"
    },
    "set": {
     "!type": "fn(name: string, value: Any, options: yui.Object) -> string",
     "!doc": "Sets a cookie with a given name and value.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_set"
    },
    "setSub": {
     "!type": "fn(name: string, subName: string, value: Any, options: yui.Object) -> string",
     "!doc": "Sets a sub cookie with a given name to a particular value.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_setSub"
    },
    "setSubs": {
     "!type": "fn(name: string, value: yui.Object, options: yui.Object) -> string",
     "!doc": "Sets a cookie with a given name to contain a hash of name-value pairs.",
     "!url": "http://yuilibrary.com/classes/Cookie.html#method_setSubs"
    }
   }
  },
  "dataschema": {
   "DataSchema.Array": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with data\nstored in arrays.\n\nSee the `apply` method below for usage.",
    "!url": "http://yuilibrary.com/classes/DataSchema.Array.html",
    "apply": {
     "!type": "fn(schema?: yui.Object, data: yui.Array) -> +yui.Object",
     "!doc": "Applies a schema to an array of data, returning a normalized object\nwith results in the `results` property. The `meta` property of the\nresponse object is present for consistency, but is assigned an empty\nobject.  If the input data is absent or not an array, an `error`\nproperty will be added.\n\nThe input array is expected to contain objects, arrays, or strings.\n\nIf _schema_ is not specified or _schema.resultFields_ is not an array,\n`response.results` will be assigned the input array unchanged.\n\nWhen a _schema_ is specified, the following will occur:\n\nIf the input array contains strings, they will be copied as-is into the\n`response.results` array.\n\nIf the input array contains arrays, `response.results` will contain an\narray of objects with key:value pairs assuming the fields in\n_schema.resultFields_ are ordered in accordance with the data array\nvalues.\n\nIf the input array contains objects, the identified\n_schema.resultFields_ will be used to extract a value from those\nobjects for the output result.\n\n_schema.resultFields_ field identifiers are objects with the following properties:\n\n  * `key`   : <strong>(required)</strong> The locator name (String)\n  * `parser`: A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n\nIf no value parsing is needed, you can use strings as identifiers\ninstead of objects (see example below).",
     "!url": "http://yuilibrary.com/classes/DataSchema.Array.html#method_apply"
    }
   },
   "DataSchema.Base": {
    "!type": "fn()",
    "!doc": "Base class for the YUI DataSchema Utility.",
    "!url": "http://yuilibrary.com/classes/DataSchema.Base.html",
    "apply": {
     "!type": "fn(schema: yui.Object, data: yui.Object) -> +yui.Object",
     "!doc": "Overridable method returns data as-is.",
     "!url": "http://yuilibrary.com/classes/DataSchema.Base.html#method_apply"
    },
    "prototype": {
     "parse": {
      "!type": "fn(value: yui.Object, field: yui.Object) -> +yui.Object",
      "!doc": "Applies field parser, if defined",
      "!url": "http://yuilibrary.com/classes/DataSchema.Base.html#method_parse"
     }
    }
   },
   "DataSchema.JSON": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with JSON data.\n\nSee the `apply` method for usage.",
    "!url": "http://yuilibrary.com/classes/DataSchema.JSON.html",
    "getPath": {
     "!type": "fn(locator: string) -> [string]",
     "!doc": "Utility function converts JSON locator strings into walkable paths",
     "!url": "http://yuilibrary.com/classes/DataSchema.JSON.html#method_getPath"
    },
    "getLocationValue": {
     "!type": "fn(path: [string], data: string) -> +yui.Object",
     "!doc": "Utility function to walk a path and return the value located there.",
     "!url": "http://yuilibrary.com/classes/DataSchema.JSON.html#method_getLocationValue"
    },
    "apply": {
     "!type": "fn(schema?: yui.Object, data: yui.Object) -> +yui.Object",
     "!doc": "Applies a schema to an array of data located in a JSON structure, returning\na normalized object with results in the `results` property. Additional\ninformation can be parsed out of the JSON for inclusion in the `meta`\nproperty of the response object.  If an error is encountered during\nprocessing, an `error` property will be added.\n\nThe input _data_ is expected to be an object or array.  If it is a string,\nit will be passed through `Y.JSON.parse()`.\n\nIf _data_ contains an array of data records to normalize, specify the\n_schema.resultListLocator_ as a dot separated path string just as you would\nreference it in JavaScript.  So if your _data_ object has a record array at\n_data.response.results_, use _schema.resultListLocator_ =\n\"response.results\". Bracket notation can also be used for array indices or\nobject properties (e.g. \"response['results']\");  This is called a \"path\nlocator\"\n\nField data in the result list is extracted with field identifiers in\n_schema.resultFields_.  Field identifiers are objects with the following\nproperties:\n\n  * `key`   : <strong>(required)</strong> The path locator (String)\n  * `parser`: A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n\nIf no value parsing is needed, you can use path locators (strings)\ninstead of field identifiers (objects) -- see example below.\n\nIf no processing of the result list array is needed, _schema.resultFields_\ncan be omitted; the `response.results` will point directly to the array.\n\nIf the result list contains arrays, `response.results` will contain an\narray of objects with key:value pairs assuming the fields in\n_schema.resultFields_ are ordered in accordance with the data array\nvalues.\n\nIf the result list contains objects, the identified _schema.resultFields_\nwill be used to extract a value from those objects for the output result.\n\nTo extract additional information from the JSON, include an array of\npath locators in _schema.metaFields_.  The collected values will be\nstored in `response.meta`.",
     "!url": "http://yuilibrary.com/classes/DataSchema.JSON.html#method_apply"
    }
   },
   "DataSchema.Text": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with\ndelimited text data.\n\nSee the `apply` method for usage.",
    "!url": "http://yuilibrary.com/classes/DataSchema.Text.html",
    "apply": {
     "!type": "fn(schema: yui.Object, data: string) -> +yui.Object",
     "!doc": "Applies a schema to a string of delimited data, returning a normalized\nobject with results in the `results` property. The `meta` property of\nthe response object is present for consistency, but is assigned an\nempty object.  If the input data is absent or not a string, an `error`\nproperty will be added.\n\nUse _schema.resultDelimiter_ and _schema.fieldDelimiter_ to instruct\n`apply` how to split up the string into an array of data arrays for\nprocessing.\n\nUse _schema.resultFields_ to specify the keys in the generated result\nobjects in `response.results`. The key:value pairs will be assigned\nin the order of the _schema.resultFields_ array, assuming the values\nin the data records are defined in the same order.\n\n_schema.resultFields_ field identifiers are objects with the following\nproperties:\n\n  * `key`   : <strong>(required)</strong> The property name you want\n        the data value assigned to in the result object (String)\n  * `parser`: A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n\nIf no value parsing is needed, you can use just the desired property\nname string as the field identifier instead of an object (see example\nbelow).",
     "!url": "http://yuilibrary.com/classes/DataSchema.Text.html#method_apply"
    }
   },
   "DataSchema.XML": {
    "!type": "fn()",
    "!proto": "dataschema.DataSchema.Base",
    "!doc": "Provides a DataSchema implementation which can be used to work with XML data.\n\nSee the `apply` method for usage.",
    "!url": "http://yuilibrary.com/classes/DataSchema.XML.html",
    "apply": {
     "!type": "fn(schema: yui.Object, data: XMLDocument) -> +yui.Object",
     "!doc": "Applies a schema to an XML data tree, returning a normalized object with\nresults in the `results` property. Additional information can be parsed out\nof the XML for inclusion in the `meta` property of the response object.  If\nan error is encountered during processing, an `error` property will be\nadded.\n\nField data in the nodes captured by the XPath in _schema.resultListLocator_\nis extracted with the field identifiers described in _schema.resultFields_.\nField identifiers are objects with the following properties:\n\n  * `key`    : <strong>(required)</strong> The desired property name to use\n        store the retrieved value in the result object.  If `locator` is\n        not specified, `key` is also used as the XPath locator (String)\n  * `locator`: The XPath locator to the node or attribute within each\n        result node found by _schema.resultListLocator_ containing the\n        desired field data (String)\n  * `parser` : A function or the name of a function on `Y.Parsers` used\n        to convert the input value into a normalized type.  Parser\n        functions are passed the value as input and are expected to\n        return a value.\n  * `schema` : Used to retrieve nested field data into an array for\n        assignment as the result field value.  This object follows the same\n        conventions as _schema_.\n\nIf no value parsing or nested parsing is needed, you can use XPath locators\n(strings) instead of field identifiers (objects) -- see example below.\n\n`response.results` will contain an array of objects with key:value pairs.\nThe keys are the field identifier `key`s, and the values are the data\nvalues extracted from the nodes or attributes found by the field `locator`\n(or `key` fallback).\n\nTo extract additional information from the XML, include an array of\nXPath locators in _schema.metaFields_.  The collected values will be\nstored in `response.meta` with the XPath locator as keys.",
     "!url": "http://yuilibrary.com/classes/DataSchema.XML.html#method_apply"
    }
   }
  },
  "datasource": {
   "DataSourceArraySchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSourceArraySchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/DataSourceArraySchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSourceArraySchema.html#property_NAME"
    }
   },
   "DataSourceCacheExtension": {
    "!type": "fn()",
    "!doc": "DataSourceCache extension binds Cache to DataSource.",
    "!url": "http://yuilibrary.com/classes/DataSourceCacheExtension.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/DataSourceCacheExtension.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSourceCacheExtension.html#property_NAME"
    }
   },
   "DataSourceCache": {
    "!type": "fn()",
    "!proto": "cache.Cache",
    "!doc": "DataSource plugin adds cache functionality.",
    "!url": "http://yuilibrary.com/classes/DataSourceCache.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/DataSourceCache.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSourceCache.html#property_NAME"
    }
   },
   "DataSource.Function": {
    "!type": "fn() -> +datasource.DataSource.Function",
    "!proto": "datasource.DataSource.Local",
    "!doc": "Function subclass for the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSource.Function.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSource.Function.html#property_NAME"
    },
    "prototype": {
     "source": {
      "!type": "fn()",
      "!doc": "Stores the function that will serve the response data.",
      "!url": "http://yuilibrary.com/classes/DataSource.Function.html#attribute_source"
     }
    }
   },
   "DataSource.Get": {
    "!type": "fn() -> +datasource.DataSource.Get",
    "!proto": "datasource.DataSource.Local",
    "!doc": "Get Utility subclass for the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSource.Get.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSource.Get.html#property_NAME"
    },
    "prototype": {
     "get": {
      "!type": "fn()",
      "!doc": "Pointer to Get Utility.",
      "!url": "http://yuilibrary.com/classes/DataSource.Get.html#attribute_get"
     },
     "asyncMode": {
      "!type": "fn()",
      "!doc": "Defines request/response management in the following manner:\n<dl>\n    <!--<dt>queueRequests</dt>\n    <dd>If a request is already in progress, wait until response is\n    returned before sending the next request.</dd>\n    <dt>cancelStaleRequests</dt>\n    <dd>If a request is already in progress, cancel it before\n    sending the next request.</dd>-->\n    <dt>ignoreStaleResponses</dt>\n    <dd>Send all requests, but handle only the response for the most\n    recently sent request.</dd>\n    <dt>allowAll</dt>\n    <dd>Send all requests and handle all responses.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/DataSource.Get.html#attribute_asyncMode"
     },
     "scriptCallbackParam": {
      "!type": "fn()",
      "!doc": "Callback string parameter name sent to the remote script. By default,\nrequests are sent to\n&#60;URI&#62;?&#60;scriptCallbackParam&#62;=callbackFunction",
      "!url": "http://yuilibrary.com/classes/DataSource.Get.html#attribute_scriptCallbackParam"
     },
     "generateRequestCallback": {
      "!type": "fn()",
      "!doc": "Accepts the DataSource instance and a callback ID, and returns a callback\nparam/value string that gets appended to the script URI. Implementers\ncan customize this string to match their server's query syntax.",
      "!url": "http://yuilibrary.com/classes/DataSource.Get.html#attribute_generateRequestCallback"
     }
    }
   },
   "DataSource.IO": {
    "!type": "fn() -> +datasource.DataSource.IO",
    "!proto": "datasource.DataSource.Local",
    "!doc": "IO subclass for the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSource.IO.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSource.IO.html#property_NAME"
    },
    "prototype": {
     "io": {
      "!type": "fn()",
      "!doc": "Pointer to IO Utility.",
      "!url": "http://yuilibrary.com/classes/DataSource.IO.html#attribute_io"
     },
     "ioConfig": {
      "!type": "fn()",
      "!doc": "Default IO Config.",
      "!url": "http://yuilibrary.com/classes/DataSource.IO.html#attribute_ioConfig"
     }
    }
   },
   "DataSourceJSONSchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSourceJSONSchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/DataSourceJSONSchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSourceJSONSchema.html#property_NAME"
    }
   },
   "DataSource.Local": {
    "!type": "fn() -> +datasource.DataSource.Local",
    "!proto": "base.Base",
    "!doc": "Base class for the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSource.Local.html",
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSource.Local.html#property_NAME"
    },
    "prototype": {
     "source": {
      "!type": "fn()",
      "!doc": "Pointer to live data.",
      "!url": "http://yuilibrary.com/classes/DataSource.Local.html#attribute_source"
     },
     "request": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when a data request is received.",
      "!url": "http://yuilibrary.com/classes/DataSource.Local.html#event_request"
     },
     "data": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when raw data is received.",
      "!url": "http://yuilibrary.com/classes/DataSource.Local.html#event_data"
     },
     "response": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when response is returned.",
      "!url": "http://yuilibrary.com/classes/DataSource.Local.html#event_response"
     },
     "error": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when an error is encountered.",
      "!url": "http://yuilibrary.com/classes/DataSource.Local.html#event_error"
     },
     "sendRequest": {
      "!type": "fn(request?: yui.Object) -> number",
      "!doc": "Generates a unique transaction ID and fires <code>request</code> event.\n<strong>Note</strong>: the property <code>callback</code> is a\ndeprecated alias for the <code>on</code> transaction configuration\nproperty described below.",
      "!url": "http://yuilibrary.com/classes/DataSource.Local.html#method_sendRequest"
     }
    },
    "transactions": {
     "!type": "+yui.Object",
     "!doc": "Global in-progress transaction objects.",
     "!url": "http://yuilibrary.com/classes/DataSource.Local.html#property_transactions"
    },
    "issueCallback": {
     "!type": "fn(e: event_custom.EventFacade, caller: DataSource)",
     "!doc": "Returns data to callback.",
     "!url": "http://yuilibrary.com/classes/DataSource.Local.html#method_issueCallback"
    }
   },
   "Pollable": {
    "!type": "fn()",
    "!proto": "datasource.DataSource.Local",
    "!doc": "Adds polling to the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/Pollable.html",
    "prototype": {
     "setInterval": {
      "!type": "fn(msec: number, request?: yui.Object) -> number",
      "!doc": "Sets up a polling mechanism to send requests at set intervals and\nforward responses to given callback.",
      "!url": "http://yuilibrary.com/classes/Pollable.html#method_setInterval"
     },
     "clearInterval": {
      "!type": "fn(id: number)",
      "!doc": "Disables polling mechanism associated with the given interval ID.",
      "!url": "http://yuilibrary.com/classes/Pollable.html#method_clearInterval"
     },
     "clearAllIntervals": {
      "!type": "fn()",
      "!doc": "Clears all intervals.",
      "!url": "http://yuilibrary.com/classes/Pollable.html#method_clearAllIntervals"
     }
    }
   },
   "DataSourceTextSchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSourceTextSchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/DataSourceTextSchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSourceTextSchema.html#property_NAME"
    }
   },
   "DataSourceXMLSchema": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds schema-parsing to the DataSource Utility.",
    "!url": "http://yuilibrary.com/classes/DataSourceXMLSchema.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/DataSourceXMLSchema.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/DataSourceXMLSchema.html#property_NAME"
    }
   }
  },
  "datatable": {
   "DataTable.Base": {
    "!type": "fn()",
    "!proto": "widget.Widget",
    "!doc": "The baseline implementation of a DataTable.  This class should be used\nprimarily as a superclass for a custom DataTable with a specific set of\nfeatures.  Because features can be composed onto `Y.DataTable`, custom\nsubclasses of DataTable.Base will remain unmodified when new feature modules\nare loaded.\n\nExample usage might look like this:\n\n<pre><code>\n// Custom subclass with only sorting and mutability added.  If other datatable\n// feature modules are loaded, this class will not be affected.\nvar MyTableClass = Y.Base.create('table', Y.DataTable.Base,\n                       [ Y.DataTable.Sortable, Y.DataTable.Mutable ]);\n\nvar table = new MyTableClass({\n    columns: ['firstName', 'lastName', 'age'],\n    data: [\n        { firstName: 'Frank', lastName: 'Zappa', age: 71 },\n        { firstName: 'Frank', lastName: 'Lloyd Wright', age: 144 },\n        { firstName: 'Albert', lastName: 'Einstein', age: 132 },\n        ...\n    ]\n});\n\ntable.render('#over-there');\n\n// DataTable.Base can be instantiated if a featureless table is needed.\nvar table = new Y.DataTable.Base({\n    columns: ['firstName', 'lastName', 'age'],\n    data: [\n        { firstName: 'Frank', lastName: 'Zappa', age: 71 },\n        { firstName: 'Frank', lastName: 'Lloyd Wright', age: 144 },\n        { firstName: 'Albert', lastName: 'Einstein', age: 132 },\n        ...\n    ]\n});\n\ntable.render('#in-here');\n</code></pre>\n\nDataTable.Base is built from DataTable.Core, and sets the default `view`\nto `Y.DataTable.TableView`.",
    "!url": "http://yuilibrary.com/classes/DataTable.Base.html",
    "prototype": {
     "delegate": {
      "!type": "fn(type: string, fn: fn(), spec: string, context: yui.Object, args: Any) -> +event_custom.EventHandle",
      "!doc": "Pass through to `delegate()` called from the `contentBox`.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#method_delegate"
     },
     "getCell": {
      "!type": "fn(seed: [number], shift?: [number]) -> +node.Node",
      "!doc": "Returns the `<td>` Node from the given row and column index.  Alternately,\nthe `seed` can be a Node.  If so, the nearest ancestor cell is returned.\nIf the `seed` is a cell, it is returned.  If there is no cell at the given\ncoordinates, `null` is returned.\n\nOptionally, include an offset array or string to return a cell near the\ncell identified by the `seed`.  The offset can be an array containing the\nnumber of rows to shift followed by the number of columns to shift, or one\nof \"above\", \"below\", \"next\", or \"previous\".\n\n<pre><code>// Previous cell in the previous row\nvar cell = table.getCell(e.target, [-1, -1]);\n\n// Next cell\nvar cell = table.getCell(e.target, 'next');\nvar cell = table.getCell(e.taregt, [0, 1];</pre></code>\n\nThis is actually just a pass through to the `view` instance's method\nby the same name.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#method_getCell"
     },
     "getRow": {
      "!type": "fn(id: number) -> +node.Node",
      "!doc": "Returns the `<tr>` Node from the given row index, Model, or Model's\n`clientId`.  If the rows haven't been rendered yet, or if the row can't be\nfound by the input, `null` is returned.\n\nThis is actually just a pass through to the `view` instance's method\nby the same name.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#method_getRow"
     },
     "_displayColumns": {
      "!type": "[+yui.Object]",
      "!doc": "Array of the columns that correspond to those with value cells in the\ndata rows. Excludes colspan header columns (configured with `children`).",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#property__displayColumns"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Fires the `renderView` event, delegating UI updates to the configured View.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#method_syncUI"
     },
     "view": {
      "!type": "fn()",
      "!doc": "The View class used to render the `<table>` into the Widget's\n`contentBox`.  This View can handle the entire table rendering itself\nor delegate to other Views.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.\n\nWhen the DataTable is rendered, an instance of this View will be\ncreated and its `render()` method called.  The View instance will be\nassigned to the DataTable instance's `view` property.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#attribute_view"
     },
     "headerView": {
      "!type": "fn()",
      "!doc": "If the View class assigned to the DataTable's `view` attribute supports\nit, this class will be used for rendering the contents of the\n`<thead>`&mdash;the column headers for the table.\n\nSimilar to `view`, the instance of this View will be assigned to the\nDataTable instance's `head` property.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#attribute_headerView"
     },
     "footerView": {
      "!type": "fn()",
      "!doc": "If the View class assigned to the DataTable's `view` attribute supports\nit, this class will be used for rendering the contents of the `<tfoot>`.\n\nSimilar to `view`, the instance of this View will be assigned to the\nDataTable instance's `foot` property.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#attribute_footerView"
     },
     "bodyView": {
      "!type": "fn()",
      "!doc": "If the View class assigned to the DataTable's `view` attribute supports\nit, this class will be used for rendering the contents of the `<tbody>`\nincluding all data rows.\n\nSimilar to `view`, the instance of this View will be assigned to the\nDataTable instance's `body` property.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.Base.html#attribute_bodyView"
     }
    }
   },
   "DataTable.BodyView": {
    "!type": "fn()",
    "!proto": "app.View",
    "!doc": "View class responsible for rendering the `<tbody>` section of a table. Used as\nthe default `bodyView` for `Y.DataTable.Base` and `Y.DataTable` classes.\n\nTranslates the provided `modelList` into a rendered `<tbody>` based on the data\nin the constituent Models, altered or amended by any special column\nconfigurations.\n\nThe `columns` configuration, passed to the constructor, determines which\ncolumns will be rendered.\n\nThe rendering process involves constructing an HTML template for a complete row\nof data, built by concatenating a customized copy of the instance's\n`CELL_TEMPLATE` into the `ROW_TEMPLATE` once for each column.  This template is\nthen populated with values from each Model in the `modelList`, aggregating a\ncomplete HTML string of all row and column data.  A `<tbody>` Node is then created from the markup and any column `nodeFormatter`s are applied.\n\nSupported properties of the column objects include:\n\n  * `key` - Used to link a column to an attribute in a Model.\n  * `name` - Used for columns that don't relate to an attribute in the Model\n    (`formatter` or `nodeFormatter` only) if the implementer wants a\n    predictable name to refer to in their CSS.\n  * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in this\n    column only.\n  * `formatter` - Used to customize or override the content value from the\n    Model.  These do not have access to the cell or row Nodes and should\n    return string (HTML) content.\n  * `nodeFormatter` - Used to provide content for a cell as well as perform any\n    custom modifications on the cell or row Node that could not be performed by\n    `formatter`s.  Should be used sparingly for better performance.\n  * `emptyCellValue` - String (HTML) value to use if the Model data for a\n    column, or the content generated by a `formatter`, is the empty string,\n    `null`, or `undefined`.\n  * `allowHTML` - Set to `true` if a column value, `formatter`, or\n    `emptyCellValue` can contain HTML.  This defaults to `false` to protect\n    against XSS.\n  * `className` - Space delimited CSS classes to add to all `<td>`s in a column.\n\nA column `formatter` can be:\n\n  * a function, as described below.\n  * a string which can be:\n      * the name of a pre-defined formatter function\n        which can be located in the `Y.DataTable.BodyView.Formatters` hash using the\n        value of the `formatter` property as the index.\n      * A template that can use the `{value}` placeholder to include the value\n        for the current cell or the name of any field in the underlaying model\n        also enclosed in curly braces.  Any number and type of these placeholders\n        can be used.\n\nColumn `formatter`s are passed an object (`o`) with the following properties:\n\n  * `value` - The current value of the column's associated attribute, if any.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `className` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's `<td>`.\n  * `rowIndex` - The zero-based row number.\n  * `rowClass` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's containing row `<tr>`.\n\nThey may return a value or update `o.value` to assign specific HTML content.  A\nreturned value has higher precedence.\n\nColumn `nodeFormatter`s are passed an object (`o`) with the following\nproperties:\n\n  * `value` - The current value of the column's associated attribute, if any.\n  * `td` - The `<td>` Node instance.\n  * `cell` - The `<div>` liner Node instance if present, otherwise, the `<td>`.\n    When adding content to the cell, prefer appending into this property.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `rowIndex` - The zero-based row number.\n\nThey are expected to inject content into the cell's Node directly, including\nany \"empty\" cell content.  Each `nodeFormatter` will have access through the\nNode API to all cells and rows in the `<tbody>`, but not to the `<table>`, as\nit will not be attached yet.\n\nIf a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be\n`destroy()`ed to remove them from the Node cache and free up memory.  The DOM\nelements will remain as will any content added to them.  _It is highly\nadvisable to always return `false` from your `nodeFormatter`s_.",
    "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html",
    "prototype": {
     "CELL_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML template used to create table cells.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_CELL_TEMPLATE"
     },
     "CLASS_EVEN": {
      "!type": "string",
      "!doc": "CSS class applied to even rows.  This is assigned at instantiation.\n\nFor DataTable, this will be `yui3-datatable-even`.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_CLASS_EVEN"
     },
     "CLASS_ODD": {
      "!type": "string",
      "!doc": "CSS class applied to odd rows.  This is assigned at instantiation.\n\nWhen used by DataTable instances, this will be `yui3-datatable-odd`.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_CLASS_ODD"
     },
     "ROW_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML template used to create table rows.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_ROW_TEMPLATE"
     },
     "host": {
      "!type": "+yui.Object",
      "!doc": "The object that serves as the source of truth for column and row data.\nThis property is assigned at instantiation from the `host` property of\nthe configuration object passed to the constructor.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_host"
     },
     "TBODY_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML templates used to create the `<tbody>` containing the table rows.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_TBODY_TEMPLATE"
     },
     "getCell": {
      "!type": "fn(seed: [number], shift?: [number]) -> +node.Node",
      "!doc": "Returns the `<td>` Node from the given row and column index.  Alternately,\nthe `seed` can be a Node.  If so, the nearest ancestor cell is returned.\nIf the `seed` is a cell, it is returned.  If there is no cell at the given\ncoordinates, `null` is returned.\n\nOptionally, include an offset array or string to return a cell near the\ncell identified by the `seed`.  The offset can be an array containing the\nnumber of rows to shift followed by the number of columns to shift, or one\nof \"above\", \"below\", \"next\", or \"previous\".\n\n<pre><code>// Previous cell in the previous row\nvar cell = table.getCell(e.target, [-1, -1]);\n\n// Next cell\nvar cell = table.getCell(e.target, 'next');\nvar cell = table.getCell(e.target, [0, 1];</pre></code>",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_getCell"
     },
     "getRecord": {
      "!type": "fn(seed: string) -> +app.Model",
      "!doc": "Returns the Model associated to the row Node or id provided. Passing the\nNode or id for a descendant of the row also works.\n\nIf no Model can be found, `null` is returned.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_getRecord"
     },
     "getRow": {
      "!type": "fn(id: number) -> +node.Node",
      "!doc": "Returns the `<tr>` Node from the given row index, Model, or Model's\n`clientId`.  If the rows haven't been rendered yet, or if the row can't be\nfound by the input, `null` is returned.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_getRow"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the table's `<tbody>` content by assembling markup generated by\npopulating the `ROW\\_TEMPLATE`, and `CELL\\_TEMPLATE` templates with content\nfrom the `columns` and `modelList` attributes.\n\nThe rendering process happens in three stages:\n\n1. A row template is assembled from the `columns` attribute (see\n   `_createRowTemplate`)\n\n2. An HTML string is built up by concatenating the application of the data in\n   each Model in the `modelList` to the row template. For cells with\n   `formatter`s, the function is called to generate cell content. Cells\n   with `nodeFormatter`s are ignored. For all other cells, the data value\n   from the Model attribute for the given column key is used.  The\n   accumulated row markup is then inserted into the container.\n\n3. If any column is configured with a `nodeFormatter`, the `modelList` is\n   iterated again to apply the `nodeFormatter`s.\n\nSupported properties of the column objects include:\n\n  * `key` - Used to link a column to an attribute in a Model.\n  * `name` - Used for columns that don't relate to an attribute in the Model\n    (`formatter` or `nodeFormatter` only) if the implementer wants a\n    predictable name to refer to in their CSS.\n  * `cellTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in\n    this column only.\n  * `formatter` - Used to customize or override the content value from the\n    Model.  These do not have access to the cell or row Nodes and should\n    return string (HTML) content.\n  * `nodeFormatter` - Used to provide content for a cell as well as perform\n    any custom modifications on the cell or row Node that could not be\n    performed by `formatter`s.  Should be used sparingly for better\n    performance.\n  * `emptyCellValue` - String (HTML) value to use if the Model data for a\n    column, or the content generated by a `formatter`, is the empty string,\n    `null`, or `undefined`.\n  * `allowHTML` - Set to `true` if a column value, `formatter`, or\n    `emptyCellValue` can contain HTML.  This defaults to `false` to protect\n    against XSS.\n  * `className` - Space delimited CSS classes to add to all `<td>`s in a\n    column.\n\nColumn `formatter`s are passed an object (`o`) with the following\nproperties:\n\n  * `value` - The current value of the column's associated attribute, if\n    any.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `className` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's `<td>`.\n  * `rowIndex` - The zero-based row number.\n  * `rowClass` - Initially empty string to allow `formatter`s to add CSS\n    classes to the cell's containing row `<tr>`.\n\nThey may return a value or update `o.value` to assign specific HTML\ncontent.  A returned value has higher precedence.\n\nColumn `nodeFormatter`s are passed an object (`o`) with the following\nproperties:\n\n  * `value` - The current value of the column's associated attribute, if\n    any.\n  * `td` - The `<td>` Node instance.\n  * `cell` - The `<div>` liner Node instance if present, otherwise, the\n    `<td>`.  When adding content to the cell, prefer appending into this\n    property.\n  * `data` - An object map of Model keys to their current values.\n  * `record` - The Model instance.\n  * `column` - The column configuration object for the current column.\n  * `rowIndex` - The zero-based row number.\n\nThey are expected to inject content into the cell's Node directly, including\nany \"empty\" cell content.  Each `nodeFormatter` will have access through the\nNode API to all cells and rows in the `<tbody>`, but not to the `<table>`,\nas it will not be attached yet.\n\nIf a `nodeFormatter` returns `false`, the `o.td` and `o.cell` Nodes will be\n`destroy()`ed to remove them from the Node cache and free up memory.  The\nDOM elements will remain as will any content added to them.  _It is highly\nadvisable to always return `false` from your `nodeFormatter`s_.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_render"
     },
     "refreshRow": {
      "!type": "fn(row: node.Node, model: app.Model, colKeys: [string]) -> !this",
      "!doc": "Refreshes the provided row against the provided model and the Array of\ncolumns to be updated.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_refreshRow"
     },
     "refreshCell": {
      "!type": "fn(cell: node.Node, model?: app.Model, col?: yui.Object) -> !this",
      "!doc": "Refreshes the given cell with the provided model data and the provided\ncolumn configuration.\n\nUses the provided column formatter if aviable.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_refreshCell"
     },
     "getColumn": {
      "!type": "fn(name: string) -> +yui.Object",
      "!doc": "Returns column data from this.get('columns'). If a Y.Node is provided as\nthe key, will try to determine the key from the classname",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#method_getColumn"
     },
     "undefined": {
      "!type": "fn(row: node.Node) -> number",
      "!doc": "Locates the row within the tbodyNode and returns the found index, or Null\nif it is not found in the tbodyNode",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html"
     }
    },
    "Formatters": {
     "!type": "+yui.Object",
     "!doc": "Hash of formatting functions for cell contents.\n\nThis property can be populated with a hash of formatting functions by the developer\nor a set of pre-defined functions can be loaded via the `datatable-formatters` module.\n\nSee: [DataTable.BodyView.Formatters](./DataTable.BodyView.Formatters.html)",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.html#property_Formatters"
    }
   },
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://yuilibrary.com/classes/DataTable.html",
    "prototype": {
     "COL_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the table's `<col>`s.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property_COL_TEMPLATE"
     },
     "COLGROUP_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the table's `<colgroup>`.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property_COLGROUP_TEMPLATE"
     },
     "setColumnWidth": {
      "!type": "fn(id: number, width: number) -> !this",
      "!doc": "Assigns the style width of the `<col>` representing the column identifed by\n`id` and updates the column configuration.\n\nPass the empty string for `width` to return a column to auto sizing.\n\nThis does not trigger a `columnsChange` event today, but I can be convinced\nthat it should.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_setColumnWidth"
     },
     "columns": {
      "!type": "fn()",
      "!doc": "Columns to include in the rendered table.\n\nIf omitted, the attributes on the configured `recordType` or the first item\nin the `data` collection will be used as a source.\n\nThis attribute takes an array of strings or objects (mixing the two is\nfine).  Each string or object is considered a column to be rendered.\nStrings are converted to objects, so `columns: ['first', 'last']` becomes\n`columns: [{ key: 'first' }, { key: 'last' }]`.\n\nDataTable.Core only concerns itself with a few properties of columns.\nThese properties are:\n\n* `key` - Used to identify the record field/attribute containing content for\n  this column.  Also used to create a default Model if no `recordType` or\n  `data` are provided during construction.  If `name` is not specified, this\n  is assigned to the `_id` property (with added incrementer if the key is\n  used by multiple columns).\n* `children` - Traversed to initialize nested column objects\n* `name` - Used in place of, or in addition to, the `key`.  Useful for\n  columns that aren't bound to a field/attribute in the record data.  This\n  is assigned to the `_id` property.\n* `id` - For backward compatibility.  Implementers can specify the id of\n  the header cell.  This should be avoided, if possible, to avoid the\n  potential for creating DOM elements with duplicate IDs.\n* `field` - For backward compatibility.  Implementers should use `name`.\n* `_id` - Assigned unique-within-this-instance id for a column.  By order\n  of preference, assumes the value of `name`, `key`, `id`, or `_yuid`.\n  This is used by the rendering views as well as feature module\n  as a means to identify a specific column without ambiguity (such as\n  multiple columns using the same `key`.\n* `_yuid` - Guid stamp assigned to the column object.\n* `_parent` - Assigned to all child columns, referencing their parent\n  column.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_columns"
     },
     "recordType": {
      "!type": "fn()",
      "!doc": "Model subclass to use as the `model` for the ModelList stored in the `data`\nattribute.\n\nIf not provided, it will try really hard to figure out what to use.  The\nfollowing attempts will be made to set a default value:\n\n1. If the `data` attribute is set with a ModelList instance and its `model`\n   property is set, that will be used.\n2. If the `data` attribute is set with a ModelList instance, and its\n   `model` property is unset, but it is populated, the `ATTRS` of the\n   `constructor of the first item will be used.\n3. If the `data` attribute is set with a non-empty array, a Model subclass\n   will be generated using the keys of the first item as its `ATTRS` (see\n   the `_createRecordClass` method).\n4. If the `columns` attribute is set, a Model subclass will be generated\n   using the columns defined with a `key`. This is least desirable because\n   columns can be duplicated or nested in a way that's not parsable.\n5. If neither `data` nor `columns` is set or populated, a change event\n   subscriber will listen for the first to be changed and try all over\n   again.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_recordType"
     },
     "data": {
      "!type": "+app.ModelList",
      "!doc": "The ModelList that manages the table's data.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property_data"
     },
     "summary": {
      "!type": "fn()",
      "!doc": "Content for the `<table summary=\"ATTRIBUTE VALUE HERE\">`.  Values assigned\nto this attribute will be HTML escaped for security.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_summary"
     },
     "caption": {
      "!type": "fn()",
      "!doc": "HTML content of an optional `<caption>` element to appear above the table.\nLeave this config unset or set to a falsy value to remove the caption.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_caption"
     },
     "recordset": {
      "!type": "fn()",
      "!doc": "Deprecated as of 3.5.0. Passes through to the `data` attribute.\n\nWARNING: `get('recordset')` will NOT return a Recordset instance as of\n3.5.0.  This is a break in backward compatibility.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_recordset"
     },
     "columnset": {
      "!type": "fn()",
      "!doc": "Deprecated as of 3.5.0. Passes through to the `columns` attribute.\n\nWARNING: `get('columnset')` will NOT return a Columnset instance as of\n3.5.0.  This is a break in backward compatibility.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_columnset"
     },
     "getColumn": {
      "!type": "fn(name: string) -> +yui.Object",
      "!doc": "Gets the column configuration object for the given key, name, or index.  For\nnested columns, `name` can be an array of indexes, each identifying the index\nof that column in the respective parent's \"children\" array.\n\nIf you pass a column object, it will be returned.\n\nFor columns with keys, you can also fetch the column with\n`instance.get('columns.foo')`.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_getColumn"
     },
     "getRecord": {
      "!type": "fn(seed: number) -> +app.Model",
      "!doc": "Returns the Model associated to the record `id`, `clientId`, or index (not\nrow index).  If none of those yield a Model from the `data` ModelList, the\narguments will be passed to the `view` instance's `getRecord` method\nif it has one.\n\nIf no Model can be found, `null` is returned.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_getRecord"
     },
     "_getRecordType": {
      "!type": "fn(val: app.Model) -> +app.Model",
      "!doc": "Returns the Model class of the instance's `data` attribute ModelList.  If\nnot set, returns the explicitly configured value.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method__getRecordType"
     },
     "focusedCell": {
      "!type": "fn()",
      "!doc": "Cell that's currently either focused or\nfocusable when the DataTable gets the focus.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_focusedCell"
     },
     "keyIntoHeaders": {
      "!type": "fn()",
      "!doc": "Determines whether it is possible to navigate into the header area.\nThe examples referenced in the document show both behaviors so it seems\nit is optional.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_keyIntoHeaders"
     },
     "keyActions": {
      "!type": "+yui.Object",
      "!doc": "Table of actions to be performed for each key.  It is loaded with a clone\nof [ARIA_ACTIONS](#property_ARIA_ACTIONS) by default.\n\nThe key for each entry is either a key-code or an alias from the\n[KEY_NAMES](#property_KEY_NAMES) table. They can be prefixed with any combination\nof the modifier keys `alt`, `ctrl`, `meta` or `shift` each followed by a hyphen,\nsuch as `\"ctrl-shift-up\"` (modifiers, if more than one, should appear in alphabetical order).\n\nThe value for each entry should be a function or the name of a method in\nthe DataTable instance.  The method will receive the original keyboard\nEventFacade as its only argument.\n\nIf the value is a string and it cannot be resolved into a method,\nit will be assumed to be the name of an event to fire. The listener for that\nevent will receive an EventFacade containing references to the cell that has the focus,\nthe row, column and, unless it is a header row, the record it corresponds to.\nThe second argument will be the original EventFacade for the keyboard event.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property_keyActions"
     },
     "showMessages": {
      "!type": "fn()",
      "!doc": "Enables the display of messages in the table.  Setting this to false will\nprevent the message Node from being created and `showMessage` from doing\nanything.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_showMessages"
     },
     "MESSAGE_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to generate the node that will be used to report messages.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property_MESSAGE_TEMPLATE"
     },
     "hideMessage": {
      "!type": "fn() -> !this",
      "!doc": "Hides the message node.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_hideMessage"
     },
     "showMessage": {
      "!type": "fn(message: string) -> !this",
      "!doc": "Display the message node and set its content to `message`.  If there is a\nlocalized `strings` entry for the value of `message`, that string will be\nused.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_showMessage"
     },
     "_messageNode": {
      "!type": "+node.Node",
      "!doc": "Node used to display messages from `showMessage`.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property__messageNode"
     },
     "autoSync": {
      "!type": "fn()",
      "!doc": "Controls whether `addRow`, `removeRow`, and `modifyRow` should trigger the\nunderlying Model's sync layer by default.\n\nWhen `true`, it is unnecessary to pass the \"sync\" configuration property to\nthose methods to trigger per-operation sync.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_autoSync"
     },
     "addColumn": {
      "!type": "fn(column: yui.Object, index: number)",
      "!doc": "Fired by the `addColumn` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#event_addColumn"
     },
     "modifyColumn": {
      "!type": "fn(column: yui.Object, newColumnDef: yui.Object)",
      "!doc": "Fired by the `modifyColumn` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#event_modifyColumn"
     },
     "moveColumn": {
      "!type": "fn(column: yui.Object, index: yui.Object)",
      "!doc": "Fired by the `moveColumn` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#event_moveColumn"
     },
     "removeColumn": {
      "!type": "fn(column: yui.Object)",
      "!doc": "Fired by the `removeColumn` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#event_removeColumn"
     },
     "addRow": {
      "!type": "fn(data: yui.Object, config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Adds a new record to the DataTable's `data` ModelList.  Record data can be\nan object of field values or an instance of the DataTable's configured\n`recordType` class.\n\nThis relays all parameters to the `data` ModelList's `add` method.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Model will be `save()`d.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to the Model's `save()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_addRow"
     },
     "removeRow": {
      "!type": "fn(id: yui.Object, config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Removes a record from the DataTable's `data` ModelList.  The record can be\nprovided explicitly or targeted by it's `id` (see ModelList's `getById`\nmethod), `clientId`, or index in the ModelList.\n\nAfter locating the target Model, this relays the Model and all other passed\narguments to the `data` ModelList's `remove` method.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Model will be destroyed, passing\n`{ delete: true }` to trigger calling the Model's sync layer.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to the Model's `destroy()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_removeRow"
     },
     "modifyRow": {
      "!type": "fn(id: yui.Object, data: yui.Object, config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Updates an existing record in the DataTable's `data` ModelList.  The record\ncan be provided explicitly or targeted by it's `id` (see ModelList's\n`getById` method), `clientId`, or index in the ModelList.\n\nAfter locating the target Model, this relays the all other passed\narguments to the Model's `setAttrs` method.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Model will be `save()`d.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to the Model's `save()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_modifyRow"
     },
     "addRows": {
      "!type": "fn(data: [yui.Object], config?: yui.Object, callback?: fn()) -> !this",
      "!doc": "Adds an array of new records to the DataTable's `data` ModelList.  Record data\ncan be an array of objects containing field values or an array of instance of\nthe DataTable's configured `recordType` class.\n\nThis relays all parameters to the `data` ModelList's `add` method.\n\nTechnically, this is an alias to `addRow`, but please use the appropriately\nnamed method for readability.\n\nIf a configuration object is passed as a second argument, and that object\nhas `sync: true` set, the underlying Models will be `save()`d.\n\nIf the DataTable's `autoSync` attribute is set to `true`, the additional\nargument is not needed.\n\nIf syncing and the last argument is a function, that function will be used\nas a callback to each Model's `save()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_addRows"
     },
     "sortable": {
      "!type": "fn()",
      "!doc": "Controls which column headers can trigger sorting by user clicks.\n\nAcceptable values are:\n\n * \"auto\" - (default) looks for `sortable: true` in the column configurations\n * `true` - all columns are enabled\n * `false - no UI sortable is enabled\n * {String[]} - array of key names to give sortable headers",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_sortable"
     },
     "sortBy": {
      "!type": "fn()",
      "!doc": "The current sort configuration to maintain in the data.\n\nAccepts column `key` strings or objects with a single property, the column\n`key`, with a value of 1, -1, \"asc\", or \"desc\".  E.g. `{ username: 'asc'\n}`.  String values are assumed to be ascending.\n\nExample values would be:\n\n * `\"username\"` - sort by the data's `username` field or the `key`\n   associated to a column with that `name`.\n * `{ username: \"desc\" }` - sort by `username` in descending order.\n   Alternately, use values \"asc\", 1 (same as \"asc\"), or -1 (same as \"desc\").\n * `[\"lastName\", \"firstName\"]` - ascending sort by `lastName`, but for\n   records with the same `lastName`, ascending subsort by `firstName`.\n   Array can have as many items as you want.\n * `[{ lastName: -1 }, \"firstName\"]` - descending sort by `lastName`,\n   ascending subsort by `firstName`. Mixed types are ok.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_sortBy"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "Strings containing language for sorting tooltips.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_strings"
     },
     "sort": {
      "!type": "fn(sortBy: string)",
      "!doc": "Notifies of an impending sort, either from clicking on a column\nheader, or from a call to the `sort` or `toggleSort` method.\n\nThe requested sort is available in the `sortBy` property of the event.\n\nThe default behavior of this event sets the table's `sortBy` attribute.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#event_sort"
     },
     "SORTABLE_HEADER_TEMPLATE": {
      "!type": "string",
      "!doc": "Template for the node that will wrap the header content for sortable\ncolumns.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#property_SORTABLE_HEADER_TEMPLATE"
     },
     "toggleSort": {
      "!type": "fn(fields: string, payload?: yui.Object) -> !this",
      "!doc": "Reverse the current sort direction of one or more fields currently being\nsorted by.\n\nPass the `key` of the column or columns you want the sort order reversed\nfor.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_toggleSort"
     }
    },
    "KEY_NAMES": {
     "!type": "+yui.Object",
     "!doc": "Mapping of key codes to friendly key names that can be used in the\n[keyActions](#property_keyActions) property and [ARIA_ACTIONS](#property_ARIA_ACTIONS)\nproperty.\n\nIt contains aliases for the following keys:\n    <ul>\n    <li>backspace</li>\n    <li>tab</li>\n    <li>enter</li>\n    <li>esc</li>\n    <li>space</li>\n    <li>pgup</li>\n    <li>pgdown</li>\n    <li>end</li>\n    <li>home</li>\n    <li>left</li>\n    <li>up</li>\n    <li>right</li>\n    <li>down</li>\n    <li>f1 .. f12</li>\n    </ul>",
     "!url": "http://yuilibrary.com/classes/DataTable.html#property_KEY_NAMES"
    },
    "ARIA_ACTIONS": {
     "!type": "+yui.Object",
     "!doc": "Mapping of key codes to actions according to the WAI-ARIA suggestion for the\n[Grid Widget](http://www.w3.org/WAI/PF/aria-practices/#grid).\n\nThe key for each entry is a key-code or [keyName](#property_KEY_NAMES) while the\nvalue can be a function that performs the action or a string.  If a string,\nit can either correspond to the name of a method in this module (or  any\nmethod in a DataTable instance) or the name of an event to fire.",
     "!url": "http://yuilibrary.com/classes/DataTable.html#property_ARIA_ACTIONS"
    }
   },
   "DataTable.Column": {
    "!type": "fn()",
    "!doc": "_This is a documentation entry only_\n\nColumns are described by object literals with a set of properties.\nThere is not an actual `DataTable.Column` class.\nHowever, for the purpose of documenting it, this pseudo-class is declared here.\n\nDataTables accept an array of column definitions in their [columns](DataTable.html#attr_columns)\nattribute.  Each entry in this array is a column definition which may contain\nany combination of the properties listed below.\n\nThere are no mandatory properties though a column will usually have a\n[key](#property_key) property to reference the data it is supposed to show.\nThe [columns](DataTable.html#attr_columns) attribute can accept a plain string\nin lieu of an object literal, which is the equivalent of an object with the\n[key](#property_key) property set to that string.",
    "!url": "http://yuilibrary.com/classes/DataTable.Column.html",
    "prototype": {
     "width": {
      "!type": "string",
      "!doc": "Adds a style `width` setting to an associated `<col>`\nelement for the column.\n\nNote, the assigned width will not truncate cell content, and\nit will not preserve the configured width if doing so would\ncompromise either the instance's `width` configuration or\nthe natural width of the table's containing DOM elements.\n\nIf absolute widths are required, it can be accomplished with\nsome custom CSS and the use of a `cellTemplate`, or\n`formatter`.  \n\nSee the description of \n[datatable-column-widths](DataTable.ColumnWidths.html) \nfor an example of how to do this.\n\n    { key: 'a', width: '400px' },\n    { key: 'b', width: '10em' }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_width"
     },
     "key": {
      "!type": "string",
      "!doc": "Binds the column values to the named property in the [data](DataTable.html#attr_data).\n\nOptional if [formatter](#property_formatter), [nodeFormatter](#property_nodeFormatter),\nor [cellTemplate](#property_cellTemplate) is used to populate the content.\n\nIt should not be set if [children](#property_children) is set.\n\nThe value is used for the [\\_id](#property__id) property unless the [name](#property_name)\nproperty is also set.\n\n    { key: 'username' }\n\nThe above column definition can be reduced to this:\n\n    'username'",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_key"
     },
     "name": {
      "!type": "string",
      "!doc": "An identifier that can be used to locate a column via\n[getColumn](DataTable.html#method_getColumn)\nor style columns with class `yui3-datatable-col-NAME` after dropping characters\nthat are not valid for CSS class names.\n\nIt defaults to the [key](#property_key).\n\nThe value is used for the [\\_id](#property__id) property.\n\n    { name: 'fullname', formatter: ... }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_name"
     },
     "field": {
      "!type": "string",
      "!doc": "An alias for [name](#property_name) for backward compatibility.\n\n    { field: 'fullname', formatter: ... }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_field"
     },
     "id": {
      "!type": "string",
      "!doc": "Overrides the default unique id assigned `<th id=\"HERE\">`.\n\n__Use this with caution__, since it can result in\nduplicate ids in the DOM.\n\n    {\n        name: 'checkAll',\n        id: 'check-all',\n        label: ...\n        formatter: ...\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_id"
     },
     "label": {
      "!type": "string",
      "!doc": "HTML to populate the header `<th>` for the column.\nIt defaults to the value of the [key](#property_key) property or the text\n`Column n` where _n_ is an ordinal number.\n\n    { key: 'MfgvaPrtNum', label: 'Part Number' }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_label"
     },
     "children": {
      "!type": "+yui.Array",
      "!doc": "Used to create stacked headers.\n\nChild columns may also contain `children`. There is no limit\nto the depth of nesting.\n\nColumns configured with `children` are for display only and\n<strong>should not</strong> be configured with a [key](#property_key).\nConfigurations relating to the display of data, such as\n[formatter](#property_formatter), [nodeFormatter](#property_nodeFormatter),\n[emptyCellValue](#property_emptyCellValue), etc. are ignored.\n\n    { label: 'Name', children: [\n        { key: 'firstName', label: 'First`},\n        { key: 'lastName', label: 'Last`}\n    ]}",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_children"
     },
     "abbr": {
      "!type": "string",
      "!doc": "Assigns the value `<th abbr=\"HERE\">`.\n\n    {\n      key  : 'forecast',\n      label: '1yr Target Forecast',\n      abbr : 'Forecast'\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_abbr"
     },
     "title": {
      "!type": "string",
      "!doc": "Assigns the value `<th title=\"HERE\">`.\n\n    {\n      key  : 'forecast',\n      label: '1yr Target Forecast',\n      title: 'Target Forecast for the Next 12 Months'\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_title"
     },
     "headerTemplate": {
      "!type": "+HTML",
      "!doc": "Overrides the default [CELL_TEMPLATE](DataTable.HeaderView.html#property_CELL_TEMPLATE)\nused by `Y.DataTable.HeaderView` to render the header cell\nfor this column.  This is necessary when more control is\nneeded over the markup for the header itself, rather than\nits content.\n\nUse the [label](#property_label) configuration if you don't need to\ncustomize the `<th>` iteself.\n\nImplementers are strongly encouraged to preserve at least\nthe `{id}` and `{_id}` placeholders in the custom value.\n\n    {\n        headerTemplate:\n            '<th id=\"{id}\" ' +\n                'title=\"Unread\" ' +\n                'class=\"{className}\" ' +\n                '{_id}>&#9679;</th>'\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_headerTemplate"
     },
     "cellTemplate": {
      "!type": "string",
      "!doc": "Overrides the default [CELL_TEMPLATE](DataTable.BodyView.html#property_CELL_TEMPLATE)\nused by `Y.DataTable.BodyView` to render the data cells\nfor this column.  This is necessary when more control is\nneeded over the markup for the `<td>` itself, rather than\nits content.\n\n    {\n        key: 'id',\n        cellTemplate:\n            '<td class=\"{className}\">' +\n              '<input type=\"checkbox\" ' +\n                     'id=\"{content}\">' +\n            '</td>'\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_cellTemplate"
     },
     "formatter": {
      "!type": "string",
      "!doc": "String or function used to translate the raw record data for each cell in a\ngiven column into a format better suited to display.\n\nIf it is a string, it will initially be assumed to be the name of one of the\nformatting functions in\n[Y.DataTable.BodyView.Formatters](DataTable.BodyView.Formatters.html).\nIf one such formatting function exists, it will be used.\n\nIf no such named formatter is found, it will be assumed to be a template\nstring and will be expanded.  The placeholders can contain the key to any\nfield in the record or the placeholder `{value}` which represents the value\nof the current field.\n\nIf the value is a function, it will be assumed to be a formatting function.\nA formatting function receives a single argument, an object with the following properties:\n\n* __value__ The raw value from the record Model to populate this cell.\n  Equivalent to `o.record.get(o.column.key)` or `o.data[o.column.key]`.\n* __data__ The Model data for this row in simple object format.\n* __record__ The Model for this row.\n* __column__ The column configuration object.\n* __className__ A string of class names to add `<td class=\"HERE\">` in addition to\n  the column class and any classes in the column's className configuration.\n* __rowIndex__ The index of the current Model in the ModelList.\n  Typically correlates to the row index as well.\n* __rowClass__ A string of css classes to add `<tr class=\"HERE\"><td....`\n  This is useful to avoid the need for nodeFormatters to add classes to the containing row.\n\nThe formatter function may return a string value that will be used for the cell\ncontents or it may change the value of the `value`, `className` or `rowClass`\nproperties which well then be used to format the cell.  If the value for the cell\nis returned in the `value` property of the input argument, no value should be returned.\n\n    {\n        key: 'name',\n        formatter: 'link',  // named formatter\n        linkFrom: 'website' // extra column property for link formatter\n    },\n    {\n        key: 'cost',\n        formatter: '${value}' // formatter template string\n      //formatter: '${cost}'  // same result but less portable\n    },\n    {\n        name: 'Name',          // column does not have associated field value\n                               // thus, it uses name instead of key\n        formatter: '{firstName} {lastName}' // template references other fields\n    },\n    {\n        key: 'price',\n        formatter: function (o) { // function both returns a string to show\n            if (o.value > 3) {    // and a className to apply to the cell\n                o.className += 'expensive';\n            }\n\n            return '$' + o.value.toFixed(2);\n        }\n    },",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_formatter"
     },
     "nodeFormatter": {
      "!type": "fn()",
      "!doc": "Used to customize the content of the data cells for this column.\n\n`nodeFormatter` is significantly slower than [formatter](#property_formatter)\nand should be avoided if possible. Unlike [formatter](#property_formatter),\n`nodeFormatter` has access to the `<td>` element and its ancestors.\n\nThe function provided is expected to fill in the `<td>` element itself.\n__Node formatters should return `false`__ except in certain conditions as described\nin the users guide.\n\nThe function receives a single object\nargument with the following properties:\n\n* __td__\tThe `<td>` Node for this cell.\n* __cell__\tIf the cell `<td> contains an element with class `yui3-datatable-liner,\n  this will refer to that Node. Otherwise, it is equivalent to `td` (default behavior).\n* __value__\tThe raw value from the record Model to populate this cell.\n  Equivalent to `o.record.get(o.column.key)` or `o.data[o.column.key]`.\n* __data__\tThe Model data for this row in simple object format.\n* __record__\tThe Model for this row.\n* __column__\tThe column configuration object.\n* __rowIndex__\tThe index of the current Model in the ModelList.\n _Typically_ correlates to the row index as well.",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_nodeFormatter"
     },
     "emptyCellValue": {
      "!type": "+String} depending on the setting of allowHTM",
      "!doc": "Provides the default value to populate the cell if the data\nfor that cell is `undefined`, `null`, or an empty string.\n\n    {\n        key: 'price',\n        emptyCellValue: '???'\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_emptyCellValue"
     },
     "allowHTML": {
      "!type": "bool",
      "!doc": "Skips the security step of HTML escaping the value for cells\nin this column.\n\nThis is also necessary if [emptyCellValue](#property_emptyCellValue)\nis set with an HTML string.\n`nodeFormatter`s ignore this configuration.  If using a\n`nodeFormatter`, it is recommended to use\n[Y.Escape.html()](Escape.html#method_html)\non any user supplied content that is to be displayed.\n\n    {\n        key: 'preview',\n        allowHTML: true\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_allowHTML"
     },
     "className": {
      "!type": "string",
      "!doc": "A string of CSS classes that will be added to the `<td>`'s\n`class` attribute.\n\nNote, all cells will automatically have a class in the\nform of \"yui3-datatable-col-XXX\" added to the `<td>`, where\nXXX is the column's configured `name`, `key`, or `id` (in\nthat order of preference) sanitized from invalid characters.\n\n    {\n        key: 'symbol',\n        className: 'no-hide'\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_className"
     },
     "sortable": {
      "!type": "bool",
      "!doc": "Used when the instance's `sortable` attribute is set to\n\"auto\" (the default) to determine which columns will support\nuser sorting by clicking on the header.\n\nIf the instance's `key` attribute is not set, this\nconfiguration is ignored.\n\n    { key: 'lastLogin', sortable: true }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_sortable"
     },
     "caseSensitive": {
      "!type": "bool",
      "!doc": "When the instance's `caseSensitive` attribute is set to\n`true` the sort order is case sensitive (relevant to string columns only).\n\nCase sensitive sort is marginally more efficient and should be considered\nfor large data sets when case insensitive sort is not required.\n\n    { key: 'lastLogin', sortable: true, caseSensitive: true }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_caseSensitive"
     },
     "sortFn": {
      "!type": "fn()",
      "!doc": "Allows a column to be sorted using a custom algorithm.  The\nfunction receives three parameters, the first two being the\ntwo record Models to compare, and the third being a boolean\n`true` if the sort order should be descending.\n\nThe function should return `1` to sort `a` above `b`, `-1`\nto sort `a` below `b`, and `0` if they are equal.  Keep in\nmind that the order should be reversed when `desc` is\n`true`.\n\nThe `desc` parameter is provided to allow `sortFn`s to\nalways sort certain values above or below others, such as\nalways sorting `null`s on top.\n\n    {\n      label: 'Name',\n      sortFn: function (a, b, desc) {\n        var an = a.get('lname') + b.get('fname'),\n            bn = a.get('lname') + b.get('fname'),\n            order = (an > bn) ? 1 : -(an < bn);\n\n        return desc ? -order : order;\n      },\n      formatter: function (o) {\n        return o.data.lname + ', ' + o.data.fname;\n      }\n    }",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_sortFn"
     },
     "sortDir": {
      "!type": "number",
      "!doc": "(__read-only__) If a column is sorted, this\nwill be set to `1` for ascending order or `-1` for\ndescending.  This configuration is public for inspection,\nbut can't be used during DataTable instantiation to set the\nsort direction of the column.  Use the table's\n[sortBy](DataTable.html#attr_sortBy)\nattribute for that.",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_sortDir"
     }
    }
   },
   "Plugin.DataTableDataSource": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds DataSource integration to DataTable.",
    "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html",
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the host which\nreferences the plugin instance.",
     "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html#property_NS"
    },
    "NAME": {
     "!type": "string",
     "!doc": "Class name.",
     "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html#property_NAME"
    },
    "prototype": {
     "datasource": {
      "!type": "fn()",
      "!doc": "Pointer to DataSource instance.",
      "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html#attribute_datasource"
     },
     "initialRequest": {
      "!type": "fn()",
      "!doc": "Request sent to DataSource immediately upon initialization.",
      "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html#attribute_initialRequest"
     },
     "load": {
      "!type": "fn(config: yui.Object)",
      "!doc": "Load data by calling DataSource's sendRequest() method under the hood.",
      "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html#method_load"
     },
     "onDataReturnInitializeTable": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Callback function passed to DataSource's sendRequest() method populates\nan entire DataTable with new data, clearing previous data, if any.",
      "!url": "http://yuilibrary.com/classes/Plugin.DataTableDataSource.html#method_onDataReturnInitializeTable"
     }
    }
   },
   "DataTable.BodyView.Formatters": {
    "!type": "fn()",
    "!doc": "Registry of function producing cell formatting functions.\nAllows for names to be used in the column\ndefinition `formatter` property:\n\n    {key:\"myColumn\", formatter:\"date\"}\n\nThese functions are not meant to be used directly.  Instead, they will be\nautomatically called when their names are used as values for the `formatter`\nproperty in a columnd definition.\nThey will be called just once per rendering cycle and will receive\nthe column configuration.  They are expected to return a function that will\nthen be called once per row and will do the actual formatting.\nThey are expected to do all the preparatory once-per-render work\nso that the actual formatting function doesn't need to repeat it.",
    "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html",
    "prototype": {
     "TFOOT_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML templates used to create the `<tfoot>` containing the table footers.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#property_TFOOT_TEMPLATE"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the `<tfoot>` Node and inserts it after the `<thead>` Node.",
      "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_render"
     }
    }
   },
   "DataTable.HeaderView": {
    "!type": "fn()",
    "!proto": "app.View",
    "!doc": "View class responsible for rendering the `<thead>` section of a table. Used as\nthe default `headerView` for `Y.DataTable.Base` and `Y.DataTable` classes.\n\nTranslates the provided array of column configuration objects into a rendered\n`<thead>` based on the data in those objects.\n\n\nThe structure of the column data is expected to be a single array of objects,\nwhere each object corresponds to a `<th>`.  Those objects may contain a\n`children` property containing a similarly structured array to indicate the\nnested cells should be grouped under the parent column's colspan in a separate\nrow of header cells. E.g.\n\n<pre><code>\nnew Y.DataTable.HeaderView({\n  container: tableNode,\n  columns: [\n    { key: 'id' }, // no nesting\n    { key: 'name', children: [\n      { key: 'firstName', label: 'First' },\n      { key: 'lastName',  label: 'Last' } ] }\n  ]\n}).render();\n</code></pre>\n\nThis would translate to the following visualization:\n\n<pre>\n---------------------\n|    |     name     |\n|    |---------------\n| id | First | Last |\n---------------------\n</pre>\n\nSupported properties of the column objects include:\n\n  * `label`     - The HTML content of the header cell.\n  * `key`       - If `label` is not specified, the `key` is used for content.\n  * `children`  - Array of columns to appear below this column in the next\n                  row.\n  * `headerTemplate` - Overrides the instance's `CELL_TEMPLATE` for cells in this\n    column only.\n  * `abbr`      - The content of the 'abbr' attribute of the `<th>`\n  * `title`     - The content of the 'title' attribute of the `<th>`\n  * `className` - Adds this string of CSS classes to the column header\n\nThrough the life of instantiation and rendering, the column objects will have\nthe following properties added to them:\n\n  * `id`       - (Defaulted by DataTable) The id to assign the rendered column\n  * `_colspan` - To supply the `<th>` attribute\n  * `_rowspan` - To supply the `<th>` attribute\n  * `_parent`  - (Added by DataTable) If the column is a child of another\n    column, this points to its parent column\n\nThe column object is also used to provide values for {placeholder} tokens in the\ninstance's `CELL_TEMPLATE`, so you can modify the template and include other\ncolumn object properties to populate them.",
    "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html",
    "prototype": {
     "CELL_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the table's header cell markup.  Override this to\ncustomize how header cell markup is created.",
      "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html#property_CELL_TEMPLATE"
     },
     "columns": {
      "!type": "[+yui.Array]",
      "!doc": "The data representation of the header rows to render.  This is assigned by\nparsing the `columns` configuration array, and is used by the render()\nmethod.",
      "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html#property_columns"
     },
     "ROW_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the table's header row markup.  Override this to\ncustomize the row markup.",
      "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html#property_ROW_TEMPLATE"
     },
     "source": {
      "!type": "+yui.Object",
      "!doc": "The object that serves as the source of truth for column and row data.\nThis property is assigned at instantiation from the `source` property of\nthe configuration object passed to the constructor.",
      "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html#property_source"
     },
     "THEAD_TEMPLATE": {
      "!type": "string",
      "!doc": "HTML templates used to create the `<thead>` containing the table headers.",
      "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html#property_THEAD_TEMPLATE"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the `<thead>` Node content by assembling markup generated by\npopulating the `ROW_TEMPLATE` and `CELL_TEMPLATE` templates with content\nfrom the `columns` property.",
      "!url": "http://yuilibrary.com/classes/DataTable.HeaderView.html#method_render"
     }
    }
   },
   "DataTable.Highlight": {
    "!type": "fn()",
    "!url": "http://yuilibrary.com/classes/DataTable.Highlight.html",
    "prototype": {
     "highlightRows": {
      "!type": "fn()",
      "!doc": "Setting this to true will create a delegate on the DataTable adding the\ndefault classname to the row when the mouse is over the row.",
      "!url": "http://yuilibrary.com/classes/DataTable.Highlight.html#attribute_highlightRows"
     },
     "highlightCols": {
      "!type": "fn()",
      "!doc": "Setting this to true will create a delegate on the DataTable adding the\ndefault classname to the column when the mouse is over the column.",
      "!url": "http://yuilibrary.com/classes/DataTable.Highlight.html#attribute_highlightCols"
     },
     "highlightCells": {
      "!type": "fn()",
      "!doc": "Setting this to true will create a delegate on the DataTable adding the\ndefault classname to the cell when the mouse is over it.",
      "!url": "http://yuilibrary.com/classes/DataTable.Highlight.html#attribute_highlightCells"
     },
     "highlightClassNames": {
      "!type": "+yui.Object",
      "!doc": "An object consisting of classnames for a `row`, a `col` and a `cell` to\nbe applied to their respective objects when the user moves the mouse over\nthe item and the attribute is set to true.",
      "!url": "http://yuilibrary.com/classes/DataTable.Highlight.html#property_highlightClassNames"
     }
    }
   },
   "DataTable.Paginator.View": {
    "!type": "fn()",
    "!proto": "app.View",
    "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html",
    "prototype": {
     "containerTemplate": {
      "!type": "string",
      "!doc": "Template for this view's container.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#property_containerTemplate"
     },
     "contentTemplate": {
      "!type": "string",
      "!doc": "Template for content. Helps maintain order of controls.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#property_contentTemplate"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "Sets classnames on the templates and bind events",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#method_initializer"
     },
     "render": {
      "!type": "fn() -> !this",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#method_render"
     },
     "attachEvents": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#method_attachEvents"
     },
     "pageSizes": {
      "!type": "fn()",
      "!doc": "Array of values used to populate the drop down for items per page",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#attribute_pageSizes"
     },
     "model": {
      "!type": "fn()",
      "!doc": "Model used for this view",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.View.html#attribute_model"
     }
    }
   },
   "DataTable.Paginator": {
    "!type": "fn()",
    "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html",
    "prototype": {
     "paginatorModel": {
      "!type": "fn()",
      "!doc": "A model instance or a configuration object for the Model.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#attribute_paginatorModel"
     },
     "paginatorModelType": {
      "!type": "fn()",
      "!doc": "A pointer to a Model object to be instantiated, or a String off of the\n`Y` namespace.\n\nThis is only used if the `paginatorModel` is a configuration object or\nis null.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#attribute_paginatorModelType"
     },
     "paginatorView": {
      "!type": "fn()",
      "!doc": "A pointer to a `Y.View` object to be instantiated. A new view will be\ncreated for each location provided. Each view created will be given the\nsame model instance.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#attribute_paginatorView"
     },
     "pageSizes": {
      "!type": "fn()",
      "!doc": "Array of values used to populate the values in the Paginator UI allowing\nthe end user to select the number of items to display per page.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#attribute_pageSizes"
     },
     "rowsPerPage": {
      "!type": "fn()",
      "!doc": "Number of rows to display per page. As the UI changes the number of pages\nto display, this will update to reflect the value selected in the UI",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#attribute_rowsPerPage"
     },
     "paginatorLocation": {
      "!type": "fn()",
      "!doc": "String of `footer` or `header`, a Y.Node, or an Array or any combination\nof those values.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#attribute_paginatorLocation"
     },
     "firstPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the first page.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#method_firstPage"
     },
     "lastPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the last page.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#method_lastPage"
     },
     "previousPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the previous page.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#method_previousPage"
     },
     "nextPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the `paginatorModel` to the next page.",
      "!url": "http://yuilibrary.com/classes/DataTable.Paginator.html#method_nextPage"
     }
    }
   },
   "DataTable.TableView": {
    "!type": "fn()",
    "!proto": "app.View",
    "!doc": "View class responsible for rendering a `<table>` from provided data.  Used as\nthe default `view` for `Y.DataTable.Base` and `Y.DataTable` classes.",
    "!url": "http://yuilibrary.com/classes/DataTable.TableView.html",
    "prototype": {
     "CAPTION_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the caption Node if the `caption`\nattribute is set.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#property_CAPTION_TEMPLATE"
     },
     "TABLE_TEMPLATE": {
      "!type": "string",
      "!doc": "The HTML template used to create the table Node.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#property_TABLE_TEMPLATE"
     },
     "body": {
      "!type": "+yui.Object",
      "!doc": "The object or instance of the class assigned to `bodyView` that is\nresponsible for rendering and managing the table's `<tbody>`(s) and its\ncontent.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#property_body"
     },
     "foot": {
      "!type": "+yui.Object",
      "!doc": "The object or instance of the class assigned to `footerView` that is\nresponsible for rendering and managing the table's `<tfoot>` and its\ncontent.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#property_foot"
     },
     "head": {
      "!type": "+yui.Object",
      "!doc": "The object or instance of the class assigned to `headerView` that is\nresponsible for rendering and managing the table's `<thead>` and its\ncontent.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#property_head"
     },
     "getCell": {
      "!type": "fn(seed: [number], shift?: [number]) -> +node.Node",
      "!doc": "Returns the `<td>` Node from the given row and column index.  Alternately,\nthe `seed` can be a Node.  If so, the nearest ancestor cell is returned.\nIf the `seed` is a cell, it is returned.  If there is no cell at the given\ncoordinates, `null` is returned.\n\nOptionally, include an offset array or string to return a cell near the\ncell identified by the `seed`.  The offset can be an array containing the\nnumber of rows to shift followed by the number of columns to shift, or one\nof \"above\", \"below\", \"next\", or \"previous\".\n\n<pre><code>// Previous cell in the previous row\nvar cell = table.getCell(e.target, [-1, -1]);\n\n// Next cell\nvar cell = table.getCell(e.target, 'next');\nvar cell = table.getCell(e.taregt, [0, 1];</pre></code>\n\nThis is actually just a pass through to the `bodyView` instance's method\nby the same name.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#method_getCell"
     },
     "getRecord": {
      "!type": "fn(seed: string) -> +app.Model",
      "!doc": "Relays call to the `bodyView`'s `getRecord` method if it has one.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#method_getRecord"
     },
     "getRow": {
      "!type": "fn(id: number) -> +node.Node",
      "!doc": "Returns the `<tr>` Node from the given row index, Model, or Model's\n`clientId`.  If the rows haven't been rendered yet, or if the row can't be\nfound by the input, `null` is returned.\n\nThis is actually just a pass through to the `bodyView` instance's method\nby the same name.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#method_getRow"
     },
     "displayColumns": {
      "!type": "[+yui.Object]",
      "!doc": "Array of the columns that correspond to those with value cells in the\ndata rows. Excludes colspan header columns (configured with `children`).",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#property_displayColumns"
     },
     "render": {
      "!type": "fn() -> !this",
      "!doc": "Creates the UI in the configured `container`.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#method_render"
     },
     "summary": {
      "!type": "fn()",
      "!doc": "Content for the `<table summary=\"ATTRIBUTE VALUE HERE\">`.  Values\nassigned to this attribute will be HTML escaped for security.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_summary"
     },
     "caption": {
      "!type": "fn()",
      "!doc": "HTML content of an optional `<caption>` element to appear above the\ntable.  Leave this config unset or set to a falsy value to remove the\ncaption.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_caption"
     },
     "columns": {
      "!type": "fn()",
      "!doc": "Columns to include in the rendered table.\n\nThis attribute takes an array of objects. Each object is considered a\ndata column or header cell to be rendered.  How the objects are\ntranslated into markup is delegated to the `headerView`, `bodyView`,\nand `footerView`.\n\nThe raw value is passed to the `headerView` and `footerView`.  The\n`bodyView` receives the instance's `displayColumns` array, which is\nparsed from the columns array.  If there are no nested columns (columns\nconfigured with a `children` array), the `displayColumns` is the same\nas the raw value.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_columns"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Width of the table including borders.  This value requires units, so\n`200` is invalid, but `'200px'` is valid.  Setting the empty string\n(the default) will allow the browser to set the table width.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_width"
     },
     "headerView": {
      "!type": "fn()",
      "!doc": "An instance of this class is used to render the contents of the\n`<thead>`&mdash;the column headers for the table.\n\nThe instance of this View will be assigned to the instance's `head`\nproperty.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_headerView"
     },
     "headerConfig": {
      "!type": "fn()",
      "!doc": "Configuration overrides used when instantiating the `headerView`\ninstance.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_headerConfig"
     },
     "footerView": {
      "!type": "fn()",
      "!doc": "An instance of this class is used to render the contents of the\n`<tfoot>` (if appropriate).\n\nThe instance of this View will be assigned to the instance's `foot`\nproperty.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_footerView"
     },
     "footerConfig": {
      "!type": "fn()",
      "!doc": "Configuration overrides used when instantiating the `footerView`\ninstance.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_footerConfig"
     },
     "bodyView": {
      "!type": "fn()",
      "!doc": "An instance of this class is used to render the contents of the table's\n`<tbody>`&mdash;the data cells in the table.\n\nThe instance of this View will be assigned to the instance's `body`\nproperty.\n\nIt is not strictly necessary that the class function assigned here be\na View subclass.  It must however have a `render()` method.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_bodyView"
     },
     "bodyConfig": {
      "!type": "fn()",
      "!doc": "Configuration overrides used when instantiating the `bodyView`\ninstance.",
      "!url": "http://yuilibrary.com/classes/DataTable.TableView.html#attribute_bodyConfig"
     }
    }
   }
  },
  "datatable_formatters": {
   "DataTable.BodyView.Formatters": {
    "!type": "fn()",
    "!doc": "Registry of function producing cell formatting functions.\nAllows for names to be used in the column\ndefinition `formatter` property:\n\n    {key:\"myColumn\", formatter:\"date\"}\n\nThese functions are not meant to be used directly.  Instead, they will be\nautomatically called when their names are used as values for the `formatter`\nproperty in a columnd definition.\nThey will be called just once per rendering cycle and will receive\nthe column configuration.  They are expected to return a function that will\nthen be called once per row and will do the actual formatting.\nThey are expected to do all the preparatory once-per-render work\nso that the actual formatting function doesn't need to repeat it.",
    "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html",
    "button": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter that produces a BUTTON element using the value of\nthe [buttonLabel](DataTable.Column.html#property_buttonLabel)\ncolumn definition attribute as its label or the text\n`Click` if not found.\n\nApplies the CSS className `yui3-datatable-button` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_button"
    },
    "boolean": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that returns the texts `\"true\"` or `\"false\"`\nand assigns the CSS classNames `yui3-datatable-true` or `yui3-datatable-false`\nbased on the value of the cell.\n\nIf either a [booleanLabels](DataTable.Column.html#property_booleanLabels)\n configuration object is defined for the column\nor a [booleanLabels](DataTable.html#attr_booleanLabels)\nconfiguration attribute is defined for the datatable,\nthe formatter will use the values for the properties `true` or `false`\nof either of those objects as the text to show.\n\nIt returns `null`s or `undefined`s unchanged so that the `emptyCellValue`\nconfiguration attribute will eventually apply.\n\n     {key:\"active\", formatter: \"boolean\", booleanLabels: {\n         \"true\": \"yes\",\n         \"false\": \"no\"\n     }}",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_boolean"
    },
    "currency": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that formats values as currency using\nthe [Number.format](Number.html#method_format) method.\nIt looks for the format to apply in the\n[currencyFormat](DataTable.Column.html#property_currencyFormat) property\nof the column or in the\n[currencyFormat](DataTable.html#attr_currencyFormat)\n attribute of the whole table.\n\n    {key: \"amount\", formatter: \"currency\", currencyFormat: {\n        decimalPlaces:2,\n        decimalSeparator: \",\",\n        thousandsSeparator: \".\",\n        suffix: \"&euro;\"\n    }}\n\nSee [Number.format](Number.html#method_format) for the available format specs.\n\nAnything that cannot be parsed as a number will be returned unchanged.\n\nApplies the CSS className `yui3-datatable-currency` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_currency"
    },
    "date": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a date formatting function.\nIt looks for the format to apply in the\n[dateFormat](DataTable.Column.html#property_dateFormat)\nproperty of the column or in the\n[dateFormat](DataTable.html#attr_dateFormat)\n attribute of the whole table.\n\n    {key: \"DOB\", formatter: \"date\", dateFormat: \"%I:%M:%S %p\"}\n\nSee [Date.format](Date.html#method_format) for the available format specs.\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_date"
    },
    "localDate": {
     "!type": "fn() -> fn()",
     "!doc": "Returns a date-only (no time part) formatting function using the current locale.\n\n    {key: \"DOB\", formatter: \"localDate\"}\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_localDate"
    },
    "localTime": {
     "!type": "fn() -> fn()",
     "!doc": "Returns a time-only (no date part) formatting function using the current locale.\n\n    {key: \"startTime\", formatter: \"localTime\"}\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_localTime"
    },
    "localDateTime": {
     "!type": "fn() -> fn()",
     "!doc": "Returns a date formatting function using the current locale.\n\n    {key: \"DOB\", formatter: \"localDateTime\"}\n\nAnything that is not a date is returned unchanged.\n\nApplies the CSS className `yui3-datatable-date` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_localDateTime"
    },
    "email": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a function that produces email links.\nIf the column definition contains a property\n[linkFrom](DataTable.Column.html#property_linkFrom) it will use the value\nin that field for the link, otherwise, the same column value will be used for both\nlink and text.\n\n    {key: \"contact\", formatter: \"email\", linkFrom: \"contactEmail\"}\n\nIt will use the respective\n[emptyCellValue](DataTable.Column.html#property_emptyCellValue)\ncolumn configuration attribute\nfor each of the value and the link if either is empty.\nIf the link value is still empty, it will return the value with no link.\n\nApplies the CSS className `yui3-datatable-email` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_email"
    },
    "link": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a function that produces links.\nIf the column definition contains a property\n[linkFrom](DataTable.Column.html#property_linkFrom) it will use the value\nin that field for the link, otherwise, the same column value will be used for both\nlink and text.\n\n    {key: \"company\", formatter: \"link\", linkFrom: \"webSite\"}\n\nIt will use the respective\n[emptyCellValue](DataTable.Column.html#property_emptyCellValue)\n column configuration attribute\nfor each of the value and the link if either is empty.\nIf the link value is still empty, it will return the value with no link.\n\nApplies the CSS className `yui3-datatable-link` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_link"
    },
    "number": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that formats values using\nthe [Number.format](Number.html#method_format) method.\nIt looks for the format to apply in the\n[numberFormat](DataTable.Column.html#property_numberFormat)\nproperty of the column or in the\n[numberFormat](DataTable.html#attr_numberFormat)\nattribute of the whole table.\n\n     {key: \"weight\", formatter: \"number\", numberFormat: {\n         decimalPlaces:2,\n         decimalSeparator: \",\",\n         thousandsSeparator: \",\",\n         suffix: \"kg\"\n     }}\n\nSee [Number.format](Number.html#method_format) for the available format specs.\n\nAnything that cannot be parsed as a number will be returned unchanged.\n\nApplies the CSS className `yui3-datatable-number` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_number"
    },
    "lookup": {
     "!type": "fn(col: yui.Object) -> fn()",
     "!doc": "Returns a formatter function that returns texts from a lookup table\nbased on the stored value.\n\nIt looks for the translation to apply in the\n[lookupTable](DataTable.Column.html#property_lookupTable) property of the\ncolumn in either of these two formats:\n\n    {key: \"status\", formatter: \"lookup\", lookupTable: {\n        0: \"unknown\",\n        1: \"requested\",\n        2: \"approved\",\n        3: \"delivered\"\n    }},\n    {key: \"otherStatus\", formatter: \"lookup\", lookupTable: [\n        {value:0, text: \"unknown\"},\n        {value:1, text: \"requested\"},\n        {value:2, text: \"approved\"},\n        {value:3, text: \"delivered\"}\n    ]}\n\nApplies the CSS className `yui3-datatable-lookup` to the cell.",
     "!url": "http://yuilibrary.com/classes/DataTable.BodyView.Formatters.html#method_lookup"
    }
   },
   "DataTable.Column": {
    "!type": "fn()",
    "!doc": "_This is a documentation entry only_\n\nColumns are described by object literals with a set of properties.\nThere is not an actual `DataTable.Column` class.\nHowever, for the purpose of documenting it, this pseudo-class is declared here.\n\nDataTables accept an array of column definitions in their [columns](DataTable.html#attr_columns)\nattribute.  Each entry in this array is a column definition which may contain\nany combination of the properties listed below.\n\nThere are no mandatory properties though a column will usually have a\n[key](#property_key) property to reference the data it is supposed to show.\nThe [columns](DataTable.html#attr_columns) attribute can accept a plain string\nin lieu of an object literal, which is the equivalent of an object with the\n[key](#property_key) property set to that string.",
    "!url": "http://yuilibrary.com/classes/DataTable.Column.html",
    "prototype": {
     "buttonLabel": {
      "!type": "string",
      "!doc": "Label to be shown in the face of a button produced by the\n[button](DataTable.BodyView.Formatters.html#method_button) formatter",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_buttonLabel"
     },
     "booleanLabels": {
      "!type": "+yui.Object",
      "!doc": "Determines the texts to be shown to represent Boolean values when the\n[boolean](DataTable.BodyView.Formatters.html#method_boolean) formatter\nis used.\n\nThe attribute is an object with text values for properties `true` and `false`.\n\n    {key:\"active\", formatter: \"boolean\", booleanLabels: {\n        \"true\": \"yes\",\n        \"false\": \"no\"\n    }}",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_booleanLabels"
     },
     "currencyFormat": {
      "!type": "+yui.Object",
      "!doc": "Format specification for columns using the\n[currency](DataTable.BodyView.Formatters.html#method_currency) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_currencyFormat"
     },
     "dateFormat": {
      "!type": "string",
      "!doc": "Format specification for columns using the\n[date](DataTable.BodyView.Formatters.html#method_date) formatter.\nIt contains a string as described in\n[Date.format](Date.html#method_format).",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_dateFormat"
     },
     "linkFrom": {
      "!type": "string",
      "!doc": "Name of the field that is to provide the link for a column using the\n[email](DataTable.BodyView.Formatters.html#method_email) or\n[link](DataTable.BodyView.Formatters.html#method_link)\nformatters.",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_linkFrom"
     },
     "numberFormat": {
      "!type": "+yui.Object",
      "!doc": "Format specification for columns using the\n[number](DataTable.BodyView.Formatters.html#method_number) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_numberFormat"
     },
     "lookupTable": {
      "!type": "+yui.Object",
      "!doc": "Map of values to text used to translate internal values to human readable text\nin columns using the [lookup](DataTable.BodyView.Formatters.html#method_lookup)\nformatter.\n\nThe map can be given in either of two formats:\n\n    {key: \"status\", formatter: \"lookup\", lookupTable: {\n        0: \"unknown\",\n        1: \"requested\",\n        2: \"approved\",\n        3: \"delivered\"\n    }},\n    {key: \"otherStatus\", formatter: \"lookup\", lookupTable: [\n        {value:0, text: \"unknown\"},\n        {value:1, text: \"requested\"},\n        {value:2, text: \"approved\"},\n        {value:3, text: \"delivered\"}\n    ]}\n\nThe last format is compatible with the [dropdown](DataTable.Editors.html#property_dropdown)\nand autocomplete-based editors, where the order of the items in the dropdown matters.",
      "!url": "http://yuilibrary.com/classes/DataTable.Column.html#property_lookupTable"
     }
    }
   },
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://yuilibrary.com/classes/DataTable.html",
    "prototype": {
     "booleanLabels": {
      "!type": "fn()",
      "!doc": "Determines the texts to be shown to represent Boolean values when the\n[boolean](DataTable.BodyView.Formatters.html#method_boolean) formatter\nis used on any column.\n\nIt works like the column-specific\n[booleanLabels](DataTable.Column.html#property_booleanLabels) but\nfor all columns using the\n[boolean](DataTable.BodyView.Formatters.html#method_boolean) formatter at once.\nThe values are often retrieved from a resource of localized texts.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_booleanLabels"
     },
     "currencyFormat": {
      "!type": "fn()",
      "!doc": "Format specification for columns using the\n[currency](DataTable.BodyView.Formatters.html#method_currency) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).\n\nIt is similar to\n[currencyFormat](DataTable.Column.html#property_currencyFormat)\nbut it applies to any column using the\n[currency](DataTable.BodyView.Formatters.html#method_currency) formatter.\n The values are often retrieved from a resource of localized configuration.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_currencyFormat"
     },
     "dateFormat": {
      "!type": "fn()",
      "!doc": "Format specification for columns using the\n[date](DataTable.BodyView.Formatters.html#method_date) formatter.\nIt contains an object as described in\n[Date.format](Date.html#method_format).\n\nIt is similar to\n[dateFormat](DataTable.Column.html#property_dateFormat)\nbut it applies to any column using the\n[date](DataTable.BodyView.Formatters.html#method_date) formatter.\n The values are often retrieved from a resource of localized configuration.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_dateFormat"
     },
     "numberFormat": {
      "!type": "fn()",
      "!doc": "Format specification for columns using the\n[number](DataTable.BodyView.Formatters.html#method_number) formatter.\nIt contains an object as described in\n[Number.format](Number.html#method_format).\n\nIt is similar to\n[numberFormat](DataTable.Column.html#property_numberFormat)\nbut it applies to any column using the\n[number](DataTable.BodyView.Formatters.html#method_number) formatter.\n The values are often retrieved from a resource of localized configuration.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_numberFormat"
     }
    }
   }
  },
  "datatable_scroll": {
   "DataTable": {
    "!type": "fn()",
    "!proto": "datatable.DataTable.Base",
    "!doc": "A Widget for displaying tabular data.  Before feature modules are `use()`d,\nthis class is functionally equivalent to DataTable.Base.  However, feature\nmodules can modify this class in non-destructive ways, expanding the API and\nfunctionality.\n\nThis is the primary DataTable class.  Out of the box, it provides the ability\nto dynamically generate an HTML table from a set of column configurations and\nrow data.  But feature module inclusion can add table sorting, pagintaion,\nhighlighting, selection, and more.\n\n<pre><code>\n// The functionality of this table would require additional modules be use()d,\n// but the feature APIs are aggregated onto Y.DataTable.\n// (Snippet is for illustration. Not all features are available today.)\nvar table = new Y.DataTable({\n    columns: [\n        { type: 'checkbox', defaultChecked: true },\n        { key: 'firstName', sortable: true, resizable: true },\n        { key: 'lastName', sortable: true },\n        { key: 'role', formatter: toRoleName }\n    ],\n    data: {\n        source: 'http://myserver.com/service/json',\n        type: 'json',\n        schema: {\n            resultListLocator: 'results.users',\n            fields: [\n                'username',\n                'firstName',\n                'lastName',\n                { key: 'role', type: 'number' }\n            ]\n        }\n    },\n    recordType: UserModel,\n    pagedData: {\n        location: 'footer',\n        pageSizes: [20, 50, 'all'],\n        rowsPerPage: 20,\n        pageLinks: 5\n    },\n    editable: true\n});\n</code></pre>\n\n### Column Configuration\n\nThe column configurations are set in the form of an array of objects, where\neach object corresponds to a column.  For columns populated directly from the\nrow data, a 'key' property is required to bind the column to that property or\nattribute in the row data.\n\nNot all columns need to relate to row data, nor do all properties or attributes\nof the row data need to have a corresponding column.  However, only those\ncolumns included in the `columns` configuration attribute will be rendered.\n\nOther column configuration properties are supported by the configured\n`view`, class as well as any features added by plugins or class extensions.\nSee the description of DataTable.TableView and its subviews\nDataTable.HeaderView, DataTable.BodyView, and DataTable.FooterView (and other\nDataTable feature classes) to see what column properties they support.\n\nSome examples of column configurations would be:\n\n<pre><code>\n// Basic\nvar columns = [{ key: 'firstName' }, { key: 'lastName' }, { key: 'age' }];\n\n// For columns without any additional configuration, strings can be used\nvar columns = ['firstName', 'lastName', 'age'];\n\n// Multi-row column headers (see DataTable.HeaderView for details)\nvar columns = [\n    {\n        label: 'Name',\n        children: [\n            { key: 'firstName' },\n            { key: 'lastName' }\n        ]\n    },\n    'age' // mixing and matching objects and strings is ok\n];\n\n// Including columns that are not related 1:1 to row data fields/attributes\n// (See DataTable.BodyView for details)\nvar columns = [\n    {\n        label: 'Name', // Needed for the column header\n        formatter: function (o) {\n            // Fill the column cells with data from firstName and lastName\n            if (o.data.age > 55) {\n                o.className += ' senior';\n            }\n            return o.data.lastName + ', ' + o.data.firstName;\n        }\n    },\n    'age'\n];\n\n// Columns that include feature configurations (for illustration; not all\n// features are available today).\nvar columns = [\n    { type: 'checkbox', defaultChecked: true },\n    { key: 'firstName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'lastName', sortable: true, resizable: true, min-width: '300px' },\n    { key: 'age', emptyCellValue: '<em>unknown</em>' }\n];\n</code></pre>\n\n### Row Data Configuration\n\nThe `data` configuration attribute is responsible for housing the data objects\nthat will be rendered as rows.  You can provide this information in two ways by default:\n\n1. An array of simple objects with key:value pairs\n2. A ModelList of Base-based class instances (presumably Model subclass\n   instances)\n\nIf an array of objects is passed, it will be translated into a ModelList filled\nwith instances of the class provided to the `recordType` attribute.  This\nattribute can also create a custom Model subclass from an array of field names\nor an object of attribute configurations.  If no `recordType` is provided, one\nwill be created for you from available information (see `_initRecordType`).\nProviding either your own ModelList instance for `data`, or at least Model\nclass for `recordType`, is the best way to control client-server\nsynchronization when modifying data on the client side.\n\nThe ModelList instance that manages the table's data is available in the `data`\nproperty on the DataTable instance.\n\n\n### Rendering\n\nTable rendering is a collaborative process between the DataTable and its\nconfigured `view`. The DataTable creates an instance of the configured `view`\n(DataTable.TableView by default), and calls its `render()` method.\nDataTable.TableView, for instance, then creates the `<table>` and `<caption>`,\nthen delegates the rendering of the specific sections of the table to subviews,\nwhich can be configured as `headerView`, `bodyView`, and `footerView`.\nDataTable.TableView defaults the `headerView` to DataTable.HeaderView and the\n`bodyView` to DataTable.BodyView, but leaves the `footerView` unassigned.\nSetting any subview to `null` will result in that table section not being\nrendered.",
    "!url": "http://yuilibrary.com/classes/DataTable.html",
    "prototype": {
     "scrollable": {
      "!type": "fn()",
      "!doc": "Activates or deactivates scrolling in the table.  Acceptable values are:\n\n * `false` - (default) Scrolling is disabled.\n * `true` or 'xy' - If `height` is set, vertical scrolling will be\n   activated, if `width` is set, horizontal scrolling will be activated.\n * 'x' - Activate horizontal scrolling only. Requires the `width` attribute\n   is also set.\n * 'y' - Activate vertical scrolling only. Requires the `height` attribute\n   is also set.",
      "!url": "http://yuilibrary.com/classes/DataTable.html#attribute_scrollable"
     },
     "scrollTo": {
      "!type": "fn(id: string) -> !this",
      "!doc": "Scrolls a given row or cell into view if the table is scrolling.  Pass the\n`clientId` of a Model from the DataTable's `data` ModelList or its row\nindex to scroll to a row or a [row index, column index] array to scroll to\na cell.  Alternately, to scroll to any element contained within the table's\nscrolling areas, pass its ID, or the Node itself (though you could just as\nwell call `node.scrollIntoView()` yourself, but hey, whatever).",
      "!url": "http://yuilibrary.com/classes/DataTable.html#method_scrollTo"
     }
    }
   }
  },
  "datatype_date": {
   "Date": {
    "!type": "fn()",
    "!doc": "Date provides a set of utility functions to operate against Date objects.",
    "!url": "http://yuilibrary.com/classes/Date.html",
    "prototype": {
     "format": {
      "!type": "fn(oDate: datatype_date.Date, oConfig: yui.Object) -> +HTML",
      "!doc": "Takes a native JavaScript Date and formats it as a string for display to user.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_format"
     },
     "isValidDate": {
      "!type": "fn(oDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether a native JavaScript Date contains a valid value.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_isValidDate"
     },
     "areEqual": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether two dates correspond to the same date and time.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_areEqual"
     },
     "isGreater": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether the first date comes later than the second.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_isGreater"
     },
     "isGreaterOrEqual": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether the first date comes later than or is the same as\nthe second.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_isGreaterOrEqual"
     },
     "isInRange": {
      "!type": "fn(aDate: datatype_date.Date, bDate: datatype_date.Date, cDate: datatype_date.Date) -> bool",
      "!doc": "Checks whether the date is between two other given dates.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_isInRange"
     },
     "addDays": {
      "!type": "fn(oDate: datatype_date.Date, numDays: number) -> +datatype_date.Date",
      "!doc": "Adds a specified number of days to the given date.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_addDays"
     },
     "addMonths": {
      "!type": "fn(oDate: datatype_date.Date, numMonths: number) -> +datatype_date.Date",
      "!doc": "Adds a specified number of months to the given date.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_addMonths"
     },
     "addYears": {
      "!type": "fn(oDate: datatype_date.Date, numYears: number) -> +datatype_date.Date",
      "!doc": "Adds a specified number of years to the given date.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_addYears"
     },
     "listOfDatesInMonth": {
      "!type": "fn(oDate: datatype_date.Date) -> +yui.Array",
      "!doc": "Lists all dates in a given month.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_listOfDatesInMonth"
     },
     "daysInMonth": {
      "!type": "fn(oDate: datatype_date.Date) -> number",
      "!doc": "Takes a native JavaScript Date and returns the number of days\nin the month that the given date belongs to.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_daysInMonth"
     },
     "parse": {
      "!type": "fn(data: datatype_date.Date) -> +datatype_date.Date",
      "!doc": "Converts data to type Date.",
      "!url": "http://yuilibrary.com/classes/Date.html#method_parse"
     }
    }
   }
  },
  "dd": {
   "Plugin.DDConstrained": {
    "!type": "fn() -> +dd.Plugin.DDConstrained",
    "!proto": "base.Base",
    "!doc": "Plugin for the dd-drag module to add the constraining methods to it.\nIt supports constraining to a node or viewport. It supports tick based moves and XY axis constraints.",
    "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html",
    "prototype": {
     "drag:tickAlignX": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is aligned with the tickX value.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#event_drag:tickAlignX"
     },
     "drag:tickAlignY": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is aligned with the tickY value.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#event_drag:tickAlignY"
     },
     "stickX": {
      "!type": "fn()",
      "!doc": "Stick the drag movement to the X-Axis. Default: false",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_stickX"
     },
     "stickY": {
      "!type": "fn()",
      "!doc": "Stick the drag movement to the Y-Axis",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_stickY"
     },
     "tickX": {
      "!type": "fn()",
      "!doc": "The X tick offset the drag node should snap to on each drag move. False for no ticks. Default: false",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_tickX"
     },
     "tickY": {
      "!type": "fn()",
      "!doc": "The Y tick offset the drag node should snap to on each drag move. False for no ticks. Default: false",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_tickY"
     },
     "tickXArray": {
      "!type": "fn()",
      "!doc": "An array of page coordinates to use as X ticks for drag movement.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_tickXArray"
     },
     "tickYArray": {
      "!type": "fn()",
      "!doc": "An array of page coordinates to use as Y ticks for drag movement.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_tickYArray"
     },
     "gutter": {
      "!type": "fn()",
      "!doc": "CSS style string for the gutter of a region (supports negative values): '5 0'\n(sets top and bottom to 5px, left and right to 0px), '1 2 3 4' (top 1px, right 2px, bottom 3px, left 4px)",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_gutter"
     },
     "constrain": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the drag node to the boundaries. Arguments:<br>\n'view': Contrain to Viewport<br>\n'#selector_string': Constrain to this node<br>\n'{Region Object}': An Object Literal containing a valid region (top, right, bottom, left) of page positions",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_constrain"
     },
     "constrain2region": {
      "!type": "fn()",
      "!doc": "An Object Literal containing a valid region (top, right, bottom, left) of page positions to constrain the drag node to.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_constrain2region"
     },
     "constrain2node": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the drag node to the boundaries of this node.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_constrain2node"
     },
     "constrain2view": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the drag node to the boundaries of the viewport region.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_constrain2view"
     },
     "cacheRegion": {
      "!type": "fn()",
      "!doc": "Should the region be cached for performace. Default: true",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#attribute_cacheRegion"
     },
     "resetCache": {
      "!type": "fn()",
      "!doc": "Reset the internal region cache.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#method_resetCache"
     },
     "getRegion": {
      "!type": "fn(inc: bool) -> +yui.Object",
      "!doc": "Get the active region: viewport, node, custom region",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#method_getRegion"
     },
     "inRegion": {
      "!type": "fn(xy: yui.Array) -> bool",
      "!doc": "Checks if the XY passed or the dragNode is inside the active region.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#method_inRegion"
     },
     "align": {
      "!type": "fn()",
      "!doc": "Modifies the Drag.actXY method from the after drag:align event. This is where the constraining happens.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#method_align"
     },
     "drag": {
      "!type": "fn()",
      "!doc": "Fires after drag:drag. Handle the tickX and tickX align events.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDConstrained.html#method_drag"
     }
    }
   },
   "Plugin.Drop": {
    "!type": "fn() -> +dd.Plugin.Drop",
    "!proto": "dd.DD.Drop",
    "!doc": "Simple Drop plugin that can be attached to a Node via the plug method.",
    "!url": "http://yuilibrary.com/classes/Plugin.Drop.html",
    "prototype": {
     "NAME": {
      "!type": "string",
      "!doc": "dd-drop-plugin",
      "!url": "http://yuilibrary.com/classes/Plugin.Drop.html#property_NAME"
     },
     "NS": {
      "!type": "string",
      "!doc": "The Drop instance will be placed on the Node instance under the drop namespace. It can be accessed via Node.drop;",
      "!url": "http://yuilibrary.com/classes/Plugin.Drop.html#property_NS"
     }
    }
   },
   "Plugin.Drag": {
    "!type": "fn() -> +dd.Plugin.Drag",
    "!proto": "dd.DD.Drag",
    "!doc": "Simple Drag plugin that can be attached to a Node or Widget via the plug method.",
    "!url": "http://yuilibrary.com/classes/Plugin.Drag.html",
    "prototype": {
     "NAME": {
      "!type": "string",
      "!doc": "dd-plugin",
      "!url": "http://yuilibrary.com/classes/Plugin.Drag.html#property_NAME"
     },
     "NS": {
      "!type": "string",
      "!doc": "The Drag instance will be placed on the Node instance under the dd namespace. It can be accessed via Node.dd;",
      "!url": "http://yuilibrary.com/classes/Plugin.Drag.html#property_NS"
     }
    }
   },
   "DD.DDM": {
    "!type": "fn() -> +dd.DD.DDM",
    "!proto": "base.Base",
    "!doc": "Provides the base Drag Drop Manager required for making a Node draggable.",
    "!url": "http://yuilibrary.com/classes/DD.DDM.html",
    "prototype": {
     "dragCursor": {
      "!type": "fn()",
      "!doc": "The cursor to apply when dragging, if shimmed the shim will get the cursor.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#attribute_dragCursor"
     },
     "clickPixelThresh": {
      "!type": "fn()",
      "!doc": "The number of pixels to move to start a drag operation, default is 3.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#attribute_clickPixelThresh"
     },
     "clickTimeThresh": {
      "!type": "fn()",
      "!doc": "The number of milliseconds a mousedown has to pass to start a drag operation, default is 1000.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#attribute_clickTimeThresh"
     },
     "throttleTime": {
      "!type": "fn()",
      "!doc": "The number of milliseconds to throttle the mousemove event. Default: 150",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#attribute_throttleTime"
     },
     "dragMode": {
      "!type": "fn()",
      "!doc": "This attribute only works if the dd-drop module is active. It will set the dragMode (point, intersect, strict) of all future Drag instances.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#attribute_dragMode"
     },
     "_active": {
      "!type": "bool",
      "!doc": "flag set when we activate our first drag, so DDM can start listening for events.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property__active"
     },
     "CSS_PREFIX": {
      "!type": "string",
      "!doc": "The PREFIX to attach to all DD CSS class names",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_CSS_PREFIX"
     },
     "activeDrag": {
      "!type": "+Drag",
      "!doc": "A reference to the currently active draggable object.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_activeDrag"
     },
     "stopDrag": {
      "!type": "fn() -> !this",
      "!doc": "Method will forcefully stop a drag operation. For example calling this from inside an ESC keypress handler will stop this drag.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_stopDrag"
     },
     "getDrag": {
      "!type": "fn(node: string) -> +yui.Object",
      "!doc": "Get a valid Drag instance back from a Node or a selector string, false otherwise",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_getDrag"
     },
     "swapPosition": {
      "!type": "fn(n1: node.Node, n2: node.Node) -> +node.Node",
      "!doc": "Swap the position of 2 nodes based on their CSS positioning.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_swapPosition"
     },
     "getNode": {
      "!type": "fn(n: node.Node) -> +node.Node",
      "!doc": "Return a node instance from the given node, selector string or Y.Base extended object.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_getNode"
     },
     "swapNode": {
      "!type": "fn(n1: node.Node, n2: node.Node) -> +node.Node",
      "!doc": "Swap the position of 2 nodes based on their DOM location.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_swapNode"
     },
     "ddm:start": {
      "!type": "fn()",
      "!doc": "Fires from the DDM before all drag events fire.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#event_ddm:start"
     },
     "ddm:end": {
      "!type": "fn()",
      "!doc": "Fires from the DDM after the DDM finishes, before the drag end events.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#event_ddm:end"
     },
     "syncActiveShims": {
      "!type": "fn(force: bool)",
      "!doc": "This method will sync the position of the shims on the Drop Targets that are currently active.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_syncActiveShims"
     },
     "useHash": {
      "!type": "bool",
      "!doc": "Should we only check targets that are in the viewport on drags (for performance), default: true",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_useHash"
     },
     "activeDrop": {
      "!type": "+yui.Object",
      "!doc": "A reference to the active Drop Target",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_activeDrop"
     },
     "validDrops": {
      "!type": "+yui.Array",
      "!doc": "An array of the valid Drop Targets for this interaction.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_validDrops"
     },
     "otherDrops": {
      "!type": "+yui.Object",
      "!doc": "An object literal of Other Drop Targets that we encountered during this interaction (in the case of overlapping Drop Targets)",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_otherDrops"
     },
     "targets": {
      "!type": "+yui.Array",
      "!doc": "All of the Targets",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#property_targets"
     },
     "isOverTarget": {
      "!type": "fn(drop: yui.Object) -> bool",
      "!doc": "Check to see if the Drag element is over the target, method varies on current mode",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_isOverTarget"
     },
     "clearCache": {
      "!type": "fn()",
      "!doc": "Clears the cache data used for this interaction.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_clearCache"
     },
     "getBestMatch": {
      "!type": "fn(drops: yui.Array, all: bool) -> +Object or Array",
      "!doc": "This method will gather the area for all potential targets and see which has the hightest covered area and return it.",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_getBestMatch"
     },
     "getDrop": {
      "!type": "fn(node: string) -> +yui.Object",
      "!doc": "Get a valid Drop instance back from a Node or a selector string, false otherwise",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_getDrop"
     },
     "regDelegate": {
      "!type": "fn()",
      "!doc": "Register a Delegate with the DDM",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_regDelegate"
     },
     "getDelegate": {
      "!type": "fn() -> ?",
      "!doc": "Get a delegate instance from a container node",
      "!url": "http://yuilibrary.com/classes/DD.DDM.html#method_getDelegate"
     }
    }
   },
   "DD.Delegate": {
    "!type": "fn() -> +dd.DD.Delegate",
    "!proto": "base.Base",
    "!doc": "Provides the ability to drag multiple nodes under a container element using only one Y.DD.Drag instance as a delegate.",
    "!url": "http://yuilibrary.com/classes/DD.Delegate.html",
    "prototype": {
     "dd": {
      "!type": "?",
      "!doc": "A reference to the temporary dd instance used under the hood.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#property_dd"
     },
     "syncTargets": {
      "!type": "fn() -> !this",
      "!doc": "Applies the Y.Plugin.Drop to all nodes matching the cont + nodes selector query.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#method_syncTargets"
     },
     "createDrop": {
      "!type": "fn(node: node.Node, groups: yui.Array) -> ?",
      "!doc": "Apply the Drop plugin to this node",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#method_createDrop"
     },
     "container": {
      "!type": "fn()",
      "!doc": "A selector query to get the container to listen for mousedown events on. All \"nodes\" should be a child of this container.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_container"
     },
     "nodes": {
      "!type": "fn()",
      "!doc": "A selector query to get the children of the \"container\" to make draggable elements from.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_nodes"
     },
     "invalid": {
      "!type": "fn()",
      "!doc": "A selector query to test a node to see if it's an invalid item.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_invalid"
     },
     "lastNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance of the last item dragged.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_lastNode"
     },
     "currentNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance of the dd node.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_currentNode"
     },
     "dragNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance of the dd dragNode.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_dragNode"
     },
     "over": {
      "!type": "fn()",
      "!doc": "Is the mouse currently over the container",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_over"
     },
     "target": {
      "!type": "fn()",
      "!doc": "Should the items also be a drop target.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_target"
     },
     "dragConfig": {
      "!type": "fn()",
      "!doc": "The default config to be used when creating the DD instance.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_dragConfig"
     },
     "handles": {
      "!type": "fn()",
      "!doc": "The handles config option added to the temp DD instance.",
      "!url": "http://yuilibrary.com/classes/DD.Delegate.html#attribute_handles"
     }
    }
   },
   "DD.Drag": {
    "!type": "fn() -> +dd.DD.Drag",
    "!proto": "base.Base",
    "!doc": "Provides the ability to drag a Node.",
    "!url": "http://yuilibrary.com/classes/DD.Drag.html",
    "prototype": {
     "drag:mouseup": {
      "!type": "fn()",
      "!doc": "Handles the mouseup DOM event, does nothing internally just fires.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:mouseup"
     },
     "drag:mouseDown": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the mousedown DOM event, checks to see if you have a valid handle then starts the drag timers.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:mouseDown"
     },
     "drag:afterMouseDown": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after the mousedown event has been cleared.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:afterMouseDown"
     },
     "drag:removeHandle": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after a handle is removed.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:removeHandle"
     },
     "drag:addHandle": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after a handle is added.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:addHandle"
     },
     "drag:removeInvalid": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after an invalid selector is removed.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:removeInvalid"
     },
     "drag:addInvalid": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires after an invalid selector is added.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:addInvalid"
     },
     "drag:start": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires at the start of a drag operation.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:start"
     },
     "drag:end": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires at the end of a drag operation.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:end"
     },
     "drag:drag": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires every mousemove during a drag operation.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:drag"
     },
     "drag:align": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is aligned.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:align"
     },
     "drag:over": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is over a Drop Target. (Fired from dd-drop)",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:over"
     },
     "drag:enter": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node enters a Drop Target. (Fired from dd-drop)",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:enter"
     },
     "drag:exit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node exits a Drop Target. (Fired from dd-drop)",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:exit"
     },
     "drag:drophit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is dropped on a valid Drop Target. (Fired from dd-ddm-drop)",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:drophit"
     },
     "drag:dropmiss": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when this node is dropped on an invalid Drop Target. (Fired from dd-ddm-drop)",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#event_drag:dropmiss"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Y.Node instance to use as the element to initiate a drag operation",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_node"
     },
     "dragNode": {
      "!type": "fn()",
      "!doc": "Y.Node instance to use as the draggable element, defaults to node",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_dragNode"
     },
     "offsetNode": {
      "!type": "fn()",
      "!doc": "Offset the drag element by the difference in cursor position: default true",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_offsetNode"
     },
     "startCentered": {
      "!type": "fn()",
      "!doc": "Center the dragNode to the mouse position on drag:start: default false",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_startCentered"
     },
     "clickPixelThresh": {
      "!type": "fn()",
      "!doc": "The number of pixels to move to start a drag operation, default is 3.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_clickPixelThresh"
     },
     "clickTimeThresh": {
      "!type": "fn()",
      "!doc": "The number of milliseconds a mousedown has to pass to start a drag operation, default is 1000.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_clickTimeThresh"
     },
     "lock": {
      "!type": "fn()",
      "!doc": "Set to lock this drag element so that it can't be dragged: default false.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_lock"
     },
     "data": {
      "!type": "fn()",
      "!doc": "A payload holder to store arbitrary data about this drag object, can be used to store any value.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_data"
     },
     "move": {
      "!type": "fn()",
      "!doc": "If this is false, the drag element will not move with the cursor: default true. Can be used to \"resize\" the element.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_move"
     },
     "useShim": {
      "!type": "fn()",
      "!doc": "Use the protective shim on all drag operations: default true. Only works with dd-ddm, not dd-ddm-base.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_useShim"
     },
     "activeHandle": {
      "!type": "fn()",
      "!doc": "Config option is set by Drag to inform you of which handle fired the drag event (in the case that there are several handles): default false.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_activeHandle"
     },
     "primaryButtonOnly": {
      "!type": "fn()",
      "!doc": "By default a drag operation will only begin if the mousedown occurred with the primary mouse button.\nSetting this to false will allow for all mousedown events to trigger a drag.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_primaryButtonOnly"
     },
     "dragging": {
      "!type": "fn()",
      "!doc": "This attribute is not meant to be used by the implementor, it is meant to be used as an Event tracker so you can listen for it to change.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_dragging"
     },
     "target": {
      "!type": "+yui.Object",
      "!doc": "This will be a reference to the Drop instance associated with this drag if the target: true config attribute is set..",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_target"
     },
     "dragMode": {
      "!type": "fn()",
      "!doc": "This attribute only works if the dd-drop module is active. It will set the dragMode (point, intersect, strict) of this Drag instance.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_dragMode"
     },
     "groups": {
      "!type": "fn()",
      "!doc": "Array of groups to add this drag into.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_groups"
     },
     "handles": {
      "!type": "fn()",
      "!doc": "Array of valid handles to add. Adding something here will set all handles, even if previously added with addHandle",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_handles"
     },
     "bubbles": {
      "!type": "fn()",
      "!doc": "Controls the default bubble parent for this Drag instance. Default: Y.DD.DDM. Set to false to disable bubbling. Use bubbleTargets in config",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_bubbles"
     },
     "haltDown": {
      "!type": "fn()",
      "!doc": "Should the mousedown event be halted. Default: true",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#attribute_haltDown"
     },
     "addToGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Add this Drag instance to a group, this should be used for on-the-fly group additions.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_addToGroup"
     },
     "removeFromGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Remove this Drag instance from a group, this should be used for on-the-fly group removals.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_removeFromGroup"
     },
     "deltaXY": {
      "!type": "+yui.Array",
      "!doc": "The offset of the mouse position to the element's position",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_deltaXY"
     },
     "startXY": {
      "!type": "+yui.Array",
      "!doc": "The initial mouse position",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_startXY"
     },
     "nodeXY": {
      "!type": "+yui.Array",
      "!doc": "The initial element position",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_nodeXY"
     },
     "lastXY": {
      "!type": "+yui.Array",
      "!doc": "The position of the element as it's moving (for offset calculations)",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_lastXY"
     },
     "actXY": {
      "!type": "+yui.Array",
      "!doc": "The xy that the node will be set to. Changing this will alter the position as it's dragged.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_actXY"
     },
     "realXY": {
      "!type": "+yui.Array",
      "!doc": "The real xy position of the node.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_realXY"
     },
     "mouseXY": {
      "!type": "+yui.Array",
      "!doc": "The XY coords of the mousemove",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_mouseXY"
     },
     "region": {
      "!type": "+yui.Object",
      "!doc": "A region object associated with this drag, used for checking regions while dragging.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_region"
     },
     "validClick": {
      "!type": "fn(ev: event_custom.EventFacade) -> bool",
      "!doc": "Method first checks to see if we have handles, if so it validates the click\nagainst the handle. Then if it finds a valid handle, it checks it against\nthe invalid handles list. Returns true if a good handle was used, false otherwise.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_validClick"
     },
     "removeHandle": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Remove a Selector added by addHandle",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_removeHandle"
     },
     "addHandle": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Add a handle to a drag element. Drag only initiates when a mousedown happens on this element.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_addHandle"
     },
     "removeInvalid": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Remove an invalid handle added by addInvalid",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_removeInvalid"
     },
     "addInvalid": {
      "!type": "fn(str: string) -> !this",
      "!doc": "Add a selector string to test the handle against. If the test passes the drag operation will not continue.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_addInvalid"
     },
     "start": {
      "!type": "fn() -> !this",
      "!doc": "Starts the drag operation",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_start"
     },
     "end": {
      "!type": "fn() -> !this",
      "!doc": "Ends the drag operation",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_end"
     },
     "stopDrag": {
      "!type": "fn() -> !this",
      "!doc": "Method will forcefully stop a drag operation. For example calling this from inside an ESC keypress handler will stop this drag.",
      "!url": "http://yuilibrary.com/classes/DD.Drag.html#method_stopDrag"
     }
    },
    "START_EVENT": {
     "!type": "?",
     "!doc": "This property defaults to \"mousedown\", but when drag-gestures is loaded, it is changed to \"gesturemovestart\"",
     "!url": "http://yuilibrary.com/classes/DD.Drag.html#property_START_EVENT"
    }
   },
   "DD.Drop": {
    "!type": "fn() -> +dd.DD.Drop",
    "!proto": "base.Base",
    "!doc": "Provides the ability to create a Drop Target.",
    "!url": "http://yuilibrary.com/classes/DD.Drop.html",
    "prototype": {
     "drop:over": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a drag element is over this target.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#event_drop:over"
     },
     "drop:enter": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a drag element enters this target.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#event_drop:enter"
     },
     "drop:exit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a drag element exits this target.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#event_drop:exit"
     },
     "drop:hit": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fires when a draggable node is dropped on this Drop Target. (Fired from dd-ddm-drop)",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#event_drop:hit"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Y.Node instance to use as the element to make a Drop Target",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#attribute_node"
     },
     "groups": {
      "!type": "fn()",
      "!doc": "Array of groups to add this drop into.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#attribute_groups"
     },
     "padding": {
      "!type": "fn()",
      "!doc": "CSS style padding to make the Drop Target bigger than the node.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#attribute_padding"
     },
     "lock": {
      "!type": "fn()",
      "!doc": "Set to lock this drop element.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#attribute_lock"
     },
     "bubbles": {
      "!type": "fn()",
      "!doc": "Controls the default bubble parent for this Drop instance. Default: Y.DD.DDM. Set to false to disable bubbling.\nUse bubbleTargets in config.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#attribute_bubbles"
     },
     "useShim": {
      "!type": "fn()",
      "!doc": "Use the Drop shim. Default: true",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#attribute_useShim"
     },
     "addToGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Add this Drop instance to a group, this should be used for on-the-fly group additions.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#method_addToGroup"
     },
     "removeFromGroup": {
      "!type": "fn(g: string) -> !this",
      "!doc": "Remove this Drop instance from a group, this should be used for on-the-fly group removals.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#method_removeFromGroup"
     },
     "shim": {
      "!type": "+yui.Object",
      "!doc": "Node reference to the targets shim",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#property_shim"
     },
     "region": {
      "!type": "+yui.Object",
      "!doc": "A region object associated with this target, used for checking regions while dragging.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#property_region"
     },
     "overTarget": {
      "!type": "bool",
      "!doc": "This flag is tripped when a drag element is over this target.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#property_overTarget"
     },
     "inGroup": {
      "!type": "fn(groups: yui.Array) -> ?",
      "!doc": "Check if this target is in one of the supplied groups.",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#method_inGroup"
     },
     "sizeShim": {
      "!type": "fn()",
      "!doc": "Positions and sizes the shim with the raw data from the node,\nthis can be used to programatically adjust the Targets shim for Animation..",
      "!url": "http://yuilibrary.com/classes/DD.Drop.html#method_sizeShim"
     }
    }
   },
   "Plugin.DDProxy": {
    "!type": "fn() -> +dd.Plugin.DDProxy",
    "!proto": "base.Base",
    "!doc": "Plugin for dd-drag for creating a proxy drag node, instead of dragging the original node.",
    "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html",
    "prototype": {
     "moveOnEnd": {
      "!type": "fn()",
      "!doc": "Move the original node at the end of the drag. Default: true",
      "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html#attribute_moveOnEnd"
     },
     "hideOnEnd": {
      "!type": "fn()",
      "!doc": "Hide the drag node at the end of the drag. Default: true",
      "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html#attribute_hideOnEnd"
     },
     "resizeFrame": {
      "!type": "fn()",
      "!doc": "Make the Proxy node assume the size of the original node. Default: true",
      "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html#attribute_resizeFrame"
     },
     "positionProxy": {
      "!type": "fn()",
      "!doc": "Make the Proxy node appear in the same place as the original node. Default: true",
      "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html#attribute_positionProxy"
     },
     "borderStyle": {
      "!type": "fn()",
      "!doc": "The default border style for the border of the proxy. Default: 1px solid #808080",
      "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html#attribute_borderStyle"
     },
     "cloneNode": {
      "!type": "fn()",
      "!doc": "Should the node be cloned into the proxy for you. Default: false",
      "!url": "http://yuilibrary.com/classes/Plugin.DDProxy.html#attribute_cloneNode"
     }
    }
   },
   "DD.Scroll": {
    "!type": "fn() -> +dd.DD.Scroll",
    "!proto": "base.Base",
    "!doc": "Base scroller class used to create the Plugin.DDNodeScroll and Plugin.DDWinScroll.\nThis class should not be called on it's own, it's designed to be a plugin.",
    "!url": "http://yuilibrary.com/classes/DD.Scroll.html",
    "prototype": {
     "buffer": {
      "!type": "fn()",
      "!doc": "The number of pixels from the edge of the screen to turn on scrolling. Default: 30",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#attribute_buffer"
     },
     "scrollDelay": {
      "!type": "fn()",
      "!doc": "The number of milliseconds delay to pass to the auto scroller. Default: 235",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#attribute_scrollDelay"
     },
     "host": {
      "!type": "fn()",
      "!doc": "The host we are plugged into.",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#attribute_host"
     },
     "windowScroll": {
      "!type": "fn()",
      "!doc": "Turn on window scroll support, default: false",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#attribute_windowScroll"
     },
     "vertical": {
      "!type": "fn()",
      "!doc": "Allow vertical scrolling, default: true.",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#attribute_vertical"
     },
     "horizontal": {
      "!type": "fn()",
      "!doc": "Allow horizontal scrolling, default: true.",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#attribute_horizontal"
     },
     "align": {
      "!type": "fn()",
      "!doc": "Called from the drag:align event to determine if we need to scroll.",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#method_align"
     },
     "start": {
      "!type": "fn()",
      "!doc": "Called from the drag:start event",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#method_start"
     },
     "end": {
      "!type": "fn()",
      "!doc": "Called from the drag:end event",
      "!url": "http://yuilibrary.com/classes/DD.Scroll.html#method_end"
     }
    }
   },
   "Plugin.DDWindowScroll": {
    "!type": "fn() -> +dd.Plugin.DDWindowScroll",
    "!proto": "Scroll",
    "!doc": "Extends the Scroll class to make the window scroll while dragging.",
    "!url": "http://yuilibrary.com/classes/Plugin.DDWindowScroll.html",
    "prototype": {
     "windowScroll": {
      "!type": "fn()",
      "!doc": "Turn on window scroll support, default: true",
      "!url": "http://yuilibrary.com/classes/Plugin.DDWindowScroll.html#attribute_windowScroll"
     }
    }
   },
   "Plugin.DDNodeScroll": {
    "!type": "fn() -> +dd.Plugin.DDNodeScroll",
    "!proto": "Scroll",
    "!doc": "Extends the Scroll class to make a parent node scroll while dragging.",
    "!url": "http://yuilibrary.com/classes/Plugin.DDNodeScroll.html",
    "prototype": {
     "node": {
      "!type": "fn()",
      "!doc": "The node we want to scroll. Used to set the internal parentScroll attribute.",
      "!url": "http://yuilibrary.com/classes/Plugin.DDNodeScroll.html#attribute_node"
     }
    }
   }
  },
  "dial": {
   "Dial": {
    "!type": "fn(config: yui.Object) -> +dial.Dial",
    "!proto": "widget.Widget",
    "!doc": "Create a dial to represent an input control capable of representing a\nseries of intermediate states based on the position of the Dial's handle.\nThese states are typically aligned to a value algorithm whereby the angle of the handle's\nposition corresponds to a given value.",
    "!url": "http://yuilibrary.com/classes/Dial.html",
    "prototype": {
     "min": {
      "!type": "fn()",
      "!doc": "minimum value allowed",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_min"
     },
     "max": {
      "!type": "fn()",
      "!doc": "maximum value allowed",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_max"
     },
     "diameter": {
      "!type": "fn()",
      "!doc": "diameter of the circular background object.\nOther objects scale accordingly.\nSet this only before rendering.",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_diameter"
     },
     "handleDiameter": {
      "!type": "fn()",
      "!doc": "diameter of the handle object which users drag to change the value.\nDial sets the pixel dimension of the handle equal to handleDiameter * diameter.\nSet this only before rendering.",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_handleDiameter"
     },
     "markerDiameter": {
      "!type": "fn()",
      "!doc": "diameter of the marker object which follows the angle of the handle during value changes.\nDial sets the pixel dimension of the marker equal to markerDiameter * diameter.\nSet this only before rendering.",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_markerDiameter"
     },
     "centerButtonDiameter": {
      "!type": "fn()",
      "!doc": "diameter of the center button object.\nDial sets the pixel dimension of the centerButton equal to centerButtonDiameter * diameter.\nSet this only before rendering.",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_centerButtonDiameter"
     },
     "value": {
      "!type": "fn()",
      "!doc": "initial value of the Dial",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_value"
     },
     "minorStep": {
      "!type": "fn()",
      "!doc": "amount to increment/decrement the dial value\nwhen the arrow up/down/left/right keys are pressed",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_minorStep"
     },
     "majorStep": {
      "!type": "fn()",
      "!doc": "amount to increment/decrement the dial value\nwhen the page up/down keys are pressed",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_majorStep"
     },
     "stepsPerRevolution": {
      "!type": "fn()",
      "!doc": "number of value increments in one 360 degree revolution\nof the handle around the dial",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_stepsPerRevolution"
     },
     "decimalPlaces": {
      "!type": "fn()",
      "!doc": "number of decimal places of accuracy in the value",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_decimalPlaces"
     },
     "strings": {
      "!type": "fn()",
      "!doc": "visible strings for the dial UI. This attribute is\ndefined by the base Widget class but has an empty value. The\nDial is simply providing a default value for the attribute.\nGets localized strings in the current language",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_strings"
     },
     "handleDistance": {
      "!type": "fn()",
      "!doc": "distance from the center of the dial to the\ncenter of the marker and handle, when at rest.\nThe value is a percent of the radius of the dial.",
      "!url": "http://yuilibrary.com/classes/Dial.html#attribute_handleDistance"
     },
     "syncUI": {
      "!type": "fn()",
      "!doc": "Synchronizes the DOM state with the attribute settings.",
      "!url": "http://yuilibrary.com/classes/Dial.html#method_syncUI"
     }
    }
   }
  },
  "dom": {
   "DOM": {
    "!type": "fn()",
    "!doc": "Provides DOM helper methods.",
    "!url": "http://yuilibrary.com/classes/DOM.html",
    "prototype": {
     "getText": {
      "!type": "fn(element: HTMLElement) -> string",
      "!doc": "Returns the text content of the HTMLElement.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getText"
     },
     "setText": {
      "!type": "fn(element: HTMLElement, content: string)",
      "!doc": "Sets the text content of the HTMLElement.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setText"
     },
     "setAttribute": {
      "!type": "fn(el: HTMLElement, attr: string, val: string)",
      "!doc": "Provides a normalized attribute interface.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setAttribute"
     },
     "getAttribute": {
      "!type": "fn(el: HTMLElement, attr: string) -> string",
      "!doc": "Provides a normalized attribute interface.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getAttribute"
     },
     "hasClass": {
      "!type": "fn(element: HTMLElement, className: string) -> bool",
      "!doc": "Determines whether a DOM element has the given className.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_hasClass"
     },
     "addClass": {
      "!type": "fn(element: HTMLElement, className: string)",
      "!doc": "Adds a class name to a given DOM element.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(element: HTMLElement, className: string)",
      "!doc": "Removes a class name from a given element.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_removeClass"
     },
     "replaceClass": {
      "!type": "fn(element: HTMLElement, oldClassName: string, newClassName: string)",
      "!doc": "Replace a class with another class for a given element.\nIf no oldClassName is present, the newClassName is simply added.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_replaceClass"
     },
     "toggleClass": {
      "!type": "fn(element: HTMLElement, className: string, addClass: bool)",
      "!doc": "If the className exists on the node it is removed, if it doesn't exist it is added.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_toggleClass"
     },
     "byId": {
      "!type": "fn(id: string, doc: yui.Object) -> +HTMLElement",
      "!doc": "Returns the HTMLElement with the given ID (Wrapper for document.getElementById).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_byId"
     },
     "elementByAxis": {
      "!type": "fn(element: HTMLElement, axis: string, fn?: fn(), all?: bool) -> +HTMLElement",
      "!doc": "Searches the element by the given axis for the first matching element.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_elementByAxis"
     },
     "contains": {
      "!type": "fn(element: HTMLElement, needle: HTMLElement) -> bool",
      "!doc": "Determines whether or not one HTMLElement is or contains another HTMLElement.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_contains"
     },
     "inDoc": {
      "!type": "fn(element: HTMLElement, doc: HTMLElement) -> bool",
      "!doc": "Determines whether or not the HTMLElement is part of the document.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_inDoc"
     },
     "create": {
      "!type": "fn(html: string, doc: HTMLDocument) -> +HTMLElement",
      "!doc": "Creates a new dom node using the provided markup string.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_create"
     },
     "addHTML": {
      "!type": "fn(node: HTMLElement, content: HTMLElement, where: HTMLElement)",
      "!doc": "Inserts content in a node at the given location",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_addHTML"
     },
     "region": {
      "!type": "fn(element: HTMLElement) -> +yui.Object",
      "!doc": "Returns an Object literal containing the following about this element: (top, right, bottom, left)",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_region"
     },
     "intersect": {
      "!type": "fn(element: HTMLElement, element2: HTMLElement, altRegion: yui.Object) -> +yui.Object",
      "!doc": "Find the intersect information for the passed nodes.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_intersect"
     },
     "inRegion": {
      "!type": "fn(node: yui.Object, node2: yui.Object, all: bool, altRegion: yui.Object) -> bool",
      "!doc": "Check if any part of this node is in the passed region",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_inRegion"
     },
     "inViewportRegion": {
      "!type": "fn(element: HTMLElement, all: bool, altRegion: yui.Object) -> bool",
      "!doc": "Check if any part of this element is in the viewport",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_inViewportRegion"
     },
     "viewportRegion": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns an Object literal containing the following about the visible region of viewport: (top, right, bottom, left)",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_viewportRegion"
     },
     "winHeight": {
      "!type": "fn() -> number",
      "!doc": "Returns the inner height of the viewport (exludes scrollbar).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_winHeight"
     },
     "winWidth": {
      "!type": "fn() -> number",
      "!doc": "Returns the inner width of the viewport (exludes scrollbar).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_winWidth"
     },
     "docHeight": {
      "!type": "fn() -> number",
      "!doc": "Document height",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_docHeight"
     },
     "docWidth": {
      "!type": "fn() -> number",
      "!doc": "Document width",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_docWidth"
     },
     "docScrollX": {
      "!type": "fn() -> number",
      "!doc": "Amount page has been scroll horizontally",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_docScrollX"
     },
     "docScrollY": {
      "!type": "fn() -> number",
      "!doc": "Amount page has been scroll vertically",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_docScrollY"
     },
     "getXY": {
      "!type": "fn(element) -> +yui.Array",
      "!doc": "Gets the current position of an element based on page coordinates.\nElement must be part of the DOM tree to have page coordinates\n(display:none or elements not appended return false).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getXY"
     },
     "getScrollbarWidth": {
      "!type": "fn() -> number",
      "!doc": "Gets the width of vertical scrollbars on overflowed containers in the body\ncontent.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getScrollbarWidth"
     },
     "getX": {
      "!type": "fn(element) -> number",
      "!doc": "Gets the current X position of an element based on page coordinates.\nElement must be part of the DOM tree to have page coordinates\n(display:none or elements not appended return false).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getX"
     },
     "getY": {
      "!type": "fn(element) -> number",
      "!doc": "Gets the current Y position of an element based on page coordinates.\nElement must be part of the DOM tree to have page coordinates\n(display:none or elements not appended return false).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getY"
     },
     "setXY": {
      "!type": "fn(element, xy: yui.Array, noRetry: bool)",
      "!doc": "Set the position of an html element in page coordinates.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setXY"
     },
     "setX": {
      "!type": "fn(element, x: number)",
      "!doc": "Set the X position of an html element in page coordinates, regardless of how the element is positioned.\nThe element(s) must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setX"
     },
     "setY": {
      "!type": "fn(element, y: number)",
      "!doc": "Set the Y position of an html element in page coordinates, regardless of how the element is positioned.\nThe element(s) must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setY"
     },
     "swapXY": {
      "!type": "fn(node: node.Node, otherNode: node.Node) -> +node.Node",
      "!doc": "Swap the xy position with another node",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_swapXY"
     },
     "setWidth": {
      "!type": "fn(element: HTMLElement, size: string)",
      "!doc": "Sets the width of the element to the given size, regardless\nof box model, border, padding, etc.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setWidth"
     },
     "setHeight": {
      "!type": "fn(element: HTMLElement, size: string)",
      "!doc": "Sets the height of the element to the given size, regardless\nof box model, border, padding, etc.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setHeight"
     },
     "setStyle": {
      "!type": "fn(node: HTMLElement, att: string, val: string, style?: yui.Object)",
      "!doc": "Sets a style property for a given element.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setStyle"
     },
     "getStyle": {
      "!type": "fn(node: HTMLElement, att: string, style?: yui.Object)",
      "!doc": "Returns the current style value for the given property.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getStyle"
     },
     "setStyles": {
      "!type": "fn(node: HTMLElement, hash: yui.Object)",
      "!doc": "Sets multiple style properties.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_setStyles"
     },
     "getComputedStyle": {
      "!type": "fn(node: HTMLElement, att: string) -> string",
      "!doc": "Returns the computed style for the given node.",
      "!url": "http://yuilibrary.com/classes/DOM.html#method_getComputedStyle"
     }
    }
   },
   "Selector": {
    "!type": "fn()",
    "!doc": "Provides support for using CSS selectors to query the DOM",
    "!url": "http://yuilibrary.com/classes/Selector.html",
    "prototype": {
     "shorthand": {
      "!type": "+object",
      "!doc": "Mapping of shorthand tokens to corresponding attribute selector",
      "!url": "http://yuilibrary.com/classes/Selector.html#property_shorthand"
     },
     "operators": {
      "!type": "+object",
      "!doc": "List of operators and corresponding boolean functions.\nThese functions are passed the attribute and the current node's value of the attribute.",
      "!url": "http://yuilibrary.com/classes/Selector.html#property_operators"
     }
    },
    "useNative": {
     "!type": "?",
     "!doc": "Use the native version of `querySelectorAll`, if it exists.",
     "!url": "http://yuilibrary.com/classes/Selector.html#property_useNative"
    },
    "query": {
     "!type": "fn(selector: string, root: HTMLElement, firstOnly: bool) -> [+HTMLElement]",
     "!doc": "Retrieves a set of nodes based on a given CSS selector.",
     "!url": "http://yuilibrary.com/classes/Selector.html#method_query"
    },
    "filter": {
     "!type": "fn(nodes: [HTMLElement], selector: string) -> [+HTMLElement]",
     "!doc": "Filters out nodes that do not match the given CSS selector.",
     "!url": "http://yuilibrary.com/classes/Selector.html#method_filter"
    },
    "test": {
     "!type": "fn(node: HTMLElement, selector: string, root: HTMLElement) -> bool",
     "!doc": "Determines whether or not the given node matches the given CSS selector.",
     "!url": "http://yuilibrary.com/classes/Selector.html#method_test"
    },
    "ancestor": {
     "!type": "fn(node: HTMLElement, selector: string, testSelf: bool) -> +HTMLElement",
     "!doc": "A convenience method to emulate Y.Node's aNode.ancestor(selector).",
     "!url": "http://yuilibrary.com/classes/Selector.html#method_ancestor"
    }
   }
  },
  "dump": {
   "dump": {
    "!type": "fn(o: yui.Object, d: number) -> string",
    "!doc": "Returns a simple string representation of the object or array.\nOther types of objects will be returned unprocessed.  Arrays\nare expected to be indexed.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_dump"
   }
  },
  "editor": {
   "ContentEditable": {
    "!type": "fn() -> +editor.ContentEditable",
    "!proto": "Y.Plugin.Base",
    "!doc": "Creates a component to work with an elemment.",
    "!url": "http://yuilibrary.com/classes/ContentEditable.html",
    "prototype": {
     "use": {
      "!type": "fn()",
      "!doc": "Array of modules to include in the scoped YUI instance at render time. Default: ['node-base', 'editor-selection', 'stylesheet']",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_use"
     },
     "delegate": {
      "!type": "fn(type: string, fn: fn(), cont: String, Node, sel: string) -> +event_custom.EventHandle",
      "!doc": "A delegate method passed to the instance's delegate method",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#method_delegate"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get a reference to the internal YUI instance.",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#method_getInstance"
     },
     "render": {
      "!type": "fn(node: string) -> !this",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#method_render"
     },
     "focus": {
      "!type": "fn(fn: fn()) -> !this",
      "!doc": "Set the focus to the container",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#method_focus"
     },
     "show": {
      "!type": "fn() -> !this",
      "!doc": "Show the iframe instance",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#method_show"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Hide the iframe instance",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#method_hide"
     },
     "dir": {
      "!type": "fn()",
      "!doc": "The default text direction for this ContentEditable element. Default: ltr",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_dir"
     },
     "container": {
      "!type": "fn()",
      "!doc": "The container to set contentEditable=true or to create on render.",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_container"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The string to inject as Editor content. Default '<br>'",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_content"
     },
     "defaultblock": {
      "!type": "fn()",
      "!doc": "The default tag to use for block level items, defaults to: p",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_defaultblock"
     },
     "extracss": {
      "!type": "fn()",
      "!doc": "A string of CSS to add to the Head of the Editor",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_extracss"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Set the id of the new Node. (optional)",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_id"
     },
     "lang": {
      "!type": "fn()",
      "!doc": "The default language. Default: en-US",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_lang"
     },
     "linkedcss": {
      "!type": "fn()",
      "!doc": "An array of url's to external linked style sheets",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_linkedcss"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The Node instance of the container.",
      "!url": "http://yuilibrary.com/classes/ContentEditable.html#attribute_node"
     }
    },
    "THROTTLE_TIME": {
     "!type": "number",
     "!doc": "The throttle time for key events in IE",
     "!url": "http://yuilibrary.com/classes/ContentEditable.html#property_THROTTLE_TIME"
    },
    "DOM_EVENTS": {
     "!type": "+yui.Object",
     "!doc": "The DomEvents that the frame automatically attaches and bubbles",
     "!url": "http://yuilibrary.com/classes/ContentEditable.html#property_DOM_EVENTS"
    },
    "HTML": {
     "!type": "string",
     "!doc": "The template string used to create the ContentEditable element",
     "!url": "http://yuilibrary.com/classes/ContentEditable.html#property_HTML"
    },
    "NAME": {
     "!type": "string",
     "!doc": "The name of the class (contentEditable)",
     "!url": "http://yuilibrary.com/classes/ContentEditable.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace on which ContentEditable plugin will reside.",
     "!url": "http://yuilibrary.com/classes/ContentEditable.html#property_NS"
    }
   },
   "Plugin.CreateLinkBase": {
    "!type": "fn()",
    "!doc": "Adds prompt style link creation. Adds an override for the\n<a href=\"Plugin.ExecCommand.html#method_COMMANDS.createlink\">createlink execCommand</a>.",
    "!url": "http://yuilibrary.com/classes/Plugin.CreateLinkBase.html",
    "STRINGS": {
     "!type": "?",
     "!doc": "Strings used by the plugin",
     "!url": "http://yuilibrary.com/classes/Plugin.CreateLinkBase.html#property_STRINGS"
    },
    "PROMPT": {
     "!type": "?",
     "!doc": "String used for the Prompt",
     "!url": "http://yuilibrary.com/classes/Plugin.CreateLinkBase.html#property_PROMPT"
    },
    "DEFAULT": {
     "!type": "?",
     "!doc": "String used as the default value of the Prompt",
     "!url": "http://yuilibrary.com/classes/Plugin.CreateLinkBase.html#property_DEFAULT"
    }
   },
   "Plugin.ExecCommand.COMMANDS": {
    "!type": "fn()",
    "!doc": "Static object literal of execCommand overrides",
    "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html",
    "createlink": {
     "!type": "fn(cmd: string) -> +node.Node",
     "!doc": "Override for the createlink method from the <a href=\"Plugin.CreateLinkBase.html\">CreateLinkBase</a> plugin.",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_createlink"
    },
    "wrap": {
     "!type": "fn(cmd: string, tag: string) -> +node.NodeList",
     "!doc": "Wraps the content with a new element of type (tag)",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_wrap"
    },
    "inserthtml": {
     "!type": "fn(cmd: string, html: string) -> +node.Node",
     "!doc": "Inserts the provided HTML at the cursor, should be a single element.",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_inserthtml"
    },
    "insertandfocus": {
     "!type": "fn(cmd: string, html: string) -> +node.Node",
     "!doc": "Inserts the provided HTML at the cursor, and focuses the cursor afterwards.",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertandfocus"
    },
    "insertbr": {
     "!type": "fn(cmd: string)",
     "!doc": "Inserts a BR at the current cursor position",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertbr"
    },
    "insertimage": {
     "!type": "fn(cmd: string, img: string) -> +node.Node",
     "!doc": "Inserts an image at the cursor position",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertimage"
    },
    "addclass": {
     "!type": "fn(cmd: string, cls: string) -> +node.NodeList",
     "!doc": "Add a class to all of the elements in the selection",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_addclass"
    },
    "removeclass": {
     "!type": "fn(cmd: string, cls: string) -> +node.NodeList",
     "!doc": "Remove a class from all of the elements in the selection",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_removeclass"
    },
    "forecolor": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a forecolor to the current selection, or creates a new element and applies it",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_forecolor"
    },
    "backcolor": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a background color to the current selection, or creates a new element and applies it",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_backcolor"
    },
    "hilitecolor": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Sugar method, calles backcolor",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_hilitecolor"
    },
    "fontname2": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a font name to the current selection, or creates a new element and applies it",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_fontname2"
    },
    "fontsize2": {
     "!type": "fn(cmd: string, val: string) -> +node.NodeList",
     "!doc": "Adds a fontsize to the current selection, or creates a new element and applies it",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_fontsize2"
    },
    "insertorderedlist": {
     "!type": "fn(cmd: string)",
     "!doc": "Overload for list",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertorderedlist"
    },
    "insertunorderedlist": {
     "!type": "fn(cmd: string)",
     "!doc": "Overload for list",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_insertunorderedlist"
    },
    "list": {
     "!type": "fn(cmd: string, tag: string)",
     "!doc": "Noramlizes lists creation/destruction for IE. All others pass through to native calls",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_list"
    },
    "justify": {
     "!type": "fn(cmd: string, val: string)",
     "!doc": "Noramlizes alignment for Webkit Browsers",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justify"
    },
    "justifycenter": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifycenter"
    },
    "justifyleft": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifyleft"
    },
    "justifyright": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifyright"
    },
    "justifyfull": {
     "!type": "fn()",
     "!doc": "Override method for justify",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.COMMANDS.html#method_justifyfull"
    }
   },
   "EditorBase": {
    "!type": "fn() -> +editor.EditorBase",
    "!proto": "base.Base",
    "!doc": "Base class for Editor. Handles the business logic of Editor, no GUI involved only utility methods and events.\n\n     var editor = new Y.EditorBase({\n         content: 'Foo'\n     });\n     editor.render('#demo');",
    "!url": "http://yuilibrary.com/classes/EditorBase.html",
    "prototype": {
     "frame": {
      "!type": "?",
      "!doc": "Internal reference to the Y.ContentEditable instance",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#property_frame"
     },
     "copyStyles": {
      "!type": "fn(from: node.Node, to: node.Node)",
      "!doc": "Copy certain styles from one node instance to another (used for new paragraph creation mainly)",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_copyStyles"
     },
     "getDomPath": {
      "!type": "fn(node: node.Node)",
      "!doc": "Walk the dom tree from this node up to body, returning a reversed array of parents.",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_getDomPath"
     },
     "execCommand": {
      "!type": "fn(cmd: string, val: string) -> +node.Node",
      "!doc": "Pass through to the frame.execCommand method",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_execCommand"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get the YUI instance of the frame",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_getInstance"
     },
     "render": {
      "!type": "fn(node: dom.Selector) -> !this",
      "!doc": "Renders the Y.ContentEditable to the passed node.",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_render"
     },
     "focus": {
      "!type": "fn(fn: fn()) -> !this",
      "!doc": "Focus the contentWindow of the iframe",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_focus"
     },
     "show": {
      "!type": "fn() -> !this",
      "!doc": "Handles the showing of the Editor instance. Currently only handles the iframe",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_show"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Handles the hiding of the Editor instance. Currently only handles the iframe",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_hide"
     },
     "getContent": {
      "!type": "fn() -> string",
      "!doc": "(Un)Filters the content of the Editor, cleaning YUI related code. //TODO better filtering",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#method_getContent"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The content to load into the Editor Frame",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#attribute_content"
     },
     "dir": {
      "!type": "fn()",
      "!doc": "The value of the dir attribute on the HTML element of the frame. Default: ltr",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#attribute_dir"
     },
     "linkedcss": {
      "!type": "fn()",
      "!doc": "An array of url's to external linked style sheets",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#attribute_linkedcss"
     },
     "extracss": {
      "!type": "fn()",
      "!doc": "A string of CSS to add to the Head of the Editor",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#attribute_extracss"
     },
     "defaultblock": {
      "!type": "fn()",
      "!doc": "The default tag to use for block level items, defaults to: p",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#attribute_defaultblock"
     },
     "nodeChange": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fired from several mouse/key/paste event points.",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#event_nodeChange"
     },
     "ready": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Fired after the frame is ready.",
      "!url": "http://yuilibrary.com/classes/EditorBase.html#event_ready"
     }
    },
    "NORMALIZE_FONTSIZE": {
     "!type": "fn()",
     "!doc": "Pulls the fontSize from a node, then checks for string values (x-large, x-small)\nand converts them to pixel sizes. If the parsed size is different from the original, it calls\nnode.setStyle to update the node with a pixel size for normalization.",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#method_NORMALIZE_FONTSIZE"
    },
    "TABKEY": {
     "!type": "?",
     "!doc": "The HTML markup to use for the tabkey",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#property_TABKEY"
    },
    "FILTER_RGB": {
     "!type": "fn(String) -> ?",
     "!doc": "Converts an RGB color string to a hex color, example: rgb(0, 255, 0) converts to #00ff00",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#method_FILTER_RGB"
    },
    "TAG2CMD": {
     "!type": "?",
     "!doc": "A hash table of tags to their execcomand's",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#property_TAG2CMD"
    },
    "NC_KEYS": {
     "!type": "+yui.Object",
     "!doc": "Hash table of keys to fire a nodeChange event for.",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#property_NC_KEYS"
    },
    "USE": {
     "!type": "+yui.Array",
     "!doc": "The default modules to use inside the Frame",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#property_USE"
    },
    "NAME": {
     "!type": "?",
     "!doc": "The Class Name: editorBase",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#property_NAME"
    },
    "STRINGS": {
     "!type": "?",
     "!doc": "Editor Strings.  By default contains only the `title` property for the\nTitle of frame document (default \"Rich Text Editor\").",
     "!url": "http://yuilibrary.com/classes/EditorBase.html#property_STRINGS"
    }
   },
   "Plugin.EditorBidi": {
    "!type": "fn() -> +editor.Plugin.EditorBidi",
    "!proto": "base.Base",
    "!doc": "Plugin for Editor to support BiDirectional (bidi) text operations.",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html",
    "EVENTS": {
     "!type": "?",
     "!doc": "The events to check for a direction change on",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property_EVENTS"
    },
    "BLOCKS": {
     "!type": "?",
     "!doc": "More elements may be needed. BODY *must* be in the list to take care of the special case.\n\nblockParent could be changed to use inst.EditorSelection.BLOCKS\ninstead, but that would make Y.Plugin.EditorBidi.blockParent\nunusable in non-RTE contexts (it being usable is a nice\nside-effect).",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property_BLOCKS"
    },
    "DIV_WRAPPER": {
     "!type": "?",
     "!doc": "Template for creating a block element",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property_DIV_WRAPPER"
    },
    "blockParent": {
     "!type": "fn()",
     "!doc": "Returns a block parent for a given element",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#method_blockParent"
    },
    "_NODE_SELECTED": {
     "!type": "?",
     "!doc": "The data key to store on the node.",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property__NODE_SELECTED"
    },
    "addParents": {
     "!type": "fn()",
     "!doc": "Generates a list of all the block parents of the current NodeList",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#method_addParents"
    },
    "NAME": {
     "!type": "?",
     "!doc": "editorBidi",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorBidi",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property_NS"
    },
    "RE_TEXT_ALIGN": {
     "!type": "?",
     "!doc": "Regex for testing/removing text-align style from an element",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#property_RE_TEXT_ALIGN"
    },
    "removeTextAlign": {
     "!type": "fn()",
     "!doc": "Method to test a node's style attribute for text-align and removing it.",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBidi.html#method_removeTextAlign"
    }
   },
   "Plugin.ExecCommand": {
    "!type": "fn() -> +editor.Plugin.ExecCommand",
    "!proto": "base.Base",
    "!doc": "Plugin for the frame module to handle execCommands for Editor",
    "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.html",
    "prototype": {
     "bidi": {
      "!type": "?",
      "!doc": "bidi execCommand override for setting the text direction of a node.\nThis property is added to the `Y.Plugin.ExecCommands.COMMANDS`\ncollection.",
      "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.html#property_bidi"
     },
     "command": {
      "!type": "fn(action: string, value: string) -> +node.Node",
      "!doc": "Execute a command on the frame's document.",
      "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.html#method_command"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get's the instance of YUI bound to the parent frame",
      "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.html#method_getInstance"
     }
    },
    "NAME": {
     "!type": "?",
     "!doc": "execCommand",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "exec",
     "!url": "http://yuilibrary.com/classes/Plugin.ExecCommand.html#property_NS"
    }
   },
   "Plugin.EditorBR": {
    "!type": "fn() -> +editor.Plugin.EditorBR",
    "!proto": "base.Base",
    "!doc": "Plugin for Editor to normalize BR's.",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorBR.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorBR",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBR.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorBR",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorBR.html#property_NS"
    }
   },
   "Plugin.EditorParaBase": {
    "!type": "fn() -> +editor.Plugin.EditorParaBase",
    "!proto": "base.Base",
    "!doc": "Base Plugin for Editor to paragraph auto wrapping and correction.",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorParaBase.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorParaBase.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorParaBase.html#property_NS"
    }
   },
   "Plugin.EditorParaIE": {
    "!type": "fn() -> +editor.Plugin.EditorParaIE",
    "!proto": "editor.Plugin.EditorParaBase",
    "!doc": "Extends EditorParaBase with IE support",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorParaIE.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorParaIE.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorParaIE.html#property_NS"
    }
   },
   "Plugin.EditorPara": {
    "!type": "fn() -> +editor.Plugin.EditorPara",
    "!proto": "editor.Plugin.EditorParaBase",
    "!doc": "Plugin for Editor to paragraph auto wrapping and correction.",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorPara.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorPara.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "editorPara",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorPara.html#property_NS"
    }
   },
   "EditorSelection": {
    "!type": "fn() -> +editor.EditorSelection",
    "!doc": "Wraps some common Selection/Range functionality into a simple object",
    "!url": "http://yuilibrary.com/classes/EditorSelection.html",
    "removeFontFamily": {
     "!type": "fn()",
     "!doc": "Utility method to remove dead font-family styles from an element.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_removeFontFamily"
    },
    "filter": {
     "!type": "fn()",
     "!doc": "Performs a prefilter on all nodes in the editor. Looks for nodes with a style: fontFamily or font face\nIt then creates a dynamic class assigns it and removed the property. This is so that we don't lose\nthe fontFamily when selecting nodes.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_filter"
    },
    "filterBlocks": {
     "!type": "fn()",
     "!doc": "Method attempts to replace all \"orphined\" text nodes in the main body by wrapping them with a <p>. Called from filter.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_filterBlocks"
    },
    "REG_FONTFAMILY": {
     "!type": "?",
     "!doc": "Regular Expression used to find dead font-family styles",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_REG_FONTFAMILY"
    },
    "REG_CHAR": {
     "!type": "?",
     "!doc": "Regular Expression to determine if a string has a character in it",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_REG_CHAR"
    },
    "REG_NON": {
     "!type": "?",
     "!doc": "Regular Expression to determine if a string has a non-character in it",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_REG_NON"
    },
    "REG_NOHTML": {
     "!type": "?",
     "!doc": "Regular Expression to remove all HTML from a string",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_REG_NOHTML"
    },
    "unfilter": {
     "!type": "fn() -> string",
     "!doc": "Undoes what filter does enough to return the HTML from the Editor, then re-applies the filter.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_unfilter"
    },
    "resolve": {
     "!type": "fn(n: HTMLElement) -> +node.Node",
     "!doc": "Resolve a node from the selection object and return a Node instance",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_resolve"
    },
    "getText": {
     "!type": "fn(node: node.Node) -> string",
     "!doc": "Returns the innerHTML of a node with all HTML tags removed.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_getText"
    },
    "ALL": {
     "!type": "?",
     "!doc": "The selector to use when looking for Nodes to cache the value of: [style],font[face]",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_ALL"
    },
    "BLOCKS": {
     "!type": "?",
     "!doc": "The selector to use when looking for block level items.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_BLOCKS"
    },
    "TMP": {
     "!type": "?",
     "!doc": "The temporary fontname applied to a selection to retrieve their values: yui-tmp",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_TMP"
    },
    "DEFAULT_TAG": {
     "!type": "?",
     "!doc": "The default tag to use when creating elements: span",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_DEFAULT_TAG"
    },
    "CURID": {
     "!type": "?",
     "!doc": "The id of the outer cursor wrapper",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_CURID"
    },
    "CUR_WRAPID": {
     "!type": "?",
     "!doc": "The id used to wrap the inner space of the cursor position",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_CUR_WRAPID"
    },
    "CURSOR": {
     "!type": "?",
     "!doc": "The default HTML used to focus the cursor..",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_CURSOR"
    },
    "ROOT": {
     "!type": "?",
     "!doc": "The default HTML element from which data will be retrieved. Default: body",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_ROOT"
    },
    "cleanCursor": {
     "!type": "fn()",
     "!doc": "Called from Editor keydown to remove the \"extra\" space before the cursor.",
     "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_cleanCursor"
    },
    "prototype": {
     "text": {
      "!type": "string",
      "!doc": "Range text value",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_text"
     },
     "isCollapsed": {
      "!type": "bool",
      "!doc": "Flag to show if the range is collapsed or not",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_isCollapsed"
     },
     "anchorNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the parentNode of the anchorNode of the range",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_anchorNode"
     },
     "anchorOffset": {
      "!type": "number",
      "!doc": "The offset from the range object",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_anchorOffset"
     },
     "anchorTextNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the actual textNode of the range.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_anchorTextNode"
     },
     "focusNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the parentNode of the focusNode of the range",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_focusNode"
     },
     "focusOffset": {
      "!type": "number",
      "!doc": "The offset from the range object",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_focusOffset"
     },
     "focusTextNode": {
      "!type": "+node.Node",
      "!doc": "A Node instance of the actual textNode of the range.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#property_focusTextNode"
     },
     "getSelected": {
      "!type": "fn() -> +node.NodeList",
      "!doc": "Get all the nodes in the current selection. This method will actually perform a filter first.\nThen it calls doc.execCommand('fontname', null, 'yui-tmp') to touch all nodes in the selection.\nThe it compiles a list of all nodes affected by the execCommand and builds a NodeList to return.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_getSelected"
     },
     "insertContent": {
      "!type": "fn(html: string) -> +node.Node",
      "!doc": "Insert HTML at the current cursor position and return a Node instance of the newly inserted element.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_insertContent"
     },
     "insertAtCursor": {
      "!type": "fn(html: string, node: node.Node, offset: number, collapse: bool) -> +node.Node",
      "!doc": "Insert HTML at the current cursor position, this method gives you control over the text node to insert into and the offset where to put it.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_insertAtCursor"
     },
     "wrapContent": {
      "!type": "fn(tag: string) -> +node.NodeList",
      "!doc": "Get all elements inside a selection and wrap them with a new element and return a NodeList of all elements touched.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_wrapContent"
     },
     "replace": {
      "!type": "fn(se: string, re: string) -> +node.Node",
      "!doc": "Find and replace a string inside a text node and replace it with HTML focusing the node after\nto allow you to continue to type.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_replace"
     },
     "remove": {
      "!type": "fn() -> !this",
      "!doc": "Destroy the range.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_remove"
     },
     "createRange": {
      "!type": "fn() -> +Range",
      "!doc": "Wrapper for the different range creation methods.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_createRange"
     },
     "selectNode": {
      "!type": "fn(node: node.Node, collapse: bool) -> !this",
      "!doc": "Select a Node (hilighting it).",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_selectNode"
     },
     "setCursor": {
      "!type": "fn() -> +node.Node",
      "!doc": "Put a placeholder in the DOM at the current cursor position.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_setCursor"
     },
     "getCursor": {
      "!type": "fn() -> +node.Node",
      "!doc": "Get the placeholder in the DOM at the current cursor position.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_getCursor"
     },
     "removeCursor": {
      "!type": "fn(keep: bool) -> +node.Node",
      "!doc": "Remove the cursor placeholder from the DOM.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_removeCursor"
     },
     "focusCursor": {
      "!type": "fn() -> +node.Node",
      "!doc": "Gets a stored cursor and focuses it for editing, must be called sometime after setCursor",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_focusCursor"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "Generic toString for logging.",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_toString"
     },
     "getEditorOffset": {
      "!type": "fn(node?: Y.Node) -> ?",
      "!doc": "Gets the offset of the selection for the selection within the current\neditor",
      "!url": "http://yuilibrary.com/classes/EditorSelection.html#method_getEditorOffset"
     }
    }
   },
   "Plugin.EditorTab": {
    "!type": "fn() -> +editor.Plugin.EditorTab",
    "!proto": "base.Base",
    "!doc": "Handles tab and shift-tab indent/outdent support.",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorTab.html",
    "NAME": {
     "!type": "?",
     "!doc": "editorTab",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorTab.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "tab",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorTab.html#property_NS"
    }
   },
   "Frame": {
    "!type": "fn() -> +editor.Frame",
    "!proto": "base.Base",
    "!doc": "Creates a wrapper around an iframe. It loads the content either from a local\nfile or from script and creates a local YUI instance bound to that new window and document.",
    "!url": "http://yuilibrary.com/classes/Frame.html",
    "prototype": {
     "use": {
      "!type": "fn()",
      "!doc": "Array of modules to include in the scoped YUI instance at render time. Default: ['none', 'selector-css2']",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_use"
     },
     "delegate": {
      "!type": "fn(type: string, fn: fn(), cont: string, sel: string) -> +event_custom.EventHandle",
      "!doc": "A delegate method passed to the instance's delegate method",
      "!url": "http://yuilibrary.com/classes/Frame.html#method_delegate"
     },
     "getInstance": {
      "!type": "fn() -> +YUI",
      "!doc": "Get a reference to the internal YUI instance.",
      "!url": "http://yuilibrary.com/classes/Frame.html#method_getInstance"
     },
     "render": {
      "!type": "fn(node: string) -> !this",
      "!doc": "Render the iframe into the container config option or open the window.",
      "!url": "http://yuilibrary.com/classes/Frame.html#method_render"
     },
     "focus": {
      "!type": "fn(fn: fn()) -> !this",
      "!doc": "Set the focus to the iframe",
      "!url": "http://yuilibrary.com/classes/Frame.html#method_focus"
     },
     "show": {
      "!type": "fn() -> !this",
      "!doc": "Show the iframe instance",
      "!url": "http://yuilibrary.com/classes/Frame.html#method_show"
     },
     "hide": {
      "!type": "fn() -> !this",
      "!doc": "Hide the iframe instance",
      "!url": "http://yuilibrary.com/classes/Frame.html#method_hide"
     },
     "title": {
      "!type": "fn()",
      "!doc": "The title to give the blank page.",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_title"
     },
     "dir": {
      "!type": "fn()",
      "!doc": "The default text direction for this new frame. Default: ltr",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_dir"
     },
     "lang": {
      "!type": "fn()",
      "!doc": "The default language. Default: en-US",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_lang"
     },
     "src": {
      "!type": "fn()",
      "!doc": "The src of the iframe/window. Defaults to javascript:;",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_src"
     },
     "designMode": {
      "!type": "fn()",
      "!doc": "Should designMode be turned on after creation.",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_designMode"
     },
     "content": {
      "!type": "fn()",
      "!doc": "The string to inject into the body of the new frame/window.",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_content"
     },
     "basehref": {
      "!type": "fn()",
      "!doc": "The base href to use in the iframe.",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_basehref"
     },
     "container": {
      "!type": "fn()",
      "!doc": "The container to append the iFrame to on render.",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_container"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The Node instance of the iframe.",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_node"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Set the id of the new Node. (optional)",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_id"
     },
     "linkedcss": {
      "!type": "fn()",
      "!doc": "An array of url's to external linked style sheets",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_linkedcss"
     },
     "extracss": {
      "!type": "fn()",
      "!doc": "A string of CSS to add to the Head of the Editor",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_extracss"
     },
     "defaultblock": {
      "!type": "fn()",
      "!doc": "The default tag to use for block level items, defaults to: p",
      "!url": "http://yuilibrary.com/classes/Frame.html#attribute_defaultblock"
     }
    },
    "THROTTLE_TIME": {
     "!type": "number",
     "!doc": "The throttle time for key events in IE",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_THROTTLE_TIME"
    },
    "DOM_EVENTS": {
     "!type": "+yui.Object",
     "!doc": "The DomEvents that the frame automatically attaches and bubbles",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_DOM_EVENTS"
    },
    "DEFAULT_CSS": {
     "!type": "string",
     "!doc": "The default css used when creating the document.",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_DEFAULT_CSS"
    },
    "HTML": {
     "!type": "string",
     "!doc": "The template string used to create the iframe, deprecated to use DOM instead of innerHTML",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_HTML"
    },
    "IFRAME_ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Attributes to auto add to the dynamic iframe under the hood",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_IFRAME_ATTRS"
    },
    "PAGE_HTML": {
     "!type": "string",
     "!doc": "The template used to create the page when created dynamically.",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_PAGE_HTML"
    },
    "getDocType": {
     "!type": "fn() -> string",
     "!doc": "Parses document.doctype and generates a DocType to match the parent page, if supported.\nFor IE8, it grabs document.all[0].nodeValue and uses that. For IE < 8, it falls back to Frame.DOC_TYPE.",
     "!url": "http://yuilibrary.com/classes/Frame.html#method_getDocType"
    },
    "DOC_TYPE": {
     "!type": "string",
     "!doc": "The DOCTYPE to prepend to the new document when created. Should match the one on the page being served.",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_DOC_TYPE"
    },
    "META": {
     "!type": "string",
     "!doc": "The meta-tag for Content-Type to add to the dynamic document",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_META"
    },
    "NAME": {
     "!type": "string",
     "!doc": "The name of the class (frame)",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace on which Frame plugin will reside.",
     "!url": "http://yuilibrary.com/classes/Frame.html#property_NS"
    }
   },
   "Plugin.EditorLists": {
    "!type": "fn() -> +editor.Plugin.EditorLists",
    "!proto": "base.Base",
    "!doc": "Handles list manipulation inside the Editor. Adds keyboard manipulation and execCommand support.\nAdds overrides for the <a href=\"Plugin.ExecCommand.html#method_COMMANDS.insertorderedlist\">insertorderedlist</a>\nand <a href=\"Plugin.ExecCommand.html#method_COMMANDS.insertunorderedlist\">insertunorderedlist</a> execCommands.",
    "!url": "http://yuilibrary.com/classes/Plugin.EditorLists.html",
    "NON": {
     "!type": "?",
     "!doc": "The non element placeholder, used for positioning the cursor and filling empty items",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorLists.html#property_NON"
    },
    "NONSEL": {
     "!type": "?",
     "!doc": "The selector query to get all non elements",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorLists.html#property_NONSEL"
    },
    "REMOVE": {
     "!type": "?",
     "!doc": "The items to removed from a list when a list item is moved, currently removes BR nodes",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorLists.html#property_REMOVE"
    },
    "NAME": {
     "!type": "?",
     "!doc": "editorLists",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorLists.html#property_NAME"
    },
    "NS": {
     "!type": "?",
     "!doc": "lists",
     "!url": "http://yuilibrary.com/classes/Plugin.EditorLists.html#property_NS"
    }
   }
  },
  "escape": {
   "Escape": {
    "!type": "fn()",
    "!doc": "Provides utility methods for escaping strings.",
    "!url": "http://yuilibrary.com/classes/Escape.html",
    "html": {
     "!type": "fn(string: string) -> string",
     "!doc": "Returns a copy of the specified string with special HTML characters\nescaped. The following characters will be converted to their\ncorresponding character entities:\n\n    & < > \" ' / `\n\nThis implementation is based on the [OWASP HTML escaping\nrecommendations][1]. In addition to the characters in the OWASP\nrecommendations, we also escape the <code>&#x60;</code> character, since IE\ninterprets it as an attribute delimiter.\n\nIf _string_ is not already a string, it will be coerced to a string.\n\n[1]: http://www.owasp.org/index.php/XSS_(Cross_Site_Scripting)_Prevention_Cheat_Sheet",
     "!url": "http://yuilibrary.com/classes/Escape.html#method_html"
    },
    "regex": {
     "!type": "fn(string: string) -> string",
     "!doc": "Returns a copy of the specified string with special regular expression\ncharacters escaped, allowing the string to be used safely inside a regex.\nThe following characters, and all whitespace characters, are escaped:\n\n    - $ ^ * ( ) + [ ] { } | \\ , . ?\n\nIf _string_ is not already a string, it will be coerced to a string.",
     "!url": "http://yuilibrary.com/classes/Escape.html#method_regex"
    }
   }
  },
  "event_custom": {
   "CustomEvent": {
    "!type": "fn(type: string, defaults: yui.Object) -> +event_custom.CustomEvent",
    "!doc": "The CustomEvent class lets you define events for your application\nthat can be subscribed to by one or more independent component.",
    "!url": "http://yuilibrary.com/classes/CustomEvent.html",
    "prototype": {
     "type": {
      "!type": "string",
      "!doc": "The type of event, returned to subscribers when the event fires",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_type"
     },
     "silent": {
      "!type": "+boolean",
      "!doc": "By default all custom events are logged in the debug build, set silent\nto true to disable debug outpu for this event.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_silent"
     },
     "subscribers": {
      "!type": "+Subscriber {}",
      "!doc": "The subscribers to this event",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_subscribers"
     },
     "afters": {
      "!type": "+Subscriber {}",
      "!doc": "'After' subscribers",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_afters"
     },
     "monitored": {
      "!type": "+boolean",
      "!doc": "Monitor when an event is attached or detached.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_monitored"
     },
     "broadcast": {
      "!type": "+int",
      "!doc": "If 0, this event does not broadcast.  If 1, the YUI instance is notified\nevery time this event fires.  If 2, the YUI instance and the YUI global\n(if event is enabled on the global) are notified every time this event\nfires.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_broadcast"
     },
     "queuable": {
      "!type": "+boolean",
      "!doc": "Specifies whether this event should be queued when the host is actively\nprocessing an event.  This will effect exectution order of the callbacks\nfor the various events.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_queuable"
     },
     "fired": {
      "!type": "+boolean",
      "!doc": "This event has fired if true",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_fired"
     },
     "firedWith": {
      "!type": "+yui.Array",
      "!doc": "An array containing the arguments the custom event\nwas last fired with.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_firedWith"
     },
     "fireOnce": {
      "!type": "+boolean",
      "!doc": "This event should only fire one time if true, and if\nit has fired, any new subscribers should be notified\nimmediately.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_fireOnce"
     },
     "async": {
      "!type": "+boolean",
      "!doc": "fireOnce listeners will fire syncronously unless async\nis set to true",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_async"
     },
     "stopped": {
      "!type": "+int",
      "!doc": "Flag for stopPropagation that is modified during fire()\n1 means to stop propagation to bubble targets.  2 means\nto also stop additional subscribers on this target.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_stopped"
     },
     "prevented": {
      "!type": "+int",
      "!doc": "Flag for preventDefault that is modified during fire().\nif it is not 0, the default behavior for this event",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_prevented"
     },
     "host": {
      "!type": "+event_custom.EventTarget",
      "!doc": "Specifies the host for this custom event.  This is used\nto enable event bubbling",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_host"
     },
     "defaultFn": {
      "!type": "fn()",
      "!doc": "The default function to execute after event listeners\nhave fire, but only if the default action was not\nprevented.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_defaultFn"
     },
     "defaultTargetOnly": {
      "!type": "bool",
      "!doc": "Flag for the default function to execute only if the\nfiring event is the current target. This happens only\nwhen using custom event delegation and setting the\nflag to `true` mimics the behavior of event delegation\nin the DOM.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_defaultTargetOnly"
     },
     "stoppedFn": {
      "!type": "fn()",
      "!doc": "The function to execute if a subscriber calls\nstopPropagation or stopImmediatePropagation",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_stoppedFn"
     },
     "preventedFn": {
      "!type": "fn()",
      "!doc": "The function to execute if a subscriber calls\npreventDefault",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_preventedFn"
     },
     "emitFacade": {
      "!type": "+boolean",
      "!doc": "If set to true, the custom event will deliver an EventFacade object\nthat is similar to a DOM event object.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_emitFacade"
     },
     "signature": {
      "!type": "+int",
      "!doc": "Supports multiple options for listener signatures in order to\nport YUI 2 apps.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_signature"
     },
     "context": {
      "!type": "+object",
      "!doc": "The context the the event will fire from by default.  Defaults to the YUI\ninstance.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_context"
     },
     "preventable": {
      "!type": "+boolean",
      "!doc": "Specifies whether or not this event's default function\ncan be cancelled by a subscriber by executing preventDefault()\non the event facade",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_preventable"
     },
     "bubbles": {
      "!type": "+boolean",
      "!doc": "Specifies whether or not a subscriber can stop the event propagation\nvia stopPropagation(), stopImmediatePropagation(), or halt()\n\nEvents can only bubble if emitFacade is true.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_bubbles"
     },
     "hasSubs": {
      "!type": "fn() -> ?",
      "!doc": "Returns the number of subscribers for this event as the sum of the on()\nsubscribers and after() subscribers.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_hasSubs"
     },
     "monitor": {
      "!type": "fn(what: string) -> +event_custom.EventHandle",
      "!doc": "Monitor the event state for the subscribed event.  The first parameter\nis what should be monitored, the rest are the normal parameters when\nsubscribing to an event.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_monitor"
     },
     "getSubs": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Get all of the subscribers to this event and any sibling event",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_getSubs"
     },
     "applyConfig": {
      "!type": "fn(o, force: bool)",
      "!doc": "Apply configuration properties.  Only applies the CONFIG whitelist",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_applyConfig"
     },
     "subscribe": {
      "!type": "fn(fn: fn()) -> +event_custom.EventHandle",
      "!doc": "Listen for this event",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_subscribe"
     },
     "on": {
      "!type": "fn(fn: fn(), context: yui.Object, arg: Mixed) -> +event_custom.EventHandle",
      "!doc": "Listen for this event",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_on"
     },
     "after": {
      "!type": "fn(fn: fn(), context: yui.Object, arg: Mixed) -> +event_custom.EventHandle",
      "!doc": "Listen for this event after the normal subscribers have been notified and\nthe default behavior has been applied.  If a normal subscriber prevents the\ndefault behavior, it also prevents after listeners from firing.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_after"
     },
     "detach": {
      "!type": "fn(fn: fn(), context: yui.Object) -> number",
      "!doc": "Detach listeners.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_detach"
     },
     "unsubscribe": {
      "!type": "fn(fn: fn(), context: yui.Object) -> +Int",
      "!doc": "Detach listeners.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_unsubscribe"
     },
     "log": {
      "!type": "fn(msg: string, cat: string)",
      "!doc": "Logger abstraction to centralize the application of the silent flag",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_log"
     },
     "fire": {
      "!type": "fn(arguments: yui.Object) -> bool",
      "!doc": "Notifies the subscribers.  The callback functions will be executed\nfrom the context specified when the event was created, and with the\nfollowing parameters:\n  <ul>\n  <li>The type of event</li>\n  <li>All of the arguments fire() was executed with as an array</li>\n  <li>The custom object (if any) that was passed into the subscribe()\n      method</li>\n  </ul>",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_fire"
     },
     "unsubscribeAll": {
      "!type": "fn() -> number",
      "!doc": "Removes all listeners",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_unsubscribeAll"
     },
     "detachAll": {
      "!type": "fn() -> number",
      "!doc": "Removes all listeners",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_detachAll"
     },
     "stopPropagation": {
      "!type": "fn()",
      "!doc": "Stop propagation to bubble targets",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_stopPropagation"
     },
     "stopImmediatePropagation": {
      "!type": "fn()",
      "!doc": "Stops propagation to bubble targets, and prevents any remaining\nsubscribers on the current target from executing.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_stopImmediatePropagation"
     },
     "preventDefault": {
      "!type": "fn()",
      "!doc": "Prevents the execution of this event's defaultFn",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_preventDefault"
     },
     "halt": {
      "!type": "fn(immediate: bool)",
      "!doc": "Stops the event propagation and prevents the default\nevent behavior.",
      "!url": "http://yuilibrary.com/classes/CustomEvent.html#method_halt"
     }
    },
    "keepDeprecatedSubs": {
     "!type": "+boolean",
     "!doc": "Static flag to enable population of the <a href=\"#property_subscribers\">`subscribers`</a>\nand  <a href=\"#property_subscribers\">`afters`</a> properties held on a `CustomEvent` instance.\n\nThese properties were changed to private properties (`_subscribers` and `_afters`), and\nconverted from objects to arrays for performance reasons.\n\nSetting this property to true will populate the deprecated `subscribers` and `afters`\nproperties for people who may be using them (which is expected to be rare). There will\nbe a performance hit, compared to the new array based implementation.\n\nIf you are using these deprecated properties for a use case which the public API\ndoes not support, please file an enhancement request, and we can provide an alternate\npublic implementation which doesn't have the performance cost required to maintiain the\nproperties as objects.",
     "!url": "http://yuilibrary.com/classes/CustomEvent.html#property_keepDeprecatedSubs"
    }
   },
   "Do": {
    "!type": "fn()",
    "!doc": "Allows for the insertion of methods that are executed before or after\na specified method",
    "!url": "http://yuilibrary.com/classes/Do.html",
    "objs": {
     "!type": "?",
     "!doc": "Cache of objects touched by the utility",
     "!url": "http://yuilibrary.com/classes/Do.html#property_objs"
    },
    "before": {
     "!type": "fn(fn: fn(), obj, sFn: string, c, arg: Mixed) -> string",
     "!doc": "<p>Execute the supplied method before the specified function.  Wrapping\nfunction may optionally return an instance of the following classes to\nfurther alter runtime behavior:</p>\n<dl>\n    <dt></code>Y.Do.Halt(message, returnValue)</code></dt>\n        <dd>Immediatly stop execution and return\n        <code>returnValue</code>.  No other wrapping functions will be\n        executed.</dd>\n    <dt></code>Y.Do.AlterArgs(message, newArgArray)</code></dt>\n        <dd>Replace the arguments that the original function will be\n        called with.</dd>\n    <dt></code>Y.Do.Prevent(message)</code></dt>\n        <dd>Don't execute the wrapped function.  Other before phase\n        wrappers will be executed.</dd>\n</dl>",
     "!url": "http://yuilibrary.com/classes/Do.html#method_before"
    },
    "after": {
     "!type": "fn(fn: fn(), obj, sFn: string, c, arg: Mixed) -> string",
     "!doc": "<p>Execute the supplied method after the specified function.  Wrapping\nfunction may optionally return an instance of the following classes to\nfurther alter runtime behavior:</p>\n<dl>\n    <dt></code>Y.Do.Halt(message, returnValue)</code></dt>\n        <dd>Immediatly stop execution and return\n        <code>returnValue</code>.  No other wrapping functions will be\n        executed.</dd>\n    <dt></code>Y.Do.AlterReturn(message, returnValue)</code></dt>\n        <dd>Return <code>returnValue</code> instead of the wrapped\n        method's original return value.  This can be further altered by\n        other after phase wrappers.</dd>\n</dl>\n\n<p>The static properties <code>Y.Do.originalRetVal</code> and\n<code>Y.Do.currentRetVal</code> will be populated for reference.</p>",
     "!url": "http://yuilibrary.com/classes/Do.html#method_after"
    },
    "detach": {
     "!type": "fn(handle: string)",
     "!doc": "Detach a before or after subscription.",
     "!url": "http://yuilibrary.com/classes/Do.html#method_detach"
    },
    "originalRetVal": {
     "!type": "?",
     "!doc": "Contains the return value from the wrapped method, accessible\nby 'after' event listeners.",
     "!url": "http://yuilibrary.com/classes/Do.html#property_originalRetVal"
    },
    "currentRetVal": {
     "!type": "?",
     "!doc": "Contains the current state of the return value, consumable by\n'after' event listeners, and updated if an after subscriber\nchanges the return value generated by the wrapped function.",
     "!url": "http://yuilibrary.com/classes/Do.html#property_currentRetVal"
    }
   },
   "Do.Method": {
    "!type": "fn(obj, sFn) -> +event_custom.Do.Method",
    "!doc": "Wrapper for a displaced method with aop enabled",
    "!url": "http://yuilibrary.com/classes/Do.Method.html",
    "prototype": {
     "register": {
      "!type": "fn(sid: string, fn: fn(), when: string)",
      "!doc": "Register a aop subscriber",
      "!url": "http://yuilibrary.com/classes/Do.Method.html#method_register"
     },
     "delete": {
      "!type": "fn(sid: string, fn: fn(), when: string)",
      "!doc": "Unregister a aop subscriber",
      "!url": "http://yuilibrary.com/classes/Do.Method.html#method_delete"
     },
     "exec": {
      "!type": "fn(arg: Any) -> +Any",
      "!doc": "<p>Execute the wrapped method.  All arguments are passed into the wrapping\nfunctions.  If any of the before wrappers return an instance of\n<code>Y.Do.Halt</code> or <code>Y.Do.Prevent</code>, neither the wrapped\nfunction nor any after phase subscribers will be executed.</p>\n\n<p>The return value will be the return value of the wrapped function or one\nprovided by a wrapper function via an instance of <code>Y.Do.Halt</code> or\n<code>Y.Do.AlterReturn</code>.",
      "!url": "http://yuilibrary.com/classes/Do.Method.html#method_exec"
     }
    }
   },
   "EventFacade": {
    "!type": "fn(e: event.Event, currentTarget: HTMLElement)",
    "!doc": "Wraps and protects a custom event for use when emitFacade is set to true.\nRequires the event-custom-complex module",
    "!url": "http://yuilibrary.com/classes/EventFacade.html",
    "prototype": {
     "details": {
      "!type": "+yui.Array",
      "!doc": "The arguments passed to fire",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#property_details"
     },
     "type": {
      "!type": "string",
      "!doc": "The event type, this can be overridden by the fire() payload",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#property_type"
     },
     "target": {
      "!type": "+node.Node",
      "!doc": "Node reference for the targeted eventtarget",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#property_target"
     },
     "currentTarget": {
      "!type": "+node.Node",
      "!doc": "Node reference for the element that the listener was attached to.",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#property_currentTarget"
     },
     "relatedTarget": {
      "!type": "+node.Node",
      "!doc": "Node reference to the relatedTarget",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#property_relatedTarget"
     },
     "stopPropagation": {
      "!type": "fn()",
      "!doc": "Stops the propagation to the next bubble target",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#method_stopPropagation"
     },
     "stopImmediatePropagation": {
      "!type": "fn()",
      "!doc": "Stops the propagation to the next bubble target and\nprevents any additional listeners from being exectued\non the current target.",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#method_stopImmediatePropagation"
     },
     "preventDefault": {
      "!type": "fn()",
      "!doc": "Prevents the event's default behavior",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#method_preventDefault"
     },
     "halt": {
      "!type": "fn(immediate: bool)",
      "!doc": "Stops the event propagation and prevents the default\nevent behavior.",
      "!url": "http://yuilibrary.com/classes/EventFacade.html#method_halt"
     }
    }
   },
   "EventTarget": {
    "!type": "fn(opts)",
    "!doc": "EventTarget provides the implementation for any object to\npublish, subscribe and fire to custom events, and also\nalows other EventTargets to target the object with events\nsourced from the other object.\nEventTarget is designed to be used with Y.augment to wrap\nEventCustom in an interface that allows events to be listened to\nand fired by name.  This makes it possible for implementing code to\nsubscribe to an event that either has not been created yet, or will\nnot be created at all.",
    "!url": "http://yuilibrary.com/classes/EventTarget.html",
    "prototype": {
     "addTarget": {
      "!type": "fn(o: event_custom.EventTarget) -> !this",
      "!doc": "Registers another EventTarget as a bubble target.  Bubble order\nis determined by the order registered.  Multiple targets can\nbe specified.\n\nEvents can only bubble if emitFacade is true.\n\nIncluded in the event-custom-complex submodule.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_addTarget"
     },
     "getTargets": {
      "!type": "fn() -> ?",
      "!doc": "Returns an array of bubble targets for this object.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_getTargets"
     },
     "removeTarget": {
      "!type": "fn(o: event_custom.EventTarget) -> !this",
      "!doc": "Removes a bubble target",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_removeTarget"
     },
     "bubble": {
      "!type": "fn(evt: event_custom.CustomEvent) -> bool",
      "!doc": "Propagate an event.  Requires the event-custom-complex module.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_bubble"
     },
     "once": {
      "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
      "!doc": "Listen to a custom event hosted by this object one time.\nThis is the equivalent to <code>on</code> except the\nlistener is immediatelly detached when it is executed.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_once"
     },
     "onceAfter": {
      "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
      "!doc": "Listen to a custom event hosted by this object one time.\nThis is the equivalent to <code>after</code> except the\nlistener is immediatelly detached when it is executed.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_onceAfter"
     },
     "parseType": {
      "!type": "fn(type: string, pre?: string) -> +yui.Array",
      "!doc": "Takes the type parameter passed to 'on' and parses out the\nvarious pieces that could be included in the type.  If the\nevent type is passed without a prefix, it will be expanded\nto include the prefix one is supplied or the event target\nis configured with a default prefix.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_parseType"
     },
     "on": {
      "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
      "!doc": "Subscribe a callback function to a custom event fired by this object or\nfrom an object that bubbles its events to this object.\n\nCallback functions for events published with `emitFacade = true` will\nreceive an `EventFacade` as the first argument (typically named \"e\").\nThese callbacks can then call `e.preventDefault()` to disable the\nbehavior published to that event's `defaultFn`.  See the `EventFacade`\nAPI for all available properties and methods. Subscribers to\nnon-`emitFacade` events will receive the arguments passed to `fire()`\nafter the event name.\n\nTo subscribe to multiple events at once, pass an object as the first\nargument, where the key:value pairs correspond to the eventName:callback,\nor pass an array of event names as the first argument to subscribe to\nall listed events with the same callback.\n\nReturning `false` from a callback is supported as an alternative to\ncalling `e.preventDefault(); e.stopPropagation();`.  However, it is\nrecommended to use the event methods whenever possible.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_on"
     },
     "subscribe": {
      "!type": "fn()",
      "!doc": "subscribe to an event",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_subscribe"
     },
     "detach": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventTarget",
      "!doc": "Detach one or more listeners the from the specified event",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_detach"
     },
     "unsubscribe": {
      "!type": "fn()",
      "!doc": "detach a listener",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_unsubscribe"
     },
     "detachAll": {
      "!type": "fn(type: string)",
      "!doc": "Removes all listeners from the specified event.  If the event type\nis not specified, all listeners from all hosted custom events will\nbe removed.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_detachAll"
     },
     "unsubscribeAll": {
      "!type": "fn(type: string)",
      "!doc": "Removes all listeners from the specified event.  If the event type\nis not specified, all listeners from all hosted custom events will\nbe removed.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_unsubscribeAll"
     },
     "publish": {
      "!type": "fn(type: string, opts: yui.Object) -> +event_custom.CustomEvent",
      "!doc": "Creates a new custom event of the specified type.  If a custom event\nby that name already exists, it will not be re-created.  In either\ncase the custom event is returned.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_publish"
     },
     "fire": {
      "!type": "fn(type: string, arguments: yui.Object) -> bool",
      "!doc": "Fire a custom event by name.  The callback functions will be executed\nfrom the context specified when the event was created, and with the\nfollowing parameters.\n\nThe first argument is the event type, and any additional arguments are\npassed to the listeners as parameters.  If the first of these is an\nobject literal, and the event is configured to emit an event facade,\nthat object is mixed into the event facade and the facade is provided\nin place of the original object.\n\nIf the custom event object hasn't been created, then the event hasn't\nbeen published and it has no subscribers.  For performance sake, we\nimmediate exit in this case.  This means the event won't bubble, so\nif the intention is that a bubble target be notified, the event must\nbe published on this object first.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_fire"
     },
     "getEvent": {
      "!type": "fn(type: string, prefixed: string) -> +event_custom.CustomEvent",
      "!doc": "Returns the custom event of the provided type has been created, a\nfalsy value otherwise",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_getEvent"
     },
     "after": {
      "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
      "!doc": "Subscribe to a custom event hosted by this object.  The\nsupplied callback will execute after any listeners add\nvia the subscribe method, and after the default function,\nif configured for the event, has executed.",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_after"
     },
     "before": {
      "!type": "fn() -> ?",
      "!doc": "Executes the callback before a DOM event, custom event\nor method.  If the first argument is a function, it\nis assumed the target is a method.  For DOM and custom\nevents, this is an alias for Y.on.\n\nFor DOM and custom events:\ntype, callback, context, 0-n arguments\n\nFor methods:\ncallback, object (method host), methodName, context, 0-n arguments",
      "!url": "http://yuilibrary.com/classes/EventTarget.html#method_before"
     }
    }
   },
   "Global": {
    "!type": "+event_custom.EventTarget",
    "!doc": "Hosts YUI page level events.  This is where events bubble to\nwhen the broadcast config is set to 2.  This property is\nonly available if the custom event module is loaded.",
    "!url": "http://yuilibrary.com/classes/YUI.html#property_Global"
   },
   "on": {
    "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
    "!doc": "`Y.on()` can do many things:\n\n<ul>\n    <li>Subscribe to custom events `publish`ed and `fire`d from Y</li>\n    <li>Subscribe to custom events `publish`ed with `broadcast` 1 or 2 and\n        `fire`d from any object in the YUI instance sandbox</li>\n    <li>Subscribe to DOM events</li>\n    <li>Subscribe to the execution of a method on any object, effectively\n    treating that method as an event</li>\n</ul>\n\nFor custom event subscriptions, pass the custom event name as the first argument\nand callback as the second. The `this` object in the callback will be `Y` unless\nan override is passed as the third argument.\n\n    Y.on('io:complete', function () {\n        Y.MyApp.updateStatus('Transaction complete');\n    });\n\nTo subscribe to DOM events, pass the name of a DOM event as the first argument\nand a CSS selector string as the third argument after the callback function.\nAlternately, the third argument can be a `Node`, `NodeList`, `HTMLElement`,\narray, or simply omitted (the default is the `window` object).\n\n    Y.on('click', function (e) {\n        e.preventDefault();\n\n        // proceed with ajax form submission\n        var url = this.get('action');\n        ...\n    }, '#my-form');\n\nThe `this` object in DOM event callbacks will be the `Node` targeted by the CSS\nselector or other identifier.\n\n`on()` subscribers for DOM events or custom events `publish`ed with a\n`defaultFn` can prevent the default behavior with `e.preventDefault()` from the\nevent object passed as the first parameter to the subscription callback.\n\nTo subscribe to the execution of an object method, pass arguments corresponding to the call signature for\n<a href=\"../classes/Do.html#methods_before\">`Y.Do.before(...)`</a>.\n\nNOTE: The formal parameter list below is for events, not for function\ninjection.  See `Y.Do.before` for that signature.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_on"
   },
   "once": {
    "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
    "!doc": "Listen for an event one time.  Equivalent to `on()`, except that\nthe listener is immediately detached when executed.\n\nSee the <a href=\"#methods_on\">`on()` method</a> for additional subscription\noptions.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_once"
   },
   "onceAfter": {
    "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
    "!doc": "Listen for an event one time.  Equivalent to `once()`, except, like `after()`,\nthe subscription callback executes after all `on()` subscribers and the event's\n`defaultFn` (if configured) have executed.  Like `after()` if any `on()` phase\nsubscriber calls `e.preventDefault()`, neither the `defaultFn` nor the `after()`\nsubscribers will execute.\n\nThe listener is immediately detached when executed.\n\nSee the <a href=\"#methods_on\">`on()` method</a> for additional subscription\noptions.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_onceAfter"
   },
   "after": {
    "!type": "fn(type: string, fn: fn(), context?: yui.Object, args?: Any) -> +event_custom.EventHandle",
    "!doc": "Like `on()`, this method creates a subscription to a custom event or to the\nexecution of a method on an object.\n\nFor events, `after()` subscribers are executed after the event's\n`defaultFn` unless `e.preventDefault()` was called from an `on()` subscriber.\n\nSee the <a href=\"#methods_on\">`on()` method</a> for additional subscription\noptions.\n\nNOTE: The subscription signature shown is for events, not for function\ninjection.  See <a href=\"../classes/Do.html#methods_after\">`Y.Do.after`</a>\nfor that signature.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_after"
   },
   "EventHandle": {
    "!type": "fn(evt: event_custom.CustomEvent, sub: event_custom.Subscriber) -> +event_custom.EventHandle",
    "!doc": "Return value from all subscribe operations",
    "!url": "http://yuilibrary.com/classes/EventHandle.html",
    "prototype": {
     "evt": {
      "!type": "+event_custom.CustomEvent",
      "!doc": "The custom event",
      "!url": "http://yuilibrary.com/classes/EventHandle.html#property_evt"
     },
     "sub": {
      "!type": "+event_custom.Subscriber",
      "!doc": "The subscriber object",
      "!url": "http://yuilibrary.com/classes/EventHandle.html#property_sub"
     },
     "detach": {
      "!type": "fn() -> number",
      "!doc": "Detaches this subscriber",
      "!url": "http://yuilibrary.com/classes/EventHandle.html#method_detach"
     },
     "monitor": {
      "!type": "fn(what: string) -> +event_custom.EventHandle",
      "!doc": "Monitor the event state for the subscribed event.  The first parameter\nis what should be monitored, the rest are the normal parameters when\nsubscribing to an event.",
      "!url": "http://yuilibrary.com/classes/EventHandle.html#method_monitor"
     }
    }
   },
   "Subscriber": {
    "!type": "fn(fn: fn(), context: yui.Object, args: yui.Array) -> +event_custom.Subscriber",
    "!doc": "Stores the subscriber information to be used when the event fires.",
    "!url": "http://yuilibrary.com/classes/Subscriber.html",
    "prototype": {
     "fn": {
      "!type": "fn()",
      "!doc": "The callback that will be execute when the event fires\nThis is wrapped by Y.rbind if obj was supplied.",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#property_fn"
     },
     "context": {
      "!type": "+yui.Object",
      "!doc": "Optional 'this' keyword for the listener",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#property_context"
     },
     "id": {
      "!type": "string",
      "!doc": "Unique subscriber id",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#property_id"
     },
     "args": {
      "!type": "+yui.Array",
      "!doc": "Additional arguments to propagate to the subscriber",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#property_args"
     },
     "events": {
      "!type": "+event_custom.EventTarget",
      "!doc": "Custom events for a given fire transaction.",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#property_events"
     },
     "once": {
      "!type": "?",
      "!doc": "This listener only reacts to the event once",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#property_once"
     },
     "notify": {
      "!type": "fn(args: yui.Array, ce: event_custom.CustomEvent)",
      "!doc": "Executes the subscriber.",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#method_notify"
     },
     "contains": {
      "!type": "fn(fn: fn(), context: yui.Object) -> bool",
      "!doc": "Returns true if the fn and obj match this objects properties.\nUsed by the unsubscribe method to match the right subscriber.",
      "!url": "http://yuilibrary.com/classes/Subscriber.html#method_contains"
     }
    }
   }
  },
  "event_gestures": {
   "flick": {
    "!type": "fn(type: string, fn: fn(), cfg: yui.Object) -> +event_custom.EventHandle",
    "!doc": "Sets up a \"flick\" event, that is fired whenever the user initiates a flick gesture on the node\nwhere the listener is attached. The subscriber can specify a minimum distance or velocity for\nwhich the event is to be fired. The subscriber can also specify if there is a particular axis which\nthey are interested in - \"x\" or \"y\". If no axis is specified, the axis along which there was most distance\ncovered is used.\n\n<p>It is recommended that you use Y.bind to set up context and additional arguments for your event handler,\nhowever if you want to pass the context and arguments as additional signature arguments to \"on\",\nyou need to provide a null value for the configuration object, e.g: <code>node.on(\"flick\", fn, null, context, arg1, arg2, arg3)</code></p>",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_flick"
   },
   "gesturemovestart": {
    "!type": "fn(type: string, fn: fn(), cfg: yui.Object) -> +event_custom.EventHandle",
    "!doc": "Sets up a \"gesturemovestart\" event, that is fired on touch devices in response to a single finger \"touchstart\",\nand on mouse based devices in response to a \"mousedown\". The subscriber can specify the minimum time\nand distance thresholds which should be crossed before the \"gesturemovestart\" is fired and for the mouse,\nwhich button should initiate a \"gesturemovestart\". This event can also be listened for using node.delegate().\n\n<p>It is recommended that you use Y.bind to set up context and additional arguments for your event handler,\nhowever if you want to pass the context and arguments as additional signature arguments to on/delegate,\nyou need to provide a null value for the configuration object, e.g: <code>node.on(\"gesturemovestart\", fn, null, context, arg1, arg2, arg3)</code></p>",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_gesturemovestart"
   },
   "gesturemove": {
    "!type": "fn(type: string, fn: fn(), cfg: yui.Object) -> +event_custom.EventHandle",
    "!doc": "Sets up a \"gesturemove\" event, that is fired on touch devices in response to a single finger \"touchmove\",\nand on mouse based devices in response to a \"mousemove\".\n\n<p>By default this event is only fired when the same node\nhas received a \"gesturemovestart\" event. The subscriber can set standAlone to true, in the configuration properties,\nif they want to listen for this event without an initial \"gesturemovestart\".</p>\n\n<p>By default this event sets up it's internal \"touchmove\" and \"mousemove\" DOM listeners on the document element. The subscriber\ncan set the root configuration property, to specify which node to attach DOM listeners to, if different from the document.</p>\n\n<p>This event can also be listened for using node.delegate().</p>\n\n<p>It is recommended that you use Y.bind to set up context and additional arguments for your event handler,\nhowever if you want to pass the context and arguments as additional signature arguments to on/delegate,\nyou need to provide a null value for the configuration object, e.g: <code>node.on(\"gesturemove\", fn, null, context, arg1, arg2, arg3)</code></p>",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_gesturemove"
   },
   "gesturemoveend": {
    "!type": "fn(type: string, fn: fn(), cfg: yui.Object) -> +event_custom.EventHandle",
    "!doc": "Sets up a \"gesturemoveend\" event, that is fired on touch devices in response to a single finger \"touchend\",\nand on mouse based devices in response to a \"mouseup\".\n\n<p>By default this event is only fired when the same node\nhas received a \"gesturemove\" or \"gesturemovestart\" event. The subscriber can set standAlone to true, in the configuration properties,\nif they want to listen for this event without a preceding \"gesturemovestart\" or \"gesturemove\".</p>\n\n<p>By default this event sets up it's internal \"touchend\" and \"mouseup\" DOM listeners on the document element. The subscriber\ncan set the root configuration property, to specify which node to attach DOM listeners to, if different from the document.</p>\n\n<p>This event can also be listened for using node.delegate().</p>\n\n<p>It is recommended that you use Y.bind to set up context and additional arguments for your event handler,\nhowever if you want to pass the context and arguments as additional signature arguments to on/delegate,\nyou need to provide a null value for the configuration object, e.g: <code>node.on(\"gesturemoveend\", fn, null, context, arg1, arg2, arg3)</code></p>",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_gesturemoveend"
   }
  },
  "event_simulate": {
   "Event": {
    "!type": "fn()",
    "!doc": "The event utility provides functions to add and remove event listeners,\nevent cleansing.  It also tries to automatically remove listeners it\nregisters during the unload event.",
    "!url": "http://yuilibrary.com/classes/Event.html",
    "simulate": {
     "!type": "fn(target: HTMLElement, type: string, options: yui.Object)",
     "!doc": "Simulates the event or gesture with the given name on a target.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_simulate"
    }
   }
  },
  "event_valuechange": {
   "ValueChange": {
    "!type": "fn()",
    "!doc": "Provides the implementation for the synthetic `valuechange` event. This class\nisn't meant to be used directly, but is public to make monkeypatching possible.\n\nUsage:\n\n    YUI().use('event-valuechange', function (Y) {\n        Y.one('#my-input').on('valuechange', function (e) {\n            Y.log('previous value: ' + e.prevVal);\n            Y.log('new value: ' + e.newVal);\n        });\n    });",
    "!url": "http://yuilibrary.com/classes/ValueChange.html",
    "POLL_INTERVAL": {
     "!type": "number",
     "!doc": "Interval (in milliseconds) at which to poll for changes to the value of an\nelement with one or more `valuechange` subscribers when the user is likely\nto be interacting with it.",
     "!url": "http://yuilibrary.com/classes/ValueChange.html#property_POLL_INTERVAL"
    },
    "TIMEOUT": {
     "!type": "number",
     "!doc": "Timeout (in milliseconds) after which to stop polling when there hasn't been\nany new activity (keypresses, mouse clicks, etc.) on an element.",
     "!url": "http://yuilibrary.com/classes/ValueChange.html#property_TIMEOUT"
    }
   },
   "valuechange": {
    "!type": "fn(prevVal: string, newVal: string)",
    "!doc": "Synthetic event that fires when the `value` property of an `<input>`,\n`<textarea>`, `<select>`, or `[contenteditable=\"true\"]` node changes as a\nresult of a user-initiated keystroke, mouse operation, or input method\neditor (IME) input event.\n\nUnlike the `onchange` event, this event fires when the value actually changes\nand not when the element loses focus. This event also reports IME and\nmulti-stroke input more reliably than `oninput` or the various key events across\nbrowsers.\n\nFor performance reasons, only focused nodes are monitored for changes, so\nprogrammatic value changes on nodes that don't have focus won't be detected.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_valuechange"
   }
  },
  "event": {
   "available": {
    "!type": "fn(type: string, fn: fn(), el: string, context, args) -> +event_custom.EventHandle",
    "!doc": "Executes the callback as soon as the specified element\nis detected in the DOM.  This function expects a selector\nstring for the element(s) to detect.  If you already have\nan element reference, you don't need this event.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_available"
   },
   "contentready": {
    "!type": "fn(type: string, fn: fn(), el: string, context, args) -> +event_custom.EventHandle",
    "!doc": "Executes the callback as soon as the specified element\nis detected in the DOM with a nextSibling property\n(indicating that the element's children are available).\nThis function expects a selector\nstring for the element(s) to detect.  If you already have\nan element reference, you don't need this event.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_contentready"
   },
   "Event": {
    "!type": "fn()",
    "!doc": "The event utility provides functions to add and remove event listeners,\nevent cleansing.  It also tries to automatically remove listeners it\nregisters during the unload event.",
    "!url": "http://yuilibrary.com/classes/Event.html",
    "delegate": {
     "!type": "fn(node: node.Node, subscription: yui.Array, notifier: bool, filter: string)",
     "!doc": "Event delegation for the 'tap' event. The delegated event will use a\nsupplied selector or filtering function to test if the event references at least one\nnode that should trigger the subscription callback.\n\nUsage:\n\n    node.delegate('tap', function (e) {\n        Y.log('li a inside node was tapped.');\n    }, 'li a');",
     "!url": "http://yuilibrary.com/classes/Event.html#method_delegate"
    },
    "compileFilter": {
     "!type": "fn(selector: string) -> fn()",
     "!doc": "Compiles a selector string into a filter function to identify whether\nNodes along the parent axis of an event's target should trigger event\nnotification.\n\nThis function is memoized, so previously compiled filter functions are\nreturned if the same selector string is provided.\n\nThis function may be useful when defining synthetic events for delegate\nhandling.\n\nHosted as a property of the `delegate` method (e.g. `Y.delegate.compileFilter`).",
     "!url": "http://yuilibrary.com/classes/Event.html#method_compileFilter"
    },
    "POLL_RETRYS": {
     "!type": "+int",
     "!doc": "The number of times we should look for elements that are not\nin the DOM at the time the event is requested after the document\nhas been loaded.  The default is 1000@amp;40 ms, so it will poll\nfor 40 seconds or until all outstanding handlers are bound\n(whichever comes first).",
     "!url": "http://yuilibrary.com/classes/Event.html#property_POLL_RETRYS"
    },
    "POLL_INTERVAL": {
     "!type": "+int",
     "!doc": "The poll interval in milliseconds",
     "!url": "http://yuilibrary.com/classes/Event.html#property_POLL_INTERVAL"
    },
    "lastError": {
     "!type": "+Error",
     "!doc": "addListener/removeListener can throw errors in unexpected scenarios.\nThese errors are suppressed, the method returns false, and this property\nis set",
     "!url": "http://yuilibrary.com/classes/Event.html#property_lastError"
    },
    "DOMReady": {
     "!type": "+boolean",
     "!doc": "True when the document is initially usable",
     "!url": "http://yuilibrary.com/classes/Event.html#property_DOMReady"
    },
    "onAvailable": {
     "!type": "fn(id: string, fn: fn(), p_obj: yui.Object, p_override: bool, checkContent: bool)",
     "!doc": "Executes the supplied callback when the item with the supplied\nid is found.  This is meant to be used to execute behavior as\nsoon as possible as the page loads.  If you use this after the\ninitial page load it will poll for a fixed time for the element.\nThe number of times it will poll and the frequency are\nconfigurable.  By default it will poll for 10 seconds.\n\n<p>The callback is executed with a single parameter:\nthe custom object parameter, if provided.</p>",
     "!url": "http://yuilibrary.com/classes/Event.html#method_onAvailable"
    },
    "onContentReady": {
     "!type": "fn(id: string, fn: fn(), obj: yui.Object, override: bool)",
     "!doc": "Works the same way as onAvailable, but additionally checks the\nstate of sibling elements to determine if the content of the\navailable element is safe to modify.\n\n<p>The callback is executed with a single parameter:\nthe custom object parameter, if provided.</p>",
     "!url": "http://yuilibrary.com/classes/Event.html#method_onContentReady"
    },
    "attach": {
     "!type": "fn(type: string, fn: fn(), el: string, context: yui.Object, args: bool) -> +event_custom.EventHandle",
     "!doc": "Adds an event listener",
     "!url": "http://yuilibrary.com/classes/Event.html#method_attach"
    },
    "detach": {
     "!type": "fn(node: node.Node, subscription: yui.Array, notifier: bool)",
     "!doc": "Detaches all event subscriptions set up by the event-tap module",
     "!url": "http://yuilibrary.com/classes/Event.html#method_detach"
    },
    "getEvent": {
     "!type": "fn(e: event.Event, el: HTMLElement) -> +event.Event",
     "!doc": "Finds the event in the window object, the caller's arguments, or\nin the arguments of another method in the callstack.  This is\nexecuted automatically for events registered through the event\nmanager, so the implementer should not normally need to execute\nthis function at all.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_getEvent"
    },
    "generateId": {
     "!type": "fn(el) -> string",
     "!doc": "Generates an unique ID for the element if it does not already\nhave one.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_generateId"
    },
    "purgeElement": {
     "!type": "fn(el: HTMLElement, recurse: bool, type: string)",
     "!doc": "Removes all listeners attached to the given element via addListener.\nOptionally, the node's children can also be purged.\nOptionally, you can specify a specific type of event to remove.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_purgeElement"
    },
    "getListeners": {
     "!type": "fn(el: HTMLElement, type: string) -> +event_custom.CustomEvent",
     "!doc": "Returns all listeners attached to the given element via addListener.\nOptionally, you can specify a specific type of event to return.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_getListeners"
    },
    "defineOutside": {
     "!type": "fn(event: string, name: string)",
     "!doc": "Defines a new outside event to correspond with the given DOM event.\n\nBy default, the created synthetic event name will be the name of the event\nwith \"outside\" appended (e.g. \"click\" becomes \"clickoutside\"). If you want\na different name for the created Event, pass it as a second argument like so:\n<code>Y.Event.defineOutside(eventType, \"yonderclick\")</code>.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_defineOutside"
    },
    "define": {
     "!type": "fn(type: string, config: yui.Object, force: bool) -> +event.SyntheticEvent",
     "!doc": "<p>Defines a new event in the DOM event system.  Implementers are\nresponsible for monitoring for a scenario whereby the event is fired.  A\nnotifier object is provided to the functions identified below.  When the\ncriteria defining the event are met, call notifier.fire( [args] ); to\nexecute event subscribers.</p>\n\n<p>The first parameter is the name of the event.  The second parameter is a\nconfiguration object which define the behavior of the event system when the\nnew event is subscribed to or detached from.  The methods that should be\ndefined in this configuration object are <code>on</code>,\n<code>detach</code>, <code>delegate</code>, and <code>detachDelegate</code>.\nYou are free to define any other methods or properties needed to define your\nevent.  Be aware, however, that since the object is used to subclass\nSyntheticEvent, you should avoid method names used by SyntheticEvent unless\nyour intention is to override the default behavior.</p>\n\n<p>This is a list of properties and methods that you can or should specify\nin the configuration object:</p>\n\n<dl>\n  <dt><code>on</code></dt>\n      <dd><code>function (node, subscription, notifier)</code> The\n      implementation logic for subscription.  Any special setup you need to\n      do to create the environment for the event being fired--E.g. native\n      DOM event subscriptions.  Store subscription related objects and\n      state on the <code>subscription</code> object.  When the\n      criteria have been met to fire the synthetic event, call\n      <code>notifier.fire(e)</code>.  See Notifier's <code>fire()</code>\n      method for details about what to pass as parameters.</dd>\n\n  <dt><code>detach</code></dt>\n      <dd><code>function (node, subscription, notifier)</code> The\n      implementation logic for cleaning up a detached subscription. E.g.\n      detach any DOM subscriptions added in <code>on</code>.</dd>\n\n  <dt><code>delegate</code></dt>\n      <dd><code>function (node, subscription, notifier, filter)</code> The\n      implementation logic for subscription via <code>Y.delegate</code> or\n      <code>node.delegate</code>.  The filter is typically either a selector\n      string or a function.  You can use\n      <code>Y.delegate.compileFilter(selectorString)</code> to create a\n      filter function from a selector string if needed.  The filter function\n      expects an event object as input and should output either null, a\n      matching Node, or an array of matching Nodes.  Otherwise, this acts\n      like <code>on</code> DOM event subscriptions.  Store subscription\n      related objects and information on the <code>subscription</code>\n      object.  When the criteria have been met to fire the synthetic event,\n      call <code>notifier.fire(e)</code> as noted above.</dd>\n\n  <dt><code>detachDelegate</code></dt>\n      <dd><code>function (node, subscription, notifier)</code> The\n      implementation logic for cleaning up a detached delegate subscription.\n      E.g. detach any DOM delegate subscriptions added in\n      <code>delegate</code>.</dd>\n\n  <dt><code>publishConfig</code></dt>\n      <dd>(Object) The configuration object that will be used to instantiate\n      the underlying CustomEvent. See Notifier's <code>fire</code> method\n      for details.</dd>\n\n  <dt><code>processArgs</code></dt\n      <dd>\n         <p><code>function (argArray, fromDelegate)</code> Optional method\n         to extract any additional arguments from the subscription\n         signature.  Using this allows <code>on</code> or\n         <code>delegate</code> signatures like\n         <code>node.on(&quot;hover&quot;, overCallback,\n         outCallback)</code>.</p>\n         <p>When processing an atypical argument signature, make sure the\n         args array is returned to the normal signature before returning\n         from the function.  For example, in the &quot;hover&quot; example\n         above, the <code>outCallback</code> needs to be <code>splice</code>d\n         out of the array.  The expected signature of the args array for\n         <code>on()</code> subscriptions is:</p>\n         <pre>\n             <code>[type, callback, target, contextOverride, argN...]</code>\n         </pre>\n         <p>And for <code>delegate()</code>:</p>\n         <pre>\n             <code>[type, callback, target, filter, contextOverride, argN...]</code>\n         </pre>\n         <p>where <code>target</code> is the node the event is being\n         subscribed for.  You can see these signatures documented for\n         <code>Y.on()</code> and <code>Y.delegate()</code> respectively.</p>\n         <p>Whatever gets returned from the function will be stored on the\n         <code>subscription</code> object under\n         <code>subscription._extra</code>.</p></dd>\n  <dt><code>subMatch</code></dt>\n      <dd>\n          <p><code>function (sub, args)</code>  Compares a set of\n          subscription arguments against a Subscription object to determine\n          if they match.  The default implementation compares the callback\n          function against the second argument passed to\n          <code>Y.on(...)</code> or <code>node.detach(...)</code> etc.</p>\n      </dd>\n</dl>",
     "!url": "http://yuilibrary.com/classes/Event.html#method_define"
    },
    "prototype": {
     "tap": {
      "!type": "fn(type: string, fn: fn()) -> +event_custom.EventHandle",
      "!doc": "Sets up a \"tap\" event, that is fired on touch devices in response to a tap event (finger down, finder up).\nThis event can be used instead of listening for click events which have a 500ms delay on most touch devices.\nThis event can also be listened for using node.delegate().",
      "!url": "http://yuilibrary.com/classes/Event.html#event_tap"
     }
    },
    "on": {
     "!type": "fn(node: node.Node, subscription: yui.Array, notifier: bool)",
     "!doc": "This function should set up the node that will eventually fire the event.\n\nUsage:\n\n    node.on('tap', function (e) {\n        Y.log('the node was tapped on');\n    });",
     "!url": "http://yuilibrary.com/classes/Event.html#method_on"
    },
    "detachDelegate": {
     "!type": "fn(node: node.Node, subscription: yui.Array, notifier: bool)",
     "!doc": "Detaches the delegated event subscriptions set up by the event-tap module.\nOnly used if you use node.delegate(...) instead of node.on(...);",
     "!url": "http://yuilibrary.com/classes/Event.html#method_detachDelegate"
    }
   },
   "delegate": {
    "!type": "fn(type: string, fn: fn(), el: string, filter: string, context, args) -> +event_custom.EventHandle",
    "!doc": "Sets up event delegation on a container element.  The delegated event\nwill use a supplied filter to test if the callback should be executed.\nThis filter can be either a selector string or a function that returns\na Node to use as the currentTarget for the event.\n\nThe event object for the delegated event is supplied to the callback\nfunction.  It is modified slightly in order to support all properties\nthat may be needed for event delegation.  'currentTarget' is set to\nthe element that matched the selector string filter or the Node returned\nfrom the filter function.  'container' is set to the element that the\nlistener is delegated from (this normally would be the 'currentTarget').\n\nFilter functions will be called with the arguments that would be passed to\nthe callback function, including the event object as the first parameter.\nThe function should return false (or a falsey value) if the success criteria\naren't met, and the Node to use as the event's currentTarget and 'this'\nobject if they are.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_delegate"
   },
   "DOMEventFacade": {
    "!type": "fn(ev: event.Event, currentTarget: HTMLElement, wrapper: event_custom.CustomEvent)",
    "!doc": "Wraps a DOM event, properties requiring browser abstraction are\nfixed here.  Provids a security layer when required.",
    "!url": "http://yuilibrary.com/classes/DOMEventFacade.html",
    "prototype": {
     "touches": {
      "!type": "[+event.DOMEventFacade]",
      "!doc": "Array of individual touch events for touch points that are still in\ncontact with the touch surface.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_touches"
     },
     "targetTouches": {
      "!type": "[+event.DOMEventFacade]",
      "!doc": "Array of individual touch events still in contact with the touch\nsurface and whose `touchstart` event occurred inside the same taregt\nelement as the current target element.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_targetTouches"
     },
     "changedTouches": {
      "!type": "[+event.DOMEventFacade]",
      "!doc": "An array of event-specific touch events.\n\nFor `touchstart`, the touch points that became active with the current\nevent.\n\nFor `touchmove`, the touch points that have changed since the last\nevent.\n\nFor `touchend`, the touch points that have been removed from the touch\nsurface.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_changedTouches"
     },
     "type": {
      "!type": "string",
      "!doc": "The name of the event (e.g. \"click\")",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_type"
     },
     "altKey": {
      "!type": "bool",
      "!doc": "`true` if the \"alt\" or \"option\" key is pressed.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_altKey"
     },
     "shiftKey": {
      "!type": "bool",
      "!doc": "`true` if the shift key is pressed.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_shiftKey"
     },
     "metaKey": {
      "!type": "bool",
      "!doc": "`true` if the \"Windows\" key on a Windows keyboard, \"command\" key on an\nApple keyboard, or \"meta\" key on other keyboards is pressed.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_metaKey"
     },
     "ctrlKey": {
      "!type": "bool",
      "!doc": "`true` if the \"Ctrl\" or \"control\" key is pressed.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_ctrlKey"
     },
     "pageX": {
      "!type": "number",
      "!doc": "The X location of the event on the page (including scroll)",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_pageX"
     },
     "pageY": {
      "!type": "number",
      "!doc": "The Y location of the event on the page (including scroll)",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_pageY"
     },
     "clientX": {
      "!type": "number",
      "!doc": "The X location of the event in the viewport",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_clientX"
     },
     "clientY": {
      "!type": "number",
      "!doc": "The Y location of the event in the viewport",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_clientY"
     },
     "keyCode": {
      "!type": "number",
      "!doc": "The keyCode for key events.  Uses charCode if keyCode is not available",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_keyCode"
     },
     "charCode": {
      "!type": "number",
      "!doc": "The charCode for key events.  Same as keyCode",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_charCode"
     },
     "button": {
      "!type": "number",
      "!doc": "The button that was pushed. 1 for left click, 2 for middle click, 3 for\nright click.  This is only reliably populated on `mouseup` events.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_button"
     },
     "which": {
      "!type": "number",
      "!doc": "The button that was pushed.  Same as button.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_which"
     },
     "target": {
      "!type": "+node.Node",
      "!doc": "Node reference for the targeted element",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_target"
     },
     "currentTarget": {
      "!type": "+node.Node",
      "!doc": "Node reference for the element that the listener was attached to.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_currentTarget"
     },
     "relatedTarget": {
      "!type": "+node.Node",
      "!doc": "Node reference to the relatedTarget",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_relatedTarget"
     },
     "wheelDelta": {
      "!type": "number",
      "!doc": "Number representing the direction and velocity of the movement of the mousewheel.\nNegative is down, the higher the number, the faster.  Applies to the mousewheel event.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property_wheelDelta"
     },
     "stopPropagation": {
      "!type": "fn()",
      "!doc": "Stops the propagation to the next bubble target",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#method_stopPropagation"
     },
     "stopImmediatePropagation": {
      "!type": "fn()",
      "!doc": "Stops the propagation to the next bubble target and\nprevents any additional listeners from being exectued\non the current target.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#method_stopImmediatePropagation"
     },
     "preventDefault": {
      "!type": "fn(returnValue: string)",
      "!doc": "Prevents the event's default behavior",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#method_preventDefault"
     },
     "halt": {
      "!type": "fn(immediate: bool)",
      "!doc": "Stops the event propagation and prevents the default\nevent behavior.",
      "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#method_halt"
     }
    },
    "_GESTURE_MAP": {
     "!type": "+yui.Object",
     "!doc": "A object literal with keys \"start\", \"end\", and \"move\". The value for each key is a\nstring representing the event for that environment. For touch environments, the respective\nvalues are \"touchstart\", \"touchend\" and \"touchmove\". Mouse and MSPointer environments are also\nsupported via feature detection.",
     "!url": "http://yuilibrary.com/classes/DOMEventFacade.html#property__GESTURE_MAP"
    }
   },
   "domready": {
    "!type": "fn()",
    "!doc": "The domready event fires at the moment the browser's DOM is\nusable. In most cases, this is before images are fully\ndownloaded, allowing you to provide a more responsive user\ninterface.\n\nIn YUI 3, domready subscribers will be notified immediately if\nthat moment has already passed when the subscription is created.\n\nOne exception is if the yui.js file is dynamically injected into\nthe page.  If this is done, you must tell the YUI instance that\nyou did this in order for DOMReady (and window load events) to\nfire normally.  That configuration option is 'injected' -- set\nit to true if the yui.js script is not included inline.\n\nThis method is part of the 'event-ready' module, which is a\nsubmodule of 'event'.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_domready"
   },
   "key": {
    "!type": "fn(type: string, fn: fn(), id: string, spec: string, o, args) -> +Event.Handle",
    "!doc": "<p>Add a key listener.  The listener will only be notified if the\nkeystroke detected meets the supplied specification.  The\nspecification is a string that is defined as:</p>\n\n<dl>\n  <dt>spec</dt>\n  <dd><code>[{type}:]{code}[,{code}]*</code></dd>\n  <dt>type</dt>\n  <dd><code>\"down\", \"up\", or \"press\"</code></dd>\n  <dt>code</dt>\n  <dd><code>{keyCode|character|keyName}[+{modifier}]*</code></dd>\n  <dt>modifier</dt>\n  <dd><code>\"shift\", \"ctrl\", \"alt\", or \"meta\"</code></dd>\n  <dt>keyName</dt>\n  <dd><code>\"enter\", \"space\", \"backspace\", \"esc\", \"tab\", \"pageup\", or \"pagedown\"</code></dd>\n</dl>\n\n<p>Examples:</p>\n<ul>\n  <li><code>Y.on(\"key\", callback, \"press:12,65+shift+ctrl\", \"#my-input\");</code></li>\n  <li><code>Y.delegate(\"key\", preventSubmit, \"#forms\", \"enter\", \"input[type=text]\");</code></li>\n  <li><code>Y.one(\"doc\").on(\"key\", viNav, \"j,k,l,;\");</code></li>\n</ul>",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_key"
   },
   "mousewheel": {
    "!type": "fn(type: string, fn: fn(), context, args) -> +event_custom.EventHandle",
    "!doc": "Mousewheel event.  This listener is automatically attached to the\ncorrect target, so one should not be supplied.  Mouse wheel\ndirection and velocity is stored in the 'wheelDelta' field.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_mousewheel"
   },
   "windowresize": {
    "!type": "fn()",
    "!doc": "Old firefox fires the window resize event once when the resize action\nfinishes, other browsers fire the event periodically during the\nresize.  This code uses timeout logic to simulate the Firefox\nbehavior in other browsers.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_windowresize"
   },
   "SynthRegistry": {
    "!type": "fn(el: HTMLElement, yuid: string, key: string) -> +event.SynthRegistry",
    "!doc": "Manager object for synthetic event subscriptions to aggregate multiple synths on the\nsame node without colliding with actual DOM subscription entries in the global map of\nDOM subscriptions.  Also facilitates proper cleanup on page unload.",
    "!url": "http://yuilibrary.com/classes/SynthRegistry.html",
    "prototype": {
     "register": {
      "!type": "fn(handle: event_custom.EventHandle)",
      "!doc": "Adds a subscription from the Notifier registry.",
      "!url": "http://yuilibrary.com/classes/SynthRegistry.html#method_register"
     },
     "_unregisterSub": {
      "!type": "fn(sub: Subscription)",
      "!doc": "Removes the subscription from the Notifier registry.",
      "!url": "http://yuilibrary.com/classes/SynthRegistry.html#method__unregisterSub"
     }
    }
   },
   "SyntheticEvent": {
    "!type": "fn(cfg: yui.Object) -> +event.SyntheticEvent",
    "!doc": "<p>Wrapper class for the integration of new events into the YUI event\ninfrastructure.  Don't instantiate this object directly, use\n<code>Y.Event.define(type, config)</code>.  See that method for details.</p>\n\n<p>Properties that MAY or SHOULD be specified in the configuration are noted\nbelow and in the description of <code>Y.Event.define</code>.</p>",
    "!url": "http://yuilibrary.com/classes/SyntheticEvent.html",
    "prototype": {
     "processArgs": {
      "!type": "fn(args: yui.Array, delegate: bool) -> +Any",
      "!doc": "<p>Implementers MAY provide this method definition.</p>\n\n<p>Implement this function if the event supports a different\nsubscription signature.  This function is used by both\n<code>on()</code> and <code>delegate()</code>.  The second parameter\nindicates that the event is being subscribed via\n<code>delegate()</code>.</p>\n\n<p>Implementations must remove extra arguments from the args list\nbefore returning.  The required args for <code>on()</code>\nsubscriptions are</p>\n<pre><code>[type, callback, target, context, argN...]</code></pre>\n\n<p>The required args for <code>delegate()</code>\nsubscriptions are</p>\n\n<pre><code>[type, callback, target, filter, context, argN...]</code></pre>\n\n<p>The return value from this function will be stored on the\nsubscription in the '_extra' property for reference elsewhere.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_processArgs"
     },
     "preventDups": {
      "!type": "bool",
      "!doc": "<p>Implementers MAY override this property.</p>\n\n<p>Whether to prevent multiple subscriptions to this event that are\nclassified as being the same.  By default, this means the subscribed\ncallback is the same function.  See the <code>subMatch</code>\nmethod.  Setting this to true will impact performance for high volume\nevents.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#property_preventDups"
     },
     "on": {
      "!type": "fn(node: node.Node, sub: Subscription, notifier: event.SyntheticEvent.Notifier)",
      "!doc": "<p>Implementers SHOULD provide this method definition.</p>\n\nImplementation logic for subscriptions done via <code>node.on(type,\nfn)</code> or <code>Y.on(type, fn, target)</code>.  This\nfunction should set up the monitor(s) that will eventually fire the\nevent.  Typically this involves subscribing to at least one DOM\nevent.  It is recommended to store detach handles from any DOM\nsubscriptions to make for easy cleanup in the <code>detach</code>\nmethod.  Typically these handles are added to the <code>sub</code>\nobject.  Also for SyntheticEvents that leverage a single DOM\nsubscription under the hood, it is recommended to pass the DOM event\nobject to <code>notifier.fire(e)</code>.  (The event name on the\nobject will be updated).",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_on"
     },
     "detach": {
      "!type": "fn(node: node.Node, sub: Subscription, notifier: event.SyntheticEvent.Notifier)",
      "!doc": "<p>Implementers SHOULD provide this method definition.</p>\n\n<p>Implementation logic for detaching subscriptions done via\n<code>node.on(type, fn)</code>.  This function should clean up any\nsubscriptions made in the <code>on()</code> phase.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_detach"
     },
     "delegate": {
      "!type": "fn(node: node.Node, sub: Subscription, notifier: event.SyntheticEvent.Notifier, filter: string)",
      "!doc": "<p>Implementers SHOULD provide this method definition.</p>\n\n<p>Implementation logic for subscriptions done via\n<code>node.delegate(type, fn, filter)</code> or\n<code>Y.delegate(type, fn, container, filter)</code>.  Like with\n<code>on()</code> above, this function should monitor the environment\nfor the event being fired, and trigger subscription execution by\ncalling <code>notifier.fire(e)</code>.</p>\n\n<p>This function receives a fourth argument, which is the filter\nused to identify which Node's are of interest to the subscription.\nThe filter will be either a boolean function that accepts a target\nNode for each hierarchy level as the event bubbles, or a selector\nstring.  To translate selector strings into filter functions, use\n<code>Y.delegate.compileFilter(filter)</code>.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_delegate"
     },
     "detachDelegate": {
      "!type": "fn(node: node.Node, sub: Subscription, notifier: event.SyntheticEvent.Notifier, filter: string)",
      "!doc": "<p>Implementers SHOULD provide this method definition.</p>\n\n<p>Implementation logic for detaching subscriptions done via\n<code>node.delegate(type, fn, filter)</code> or\n<code>Y.delegate(type, fn, container, filter)</code>.  This function\nshould clean up any subscriptions made in the\n<code>delegate()</code> phase.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_detachDelegate"
     },
     "applyArgExtras": {
      "!type": "fn(extra: Any, sub: Subscription)",
      "!doc": "<p>Implementers MAY provide this method definition.</p>\n\n<p>Implement this function if you want extra data extracted during\nprocessArgs to be propagated to subscriptions on a per-node basis.\nThat is to say, if you call <code>Y.on('xyz', fn, xtra, 'div')</code>\nthe data returned from processArgs will be shared\nacross the subscription objects for all the divs.  If you want each\nsubscription to receive unique information, do that processing\nhere.</p>\n\n<p>The default implementation adds the data extracted by processArgs\nto the subscription object as <code>sub._extra</code>.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_applyArgExtras"
     },
     "getSubs": {
      "!type": "fn(node: node.Node, args: yui.Array, filter: fn(), first: bool) -> [+event_custom.EventHandle]",
      "!doc": "Returns the detach handles of subscriptions on a node that satisfy a\nsearch/filter function.  By default, the filter used is the\n<code>subMatch</code> method.",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_getSubs"
     },
     "subMatch": {
      "!type": "fn(sub: Subscription, args: yui.Array) -> bool",
      "!doc": "<p>Implementers MAY override this to define what constitutes a\n&quot;same&quot; subscription.  Override implementations should\nconsider the lack of a comparator as a match, so calling\n<code>getSubs()</code> with no arguments will return all subs.</p>\n\n<p>Compares a set of subscription arguments against a Subscription\nobject to determine if they match.  The default implementation\ncompares the callback function against the second argument passed to\n<code>Y.on(...)</code> or <code>node.detach(...)</code> etc.</p>",
      "!url": "http://yuilibrary.com/classes/SyntheticEvent.html#method_subMatch"
     }
    }
   }
  },
  "file_flash": {
   "FileFlash": {
    "!type": "fn(config: yui.Object) -> +file_flash.FileFlash",
    "!proto": "base.Base",
    "!doc": "The class provides a wrapper for a file pointer in Flash.",
    "!url": "http://yuilibrary.com/classes/FileFlash.html",
    "prototype": {
     "uploadstart": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has started.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#event_uploadstart"
     },
     "uploadprogress": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that progress has been made on the upload of this file.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#event_uploadprogress"
     },
     "uploadfinished": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has completed, but data has not yet been received from the server.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#event_uploadfinished"
     },
     "uploadcomplete": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has completed and data has been received from the server.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#event_uploadcomplete"
     },
     "uploadcancel": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has been cancelled.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#event_uploadcancel"
     },
     "uploaderror": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has encountered an error.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#event_uploaderror"
     },
     "startUpload": {
      "!type": "fn(url: string, parameters: yui.Object, fileFieldName: string)",
      "!doc": "Starts the upload of a specific file.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#method_startUpload"
     },
     "cancelUpload": {
      "!type": "fn()",
      "!doc": "Cancels the upload of a specific file, if currently in progress.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#method_cancelUpload"
     },
     "id": {
      "!type": "fn()",
      "!doc": "A String containing the unique id of the file wrapped by the FileFlash instance.\nThe id is supplied by the Flash player uploader.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_id"
     },
     "size": {
      "!type": "fn()",
      "!doc": "The size of the file wrapped by FileFlash. This value is supplied by the Flash player uploader.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_size"
     },
     "name": {
      "!type": "fn()",
      "!doc": "The name of the file wrapped by FileFlash. This value is supplied by the Flash player uploader.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_name"
     },
     "dateCreated": {
      "!type": "fn()",
      "!doc": "The date that the file wrapped by FileFlash was created on. This value is supplied by the Flash player uploader.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_dateCreated"
     },
     "dateModified": {
      "!type": "fn()",
      "!doc": "The date that the file wrapped by FileFlash was last modified on. This value is supplied by the Flash player uploader.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_dateModified"
     },
     "bytesUploaded": {
      "!type": "fn()",
      "!doc": "The number of bytes of the file that has been uploaded to the server. This value is\nnon-zero only while a file is being uploaded.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_bytesUploaded"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the file wrapped by FileFlash. This value is provided by the Flash player\nuploader.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_type"
     },
     "uploder": {
      "!type": "fn()",
      "!doc": "The instance of Y.SWF wrapping the Flash player uploader associated with this file.",
      "!url": "http://yuilibrary.com/classes/FileFlash.html#attribute_uploder"
     }
    }
   }
  },
  "file_html5": {
   "FileHTML5": {
    "!type": "fn(config: yui.Object) -> +file_html5.FileHTML5",
    "!proto": "base.Base",
    "!doc": "The class provides a wrapper for a file pointer.",
    "!url": "http://yuilibrary.com/classes/FileHTML5.html",
    "prototype": {
     "uploadprogress": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that progress has been made on the upload of this file.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#event_uploadprogress"
     },
     "uploadcomplete": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has completed and data has been received from the server.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#event_uploadcomplete"
     },
     "uploaderror": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has encountered an error.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#event_uploaderror"
     },
     "uploadcancel": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has been cancelled.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#event_uploadcancel"
     },
     "readystatechange": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that XMLHttpRequest has fired a readystatechange event.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#event_readystatechange"
     },
     "startUpload": {
      "!type": "fn(url: string, parameters: yui.Object, fileFieldName: string)",
      "!doc": "Starts the upload of a specific file.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#method_startUpload"
     },
     "uploadstart": {
      "!type": "fn(event: event.Event)",
      "!doc": "Signals that this file's upload has started.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#event_uploadstart"
     },
     "cancelUpload": {
      "!type": "fn()",
      "!doc": "Cancels the upload of a specific file, if currently in progress.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#method_cancelUpload"
     },
     "id": {
      "!type": "fn()",
      "!doc": "A String containing the unique id of the file wrapped by the FileFlash instance.\nThe id is supplied by the Flash player uploader.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_id"
     },
     "size": {
      "!type": "fn()",
      "!doc": "The size of the file wrapped by FileHTML5. This value is supplied by the instance of File().",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_size"
     },
     "name": {
      "!type": "fn()",
      "!doc": "The name of the file wrapped by FileHTML5. This value is supplied by the instance of File().",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_name"
     },
     "dateCreated": {
      "!type": "fn()",
      "!doc": "The date that the file wrapped by FileHTML5 was created on. This value is supplied by the instance of File().",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_dateCreated"
     },
     "dateModified": {
      "!type": "fn()",
      "!doc": "The date that the file wrapped by FileHTML5 was last modified on. This value is supplied by the instance of File().",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_dateModified"
     },
     "bytesUploaded": {
      "!type": "fn()",
      "!doc": "The number of bytes of the file that has been uploaded to the server. This value is\nnon-zero only while a file is being uploaded.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_bytesUploaded"
     },
     "type": {
      "!type": "fn()",
      "!doc": "The type of the file wrapped by FileHTML. This value is provided by the instance of File()",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_type"
     },
     "file": {
      "!type": "fn()",
      "!doc": "The pointer to the instance of File() wrapped by FileHTML5.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_file"
     },
     "xhr": {
      "!type": "fn()",
      "!doc": "The pointer to the instance of XMLHttpRequest used by FileHTML5 to upload the file.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_xhr"
     },
     "xhrHeaders": {
      "!type": "fn()",
      "!doc": "The dictionary of headers that should be set on the XMLHttpRequest object before\nsending it.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_xhrHeaders"
     },
     "xhrWithCredentials": {
      "!type": "fn()",
      "!doc": "A Boolean indicating whether the XMLHttpRequest should be sent with user credentials.\nThis does not affect same-site requests.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_xhrWithCredentials"
     },
     "boundEventHandler": {
      "!type": "fn()",
      "!doc": "The bound event handler used to handle events from XMLHttpRequest.",
      "!url": "http://yuilibrary.com/classes/FileHTML5.html#attribute_boundEventHandler"
     }
    },
    "isValidFile": {
     "!type": "fn(file: file.File)",
     "!doc": "Checks whether a specific native file instance is valid",
     "!url": "http://yuilibrary.com/classes/FileHTML5.html#method_isValidFile"
    },
    "canUpload": {
     "!type": "fn()",
     "!doc": "Checks whether the browser has a native upload capability\nvia XMLHttpRequest Level 2.",
     "!url": "http://yuilibrary.com/classes/FileHTML5.html#method_canUpload"
    }
   }
  },
  "gesture_simulate": {
   "Event": {
    "!type": "fn()",
    "!doc": "The event utility provides functions to add and remove event listeners,\nevent cleansing.  It also tries to automatically remove listeners it\nregisters during the unload event.",
    "!url": "http://yuilibrary.com/classes/Event.html",
    "prototype": {
     "rotate": {
      "!type": "fn(cb: fn(), center: yui.Array, startRadius: number, endRadius: number, duration: number, start: number, rotation: number)",
      "!doc": "The \"rotate\" and \"pinch\" methods are essencially same with the exact same\narguments. Only difference is the required parameters. The rotate method\nrequires \"rotation\" parameter while the pinch method requires \"startRadius\"\nand \"endRadius\" parameters.",
      "!url": "http://yuilibrary.com/classes/Event.html#method_rotate"
     },
     "pinch": {
      "!type": "fn(cb: fn(), center: yui.Array, startRadius: number, endRadius: number, duration: number, start: number, rotation: number)",
      "!doc": "The \"rotate\" and \"pinch\" methods are essencially same with the exact same\narguments. Only difference is the required parameters. The rotate method\nrequires \"rotation\" parameter while the pinch method requires \"startRadius\"\nand \"endRadius\" parameters.\n\nThe \"pinch\" gesture can simulate various 2 finger gestures such as pinch,\nspread and/or rotation. The \"startRadius\" and \"endRadius\" are required.\nIf endRadius is larger than startRadius, it becomes a spread gesture\notherwise a pinch gesture.",
      "!url": "http://yuilibrary.com/classes/Event.html#method_pinch"
     },
     "tap": {
      "!type": "fn(cb: fn(), point: yui.Array, times: number, hold: number, delay: number)",
      "!doc": "The \"tap\" gesture can be used for various single touch point gestures\nsuch as single tap, N number of taps, long press. The default is a single\ntap.",
      "!url": "http://yuilibrary.com/classes/Event.html#method_tap"
     },
     "flick": {
      "!type": "fn(cb: fn(), point: yui.Array, axis: string, distance: number, duration: number)",
      "!doc": "The \"flick\" gesture is a specialized \"move\" that has some velocity\nand the movement always runs either x or y axis. The velocity is calculated\nwith \"distance\" and \"duration\" arguments. If the calculated velocity is\nbelow than the minimum velocity, the given duration will be ignored and\nnew duration will be created to make a valid flick gesture.",
      "!url": "http://yuilibrary.com/classes/Event.html#method_flick"
     },
     "move": {
      "!type": "fn(cb: fn(), path: yui.Object, duration: number)",
      "!doc": "The \"move\" gesture simulate the movement of any direction between\nthe straight line of start and end point for the given duration.\nThe path argument is an object with \"point\", \"xdist\" and \"ydist\" properties.\nThe \"point\" property is an array with x and y coordinations(relative to the\ntop left corner of the target node element) while \"xdist\" and \"ydist\"\nproperties are used for the distance along the x and y axis. A negative\ndistance number can be used to drag either left or up direction.\n\nIf no arguments are given, it will simulate the default move, which\nis moving 200 pixels from the center of the element to the positive X-axis\ndirection for 1 sec.",
      "!url": "http://yuilibrary.com/classes/Event.html#method_move"
     }
    },
    "simulateGesture": {
     "!type": "fn(node: HTMLElement, name: string, options?: yui.Object, cb?: fn())",
     "!doc": "Simulates the higher user level gesture of the given name on a target.\nThis method generates a set of low level touch events(Apple specific gesture\nevents as well for the iOS platforms) asynchronously. Note that gesture\nsimulation is relying on `Y.Event.simulate()` method to generate\nthe touch events under the hood. The `Y.Event.simulate()` method\nitself is a synchronous method.\n\nUsers are suggested to use `Node.simulateGesture()` method which\nbasically calls this method internally. Supported gestures are `tap`,\n`doubletap`, `press`, `move`, `flick`, `pinch` and `rotate`.\n\nThe `pinch` gesture is used to simulate the pinching and spreading of two\nfingers. During a pinch simulation, rotation is also possible. Essentially\n`pinch` and `rotate` simulations share the same base implementation to allow\nboth pinching and rotation at the same time. The only difference is `pinch`\nrequires `start` and `end` option properties while `rotate` requires `rotation`\noption property.\n\nThe `pinch` and `rotate` gestures can be described as placing 2 fingers along a\ncircle. Pinching and spreading can be described by start and end circles while\nrotation occurs on a single circle. If the radius of the start circle is greater\nthan the end circle, the gesture becomes a pinch, otherwise it is a spread spread.",
     "!url": "http://yuilibrary.com/classes/Event.html#method_simulateGesture"
    }
   }
  },
  "get_nodejs": {
   "GetNodeJS": {
    "!type": "fn()",
    "!doc": "NodeJS specific Get module used to load remote resources.\nIt contains the same signature as the default Get module so there is no code change needed.",
    "!url": "http://yuilibrary.com/classes/GetNodeJS.html",
    "prototype": {
     "js": {
      "!type": "fn(s: yui.Array, options: yui.Object)",
      "!doc": "Override for Get.script for loading local or remote YUI modules.",
      "!url": "http://yuilibrary.com/classes/GetNodeJS.html#method_js"
     },
     "script": {
      "!type": "fn()",
      "!doc": "Alias for `Y.Get.js`",
      "!url": "http://yuilibrary.com/classes/GetNodeJS.html#method_script"
     }
    }
   }
  },
  "get": {
   "Get": {
    "!type": "fn()",
    "!doc": "Provides dynamic loading of remote JavaScript and CSS resources.",
    "!url": "http://yuilibrary.com/classes/Get.html",
    "cssOptions": {
     "!type": "+yui.Object",
     "!doc": "Default options for CSS requests. Options specified here will override\nglobal defaults for CSS requests.\n\nSee the `options` property for all available options.",
     "!url": "http://yuilibrary.com/classes/Get.html#property_cssOptions"
    },
    "jsOptions": {
     "!type": "+yui.Object",
     "!doc": "Default options for JS requests. Options specified here will override global\ndefaults for JS requests.\n\nSee the `options` property for all available options.",
     "!url": "http://yuilibrary.com/classes/Get.html#property_jsOptions"
    },
    "options": {
     "!type": "+yui.Object",
     "!doc": "Default options to use for all requests.\n\nNote that while all available options are documented here for ease of\ndiscovery, some options (like callback functions) only make sense at the\ntransaction level.\n\nCallback functions specified via the options object or the `options`\nparameter of the `css()`, `js()`, or `load()` methods will receive the\ntransaction object as a parameter. See `Y.Get.Transaction` for details on\nthe properties and methods available on transactions.",
     "!url": "http://yuilibrary.com/classes/Get.html#property_options"
    },
    "abort": {
     "!type": "fn(transaction: get.Get.Transaction)",
     "!doc": "Aborts the specified transaction.\n\nThis will cause the transaction's `onFailure` callback to be called and\nwill prevent any new script and link nodes from being added to the document,\nbut any resources that have already been requested will continue loading\n(there's no safe way to prevent this, unfortunately).\n\n*Note:* This method is deprecated as of 3.5.0, and will be removed in a\nfuture version of YUI. Use the transaction-level `abort()` method instead.",
     "!url": "http://yuilibrary.com/classes/Get.html#method_abort"
    },
    "css": {
     "!type": "fn(urls: string, options?: yui.Object, callback?: fn()) -> +get.Get.Transaction",
     "!doc": "Loads one or more CSS files.\n\nThe _urls_ parameter may be provided as a URL string, a request object,\nor an array of URL strings and/or request objects.\n\nA request object is just an object that contains a `url` property and zero\nor more options that should apply specifically to that request.\nRequest-specific options take priority over transaction-level options and\ndefault options.\n\nURLs may be relative or absolute, and do not have to have the same origin\nas the current page.\n\nThe `options` parameter may be omitted completely and a callback passed in\nits place, if desired.",
     "!url": "http://yuilibrary.com/classes/Get.html#method_css"
    },
    "js": {
     "!type": "fn(urls: string, options?: yui.Object, callback?: fn()) -> +get.Get.Transaction",
     "!doc": "Loads one or more JavaScript resources.\n\nThe _urls_ parameter may be provided as a URL string, a request object,\nor an array of URL strings and/or request objects.\n\nA request object is just an object that contains a `url` property and zero\nor more options that should apply specifically to that request.\nRequest-specific options take priority over transaction-level options and\ndefault options.\n\nURLs may be relative or absolute, and do not have to have the same origin\nas the current page.\n\nThe `options` parameter may be omitted completely and a callback passed in\nits place, if desired.\n\nScripts will be executed in the order they're specified unless the `async`\noption is `true`, in which case they'll be loaded in parallel and executed\nin whatever order they finish loading.",
     "!url": "http://yuilibrary.com/classes/Get.html#method_js"
    },
    "load": {
     "!type": "fn(urls: string, options?: yui.Object, callback?: fn(), err: yui.Array, Transaction: get.Get.Transaction) -> +get.Get.Transaction",
     "!doc": "Loads one or more CSS and/or JavaScript resources in the same transaction.\n\nUse this method when you want to load both CSS and JavaScript in a single\ntransaction and be notified when all requested URLs have finished loading,\nregardless of type.\n\nBehavior and options are the same as for the `css()` and `js()` methods. If\na resource type isn't specified in per-request options or transaction-level\noptions, Get will guess the file type based on the URL's extension (`.css`\nor `.js`, with or without a following query string). If the file type can't\nbe guessed from the URL, a warning will be logged and Get will assume the\nURL is a JavaScript resource.",
     "!url": "http://yuilibrary.com/classes/Get.html#method_load"
    },
    "script": {
     "!type": "fn()",
     "!doc": "Alias for `js()`.",
     "!url": "http://yuilibrary.com/classes/Get.html#method_script"
    }
   },
   "Get.Transaction": {
    "!type": "fn() -> +get.Get.Transaction",
    "!doc": "Represents a Get transaction, which may contain requests for one or more JS or\nCSS files.\n\nThis class should not be instantiated manually. Instances will be created and\nreturned as needed by Y.Get's `css()`, `js()`, and `load()` methods.",
    "!url": "http://yuilibrary.com/classes/Get.Transaction.html",
    "prototype": {
     "data": {
      "!type": "+yui.Object",
      "!doc": "Arbitrary data object associated with this transaction.\n\nThis object comes from the options passed to `Get.css()`, `Get.js()`, or\n`Get.load()`, and will be `undefined` if no data object was specified.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#property_data"
     },
     "errors": {
      "!type": "[+yui.Object]",
      "!doc": "Array of errors that have occurred during this transaction, if any. Each error\nobject has the following properties:\n`errors.error`: Error message.\n`errors.request`: Request object related to the error.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#property_errors"
     },
     "id": {
      "!type": "number",
      "!doc": "Numeric id for this transaction, unique among all transactions within the same\nYUI sandbox in the current pageview.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#property_id"
     },
     "nodes": {
      "!type": "[+HTMLElement]",
      "!doc": "HTMLElement nodes (native ones, not YUI Node instances) that have been inserted\nduring the current transaction.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#property_nodes"
     },
     "options": {
      "!type": "+yui.Object",
      "!doc": "Options associated with this transaction.\n\nSee `Get.options` for the full list of available options.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#property_options"
     },
     "requests": {
      "!type": "+yui.Object",
      "!doc": "Request objects contained in this transaction. Each request object represents\none CSS or JS URL that will be (or has been) requested and loaded into the page.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#property_requests"
     },
     "abort": {
      "!type": "fn(msg?: string)",
      "!doc": "Aborts this transaction.\n\nThis will cause the transaction's `onFailure` callback to be called and\nwill prevent any new script and link nodes from being added to the document,\nbut any resources that have already been requested will continue loading\n(there's no safe way to prevent this, unfortunately).",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#method_abort"
     },
     "execute": {
      "!type": "fn(callback: fn())",
      "!doc": "Begins execting the transaction.\n\nThere's usually no reason to call this manually, since Get will call it\nautomatically when other pending transactions have finished. If you really\nwant to execute your transaction before Get does, you can, but be aware that\nthis transaction's scripts may end up executing before the scripts in other\npending transactions.\n\nIf the transaction is already executing, the specified callback (if any)\nwill be queued and called after execution finishes. If the transaction has\nalready finished, the callback will be called immediately (the transaction\nwill not be executed again).",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#method_execute"
     },
     "purge": {
      "!type": "fn()",
      "!doc": "Manually purges any `<script>` or `<link>` nodes this transaction has\ncreated.\n\nBe careful when purging a transaction that contains CSS requests, since\nremoving `<link>` nodes will also remove any styles they applied.",
      "!url": "http://yuilibrary.com/classes/Get.Transaction.html#method_purge"
     }
    }
   }
  },
  "graphics": {
   "CanvasCircle": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> implementation of the <a href=\"Circle.html\">`Circle`</a> class.\n`CanvasCircle` is not intended to be used directly. Instead, use the <a href=\"Circle.html\">`Circle`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities but has\n<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> capabilities, the <a href=\"Circle.html\">`Circle`</a>\nclass will point to the `CanvasCircle` class.",
    "!url": "http://yuilibrary.com/classes/CanvasCircle.html",
    "prototype": {
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/CanvasCircle.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/CanvasCircle.html#config_height"
     },
     "radius": {
      "!type": "fn()",
      "!doc": "Radius of the circle",
      "!url": "http://yuilibrary.com/classes/CanvasCircle.html#config_radius"
     }
    }
   },
   "CanvasDrawing": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> implementation of the <a href=\"Drawing.html\">`Drawing`</a> class.\n`CanvasDrawing` is not intended to be used directly. Instead, use the <a href=\"Drawing.html\">`Drawing`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities but has\n<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> capabilities, the <a href=\"Drawing.html\">`Drawing`</a>\nclass will point to the `CanvasDrawing` class.",
    "!url": "http://yuilibrary.com/classes/CanvasDrawing.html",
    "prototype": {
     "lineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment from the current drawing position to the specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_lineTo"
     },
     "relativeLineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment from the current drawing position to the relative x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_relativeLineTo"
     },
     "moveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_moveTo"
     },
     "relativeMoveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position relative to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_relativeMoveTo"
     },
     "curveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_curveTo"
     },
     "relativeCurveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve relative to the current coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_relativeCurveTo"
     },
     "quadraticCurveTo": {
      "!type": "fn(cpx: number, cpy: number, x: number, y: number) -> !this",
      "!doc": "Draws a quadratic bezier curve.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_quadraticCurveTo"
     },
     "relativeQuadraticCurveTo": {
      "!type": "fn(cpx: number, cpy: number, x: number, y: number) -> !this",
      "!doc": "Draws a quadratic bezier curve relative to the current position.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_relativeQuadraticCurveTo"
     },
     "drawRect": {
      "!type": "fn(x: number, y: number, w: number, h: number, ew: number, eh: number) -> !this",
      "!doc": "Draws a rectangle with rounded corners.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_drawRect"
     },
     "end": {
      "!type": "fn() -> !this",
      "!doc": "Completes a drawing operation.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_end"
     },
     "closePath": {
      "!type": "fn() -> !this",
      "!doc": "Ends a fill and stroke",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_closePath"
     },
     "clear": {
      "!type": "fn() -> !this",
      "!doc": "Clears the graphics object.",
      "!url": "http://yuilibrary.com/classes/CanvasDrawing.html#method_clear"
     }
    }
   },
   "CanvasEllipse": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> implementation of the <a href=\"Ellipse.html\">`Ellipse`</a> class.\n`CanvasEllipse` is not intended to be used directly. Instead, use the <a href=\"Ellipse.html\">`Ellipse`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities but has\n<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> capabilities, the <a href=\"Ellipse.html\">`Ellipse`</a>\nclass will point to the `CanvasEllipse` class.",
    "!url": "http://yuilibrary.com/classes/CanvasEllipse.html",
    "prototype": {
     "xRadius": {
      "!type": "fn()",
      "!doc": "Horizontal radius for the ellipse.",
      "!url": "http://yuilibrary.com/classes/CanvasEllipse.html#config_xRadius"
     },
     "yRadius": {
      "!type": "fn()",
      "!doc": "Vertical radius for the ellipse.",
      "!url": "http://yuilibrary.com/classes/CanvasEllipse.html#config_yRadius"
     }
    }
   },
   "CanvasGraphic": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> implementation of the `Graphic` class.\n`CanvasGraphic` is not intended to be used directly. Instead, use the <a href=\"Graphic.html\">`Graphic`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities but has\n<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> capabilities, the <a href=\"Graphic.html\">`Graphic`</a>\nclass will point to the `CanvasGraphic` class.",
    "!url": "http://yuilibrary.com/classes/CanvasGraphic.html",
    "prototype": {
     "render": {
      "!type": "fn(parentNode: HTMLElement)",
      "!doc": "Adds the graphics node to the dom.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_render"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_id"
     },
     "shapes": {
      "!type": "fn()",
      "!doc": "Key value pairs in which a shape instance is associated with its id.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_shapes"
     },
     "contentBounds": {
      "!type": "fn()",
      "!doc": "Object containing size and coordinate data for the content of a Graphic in relation to the graphic instance's position.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_contentBounds"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The outermost html element of the Graphic instance.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_node"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_height"
     },
     "autoSize": {
      "!type": "fn()",
      "!doc": "Determines the sizing of the Graphic.\n\n<dl>\n    <dt>sizeContentToGraphic</dt><dd>The Graphic's width and height attributes are, either explicitly set through the\n    <code>width</code> and <code>height</code> attributes or are determined by the dimensions of the parent element. The\n    content contained in the Graphic will be sized to fit with in the Graphic instance's dimensions. When using this\n    setting, the <code>preserveAspectRatio</code> attribute will determine how the contents are sized.</dd>\n    <dt>sizeGraphicToContent</dt><dd>(Also accepts a value of true) The Graphic's width and height are determined by the\n    size and positioning of the content.</dd>\n    <dt>false</dt><dd>The Graphic's width and height attributes are, either explicitly set through the <code>width</code>\n    and <code>height</code> attributes or are determined by the dimensions of the parent element. The contents of the\n    Graphic instance are not affected by this setting.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_autoSize"
     },
     "preserveAspectRatio": {
      "!type": "fn()",
      "!doc": "Determines how content is sized when <code>autoSize</code> is set to <code>sizeContentToGraphic</code>.\n\n <dl>\n     <dt>none<dt><dd>Do not force uniform scaling. Scale the graphic content of the given element non-uniformly if necessary\n     such that the element's bounding box exactly matches the viewport rectangle.</dd>\n     <dt>xMinYMin</dt><dd>Force uniform scaling position along the top left of the Graphic's node.</dd>\n     <dt>xMidYMin</dt><dd>Force uniform scaling horizontally centered and positioned at the top of the Graphic's node.<dd>\n     <dt>xMaxYMin</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the top.</dd>\n     <dt>xMinYMid</dt>Force uniform scaling positioned horizontally from the left and vertically centered.</dd>\n     <dt>xMidYMid (the default)</dt><dd>Force uniform scaling with the content centered.</dd>\n     <dt>xMaxYMid</dt><dd>Force uniform scaling positioned horizontally from the right and vertically centered.</dd>\n     <dt>xMinYMax</dt><dd>Force uniform scaling positioned horizontally from the left and vertically from the bottom.</dd>\n     <dt>xMidYMax</dt><dd>Force uniform scaling horizontally centered and position vertically from the bottom.</dd>\n     <dt>xMaxYMax</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the bottom.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_preserveAspectRatio"
     },
     "resizeDown": {
      "!type": "fn()",
      "!doc": "The contentBounds will resize to greater values but not smaller values. (for performance)\nWhen resizing the contentBounds down is desirable, set the resizeDown value to true.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_resizeDown"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_y"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the `Graphic` and its children are visible.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#config_visible"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_set"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the graphic instance in page coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_getXY"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Removes all nodes.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_destroy"
     },
     "addShape": {
      "!type": "fn(cfg: yui.Object) -> ?",
      "!doc": "Generates a shape instance by type.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_addShape"
     },
     "removeShape": {
      "!type": "fn(shape: graphics.Shape)",
      "!doc": "Removes a shape instance from from the graphic instance.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_removeShape"
     },
     "removeAllShapes": {
      "!type": "fn()",
      "!doc": "Removes all shape instances from the dom.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_removeAllShapes"
     },
     "clear": {
      "!type": "fn()",
      "!doc": "Clears the graphics object.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_clear"
     },
     "getShapeById": {
      "!type": "fn(id: string) -> ?",
      "!doc": "Returns a shape based on the id of its dom node.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_getShapeById"
     },
     "batch": {
      "!type": "fn(method: fn())",
      "!doc": "Allows for creating multiple shapes in order to batch appending and redraw operations.",
      "!url": "http://yuilibrary.com/classes/CanvasGraphic.html#method_batch"
     }
    }
   },
   "CanvasPath": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> implementation of the <a href=\"Path.html\">`Path`</a> class.\n`CanvasPath` is not intended to be used directly. Instead, use the <a href=\"Path.html\">`Path`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities but has\n<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> capabilities, the <a href=\"Path.html\">`Path`</a>\nclass will point to the `CanvasPath` class.",
    "!url": "http://yuilibrary.com/classes/CanvasPath.html",
    "prototype": {
     "end": {
      "!type": "fn()",
      "!doc": "Completes a drawing operation.",
      "!url": "http://yuilibrary.com/classes/CanvasPath.html#method_end"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/CanvasPath.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/CanvasPath.html#config_height"
     },
     "path": {
      "!type": "fn()",
      "!doc": "Indicates the path used for the node.",
      "!url": "http://yuilibrary.com/classes/CanvasPath.html#config_path"
     }
    }
   },
   "CanvasPieSlice": {
    "!type": "fn()",
    "!doc": "Draws pie slices",
    "!url": "http://yuilibrary.com/classes/CanvasPieSlice.html",
    "prototype": {
     "startAngle": {
      "!type": "fn()",
      "!doc": "Starting angle in relation to a circle in which to begin the pie slice drawing.",
      "!url": "http://yuilibrary.com/classes/CanvasPieSlice.html#config_startAngle"
     },
     "arc": {
      "!type": "fn()",
      "!doc": "Arc of the slice.",
      "!url": "http://yuilibrary.com/classes/CanvasPieSlice.html#config_arc"
     },
     "radius": {
      "!type": "fn()",
      "!doc": "Radius of the circle in which the pie slice is drawn",
      "!url": "http://yuilibrary.com/classes/CanvasPieSlice.html#config_radius"
     }
    }
   },
   "CanvasShape": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> implementation of the <a href=\"Shape.html\">`Shape`</a> class.\n`CanvasShape` is not intended to be used directly. Instead, use the <a href=\"Shape.html\">`Shape`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities but has\n<a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> capabilities, the <a href=\"Shape.html\">`Shape`</a>\nclass will point to the `CanvasShape` class.",
    "!url": "http://yuilibrary.com/classes/CanvasShape.html",
    "prototype": {
     "addClass": {
      "!type": "fn(className: string)",
      "!doc": "Add a class name to each node.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(className: string)",
      "!doc": "Removes a class name from each node.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_removeClass"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_getXY"
     },
     "setXY": {
      "!type": "fn(Contains: yui.Array)",
      "!doc": "Set the position of the shape in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_setXY"
     },
     "contains": {
      "!type": "fn(needle: graphics.CanvasShape) -> ?",
      "!doc": "Determines whether the node is an ancestor of another HTML element in the DOM hierarchy.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_contains"
     },
     "test": {
      "!type": "fn(selector: string) -> ?",
      "!doc": "Test if the supplied node matches the supplied selector.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_test"
     },
     "compareTo": {
      "!type": "fn(refNode: HTMLElement) -> bool",
      "!doc": "Compares nodes to determine if they match.\nNode instances can be compared to each other and/or HTMLElements.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_compareTo"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_set"
     },
     "translate": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Specifies a 2d translation.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_translate"
     },
     "translateX": {
      "!type": "fn(x: number)",
      "!doc": "Translates the shape along the x-axis. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_translateX"
     },
     "translateY": {
      "!type": "fn(y: number)",
      "!doc": "Performs a translate on the y-coordinate. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_translateY"
     },
     "skew": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Skews the shape around the x-axis and y-axis.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_skew"
     },
     "skewX": {
      "!type": "fn(x: number)",
      "!doc": "Skews the shape around the x-axis.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_skewX"
     },
     "skewY": {
      "!type": "fn(y: number)",
      "!doc": "Skews the shape around the y-axis.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_skewY"
     },
     "rotate": {
      "!type": "fn(deg: number)",
      "!doc": "Rotates the shape clockwise around it transformOrigin.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_rotate"
     },
     "scale": {
      "!type": "fn(val: number)",
      "!doc": "Specifies a 2d scaling operation.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_scale"
     },
     "getBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the bounds for a shape.\n\nCalculates the a new bounding box from the original corner coordinates (base on size and position) and the transform matrix.\nThe calculated bounding box is used by the graphic instance to calculate its viewBox.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_getBounds"
     },
     "toFront": {
      "!type": "fn()",
      "!doc": "Places the shape underneath all other shapes.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_toFront"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Destroys the shape instance.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#method_destroy"
     },
     "transformOrigin": {
      "!type": "fn()",
      "!doc": "An array of x, y values which indicates the transformOrigin in which to rotate the shape. Valid values range between 0 and 1 representing a\nfraction of the shape's corresponding bounding box dimension. The default value is [0.5, 0.5].",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_transformOrigin"
     },
     "transform": {
      "!type": "fn()",
      "!doc": "<p>A string containing, in order, transform operations applied to the shape instance. The `transform` string can contain the following values:\n\n   <dl>\n       <dt>rotate</dt><dd>Rotates the shape clockwise around it transformOrigin.</dd>\n       <dt>translate</dt><dd>Specifies a 2d translation.</dd>\n       <dt>skew</dt><dd>Skews the shape around the x-axis and y-axis.</dd>\n       <dt>scale</dt><dd>Specifies a 2d scaling operation.</dd>\n       <dt>translateX</dt><dd>Translates the shape along the x-axis.</dd>\n       <dt>translateY</dt><dd>Translates the shape along the y-axis.</dd>\n       <dt>skewX</dt><dd>Skews the shape around the x-axis.</dd>\n       <dt>skewY</dt><dd>Skews the shape around the y-axis.</dd>\n       <dt>matrix</dt><dd>Specifies a 2D transformation matrix comprised of the specified six values.</dd>\n   </dl>\n</p>\n<p>Applying transforms through the transform attribute will reset the transform matrix and apply a new transform. The shape class also contains\ncorresponding methods for each transform that will apply the transform to the current matrix. The below code illustrates how you might use the\n`transform` attribute to instantiate a recangle with a rotation of 45 degrees.</p>\n           var myRect = new Y.Rect({\n               type:\"rect\",\n               width: 50,\n               height: 40,\n               transform: \"rotate(45)\"\n           };\n<p>The code below would apply `translate` and `rotate` to an existing shape.</p>\n\n       myRect.set(\"transform\", \"translate(40, 50) rotate(45)\");",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_transform"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Dom node for the shape",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_node"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_id"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_height"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x position of shape.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y position of shape.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_y"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the shape is visible.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_visible"
     },
     "fill": {
      "!type": "fn()",
      "!doc": "Contains information about the fill of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the fill.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1.</dd>\n     <dt>type</dt><dd>Type of fill.\n         <dl>\n             <dt>solid</dt><dd>Solid single color fill. (default)</dd>\n             <dt>linear</dt><dd>Linear gradient fill.</dd>\n             <dt>radial</dt><dd>Radial gradient fill.</dd>\n         </dl>\n     </dd>\n </dl>\n <p>If a `linear` or `radial` is specified as the fill type. The following additional property is used:\n <dl>\n     <dt>stops</dt><dd>An array of objects containing the following properties:\n         <dl>\n             <dt>color</dt><dd>The color of the stop.</dd>\n             <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stop. The default value is 1.\n             Note: No effect for IE 6 - 8</dd>\n             <dt>offset</dt><dd>Number between 0 and 1 indicating where the color stop is positioned.</dd>\n         </dl>\n     </dd>\n     <p>Linear gradients also have the following property:</p>\n     <dt>rotation</dt><dd>Linear gradients flow left to right by default. The rotation property allows you to change the\n     flow by rotation. (e.g. A rotation of 180 would make the gradient pain from right to left.)</dd>\n     <p>Radial gradients have the following additional properties:</p>\n     <dt>r</dt><dd>Radius of the gradient circle.</dd>\n     <dt>fx</dt><dd>Focal point x-coordinate of the gradient.</dd>\n     <dt>fy</dt><dd>Focal point y-coordinate of the gradient.</dd>\n </dl>\n <p>The corresponding `SVGShape` class implements the following additional properties.</p>\n <dl>\n     <dt>cx</dt><dd>\n         <p>The x-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and\n         `VMLShape` classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n     <dt>cy</dt><dd>\n         <p>The y-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and `VMLShape`\n         classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n </dl>\n <p>These properties are not currently implemented in `CanvasShape` or `VMLShape`.</p>",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_fill"
     },
     "stroke": {
      "!type": "fn()",
      "!doc": "Contains information about the stroke of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the stroke.</dd>\n     <dt>weight</dt><dd>Number that indicates the width of the stroke.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stroke. The default value is 1.</dd>\n     <dt>dashstyle</dt>Indicates whether to draw a dashed stroke. When set to \"none\", a solid stroke is drawn. When set\n     to an array, the first index indicates the length of the dash. The second index indicates the length of gap.\n     <dt>linecap</dt><dd>Specifies the linecap for the stroke. The following values can be specified:\n         <dl>\n             <dt>butt (default)</dt><dd>Specifies a butt linecap.</dd>\n             <dt>square</dt><dd>Specifies a sqare linecap.</dd>\n             <dt>round</dt><dd>Specifies a round linecap.</dd>\n         </dl>\n     </dd>\n     <dt>linejoin</dt><dd>Specifies a linejoin for the stroke. The following values can be specified:\n         <dl>\n             <dt>round (default)</dt><dd>Specifies that the linejoin will be round.</dd>\n             <dt>bevel</dt><dd>Specifies a bevel for the linejoin.</dd>\n             <dt>miter limit</dt><dd>An integer specifying the miter limit of a miter linejoin. If you want to specify a linejoin\n             of miter, you simply specify the limit as opposed to having separate miter and miter limit values.</dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_stroke"
     },
     "data": {
      "!type": "fn()",
      "!doc": "Represents an SVG Path string. This will be parsed and added to shape's API to represent the SVG data across all\nimplementations. Note that when using VML or SVG implementations, part of this content will be added to the DOM using\nrespective VML/SVG attributes. If your content comes from an untrusted source, you will need to ensure that no\nmalicious code is included in that content.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_data"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Reference to the container Graphic.",
      "!url": "http://yuilibrary.com/classes/CanvasShape.html#config_graphic"
     }
    }
   },
   "CircleGroup": {
    "!type": "fn() -> +graphics.CircleGroup",
    "!doc": "Abstract class for creating groups of circles with the same styles and dimensions.",
    "!url": "http://yuilibrary.com/classes/CircleGroup.html",
    "prototype": {
     "drawShape": {
      "!type": "fn(cfg: yui.Object)",
      "!doc": "Algorithm for drawing shape.",
      "!url": "http://yuilibrary.com/classes/CircleGroup.html#method_drawShape"
     }
    }
   },
   "AttributeLite": {
    "!type": "fn() -> +graphics.AttributeLite",
    "!doc": "AttributeLite provides Attribute-like getters and setters for shape classes in the Graphics module.\nIt provides a get/set API without the event infastructure. This class is temporary and a work in progress.",
    "!url": "http://yuilibrary.com/classes/AttributeLite.html",
    "prototype": {
     "addAttrs": {
      "!type": "fn(cfg: yui.Object)",
      "!doc": "Initializes the attributes for a shape. If an attribute config is passed into the constructor of the host,\nthe initial values will be overwritten.",
      "!url": "http://yuilibrary.com/classes/AttributeLite.html#method_addAttrs"
     },
     "get": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "For a given item, returns the value of the property requested, or undefined if not found.",
      "!url": "http://yuilibrary.com/classes/AttributeLite.html#method_get"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/AttributeLite.html#method_set"
     }
    }
   },
   "Drawing": {
    "!type": "fn() -> +graphics.Drawing",
    "!doc": "`Drawing` provides a set of drawing methods used by `Path` and custom shape classes.\n`Drawing` has the following implementations based on browser capability.\n <ul>\n     <li><a href=\"SVGDrawing.html\">`SVGDrawing`</a></li>\n     <li><a href=\"VMLDrawing.html\">`VMLDrawing`</a></li>\n     <li><a href=\"CanvasDrawing.html\">`CanvasDrawing`</a></li>\n </ul>",
    "!url": "http://yuilibrary.com/classes/Drawing.html",
    "prototype": {
     "curveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_curveTo"
     },
     "quadraticCurveTo": {
      "!type": "fn(cpx: number, cpy: number, x: number, y: number) -> !this",
      "!doc": "Draws a quadratic bezier curve.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_quadraticCurveTo"
     },
     "drawRect": {
      "!type": "fn(x: number, y: number, w: number, h: number) -> !this",
      "!doc": "Draws a rectangle.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_drawRect"
     },
     "drawRoundRect": {
      "!type": "fn(x: number, y: number, w: number, h: number, ew: number, eh: number) -> !this",
      "!doc": "Draws a rectangle with rounded corners.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_drawRoundRect"
     },
     "lineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment using the current line style from the current drawing position to the specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_lineTo"
     },
     "relativeLineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment using the current line style from the current drawing position to the relative x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_relativeLineTo"
     },
     "moveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_moveTo"
     },
     "relativeMoveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position relative to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_relativeMoveTo"
     },
     "end": {
      "!type": "fn() -> !this",
      "!doc": "Completes a drawing operation.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_end"
     },
     "clear": {
      "!type": "fn() -> !this",
      "!doc": "Clears the path.",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_clear"
     },
     "closePath": {
      "!type": "fn() -> !this",
      "!doc": "Ends a fill and stroke",
      "!url": "http://yuilibrary.com/classes/Drawing.html#method_closePath"
     }
    }
   },
   "Shape": {
    "!type": "fn(cfg: yui.Object) -> +graphics.Shape",
    "!doc": "<p>Base class for creating shapes.</p>\n<p>`Shape` is an abstract class and is not meant to be used directly. The following classes extend\n`Shape`.\n\n<ul>\n    <li><a href=\"Circle.html\">`Circle`</a></li>\n    <li><a href=\"Ellipse.html\">`Ellipse`</a></li>\n    <li><a href=\"Rect.html\">`Rect`</a></li>\n    <li><a href=\"Path.html\">`Path`</a></li>\n</ul>\n\n `Shape` can also be extended to create custom shape classes.</p>\n\n `Shape` has the following implementations based on browser capability.\n<ul>\n    <li><a href=\"SVGShape.html\">`SVGShape`</a></li>\n    <li><a href=\"VMLShape.html\">`VMLShape`</a></li>\n    <li><a href=\"CanvasShape.html\">`CanvasShape`</a></li>\n</ul>\n\n It is not necessary to interact with these classes directly. `Shape` will point to the appropriate implemention.</p>",
    "!url": "http://yuilibrary.com/classes/Shape.html",
    "prototype": {
     "addClass": {
      "!type": "fn(className: string)",
      "!doc": "Add a class name to each node.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(className: string)",
      "!doc": "Removes a class name from each node.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_removeClass"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_getXY"
     },
     "setXY": {
      "!type": "fn(Contains: yui.Array)",
      "!doc": "Set the position of the shape in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_setXY"
     },
     "contains": {
      "!type": "fn(needle: graphics.Shape) -> ?",
      "!doc": "Determines whether the node is an ancestor of another HTML element in the DOM hierarchy.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_contains"
     },
     "compareTo": {
      "!type": "fn(refNode: HTMLElement) -> bool",
      "!doc": "Compares nodes to determine if they match.\nNode instances can be compared to each other and/or HTMLElements.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_compareTo"
     },
     "test": {
      "!type": "fn(selector: string) -> ?",
      "!doc": "Test if the supplied node matches the supplied selector.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_test"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_set"
     },
     "translate": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Specifies a 2d translation.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_translate"
     },
     "translateX": {
      "!type": "fn(x: number)",
      "!doc": "Translates the shape along the x-axis. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_translateX"
     },
     "translateY": {
      "!type": "fn(y: number)",
      "!doc": "Translates the shape along the y-axis. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_translateY"
     },
     "skew": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Skews the shape around the x-axis and y-axis.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_skew"
     },
     "skewX": {
      "!type": "fn(x: number)",
      "!doc": "Skews the shape around the x-axis.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_skewX"
     },
     "skewY": {
      "!type": "fn(y: number)",
      "!doc": "Skews the shape around the y-axis.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_skewY"
     },
     "rotate": {
      "!type": "fn(deg: number)",
      "!doc": "Rotates the shape clockwise around it transformOrigin.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_rotate"
     },
     "scale": {
      "!type": "fn(val: number)",
      "!doc": "Specifies a 2d scaling operation.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_scale"
     },
     "getBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the bounds for a shape.\n\nCalculates the a new bounding box from the original corner coordinates (base on size and position) and the transform matrix.\nThe calculated bounding box is used by the graphic instance to calculate its viewBox.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_getBounds"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Destroys the instance.",
      "!url": "http://yuilibrary.com/classes/Shape.html#method_destroy"
     },
     "transformOrigin": {
      "!type": "fn()",
      "!doc": "An array of x, y values which indicates the transformOrigin in which to rotate the shape. Valid values range between 0 and 1 representing a\nfraction of the shape's corresponding bounding box dimension. The default value is [0.5, 0.5].",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_transformOrigin"
     },
     "transform": {
      "!type": "fn()",
      "!doc": "<p>A string containing, in order, transform operations applied to the shape instance. The `transform` string can contain the following values:\n\n   <dl>\n       <dt>rotate</dt><dd>Rotates the shape clockwise around it transformOrigin.</dd>\n       <dt>translate</dt><dd>Specifies a 2d translation.</dd>\n       <dt>skew</dt><dd>Skews the shape around the x-axis and y-axis.</dd>\n       <dt>scale</dt><dd>Specifies a 2d scaling operation.</dd>\n       <dt>translateX</dt><dd>Translates the shape along the x-axis.</dd>\n       <dt>translateY</dt><dd>Translates the shape along the y-axis.</dd>\n       <dt>skewX</dt><dd>Skews the shape around the x-axis.</dd>\n       <dt>skewY</dt><dd>Skews the shape around the y-axis.</dd>\n       <dt>matrix</dt><dd>Specifies a 2D transformation matrix comprised of the specified six values.</dd>\n   </dl>\n</p>\n<p>Applying transforms through the transform attribute will reset the transform matrix and apply a new transform. The shape class also contains\ncorresponding methods for each transform that will apply the transform to the current matrix. The below code illustrates how you might use the\n`transform` attribute to instantiate a recangle with a rotation of 45 degrees.</p>\n           var myRect = new Y.Rect({\n               type:\"rect\",\n               width: 50,\n               height: 40,\n               transform: \"rotate(45)\"\n           };\n<p>The code below would apply `translate` and `rotate` to an existing shape.</p>\n\n       myRect.set(\"transform\", \"translate(40, 50) rotate(45)\");",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_transform"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_id"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x position of shape.",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y position of shape.",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_y"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_height"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the shape is visible.",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_visible"
     },
     "fill": {
      "!type": "fn()",
      "!doc": "Contains information about the fill of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the fill.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1.</dd>\n     <dt>type</dt><dd>Type of fill.\n         <dl>\n             <dt>solid</dt><dd>Solid single color fill. (default)</dd>\n             <dt>linear</dt><dd>Linear gradient fill.</dd>\n             <dt>radial</dt><dd>Radial gradient fill.</dd>\n         </dl>\n     </dd>\n </dl>\n <p>If a `linear` or `radial` is specified as the fill type. The following additional property is used:\n <dl>\n     <dt>stops</dt><dd>An array of objects containing the following properties:\n         <dl>\n             <dt>color</dt><dd>The color of the stop.</dd>\n             <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stop. The default value is 1.\n             Note: No effect for IE 6 - 8</dd>\n             <dt>offset</dt><dd>Number between 0 and 1 indicating where the color stop is positioned.</dd>\n         </dl>\n     </dd>\n     <p>Linear gradients also have the following property:</p>\n     <dt>rotation</dt><dd>Linear gradients flow left to right by default. The rotation property allows you to change the\n     flow by rotation. (e.g. A rotation of 180 would make the gradient pain from right to left.)</dd>\n     <p>Radial gradients have the following additional properties:</p>\n     <dt>r</dt><dd>Radius of the gradient circle.</dd>\n     <dt>fx</dt><dd>Focal point x-coordinate of the gradient.</dd>\n     <dt>fy</dt><dd>Focal point y-coordinate of the gradient.</dd>\n     <dt>cx</dt><dd>\n         <p>The x-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and\n         `VMLShape` classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n     <dt>cy</dt><dd>\n         <p>The y-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and `VMLShape`\n         classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_fill"
     },
     "stroke": {
      "!type": "fn()",
      "!doc": "Contains information about the stroke of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the stroke.</dd>\n     <dt>weight</dt><dd>Number that indicates the width of the stroke.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stroke. The default value is 1.</dd>\n     <dt>dashstyle</dt>Indicates whether to draw a dashed stroke. When set to \"none\", a solid stroke is drawn. When set\n     to an array, the first index indicates the length of the dash. The second index indicates the length of gap.\n     <dt>linecap</dt><dd>Specifies the linecap for the stroke. The following values can be specified:\n         <dl>\n             <dt>butt (default)</dt><dd>Specifies a butt linecap.</dd>\n             <dt>square</dt><dd>Specifies a sqare linecap.</dd>\n             <dt>round</dt><dd>Specifies a round linecap.</dd>\n         </dl>\n     </dd>\n     <dt>linejoin</dt><dd>Specifies a linejoin for the stroke. The following values can be specified:\n         <dl>\n             <dt>round (default)</dt><dd>Specifies that the linejoin will be round.</dd>\n             <dt>bevel</dt><dd>Specifies a bevel for the linejoin.</dd>\n             <dt>miter limit</dt><dd>An integer specifying the miter limit of a miter linejoin. If you want to specify a linejoin\n             of miter, you simply specify the limit as opposed to having separate miter and miter limit values.</dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_stroke"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Dom node for the shape.",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_node"
     },
     "data": {
      "!type": "fn()",
      "!doc": "Represents an SVG Path string. This will be parsed and added to shape's API to represent the SVG data across all\nimplementations. Note that when using VML or SVG implementations, part of this content will be added to the DOM using\nrespective VML/SVG attributes. If your content comes from an untrusted source, you will need to ensure that no\nmalicious code is included in that content.",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_data"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Reference to the parent graphic instance",
      "!url": "http://yuilibrary.com/classes/Shape.html#config_graphic"
     }
    }
   },
   "Circle": {
    "!type": "fn() -> +graphics.Circle",
    "!proto": "graphics.Shape",
    "!doc": "<p>Creates circle shape with editable attributes.</p>\n<p>`Circle` instances can be created using the <a href=\"Graphic.html#method_addShape\">`addShape`</a> method of the\n<a href=\"Graphic.html\">`Graphic`</a> class. The method's `cfg` argument contains a `type` attribute. Assigning \"circle\"\nor `Y.Circle` to this attribute will create a `Circle` instance. Required attributes for instantiating a `Circle` are\n`type` and `radius`. Optional attributes include:\n <ul>\n     <li><a href=\"#attr_fill\">fill</a></li>\n     <li><a href=\"#attr_id\">id</a></li>\n     <li><a href=\"#attr_stroke\">stroke</a></li>\n     <li><a href=\"#attr_transform\">transform</a></li>\n     <li><a href=\"#attr_transformOrigin\">transformOrigin</a></li>\n     <li><a href=\"#attr_visible\">visible</a></li>\n     <li><a href=\"#attr_x\">x</a></li>\n     <li><a href=\"#attr_y\">y</a></li>\n </ul>\n\nThe below code creates a circle by defining the `type` attribute as \"circle\":</p>\n\n       var myCircle = myGraphic.addShape({\n           type: \"circle\",\n           radius: 10,\n           fill: {\n               color: \"#9aa\"\n           },\n           stroke: {\n               weight: 1,\n               color: \"#000\"\n           }\n       });\n\nBelow, this same circle is created by defining the `type` attribute with a class reference:\n\n       var myCircle = myGraphic.addShape({\n           type: Y.Circle,\n           radius: 10,\n           fill: {\n               color: \"#9aa\"\n           },\n           stroke: {\n               weight: 1,\n               color: \"#000\"\n           }\n       });\n\n<p>`Circle` has the following implementations based on browser capability.\n <ul>\n     <li><a href=\"SVGCircle.html\">`SVGCircle`</a></li>\n     <li><a href=\"VMLCircle.html\">`VMLCircle`</a></li>\n     <li><a href=\"CanvasCircle.html\">`CanvasCircle`</a></li>\n </ul>\n\nIt is not necessary to interact with these classes directly. `Circle` will point to the appropriate implemention.</p>",
    "!url": "http://yuilibrary.com/classes/Circle.html",
    "prototype": {
     "radius": {
      "!type": "fn()",
      "!doc": "Radius of the circle",
      "!url": "http://yuilibrary.com/classes/Circle.html#config_radius"
     }
    }
   },
   "Path": {
    "!type": "fn() -> +graphics.Path",
    "!proto": "graphics.Shape",
    "!doc": "<p>The `Path` class creates a shape through the use of drawing methods. The `Path` class has the following drawing methods available:</p>\n <ul>\n     <li><a href=\"#method_clear\">`clear`</a></li>\n     <li><a href=\"#method_curveTo\">`curveTo`</a></li>\n     <li><a href=\"#method_drawRect\">`drawRect`</a></li>\n     <li><a href=\"#method_drawRoundRect\">`drawRoundRect`</a></li>\n     <li><a href=\"#method_end\">`end`</a></li>\n     <li><a href=\"#method_lineTo\">`lineTo`</a></li>\n     <li><a href=\"#method_moveTo\">`moveTo`</a></li>\n     <li><a href=\"#method_quadraticCurveTo\">`quadraticCurveTo`</a></li>\n </ul>\n\n <p>Like other shapes, `Path` elements are created using the <a href=\"Graphic.html#method_addShape\">`addShape`</a>\n method of the <a href=\"Graphic.html\">`Graphic`</a> class. The method's `cfg` argument contains a `type` attribute.\n Assigning \"path\" or `Y.Path` to this attribute will create a `Path` instance. After instantiation, a series of drawing\n operations must be performed in order to render a shape. The below code instantiates a path element by defining the\n `type` attribute as \"path\":</p>\n\n       var myPath = myGraphic.addShape({\n           type: \"path\",\n           fill: {\n               color: \"#9aa\"\n           },\n           stroke: {\n               weight: 1,\n               color: \"#000\"\n           }\n       });\n\nBelow a `Path` element with the same properties is instantiated by defining the `type` attribute with a class reference:\n\n       var myPath = myGraphic.addShape({\n           type: Y.Path,\n           fill: {\n               color: \"#9aa\"\n           },\n           stroke: {\n               weight: 1,\n               color: \"#000\"\n           }\n       });\n\nAfter instantiation, a shape or segment needs to be drawn for an element to render. After all draw operations are performed,\nthe <a href=\"#method_end\">`end`</a> method will render the shape. The code below will draw a triangle:\n\n       myPath.moveTo(35, 5);\n       myPath.lineTo(65, 65);\n       myPath.lineTo(5, 65);\n       myPath.lineTo(35, 5);\n       myPath.end();\n\n<p>`Path` has the following implementations based on browser capability.\n <ul>\n     <li><a href=\"SVGPath.html\">`SVGPath`</a></li>\n     <li><a href=\"VMLPath.html\">`VMLPath`</a></li>\n     <li><a href=\"CanvasPath.html\">`CanvasPath`</a></li>\n </ul>\nIt is not necessary to interact with these classes directly. `Path` will point to the appropriate implemention.</p>",
    "!url": "http://yuilibrary.com/classes/Path.html",
    "prototype": {
     "path": {
      "!type": "fn()",
      "!doc": "Indicates the path used for the node.",
      "!url": "http://yuilibrary.com/classes/Path.html#config_path"
     }
    }
   },
   "Graphic": {
    "!type": "fn() -> +graphics.Graphic",
    "!doc": "`Graphic` acts a factory and container for shapes. You need at least one `Graphic` instance to create shapes for your application.\n<p>The code block below creates a `Graphic` instance and appends it to an HTMLElement with the id 'mygraphiccontainer'.</p>\n\n       var myGraphic = new Y.Graphic({render:\"#mygraphiccontainer\"});\n\n<p>Alternatively, you can add a `Graphic` instance to the DOM using the <a href=\"#method_render\">`render`</a> method.</p>\n       var myGraphic = new Y.Graphic();\n       myGraphic.render(\"#mygraphiccontainer\");\n\n`Graphic` has the following implementations based on browser capability.\n <ul>\n     <li><a href=\"SVGGraphic.html\">`SVGGraphic`</a></li>\n     <li><a href=\"VMLGraphic.html\">`VMLGraphic`</a></li>\n     <li><a href=\"CanvasGraphic.html\">`CanvasGraphic`</a></li>\n </ul>\n\nIt is not necessary to interact with these classes directly. `Graphic` will point to the appropriate implemention.</p>",
    "!url": "http://yuilibrary.com/classes/Graphic.html",
    "prototype": {
     "render": {
      "!type": "fn(parentNode: node.Node)",
      "!doc": "Adds the graphics node to the dom.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_render"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_id"
     },
     "shapes": {
      "!type": "fn()",
      "!doc": "Key value pairs in which a shape instance is associated with its id.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_shapes"
     },
     "contentBounds": {
      "!type": "fn()",
      "!doc": "Object containing size and coordinate data for the content of a Graphic in relation to the coordSpace node.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_contentBounds"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The html element that represents to coordinate system of the Graphic instance.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_node"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_height"
     },
     "autoSize": {
      "!type": "fn()",
      "!doc": "Determines the sizing of the Graphic.\n\n<dl>\n    <dt>sizeContentToGraphic</dt><dd>The Graphic's width and height attributes are, either explicitly set through the\n    <code>width</code> and <code>height</code> attributes or are determined by the dimensions of the parent element. The\n    content contained in the Graphic will be sized to fit with in the Graphic instance's dimensions. When using this\n    setting, the <code>preserveAspectRatio</code> attribute will determine how the contents are sized.</dd>\n    <dt>sizeGraphicToContent</dt><dd>(Also accepts a value of true) The Graphic's width and height are determined by the\n    size and positioning of the content.</dd>\n    <dt>false</dt><dd>The Graphic's width and height attributes are, either explicitly set through the <code>width</code>\n    and <code>height</code> attributes or are determined by the dimensions of the parent element. The contents of the\n    Graphic instance are not affected by this setting.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_autoSize"
     },
     "preserveAspectRatio": {
      "!type": "fn()",
      "!doc": "Determines how content is sized when <code>autoSize</code> is set to <code>sizeContentToGraphic</code>.\n\n <dl>\n     <dt>none<dt><dd>Do not force uniform scaling. Scale the graphic content of the given element non-uniformly if necessary\n     such that the element's bounding box exactly matches the viewport rectangle.</dd>\n     <dt>xMinYMin</dt><dd>Force uniform scaling position along the top left of the Graphic's node.</dd>\n     <dt>xMidYMin</dt><dd>Force uniform scaling horizontally centered and positioned at the top of the Graphic's node.<dd>\n     <dt>xMaxYMin</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the top.</dd>\n     <dt>xMinYMid</dt>Force uniform scaling positioned horizontally from the left and vertically centered.</dd>\n     <dt>xMidYMid (the default)</dt><dd>Force uniform scaling with the content centered.</dd>\n     <dt>xMaxYMid</dt><dd>Force uniform scaling positioned horizontally from the right and vertically centered.</dd>\n     <dt>xMinYMax</dt><dd>Force uniform scaling positioned horizontally from the left and vertically from the bottom.</dd>\n     <dt>xMidYMax</dt><dd>Force uniform scaling horizontally centered and position vertically from the bottom.</dd>\n     <dt>xMaxYMax</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the bottom.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_preserveAspectRatio"
     },
     "resizeDown": {
      "!type": "fn()",
      "!doc": "The contentBounds will resize to greater values but not to smaller values. (for performance)\nWhen resizing the contentBounds down is desirable, set the resizeDown value to true.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_resizeDown"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_y"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the `Graphic` and its children are visible.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#config_visible"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the graphic instance in page coordinates.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_getXY"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Removes all nodes.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_destroy"
     },
     "addShape": {
      "!type": "fn(cfg: yui.Object) -> ?",
      "!doc": "<p>Generates a shape instance by type. The method accepts an object that contain's the shape's\ntype and attributes to be customized. For example, the code below would create a rectangle:</p>\n\n           var myRect = myGraphic.addShape({\n               type: \"rect\",\n               width: 40,\n               height: 30,\n               fill: {\n                   color: \"#9aa\"\n               },\n               stroke: {\n                   weight: 1,\n                   color: \"#000\"\n               }\n           });\n\n<p>The `Graphics` module includes a few basic shapes. More information on their creation\ncan be found in each shape's documentation:\n\n <ul>\n     <li><a href=\"Circle.html\">`Circle`</a></li>\n     <li><a href=\"Ellipse.html\">`Ellipse`</a></li>\n     <li><a href=\"Rect.html\">`Rect`</a></li>\n     <li><a href=\"Path.html\">`Path`</a></li>\n </ul>\n\n The `Graphics` module also allows for the creation of custom shapes. If a custom shape\n has been created, it can be instantiated with the `addShape` method as well. The attributes,\n required and optional, would need to be defined in the custom shape.\n\n           var myCustomShape = myGraphic.addShape({\n               type: Y.MyCustomShape,\n               width: 50,\n               height: 50,\n               fill: {\n                   color: \"#9aa\"\n               },\n               stroke: {\n                   weight: 1,\n                   color: \"#000\"\n               }\n           });",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_addShape"
     },
     "removeShape": {
      "!type": "fn(shape: graphics.Shape)",
      "!doc": "Removes a shape instance from from the graphic instance.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_removeShape"
     },
     "removeAllShapes": {
      "!type": "fn()",
      "!doc": "Removes all shape instances from the dom.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_removeAllShapes"
     },
     "getShapeById": {
      "!type": "fn(id: string) -> ?",
      "!doc": "Returns a shape based on the id of its dom node.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_getShapeById"
     },
     "batch": {
      "!type": "fn(method: fn())",
      "!doc": "Allows for creating multiple shapes in order to batch appending and redraw operations.",
      "!url": "http://yuilibrary.com/classes/Graphic.html#method_batch"
     }
    }
   },
   "SVGCircle": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/SVG/\">SVG</a> implementation of the <a href=\"Circle.html\">`Circle`</a> class.\n`SVGCircle` is not intended to be used directly. Instead, use the <a href=\"Circle.html\">`Circle`</a> class.\nIf the browser has <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities, the <a href=\"Circle.html\">`Circle`</a>\nclass will point to the `SVGCircle` class.",
    "!url": "http://yuilibrary.com/classes/SVGCircle.html",
    "prototype": {
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/SVGCircle.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/SVGCircle.html#config_height"
     },
     "radius": {
      "!type": "fn()",
      "!doc": "Radius of the circle",
      "!url": "http://yuilibrary.com/classes/SVGCircle.html#config_radius"
     }
    }
   },
   "SVGDrawing": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/SVG/\">SVG</a> implementation of the <a href=\"Drawing.html\">`Drawing`</a> class.\n`SVGDrawing` is not intended to be used directly. Instead, use the <a href=\"Drawing.html\">`Drawing`</a> class.\nIf the browser has <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities, the <a href=\"Drawing.html\">`Drawing`</a>\nclass will point to the `SVGDrawing` class.",
    "!url": "http://yuilibrary.com/classes/SVGDrawing.html",
    "prototype": {
     "curveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_curveTo"
     },
     "relativeCurveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve relative to the current coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_relativeCurveTo"
     },
     "quadraticCurveTo": {
      "!type": "fn(cpx: number, cpy: number, x: number, y: number) -> !this",
      "!doc": "Draws a quadratic bezier curve relative to the current position.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_quadraticCurveTo"
     },
     "drawRect": {
      "!type": "fn(x: number, y: number, w: number, h: number) -> !this",
      "!doc": "Draws a rectangle.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_drawRect"
     },
     "drawRoundRect": {
      "!type": "fn(x: number, y: number, w: number, h: number, ew: number, eh: number) -> !this",
      "!doc": "Draws a rectangle with rounded corners.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_drawRoundRect"
     },
     "lineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment using the current line style from the current drawing position to the specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_lineTo"
     },
     "relativeLineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment using the current line style from the current drawing position to the relative x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_relativeLineTo"
     },
     "moveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_moveTo"
     },
     "relativeMoveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position relative to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_relativeMoveTo"
     },
     "end": {
      "!type": "fn() -> !this",
      "!doc": "Completes a drawing operation.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_end"
     },
     "clear": {
      "!type": "fn() -> !this",
      "!doc": "Clears the path.",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_clear"
     },
     "closePath": {
      "!type": "fn() -> !this",
      "!doc": "Ends a fill and stroke",
      "!url": "http://yuilibrary.com/classes/SVGDrawing.html#method_closePath"
     }
    }
   },
   "SVGEllipse": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/SVG/\">SVG</a> implementation of the <a href=\"Ellipse.html\">`Ellipse`</a> class.\n`SVGEllipse` is not intended to be used directly. Instead, use the <a href=\"Ellipse.html\">`Ellipse`</a> class.\nIf the browser has <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities, the <a href=\"Ellipse.html\">`Ellipse`</a>\nclass will point to the `SVGEllipse` class.",
    "!url": "http://yuilibrary.com/classes/SVGEllipse.html",
    "prototype": {
     "xRadius": {
      "!type": "fn()",
      "!doc": "Horizontal radius for the ellipse.",
      "!url": "http://yuilibrary.com/classes/SVGEllipse.html#config_xRadius"
     },
     "yRadius": {
      "!type": "fn()",
      "!doc": "Vertical radius for the ellipse.",
      "!url": "http://yuilibrary.com/classes/SVGEllipse.html#config_yRadius"
     }
    }
   },
   "SVGGraphic": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/SVG/\">SVG</a> implementation of the <a href=\"Graphic.html\">`Graphic`</a> class.\n`SVGGraphic` is not intended to be used directly. Instead, use the <a href=\"Graphic.html\">`Graphic`</a> class.\nIf the browser has <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities, the <a href=\"Graphic.html\">`Graphic`</a>\nclass will point to the `SVGGraphic` class.",
    "!url": "http://yuilibrary.com/classes/SVGGraphic.html",
    "prototype": {
     "render": {
      "!type": "fn(parentNode: HTMLElement)",
      "!doc": "Adds the graphics node to the dom.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_render"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_id"
     },
     "shapes": {
      "!type": "fn()",
      "!doc": "Key value pairs in which a shape instance is associated with its id.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_shapes"
     },
     "contentBounds": {
      "!type": "fn()",
      "!doc": "Object containing size and coordinate data for the content of a Graphic in relation to the coordSpace node.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_contentBounds"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The html element that represents to coordinate system of the Graphic instance.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_node"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_height"
     },
     "autoSize": {
      "!type": "fn()",
      "!doc": "Determines the sizing of the Graphic.\n\n<dl>\n    <dt>sizeContentToGraphic</dt><dd>The Graphic's width and height attributes are, either explicitly set through the\n    <code>width</code> and <code>height</code> attributes or are determined by the dimensions of the parent element. The\n    content contained in the Graphic will be sized to fit with in the Graphic instance's dimensions. When using this\n    setting, the <code>preserveAspectRatio</code> attribute will determine how the contents are sized.</dd>\n    <dt>sizeGraphicToContent</dt><dd>(Also accepts a value of true) The Graphic's width and height are determined by the\n    size and positioning of the content.</dd>\n    <dt>false</dt><dd>The Graphic's width and height attributes are, either explicitly set through the <code>width</code>\n    and <code>height</code> attributes or are determined by the dimensions of the parent element. The contents of the\n    Graphic instance are not affected by this setting.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_autoSize"
     },
     "preserveAspectRatio": {
      "!type": "fn()",
      "!doc": "Determines how content is sized when <code>autoSize</code> is set to <code>sizeContentToGraphic</code>.\n\n <dl>\n     <dt>none<dt><dd>Do not force uniform scaling. Scale the graphic content of the given element non-uniformly if necessary\n     such that the element's bounding box exactly matches the viewport rectangle.</dd>\n     <dt>xMinYMin</dt><dd>Force uniform scaling position along the top left of the Graphic's node.</dd>\n     <dt>xMidYMin</dt><dd>Force uniform scaling horizontally centered and positioned at the top of the Graphic's node.<dd>\n     <dt>xMaxYMin</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the top.</dd>\n     <dt>xMinYMid</dt>Force uniform scaling positioned horizontally from the left and vertically centered.</dd>\n     <dt>xMidYMid (the default)</dt><dd>Force uniform scaling with the content centered.</dd>\n     <dt>xMaxYMid</dt><dd>Force uniform scaling positioned horizontally from the right and vertically centered.</dd>\n     <dt>xMinYMax</dt><dd>Force uniform scaling positioned horizontally from the left and vertically from the bottom.</dd>\n     <dt>xMidYMax</dt><dd>Force uniform scaling horizontally centered and position vertically from the bottom.</dd>\n     <dt>xMaxYMax</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the bottom.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_preserveAspectRatio"
     },
     "resizeDown": {
      "!type": "fn()",
      "!doc": "The contentBounds will resize to greater values but not to smaller values. (for performance)\nWhen resizing the contentBounds down is desirable, set the resizeDown value to true.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_resizeDown"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#config_y"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_set"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the graphic instance in page coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_getXY"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Removes all nodes.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_destroy"
     },
     "addShape": {
      "!type": "fn(cfg: yui.Object) -> ?",
      "!doc": "Generates a shape instance by type.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_addShape"
     },
     "removeShape": {
      "!type": "fn(shape: graphics.Shape)",
      "!doc": "Removes a shape instance from from the graphic instance.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_removeShape"
     },
     "removeAllShapes": {
      "!type": "fn()",
      "!doc": "Removes all shape instances from the dom.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_removeAllShapes"
     },
     "clear": {
      "!type": "fn()",
      "!doc": "Clears the graphics object.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_clear"
     },
     "getShapeById": {
      "!type": "fn(id: string) -> ?",
      "!doc": "Returns a shape based on the id of its dom node.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_getShapeById"
     },
     "batch": {
      "!type": "fn(method: fn())",
      "!doc": "Allows for creating multiple shapes in order to batch appending and redraw operations.",
      "!url": "http://yuilibrary.com/classes/SVGGraphic.html#method_batch"
     }
    }
   },
   "SVGPath": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/SVG/\">SVG</a> implementation of the <a href=\"Path.html\">`Path`</a> class.\n`SVGPath` is not intended to be used directly. Instead, use the <a href=\"Path.html\">`Path`</a> class.\nIf the browser has <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities, the <a href=\"Path.html\">`Path`</a>\nclass will point to the `SVGPath` class.",
    "!url": "http://yuilibrary.com/classes/SVGPath.html",
    "prototype": {
     "path": {
      "!type": "fn()",
      "!doc": "Indicates the path used for the node.",
      "!url": "http://yuilibrary.com/classes/SVGPath.html#config_path"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/SVGPath.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/SVGPath.html#config_height"
     }
    }
   },
   "SVGPieSlice": {
    "!type": "fn()",
    "!doc": "Draws pie slices",
    "!url": "http://yuilibrary.com/classes/SVGPieSlice.html",
    "prototype": {
     "startAngle": {
      "!type": "fn()",
      "!doc": "Starting angle in relation to a circle in which to begin the pie slice drawing.",
      "!url": "http://yuilibrary.com/classes/SVGPieSlice.html#config_startAngle"
     },
     "arc": {
      "!type": "fn()",
      "!doc": "Arc of the slice.",
      "!url": "http://yuilibrary.com/classes/SVGPieSlice.html#config_arc"
     },
     "radius": {
      "!type": "fn()",
      "!doc": "Radius of the circle in which the pie slice is drawn",
      "!url": "http://yuilibrary.com/classes/SVGPieSlice.html#config_radius"
     }
    }
   },
   "SVGShape": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/SVG/\">SVG</a> implementation of the <a href=\"Shape.html\">`Shape`</a> class.\n`SVGShape` is not intended to be used directly. Instead, use the <a href=\"Shape.html\">`Shape`</a> class.\nIf the browser has <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> capabilities, the <a href=\"Shape.html\">`Shape`</a>\nclass will point to the `SVGShape` class.",
    "!url": "http://yuilibrary.com/classes/SVGShape.html",
    "prototype": {
     "addClass": {
      "!type": "fn(className: string)",
      "!doc": "Add a class name to each node.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(className: string)",
      "!doc": "Removes a class name from each node.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_removeClass"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_getXY"
     },
     "setXY": {
      "!type": "fn(Contains: yui.Array)",
      "!doc": "Set the position of the shape in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_setXY"
     },
     "contains": {
      "!type": "fn(needle: graphics.SVGShape) -> ?",
      "!doc": "Determines whether the node is an ancestor of another HTML element in the DOM hierarchy.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_contains"
     },
     "compareTo": {
      "!type": "fn(refNode: HTMLElement) -> bool",
      "!doc": "Compares nodes to determine if they match.\nNode instances can be compared to each other and/or HTMLElements.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_compareTo"
     },
     "test": {
      "!type": "fn(selector: string) -> ?",
      "!doc": "Test if the supplied node matches the supplied selector.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_test"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_set"
     },
     "translate": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Specifies a 2d translation.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_translate"
     },
     "translateX": {
      "!type": "fn(x: number)",
      "!doc": "Translates the shape along the x-axis. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_translateX"
     },
     "translateY": {
      "!type": "fn(y: number)",
      "!doc": "Translates the shape along the y-axis. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_translateY"
     },
     "skew": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Skews the shape around the x-axis and y-axis.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_skew"
     },
     "skewX": {
      "!type": "fn(x: number)",
      "!doc": "Skews the shape around the x-axis.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_skewX"
     },
     "skewY": {
      "!type": "fn(y: number)",
      "!doc": "Skews the shape around the y-axis.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_skewY"
     },
     "rotate": {
      "!type": "fn(deg: number)",
      "!doc": "Rotates the shape clockwise around it transformOrigin.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_rotate"
     },
     "scale": {
      "!type": "fn(val: number)",
      "!doc": "Specifies a 2d scaling operation.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_scale"
     },
     "getBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the bounds for a shape.\n\nCalculates the a new bounding box from the original corner coordinates (base on size and position) and the transform matrix.\nThe calculated bounding box is used by the graphic instance to calculate its viewBox.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_getBounds"
     },
     "toFront": {
      "!type": "fn()",
      "!doc": "Places the shape underneath all other shapes.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_toFront"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Destroys the shape instance.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#method_destroy"
     },
     "transformOrigin": {
      "!type": "fn()",
      "!doc": "An array of x, y values which indicates the transformOrigin in which to rotate the shape. Valid values range between 0 and 1 representing a\nfraction of the shape's corresponding bounding box dimension. The default value is [0.5, 0.5].",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_transformOrigin"
     },
     "transform": {
      "!type": "fn()",
      "!doc": "<p>A string containing, in order, transform operations applied to the shape instance. The `transform` string can contain the following values:\n\n   <dl>\n       <dt>rotate</dt><dd>Rotates the shape clockwise around it transformOrigin.</dd>\n       <dt>translate</dt><dd>Specifies a 2d translation.</dd>\n       <dt>skew</dt><dd>Skews the shape around the x-axis and y-axis.</dd>\n       <dt>scale</dt><dd>Specifies a 2d scaling operation.</dd>\n       <dt>translateX</dt><dd>Translates the shape along the x-axis.</dd>\n       <dt>translateY</dt><dd>Translates the shape along the y-axis.</dd>\n       <dt>skewX</dt><dd>Skews the shape around the x-axis.</dd>\n       <dt>skewY</dt><dd>Skews the shape around the y-axis.</dd>\n       <dt>matrix</dt><dd>Specifies a 2D transformation matrix comprised of the specified six values.</dd>\n   </dl>\n</p>\n<p>Applying transforms through the transform attribute will reset the transform matrix and apply a new transform. The shape class also contains\ncorresponding methods for each transform that will apply the transform to the current matrix. The below code illustrates how you might use the\n`transform` attribute to instantiate a recangle with a rotation of 45 degrees.</p>\n           var myRect = new Y.Rect({\n               type:\"rect\",\n               width: 50,\n               height: 40,\n               transform: \"rotate(45)\"\n           };\n<p>The code below would apply `translate` and `rotate` to an existing shape.</p>\n\n       myRect.set(\"transform\", \"translate(40, 50) rotate(45)\");",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_transform"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_id"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x position of shape.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y position of shape.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_y"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_height"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the shape is visible.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_visible"
     },
     "shapeRendering": {
      "!type": "fn()",
      "!doc": "Only implemented in SVG implementation.\nApplies the SVG shape-rendering attribute to the shape.\n <dl>\n     <dt>auto</dt>\n     <dd>Indicates that the user agent shall make appropriate tradeoffs to balance speed,\n     crisp edges and geometric precision, but with geometric precision given more importance than speed and crisp edges.</dd>\n     <dt>optimizeSpeed</dt>\n     <dd>Indicates that the user agent shall emphasize rendering speed over geometric precision and crisp edges.\n     This option will sometimes cause the user agent to turn off shape anti-aliasing.</dd>\n     <dt>crispEdges</dt>\n     <dd>Indicates that the user agent shall attempt to emphasize the contrast between clean edges of artwork over rendering\n     speed and geometric precision. To achieve crisp edges, the user agent might turn off anti-aliasing for all lines and curves\n     or possibly just for straight lines which are close to vertical or horizontal. Also, the user agent might adjust line\n     positions and line widths to align edges with device pixels.</dd>\n     <dt>geometricPrecision</dt>\n     <dd>Indicates that the user agent shall emphasize geometric precision over speed and crisp edges.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_shapeRendering"
     },
     "fill": {
      "!type": "fn()",
      "!doc": "Contains information about the fill of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the fill.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1.</dd>\n     <dt>type</dt><dd>Type of fill.\n         <dl>\n             <dt>solid</dt><dd>Solid single color fill. (default)</dd>\n             <dt>linear</dt><dd>Linear gradient fill.</dd>\n             <dt>radial</dt><dd>Radial gradient fill.</dd>\n         </dl>\n     </dd>\n </dl>\n <p>If a `linear` or `radial` is specified as the fill type. The following additional property is used:\n <dl>\n     <dt>stops</dt><dd>An array of objects containing the following properties:\n         <dl>\n             <dt>color</dt><dd>The color of the stop.</dd>\n             <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stop. The default value is 1.\n             Note: No effect for IE 6 - 8</dd>\n             <dt>offset</dt><dd>Number between 0 and 1 indicating where the color stop is positioned.</dd>\n         </dl>\n     </dd>\n     <p>Linear gradients also have the following property:</p>\n     <dt>rotation</dt><dd>Linear gradients flow left to right by default. The rotation property allows you to change the\n     flow by rotation. (e.g. A rotation of 180 would make the gradient pain from right to left.)</dd>\n     <p>Radial gradients have the following additional properties:</p>\n     <dt>r</dt><dd>Radius of the gradient circle.</dd>\n     <dt>fx</dt><dd>Focal point x-coordinate of the gradient.</dd>\n     <dt>fy</dt><dd>Focal point y-coordinate of the gradient.</dd>\n     <dt>cx</dt><dd>\n         <p>The x-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and\n         `VMLShape` classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n     <dt>cy</dt><dd>\n         <p>The y-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and `VMLShape`\n         classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_fill"
     },
     "stroke": {
      "!type": "fn()",
      "!doc": "Contains information about the stroke of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the stroke.</dd>\n     <dt>weight</dt><dd>Number that indicates the width of the stroke.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stroke. The default value is 1.</dd>\n     <dt>dashstyle</dt>Indicates whether to draw a dashed stroke. When set to \"none\", a solid stroke is drawn. When set\n     to an array, the first index indicates the length of the dash. The second index indicates the length of gap.\n     <dt>linecap</dt><dd>Specifies the linecap for the stroke. The following values can be specified:\n         <dl>\n             <dt>butt (default)</dt><dd>Specifies a butt linecap.</dd>\n             <dt>square</dt><dd>Specifies a sqare linecap.</dd>\n             <dt>round</dt><dd>Specifies a round linecap.</dd>\n         </dl>\n     </dd>\n     <dt>linejoin</dt><dd>Specifies a linejoin for the stroke. The following values can be specified:\n         <dl>\n             <dt>round (default)</dt><dd>Specifies that the linejoin will be round.</dd>\n             <dt>bevel</dt><dd>Specifies a bevel for the linejoin.</dd>\n             <dt>miter limit</dt><dd>An integer specifying the miter limit of a miter linejoin. If you want to specify a linejoin\n             of miter, you simply specify the limit as opposed to having separate miter and miter limit values.</dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_stroke"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Dom node for the shape.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_node"
     },
     "data": {
      "!type": "fn()",
      "!doc": "Represents an SVG Path string. This will be parsed and added to shape's API to represent the SVG data across all\nimplementations. Note that when using VML or SVG implementations, part of this content will be added to the DOM using\nrespective VML/SVG attributes. If your content comes from an untrusted source, you will need to ensure that no\nmalicious code is included in that content.",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_data"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Reference to the parent graphic instance",
      "!url": "http://yuilibrary.com/classes/SVGShape.html#config_graphic"
     }
    }
   },
   "VMLCircle": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> implementation of the <a href=\"Circle.html\">`Circle`</a> class.\n`VMLCircle` is not intended to be used directly. Instead, use the <a href=\"Circle.html\">`Circle`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> and <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a>\ncapabilities, the <a href=\"Circle.html\">`Circle`</a> class will point to the `VMLCircle` class.",
    "!url": "http://yuilibrary.com/classes/VMLCircle.html",
    "prototype": {
     "radius": {
      "!type": "fn()",
      "!doc": "Radius for the circle.",
      "!url": "http://yuilibrary.com/classes/VMLCircle.html#config_radius"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/VMLCircle.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/VMLCircle.html#config_height"
     }
    }
   },
   "VMLDrawing": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> implementation of the <a href=\"Drawing.html\">`Drawing`</a> class.\n`VMLDrawing` is not intended to be used directly. Instead, use the <a href=\"Drawing.html\">`Drawing`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> and <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a>\ncapabilities, the <a href=\"Drawing.html\">`Drawing`</a> class will point to the `VMLDrawing` class.",
    "!url": "http://yuilibrary.com/classes/VMLDrawing.html",
    "prototype": {
     "curveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_curveTo"
     },
     "relativeCurveTo": {
      "!type": "fn(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number) -> !this",
      "!doc": "Draws a bezier curve.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_relativeCurveTo"
     },
     "quadraticCurveTo": {
      "!type": "fn(cpx: number, cpy: number, x: number, y: number) -> !this",
      "!doc": "Draws a quadratic bezier curve.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_quadraticCurveTo"
     },
     "relativeQuadraticCurveTo": {
      "!type": "fn(cpx: number, cpy: number, x: number, y: number) -> !this",
      "!doc": "Draws a quadratic bezier curve relative to the current position.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_relativeQuadraticCurveTo"
     },
     "drawRect": {
      "!type": "fn(x: number, y: number, w: number, h: number, ew: number, eh: number) -> !this",
      "!doc": "Draws a rectangle with rounded corners.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_drawRect"
     },
     "lineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment from the current drawing position to the specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_lineTo"
     },
     "relativeLineTo": {
      "!type": "fn(point1: number, point2: number) -> !this",
      "!doc": "Draws a line segment using the current line style from the current drawing position to the relative x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_relativeLineTo"
     },
     "moveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_moveTo"
     },
     "relativeMoveTo": {
      "!type": "fn(x: number, y: number) -> !this",
      "!doc": "Moves the current drawing position relative to specified x and y coordinates.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_relativeMoveTo"
     },
     "end": {
      "!type": "fn() -> !this",
      "!doc": "Completes a drawing operation.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_end"
     },
     "closePath": {
      "!type": "fn() -> !this",
      "!doc": "Ends a fill and stroke",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_closePath"
     },
     "clear": {
      "!type": "fn() -> !this",
      "!doc": "Clears the path.",
      "!url": "http://yuilibrary.com/classes/VMLDrawing.html#method_clear"
     }
    }
   },
   "VMLEllipse": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> implementation of the <a href=\"Ellipse.html\">`Ellipse`</a> class.\n`VMLEllipse` is not intended to be used directly. Instead, use the <a href=\"Ellipse.html\">`Ellipse`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> and <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a>\ncapabilities, the <a href=\"Ellipse.html\">`Ellipse`</a> class will point to the `VMLEllipse` class.",
    "!url": "http://yuilibrary.com/classes/VMLEllipse.html",
    "prototype": {
     "xRadius": {
      "!type": "fn()",
      "!doc": "Horizontal radius for the ellipse.",
      "!url": "http://yuilibrary.com/classes/VMLEllipse.html#config_xRadius"
     },
     "yRadius": {
      "!type": "fn()",
      "!doc": "Vertical radius for the ellipse.",
      "!url": "http://yuilibrary.com/classes/VMLEllipse.html#config_yRadius"
     }
    }
   },
   "VMLGraphic": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> implementation of the <a href=\"Graphic.html\">`Graphic`</a> class.\n`VMLGraphic` is not intended to be used directly. Instead, use the <a href=\"Graphic.html\">`Graphic`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> and <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a>\ncapabilities, the <a href=\"Graphic.html\">`Graphic`</a> class will point to the `VMLGraphic` class.",
    "!url": "http://yuilibrary.com/classes/VMLGraphic.html",
    "prototype": {
     "render": {
      "!type": "fn(parentNode: HTMLElement)",
      "!doc": "Adds the graphics node to the dom.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_render"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_id"
     },
     "shapes": {
      "!type": "fn()",
      "!doc": "Key value pairs in which a shape instance is associated with its id.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_shapes"
     },
     "contentBounds": {
      "!type": "fn()",
      "!doc": "Object containing size and coordinate data for the content of a Graphic in relation to the coordSpace node.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_contentBounds"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The html element that represents to coordinate system of the Graphic instance.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_node"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the `Graphic`.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_height"
     },
     "autoSize": {
      "!type": "fn()",
      "!doc": "Determines the sizing of the Graphic.\n\n<dl>\n    <dt>sizeContentToGraphic</dt><dd>The Graphic's width and height attributes are, either explicitly set through the\n    <code>width</code> and <code>height</code> attributes or are determined by the dimensions of the parent element. The\n    content contained in the Graphic will be sized to fit with in the Graphic instance's dimensions. When using this\n    setting, the <code>preserveAspectRatio</code> attribute will determine how the contents are sized.</dd>\n    <dt>sizeGraphicToContent</dt><dd>(Also accepts a value of true) The Graphic's width and height are determined by the\n    size and positioning of the content.</dd>\n    <dt>false</dt><dd>The Graphic's width and height attributes are, either explicitly set through the <code>width</code>\n    and <code>height</code> attributes or are determined by the dimensions of the parent element. The contents of the\n    Graphic instance are not affected by this setting.</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_autoSize"
     },
     "preserveAspectRatio": {
      "!type": "fn()",
      "!doc": "Determines how content is sized when <code>autoSize</code> is set to <code>sizeContentToGraphic</code>.\n\n <dl>\n     <dt>none<dt><dd>Do not force uniform scaling. Scale the graphic content of the given element non-uniformly if necessary\n     such that the element's bounding box exactly matches the viewport rectangle.</dd>\n     <dt>xMinYMin</dt><dd>Force uniform scaling position along the top left of the Graphic's node.</dd>\n     <dt>xMidYMin</dt><dd>Force uniform scaling horizontally centered and positioned at the top of the Graphic's node.<dd>\n     <dt>xMaxYMin</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the top.</dd>\n     <dt>xMinYMid</dt>Force uniform scaling positioned horizontally from the left and vertically centered.</dd>\n     <dt>xMidYMid (the default)</dt><dd>Force uniform scaling with the content centered.</dd>\n     <dt>xMaxYMid</dt><dd>Force uniform scaling positioned horizontally from the right and vertically centered.</dd>\n     <dt>xMinYMax</dt><dd>Force uniform scaling positioned horizontally from the left and vertically from the bottom.</dd>\n     <dt>xMidYMax</dt><dd>Force uniform scaling horizontally centered and position vertically from the bottom.</dd>\n     <dt>xMaxYMax</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the bottom.</dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_preserveAspectRatio"
     },
     "resizeDown": {
      "!type": "fn()",
      "!doc": "The contentBounds will resize to greater values but not values. (for performance)\nWhen resizing the contentBounds down is desirable, set the resizeDown value to true.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_resizeDown"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y-coordinate for the instance.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#config_y"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_set"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the graphic instance in page coordinates.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_getXY"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Removes all nodes.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_destroy"
     },
     "addShape": {
      "!type": "fn(cfg: yui.Object) -> ?",
      "!doc": "Generates a shape instance by type.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_addShape"
     },
     "removeShape": {
      "!type": "fn(shape: graphics.Shape)",
      "!doc": "Removes a shape instance from from the graphic instance.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_removeShape"
     },
     "removeAllShapes": {
      "!type": "fn()",
      "!doc": "Removes all shape instances from the dom.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_removeAllShapes"
     },
     "clear": {
      "!type": "fn()",
      "!doc": "Clears the graphics object.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_clear"
     },
     "setSize": {
      "!type": "fn(w: number, h: number)",
      "!doc": "Sets the size of the graphics object.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_setSize"
     },
     "setPosition": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Sets the positon of the graphics object.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_setPosition"
     },
     "getShapeById": {
      "!type": "fn(id: string) -> ?",
      "!doc": "Returns a shape based on the id of its dom node.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_getShapeById"
     },
     "batch": {
      "!type": "fn(method: fn())",
      "!doc": "Allows for creating multiple shapes in order to batch appending and redraw operations.",
      "!url": "http://yuilibrary.com/classes/VMLGraphic.html#method_batch"
     }
    }
   },
   "VMLPath": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> implementation of the <a href=\"Path.html\">`Path`</a> class.\n`VMLPath` is not intended to be used directly. Instead, use the <a href=\"Path.html\">`Path`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> and <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a>\ncapabilities, the <a href=\"Path.html\">`Path`</a> class will point to the `VMLPath` class.",
    "!url": "http://yuilibrary.com/classes/VMLPath.html",
    "prototype": {
     "width": {
      "!type": "fn()",
      "!doc": "Indicates the width of the shape",
      "!url": "http://yuilibrary.com/classes/VMLPath.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Indicates the height of the shape",
      "!url": "http://yuilibrary.com/classes/VMLPath.html#config_height"
     },
     "path": {
      "!type": "fn()",
      "!doc": "Indicates the path used for the node.",
      "!url": "http://yuilibrary.com/classes/VMLPath.html#config_path"
     }
    }
   },
   "VMLPieSlice": {
    "!type": "fn()",
    "!doc": "Draws pie slices",
    "!url": "http://yuilibrary.com/classes/VMLPieSlice.html",
    "prototype": {
     "startAngle": {
      "!type": "fn()",
      "!doc": "Starting angle in relation to a circle in which to begin the pie slice drawing.",
      "!url": "http://yuilibrary.com/classes/VMLPieSlice.html#config_startAngle"
     },
     "arc": {
      "!type": "fn()",
      "!doc": "Arc of the slice.",
      "!url": "http://yuilibrary.com/classes/VMLPieSlice.html#config_arc"
     },
     "radius": {
      "!type": "fn()",
      "!doc": "Radius of the circle in which the pie slice is drawn",
      "!url": "http://yuilibrary.com/classes/VMLPieSlice.html#config_radius"
     }
    }
   },
   "VMLShape": {
    "!type": "fn()",
    "!doc": "<a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a> implementation of the <a href=\"Shape.html\">`Shape`</a> class.\n`VMLShape` is not intended to be used directly. Instead, use the <a href=\"Shape.html\">`Shape`</a> class.\nIf the browser lacks <a href=\"http://www.w3.org/TR/SVG/\">SVG</a> and <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a>\ncapabilities, the <a href=\"Shape.html\">`Shape`</a> class will point to the `VMLShape` class.",
    "!url": "http://yuilibrary.com/classes/VMLShape.html",
    "prototype": {
     "addClass": {
      "!type": "fn(className: string)",
      "!doc": "Add a class name to each node.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(className: string)",
      "!doc": "Removes a class name from each node.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_removeClass"
     },
     "getXY": {
      "!type": "fn() -> ?",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_getXY"
     },
     "setXY": {
      "!type": "fn(Contains: yui.Array)",
      "!doc": "Set the position of the shape in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_setXY"
     },
     "contains": {
      "!type": "fn(needle: graphics.VMLShape) -> ?",
      "!doc": "Determines whether the node is an ancestor of another HTML element in the DOM hierarchy.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_contains"
     },
     "compareTo": {
      "!type": "fn(refNode: HTMLElement) -> bool",
      "!doc": "Compares nodes to determine if they match.\nNode instances can be compared to each other and/or HTMLElements.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_compareTo"
     },
     "test": {
      "!type": "fn(selector: string) -> ?",
      "!doc": "Test if the supplied node matches the supplied selector.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_test"
     },
     "translate": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Specifies a 2d translation.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_translate"
     },
     "translateX": {
      "!type": "fn(x: number)",
      "!doc": "Translates the shape along the x-axis. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_translateX"
     },
     "translateY": {
      "!type": "fn(y: number)",
      "!doc": "Performs a translate on the y-coordinate. When translating x and y coordinates,\nuse the `translate` method.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_translateY"
     },
     "skew": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Skews the shape around the x-axis and y-axis.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_skew"
     },
     "skewX": {
      "!type": "fn(x: number)",
      "!doc": "Skews the shape around the x-axis.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_skewX"
     },
     "skewY": {
      "!type": "fn(y: number)",
      "!doc": "Skews the shape around the y-axis.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_skewY"
     },
     "rotate": {
      "!type": "fn(deg: number)",
      "!doc": "Rotates the shape clockwise around it transformOrigin.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_rotate"
     },
     "scale": {
      "!type": "fn(val: number)",
      "!doc": "Specifies a 2d scaling operation.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_scale"
     },
     "set": {
      "!type": "fn(name: string, value: Any)",
      "!doc": "Sets the value of an attribute.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_set"
     },
     "getBounds": {
      "!type": "fn() -> ?",
      "!doc": "Returns the bounds for a shape.\n\nCalculates the a new bounding box from the original corner coordinates (base on size and position) and the transform matrix.\nThe calculated bounding box is used by the graphic instance to calculate its viewBox.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_getBounds"
     },
     "toFront": {
      "!type": "fn()",
      "!doc": "Places the shape underneath all other shapes.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_toFront"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Destroys shape",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#method_destroy"
     },
     "transformOrigin": {
      "!type": "fn()",
      "!doc": "An array of x, y values which indicates the transformOrigin in which to rotate the shape. Valid values range between 0 and 1 representing a\nfraction of the shape's corresponding bounding box dimension. The default value is [0.5, 0.5].",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_transformOrigin"
     },
     "transform": {
      "!type": "fn()",
      "!doc": "<p>A string containing, in order, transform operations applied to the shape instance. The `transform` string can contain the following values:\n\n   <dl>\n       <dt>rotate</dt><dd>Rotates the shape clockwise around it transformOrigin.</dd>\n       <dt>translate</dt><dd>Specifies a 2d translation.</dd>\n       <dt>skew</dt><dd>Skews the shape around the x-axis and y-axis.</dd>\n       <dt>scale</dt><dd>Specifies a 2d scaling operation.</dd>\n       <dt>translateX</dt><dd>Translates the shape along the x-axis.</dd>\n       <dt>translateY</dt><dd>Translates the shape along the y-axis.</dd>\n       <dt>skewX</dt><dd>Skews the shape around the x-axis.</dd>\n       <dt>skewY</dt><dd>Skews the shape around the y-axis.</dd>\n       <dt>matrix</dt><dd>Specifies a 2D transformation matrix comprised of the specified six values.</dd>\n   </dl>\n</p>\n<p>Applying transforms through the transform attribute will reset the transform matrix and apply a new transform. The shape class also contains\ncorresponding methods for each transform that will apply the transform to the current matrix. The below code illustrates how you might use the\n`transform` attribute to instantiate a recangle with a rotation of 45 degrees.</p>\n           var myRect = new Y.Rect({\n               type:\"rect\",\n               width: 50,\n               height: 40,\n               transform: \"rotate(45)\"\n           };\n<p>The code below would apply `translate` and `rotate` to an existing shape.</p>\n\n       myRect.set(\"transform\", \"translate(40, 50) rotate(45)\");",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_transform"
     },
     "x": {
      "!type": "fn()",
      "!doc": "Indicates the x position of shape.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_x"
     },
     "y": {
      "!type": "fn()",
      "!doc": "Indicates the y position of shape.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_y"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique id for class instance.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_id"
     },
     "width": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_width"
     },
     "height": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_height"
     },
     "visible": {
      "!type": "fn()",
      "!doc": "Indicates whether the shape is visible.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_visible"
     },
     "fill": {
      "!type": "fn()",
      "!doc": "Contains information about the fill of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the fill.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1.</dd>\n     <dt>type</dt><dd>Type of fill.\n         <dl>\n             <dt>solid</dt><dd>Solid single color fill. (default)</dd>\n             <dt>linear</dt><dd>Linear gradient fill.</dd>\n             <dt>radial</dt><dd>Radial gradient fill.</dd>\n         </dl>\n     </dd>\n </dl>\n <p>If a `linear` or `radial` is specified as the fill type. The following additional property is used:\n <dl>\n     <dt>stops</dt><dd>An array of objects containing the following properties:\n         <dl>\n             <dt>color</dt><dd>The color of the stop.</dd>\n             <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stop. The default value is 1.\n             Note: No effect for IE 6 - 8</dd>\n             <dt>offset</dt><dd>Number between 0 and 1 indicating where the color stop is positioned.</dd>\n         </dl>\n     </dd>\n     <p>Linear gradients also have the following property:</p>\n     <dt>rotation</dt><dd>Linear gradients flow left to right by default. The rotation property allows you to change the\n     flow by rotation. (e.g. A rotation of 180 would make the gradient pain from right to left.)</dd>\n     <p>Radial gradients have the following additional properties:</p>\n     <dt>r</dt><dd>Radius of the gradient circle.</dd>\n     <dt>fx</dt><dd>Focal point x-coordinate of the gradient.</dd>\n     <dt>fy</dt><dd>Focal point y-coordinate of the gradient.</dd>\n </dl>\n <p>The corresponding `SVGShape` class implements the following additional properties.</p>\n <dl>\n     <dt>cx</dt><dd>\n         <p>The x-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and\n         `VMLShape` classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n     <dt>cy</dt><dd>\n         <p>The y-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>\n         <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and `VMLShape`\n         classes which are used on Android or IE 6 - 8.</p>\n     </dd>\n </dl>\n <p>These properties are not currently implemented in `CanvasShape` or `VMLShape`.</p>",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_fill"
     },
     "stroke": {
      "!type": "fn()",
      "!doc": "Contains information about the stroke of the shape.\n <dl>\n     <dt>color</dt><dd>The color of the stroke.</dd>\n     <dt>weight</dt><dd>Number that indicates the width of the stroke.</dd>\n     <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stroke. The default value is 1.</dd>\n     <dt>dashstyle</dt>Indicates whether to draw a dashed stroke. When set to \"none\", a solid stroke is drawn. When set\n     to an array, the first index indicates the length of the dash. The second index indicates the length of gap.\n     <dt>linecap</dt><dd>Specifies the linecap for the stroke. The following values can be specified:\n         <dl>\n             <dt>butt (default)</dt><dd>Specifies a butt linecap.</dd>\n             <dt>square</dt><dd>Specifies a sqare linecap.</dd>\n             <dt>round</dt><dd>Specifies a round linecap.</dd>\n         </dl>\n     </dd>\n     <dt>linejoin</dt><dd>Specifies a linejoin for the stroke. The following values can be specified:\n         <dl>\n             <dt>round (default)</dt><dd>Specifies that the linejoin will be round.</dd>\n             <dt>bevel</dt><dd>Specifies a bevel for the linejoin.</dd>\n             <dt>miter limit</dt><dd>An integer specifying the miter limit of a miter linejoin. If you want to specify a linejoin\n             of miter, you simply specify the limit as opposed to having separate miter and miter limit values.</dd>\n         </dl>\n     </dd>\n </dl>",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_stroke"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Dom node for the shape.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_node"
     },
     "data": {
      "!type": "fn()",
      "!doc": "Represents an SVG Path string. This will be parsed and added to shape's API to represent the SVG data across all\nimplementations. Note that when using VML or SVG implementations, part of this content will be added to the DOM using\nrespective VML/SVG attributes. If your content comes from an untrusted source, you will need to ensure that no\nmalicious code is included in that content.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_data"
     },
     "graphic": {
      "!type": "fn()",
      "!doc": "Reference to the container Graphic.",
      "!url": "http://yuilibrary.com/classes/VMLShape.html#config_graphic"
     }
    }
   },
   "Handlebars": {
    "!type": "fn()",
    "!doc": "Handlebars is a simple template language inspired by Mustache.\n\nThis is a YUI port of the original Handlebars project, which can be found at\n<https://github.com/wycats/handlebars.js>.",
    "!url": "http://yuilibrary.com/classes/Handlebars.html",
    "prototype": {
     "registerHelper": {
      "!type": "fn(name: string, fn: fn(), inverse?: bool)",
      "!doc": "Registers a helper function that will be made available to all templates.\n\nHelper functions receive the current template context as the `this` object, and\ncan also receive arguments passed by the template.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_registerHelper"
     },
     "registerPartial": {
      "!type": "fn(name: string, partial: fn())",
      "!doc": "Registers a partial that will be made available to all templates.\n\nA partial is another template that can be used to render part of a larger\ntemplate. For example, a website with a common header and footer across all its\npages might use a template for each page, which would call shared partials to\nrender the headers and footers.\n\nPartials may be specified as uncompiled template strings or as compiled template\nfunctions.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_registerPartial"
     },
     "template": {
      "!type": "fn(template: fn()) -> fn()",
      "!doc": "Converts a precompiled template into a renderable template function.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_template"
     }
    }
   }
  },
  "handlebars": {
   "Handlebars": {
    "!type": "fn()",
    "!doc": "Handlebars is a simple template language inspired by Mustache.\n\nThis is a YUI port of the original Handlebars project, which can be found at\n<https://github.com/wycats/handlebars.js>.",
    "!url": "http://yuilibrary.com/classes/Handlebars.html",
    "prototype": {
     "log": {
      "!type": "fn(level: string, message: string)",
      "!doc": "Logs a debugging message. Note that messages will only be logged when the\nhandlebars module is loaded in \"debug\" mode.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_log"
     },
     "render": {
      "!type": "fn(string: string, context: yui.Object, options?: yui.Object) -> string",
      "!doc": "Compiles and renders a Handlebars template string in a single step.\n\nIf you'll be using a template more than once, it's more efficient to compile it\ninto a function once using `compile()`, and then render it whenever you need to\nby simply executing the compiled function. However, if you only need to compile\nand render a template once, `render()` is a handy shortcut for doing both in a\nsingle step.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_render"
     },
     "compile": {
      "!type": "fn(string: string, options?: yui.Object) -> fn()",
      "!doc": "Compiles a Handlebars template string into a function. To render the template,\ncall the function and pass in a context object.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_compile"
     },
     "precompile": {
      "!type": "fn(string: string, options?: yui.Object) -> string",
      "!doc": "Precompiles a Handlebars template string into a string of JavaScript code. This\ncan be used to precompile a template at build time or on the server, and the\nresulting template can then be rendered at runtime or on the client without\nneeding to go through a compile step.\n\nTo render a precompiled template, evaluate the code and then pass the resulting\nfunction to `Y.Handlebars.template()` to get back an executable template\nfunction.",
      "!url": "http://yuilibrary.com/classes/Handlebars.html#method_precompile"
     }
    }
   }
  },
  "highlight": {
   "Highlight": {
    "!type": "fn()",
    "!doc": "Provides methods for highlighting strings within other strings by wrapping\nthem in HTML.\n\nThe highlight methods first escape any special HTML characters in the input\nstrings and then highlight the appropriate substrings by wrapping them in a\n`<b class=\"yui3-highlight\"></b>` element. The `<b>` element is used rather than\n`<strong>` in accordance with HTML5's definition of `<b>` as being purely\npresentational, which is exactly what highlighting is.",
    "!url": "http://yuilibrary.com/classes/Highlight.html",
    "allFold": {
     "!type": "fn(haystack: string, needles: string, options?: yui.Object) -> string",
     "!doc": "Accent-folding version of `all()`.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_allFold"
    },
    "startFold": {
     "!type": "fn(haystack: string, needles: string) -> string",
     "!doc": "Accent-folding version of `start()`.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_startFold"
    },
    "wordsFold": {
     "!type": "fn(haystack: string, needles: string) -> string",
     "!doc": "Accent-folding version of `words()`.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_wordsFold"
    },
    "all": {
     "!type": "fn(haystack: string, needles: string, options?: yui.Object) -> string",
     "!doc": "Highlights all occurrences in the _haystack_ string of the items in the\n_needles_ array, regardless of where they occur. The returned string will\nhave all HTML characters escaped except for the highlighting markup.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_all"
    },
    "allCase": {
     "!type": "fn(haystack: string, needles: string, options?: yui.Object) -> string",
     "!doc": "Same as `all()`, but case-sensitive by default.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_allCase"
    },
    "start": {
     "!type": "fn(haystack: string, needles: string, options?: yui.Object) -> string",
     "!doc": "Highlights _needles_ that occur at the start of _haystack_. The returned\nstring will have all HTML characters escaped except for the highlighting\nmarkup.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_start"
    },
    "startCase": {
     "!type": "fn(haystack: string, needles: string) -> string",
     "!doc": "Same as `start()`, but case-sensitive by default.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_startCase"
    },
    "words": {
     "!type": "fn(haystack: string, needles: string, options?: yui.Object) -> string",
     "!doc": "Highlights complete words in the _haystack_ string that are also in the\n_needles_ array. The returned string will have all HTML characters escaped\nexcept for the highlighting markup.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_words"
    },
    "wordsCase": {
     "!type": "fn(haystack: string, needles: string) -> string",
     "!doc": "Same as `words()`, but case-sensitive by default.",
     "!url": "http://yuilibrary.com/classes/Highlight.html#method_wordsCase"
    }
   }
  },
  "history": {
   "HistoryBase": {
    "!type": "fn()",
    "!doc": "Provides global state management backed by an object, but with no browser\nhistory integration. For actual browser history integration and back/forward\nsupport, use the history-html5 or history-hash modules.",
    "!url": "http://yuilibrary.com/classes/HistoryBase.html",
    "NAME": {
     "!type": "string",
     "!doc": "Name of this component.",
     "!url": "http://yuilibrary.com/classes/HistoryBase.html#property_NAME"
    },
    "SRC_ADD": {
     "!type": "string",
     "!doc": "Constant used to identify state changes originating from the\n<code>add()</code> method.",
     "!url": "http://yuilibrary.com/classes/HistoryBase.html#property_SRC_ADD"
    },
    "SRC_REPLACE": {
     "!type": "string",
     "!doc": "Constant used to identify state changes originating from the\n<code>replace()</code> method.",
     "!url": "http://yuilibrary.com/classes/HistoryBase.html#property_SRC_REPLACE"
    },
    "html5": {
     "!type": "bool",
     "!doc": "Whether or not this browser supports the HTML5 History API.",
     "!url": "http://yuilibrary.com/classes/HistoryBase.html#property_html5"
    },
    "nativeHashChange": {
     "!type": "bool",
     "!doc": "Whether or not this browser supports the <code>window.onhashchange</code>\nevent natively. Note that even if this is <code>true</code>, you may\nstill want to use HistoryHash's synthetic <code>hashchange</code> event\nsince it normalizes implementation differences and fixes spec violations\nacross various browsers.",
     "!url": "http://yuilibrary.com/classes/HistoryBase.html#property_nativeHashChange"
    },
    "prototype": {
     "force": {
      "!type": "bool",
      "!doc": "If `true`, a `history:change` event will be fired whenever the URL\nchanges, even if there is no associated state change.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#property_force"
     },
     "history:change": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Fired when the state changes. To be notified of all state changes\nregardless of the History or YUI instance that generated them,\nsubscribe to this event on <code>Y.Global</code>. If you would rather\nbe notified only about changes generated by this specific History\ninstance, subscribe to this event on the instance.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#event_history:change"
     },
     "add": {
      "!type": "fn(state: yui.Object, options: yui.Object) -> !this",
      "!doc": "Adds a state entry with new values for the specified keys. By default,\nthe new state will be merged into the existing state, and new values will\noverride existing values. Specifying a <code>null</code> or\n<code>undefined</code> value will cause that key to be removed from the\nnew state entry.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#method_add"
     },
     "addValue": {
      "!type": "fn(key: string, value: string, options: yui.Object) -> !this",
      "!doc": "Adds a state entry with a new value for a single key. By default, the new\nvalue will be merged into the existing state values, and will override an\nexisting value with the same key if there is one. Specifying a\n<code>null</code> or <code>undefined</code> value will cause the key to\nbe removed from the new state entry.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#method_addValue"
     },
     "get": {
      "!type": "fn(key: string) -> +yui.Object",
      "!doc": "Returns the current value of the state parameter specified by <i>key</i>,\nor an object hash of key/value pairs for all current state parameters if\nno key is specified.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#method_get"
     },
     "replace": {
      "!type": "fn(state: yui.Object, options: yui.Object) -> !this",
      "!doc": "Same as <code>add()</code> except that a new browser history entry will\nnot be created. Instead, the current history entry will be replaced with\nthe new state.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#method_replace"
     },
     "replaceValue": {
      "!type": "fn(key: string, value: string, options: yui.Object) -> !this",
      "!doc": "Same as <code>addValue()</code> except that a new browser history entry\nwill not be created. Instead, the current history entry will be replaced\nwith the new state.",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#method_replaceValue"
     },
     "[key]Change": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "<p>\nDynamic event fired when an individual history item is added or\nchanged. The name of this event depends on the name of the key that\nchanged. To listen to change events for a key named \"foo\", subscribe\nto the <code>fooChange</code> event; for a key named \"bar\", subscribe\nto <code>barChange</code>, etc.\n</p>\n\n<p>\nKey-specific events are only fired for instance-level changes; that\nis, changes that were made via the same History instance on which the\nevent is subscribed. To be notified of changes made by other History\ninstances, subscribe to the global <code>history:change</code> event.\n</p>",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#event_[key]Change"
     },
     "[key]Remove": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "<p>\nDynamic event fired when an individual history item is removed. The\nname of this event depends on the name of the key that was removed.\nTo listen to remove events for a key named \"foo\", subscribe to the\n<code>fooRemove</code> event; for a key named \"bar\", subscribe to\n<code>barRemove</code>, etc.\n</p>\n\n<p>\nKey-specific events are only fired for instance-level changes; that\nis, changes that were made via the same History instance on which the\nevent is subscribed. To be notified of changes made by other History\ninstances, subscribe to the global <code>history:change</code> event.\n</p>",
      "!url": "http://yuilibrary.com/classes/HistoryBase.html#event_[key]Remove"
     }
    }
   },
   "HistoryHash": {
    "!type": "fn()",
    "!doc": "Provides browser history management backed by\n<code>window.location.hash</code>, as well as convenience methods for working\nwith the location hash and a synthetic <code>hashchange</code> event that\nnormalizes differences across browsers.",
    "!url": "http://yuilibrary.com/classes/HistoryHash.html",
    "getIframeHash": {
     "!type": "fn() -> string",
     "!doc": "Gets the raw (not decoded) current location hash from the IE iframe,\nminus the preceding '#' character and the hashPrefix (if one is set).",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_getIframeHash"
    },
    "SRC_HASH": {
     "!type": "string",
     "!doc": "Constant used to identify state changes originating from\n<code>hashchange</code> events.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#property_SRC_HASH"
    },
    "hashPrefix": {
     "!type": "string",
     "!doc": "<p>\nPrefix to prepend when setting the hash fragment. For example, if the\nprefix is <code>!</code> and the hash fragment is set to\n<code>#foo=bar&baz=quux</code>, the final hash fragment in the URL will\nbecome <code>#!foo=bar&baz=quux</code>. This can be used to help make an\nAjax application crawlable in accordance with Google's guidelines at\n<a href=\"http://code.google.com/web/ajaxcrawling/\">http://code.google.com/web/ajaxcrawling/</a>.\n</p>\n\n<p>\nNote that this prefix applies to all HistoryHash instances. It's not\npossible for individual instances to use their own prefixes since they\nall operate on the same URL.\n</p>",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#property_hashPrefix"
    },
    "createHash": {
     "!type": "fn(params: yui.Object) -> string",
     "!doc": "Creates a location hash string from the specified object of key/value\npairs.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_createHash"
    },
    "decode": {
     "!type": "fn(string: string) -> string",
     "!doc": "Wrapper around <code>decodeURIComponent()</code> that also converts +\nchars into spaces.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_decode"
    },
    "encode": {
     "!type": "fn(string: string) -> string",
     "!doc": "Wrapper around <code>encodeURIComponent()</code> that converts spaces to\n+ chars.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_encode"
    },
    "getHash": {
     "!type": "fn() -> string",
     "!doc": "Gets the raw (not decoded) current location hash, minus the preceding '#'\ncharacter and the hashPrefix (if one is set).",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_getHash"
    },
    "getUrl": {
     "!type": "fn() -> string",
     "!doc": "Gets the current bookmarkable URL.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_getUrl"
    },
    "parseHash": {
     "!type": "fn(hash: string) -> +yui.Object",
     "!doc": "Parses a location hash string into an object of key/value parameter\npairs. If <i>hash</i> is not specified, the current location hash will\nbe used.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_parseHash"
    },
    "replaceHash": {
     "!type": "fn(hash: string)",
     "!doc": "Replaces the browser's current location hash with the specified hash\nand removes all forward navigation states, without creating a new browser\nhistory entry. Automatically prepends the <code>hashPrefix</code> if one\nis set.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_replaceHash"
    },
    "setHash": {
     "!type": "fn(hash: string)",
     "!doc": "Sets the browser's location hash to the specified string. Automatically\nprepends the <code>hashPrefix</code> if one is set.",
     "!url": "http://yuilibrary.com/classes/HistoryHash.html#method_setHash"
    }
   },
   "hashchange": {
    "!type": "fn(e: event_custom.EventFacade)",
    "!doc": "Synthetic <code>window.onhashchange</code> event that normalizes differences\nacross browsers and provides support for browsers that don't natively support\n<code>onhashchange</code>.\n\nThis event is provided by the <code>history-hash</code> module.",
    "!url": "http://yuilibrary.com/classes/YUI.html#event_hashchange"
   },
   "HistoryHTML5": {
    "!type": "fn(config: yui.Object) -> +history.HistoryHTML5",
    "!proto": "history.HistoryBase",
    "!doc": "<p>\nProvides browser history management using the HTML5 history API.\n</p>\n\n<p>\nWhen calling the <code>add()</code>, <code>addValue()</code>,\n<code>replace()</code>, or <code>replaceValue()</code> methods on\n<code>HistoryHTML5</code>, the following additional options are supported:\n</p>\n\n<dl>\n  <dt><strong>title (String)</strong></dt>\n  <dd>\n    Title to use for the new history entry. Browsers will typically display\n    this title to the user in the detailed history window or in a dropdown\n    menu attached to the back/forward buttons. If not specified, the title\n    of the current document will be used.\n  </dd>\n\n  <dt><strong>url (String)</strong></dt>\n  <dd>\n    URL to display to the user for the new history entry. This URL will be\n    visible in the browser's address bar and will be the bookmarked URL if\n    the user bookmarks the page. It may be a relative path (\"foo/bar\"), an\n    absolute path (\"/foo/bar\"), or a full URL (\"http://example.com/foo/bar\").\n    If you specify a full URL, the origin <i>must</i> be the same as the\n    origin of the current page, or an error will occur. If no URL is\n    specified, the current URL will not be changed.\n  </dd>\n</dl>",
    "!url": "http://yuilibrary.com/classes/HistoryHTML5.html",
    "SRC_POPSTATE": {
     "!type": "string",
     "!doc": "Constant used to identify state changes originating from\n<code>popstate</code> events.",
     "!url": "http://yuilibrary.com/classes/HistoryHTML5.html#property_SRC_POPSTATE"
    }
   },
   "config": {
    "!type": "fn()",
    "!doc": "Config object that contains all of the configuration options for\nthis `YUI` instance.\n\nThis object is supplied by the implementer when instantiating YUI. Some\nproperties have default values if they are not supplied by the implementer.\n\nThis object should not be updated directly because some values are cached. Use\n`applyConfig()` to update the config object on a YUI instance that has already\nbeen configured.",
    "!url": "http://yuilibrary.com/classes/config.html",
    "prototype": {
     "useHistoryHTML5": {
      "!type": "+boolean",
      "!doc": "<p>\nIf <code>true</code>, the <code>Y.History</code> alias will always point to\n<code>Y.HistoryHTML5</code> when the history-html5 module is loaded, even if\nthe current browser doesn't support HTML5 history.\n</p>\n\n<p>\nIf <code>false</code>, the <code>Y.History</code> alias will always point to\n<code>Y.HistoryHash</code> when the history-hash module is loaded, even if\nthe current browser supports HTML5 history.\n</p>\n\n<p>\nIf neither <code>true</code> nor <code>false</code>, the\n<code>Y.History</code> alias will point to the best available history adapter\nthat the browser supports. This is the default behavior.\n</p>",
      "!url": "http://yuilibrary.com/classes/config.html#property_useHistoryHTML5"
     }
    }
   }
  },
  "imageloader": {
   "ImgLoadGroup": {
    "!type": "fn() -> +imageloader.ImgLoadGroup",
    "!proto": "base.Base",
    "!doc": "A group for images. A group can have one time limit and a series of triggers. Thus the images belonging to this group must share these constraints.",
    "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html",
    "prototype": {
     "name": {
      "!type": "fn()",
      "!doc": "Name for the group. Only used to identify the group in logging statements.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#attribute_name"
     },
     "timeLimit": {
      "!type": "fn()",
      "!doc": "Time limit, in seconds, after which images are fetched regardless of trigger events.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#attribute_timeLimit"
     },
     "foldDistance": {
      "!type": "fn()",
      "!doc": "Distance below the fold for which images are loaded. Images are not loaded until they are at most this distance away from (or above) the fold.\nThis check is performed at page load (domready) and after any window scroll or window resize event (until all images are loaded).",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#attribute_foldDistance"
     },
     "className": {
      "!type": "fn()",
      "!doc": "Class name that will identify images belonging to the group. This class name will be removed from each element in order to fetch images.\nThis class should have, in its CSS style definition, \"<code>background:none !important;</code>\".",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#attribute_className"
     },
     "classNameAction": {
      "!type": "fn()",
      "!doc": "Determines how to act when className is used as the way to delay load images. The \"default\" action is to just\nremove the class name. The \"enhanced\" action is to remove the class name and also set the src attribute if\nthe element is an img.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#attribute_classNameAction"
     },
     "addTrigger": {
      "!type": "fn(obj: yui.Object, type: string) -> !this",
      "!doc": "Adds a trigger to the group. Arguments are passed to <code>Y.on</code>.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#method_addTrigger"
     },
     "addCustomTrigger": {
      "!type": "fn(name: string, obj: yui.Object) -> !this",
      "!doc": "Adds a custom event trigger to the group.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#method_addCustomTrigger"
     },
     "registerImage": {
      "!type": "fn(config: yui.Object) -> +yui.Object",
      "!doc": "Registers an image with the group.\nArguments are passed through to a <code>Y.ImgLoadImgObj</code> constructor; see that class' attribute documentation for detailed information. \"<code>domId</code>\" is a required attribute.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#method_registerImage"
     },
     "fetch": {
      "!type": "fn()",
      "!doc": "Displays the images in the group.\nThis method is called when a trigger fires or the time limit expires; it shouldn't be called externally, but is not private in the rare event that it needs to be called immediately.",
      "!url": "http://yuilibrary.com/classes/ImgLoadGroup.html#method_fetch"
     }
    }
   },
   "ImgLoadImgObj": {
    "!type": "fn() -> +imageloader.ImgLoadImgObj",
    "!proto": "base.Base",
    "!doc": "Image objects to be registered with the groups",
    "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html",
    "prototype": {
     "domId": {
      "!type": "fn()",
      "!doc": "HTML DOM id of the image element.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_domId"
     },
     "bgUrl": {
      "!type": "fn()",
      "!doc": "Background URL for the image.\nFor an image whose URL is specified by \"<code>background-image</code>\" in the element's style.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_bgUrl"
     },
     "srcUrl": {
      "!type": "fn()",
      "!doc": "Source URL for the image.\nFor an image whose URL is specified by a \"<code>src</code>\" attribute in the DOM element.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_srcUrl"
     },
     "width": {
      "!type": "fn()",
      "!doc": "Pixel width of the image. Will be set as a <code>width</code> attribute on the DOM element after the image is fetched.\nDefaults to the natural width of the image (no <code>width</code> attribute will be set).\nUsually only used with src images.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_width"
     },
     "height": {
      "!type": "fn()",
      "!doc": "Pixel height of the image. Will be set as a <code>height</code> attribute on the DOM element after the image is fetched.\nDefaults to the natural height of the image (no <code>height</code> attribute will be set).\nUsually only used with src images.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_height"
     },
     "setVisible": {
      "!type": "fn()",
      "!doc": "Whether the image's <code>style.visibility</code> should be set to <code>visible</code> after the image is fetched.\nUsed when setting images as <code>visibility:hidden</code> prior to image fetching.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_setVisible"
     },
     "isPng": {
      "!type": "fn()",
      "!doc": "Whether the image is a PNG.\nPNG images get special treatment in that the URL is specified through AlphaImageLoader for IE, versions 6 and earlier.\nOnly used with background images.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_isPng"
     },
     "sizingMethod": {
      "!type": "fn()",
      "!doc": "AlphaImageLoader <code>sizingMethod</code> property to be set for the image.\nOnly set if <code>isPng</code> value for this image is set to <code>true</code>.\nDefaults to <code>scale</code>.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_sizingMethod"
     },
     "enabled": {
      "!type": "fn()",
      "!doc": "AlphaImageLoader <code>enabled</code> property to be set for the image.\nOnly set if <code>isPng</code> value for this image is set to <code>true</code>.\nDefaults to <code>true</code>.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#attribute_enabled"
     },
     "fetch": {
      "!type": "fn(withinY: number) -> bool",
      "!doc": "Displays the image; puts the URL into the DOM.\nThis method shouldn't be called externally, but is not private in the rare event that it needs to be called immediately.",
      "!url": "http://yuilibrary.com/classes/ImgLoadImgObj.html#method_fetch"
     }
    }
   }
  },
  "intl": {
   "Intl": {
    "!type": "fn()",
    "!doc": "The Intl utility provides a central location for managing sets of\nlocalized resources (strings and formatting patterns).",
    "!url": "http://yuilibrary.com/classes/Intl.html",
    "prototype": {
     "setLang": {
      "!type": "fn(module: string, lang: string) -> ?",
      "!doc": "Sets the active language for the given module.\n\nReturns false on failure, which would happen if the language had not been registered through the <a href=\"#method_add\">add()</a> method.",
      "!url": "http://yuilibrary.com/classes/Intl.html#method_setLang"
     },
     "getLang": {
      "!type": "fn(module: string) -> string",
      "!doc": "Get the currently active language for the given module.",
      "!url": "http://yuilibrary.com/classes/Intl.html#method_getLang"
     },
     "add": {
      "!type": "fn(module: string, lang: string, strings: yui.Object)",
      "!doc": "Register a hash of localized resources for the given module and language",
      "!url": "http://yuilibrary.com/classes/Intl.html#method_add"
     },
     "get": {
      "!type": "fn(module: string, key: string, lang: string) -> ?",
      "!doc": "Gets the module's localized resources for the currently active language (as provided by the <a href=\"#method_getLang\">getLang</a> method).\n<p>\nOptionally, the localized resources for alternate languages which have been added to Intl (see the <a href=\"#method_add\">add</a> method) can\nbe retrieved by providing the BCP 47 language tag as the lang parameter.\n</p>",
      "!url": "http://yuilibrary.com/classes/Intl.html#method_get"
     },
     "getAvailableLangs": {
      "!type": "fn(module: string) -> +yui.Array",
      "!doc": "Gets the list of languages for which localized resources are available for a given module, based on the module\nmeta-data (part of loader). If loader is not on the page, returns an empty array.",
      "!url": "http://yuilibrary.com/classes/Intl.html#method_getAvailableLangs"
     },
     "intl:langChange": {
      "!type": "fn(e: event_custom.EventFacade)",
      "!doc": "Notification event to indicate when the lang for a module has changed. There is no default behavior associated with this event,\nso the on and after moments are equivalent.",
      "!url": "http://yuilibrary.com/classes/Intl.html#event_intl:langChange"
     }
    }
   }
  },
  "io": {
   "IO": {
    "!type": "fn(config: yui.Object) -> +io.IO",
    "!doc": "The IO class is a utility that brokers HTTP requests through a simplified\ninterface.  Specifically, it allows JavaScript to make HTTP requests to\na resource without a page reload.  The underlying transport for making\nsame-domain requests is the XMLHttpRequest object.  IO can also use\nFlash, if specified as a transport, for cross-domain requests.",
    "!url": "http://yuilibrary.com/classes/IO.html",
    "prototype": {
     "start": {
      "!type": "fn(transaction: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:start\" and creates, fires a transaction-specific\nstart event, if `config.on.start` is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_start"
     },
     "io:start": {
      "!type": "fn()",
      "!doc": "Signals the start of an IO request.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:start"
     },
     "complete": {
      "!type": "fn(transaction: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:complete\" and creates, fires a\ntransaction-specific \"complete\" event, if config.on.complete is\ndefined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_complete"
     },
     "io:complete": {
      "!type": "fn()",
      "!doc": "Signals the completion of the request-response phase of a\ntransaction. Response status and data are accessible, if\navailable, in this event.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:complete"
     },
     "end": {
      "!type": "fn(transaction: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:end\" and creates, fires a transaction-specific \"end\"\nevent, if config.on.end is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_end"
     },
     "io:end": {
      "!type": "fn()",
      "!doc": "Signals the end of the transaction lifecycle.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:end"
     },
     "success": {
      "!type": "fn(transaction: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:success\" and creates, fires a transaction-specific\n\"success\" event, if config.on.success is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_success"
     },
     "io:success": {
      "!type": "fn()",
      "!doc": "Signals an HTTP response with status in the 2xx range.\nFires after io:complete.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:success"
     },
     "failure": {
      "!type": "fn(transaction: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:failure\" and creates, fires a transaction-specific\n\"failure\" event, if config.on.failure is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_failure"
     },
     "io:failure": {
      "!type": "fn()",
      "!doc": "Signals an HTTP response with status outside of the 2xx range.\nFires after io:complete.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:failure"
     },
     "progress": {
      "!type": "fn(transaction: yui.Object, progress: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:progress\" and creates, fires a transaction-specific\n\"progress\" event -- for XMLHttpRequest file upload -- if\nconfig.on.progress is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_progress"
     },
     "io:progress": {
      "!type": "fn()",
      "!doc": "Signals the interactive state during a file upload transaction.\nThis event fires after io:start and before io:complete.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:progress"
     },
     "load": {
      "!type": "fn(transaction: yui.Object, load: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:complete\" and creates, fires a transaction-specific\n\"complete\" event -- for XMLHttpRequest file upload -- if\nconfig.on.complete is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_load"
     },
     "error": {
      "!type": "fn(transaction: yui.Object, error: yui.Object, config: yui.Object)",
      "!doc": "Fires event \"io:failure\" and creates, fires a transaction-specific\n\"failure\" event -- for XMLHttpRequest file upload -- if\nconfig.on.failure is defined.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_error"
     },
     "setHeader": {
      "!type": "fn(name: string, value: string)",
      "!doc": "Stores default client headers for all transactions. If a label is\npassed with no value argument, the header will be deleted.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_setHeader"
     },
     "send": {
      "!type": "fn(uri: string, config: yui.Object, id: number) -> +yui.Object",
      "!doc": "Requests a transaction. `send()` is implemented as `Y.io()`.  Each\ntransaction may include a configuration object.  Its properties are:\n\n<dl>\n  <dt>method</dt>\n    <dd>HTTP method verb (e.g., GET or POST). If this property is not\n        not defined, the default value will be GET.</dd>\n\n  <dt>data</dt>\n    <dd>This is the name-value string that will be sent as the\n    transaction data. If the request is HTTP GET, the data become\n    part of querystring. If HTTP POST, the data are sent in the\n    message body.</dd>\n\n  <dt>xdr</dt>\n    <dd>Defines the transport to be used for cross-domain requests.\n    By setting this property, the transaction will use the specified\n    transport instead of XMLHttpRequest. The properties of the\n    transport object are:\n    <dl>\n      <dt>use</dt>\n        <dd>The transport to be used: 'flash' or 'native'</dd>\n      <dt>dataType</dt>\n        <dd>Set the value to 'XML' if that is the expected response\n        content type.</dd>\n      <dt>credentials</dt>\n        <dd>Set the value to 'true' to set XHR.withCredentials property to true.</dd>\n    </dl></dd>\n\n  <dt>form</dt>\n    <dd>Form serialization configuration object.  Its properties are:\n    <dl>\n      <dt>id</dt>\n        <dd>Node object or id of HTML form</dd>\n      <dt>useDisabled</dt>\n        <dd>`true` to also serialize disabled form field values\n        (defaults to `false`)</dd>\n    </dl></dd>\n\n  <dt>on</dt>\n    <dd>Assigns transaction event subscriptions. Available events are:\n    <dl>\n      <dt>start</dt>\n        <dd>Fires when a request is sent to a resource.</dd>\n      <dt>complete</dt>\n        <dd>Fires when the transaction is complete.</dd>\n      <dt>success</dt>\n        <dd>Fires when the HTTP response status is within the 2xx\n        range.</dd>\n      <dt>failure</dt>\n        <dd>Fires when the HTTP response status is outside the 2xx\n        range, if an exception occurs, if the transation is aborted,\n        or if the transaction exceeds a configured `timeout`.</dd>\n      <dt>end</dt>\n        <dd>Fires at the conclusion of the transaction\n           lifecycle, after `success` or `failure`.</dd>\n    </dl>\n\n    <p>Callback functions for `start` and `end` receive the id of the\n    transaction as a first argument. For `complete`, `success`, and\n    `failure`, callbacks receive the id and the response object\n    (usually the XMLHttpRequest instance).  If the `arguments`\n    property was included in the configuration object passed to\n    `Y.io()`, the configured data will be passed to all callbacks as\n    the last argument.</p>\n    </dd>\n\n  <dt>sync</dt>\n    <dd>Pass `true` to make a same-domain transaction synchronous.\n    <strong>CAVEAT</strong>: This will negatively impact the user\n    experience. Have a <em>very</em> good reason if you intend to use\n    this.</dd>\n\n  <dt>context</dt>\n    <dd>The \"`this'\" object for all configured event handlers. If a\n    specific context is needed for individual callbacks, bind the\n    callback to a context using `Y.bind()`.</dd>\n\n  <dt>headers</dt>\n    <dd>Object map of transaction headers to send to the server. The\n    object keys are the header names and the values are the header\n    values.</dd>\n\n  <dt>timeout</dt>\n    <dd>Millisecond threshold for the transaction before being\n    automatically aborted.</dd>\n\n  <dt>arguments</dt>\n    <dd>User-defined data passed to all registered event handlers.\n    This value is available as the second argument in the \"start\" and\n    \"end\" event handlers. It is the third argument in the \"complete\",\n    \"success\", and \"failure\" event handlers. <strong>Be sure to quote\n    this property name in the transaction configuration as\n    \"arguments\" is a reserved word in JavaScript</strong> (e.g.\n    `Y.io({ ..., \"arguments\": stuff })`).</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/IO.html#method_send"
     },
     "io:xdrReady": {
      "!type": "fn()",
      "!doc": "Fires when the XDR transport is ready for use.",
      "!url": "http://yuilibrary.com/classes/IO.html#event_io:xdrReady"
     },
     "xdr": {
      "!type": "fn(uri: string, o: yui.Object, c: yui.Object)",
      "!doc": "Method for accessing the transport's interface for making a\ncross-domain transaction.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_xdr"
     },
     "xdrResponse": {
      "!type": "fn(e: string, o: yui.Object, c: yui.Object) -> +yui.Object",
      "!doc": "Response controller for cross-domain requests when using the\nFlash transport or IE8's XDomainRequest object.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_xdrResponse"
     },
     "transport": {
      "!type": "fn(o: yui.Object)",
      "!doc": "Initializes the desired transport.",
      "!url": "http://yuilibrary.com/classes/IO.html#method_transport"
     }
    },
    "stringify": {
     "!type": "fn(form: node.Node, options?: yui.Object) -> string",
     "!doc": "Enumerate through an HTML form's elements collection\nand return a string comprised of key-value pairs.",
     "!url": "http://yuilibrary.com/classes/IO.html#method_stringify"
    },
    "queue": {
     "!type": "fn() -> +yui.Object",
     "!doc": "Method for queueing a transaction before the request is sent to the\nresource, to ensure sequential processing.",
     "!url": "http://yuilibrary.com/classes/IO.html#method_queue"
    },
    "promote": {
     "!type": "fn()",
     "!doc": "Method for promoting a transaction to the top of the queue.",
     "!url": "http://yuilibrary.com/classes/IO.html#method_promote"
    },
    "empty": {
     "!type": "fn()",
     "!doc": "Method for cancel all pending transaction from\nthe queue.",
     "!url": "http://yuilibrary.com/classes/IO.html#method_empty"
    },
    "delay": {
     "!type": "number",
     "!doc": "Delay value to calling the Flash transport, in the\nevent io.swf has not finished loading.  Once the E_XDR_READY\nevent is fired, this value will be set to 0.",
     "!url": "http://yuilibrary.com/classes/IO.html#property_delay"
    }
   },
   "io": {
    "!type": "fn(url: string, config: yui.Object) -> +yui.Object",
    "!doc": "Method for initiating an ajax call.  The first argument is the url end\npoint for the call.  The second argument is an object to configure the\ntransaction and attach event subscriptions.  The configuration object\nsupports the following properties:\n\n<dl>\n  <dt>method</dt>\n    <dd>HTTP method verb (e.g., GET or POST). If this property is not\n        not defined, the default value will be GET.</dd>\n\n  <dt>data</dt>\n    <dd>This is the name-value string that will be sent as the\n    transaction data. If the request is HTTP GET, the data become\n    part of querystring. If HTTP POST, the data are sent in the\n    message body.</dd>\n\n  <dt>xdr</dt>\n    <dd>Defines the transport to be used for cross-domain requests.\n    By setting this property, the transaction will use the specified\n    transport instead of XMLHttpRequest. The properties of the\n    transport object are:\n    <dl>\n      <dt>use</dt>\n        <dd>The transport to be used: 'flash' or 'native'</dd>\n      <dt>dataType</dt>\n        <dd>Set the value to 'XML' if that is the expected response\n        content type.</dd>\n    </dl></dd>\n\n  <dt>form</dt>\n    <dd>Form serialization configuration object.  Its properties are:\n    <dl>\n      <dt>id</dt>\n        <dd>Node object or id of HTML form</dd>\n      <dt>useDisabled</dt>\n        <dd>`true` to also serialize disabled form field values\n        (defaults to `false`)</dd>\n    </dl></dd>\n\n  <dt>on</dt>\n    <dd>Assigns transaction event subscriptions. Available events are:\n    <dl>\n      <dt>start</dt>\n        <dd>Fires when a request is sent to a resource.</dd>\n      <dt>complete</dt>\n        <dd>Fires when the transaction is complete.</dd>\n      <dt>success</dt>\n        <dd>Fires when the HTTP response status is within the 2xx\n        range.</dd>\n      <dt>failure</dt>\n        <dd>Fires when the HTTP response status is outside the 2xx\n        range, if an exception occurs, if the transation is aborted,\n        or if the transaction exceeds a configured `timeout`.</dd>\n      <dt>end</dt>\n        <dd>Fires at the conclusion of the transaction\n           lifecycle, after `success` or `failure`.</dd>\n    </dl>\n\n    <p>Callback functions for `start` and `end` receive the id of the\n    transaction as a first argument. For `complete`, `success`, and\n    `failure`, callbacks receive the id and the response object\n    (usually the XMLHttpRequest instance).  If the `arguments`\n    property was included in the configuration object passed to\n    `Y.io()`, the configured data will be passed to all callbacks as\n    the last argument.</p>\n    </dd>\n\n  <dt>sync</dt>\n    <dd>Pass `true` to make a same-domain transaction synchronous.\n    <strong>CAVEAT</strong>: This will negatively impact the user\n    experience. Have a <em>very</em> good reason if you intend to use\n    this.</dd>\n\n  <dt>context</dt>\n    <dd>The \"`this'\" object for all configured event handlers. If a\n    specific context is needed for individual callbacks, bind the\n    callback to a context using `Y.bind()`.</dd>\n\n  <dt>headers</dt>\n    <dd>Object map of transaction headers to send to the server. The\n    object keys are the header names and the values are the header\n    values.</dd>\n\n  <dt>timeout</dt>\n    <dd>Millisecond threshold for the transaction before being\n    automatically aborted.</dd>\n\n  <dt>arguments</dt>\n    <dd>User-defined data passed to all registered event handlers.\n    This value is available as the second argument in the \"start\" and\n    \"end\" event handlers. It is the third argument in the \"complete\",\n    \"success\", and \"failure\" event handlers. <strong>Be sure to quote\n    this property name in the transaction configuration as\n    \"arguments\" is a reserved word in JavaScript</strong> (e.g.\n    `Y.io({ ..., \"arguments\": stuff })`).</dd>\n</dl>",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_io"
   },
   "header": {
    "!type": "fn(name: string, value: string)",
    "!doc": "Method for setting and deleting IO HTTP headers to be sent with every\nrequest.\n\nHosted as a property on the `io` function (e.g. `Y.io.header`).",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_header"
   },
   "JSON": {
    "!type": "fn()",
    "!doc": "<p>The JSON module adds support for serializing JavaScript objects into\nJSON strings and parsing JavaScript objects from strings in JSON format.</p>\n\n<p>The JSON namespace is added to your YUI instance including static methods\nY.JSON.parse(..) and Y.JSON.stringify(..).</p>\n\n<p>The functionality and method signatures follow the ECMAScript 5\nspecification.  In browsers with native JSON support, the native\nimplementation is used.</p>\n\n<p>The <code>json</code> module is a rollup of <code>json-parse</code> and\n<code>json-stringify</code>.</p>\n\n<p>As their names suggest, <code>json-parse</code> adds support for parsing\nJSON data (Y.JSON.parse) and <code>json-stringify</code> for serializing\nJavaScript data into JSON strings (Y.JSON.stringify).  You may choose to\ninclude either of the submodules individually if you don't need the\ncomplementary functionality, or include the rollup for both.</p>",
    "!url": "http://yuilibrary.com/classes/JSON.html",
    "_default": {
     "!type": "string",
     "!doc": "The ID of the default IO transport, defaults to `xhr`",
     "!url": "http://yuilibrary.com/classes/JSON.html#property__default"
    },
    "defaultTransport": {
     "!type": "fn(id?: string) -> +yui.Object",
     "!url": "http://yuilibrary.com/classes/JSON.html#method_defaultTransport"
    },
    "transports": {
     "!type": "+yui.Object",
     "!doc": "An object hash of custom transports available to IO",
     "!url": "http://yuilibrary.com/classes/JSON.html#property_transports"
    },
    "customTransport": {
     "!type": "fn(id: string)",
     "!doc": "Create a custom transport of type and return it's object",
     "!url": "http://yuilibrary.com/classes/JSON.html#method_customTransport"
    },
    "prototype": {
     "notify": {
      "!type": "fn(event: string, transaction: yui.Object, config: yui.Object)",
      "!doc": "Fired from the notify method of the transport which in turn fires\nthe event on the IO object.",
      "!url": "http://yuilibrary.com/classes/JSON.html#method_notify"
     }
    }
   }
  },
  "io_nodejs": {
   "IO": {
    "!type": "fn(config: yui.Object) -> +io.IO",
    "!doc": "The IO class is a utility that brokers HTTP requests through a simplified\ninterface.  Specifically, it allows JavaScript to make HTTP requests to\na resource without a page reload.  The underlying transport for making\nsame-domain requests is the XMLHttpRequest object.  IO can also use\nFlash, if specified as a transport, for cross-domain requests.",
    "!url": "http://yuilibrary.com/classes/IO.html",
    "request": {
     "!type": "fn()",
     "!doc": "Passthru to the NodeJS <a href=\"https://github.com/mikeal/request\">request</a> module.\nThis method is return of `require('request')` so you can use it inside NodeJS without\nthe IO abstraction.",
     "!url": "http://yuilibrary.com/classes/IO.html#method_request"
    },
    "transports.nodejs": {
     "!type": "fn() -> +yui.Object",
     "!doc": "NodeJS IO transport, uses the NodeJS <a href=\"https://github.com/mikeal/request\">request</a>\nmodule under the hood to perform all network IO.",
     "!url": "http://yuilibrary.com/classes/IO.html#method_transports.nodejs"
    }
   }
  },
  "json": {
   "JSON": {
    "!type": "fn()",
    "!doc": "<p>The JSON module adds support for serializing JavaScript objects into\nJSON strings and parsing JavaScript objects from strings in JSON format.</p>\n\n<p>The JSON namespace is added to your YUI instance including static methods\nY.JSON.parse(..) and Y.JSON.stringify(..).</p>\n\n<p>The functionality and method signatures follow the ECMAScript 5\nspecification.  In browsers with native JSON support, the native\nimplementation is used.</p>\n\n<p>The <code>json</code> module is a rollup of <code>json-parse</code> and\n<code>json-stringify</code>.</p>\n\n<p>As their names suggest, <code>json-parse</code> adds support for parsing\nJSON data (Y.JSON.parse) and <code>json-stringify</code> for serializing\nJavaScript data into JSON strings (Y.JSON.stringify).  You may choose to\ninclude either of the submodules individually if you don't need the\ncomplementary functionality, or include the rollup for both.</p>",
    "!url": "http://yuilibrary.com/classes/JSON.html",
    "parse": {
     "!type": "fn(s: string, reviver: fn()) -> +MIXED",
     "!doc": "Parse a JSON string, returning the native JavaScript representation.",
     "!url": "http://yuilibrary.com/classes/JSON.html#method_parse"
    },
    "dateToString": {
     "!type": "fn(d: datatype_date.Date) -> string",
     "!doc": "Serializes a Date instance as a UTC date string.  Used internally by\nstringify.  Override this method if you need Dates serialized in a\ndifferent format.",
     "!url": "http://yuilibrary.com/classes/JSON.html#method_dateToString"
    },
    "stringify": {
     "!type": "fn(o: MIXED, w: yui.Array, ind: number) -> string",
     "!doc": "<p>Converts an arbitrary value to a JSON string representation.</p>\n\n<p>Objects with cyclical references will trigger an exception.</p>\n\n<p>If a whitelist is provided, only matching object keys will be\nincluded.  Alternately, a replacer function may be passed as the\nsecond parameter.  This function is executed on every value in the\ninput, and its return value will be used in place of the original value.\nThis is useful to serialize specialized objects or class instances.</p>\n\n<p>If a positive integer or non-empty string is passed as the third\nparameter, the output will be formatted with carriage returns and\nindentation for readability.  If a String is passed (such as \"\\t\") it\nwill be used once for each indentation level.  If a number is passed,\nthat number of spaces will be used.</p>",
     "!url": "http://yuilibrary.com/classes/JSON.html#method_stringify"
    },
    "charCacheThreshold": {
     "!type": "number",
     "!doc": "<p>Number of occurrences of a special character within a single call to\nstringify that should trigger promotion of that character to a dedicated\npreprocess step for future calls.  This is only used in environments\nthat don't support native JSON, or when useNativeJSONStringify is set to\nfalse.</p>\n\n<p>So, if set to 50 and an object is passed to stringify that includes\nstrings containing the special character \\x07 more than 50 times,\nsubsequent calls to stringify will process object strings through a\nfaster serialization path for \\x07 before using the generic, slower,\nreplacement process for all special characters.</p>\n\n<p>To prime the preprocessor cache, set this value to 1, then call\n<code>Y.JSON.stringify(\"<em>(all special characters to\ncache)</em>\");</code>, then return this setting to a more conservative\nvalue.</p>\n\n<p>Special characters \\ \" \\b \\t \\n \\f \\r are already cached.</p>",
     "!url": "http://yuilibrary.com/classes/JSON.html#property_charCacheThreshold"
    }
   }
  },
  "jsonp": {
   "JSONPRequest": {
    "!type": "fn()",
    "!doc": "<p>Provides a JSONPRequest class for repeated JSONP calls, and a convenience\nmethod Y.jsonp(url, callback) to instantiate and send a JSONP request.</p>\n\n<p>Both the constructor as well as the convenience function take two\nparameters: a url string and a callback.</p>\n\n<p>The url provided must include the placeholder string\n&quot;{callback}&quot; which will be replaced by a dynamically\ngenerated routing function to pass the data to your callback function.\nAn example url might look like\n&quot;http://example.com/service?callback={callback}&quot;.</p>\n\n<p>The second parameter can be a callback function that accepts the JSON\npayload as its argument, or a configuration object supporting the keys:</p>\n<ul>\n  <li>on - map of callback subscribers\n     <ul>\n        <li>success - function handler for successful transmission</li>\n        <li>failure - function handler for failed transmission</li>\n        <li>timeout - function handler for transactions that timeout</li>\n     </ul>\n </li>\n <li>format  - override function for inserting the proxy name in the url</li>\n <li>timeout - the number of milliseconds to wait before giving up</li>\n <li>context - becomes <code>this</code> in the callbacks</li>\n <li>args    - array of subsequent parameters to pass to the callbacks</li>\n <li>allowCache - use the same proxy name for all requests? (boolean)</li>\n</ul>",
    "!url": "http://yuilibrary.com/classes/JSONPRequest.html",
    "prototype": {
     "_defaultCallback": {
      "!type": "fn(url: string, config: yui.Object) -> fn()",
      "!doc": "Override this method to provide logic to default the success callback if\nit is not provided at construction.  This is overridden by jsonp-url to\nparse the callback from the url string.",
      "!url": "http://yuilibrary.com/classes/JSONPRequest.html#method__defaultCallback"
     },
     "send": {
      "!type": "fn(args: Any) -> !this",
      "!doc": "Issues the JSONP request.",
      "!url": "http://yuilibrary.com/classes/JSONPRequest.html#method_send"
     }
    }
   },
   "jsonp": {
    "!type": "fn(url: string, c: fn(), args: Any) -> +jsonp.JSONPRequest",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_jsonp"
   }
  },
  "loader": {
   "meta": {
    "!type": "?",
    "!doc": "The component metadata is stored in Y.Env.meta.\nPart of the loader module.",
    "!url": "http://yuilibrary.com/classes/YUI.html#property_meta"
   },
   "Loader": {
    "!type": "fn(config: yui.Object) -> +loader.Loader",
    "!doc": "Loader dynamically loads script and css files.  It includes the dependency\ninfo for the version of the library in use, and will automatically pull in\ndependencies for the modules requested. It can load the\nfiles from the Yahoo! CDN, and it can utilize the combo service provided on\nthis network to reduce the number of http connections required to download\nYUI files. You can also specify an external, custom combo service to host\nyour modules as well.\n\n       var Y = YUI();\n       var loader = new Y.Loader({\n           filter: 'debug',\n           base: '../../',\n           root: 'build/',\n           combine: true,\n           require: ['node', 'dd', 'console']\n       });\n       var out = loader.resolve(true);\n\nIf the Loader needs to be patched before it is used for the first time, it\nshould be done through the `doBeforeLoader` hook. Simply make the patch\navailable via configuration before YUI is loaded:\n\n       YUI_config = YUI_config || {};\n       YUI_config.doBeforeLoader = function (config) {\n           var resolve = this.context.Loader.prototype.resolve;\n           this.context.Loader.prototype.resolve = function () {\n               // do something here\n               return resolve.apply(this, arguments);\n           };\n       };",
    "!url": "http://yuilibrary.com/classes/Loader.html",
    "prototype": {
     "onSuccess": {
      "!type": "fn()",
      "!doc": "Callback that will be executed when the loader is finished\nwith an insert",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_onSuccess"
     },
     "onFailure": {
      "!type": "fn()",
      "!doc": "Callback that will be executed if there is a failure",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_onFailure"
     },
     "onCSS": {
      "!type": "fn()",
      "!doc": "Callback for the 'CSSComplete' event.  When loading YUI components\nwith CSS the CSS is loaded first, then the script.  This provides\na moment you can tie into to improve the presentation of the page\nwhile the script is loading.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_onCSS"
     },
     "onProgress": {
      "!type": "fn()",
      "!doc": "Callback executed each time a script or css file is loaded",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_onProgress"
     },
     "onTimeout": {
      "!type": "fn()",
      "!doc": "Callback that will be executed if a timeout occurs",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_onTimeout"
     },
     "context": {
      "!type": "?",
      "!doc": "The execution context for all callbacks",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_context"
     },
     "data": {
      "!type": "?",
      "!doc": "Data that is passed to all callbacks",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_data"
     },
     "insertBefore": {
      "!type": "string",
      "!doc": "Node reference or id where new nodes should be inserted before",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_insertBefore"
     },
     "charset": {
      "!type": "string",
      "!doc": "The charset attribute for inserted nodes",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_charset"
     },
     "cssAttributes": {
      "!type": "+object",
      "!doc": "An object literal containing attributes to add to link nodes",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_cssAttributes"
     },
     "jsAttributes": {
      "!type": "+object",
      "!doc": "An object literal containing attributes to add to script nodes",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_jsAttributes"
     },
     "base": {
      "!type": "string",
      "!doc": "The base directory.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_base"
     },
     "comboBase": {
      "!type": "string",
      "!doc": "Base path for the combo service",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_comboBase"
     },
     "combine": {
      "!type": "+boolean",
      "!doc": "If configured, the loader will attempt to use the combo\nservice for YUI resources and configured external resources.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_combine"
     },
     "comboSep": {
      "!type": "string",
      "!doc": "The default seperator to use between files in a combo URL",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_comboSep"
     },
     "maxURLLength": {
      "!type": "+int",
      "!doc": "Max url length for combo urls.  The default is 1024. This is the URL\nlimit for the Yahoo! hosted combo servers.  If consuming\na different combo service that has a different URL limit\nit is possible to override this default by supplying\nthe maxURLLength config option.  The config option will\nonly take effect if lower than the default.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_maxURLLength"
     },
     "ignoreRegistered": {
      "!type": "?",
      "!doc": "Ignore modules registered on the YUI global",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_ignoreRegistered"
     },
     "root": {
      "!type": "string",
      "!doc": "Root path to prepend to module path for the combo\nservice",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_root"
     },
     "timeout": {
      "!type": "+int",
      "!doc": "Timeout value in milliseconds.  If set, self value will be used by\nthe get utility.  the timeout event will fire if\na timeout occurs.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_timeout"
     },
     "ignore": {
      "!type": "[string]",
      "!doc": "A list of modules that should not be loaded, even if\nthey turn up in the dependency tree",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_ignore"
     },
     "force": {
      "!type": "[string]",
      "!doc": "A list of modules that should always be loaded, even\nif they have already been inserted into the page.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_force"
     },
     "allowRollup": {
      "!type": "+boolean",
      "!doc": "Should we allow rollups",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_allowRollup"
     },
     "filter": {
      "!type": "string",
      "!doc": "A filter to apply to result urls.  This filter will modify the default\npath for all modules.  The default path for the YUI library is the\nminified version of the files (e.g., event-min.js).  The filter property\ncan be a predefined filter or a custom filter.  The valid predefined\nfilters are:\n<dl>\n <dt>DEBUG</dt>\n <dd>Selects the debug versions of the library (e.g., event-debug.js).\n     This option will automatically include the Logger widget</dd>\n <dt>RAW</dt>\n <dd>Selects the non-minified version of the library (e.g., event.js).\n </dd>\n</dl>\nYou can also define a custom filter, which must be an object literal\ncontaining a search expression and a replace string:\n\n     myFilter: {\n         'searchExp': \"-min\\\\.js\",\n         'replaceStr': \"-debug.js\"\n     }",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_filter"
     },
     "filters": {
      "!type": "+object",
      "!doc": "per-component filter specification.  If specified for a given\ncomponent, this overrides the filter config.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_filters"
     },
     "required": {
      "!type": "+string: boolean",
      "!doc": "The list of requested modules",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_required"
     },
     "patterns": {
      "!type": "+yui.Object",
      "!doc": "If a module name is predefined when requested, it is checked againsts\nthe patterns provided in this property.  If there is a match, the\nmodule is added with the default configuration.\n\nAt the moment only supporting module prefixes, but anticipate\nsupporting at least regular expressions.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_patterns"
     },
     "moduleInfo": {
      "!type": "?",
      "!doc": "The library metadata",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_moduleInfo"
     },
     "skin": {
      "!type": "+yui.Object",
      "!doc": "Provides the information used to skin the skinnable components.\nThe following skin definition would result in 'skin1' and 'skin2'\nbeing loaded for calendar (if calendar was requested), and\n'sam' for all other skinnable components:\n\n     skin: {\n         // The default skin, which is automatically applied if not\n         // overriden by a component-specific skin definition.\n         // Change this in to apply a different skin globally\n         defaultSkin: 'sam',\n\n         // This is combined with the loader base property to get\n         // the default root directory for a skin. ex:\n         // http://yui.yahooapis.com/2.3.0/build/assets/skins/sam/\n         base: 'assets/skins/',\n\n         // Any component-specific overrides can be specified here,\n         // making it possible to load different skins for different\n         // components.  It is possible to load more than one skin\n         // for a given component as well.\n         overrides: {\n             calendar: ['skin1', 'skin2']\n         }\n     }",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_skin"
     },
     "loaded": {
      "!type": "+string: boolean",
      "!doc": "Set when beginning to compute the dependency tree.\nComposed of what YUI reports to be loaded combined\nwith what has been loaded by any instance on the page\nwith the version number specified in the metadata.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_loaded"
     },
     "async": {
      "!type": "?",
      "!doc": "Should Loader fetch scripts in `async`, defaults to `true`",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_async"
     },
     "rollups": {
      "!type": "?",
      "!doc": "List of rollup files found in the library metadata",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_rollups"
     },
     "loadOptional": {
      "!type": "+boolean",
      "!doc": "Whether or not to load optional dependencies for\nthe requested modules",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_loadOptional"
     },
     "sorted": {
      "!type": "[string]",
      "!doc": "All of the derived dependencies in sorted order, which\nwill be populated when either calculate() or insert()\nis called",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_sorted"
     },
     "dirty": {
      "!type": "+boolean",
      "!doc": "Flag to indicate the dependency tree needs to be recomputed\nif insert is called again.",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_dirty"
     },
     "inserted": {
      "!type": "+string: boolean",
      "!doc": "List of modules inserted by the utility",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_inserted"
     },
     "skipped": {
      "!type": "?",
      "!doc": "List of skipped modules during insert() because the module\nwas not defined",
      "!url": "http://yuilibrary.com/classes/Loader.html#property_skipped"
     },
     "formatSkin": {
      "!type": "fn(skin: string, mod: string) -> string",
      "!doc": "Returns the skin module name for the specified skin name.  If a\nmodule name is supplied, the returned skin module name is\nspecific to the module passed in.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_formatSkin"
     },
     "addAlias": {
      "!type": "fn(use: yui.Array, name: string)",
      "!doc": "Adds an alias module to the system",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_addAlias"
     },
     "addGroup": {
      "!type": "fn(config: yui.Object, name: string)",
      "!doc": "Add a new module group",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_addGroup"
     },
     "addModule": {
      "!type": "fn(config: yui.Object, name?: string) -> +yui.Object",
      "!doc": "Add a new module to the component metadata.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_addModule"
     },
     "require": {
      "!type": "fn(what: [string])",
      "!doc": "Add a requirement for one or more module",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_require"
     },
     "filterRequires": {
      "!type": "fn(r: yui.Array) -> +yui.Array",
      "!doc": "Explodes the required array to remove aliases and replace them with real modules",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_filterRequires"
     },
     "getRequires": {
      "!type": "fn(mod: yui.Object) -> +yui.Array",
      "!doc": "Returns an object containing properties for all modules required\nin order to load the requested module",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_getRequires"
     },
     "isCSSLoaded": {
      "!type": "fn(name: string) -> ?",
      "!doc": "Check to see if named css module is already loaded on the page",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_isCSSLoaded"
     },
     "getProvides": {
      "!type": "fn(name: string) -> +yui.Object",
      "!doc": "Returns a hash of module names the supplied module satisfies.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_getProvides"
     },
     "calculate": {
      "!type": "fn(o: yui.Object, type: string)",
      "!doc": "Calculates the dependency tree, the result is stored in the sorted\nproperty.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_calculate"
     },
     "getLangPackName": {
      "!type": "fn(lang: string, mname: string) -> string",
      "!doc": "Builds a module name for a language pack",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_getLangPackName"
     },
     "getModule": {
      "!type": "fn(mname: string) -> +yui.Object",
      "!doc": "Get's the loader meta data for the requested module",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_getModule"
     },
     "insert": {
      "!type": "fn(o: yui.Object, type: string)",
      "!doc": "inserts the requested modules and their dependencies.\n<code>type</code> can be \"js\" or \"css\".  Both script and\ncss are inserted if type is not provided.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_insert"
     },
     "loadNext": {
      "!type": "fn(mname: string)",
      "!doc": "Executed every time a module is loaded, and if we are in a load\ncycle, we attempt to load the next script.  Public so that it\nis possible to call this if using a method other than\nY.register to determine when scripts are fully loaded",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_loadNext"
     },
     "resolve": {
      "!type": "fn(calc?: bool, s?: yui.Array) -> +yui.Object",
      "!doc": "Returns an Object hash of file arrays built from `loader.sorted` or from an arbitrary list of sorted modules.",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_resolve"
     },
     "load": {
      "!type": "fn(cb: fn())",
      "!doc": "Shortcut to calculate, resolve and load all modules.\n\n    var loader = new Y.Loader({\n        ignoreRegistered: true,\n        modules: {\n            mod: {\n                path: 'mod.js'\n            }\n        },\n        requires: [ 'mod' ]\n    });\n    loader.load(function() {\n        console.log('All modules have loaded..');\n    });",
      "!url": "http://yuilibrary.com/classes/Loader.html#method_load"
     }
    }
   }
  },
  "matrix": {
   "Matrix": {
    "!type": "fn() -> +matrix.Matrix",
    "!doc": "Matrix is a class that allows for the manipulation of a transform matrix.\nThis class is a work in progress.",
    "!url": "http://yuilibrary.com/classes/Matrix.html",
    "prototype": {
     "multiple": {
      "!type": "fn(a: number, b: number, c: number, d: number, dx: number, dy: number)",
      "!doc": "Updates the matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_multiple"
     },
     "applyCSSText": {
      "!type": "fn(val: string)",
      "!doc": "Parses a string and updates the matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_applyCSSText"
     },
     "getTransformArray": {
      "!type": "fn(val: string) -> ?",
      "!doc": "Parses a string and returns an array of transform arrays.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_getTransformArray"
     },
     "init": {
      "!type": "fn(config: yui.Object)",
      "!doc": "Initializes a matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_init"
     },
     "scale": {
      "!type": "fn(val: number)",
      "!doc": "Applies a scale transform",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_scale"
     },
     "skew": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Applies a skew transformation.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_skew"
     },
     "skewX": {
      "!type": "fn(x: number)",
      "!doc": "Applies a skew to the x-coordinate",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_skewX"
     },
     "skewY": {
      "!type": "fn(y: number)",
      "!doc": "Applies a skew to the y-coordinate",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_skewY"
     },
     "toCSSText": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string of text that can be used to populate a the css transform property of an element.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_toCSSText"
     },
     "toFilterText": {
      "!type": "fn() -> ?",
      "!doc": "Returns a string that can be used to populate the css filter property of an element.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_toFilterText"
     },
     "rad2deg": {
      "!type": "fn(rad: number) -> ?",
      "!doc": "Converts a radian value to a degree.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_rad2deg"
     },
     "deg2rad": {
      "!type": "fn(deg: number) -> ?",
      "!doc": "Converts a degree value to a radian.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_deg2rad"
     },
     "rotate": {
      "!type": "fn(deg: number)",
      "!doc": "Applies a rotate transform.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_rotate"
     },
     "translate": {
      "!type": "fn(x: number, y: number)",
      "!doc": "Applies translate transformation.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_translate"
     },
     "translateX": {
      "!type": "fn(x: number)",
      "!doc": "Applies a translate to the x-coordinate",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_translateX"
     },
     "translateY": {
      "!type": "fn(y: number)",
      "!doc": "Applies a translate to the y-coordinate",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_translateY"
     },
     "identity": {
      "!type": "fn() -> ?",
      "!doc": "Returns an identity matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_identity"
     },
     "getMatrixArray": {
      "!type": "fn() -> ?",
      "!doc": "Returns a 3x3 Matrix array\n\n/                                             \\\n| matrix[0][0]   matrix[1][0]    matrix[2][0] |\n| matrix[0][1]   matrix[1][1]    matrix[2][1] |\n| matrix[0][2]   matrix[1][2]    matrix[2][2] |\n\\                                             /",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_getMatrixArray"
     },
     "getContentRect": {
      "!type": "fn(width: number, height: number, x: number, y: number) -> ?",
      "!doc": "Returns the left, top, right and bottom coordinates for a transformed\nitem.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_getContentRect"
     },
     "getDeterminant": {
      "!type": "fn() -> ?",
      "!doc": "Returns the determinant of the matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_getDeterminant"
     },
     "inverse": {
      "!type": "fn() -> ?",
      "!doc": "Returns the inverse (in array form) of the matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_inverse"
     },
     "transpose": {
      "!type": "fn() -> ?",
      "!doc": "Returns the transpose of the matrix",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_transpose"
     },
     "decompose": {
      "!type": "fn() -> ?",
      "!doc": "Returns an array of transform commands that represent the matrix.",
      "!url": "http://yuilibrary.com/classes/Matrix.html#method_decompose"
     }
    }
   },
   "MatrixUtil": {
    "!type": "fn()",
    "!doc": "Matrix utilities.",
    "!url": "http://yuilibrary.com/classes/MatrixUtil.html",
    "prototype": {
     "rad2deg": {
      "!type": "fn(rad: number) -> ?",
      "!doc": "Converts a radian value to a degree.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_rad2deg"
     },
     "deg2rad": {
      "!type": "fn(deg: number) -> ?",
      "!doc": "Converts a degree value to a radian.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_deg2rad"
     },
     "angle2rad": {
      "!type": "fn(val: Objecxt) -> ?",
      "!doc": "Converts an angle to a radian",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_angle2rad"
     },
     "getnxn": {
      "!type": "fn() -> ?",
      "!doc": "Converts a transform object to an array of column vectors.\n\n/                                             \\\n| matrix[0][0]   matrix[1][0]    matrix[2][0] |\n| matrix[0][1]   matrix[1][1]    matrix[2][1] |\n| matrix[0][2]   matrix[1][2]    matrix[2][2] |\n\\                                             /",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_getnxn"
     },
     "getDeterminant": {
      "!type": "fn(matrix: yui.Array) -> ?",
      "!doc": "Returns the determinant of a given matrix.\n\n/                                             \\\n| matrix[0][0]   matrix[1][0]    matrix[2][0] |\n| matrix[0][1]   matrix[1][1]    matrix[2][1] |\n| matrix[0][2]   matrix[1][2]    matrix[2][2] |\n| matrix[0][3]   matrix[1][3]    matrix[2][3] |\n\\                                             /",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_getDeterminant"
     },
     "inverse": {
      "!type": "fn(Array) -> ?",
      "!doc": "Returns the inverse of a matrix",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_inverse"
     },
     "scalarMultiply": {
      "!type": "fn(matrix: yui.Array, multiplier: number) -> ?",
      "!doc": "Multiplies a matrix by a numeric value.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_scalarMultiply"
     },
     "transpose": {
      "!type": "fn(matrix) -> ?",
      "!doc": "Returns the transpose for an nxn matrix.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_transpose"
     },
     "getMinors": {
      "!type": "fn(matrix: yui.Array, columnIndex: number, rowIndex: number) -> ?",
      "!doc": "Returns a matrix of minors based on a matrix, column index and row index.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_getMinors"
     },
     "sign": {
      "!type": "fn(val: number) -> ?",
      "!doc": "Returns the sign of value",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_sign"
     },
     "vectorMatrixProduct": {
      "!type": "fn(vector: yui.Array, matrix: yui.Array) -> ?",
      "!doc": "Multiplies a vector and a matrix",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_vectorMatrixProduct"
     },
     "decompose": {
      "!type": "fn(matrix: yui.Array) -> ?",
      "!doc": "Breaks up a 2d transform matrix into a series of transform operations.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_decompose"
     },
     "getTransformArray": {
      "!type": "fn(val: string) -> ?",
      "!doc": "Parses a transform string and returns an array of transform arrays.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_getTransformArray"
     },
     "getTransformFunctionArray": {
      "!type": "fn() -> ?",
      "!doc": "Returns an array of transform arrays representing transform functions and arguments.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_getTransformFunctionArray"
     },
     "compareTransformSequence": {
      "!type": "fn(list1: yui.Array, list2: yui.Array) -> ?",
      "!doc": "Compares to arrays or transform functions to ensure both contain the same functions in the same\norder.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#method_compareTransformSequence"
     },
     "transformMethods": {
      "!type": "+yui.Object",
      "!doc": "Mapping of possible transform method names.",
      "!url": "http://yuilibrary.com/classes/MatrixUtil.html#property_transformMethods"
     }
    }
   }
  },
  "node_flick": {
   "Plugin.Flick": {
    "!type": "fn(config: yui.Object)",
    "!doc": "A plugin class which can be used to animate the motion of a node, in response to a flick gesture.",
    "!url": "http://yuilibrary.com/classes/Plugin.Flick.html",
    "prototype": {
     "deceleration": {
      "!type": "fn()",
      "!doc": "Drag coefficent for inertial scrolling. The closer to 1 this\nvalue is, the less friction during scrolling.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_deceleration"
     },
     "bounce": {
      "!type": "fn()",
      "!doc": "Drag coefficient for intertial scrolling at the upper\nand lower boundaries of the scrollview. Set to 0 to\ndisable \"rubber-banding\".",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_bounce"
     },
     "bounceDistance": {
      "!type": "fn()",
      "!doc": "The bounce distance in pixels",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_bounceDistance"
     },
     "minVelocity": {
      "!type": "fn()",
      "!doc": "The minimum flick gesture distance (px) for which to trigger the flick response",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_minVelocity"
     },
     "boundingBox": {
      "!type": "fn()",
      "!doc": "The constraining box relative to which the flick animation and bounds should be calculated.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_boundingBox"
     },
     "step": {
      "!type": "fn()",
      "!doc": "Time between flick animation frames.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_step"
     },
     "duration": {
      "!type": "fn()",
      "!doc": "The custom duration to apply to the flick animation. By default,\nthe animation duration is controlled by the deceleration factor.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_duration"
     },
     "easing": {
      "!type": "fn()",
      "!doc": "The custom transition easing to use for the flick animation. If not\nprovided defaults to internally to Flick.EASING, or Flick.SNAP_EASING based\non whether or not we're animating the flick or bounce step.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#attribute_easing"
     },
     "initializer": {
      "!type": "fn(config: yui.Object)",
      "!doc": "The initializer lifecycle implementation.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#method_initializer"
     },
     "setBounds": {
      "!type": "fn()",
      "!doc": "Sets the min/maxÃ‚Â boundaries for the flick animation,\nbased on the boundingBox dimensions.",
      "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#method_setBounds"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "The NAME of the Flick class. Used to prefix events generated\nby the plugin.",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace for the plugin. This will be the property on the node, which will\nreference the plugin instance, when it's plugged in.",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_NS"
    },
    "VELOCITY_THRESHOLD": {
     "!type": "number",
     "!doc": "The threshold used to determine when the decelerated velocity of the node\nis practically 0.",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_VELOCITY_THRESHOLD"
    },
    "SNAP_DURATION": {
     "!type": "number",
     "!doc": "The duration to use for the bounce snap-back transition",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_SNAP_DURATION"
    },
    "EASING": {
     "!type": "string",
     "!doc": "The default easing to use for the main flick movement transition",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_EASING"
    },
    "SNAP_EASING": {
     "!type": "string",
     "!doc": "The default easing to use for the bounce snap-back transition",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_SNAP_EASING"
    },
    "CLASS_NAMES": {
     "!type": "+yui.Object",
     "!doc": "The default CSS class names used by the plugin",
     "!url": "http://yuilibrary.com/classes/Plugin.Flick.html#property_CLASS_NAMES"
    }
   }
  },
  "node_focusmanager": {
   "plugin.NodeFocusManager": {
    "!type": "fn()",
    "!doc": "The NodeFocusManager class is a plugin for a Node instance.  The class is used\nvia the <a href=\"Node.html#method_plug\"><code>plug</code></a> method of Node\nand should not be instantiated directly.",
    "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html",
    "prototype": {
     "focused": {
      "!type": "fn()",
      "!doc": "Boolean indicating that one of the descendants is focused.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#attribute_focused"
     },
     "descendants": {
      "!type": "fn()",
      "!doc": "String representing the CSS selector used to define the descendant Nodes\nwhose focus should be managed.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#attribute_descendants"
     },
     "activeDescendant": {
      "!type": "fn()",
      "!doc": "<p>Node, or index of the Node, representing the descendant that is either\nfocused or is focusable (<code>tabIndex</code> attribute is set to 0).\nThe value cannot represent a disabled descendant Node.  Use a value of -1\nto remove all descendant Nodes from the default tab flow.\nIf no value is specified, the active descendant will be inferred using\nthe following criteria:</p>\n<ol>\n<li>Examining the <code>tabIndex</code> attribute of each descendant and\nusing the first descendant whose <code>tabIndex</code> attribute is set\nto 0</li>\n<li>If no default can be inferred then the value is set to either 0 or\nthe index of the first enabled descendant.</li>\n</ol>",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#attribute_activeDescendant"
     },
     "keys": {
      "!type": "fn()",
      "!doc": "Object literal representing the keys to be used to navigate between the\nnext/previous descendant.  The format for the attribute's value is\n<code>{ next: \"down:40\", previous: \"down:38\" }</code>.  The value for the\n\"next\" and \"previous\" properties are used to attach\n<a href=\"event/#keylistener\"><code>key</code></a> event listeners. See\nthe <a href=\"event/#keylistener\">Using the key Event</a> section of\nthe Event documentation for more information on \"key\" event listeners.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#attribute_keys"
     },
     "focusClass": {
      "!type": "fn()",
      "!doc": "String representing the name of class applied to the focused active\ndescendant Node.  Can also be an object literal used to define both the\nclass name, and the Node to which the class should be applied.  If using\nan object literal, the format is:\n<code>{ className: \"focus\", fn: myFunction }</code>.  The function\nreferenced by the <code>fn</code> property in the object literal will be\npassed a reference to the currently focused active descendant Node.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#attribute_focusClass"
     },
     "circular": {
      "!type": "fn()",
      "!doc": "Boolean indicating if focus should be set to the first/last descendant\nwhen the end or beginning of the descendants has been reached.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#attribute_circular"
     },
     "focus": {
      "!type": "fn(index: number)",
      "!doc": "Focuses the active descendant and sets the\n<code>focused</code> attribute to true.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#method_focus"
     },
     "blur": {
      "!type": "fn()",
      "!doc": "Blurs the current active descendant and sets the\n<code>focused</code> attribute to false.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#method_blur"
     },
     "start": {
      "!type": "fn()",
      "!doc": "Enables the Focus Manager.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#method_start"
     },
     "stop": {
      "!type": "fn()",
      "!doc": "Disables the Focus Manager by detaching all event handlers.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#method_stop"
     },
     "refresh": {
      "!type": "fn()",
      "!doc": "Refreshes the Focus Manager's descendants by re-executing the\nCSS selector query specified by the <code>descendants</code> attribute.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeFocusManager.html#method_refresh"
     }
    }
   }
  },
  "node_menunav": {
   "plugin.NodeMenuNav": {
    "!type": "fn()",
    "!doc": "The NodeMenuNav class is a plugin for a Node instance.  The class is used via\nthe <a href=\"Node.html#method_plug\"><code>plug</code></a> method of Node and\nshould not be instantiated directly.",
    "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html",
    "prototype": {
     "SHIM_TEMPLATE_TITLE": {
      "!type": "string",
      "!doc": "String representing the value for the <code>title</code>\nattribute for the shim used to prevent <code>&#60;select&#62;</code> elements\nfrom poking through menus in IE 6.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#property_SHIM_TEMPLATE_TITLE"
     },
     "SHIM_TEMPLATE": {
      "!type": "string",
      "!doc": "String representing the HTML used to create the\n<code>&#60;iframe&#62;</code> shim used to prevent\n<code>&#60;select&#62;</code> elements from poking through menus in IE 6.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#property_SHIM_TEMPLATE"
     },
     "useARIA": {
      "!type": "fn()",
      "!doc": "Boolean indicating if use of the WAI-ARIA Roles and States should be\nenabled for the menu.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#attribute_useARIA"
     },
     "autoSubmenuDisplay": {
      "!type": "fn()",
      "!doc": "Boolean indicating if submenus are automatically made visible when the\nuser mouses over the menu's items.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#attribute_autoSubmenuDisplay"
     },
     "submenuShowDelay": {
      "!type": "fn()",
      "!doc": "Number indicating the time (in milliseconds) that should expire before a\nsubmenu is made visible when the user mouses over the menu's label.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#attribute_submenuShowDelay"
     },
     "submenuHideDelay": {
      "!type": "fn()",
      "!doc": "Number indicating the time (in milliseconds) that should expire before a\nsubmenu is hidden when the user mouses out of a menu label heading in the\ndirection of a submenu.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#attribute_submenuHideDelay"
     },
     "mouseOutHideDelay": {
      "!type": "fn()",
      "!doc": "Number indicating the time (in milliseconds) that should expire before a\nsubmenu is hidden when the user mouses out of it.",
      "!url": "http://yuilibrary.com/classes/plugin.NodeMenuNav.html#attribute_mouseOutHideDelay"
     }
    }
   }
  },
  "node_scroll_info": {
   "Plugin.ScrollInfo": {
    "!type": "fn()",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Provides convenient events and methods related to scrolling. This could be used,\nfor example, to implement infinite scrolling, or to lazy-load content based on\nthe current scroll position.\n\n### Example\n\n    var body = Y.one('body');\n\n    body.plug(Y.Plugin.ScrollInfo);\n\n    body.scrollInfo.on('scrollToBottom', function (e) {\n        // Load more content when the user scrolls to the bottom of the page.\n    });",
    "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html",
    "prototype": {
     "scroll": {
      "!type": "fn(atBottom: bool, atLeft: bool, atRight: bool, atTop: bool, isScrollDown: bool, isScrollLeft: bool, isScrollRight: bool, isScrollUp: bool, scrollBottom: number, scrollHeight: number, scrollLeft: number, scrollRight: number, scrollTop: number, scrollWidth: number)",
      "!doc": "Fired when the user scrolls within the host node.\n\nThis event (like all scroll events exposed by ScrollInfo) is throttled and fired\nonly after the number of milliseconds specified by the `scrollDelay` attribute\nhave passed in order to prevent thrashing.\n\nThis event passes along the event facade for the standard DOM `scroll` event and\nmixes in the following additional properties.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scroll"
     },
     "scrollDown": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls down within the host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollDown"
     },
     "scrollLeft": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls left within the host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollLeft"
     },
     "scrollRight": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls right within the host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollRight"
     },
     "scrollUp": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls up within the host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollUp"
     },
     "scrollToBottom": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls to the bottom of the scrollable region within\nthe host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollToBottom"
     },
     "scrollToLeft": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls to the extreme left of the scrollable region\nwithin the host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollToLeft"
     },
     "scrollToRight": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls to the extreme right of the scrollable region\nwithin the host node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollToRight"
     },
     "scrollToTop": {
      "!type": "fn()",
      "!doc": "Fired when the user scrolls to the top of the scrollable region within the\nhost node.\n\nThis event provides the same event facade as the `scroll` event. See that\nevent for details.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#event_scrollToTop"
     },
     "getOffscreenNodes": {
      "!type": "fn(selector?: string, margin?: number) -> +node.NodeList",
      "!doc": "Returns a NodeList containing all offscreen nodes inside the host node that\nmatch the given CSS selector. An offscreen node is any node that is entirely\noutside the visible (onscreen) region of the host node based on the current\nscroll location.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#method_getOffscreenNodes"
     },
     "getOnscreenNodes": {
      "!type": "fn(selector?: string, margin?: number) -> +node.NodeList",
      "!doc": "Returns a NodeList containing all onscreen nodes inside the host node that\nmatch the given CSS selector. An onscreen node is any node that is fully or\npartially within the visible (onscreen) region of the host node based on the\ncurrent scroll location.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#method_getOnscreenNodes"
     },
     "getScrollInfo": {
      "!type": "fn() -> +yui.Object",
      "!doc": "Returns an object hash containing information about the current scroll\nposition of the host node. This is the same information that's mixed into\nthe event facade of the `scroll` event and other scroll-related events.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#method_getScrollInfo"
     },
     "isNodeOnscreen": {
      "!type": "fn(node: HTMLElement, margin?: number) -> bool",
      "!doc": "Returns `true` if _node_ is at least partially onscreen within the host\nnode, `false` otherwise.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#method_isNodeOnscreen"
     },
     "refreshDimensions": {
      "!type": "fn()",
      "!doc": "Refreshes cached position, height, and width dimensions for the host node.\nIf the host node is the body, then the viewport height and width will be\nused.\n\nThis info is cached to improve performance during scroll events, since it's\nexpensive to touch the DOM for these values. Dimensions are automatically\nrefreshed whenever the browser is resized, but if you change the dimensions\nor position of the host node in JS, you may need to call\n`refreshDimensions()` manually to cache the new dimensions.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#method_refreshDimensions"
     },
     "scrollDelay": {
      "!type": "fn()",
      "!doc": "Number of milliseconds to wait after a native `scroll` event before\nfiring local scroll events. If another native scroll event occurs during\nthis time, previous events will be ignored. This ensures that we don't\nfire thousands of events when the user is scrolling quickly.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#attribute_scrollDelay"
     },
     "scrollMargin": {
      "!type": "fn()",
      "!doc": "Additional margin in pixels beyond the onscreen region of the host node\nthat should be considered \"onscreen\".\n\nFor example, if set to 50, then a `scrollToBottom` event would be fired\nwhen the user scrolls to within 50 pixels of the bottom of the\nscrollable region, even if they don't actually scroll completely to the\nvery bottom pixel.\n\nThis margin also applies to the `getOffscreenNodes()` and\n`getOnscreenNodes()` methods by default.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollInfo.html#attribute_scrollMargin"
     }
    }
   }
  },
  "align_plugin": {
   "Plugin.Align": {
    "!type": "fn(User: yui.Object)",
    "!doc": "Node plugin which can be used to align a node with another node,\nregion, or the viewport.",
    "!url": "http://yuilibrary.com/classes/Plugin.Align.html",
    "prototype": {
     "to": {
      "!type": "fn(region: string, regionPoint: string, point: string, resize: bool)",
      "!doc": "Aligns node with a point on another node or region.\nPossible alignment points are:\n<dl>\n     <dt>tl</dt>\n     <dd>top left</dd>\n     <dt>tr</dt>\n     <dd>top right</dd>\n     <dt>bl</dt>\n     <dd>bottom left</dd>\n     <dt>br</dt>\n     <dd>bottom right</dd>\n     <dt>tc</dt>\n     <dd>top center</dd>\n     <dt>bc</dt>\n     <dd>bottom center</dd>\n     <dt>rc</dt>\n     <dd>right center</dd>\n     <dt>lc</dt>\n     <dd>left center</dd>\n     <dt>cc</dt>\n     <dd>center center</dd>\n</dl>",
      "!url": "http://yuilibrary.com/classes/Plugin.Align.html#method_to"
     },
     "center": {
      "!type": "fn(region: node.Node)",
      "!doc": "Aligns the center of a node to the center of another node or region.",
      "!url": "http://yuilibrary.com/classes/Plugin.Align.html#method_center"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Removes the resize handler, if any. This is called automatically\nwhen unplugged from the host node.",
      "!url": "http://yuilibrary.com/classes/Plugin.Align.html#method_destroy"
     }
    }
   }
  },
  "node": {
   "Node": {
    "!type": "fn(node: HTMLElement) -> +node.Node",
    "!doc": "The Node class provides a wrapper for manipulating DOM Nodes.\nNode properties can be accessed via the set/get methods.\nUse `Y.one()` to retrieve Node instances.\n\n<strong>NOTE:</strong> Node properties are accessed using\nthe <code>set</code> and <code>get</code> methods.",
    "!url": "http://yuilibrary.com/classes/Node.html",
    "ATTRS": {
     "!type": "+object",
     "!doc": "Static collection of configuration attributes for special handling",
     "!url": "http://yuilibrary.com/classes/Node.html#property_ATTRS"
    },
    "prototype": {
     "text": {
      "!type": "fn()",
      "!doc": "Allows for getting and setting the text of an element.\nFormatting is preserved and special characters are treated literally.",
      "!url": "http://yuilibrary.com/classes/Node.html#config_text"
     },
     "for": {
      "!type": "fn()",
      "!doc": "Allows for getting and setting the text of an element.\nFormatting is preserved and special characters are treated literally.",
      "!url": "http://yuilibrary.com/classes/Node.html#config_for"
     },
     "children": {
      "!type": "fn()",
      "!doc": "Returns a NodeList instance of all HTMLElement children.",
      "!url": "http://yuilibrary.com/classes/Node.html#config_children"
     },
     "hasClass": {
      "!type": "fn(className: string) -> bool",
      "!doc": "Determines whether each node has the given className.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_hasClass"
     },
     "addClass": {
      "!type": "fn(className: string) -> !this",
      "!doc": "Adds a class name to each node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(className: string) -> !this",
      "!doc": "Removes a class name from each node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_removeClass"
     },
     "replaceClass": {
      "!type": "fn(oldClassName: string, newClassName: string) -> !this",
      "!doc": "Replace a class with another class for each node.\nIf no oldClassName is present, the newClassName is simply added.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_replaceClass"
     },
     "toggleClass": {
      "!type": "fn(className: string, force: bool) -> !this",
      "!doc": "If the className exists on the node it is removed, if it doesn't exist it is added.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_toggleClass"
     },
     "toString": {
      "!type": "fn() -> string",
      "!doc": "The method called when outputting Node instances as strings",
      "!url": "http://yuilibrary.com/classes/Node.html#method_toString"
     },
     "get": {
      "!type": "fn(attr: string) -> +Any",
      "!doc": "Returns an attribute value on the Node instance.\nUnless pre-configured (via `Node.ATTRS`), get hands\noff to the underlying DOM node.  Only valid\nattributes/properties for the node will be queried.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_get"
     },
     "set": {
      "!type": "fn(attr: string, val: Any) -> !this",
      "!doc": "Sets an attribute on the Node instance.\nUnless pre-configured (via Node.ATTRS), set hands\noff to the underlying DOM node.  Only valid\nattributes/properties for the node will be set.\nTo set custom attributes use setAttribute.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_set"
     },
     "setAttrs": {
      "!type": "fn(attrMap: yui.Object) -> !this",
      "!doc": "Sets multiple attributes.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setAttrs"
     },
     "getAttrs": {
      "!type": "fn(attrs: yui.Array) -> +yui.Object",
      "!doc": "Returns an object containing the values for the requested attributes.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getAttrs"
     },
     "compareTo": {
      "!type": "fn(refNode: HTMLElement) -> bool",
      "!doc": "Compares nodes to determine if they match.\nNode instances can be compared to each other and/or HTMLElements.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_compareTo"
     },
     "inDoc": {
      "!type": "fn(doc: node.Node) -> bool",
      "!doc": "Determines whether the node is appended to the document.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_inDoc"
     },
     "ancestor": {
      "!type": "fn(fn: string, testSelf: bool, stopFn: string) -> +node.Node",
      "!doc": "Returns the nearest ancestor that passes the test applied by supplied boolean method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_ancestor"
     },
     "ancestors": {
      "!type": "fn(fn: string, testSelf: bool) -> +node.NodeList",
      "!doc": "Returns the ancestors that pass the test applied by supplied boolean method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_ancestors"
     },
     "previous": {
      "!type": "fn(fn: string, all?: bool) -> +node.Node",
      "!doc": "Returns the previous matching sibling.\nReturns the nearest element node sibling if no method provided.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_previous"
     },
     "next": {
      "!type": "fn(fn: string, all?: bool) -> +node.Node",
      "!doc": "Returns the next matching sibling.\nReturns the nearest element node sibling if no method provided.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_next"
     },
     "siblings": {
      "!type": "fn(fn: string) -> +node.NodeList",
      "!doc": "Returns all matching siblings.\nReturns all siblings if no method provided.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_siblings"
     },
     "one": {
      "!type": "fn(selector: string) -> +node.Node",
      "!doc": "Retrieves a single Node instance, the first element matching the given\nCSS selector.\nReturns null if no match found.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_one"
     },
     "all": {
      "!type": "fn(selector: string) -> +node.NodeList",
      "!doc": "Retrieves a NodeList based on the given CSS selector.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_all"
     },
     "test": {
      "!type": "fn(selector: string) -> bool",
      "!doc": "Test if the supplied node matches the supplied selector.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_test"
     },
     "remove": {
      "!type": "fn(destroy: bool) -> !this",
      "!doc": "Removes the node from its parent.\nShortcut for myNode.get('parentNode').removeChild(myNode);",
      "!url": "http://yuilibrary.com/classes/Node.html#method_remove"
     },
     "replace": {
      "!type": "fn(newNode: node.Node) -> !this",
      "!doc": "Replace the node with the other node. This is a DOM update only\nand does not change the node bound to the Node instance.\nShortcut for myNode.get('parentNode').replaceChild(newNode, myNode);",
      "!url": "http://yuilibrary.com/classes/Node.html#method_replace"
     },
     "replaceChild": {
      "!type": "fn(node: string, refNode: HTMLElement) -> +node.Node",
      "!url": "http://yuilibrary.com/classes/Node.html#method_replaceChild"
     },
     "destroy": {
      "!type": "fn(recursivePurge: bool)",
      "!doc": "Nulls internal node references, removes any plugins and event listeners.\nNote that destroy() will not remove the node from its parent or from the DOM. For that\nfunctionality, call remove(true).",
      "!url": "http://yuilibrary.com/classes/Node.html#method_destroy"
     },
     "invoke": {
      "!type": "fn(method: string, args?: Any) -> +Any",
      "!doc": "Invokes a method on the Node instance",
      "!url": "http://yuilibrary.com/classes/Node.html#method_invoke"
     },
     "swap": {
      "!type": "fn(otherNode: node.Node) -> !this",
      "!doc": "Swap DOM locations with the given node.\nThis does not change which DOM node each Node instance refers to.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_swap"
     },
     "empty": {
      "!type": "fn() -> !this",
      "!doc": "Removes and destroys all of the nodes within the node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_empty"
     },
     "getDOMNode": {
      "!type": "fn() -> +HTMLElement",
      "!doc": "Returns the DOM node bound to the Node instance",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getDOMNode"
     },
     "create": {
      "!type": "fn(html: string, doc: HTMLDocument) -> +node.Node",
      "!doc": "Creates a new Node using the provided markup string.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_create"
     },
     "insert": {
      "!type": "fn(content: string, where: Int) -> !this",
      "!doc": "Inserts the content before the reference node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_insert"
     },
     "prepend": {
      "!type": "fn(content: string) -> !this",
      "!doc": "Inserts the content as the firstChild of the node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_prepend"
     },
     "append": {
      "!type": "fn(content: string) -> !this",
      "!doc": "Inserts the content as the lastChild of the node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_append"
     },
     "appendChild": {
      "!type": "fn(node: string) -> +node.Node",
      "!url": "http://yuilibrary.com/classes/Node.html#method_appendChild"
     },
     "insertBefore": {
      "!type": "fn(newNode: string, refNode: HTMLElement) -> +node.Node",
      "!url": "http://yuilibrary.com/classes/Node.html#method_insertBefore"
     },
     "appendTo": {
      "!type": "fn(node: node.Node) -> !this",
      "!doc": "Appends the node to the given node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_appendTo"
     },
     "setHTML": {
      "!type": "fn(content: string) -> !this",
      "!doc": "Replaces the node's current html content with the content provided.\nNote that this passes to innerHTML and is not escaped.\nUse <a href=\"../classes/Escape.html#method_html\">`Y.Escape.html()`</a>\nto escape html content or `set('text')` to add as text.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setHTML"
     },
     "getHTML": {
      "!type": "fn() -> string",
      "!doc": "Returns the node's current html content (e.g. innerHTML)",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getHTML"
     },
     "getData": {
      "!type": "fn(name: string) -> +Any",
      "!doc": "Retrieves arbitrary data stored on a Node instance.\nIf no data is associated with the Node, it will attempt to retrieve\na value from the corresponding HTML data attribute. (e.g. node.getData('foo')\nwill check node.getAttribute('data-foo')).",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getData"
     },
     "setData": {
      "!type": "fn(name: string, val: Any) -> !this",
      "!doc": "Stores arbitrary data on a Node instance.\nThis is not stored with the DOM node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setData"
     },
     "clearData": {
      "!type": "fn(name: string) -> !this",
      "!doc": "Clears internally stored data.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_clearData"
     },
     "delegate": {
      "!type": "fn(type: string, fn: fn(), spec: string, context: yui.Object, args: Any) -> +event_custom.EventHandle",
      "!doc": "<p>Sets up a delegation listener for an event occurring inside the Node.\nThe delegated event will be verified against a supplied selector or\nfiltering function to test if the event references at least one node that\nshould trigger the subscription callback.</p>\n\n<p>Selector string filters will trigger the callback if the event originated\nfrom a node that matches it or is contained in a node that matches it.\nFunction filters are called for each Node up the parent axis to the\nsubscribing container node, and receive at each level the Node and the event\nobject.  The function should return true (or a truthy value) if that Node\nshould trigger the subscription callback.  Note, it is possible for filters\nto match multiple Nodes for a single event.  In this case, the delegate\ncallback will be executed for each matching Node.</p>\n\n<p>For each matching Node, the callback will be executed with its 'this'\nobject set to the Node matched by the filter (unless a specific context was\nprovided during subscription), and the provided event's\n<code>currentTarget</code> will also be set to the matching Node.  The\ncontaining Node from which the subscription was originally made can be\nreferenced as <code>e.container</code>.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_delegate"
     },
     "simulate": {
      "!type": "fn(type: string, options: yui.Object)",
      "!doc": "Simulates an event on the node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_simulate"
     },
     "simulateGesture": {
      "!type": "fn(name: string, options?: yui.Object, cb?: fn())",
      "!doc": "Simulates the higher user level gesture of the given name on this node.\nThis method generates a set of low level touch events(Apple specific gesture\nevents as well for the iOS platforms) asynchronously. Note that gesture\nsimulation is relying on `Y.Event.simulate()` method to generate\nthe touch events under the hood. The `Y.Event.simulate()` method\nitself is a synchronous method.\n\nSupported gestures are `tap`, `doubletap`, `press`, `move`, `flick`, `pinch`\nand `rotate`.\n\nThe `pinch` gesture is used to simulate the pinching and spreading of two\nfingers. During a pinch simulation, rotation is also possible. Essentially\n`pinch` and `rotate` simulations share the same base implementation to allow\nboth pinching and rotation at the same time. The only difference is `pinch`\nrequires `start` and `end` option properties while `rotate` requires `rotation`\noption property.\n\nThe `pinch` and `rotate` gestures can be described as placing 2 fingers along a\ncircle. Pinching and spreading can be described by start and end circles while\nrotation occurs on a single circle. If the radius of the start circle is greater\nthan the end circle, the gesture becomes a pinch, otherwise it is a spread spread.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_simulateGesture"
     },
     "purge": {
      "!type": "fn(recurse: bool, type: string) -> !this",
      "!doc": "Removes event listeners from the node and (optionally) its subtree",
      "!url": "http://yuilibrary.com/classes/Node.html#method_purge"
     },
     "on": {
      "!type": "fn(type: string, fn: fn(e: +event.DOMEventFacade), context?: ?, arg?: ?) -> +event_custom.EventHandle",
      "!doc": "Subscribe a callback function to execute in response to a DOM event or custom\nevent.\n\nMost DOM events are associated with a preventable default behavior such as\nlink clicks navigating to a new page.  Callbacks are passed a `DOMEventFacade`\nobject as their first argument (usually called `e`) that can be used to\nprevent this default behavior with `e.preventDefault()`. See the\n`DOMEventFacade` API for all available properties and methods on the object.\n\nIf the event name passed as the first parameter is not a whitelisted DOM event,\nit will be treated as a custom event subscriptions, allowing\n`node.fire('customEventName')` later in the code.  Refer to the Event user guide\nfor the full DOM event whitelist.\n\nBy default, the `this` object in the callback will refer to the subscribed\n`Node`.\n\nReturning `false` from a callback is supported as an alternative to calling\n`e.preventDefault(); e.stopPropagation();`.  However, it is recommended to use\nthe event methods.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_on"
     },
     "removeChild": {
      "!type": "fn(node: HTMLElement) -> +node.Node",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_removeChild"
     },
     "hasChildNodes": {
      "!type": "fn() -> bool",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_hasChildNodes"
     },
     "cloneNode": {
      "!type": "fn(deep: bool) -> +node.Node",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_cloneNode"
     },
     "hasAttribute": {
      "!type": "fn(attribute: string) -> bool",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_hasAttribute"
     },
     "scrollIntoView": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_scrollIntoView"
     },
     "getElementsByTagName": {
      "!type": "fn(tagName: string) -> +node.NodeList",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getElementsByTagName"
     },
     "focus": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_focus"
     },
     "blur": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_blur"
     },
     "submit": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.\nOnly valid on FORM elements",
      "!url": "http://yuilibrary.com/classes/Node.html#method_submit"
     },
     "reset": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.\nOnly valid on FORM elements",
      "!url": "http://yuilibrary.com/classes/Node.html#method_reset"
     },
     "select": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_select"
     },
     "createCaption": {
      "!type": "fn() -> !this",
      "!doc": "Passes through to DOM method.\nOnly valid on TABLE elements",
      "!url": "http://yuilibrary.com/classes/Node.html#method_createCaption"
     },
     "removeAttribute": {
      "!type": "fn(attribute: string) -> !this",
      "!doc": "Passes through to DOM method.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_removeAttribute"
     },
     "contains": {
      "!type": "fn(needle: node.Node) -> bool",
      "!doc": "Determines whether the node is an ancestor of another HTML element in the DOM hierarchy.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_contains"
     },
     "setAttribute": {
      "!type": "fn(name: string, value: string) -> !this",
      "!doc": "Allows setting attributes on DOM nodes, normalizing in some cases.\nThis passes through to the DOM node, allowing for custom attributes.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setAttribute"
     },
     "getAttribute": {
      "!type": "fn(name: string) -> string",
      "!doc": "Allows getting attributes on DOM nodes, normalizing in some cases.\nThis passes through to the DOM node, allowing for custom attributes.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getAttribute"
     },
     "wrap": {
      "!type": "fn(html: string) -> !this",
      "!doc": "Wraps the given HTML around the node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_wrap"
     },
     "unwrap": {
      "!type": "fn() -> !this",
      "!doc": "Removes the node's parent node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_unwrap"
     },
     "generateID": {
      "!type": "fn() -> string",
      "!doc": "Applies a unique ID to the node if none exists",
      "!url": "http://yuilibrary.com/classes/Node.html#method_generateID"
     },
     "load": {
      "!type": "fn(url: string, selector: string, callback: fn()) -> !this",
      "!doc": "Loads content from the given url and replaces the Node's\nexisting content with the remote content.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_load"
     },
     "region": {
      "!type": "fn()",
      "!doc": "Returns a region object for the node",
      "!url": "http://yuilibrary.com/classes/Node.html#config_region"
     },
     "viewportRegion": {
      "!type": "fn()",
      "!doc": "Returns a region object for the node's viewport",
      "!url": "http://yuilibrary.com/classes/Node.html#config_viewportRegion"
     },
     "intersect": {
      "!type": "fn(node2: node.Node, altRegion: yui.Object) -> +yui.Object",
      "!doc": "Compares the intersection of the node with another node or region",
      "!url": "http://yuilibrary.com/classes/Node.html#method_intersect"
     },
     "inRegion": {
      "!type": "fn(node2: node.Node, all: bool, altRegion: yui.Object) -> bool",
      "!doc": "Determines whether or not the node is within the giving region.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_inRegion"
     },
     "winWidth": {
      "!type": "fn()",
      "!doc": "Returns the inner width of the viewport (exludes scrollbar).",
      "!url": "http://yuilibrary.com/classes/Node.html#config_winWidth"
     },
     "winHeight": {
      "!type": "fn()",
      "!doc": "Returns the inner height of the viewport (exludes scrollbar).",
      "!url": "http://yuilibrary.com/classes/Node.html#config_winHeight"
     },
     "docWidth": {
      "!type": "fn()",
      "!doc": "Document width",
      "!url": "http://yuilibrary.com/classes/Node.html#config_docWidth"
     },
     "docHeight": {
      "!type": "fn()",
      "!doc": "Document height",
      "!url": "http://yuilibrary.com/classes/Node.html#config_docHeight"
     },
     "docScrollX": {
      "!type": "fn()",
      "!doc": "Pixel distance the page has been scrolled horizontally",
      "!url": "http://yuilibrary.com/classes/Node.html#config_docScrollX"
     },
     "docScrollY": {
      "!type": "fn()",
      "!doc": "Pixel distance the page has been scrolled vertically",
      "!url": "http://yuilibrary.com/classes/Node.html#config_docScrollY"
     },
     "getXY": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getXY"
     },
     "setXY": {
      "!type": "fn(xy: yui.Array) -> !this",
      "!doc": "Set the position of the node in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setXY"
     },
     "getX": {
      "!type": "fn() -> number",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getX"
     },
     "setX": {
      "!type": "fn(x: number) -> !this",
      "!doc": "Set the position of the node in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setX"
     },
     "getY": {
      "!type": "fn() -> number",
      "!doc": "Gets the current position of the node in page coordinates.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getY"
     },
     "setY": {
      "!type": "fn(y: number) -> !this",
      "!doc": "Set the position of the node in page coordinates, regardless of how the node is positioned.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setY"
     },
     "swapXY": {
      "!type": "fn(otherNode: node.Node) -> !this",
      "!doc": "Swaps the XY position of this node with another node.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_swapXY"
     },
     "setStyle": {
      "!type": "fn(attr: string, val: string) -> !this",
      "!doc": "Sets a style property of the node.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setStyle"
     },
     "setStyles": {
      "!type": "fn(hash: yui.Object) -> !this",
      "!doc": "Sets multiple style properties on the node.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_setStyles"
     },
     "getStyle": {
      "!type": "fn(attr: string) -> string",
      "!doc": "Returns the style's current value.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getStyle"
     },
     "getComputedStyle": {
      "!type": "fn(attr: string) -> string",
      "!doc": "Returns the computed value for the given style property.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_getComputedStyle"
     },
     "show": {
      "!type": "fn(name: string, config: yui.Object, callback: fn()) -> !this",
      "!doc": "Makes the node visible.\nIf the \"transition\" module is loaded, show optionally\nanimates the showing of the node using either the default\ntransition effect ('fadeIn'), or the given named effect.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_show"
     },
     "toggleView": {
      "!type": "fn(on?: bool, callback?: fn()) -> !this",
      "!doc": "Displays or hides the node.\nIf the \"transition\" module is loaded, toggleView optionally\nanimates the toggling of the node using given named effect.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_toggleView"
     },
     "hide": {
      "!type": "fn(name: string, config: yui.Object, callback: fn()) -> !this",
      "!doc": "Hides the node.\nIf the \"transition\" module is loaded, hide optionally\nanimates the hiding of the node using either the default\ntransition effect ('fadeOut'), or the given named effect.",
      "!url": "http://yuilibrary.com/classes/Node.html#method_hide"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "The name of the component",
     "!url": "http://yuilibrary.com/classes/Node.html#property_NAME"
    },
    "getDOMNode": {
     "!type": "fn(node: node.Node) -> +HTMLElement",
     "!doc": "Retrieves the DOM node bound to a Node instance",
     "!url": "http://yuilibrary.com/classes/Node.html#method_getDOMNode"
    },
    "scrubVal": {
     "!type": "fn(node: HTMLElement) -> +node.Node",
     "!doc": "Checks Node return values and wraps DOM Nodes as Y.Node instances\nand DOM Collections / Arrays as Y.NodeList instances.\nOther return values just pass thru.  If undefined is returned (e.g. no return)\nthen the Node instance is returned for chainability.",
     "!url": "http://yuilibrary.com/classes/Node.html#method_scrubVal"
    },
    "addMethod": {
     "!type": "fn(name: string, fn: fn(), context: yui.Object) -> +Any",
     "!doc": "Adds methods to the Y.Node prototype, routing through scrubVal.",
     "!url": "http://yuilibrary.com/classes/Node.html#method_addMethod"
    },
    "importMethod": {
     "!type": "fn(host: yui.Object, name: string, altName: string, context: yui.Object)",
     "!doc": "Imports utility methods to be added as Y.Node methods.",
     "!url": "http://yuilibrary.com/classes/Node.html#method_importMethod"
    },
    "one": {
     "!type": "fn(node: string) -> +node.Node",
     "!doc": "Returns a single Node instance bound to the node or the\nfirst element matching the given selector. Returns null if no match found.\n<strong>Note:</strong> For chaining purposes you may want to\nuse <code>Y.all</code>, which returns a NodeList when no match is found.",
     "!url": "http://yuilibrary.com/classes/Node.html#method_one"
    },
    "DEFAULT_SETTER": {
     "!type": "fn(name: string, val: Any) -> +Any",
     "!doc": "The default setter for DOM properties\nCalled with instance context (this === the Node instance)",
     "!url": "http://yuilibrary.com/classes/Node.html#method_DEFAULT_SETTER"
    },
    "DEFAULT_GETTER": {
     "!type": "fn(name: string) -> +Any",
     "!doc": "The default getter for DOM properties\nCalled with instance context (this === the Node instance)",
     "!url": "http://yuilibrary.com/classes/Node.html#method_DEFAULT_GETTER"
    },
    "create": {
     "!type": "fn(html: string, doc: HTMLDocument) -> +node.Node",
     "!doc": "Returns a new dom node using the provided markup string.",
     "!url": "http://yuilibrary.com/classes/Node.html#method_create"
    },
    "DOM_EVENTS": {
     "!type": "?",
     "!doc": "List of events that route to DOM events",
     "!url": "http://yuilibrary.com/classes/Node.html#property_DOM_EVENTS"
    },
    "plug": {
     "!type": "fn(plugin: fn(), config: yui.Object)",
     "!doc": "Registers plugins to be instantiated at the class level (plugins\nwhich should be plugged into every instance of Node by default).",
     "!url": "http://yuilibrary.com/classes/Node.html#method_plug"
    },
    "unplug": {
     "!type": "fn(plugin: fn())",
     "!doc": "Unregisters any class level plugins which have been registered by the Node",
     "!url": "http://yuilibrary.com/classes/Node.html#method_unplug"
    }
   },
   "NodeList": {
    "!type": "fn(nodes: string) -> +node.NodeList",
    "!doc": "The NodeList class provides a wrapper for manipulating DOM NodeLists.\nNodeList properties can be accessed via the set/get methods.\nUse Y.all() to retrieve NodeList instances.",
    "!url": "http://yuilibrary.com/classes/NodeList.html",
    "prototype": {
     "setAttribute": {
      "!type": "fn(name: string, value: string) -> !this",
      "!doc": "Allows setting attributes on DOM nodes, normalizing in some cases.\nThis passes through to the DOM node, allowing for custom attributes.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_setAttribute"
     },
     "getAttribute": {
      "!type": "fn(name: string) -> string",
      "!doc": "Allows getting attributes on DOM nodes, normalizing in some cases.\nThis passes through to the DOM node, allowing for custom attributes.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_getAttribute"
     },
     "hasClass": {
      "!type": "fn(className: string) -> +yui.Array",
      "!doc": "Determines whether each node has the given className.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_hasClass"
     },
     "addClass": {
      "!type": "fn(className: string) -> !this",
      "!doc": "Adds a class name to each node.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_addClass"
     },
     "removeClass": {
      "!type": "fn(className: string) -> !this",
      "!doc": "Removes a class name from each node.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_removeClass"
     },
     "replaceClass": {
      "!type": "fn(oldClassName: string, newClassName: string) -> !this",
      "!doc": "Replace a class with another class for each node.\nIf no oldClassName is present, the newClassName is simply added.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_replaceClass"
     },
     "toggleClass": {
      "!type": "fn(className: string) -> !this",
      "!doc": "If the className exists on the node it is removed, if it doesn't exist it is added.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_toggleClass"
     },
     "append": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_append"
     },
     "insert": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_insert"
     },
     "appendChild": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_appendChild"
     },
     "insertBefore": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_insertBefore"
     },
     "prepend": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_prepend"
     },
     "setHTML": {
      "!type": "fn()",
      "!doc": "Called on each Node instance\nNote that this passes to innerHTML and is not escaped.\nUse <a href=\"../classes/Escape.html#method_html\">`Y.Escape.html()`</a>\nto escape html content or `set('text')` to add as text.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_setHTML"
     },
     "getHTML": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_getHTML"
     },
     "getData": {
      "!type": "fn(name: string) -> +yui.Array",
      "!doc": "Retrieves arbitrary data stored on each Node instance\nbound to the NodeList.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_getData"
     },
     "setData": {
      "!type": "fn(name: string, val: Any) -> !this",
      "!doc": "Stores arbitrary data on each Node instance bound to the\n NodeList. This is not stored with the DOM node.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_setData"
     },
     "clearData": {
      "!type": "fn(name: string) -> !this",
      "!doc": "Clears data on all Node instances bound to the NodeList.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_clearData"
     },
     "on": {
      "!type": "fn(type: string, fn: fn(), context?: yui.Object, arg?: Any) -> +event_custom.EventHandle",
      "!doc": "Subscribe a callback function for each `Node` in the collection to execute\nin response to a DOM event.\n\nNOTE: Generally, the `on()` method should be avoided on `NodeLists`, in\nfavor of using event delegation from a parent Node.  See the Event user\nguide for details.\n\nMost DOM events are associated with a preventable default behavior, such as\nlink clicks navigating to a new page.  Callbacks are passed a\n`DOMEventFacade` object as their first argument (usually called `e`) that\ncan be used to prevent this default behavior with `e.preventDefault()`. See\nthe `DOMEventFacade` API for all available properties and methods on the\nobject.\n\nBy default, the `this` object will be the `NodeList` that the subscription\ncame from, <em>not the `Node` that received the event</em>.  Use\n`e.currentTarget` to refer to the `Node`.\n\nReturning `false` from a callback is supported as an alternative to calling\n`e.preventDefault(); e.stopPropagation();`.  However, it is recommended to\nuse the event methods.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_on"
     },
     "once": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Applies an one-time event listener to each Node bound to the NodeList.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_once"
     },
     "after": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Applies an event listener to each Node bound to the NodeList.\nThe handler is called only after all on() handlers are called\nand the event is not prevented.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_after"
     },
     "onceAfter": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Applies an one-time event listener to each Node bound to the NodeList\nthat will be called only after all on() handlers are called and the\nevent is not prevented.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_onceAfter"
     },
     "detach": {
      "!type": "fn()",
      "!doc": "Called on each Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_detach"
     },
     "detachAll": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_detachAll"
     },
     "removeAttribute": {
      "!type": "fn(name: string)",
      "!doc": "Allows for removing attributes on DOM nodes.\nThis passes through to the DOM node, allowing for custom attributes.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_removeAttribute"
     },
     "unwrap": {
      "!type": "fn() -> !this",
      "!doc": "Removes the parent node from node in the list.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_unwrap"
     },
     "wrap": {
      "!type": "fn(html: string) -> !this",
      "!doc": "Wraps the given HTML around each node.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_wrap"
     },
     "generateID": {
      "!type": "fn() -> string",
      "!doc": "Applies a unique ID to each node if none exists",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_generateID"
     },
     "plug": {
      "!type": "fn(P: fn(), config) -> !this",
      "!doc": "Adds a plugin to each node in the NodeList.\nThis will instantiate the plugin and attach it to the configured namespace on each node",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_plug"
     },
     "unplug": {
      "!type": "fn(plugin: string) -> !this",
      "!doc": "Removes a plugin from all nodes in the NodeList. This will destroy the\nplugin instance and delete the namespace each node.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_unplug"
     },
     "getStyle": {
      "!type": "fn(attr: string) -> +yui.Array",
      "!doc": "Returns an array of values for each node.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_getStyle"
     },
     "getComputedStyle": {
      "!type": "fn(attr: string) -> +yui.Array",
      "!doc": "Returns an array of the computed value for each node.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_getComputedStyle"
     },
     "setStyle": {
      "!type": "fn(attr: string, val: string) -> !this",
      "!doc": "Sets a style property on each node.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_setStyle"
     },
     "setStyles": {
      "!type": "fn(hash: yui.Object) -> !this",
      "!doc": "Sets multiple style properties on each node.\nUse camelCase (e.g. 'backgroundColor') for multi-word properties.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_setStyles"
     },
     "show": {
      "!type": "fn(name: string, config: yui.Object, callback: fn()) -> !this",
      "!doc": "Makes each node visible.\nIf the \"transition\" module is loaded, show optionally\nanimates the showing of the node using either the default\ntransition effect ('fadeIn'), or the given named effect.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_show"
     },
     "hide": {
      "!type": "fn(name: string, config: yui.Object, callback: fn()) -> !this",
      "!doc": "Hides each node.\nIf the \"transition\" module is loaded, hide optionally\nanimates the hiding of the node using either the default\ntransition effect ('fadeOut'), or the given named effect.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_hide"
     },
     "toggleView": {
      "!type": "fn(on?: bool, callback?: fn()) -> !this",
      "!doc": "Displays or hides each node.\nIf the \"transition\" module is loaded, toggleView optionally\nanimates the toggling of the nodes using given named effect.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_toggleView"
     },
     "concat": {
      "!type": "fn(valueN: node.NodeList) -> +node.NodeList",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_concat"
     },
     "pop": {
      "!type": "fn() -> +node.Node",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_pop"
     },
     "push": {
      "!type": "fn(nodes: node.Node)",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_push"
     },
     "shift": {
      "!type": "fn() -> +node.Node",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_shift"
     },
     "slice": {
      "!type": "fn(begin: number, end: number) -> +node.NodeList",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_slice"
     },
     "splice": {
      "!type": "fn(index: number, howMany: number) -> +node.NodeList",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_splice"
     },
     "unshift": {
      "!type": "fn(nodes: node.Node)",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_unshift"
     },
     "item": {
      "!type": "fn(index: number) -> +node.Node",
      "!doc": "Retrieves the Node instance at the given index.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_item"
     },
     "each": {
      "!type": "fn(fn: fn(), context: yui.Object) -> !this",
      "!doc": "Applies the given function to each Node in the NodeList.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_each"
     },
     "some": {
      "!type": "fn(fn: fn(), context: yui.Object) -> bool",
      "!doc": "Executes the function once for each node until a true value is returned.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_some"
     },
     "toFrag": {
      "!type": "fn() -> +node.Node",
      "!doc": "Creates a documenFragment from the nodes bound to the NodeList instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_toFrag"
     },
     "indexOf": {
      "!type": "fn(node: node.Node) -> number",
      "!doc": "Returns the index of the node in the NodeList instance\nor -1 if the node isn't found.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_indexOf"
     },
     "filter": {
      "!type": "fn(selector: string) -> +node.NodeList",
      "!doc": "Filters the NodeList instance down to only nodes matching the given selector.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_filter"
     },
     "modulus": {
      "!type": "fn(n: number, r: number) -> +node.NodeList",
      "!doc": "Creates a new NodeList containing all nodes at every n indices, where\nremainder n % index equals r.\n(zero-based index).",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_modulus"
     },
     "odd": {
      "!type": "fn() -> +node.NodeList",
      "!doc": "Creates a new NodeList containing all nodes at odd indices\n(zero-based index).",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_odd"
     },
     "even": {
      "!type": "fn() -> +node.NodeList",
      "!doc": "Creates a new NodeList containing all nodes at even indices\n(zero-based index), including zero.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_even"
     },
     "refresh": {
      "!type": "fn() -> !this",
      "!doc": "Reruns the initial query, when created using a selector query",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_refresh"
     },
     "size": {
      "!type": "fn() -> number",
      "!doc": "Returns the current number of items in the NodeList.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_size"
     },
     "isEmpty": {
      "!type": "fn() -> bool",
      "!doc": "Determines if the instance is bound to any nodes",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_isEmpty"
     },
     "getDOMNodes": {
      "!type": "fn() -> +yui.Array",
      "!doc": "Returns the DOM node bound to the Node instance",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_getDOMNodes"
     },
     "destroy": {
      "!type": "fn(recursivePurge: bool)",
      "!doc": "Called on each Node instance. Nulls internal node references,\nremoves any plugins and event listeners",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_destroy"
     },
     "empty": {
      "!type": "fn() -> !this",
      "!doc": "Called on each Node instance. Removes and destroys all of the nodes\nwithin the node",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_empty"
     },
     "remove": {
      "!type": "fn(destroy: bool) -> !this",
      "!doc": "Called on each Node instance. Removes the node from its parent.\nShortcut for myNode.get('parentNode').removeChild(myNode);",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_remove"
     },
     "set": {
      "!type": "fn(attr: string, val: Any) -> !this",
      "!doc": "Called on each Node instance. Sets an attribute on the Node instance.\nUnless pre-configured (via Node.ATTRS), set hands\noff to the underlying DOM node.  Only valid\nattributes/properties for the node will be set.\nTo set custom attributes use setAttribute.",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_set"
     },
     "get": {
      "!type": "fn()",
      "!url": "http://yuilibrary.com/classes/NodeList.html#method_get"
     }
    },
    "getDOMNodes": {
     "!type": "fn(nodelist: node.NodeList) -> +yui.Array",
     "!doc": "Retrieves the DOM nodes bound to a NodeList instance",
     "!url": "http://yuilibrary.com/classes/NodeList.html#method_getDOMNodes"
    }
   },
   "all": {
    "!type": "fn(selector: string) -> +node.NodeList",
    "!doc": "Retrieves a NodeList based on the given CSS selector.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_all"
   },
   "one": {
    "!type": "fn(node: string) -> +node.Node",
    "!doc": "Returns a single Node instance bound to the node or the\nfirst element matching the given selector. Returns null if no match found.\n<strong>Note:</strong> For chaining purposes you may want to\nuse <code>Y.all</code>, which returns a NodeList when no match is found.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_one"
   }
  },
  "shim_plugin": {
   "Plugin.Shim": {
    "!type": "fn(User: yui.Object)",
    "!doc": "Node plugin which can be used to add shim support.",
    "!url": "http://yuilibrary.com/classes/Plugin.Shim.html",
    "CLASS_NAME": {
     "!type": "string",
     "!doc": "Default class used to mark the shim element",
     "!url": "http://yuilibrary.com/classes/Plugin.Shim.html#property_CLASS_NAME"
    },
    "TEMPLATE": {
     "!type": "string",
     "!doc": "Default markup template used to generate the shim element.",
     "!url": "http://yuilibrary.com/classes/Plugin.Shim.html#property_TEMPLATE"
    },
    "prototype": {
     "sync": {
      "!type": "fn()",
      "!doc": "Updates the size of the shim to fill its container",
      "!url": "http://yuilibrary.com/classes/Plugin.Shim.html#method_sync"
     },
     "destroy": {
      "!type": "fn()",
      "!doc": "Removes the shim and destroys the plugin",
      "!url": "http://yuilibrary.com/classes/Plugin.Shim.html#method_destroy"
     }
    }
   }
  },
  "datatype_number": {
   "Number": {
    "!type": "fn()",
    "!doc": "Number provides a set of utility functions to operate against Number objects.",
    "!url": "http://yuilibrary.com/classes/Number.html",
    "prototype": {
     "format": {
      "!type": "fn(data: number, config: yui.Object) -> string",
      "!doc": "Takes a Number and formats to string for display to user.",
      "!url": "http://yuilibrary.com/classes/Number.html#method_format"
     },
     "parse": {
      "!type": "fn(data: string, config?: yui.Object) -> number",
      "!doc": "Converts data to type Number.\nIf a `config` argument is used, it will strip the `data` of the prefix,\nthe suffix and the thousands separator, if any of them are found,\nreplace the decimal separator by a dot and parse the resulting string.\nExtra whitespace around the prefix and suffix will be ignored.",
      "!url": "http://yuilibrary.com/classes/Number.html#method_parse"
     }
    }
   }
  },
  "oop": {
   "augment": {
    "!type": "fn(receiver: fn(), supplier: fn(), overwrite?: bool, whitelist?: [string], args?: yui.Array) -> fn()",
    "!doc": "Augments the _receiver_ with prototype properties from the _supplier_. The\nreceiver may be a constructor function or an object. The supplier must be a\nconstructor function.\n\nIf the _receiver_ is an object, then the _supplier_ constructor will be called\nimmediately after _receiver_ is augmented, with _receiver_ as the `this` object.\n\nIf the _receiver_ is a constructor function, then all prototype methods of\n_supplier_ that are copied to _receiver_ will be sequestered, and the\n_supplier_ constructor will not be called immediately. The first time any\nsequestered method is called on the _receiver_'s prototype, all sequestered\nmethods will be immediately copied to the _receiver_'s prototype, the\n_supplier_'s constructor will be executed, and finally the newly unsequestered\nmethod that was called will be executed.\n\nThis sequestering logic sounds like a bunch of complicated voodoo, but it makes\nit cheap to perform frequent augmentation by ensuring that suppliers'\nconstructors are only called if a supplied method is actually used. If none of\nthe supplied methods is ever used, then there's no need to take the performance\nhit of calling the _supplier_'s constructor.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_augment"
   },
   "aggregate": {
    "!type": "fn(receiver: yui.Object, supplier: yui.Object, overwrite?: bool, whitelist?: [string]) -> +yui.Object",
    "!doc": "Copies object properties from the supplier to the receiver. If the target has\nthe property, and the property is an object, the target object will be\naugmented with the supplier's value.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_aggregate"
   },
   "extend": {
    "!type": "fn(r: fn(), s: fn(), px: yui.Object, sx: yui.Object) -> +yui.Object",
    "!doc": "Utility to set up the prototype, constructor and superclass properties to\nsupport an inheritance strategy that can chain constructors and methods.\nStatic members will not be inherited.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_extend"
   },
   "each": {
    "!type": "fn(o: yui.Object, f: fn(), c: yui.Object, proto: bool) -> +YUI",
    "!doc": "Executes the supplied function for each item in\na collection.  Supports arrays, objects, and\nNodeLists",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_each"
   },
   "some": {
    "!type": "fn(o: yui.Object, f: fn(), c: yui.Object, proto: bool) -> bool",
    "!doc": "Executes the supplied function for each item in\na collection.  The operation stops if the function\nreturns true. Supports arrays, objects, and\nNodeLists.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_some"
   },
   "clone": {
    "!type": "fn(o: yui.Object, safe: bool, f: fn(), c: yui.Object, owner: yui.Object, cloned: yui.Object) -> +yui.Array",
    "!doc": "Deep object/array copy. Function clones are actually wrappers around the\noriginal function. Array-like objects are treated as arrays. Primitives are\nreturned untouched. Optionally, a function can be provided to handle other data\ntypes, filter keys, validate values, etc.\n\n**Note:** Cloning a non-trivial object is a reasonably heavy operation, due to\nthe need to recursively iterate down non-primitive properties. Clone should be\nused only when a deep clone down to leaf level properties is explicitly\nrequired. This method will also\n\nIn many cases (for example, when trying to isolate objects used as hashes for\nconfiguration properties), a shallow copy, using `Y.merge()` is normally\nsufficient. If more than one level of isolation is required, `Y.merge()` can be\nused selectively at each level which needs to be isolated from the original\nwithout going all the way to leaf properties.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_clone"
   },
   "bind": {
    "!type": "fn(f: fn(), c: yui.Object, args: Any) -> fn()",
    "!doc": "Returns a function that will execute the supplied function in the\nsupplied object's context, optionally adding any additional\nsupplied parameters to the beginning of the arguments collection the\nsupplied to the function.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_bind"
   },
   "rbind": {
    "!type": "fn(f: fn(), c: yui.Object, args: Any) -> fn()",
    "!doc": "Returns a function that will execute the supplied function in the\nsupplied object's context, optionally adding any additional\nsupplied parameters to the end of the arguments the function\nis executed with.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_rbind"
   }
  },
  "paginator": {
   "Paginator": {
    "!type": "fn()",
    "!doc": "The Paginator utility allows you to display an item or a group of items\ndepending on the number of items you wish to display at one time.\n\nPaginator's primary functionality is contained in `paginator-core` and is mixed\ninto `paginator` to allow `paginator` to have extra functionality added to it\nwhile leaving the core functionality untouched. This allows `paginator-core` to\nremain available for use later on or used in isolation if it is the only piece\nyou need.\n\nDue to the vast number of interfaces a paginator could possibly consist of,\n`Paginator` does not contain any ready to use UIs. However, `Paginator` is\nready to be used in any Based-based, module such as a Widget, by extending your\ndesired class and mixing in `Paginator`. This is displayed in the following\nexample:\n\n<pre><code>\nYUI().use('paginator-url', 'widget', function (Y){\n    var MyPaginator = Y.Base.create('my-paginator', Y.Widget, [Y.Paginator], {\n\n       renderUI: function () {\n           var numbers = '',\n               i, numberOfPages = this.get('totalPages');\n\n           for (i = 1; i <= numberOfPages; i++) {\n               // use paginator-url's formatUrl method\n               numbers += '&lt;a href=\"' + this.formatUrl(i) + '\">' + i + '&lt;/a>';\n           }\n\n           this.get('boundingBox').append(numbers);\n       },\n\n       bindUI: function () {\n           this.get('boundingBox').delegate('click', function (e) {\n               // let's not go to the page, just update internally\n               e.preventDefault();\n               this.set('page', parseInt(e.currentTarget.getContent(), 10));\n           }, 'a', this);\n\n           this.after('pageChange', function (e) {\n               // mark the link selected when it's the page being displayed\n               var bb = this.get('boundingBox'),\n                   activeClass = 'selected';\n\n               bb.all('a').removeClass(activeClass).item(e.newVal).addClass(activeClass);\n           });\n       }\n\n    });\n\n    var myPg = new MyPaginator({\n                   totalItems: 100,\n                   pageUrl: '?pg={page}'\n               });\n\n    myPg.render();\n});\n</code></pre>",
    "!url": "http://yuilibrary.com/classes/Paginator.html",
    "prototype": {
     "page": {
      "!type": "fn()",
      "!doc": "Current page count. First page is 1.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#attribute_page"
     },
     "totalPages": {
      "!type": "fn()",
      "!doc": "Total number of pages to display",
      "!url": "http://yuilibrary.com/classes/Paginator.html#attribute_totalPages"
     },
     "itemsPerPage": {
      "!type": "fn()",
      "!doc": "Maximum number of items per page. A value of negative one (-1) indicates\n    all items on one page.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#attribute_itemsPerPage"
     },
     "totalItems": {
      "!type": "fn()",
      "!doc": "Total number of items in all pages.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#attribute_totalItems"
     },
     "prevPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the page to the previous page in the set, if there is a previous page.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#method_prevPage"
     },
     "nextPage": {
      "!type": "fn() -> !this",
      "!doc": "Sets the page to the next page in the set, if there is a next page.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#method_nextPage"
     },
     "hasPrevPage": {
      "!type": "fn() -> bool",
      "!doc": "Returns True if there is a previous page in the set.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#method_hasPrevPage"
     },
     "hasNextPage": {
      "!type": "fn() -> bool",
      "!doc": "Returns True if there is a next page in the set.\n\nIf totalItems isn't set, assume there is always next page.",
      "!url": "http://yuilibrary.com/classes/Paginator.html#method_hasNextPage"
     }
    }
   },
   "Paginator.Url": {
    "!type": "fn()",
    "!doc": "Adds in URL options for paginator links.",
    "!url": "http://yuilibrary.com/classes/Paginator.Url.html",
    "prototype": {
     "pageUrl": {
      "!type": "fn()",
      "!doc": "URL to return formatted with the page number. URL uses `Y.Lang.sub` for page number stubstitutions.\n\nFor example, if the page number is `3`, setting the `pageUrl` to `\"?pg={page}\"`, will result in `?pg=3`",
      "!url": "http://yuilibrary.com/classes/Paginator.Url.html#attribute_pageUrl"
     },
     "prevPageUrl": {
      "!type": "fn() -> string",
      "!doc": "Returns a formated URL for the previous page.",
      "!url": "http://yuilibrary.com/classes/Paginator.Url.html#method_prevPageUrl"
     },
     "nextPageUrl": {
      "!type": "fn() -> string",
      "!doc": "Returns a formated URL for the next page.",
      "!url": "http://yuilibrary.com/classes/Paginator.Url.html#method_nextPageUrl"
     },
     "formatPageUrl": {
      "!type": "fn(page?: number) -> string",
      "!doc": "Returns a formated URL for the provided page number.",
      "!url": "http://yuilibrary.com/classes/Paginator.Url.html#method_formatPageUrl"
     }
    }
   }
  },
  "panel": {
   "Panel": {
    "!type": "fn() -> +panel.Panel",
    "!proto": "widget.Widget",
    "!doc": "A basic Panel Widget, which can be positioned based on Page XY co-ordinates and\nis stackable (z-index support). It also provides alignment and centering support\nand uses a standard module format for it's content, with header, body and footer\nsection support. It can be made modal, and has functionality to hide and focus\non different events. The header and footer sections can be modified to allow for\nbutton support.",
    "!url": "http://yuilibrary.com/classes/Panel.html",
    "prototype": {
     "BUTTONS": {
      "!type": "+yui.Object",
      "!doc": "Collection of predefined buttons mapped from name => config.\n\nPanel includes a \"close\" button which can be use by name. When the close\nbutton is in the header (which is the default), it will look like: [x].\n\nSee `addButton()` for a list of possible configuration values.",
      "!url": "http://yuilibrary.com/classes/Panel.html#property_BUTTONS"
     }
    }
   }
  },
  "parallel": {
   "Parallel": {
    "!type": "fn(o: yui.Object)",
    "!doc": "A concurrent parallel processor to help in running several async functions.\n\n    var stack = new Y.Parallel();\n\n    for (var i = 0; i < 15; i++) {\n        Y.io('./api/json/' + i, {\n            on: {\n                success: stack.add(function() {\n                    Y.log('Done!');\n                })\n            }\n        });\n    }\n\n    stack.done(function() {\n        Y.log('All IO requests complete!');\n    });",
    "!url": "http://yuilibrary.com/classes/Parallel.html",
    "prototype": {
     "results": {
      "!type": "+yui.Array",
      "!doc": "An Array of results from all the callbacks in the stack",
      "!url": "http://yuilibrary.com/classes/Parallel.html#property_results"
     },
     "total": {
      "!type": "number",
      "!doc": "The total items in the stack",
      "!url": "http://yuilibrary.com/classes/Parallel.html#property_total"
     },
     "finished": {
      "!type": "number",
      "!doc": "The number of stacked callbacks executed",
      "!url": "http://yuilibrary.com/classes/Parallel.html#property_finished"
     },
     "add": {
      "!type": "fn(fn: fn())",
      "!doc": "Add a callback to the stack",
      "!url": "http://yuilibrary.com/classes/Parallel.html#method_add"
     },
     "test": {
      "!type": "fn()",
      "!doc": "Test to see if all registered items in the stack have completed, if so call the callback to `done`",
      "!url": "http://yuilibrary.com/classes/Parallel.html#method_test"
     },
     "done": {
      "!type": "fn(callback: fn(), data: Mixed)",
      "!doc": "The method to call when all the items in the stack are complete.",
      "!url": "http://yuilibrary.com/classes/Parallel.html#method_done"
     }
    }
   }
  },
  "pjax": {
   "PjaxBase": {
    "!type": "fn()",
    "!doc": "`Y.Router` extension that provides the core plumbing for enhanced navigation\nimplemented using the pjax technique (HTML5 `pushState` + Ajax).\n\nThis makes it easy to enhance the navigation between the URLs of an application\nin HTML5 history capable browsers by delegating to the router to fulfill the\n\"request\" and seamlessly falling-back to using standard full-page reloads in\nolder, less-capable browsers.\n\nThe `PjaxBase` class isn't useful on its own, but can be mixed into a\n`Router`-based class to add Pjax functionality to that Router. For a pre-made\nstandalone Pjax router, see the `Pjax` class.\n\n    var MyRouter = Y.Base.create('myRouter', Y.Router, [Y.PjaxBase], {\n        // ...\n    });",
    "!url": "http://yuilibrary.com/classes/PjaxBase.html",
    "prototype": {
     "navigate": {
      "!type": "fn(url: string, options?: yui.Object) -> bool",
      "!doc": "Navigates to the specified URL if there is a route handler that matches. In\nbrowsers capable of using HTML5 history, the navigation will be enhanced by\nfiring the `navigate` event and having the router handle the \"request\".\nNon-HTML5 browsers will navigate to the new URL via manipulation of\n`window.location`.\n\nWhen there is a route handler for the specified URL and it is being\nnavigated to, this method will return `true`, otherwise it will return\n`false`.\n\n**Note:** The specified URL _must_ be of the same origin as the current URL,\notherwise an error will be logged and navigation will not occur. This is\nintended as both a security constraint and a purposely imposed limitation as\nit does not make sense to tell the router to navigate to a URL on a\ndifferent scheme, host, or port.",
      "!url": "http://yuilibrary.com/classes/PjaxBase.html#method_navigate"
     },
     "linkSelector": {
      "!type": "fn()",
      "!doc": "CSS selector string used to filter link click events so that only the links\nwhich match it will have the enhanced navigation behavior of Pjax applied.\n\nWhen a link is clicked and that link matches this selector, Pjax will\nattempt to dispatch to any route handlers matching the link's `href` URL. If\nHTML5 history is not supported or if no route handlers match, the link click\nwill be handled by the browser just like any old link.",
      "!url": "http://yuilibrary.com/classes/PjaxBase.html#attribute_linkSelector"
     },
     "navigateOnHash": {
      "!type": "fn()",
      "!doc": "Whether navigating to a hash-fragment identifier on the current page should\nbe enhanced and cause the `navigate` event to fire.\n\nBy default Pjax allows the browser to perform its default action when a user\nis navigating within a page by clicking in-page links\n(e.g. `<a href=\"#top\">Top of page</a>`) and does not attempt to interfere or\nenhance in-page navigation.",
      "!url": "http://yuilibrary.com/classes/PjaxBase.html#attribute_navigateOnHash"
     },
     "scrollToTop": {
      "!type": "fn()",
      "!doc": "Whether the page should be scrolled to the top after navigating to a URL.\n\nWhen the user clicks the browser's back button, the previous scroll position\nwill be maintained.",
      "!url": "http://yuilibrary.com/classes/PjaxBase.html#attribute_scrollToTop"
     }
    }
   },
   "PjaxContent": {
    "!type": "fn()",
    "!doc": "`Y.Router` extension that provides the content fetching and handling needed to\nimplement the standard pjax (HTMP5 pushState + Ajax) functionality.\n\nThis makes it easy to fetch server rendered content for URLs using Ajax. By\nhelping the router to fulfill the \"request\" for the content you can avoid full\npage loads.\n\nThe `PjaxContent` class isn't useful on its own, but can be mixed into a\n`Router`-based class along with the `PjaxBase` class to add Pjax functionality\nto that Router. For a pre-made standalone Pjax router, see the `Pjax` class.\n\n    var MyRouter = Y.Base.create('myRouter', Y.Router, [\n        Y.PjaxBase,\n        Y.PjaxContent\n    ], {\n        // ...\n    });",
    "!url": "http://yuilibrary.com/classes/PjaxContent.html",
    "prototype": {
     "getContent": {
      "!type": "fn(responseText: string) -> +yui.Object",
      "!doc": "Extracts and returns the relevant HTML content from an Ajax response. The\ncontent is extracted using the `contentSelector` attribute as a CSS\nselector. If `contentSelector` is `null`, the entire response will be\nreturned.\n\nThe return value is an object containing two properties:\n\n  * `node`: A `Y.Node` instance for a document fragment containing the\n    extracted HTML content.\n\n  * `title`: The title of the HTML page, if any, extracted using the\n    `titleSelector` attribute (which defaults to looking for a `<title>`\n    element). If `titleSelector` is not set or if a title could not be\n    found, this property will be `undefined`.",
      "!url": "http://yuilibrary.com/classes/PjaxContent.html#method_getContent"
     },
     "loadContent": {
      "!type": "fn(req: yui.Object, res: yui.Object, next: fn())",
      "!doc": "Pjax route middleware to load content from a server. This makes an Ajax\nrequest for the requested URL, parses the returned content and puts it on\nthe route's response object.\n\nThis is route middleware and not intended to be the final callback for a\nroute. This will add the following information to the route's request and\nresponse objects:\n\n  - `req.ioURL`: The full URL that was used to make the `Y.io()` XHR. This\n    may contain `\"pjax=1\"` if the `addPjaxParam` option is set.\n\n  - `res.content`: An object containing `node` and `title` properties for\n    the content extracted from the server's response. See `getContent()` for\n    more details.\n\n  - `res.ioResponse`: The full `Y.io()` response object. This is useful if\n    you need access to the XHR's response `status` or HTTP headers.",
      "!url": "http://yuilibrary.com/classes/PjaxContent.html#method_loadContent"
     },
     "addPjaxParam": {
      "!type": "fn()",
      "!doc": "If `true`, a \"pjax=1\" query parameter will be appended to all URLs\nrequested via Pjax.\n\nBrowsers ignore HTTP request headers when caching content, so if the\nsame URL is used to request a partial Pjax page and a full page, the\nbrowser will cache them under the same key and may later load the\ncached partial page when the user actually requests a full page (or vice\nversa).\n\nTo prevent this, we can add a bogus query parameter to the URL so that\nPjax URLs will always be cached separately from non-Pjax URLs.",
      "!url": "http://yuilibrary.com/classes/PjaxContent.html#attribute_addPjaxParam"
     },
     "contentSelector": {
      "!type": "fn()",
      "!doc": "CSS selector used to extract a specific portion of the content of a page\nloaded via Pjax.\n\nFor example, if you wanted to load the page `example.html` but only use\nthe content within an element with the id \"pjax-content\", you'd set\n`contentSelector` to \"#pjax-content\".\n\nIf not set, the entire page will be used.",
      "!url": "http://yuilibrary.com/classes/PjaxContent.html#attribute_contentSelector"
     },
     "titleSelector": {
      "!type": "fn()",
      "!doc": "CSS selector used to extract a page title from the content of a page\nloaded via Pjax.\n\nBy default this is set to extract the title from the `<title>` element,\nbut you could customize it to extract the title from an `<h1>`, or from\nany other element, if that's more appropriate for the content you're\nloading.",
      "!url": "http://yuilibrary.com/classes/PjaxContent.html#attribute_titleSelector"
     },
     "timeout": {
      "!type": "fn()",
      "!doc": "Time in milliseconds after which an Ajax request should time out.",
      "!url": "http://yuilibrary.com/classes/PjaxContent.html#attribute_timeout"
     }
    }
   },
   "Pjax": {
    "!type": "fn(config?: yui.Object) -> +pjax.Pjax",
    "!proto": "app.Router",
    "!doc": "Provides seamless, gracefully degrading Pjax (pushState + Ajax) functionality,\nwhich makes it easy to progressively enhance standard links on the page so that\nthey can be loaded normally in old browsers, or via Ajax (with HTML5 history\nsupport) in newer browsers.",
    "!url": "http://yuilibrary.com/classes/Pjax.html",
    "defaultRoute": {
     "!type": "+yui.Array",
     "!doc": "A stack of middleware which forms the default Pjax route.",
     "!url": "http://yuilibrary.com/classes/Pjax.html#property_defaultRoute"
    },
    "prototype": {
     "error": {
      "!type": "fn(content: yui.Object, responseText: string, status: number, url: string)",
      "!doc": "Fired when an error occurs while attempting to load a URL via Ajax.",
      "!url": "http://yuilibrary.com/classes/Pjax.html#event_error"
     },
     "load": {
      "!type": "fn(content: yui.Object, responseText: string, status: number, url: string)",
      "!doc": "Fired when a URL is successfully loaded via Ajax.",
      "!url": "http://yuilibrary.com/classes/Pjax.html#event_load"
     },
     "container": {
      "!type": "fn()",
      "!doc": "Node into which content should be inserted when a page is loaded via\nPjax. This node's existing contents will be removed to make way for the\nnew content.\n\nIf not set, loaded content will not be automatically inserted into the\npage.",
      "!url": "http://yuilibrary.com/classes/Pjax.html#attribute_container"
     }
    }
   }
  },
  "plugin": {
   "Plugin.Base": {
    "!type": "fn(config: yui.Object)",
    "!proto": "base.Base",
    "!doc": "The base class for all Plugin instances.",
    "!url": "http://yuilibrary.com/classes/Plugin.Base.html",
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Object defining the set of attributes supported by the Plugin.Base class",
     "!url": "http://yuilibrary.com/classes/Plugin.Base.html#property_ATTRS"
    },
    "prototype": {
     "host": {
      "!type": "fn()",
      "!doc": "The plugin's host object.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#attribute_host"
     },
     "initializer": {
      "!type": "fn(config: yui.Object)",
      "!doc": "Initializer lifecycle implementation.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_initializer"
     },
     "destructor": {
      "!type": "fn()",
      "!doc": "Destructor lifecycle implementation.\n\nRemoves any event listeners or injected methods applied by the Plugin",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_destructor"
     },
     "doBefore": {
      "!type": "fn(strMethod: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Listens for the \"on\" moment of events fired by the host,\nor injects code \"before\" a given method on the host.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_doBefore"
     },
     "doAfter": {
      "!type": "fn(strMethod: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Listens for the \"after\" moment of events fired by the host,\nor injects code \"after\" a given method on the host.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_doAfter"
     },
     "onHostEvent": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Listens for the \"on\" moment of events fired by the host object.\n\nListeners attached through this method will be detached when the plugin is unplugged.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_onHostEvent"
     },
     "onceHostEvent": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Listens for the \"on\" moment of events fired by the host object one time only.\nThe listener is immediately detached when it is executed.\n\nListeners attached through this method will be detached when the plugin is unplugged.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_onceHostEvent"
     },
     "afterHostEvent": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Listens for the \"after\" moment of events fired by the host object.\n\nListeners attached through this method will be detached when the plugin is unplugged.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_afterHostEvent"
     },
     "onceAfterHostEvent": {
      "!type": "fn(type: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Listens for the \"after\" moment of events fired by the host object one time only.\nThe listener is immediately detached when it is executed.\n\nListeners attached through this method will be detached when the plugin is unplugged.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_onceAfterHostEvent"
     },
     "beforeHostMethod": {
      "!type": "fn(method: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Injects a function to be executed before a given method on host object.\n\nThe function will be detached when the plugin is unplugged.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_beforeHostMethod"
     },
     "afterHostMethod": {
      "!type": "fn(method: string, fn: fn(), context: yui.Object) -> +event_custom.EventHandle",
      "!doc": "Injects a function to be executed after a given method on host object.\n\nThe function will be detached when the plugin is unplugged.",
      "!url": "http://yuilibrary.com/classes/Plugin.Base.html#method_afterHostMethod"
     }
    },
    "NAME": {
     "!type": "string",
     "!doc": "The string identifying the Plugin.Base class. Plugins extending\nPlugin.Base should set their own NAME value.",
     "!url": "http://yuilibrary.com/classes/Plugin.Base.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The name of the property the the plugin will be attached to\nwhen plugged into a Plugin Host. Plugins extending Plugin.Base,\nshould set their own NS value.",
     "!url": "http://yuilibrary.com/classes/Plugin.Base.html#property_NS"
    }
   }
  },
  "pluginhost_base": {
   "Plugin.Host": {
    "!type": "fn()",
    "!doc": "<p>\nAn augmentable class, which provides the augmented class with the ability to host plugins.\nIt adds <a href=\"#method_plug\">plug</a> and <a href=\"#method_unplug\">unplug</a> methods to the augmented class, which can\nbe used to add or remove plugins from instances of the class.\n</p>\n\n<p>Plugins can also be added through the constructor configuration object passed to the host class' constructor using\nthe \"plugins\" property. Supported values for the \"plugins\" property are those defined by the <a href=\"#method_plug\">plug</a> method.\n\nFor example the following code would add the AnimPlugin and IOPlugin to Overlay (the plugin host):\n<xmp>\nvar o = new Overlay({plugins: [ AnimPlugin, {fn:IOPlugin, cfg:{section:\"header\"}}]});\n</xmp>\n</p>\n<p>\nPlug.Host's protected <a href=\"#method_initPlugins\">_initPlugins</a> and <a href=\"#method_destroyPlugins\">_destroyPlugins</a>\nmethods should be invoked by the host class at the appropriate point in the host's lifecyle.\n</p>",
    "!url": "http://yuilibrary.com/classes/Plugin.Host.html",
    "prototype": {
     "plug": {
      "!type": "fn(P: fn(), config) -> !this",
      "!doc": "Adds a plugin to the host object. This will instantiate the\nplugin and attach it to the configured namespace on the host object.",
      "!url": "http://yuilibrary.com/classes/Plugin.Host.html#method_plug"
     },
     "unplug": {
      "!type": "fn(plugin: string) -> !this",
      "!doc": "Removes a plugin from the host object. This will destroy the\nplugin instance and delete the namespace from the host object.",
      "!url": "http://yuilibrary.com/classes/Plugin.Host.html#method_unplug"
     },
     "hasPlugin": {
      "!type": "fn(ns: string) -> +Plugin",
      "!doc": "Determines if a plugin has plugged into this host.",
      "!url": "http://yuilibrary.com/classes/Plugin.Host.html#method_hasPlugin"
     }
    },
    "plug": {
     "!type": "fn(hostClass: fn(), plugin: fn(), config: yui.Object)",
     "!doc": "Registers plugins to be instantiated at the class level (plugins\nwhich should be plugged into every instance of the class by default).",
     "!url": "http://yuilibrary.com/classes/Plugin.Host.html#method_plug"
    },
    "unplug": {
     "!type": "fn(hostClass: fn(), plugin: fn())",
     "!doc": "Unregisters any class level plugins which have been registered by the host class, or any\nother class in the hierarchy.",
     "!url": "http://yuilibrary.com/classes/Plugin.Host.html#method_unplug"
    }
   },
   "batch": {
    "!type": "fn(operation: Any) -> +promise.Promise",
    "!doc": "Returns a new promise that will be resolved when all operations have completed.\nTakes both any numer of values as arguments. If an argument is a not a promise,\nit will be wrapped in a new promise, same as in `Y.when()`.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_batch"
   }
  },
  "promise": {
   "Promise": {
    "!type": "fn(fn: fn()) -> +promise.Promise",
    "!doc": "A promise represents a value that may not yet be available. Promises allow\nyou to chain asynchronous operations, write synchronous looking code and\nhandle errors throughout the process.\n\nThis constructor takes a function as a parameter where you can insert the logic\nthat fulfills or rejects this promise. The fulfillment value and the rejection\nreason can be any JavaScript value. It's encouraged that rejection reasons be\nerror objects\n\n<pre><code>\nvar fulfilled = new Y.Promise(function (resolve) {\n    resolve('I am a fulfilled promise');\n});\n\nvar rejected = new Y.Promise(function (resolve, reject) {\n    reject(new Error('I am a rejected promise'));\n});\n</code></pre>",
    "!url": "http://yuilibrary.com/classes/Promise.html",
    "prototype": {
     "then": {
      "!type": "fn(callback?: fn(), errback?: fn()) -> +promise.Promise",
      "!doc": "Schedule execution of a callback to either or both of \"fulfill\" and\n\"reject\" resolutions for this promise. The callbacks are wrapped in a new\npromise and that promise is returned.  This allows operation chaining ala\n`functionA().then(functionB).then(functionC)` where `functionA` returns\na promise, and `functionB` and `functionC` _may_ return promises.\n\nAsynchronicity of the callbacks is guaranteed.",
      "!url": "http://yuilibrary.com/classes/Promise.html#method_then"
     },
     "getStatus": {
      "!type": "fn() -> string",
      "!doc": "Returns the current status of the operation. Possible results are\n\"pending\", \"fulfilled\", and \"rejected\".",
      "!url": "http://yuilibrary.com/classes/Promise.html#method_getStatus"
     }
    },
    "isPromise": {
     "!type": "fn(obj: Any) -> bool",
     "!doc": "Checks if an object or value is a promise. This is cross-implementation\ncompatible, so promises returned from other libraries or native components\nthat are compatible with the Promises A+ spec should be recognized by this\nmethod.",
     "!url": "http://yuilibrary.com/classes/Promise.html#method_isPromise"
    }
   },
   "Promise.Resolver": {
    "!type": "fn(promise: promise.Promise) -> +promise.Promise.Resolver",
    "!doc": "Represents an asynchronous operation. Provides a\nstandard API for subscribing to the moment that the operation completes either\nsuccessfully (`fulfill()`) or unsuccessfully (`reject()`).",
    "!url": "http://yuilibrary.com/classes/Promise.Resolver.html",
    "prototype": {
     "promise": {
      "!type": "+promise.Promise",
      "!doc": "The promise for this Resolver.",
      "!url": "http://yuilibrary.com/classes/Promise.Resolver.html#property_promise"
     },
     "fulfill": {
      "!type": "fn(value: Any)",
      "!doc": "Resolves the promise, signaling successful completion of the\nrepresented operation. All \"onFulfilled\" subscriptions are executed and passed\nthe value provided to this method. After calling `fulfill()`, `reject()` and\n`notify()` are disabled.",
      "!url": "http://yuilibrary.com/classes/Promise.Resolver.html#method_fulfill"
     },
     "reject": {
      "!type": "fn(value: Any)",
      "!doc": "Resolves the promise, signaling *un*successful completion of the\nrepresented operation. All \"onRejected\" subscriptions are executed with\nthe value provided to this method. After calling `reject()`, `resolve()`\nand `notify()` are disabled.",
      "!url": "http://yuilibrary.com/classes/Promise.Resolver.html#method_reject"
     },
     "then": {
      "!type": "fn(callback?: fn(), errback?: fn()) -> +promise.Promise",
      "!doc": "Schedule execution of a callback to either or both of \"resolve\" and\n\"reject\" resolutions for the Resolver.  The callbacks\nare wrapped in a new Resolver and that Resolver's corresponding promise\nis returned.  This allows operation chaining ala\n`functionA().then(functionB).then(functionC)` where `functionA` returns\na promise, and `functionB` and `functionC` _may_ return promises.",
      "!url": "http://yuilibrary.com/classes/Promise.Resolver.html#method_then"
     },
     "getStatus": {
      "!type": "fn() -> string",
      "!doc": "Returns the current status of the Resolver as a string \"pending\",\n\"fulfilled\", or \"rejected\".",
      "!url": "http://yuilibrary.com/classes/Promise.Resolver.html#method_getStatus"
     }
    }
   },
   "when": {
    "!type": "fn(promise: Any, callback?: fn(), errback?: fn()) -> +promise.Promise",
    "!doc": "Abstraction API allowing you to interact with promises or raw values as if they\nwere promises. If a non-promise object is passed in, a new Resolver is created\nand scheduled to resolve asynchronously with the provided value.\n\nIn either case, a promise is returned.  If either _callback_ or _errback_ are\nprovided, the promise returned is the one returned from calling\n`promise.then(callback, errback)` on the provided or created promise.  If neither\nare provided, the original promise is returned.",
    "!url": "http://yuilibrary.com/classes/YUI.html#method_when"
   }
  },
  "querystring": {
   "QueryString": {
    "!type": "fn()",
    "!doc": "The QueryString module adds support for serializing JavaScript objects into\nquery strings and parsing JavaScript objects from query strings format.",
    "!url": "http://yuilibrary.com/classes/QueryString.html",
    "parse": {
     "!type": "fn(qs: string, sep: string, eq: string)",
     "!doc": "Accept Query Strings and return native JavaScript objects.",
     "!url": "http://yuilibrary.com/classes/QueryString.html#method_parse"
    },
    "unescape": {
     "!type": "fn(s: string)",
     "!doc": "Provides Y.QueryString.unescape method to be able to override default decoding\nmethod.  This is important in cases where non-standard delimiters are used, if\nthe delimiters would not normally be handled properly by the builtin\n(en|de)codeURIComponent functions.\nDefault: replace \"+\" with \" \", and then decodeURIComponent behavior.",
     "!url": "http://yuilibrary.com/classes/QueryString.html#method_unescape"
    },
    "escape": {
     "!type": "fn()",
     "!doc": "Provides Y.QueryString.escape method to be able to override default encoding\nmethod.  This is important in cases where non-standard delimiters are used, if\nthe delimiters would not normally be handled properly by the builtin\n(en|de)codeURIComponent functions.\nDefault: encodeURIComponent",
     "!url": "http://yuilibrary.com/classes/QueryString.html#method_escape"
    },
    "stringify": {
     "!type": "fn(obj: Any, cfg: yui.Object, name: string)",
     "!doc": "<p>Converts an arbitrary value to a Query String representation.</p>\n\n<p>Objects with cyclical references will trigger an exception.</p>",
     "!url": "http://yuilibrary.com/classes/QueryString.html#method_stringify"
    }
   }
  },
  "queue_promote": {
   "Queue": {
    "!type": "fn(item: MIXED) -> +yui.Queue",
    "!doc": "A simple FIFO queue.  Items are added to the Queue with add(1..n items) and\nremoved using next().",
    "!url": "http://yuilibrary.com/classes/Queue.html",
    "prototype": {
     "indexOf": {
      "!type": "fn(needle: MIXED) -> number",
      "!doc": "Returns the current index in the queue of the specified item",
      "!url": "http://yuilibrary.com/classes/Queue.html#method_indexOf"
     },
     "promote": {
      "!type": "fn(item: MIXED)",
      "!doc": "Moves the referenced item to the head of the queue",
      "!url": "http://yuilibrary.com/classes/Queue.html#method_promote"
     },
     "remove": {
      "!type": "fn(item: MIXED)",
      "!doc": "Removes the referenced item from the queue",
      "!url": "http://yuilibrary.com/classes/Queue.html#method_remove"
     }
    }
   },
   "Record": {
    "!type": "fn()",
    "!doc": "Provides a wrapper around a standard javascript object. Can be inserted into a Recordset instance.",
    "!url": "http://yuilibrary.com/classes/Record.html",
    "prototype": {
     "getValue": {
      "!type": "fn(field: string)",
      "!doc": "Retrieve a particular (or all) values from the object",
      "!url": "http://yuilibrary.com/classes/Record.html#method_getValue"
     },
     "id": {
      "!type": "fn()",
      "!doc": "Unique ID of the record instance",
      "!url": "http://yuilibrary.com/classes/Record.html#attribute_id"
     },
     "data": {
      "!type": "fn()",
      "!doc": "The object stored within the record instance",
      "!url": "http://yuilibrary.com/classes/Record.html#attribute_data"
     }
    }
   }
  },
  "recordset": {
   "Recordset": {
    "!type": "fn(config: yui.Object) -> +recordset.Recordset",
    "!proto": "base.Base",
    "!doc": "The Recordset utility provides a standard way for dealing with\na collection of similar objects.\n\nProvides the base Recordset implementation, which can be extended to add\nadditional functionality, such as custom indexing. sorting, and filtering.",
    "!url": "http://yuilibrary.com/classes/Recordset.html",
    "prototype": {
     "add": {
      "!type": "fn(oData: queue_promote.Record, index?: number) -> +recordset.Recordset",
      "!doc": "Adds one or more Records to the RecordSet at the given index. If index is null, then adds the Records to the end of the RecordSet.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_add"
     },
     "remove": {
      "!type": "fn(index?: number, range?: number) -> +recordset.Recordset",
      "!doc": "Removes one or more Records to the RecordSet at the given index. If index\nis null, then removes a single Record from the end of the RecordSet.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_remove"
     },
     "empty": {
      "!type": "fn() -> +recordset.Recordset",
      "!doc": "Empties the recordset",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_empty"
     },
     "update": {
      "!type": "fn(data: queue_promote.Record, index?: number) -> +recordset.Recordset",
      "!doc": "Updates the recordset with the new records passed in. Overwrites existing\nrecords when updating the index with the new records.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_update"
     },
     "getRecord": {
      "!type": "fn(i: String, Number) -> +queue_promote.Record",
      "!doc": "Returns the record with particular ID or index",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_getRecord"
     },
     "getRecordByIndex": {
      "!type": "fn(i: number) -> +queue_promote.Record",
      "!doc": "Returns the record at a particular index",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_getRecordByIndex"
     },
     "getRecordsByIndex": {
      "!type": "fn(index: number, range: number) -> +yui.Array",
      "!doc": "Returns a range of records beginning at particular index",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_getRecordsByIndex"
     },
     "getLength": {
      "!type": "fn() -> number",
      "!doc": "Returns the length of the recordset",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_getLength"
     },
     "getValuesByKey": {
      "!type": "fn(key?: string) -> +yui.Array",
      "!doc": "Gets an array of values for a data _key_ in the set's records.  If no _key_\nis supplied, the returned array will contain the full data object for each\nrecord.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method_getValuesByKey"
     },
     "_setRecords": {
      "!type": "fn(items: [queue_promote.Record]) -> [+queue_promote.Record]",
      "!doc": "Ensures the value being set is an array of Record instances. If array items\nare raw object data, they are turned into Records.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#method__setRecords"
     },
     "records": {
      "!type": "fn()",
      "!doc": "An array of Records that the Recordset is storing.  Passing an array\nof raw record data is also accepted.  The data for each item will be\nwrapped in a Record instance.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#attribute_records"
     },
     "table": {
      "!type": "fn()",
      "!doc": "A hash table where the ID of the record is the key, and the record\ninstance is the value.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#attribute_table"
     },
     "key": {
      "!type": "fn()",
      "!doc": "The ID to use as the key in the hash table.",
      "!url": "http://yuilibrary.com/classes/Recordset.html#attribute_key"
     }
    }
   },
   "RecordsetFilter": {
    "!type": "fn()",
    "!doc": "Plugin that provides the ability to filter through a recordset.\nUses the filter methods available on Y.Array (see arrayextras submodule) to filter the recordset.",
    "!url": "http://yuilibrary.com/classes/RecordsetFilter.html",
    "prototype": {
     "filter": {
      "!type": "fn(filter: fn(), value?: Any) -> +recordset.Recordset",
      "!doc": "Filter through the recordset with a custom filter function, or a key-value\npair.",
      "!url": "http://yuilibrary.com/classes/RecordsetFilter.html#method_filter"
     },
     "reject": {
      "!type": "fn(filter: fn()) -> +recordset.Recordset",
      "!doc": "The inverse of filter. Executes the supplied function on each item. Returns\na new Recordset containing the items that the supplied function returned\n`false` for.",
      "!url": "http://yuilibrary.com/classes/RecordsetFilter.html#method_reject"
     },
     "grep": {
      "!type": "fn(pattern: RegExp) -> +recordset.Recordset",
      "!doc": "Iterates over the Recordset, returning a new Recordset of all the elements\nthat match the supplied regular expression",
      "!url": "http://yuilibrary.com/classes/RecordsetFilter.html#method_grep"
     }
    }
   },
   "RecordsetIndexer": {
    "!type": "fn()",
    "!doc": "Plugin that provides the ability to store multiple custom hash tables referencing records in the recordset.\nThis utility does not support any collision handling. New hash table entries with a used key overwrite older ones.",
    "!url": "http://yuilibrary.com/classes/RecordsetIndexer.html",
    "prototype": {
     "hashTables": {
      "!type": "fn()",
      "!doc": "Collection of all the hashTables created by the plugin.\nThe individual tables can be accessed by the key they are hashing against.",
      "!url": "http://yuilibrary.com/classes/RecordsetIndexer.html#attribute_hashTables"
     },
     "createTable": {
      "!type": "fn(key: string) -> +yui.Object",
      "!doc": "Creates a new hash table.",
      "!url": "http://yuilibrary.com/classes/RecordsetIndexer.html#method_createTable"
     },
     "getTable": {
      "!type": "fn(key: string) -> +yui.Object",
      "!doc": "Get a hash table that hashes records by a given key.",
      "!url": "http://yuilibrary.com/classes/RecordsetIndexer.html#method_getTable"
     }
    }
   },
   "RecordsetSort": {
    "!type": "fn()",
    "!doc": "Plugin that adds default and custom sorting functionality to the Recordset utility",
    "!url": "http://yuilibrary.com/classes/RecordsetSort.html",
    "prototype": {
     "lastSortProperties": {
      "!type": "fn()",
      "!doc": "The last properties used to sort. Consists of an object literal with the keys \"field\", \"desc\", and \"sorter\"",
      "!url": "http://yuilibrary.com/classes/RecordsetSort.html#attribute_lastSortProperties"
     },
     "defaultSorter": {
      "!type": "fn()",
      "!doc": "A boolean telling if the recordset is in a sorted state.",
      "!url": "http://yuilibrary.com/classes/RecordsetSort.html#attribute_defaultSorter"
     },
     "sort": {
      "!type": "fn(field: string, desc: bool)",
      "!doc": "Sorts the recordset.",
      "!url": "http://yuilibrary.com/classes/RecordsetSort.html#method_sort"
     },
     "resort": {
      "!type": "fn()",
      "!doc": "Resorts the recordset based on the last-used sort parameters (stored in 'lastSortProperties' ATTR)",
      "!url": "http://yuilibrary.com/classes/RecordsetSort.html#method_resort"
     },
     "reverse": {
      "!type": "fn()",
      "!doc": "Reverses the recordset calling the standard array.reverse() method.",
      "!url": "http://yuilibrary.com/classes/RecordsetSort.html#method_reverse"
     },
     "flip": {
      "!type": "fn()",
      "!doc": "Sorts the recordset based on the last-used sort parameters, but flips the order. (ie: Descending becomes ascending, and vice versa).",
      "!url": "http://yuilibrary.com/classes/RecordsetSort.html#method_flip"
     }
    }
   }
  },
  "resize": {
   "Resize": {
    "!type": "fn(config: yui.Object) -> +resize.Resize",
    "!proto": "base.Base",
    "!doc": "A base class for Resize, providing:\n\n   * Basic Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)\n   * Applies drag handles to an element to make it resizable\n   * Here is the list of valid resize handles:\n       `[ 't', 'tr', 'r', 'br', 'b', 'bl', 'l', 'tl' ]`. You can\n       read this list as top, top-right, right, bottom-right, bottom,\n       bottom-left, left, top-left.\n   * The drag handles are inserted into the element and positioned\n       absolute. Some elements, such as a textarea or image, don't support\n       children. To overcome that, set wrap:true in your config and the\n       element willbe wrapped for you automatically.\n\nQuick Example:\n\n    var instance = new Y.Resize({\n        node: '#resize1',\n        preserveRatio: true,\n        wrap: true,\n        maxHeight: 170,\n        maxWidth: 400,\n        handles: 't, tr, r, br, b, bl, l, tl'\n    });\n\nCheck the list of <a href=\"Resize.html#attrs\">Configuration Attributes</a> available for\nResize.",
    "!url": "http://yuilibrary.com/classes/Resize.html",
    "NAME": {
     "!type": "string",
     "!doc": "Static property provides a string to identify the class.",
     "!url": "http://yuilibrary.com/classes/Resize.html#property_NAME"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Resize.",
     "!url": "http://yuilibrary.com/classes/Resize.html#property_ATTRS"
    },
    "prototype": {
     "autoHide": {
      "!type": "fn()",
      "!doc": "False to ensure that the resize handles are always visible, true to\ndisplay them only when the user mouses over the resizable borders.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_autoHide"
     },
     "defMinHeight": {
      "!type": "fn()",
      "!doc": "The default minimum height of the element. Only used when\nResizeConstrained is not plugged.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_defMinHeight"
     },
     "defMinWidth": {
      "!type": "fn()",
      "!doc": "The default minimum width of the element. Only used when\nResizeConstrained is not plugged.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_defMinWidth"
     },
     "handles": {
      "!type": "fn()",
      "!doc": "The handles to use (any combination of): 't', 'b', 'r', 'l', 'bl',\n'br', 'tl', 'tr'. Can use a shortcut of All.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_handles"
     },
     "handlesWrapper": {
      "!type": "fn()",
      "!doc": "Node to wrap the resize handles.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_handlesWrapper"
     },
     "node": {
      "!type": "fn()",
      "!doc": "The selector or element to resize. Required.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_node"
     },
     "resizing": {
      "!type": "fn()",
      "!doc": "True when the element is being Resized.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_resizing"
     },
     "wrap": {
      "!type": "fn()",
      "!doc": "True to wrap an element with a div if needed (required for textareas\nand images, defaults to false) in favor of the handles config option.\nThe wrapper element type (default div) could be over-riden passing the\n<code>wrapper</code> attribute.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_wrap"
     },
     "wrapTypes": {
      "!type": "fn()",
      "!doc": "Elements that requires a wrapper by default. Normally are elements\nwhich cannot have children elements.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_wrapTypes"
     },
     "wrapper": {
      "!type": "fn()",
      "!doc": "Element to wrap the <code>wrapTypes</code>. This element will house\nthe handles elements.",
      "!url": "http://yuilibrary.com/classes/Resize.html#attribute_wrapper"
     },
     "ALL_HANDLES": {
      "!type": "string",
      "!doc": "Array containing all possible resizable handles.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_ALL_HANDLES"
     },
     "REGEX_CHANGE_HEIGHT": {
      "!type": "string",
      "!doc": "Regex which matches with the handles that could change the height of\nthe resizable element.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_REGEX_CHANGE_HEIGHT"
     },
     "REGEX_CHANGE_LEFT": {
      "!type": "string",
      "!doc": "Regex which matches with the handles that could change the left of\nthe resizable element.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_REGEX_CHANGE_LEFT"
     },
     "REGEX_CHANGE_TOP": {
      "!type": "string",
      "!doc": "Regex which matches with the handles that could change the top of\nthe resizable element.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_REGEX_CHANGE_TOP"
     },
     "REGEX_CHANGE_WIDTH": {
      "!type": "string",
      "!doc": "Regex which matches with the handles that could change the width of\nthe resizable element.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_REGEX_CHANGE_WIDTH"
     },
     "HANDLES_WRAP_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the resize wrapper for the handles.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_HANDLES_WRAP_TEMPLATE"
     },
     "WRAP_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the resize wrapper node when needed.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_WRAP_TEMPLATE"
     },
     "HANDLE_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create each resize handle.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_HANDLE_TEMPLATE"
     },
     "totalHSurrounding": {
      "!type": "number",
      "!doc": "Each box has a content area and optional surrounding padding and\nborder areas. This property stores the sum of all horizontal\nsurrounding * information needed to adjust the node height.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_totalHSurrounding"
     },
     "totalVSurrounding": {
      "!type": "number",
      "!doc": "Each box has a content area and optional surrounding padding and\nborder areas. This property stores the sum of all vertical\nsurrounding * information needed to adjust the node height.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_totalVSurrounding"
     },
     "nodeSurrounding": {
      "!type": "+yui.Object",
      "!doc": "Stores the <a href=\"Resize.html#attr_node\">node</a>\nsurrounding information retrieved from\n<a href=\"Resize.html#method__getBoxSurroundingInfo\">_getBoxSurroundingInfo</a>.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_nodeSurrounding"
     },
     "wrapperSurrounding": {
      "!type": "+yui.Object",
      "!doc": "Stores the <a href=\"Resize.html#attr_wrapper\">wrapper</a>\nsurrounding information retrieved from\n<a href=\"Resize.html#method__getBoxSurroundingInfo\">_getBoxSurroundingInfo</a>.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_wrapperSurrounding"
     },
     "changeHeightHandles": {
      "!type": "+boolean",
      "!doc": "Whether the handle being dragged can change the height.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_changeHeightHandles"
     },
     "changeLeftHandles": {
      "!type": "+boolean",
      "!doc": "Whether the handle being dragged can change the left.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_changeLeftHandles"
     },
     "changeTopHandles": {
      "!type": "+boolean",
      "!doc": "Whether the handle being dragged can change the top.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_changeTopHandles"
     },
     "changeWidthHandles": {
      "!type": "+boolean",
      "!doc": "Whether the handle being dragged can change the width.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_changeWidthHandles"
     },
     "delegate": {
      "!type": "+yui.Object",
      "!doc": "Store DD.Delegate reference for the respective Resize instance.",
      "!url": "http://yuilibrary.com/classes/Resize.html#property_delegate"
     },
     "eachHandle": {
      "!type": "fn(fn: fn())",
      "!doc": "<p>Loop through each handle which is being used and executes a callback.</p>\n<p>Example:</p>\n<pre><code>instance.eachHandle(\n     function(handleName, index) { ... }\n );</code></pre>",
      "!url": "http://yuilibrary.com/classes/Resize.html#method_eachHandle"
     },
     "resize:start": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the resize start event. Fired when a handle starts to be\ndragged.",
      "!url": "http://yuilibrary.com/classes/Resize.html#event_resize:start"
     },
     "resize:resize": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the resize event. Fired on each pixel when the handle is\nbeing dragged.",
      "!url": "http://yuilibrary.com/classes/Resize.html#event_resize:resize"
     },
     "resize:align": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the resize align event.",
      "!url": "http://yuilibrary.com/classes/Resize.html#event_resize:align"
     },
     "resize:end": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the resize end event. Fired when a handle stop to be\ndragged.",
      "!url": "http://yuilibrary.com/classes/Resize.html#event_resize:end"
     },
     "resize:mouseUp": {
      "!type": "fn(event: event_custom.EventFacade)",
      "!doc": "Handles the resize mouseUp event. Fired when a mouseUp event happens on a\nhandle.",
      "!url": "http://yuilibrary.com/classes/Resize.html#event_resize:mouseUp"
     }
    }
   },
   "Plugin.ResizeConstrained": {
    "!type": "fn()",
    "!doc": "A Resize plugin that will attempt to constrain the resize node to the boundaries.",
    "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html",
    "prototype": {
     "constrain": {
      "!type": "fn()",
      "!doc": "Will attempt to constrain the resize node to the boundaries. Arguments:<br>\n'view': Contrain to Viewport<br>\n'#selector_string': Constrain to this node<br>\n'{Region Object}': An Object Literal containing a valid region (top, right, bottom, left) of page positions",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_constrain"
     },
     "minHeight": {
      "!type": "fn()",
      "!doc": "The minimum height of the element",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_minHeight"
     },
     "minWidth": {
      "!type": "fn()",
      "!doc": "The minimum width of the element",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_minWidth"
     },
     "maxHeight": {
      "!type": "fn()",
      "!doc": "The maximum height of the element",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_maxHeight"
     },
     "maxWidth": {
      "!type": "fn()",
      "!doc": "The maximum width of the element",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_maxWidth"
     },
     "preserveRatio": {
      "!type": "fn()",
      "!doc": "Maintain the element's ratio when resizing.",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_preserveRatio"
     },
     "tickX": {
      "!type": "fn()",
      "!doc": "The number of x ticks to span the resize to.",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_tickX"
     },
     "tickY": {
      "!type": "fn()",
      "!doc": "The number of y ticks to span the resize to.",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#attribute_tickY"
     },
     "constrainSurrounding": {
      "!type": "+yui.Object",
      "!doc": "Stores the <code>constrain</code>\nsurrounding information retrieved from\n<a href=\"Resize.html#method__getBoxSurroundingInfo\">_getBoxSurroundingInfo</a>.",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeConstrained.html#property_constrainSurrounding"
     }
    }
   },
   "Plugin.Resize": {
    "!type": "fn()",
    "!proto": "resize.Resize",
    "!doc": "The Resize Plugin allows you to make a Node or a Widget resizable. It supports all the functionality of\nthe standalone Resize utility. Additionally, resizing a widget updates the widget's height,width and x,y\nattributes, if they exist.\n\n\n       var overlay = new Y.Overlay({\n          width: \"200px\",\n          srcNode: \"#overlay\",\n          visible: false,\n          align: {node:\".example\", points:[\"tc\", \"bc\"]}\n       });\n       overlay.plug(Y.Plugin.Resize);",
    "!url": "http://yuilibrary.com/classes/Plugin.Resize.html",
    "prototype": {
     "NAME": {
      "!type": "string",
      "!doc": "resize-plugin",
      "!url": "http://yuilibrary.com/classes/Plugin.Resize.html#property_NAME"
     },
     "NS": {
      "!type": "string",
      "!doc": "The Resize instance will be placed on the Node instance under\nthe resize namespace. It can be accessed via Node.resize or Widget.resize;",
      "!url": "http://yuilibrary.com/classes/Plugin.Resize.html#property_NS"
     },
     "node": {
      "!type": "fn()",
      "!doc": "Stores the node that is being resized",
      "!url": "http://yuilibrary.com/classes/Plugin.Resize.html#attribute_node"
     },
     "widget": {
      "!type": "fn()",
      "!doc": "Stores the widget that the node belongs to, if one exists",
      "!url": "http://yuilibrary.com/classes/Plugin.Resize.html#attribute_widget"
     }
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "Static property used to define the default attribute\nconfiguration for the Resize plugin.",
     "!url": "http://yuilibrary.com/classes/Plugin.Resize.html#property_ATTRS"
    }
   },
   "Plugin.ResizeProxy": {
    "!type": "fn() -> +resize.Plugin.ResizeProxy",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Adds a `proxyNode` attribute and resizes it instead of the actual node. __very similar to DDProxy__\n\n    var resize = new Y.Resize({\n        //Selector of the node to resize\n        node: '#demo'\n    });\n    resize.plug(Y.Plugin.ResizeProxy);",
    "!url": "http://yuilibrary.com/classes/Plugin.ResizeProxy.html",
    "prototype": {
     "proxyNode": {
      "!type": "fn()",
      "!doc": "The Resize proxy element.",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeProxy.html#attribute_proxyNode"
     },
     "PROXY_TEMPLATE": {
      "!type": "string",
      "!doc": "Template used to create the resize proxy.",
      "!url": "http://yuilibrary.com/classes/Plugin.ResizeProxy.html#property_PROXY_TEMPLATE"
     }
    }
   }
  },
  "scrollview_list": {
   "Plugin.ScrollViewList": {
    "!type": "fn() -> +scrollview_list.Plugin.ScrollViewList",
    "!proto": "plugin.Plugin.Base",
    "!doc": "ScrollView plugin that adds class names to immediate descendant \"<li>\" to\n allow for easier styling through CSS",
    "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewList.html",
    "NAME": {
     "!type": "string",
     "!doc": "The identity of the plugin",
     "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewList.html#property_NAME"
    },
    "NS": {
     "!type": "string",
     "!doc": "The namespace on which the plugin will reside.",
     "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewList.html#property_NS"
    },
    "ATTRS": {
     "!type": "+yui.Object",
     "!doc": "The default attribute configuration for the plugin",
     "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewList.html#property_ATTRS"
    },
    "prototype": {
     "isAttached": {
      "!type": "fn()",
      "!doc": "Specifies whether the list elements (the immediate <ul>'s and the\n immediate <li>'s inside those <ul>'s) have class names attached to\n them or not",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewList.html#attribute_isAttached"
     },
     "initializer": {
      "!type": "fn()",
      "!doc": "Designated initializer",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewList.html#method_initializer"
     }
    }
   }
  },
  "scrollview_paginator": {
   "Plugin.ScrollViewPaginator": {
    "!type": "fn() -> +scrollview_paginator.Plugin.ScrollViewPaginator",
    "!proto": "plugin.Plugin.Base",
    "!doc": "Scrollview plugin that adds support for paging",
    "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html",
    "prototype": {
     "initializer": {
      "!type": "fn(Configuration: yui.Object)",
      "!doc": "Designated initializer",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#method_initializer"
     },
     "next": {
      "!type": "fn()",
      "!doc": "Scroll to the next page, with animation",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#method_next"
     },
     "prev": {
      "!type": "fn()",
      "!doc": "Scroll to the previous page, with animation",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#method_prev"
     },
     "scrollTo": {
      "!type": "fn()",
      "!doc": "Deprecated for 3.7.0.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#method_scrollTo"
     },
     "scrollToIndex": {
      "!type": "fn(index: number, duration?: number, easing?: string)",
      "!doc": "Scroll to a given page in the scrollview",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#method_scrollToIndex"
     },
     "axis": {
      "!type": "fn()",
      "!doc": "Specifies ability to scroll on x, y, or x and y axis/axes.\n If unspecified, it inherits from the host instance.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#attribute_axis"
     },
     "selector": {
      "!type": "fn()",
      "!doc": "CSS selector for a page inside the scrollview. The scrollview\nwill snap to the closest page.",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#attribute_selector"
     },
     "index": {
      "!type": "fn()",
      "!doc": "The active page number for a paged scrollview",
      "!url": "http://yuilibrary.com/classes/Plugin.ScrollViewPaginator.html#attribute_index"
     },
     "total": {
      "!type": "fn()