/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service;

import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRemoteException;

public class JiraRemoteMessageException
extends JiraRemoteException {
    private static final long serialVersionUID = 4622602207502097037L;
    private final String htmlMessage;

    public JiraRemoteMessageException(String message, String htmlMessage) {
        super(message);
        this.htmlMessage = htmlMessage;
    }

    public JiraRemoteMessageException(String htmlMessage) {
        super(JiraRemoteMessageException.getTitle(htmlMessage));
        this.htmlMessage = htmlMessage;
    }

    private static String getTitle(String text) {
        int stop;
        if (text == null) {
            return null;
        }
        int start = text.indexOf("<strong>");
        if (start != -1 && (stop = text.indexOf("</strong>", start + 8)) != -1) {
            return text.substring(start + 8, stop);
        }
        start = text.indexOf("<li>");
        if (start != -1 && (stop = text.indexOf("</li>", start + 4)) != -1) {
            return text.substring(start + 4, stop);
        }
        start = text.indexOf("<p>");
        if (start != -1 && (stop = text.indexOf("</p>", start + 3)) != -1) {
            return text.substring(start + 3, stop);
        }
        return null;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public String toString() {
        String message = this.getMessage();
        if (message != null) {
            if (this.htmlMessage != null) {
                return String.valueOf(message) + " (" + this.htmlMessage + ")";
            }
            return message;
        }
        return this.htmlMessage;
    }
}

