/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service;

import com.atlassian.connector.eclipse.internal.jira.core.JiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.model.Attachment;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraAction;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.ProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueCollector;
import com.atlassian.connector.eclipse.internal.jira.core.service.FilterDefinitionConverter;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClientCache;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraLocalConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.service.rest.JiraRestClientAdapter;
import com.atlassian.connector.eclipse.internal.jira.core.service.soap.JiraSoapClient;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.domain.SessionInfo;
import java.io.InputStream;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraClient {
    private static final String URL_REGEXP_HTTP = "http.*";
    private static final String URL_REGEXP_HTTPS = "https.*";
    private static final String PROXY_TYPE_HTTP = "HTTP";
    private static final String PROXY_TYPE_HTTPS = "HTTPS";
    public static final int ASSIGNEE_CURRENT = 2;
    public static final int ASSIGNEE_DEFAULT = 1;
    public static final int ASSIGNEE_NONE = 3;
    public static final int ASSIGNEE_SELF = 5;
    public static final int ASSIGNEE_USER = 4;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final String baseUrl;
    private final JiraClientCache cache;
    private final AbstractWebLocation location;
    private final JiraSoapClient soapClient;
    private JiraLocalConfiguration localConfiguration;
    private JiraRestClientAdapter restClient = null;

    public JiraClient(AbstractWebLocation location, JiraLocalConfiguration configuration, JiraRestClientAdapter restClient) {
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)configuration);
        this.baseUrl = location.getUrl();
        this.location = location;
        this.localConfiguration = configuration;
        this.cache = new JiraClientCache(this);
        this.soapClient = new JiraSoapClient(this);
        this.restClient = restClient;
    }

    public JiraClient(AbstractWebLocation location, JiraLocalConfiguration configuration) {
        this(location, configuration, null);
    }

    public JiraClient(AbstractWebLocation location) {
        this(location, new JiraLocalConfiguration());
    }

    private JiraRestClientAdapter getRestClient() {
        if (this.restClient == null) {
            this.restClient = this.createRestClient(this.location, this.cache);
        }
        return this.restClient;
    }

    private JiraRestClientAdapter createRestClient(AbstractWebLocation location, JiraClientCache cache) {
        Proxy proxy = null;
        String baseUrl = location.getUrl();
        if (baseUrl.matches(URL_REGEXP_HTTPS)) {
            proxy = location.getProxyForHost(baseUrl, PROXY_TYPE_HTTPS);
        } else if (baseUrl.matches(URL_REGEXP_HTTP)) {
            proxy = location.getProxyForHost(baseUrl, PROXY_TYPE_HTTP);
        }
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.REPOSITORY);
        String username = "";
        String password = null;
        if (credentials != null) {
            username = credentials.getUserName();
            password = credentials.getPassword();
        }
        return new JiraRestClientAdapter(baseUrl, username, password, proxy, cache, this.localConfiguration.getFollowRedirects());
    }

    public void addCommentToIssue(String issueKey, String comment, IProgressMonitor monitor) throws JiraException {
        try {
            this.getRestClient().addComment(issueKey, comment);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public void advanceIssueWorkflow(JiraIssue issue, String actionKey, String comment, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("advanceIssueWorkflow", null);
        try {
            Iterable<IssueField> fields = this.getActionFields(issue.getKey(), actionKey, monitor);
            this.getRestClient().transitionIssue(issue, actionKey, comment, fields);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public void assignIssueTo(JiraIssue issue, String user, String comment, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("assignIssueTo", null);
        try {
            this.getRestClient().assignIssue(issue.getKey(), user, comment);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
        if (!StringUtils.isEmpty((String)comment)) {
            this.addCommentToIssue(issue.getKey(), comment, monitor);
        }
    }

    public void addAttachment(JiraIssue jiraIssue, String comment, String filename, byte[] content, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("addAttachment", null);
        if (content.length == 0) {
            throw new JiraException("Cannot attach empty file");
        }
        try {
            this.getRestClient().addAttachment(jiraIssue.getKey(), content, filename);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
        if (!StringUtils.isEmpty((String)comment)) {
            this.addCommentToIssue(jiraIssue.getKey(), comment, monitor);
        }
    }

    public JiraIssue createIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        Project project;
        JiraCorePlugin.getMonitoring().logJob("createIssue", null);
        if (issue.getProject().getKey() == null && (project = this.cache.getProjectById(issue.getProject().getId(), monitor)) != null) {
            issue.getProject().setKey(project.getKey());
        }
        try {
            String issueKey = this.getRestClient().createIssue(issue);
            return this.getIssueByKey(issueKey, monitor);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public void deleteIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("deleteIssue", null);
        this.soapClient.deleteIssue(issue.getKey(), monitor);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JiraClient) {
            return this.getBaseUrl().equals(((JiraClient)obj).getBaseUrl());
        }
        return false;
    }

    public void findIssues(FilterDefinition filterDefinition, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("findIssues", null);
        FilterDefinitionConverter filterConverter = new FilterDefinitionConverter(DEFAULT_CHARSET, this.getLocalConfiguration().getDateTimeFormat());
        String jql = filterConverter.getJqlString(filterDefinition);
        this.findIssues(jql, collector, monitor);
    }

    private void findIssues(String jql, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        try {
            List<JiraIssue> issues = this.getRestClient().getIssues(jql, this.localConfiguration.getMaxSearchResults(), monitor);
            if (!collector.isCancelled()) {
                collector.start();
                for (JiraIssue issue : issues) {
                    collector.collectIssue(issue);
                }
                collector.done();
            }
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public Iterable<IssueField> getActionFields(String issueKey, String actionId, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getActionFields", null);
        Iterable<JiraAction> actions = this.getAvailableActions(issueKey, monitor);
        for (JiraAction action : actions) {
            if (!action.getId().equals(actionId)) continue;
            return action.getFields();
        }
        return Collections.emptyList();
    }

    public Iterable<JiraAction> getAvailableActions(String issueKey, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getAvailableActions", null);
        try {
            return this.getRestClient().getTransitions(issueKey);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public JiraClientCache getCache() {
        return this.cache;
    }

    public String getCharacterEncoding(IProgressMonitor monitor) throws JiraException {
        if (this.localConfiguration.getCharacterEncoding() == null) {
            return DEFAULT_CHARSET;
        }
        return this.localConfiguration.getCharacterEncoding();
    }

    public synchronized JiraLocalConfiguration getLocalConfiguration() {
        return this.localConfiguration;
    }

    public JiraIssue getIssueByKey(String issueKey, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getIssueByKey", null);
        try {
            return this.getRestClient().getIssueByKeyOrId(issueKey, monitor);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public JiraIssue getIssueById(String issueId, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getIssueByUrl", null);
        try {
            return this.getRestClient().getIssueByKeyOrId(issueId, monitor);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public IssueType[] getIssueTypes(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getIssueTypes", null);
        try {
            return this.getRestClient().getIssueTypes();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public NamedFilter[] getNamedFilters(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getNamedFilters", null);
        try {
            return this.getRestClient().getFavouriteFilters();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public Priority[] getPriorities(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getPriorities", null);
        try {
            return this.getRestClient().getPriorities();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public Project[] getProjects(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getProjects", null);
        try {
            return this.getRestClient().getProjects();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public Resolution[] getResolutions(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getResolutions", null);
        try {
            return this.getRestClient().getResolutions();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public SessionInfo getSessionInfo(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getAuthInfo", null);
        try {
            return this.getRestClient().getSessionInfo();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getServerInfo", null);
        try {
            ServerInfo serverInfo = this.getRestClient().getServerInfo();
            serverInfo.setCharacterEncoding(DEFAULT_CHARSET);
            return serverInfo;
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public JiraSoapClient getSoapClient() {
        return this.soapClient;
    }

    public JiraStatus[] getStatuses(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getStatuses", null);
        try {
            return this.getRestClient().getStatuses();
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public void getProjectDetails(Project project) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getProjectDetails", null);
        try {
            this.getRestClient().getProjectDetails(project);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public String getUserName() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        return credentials != null ? credentials.getUserName() : "";
    }

    public int hashCode() {
        return this.getBaseUrl().hashCode();
    }

    public void logout(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("logout", null);
        this.soapClient.logout(monitor);
    }

    public InputStream getAttachment(JiraIssue jiraIssue, Attachment attachment, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getAttachment", null);
        try {
            return this.getRestClient().getAttachment(attachment.getContent());
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public void search(JiraFilter query, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        if (query instanceof FilterDefinition) {
            this.findIssues((FilterDefinition)query, collector, monitor);
        } else if (query instanceof NamedFilter) {
            this.findIssues(((NamedFilter)query).getJql(), collector, monitor);
        } else {
            throw new IllegalArgumentException("Unknown query type: " + query.getClass());
        }
    }

    public String toString() {
        return this.getBaseUrl();
    }

    public void updateIssue(JiraIssue issue, String comment, boolean updateEstimate, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("updateIssue", null);
        try {
            this.getRestClient().updateIssue(issue, updateEstimate);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
        if (!StringUtils.isEmpty((String)comment)) {
            this.addCommentToIssue(issue.getKey(), comment, monitor);
        }
    }

    public SecurityLevel[] getAvailableSecurityLevels(String projectKey, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getAvailableSecurityLevels", null);
        return this.getRestClient().getSecurityLevels(projectKey);
    }

    public void addWorkLog(String issueKey, JiraWorkLog log, IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("addWorkLog", null);
        try {
            this.getRestClient().addWorklog(issueKey, log);
        }
        catch (RestClientException e) {
            throw new JiraException(e);
        }
    }

    public ProjectRole[] getProjectRoles(IProgressMonitor monitor) throws JiraException {
        JiraCorePlugin.getMonitoring().logJob("getProjectRoles", null);
        return new ProjectRole[0];
    }

    public synchronized void setLocalConfiguration(JiraLocalConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.localConfiguration = configuration;
    }

    public boolean isCompressionEnabled() {
        return this.getLocalConfiguration().isCompressionEnabled();
    }

    public synchronized void purgeSession() {
        this.soapClient.purgeSession();
        this.restClient = this.createRestClient(this.location, this.cache);
    }

    public String getAssigneeParam(JiraIssue issue, int assigneeType, String user) {
        switch (assigneeType) {
            case 2: {
                return issue.getAssignee();
            }
            case 1: {
                return "-1";
            }
            case 3: {
                return "";
            }
            case 5: {
                return this.getUserName();
            }
            case 4: {
                return user;
            }
        }
        return user;
    }

    public SimpleDateFormat getDateTimeFormat() {
        return JiraRestClientAdapter.getDateTimeFormat();
    }

    public SimpleDateFormat getDateFormat() {
        return JiraRestClientAdapter.getDateFormat();
    }
}

