/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model.filter;

import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.Filter;
import java.io.Serializable;

public class VersionFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Version[] versions;
    private final boolean unreleasedVersions;
    private final boolean releasedVersions;
    private final boolean hasNoneVersion;

    public VersionFilter(Version[] versions, boolean none, boolean released, boolean unreleased) {
        this.versions = versions;
        this.releasedVersions = released;
        this.unreleasedVersions = unreleased;
        this.hasNoneVersion = none;
    }

    public boolean isReleasedVersions() {
        return this.releasedVersions;
    }

    public boolean isUnreleasedVersions() {
        return this.unreleasedVersions;
    }

    public boolean hasNoVersion() {
        return this.hasNoneVersion;
    }

    public Version[] getVersions() {
        return this.versions;
    }

    public VersionFilter copy() {
        if (this.versions != null) {
            Version[] copy = new Version[this.versions.length];
            System.arraycopy(this.versions, 0, copy, 0, this.versions.length);
            return new VersionFilter(copy, this.hasNoneVersion, this.releasedVersions, this.unreleasedVersions);
        }
        return new VersionFilter(this.versions, this.hasNoneVersion, this.releasedVersions, this.unreleasedVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isReleasedVersions()) {
            sb.append("<released versions>");
        }
        if (this.isUnreleasedVersions()) {
            sb.append("<unreleased versions>");
        }
        if (this.hasNoVersion()) {
            sb.append("<no version>");
        }
        if (this.versions != null && this.versions.length > 0) {
            sb.append("<specified versions>");
        }
        return sb.toString();
    }
}

