/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.commons.api.BambooServerFacade2;
import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClient;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClientData;
import com.atlassian.connector.eclipse.internal.core.ServerDataUtil;
import com.atlassian.connector.eclipse.internal.core.client.HttpSessionCallbackImpl;
import com.atlassian.connector.eclipse.internal.core.client.RepositoryClientManager;
import com.atlassian.theplugin.commons.bamboo.BambooServerFacadeImpl;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import java.io.File;
import java.util.Map;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooClientManager
extends RepositoryClientManager<BambooClient, BambooClientData> {
    private BambooServerFacade2 bambooServerFacade;
    private final HttpSessionCallbackImpl clientCallback = new HttpSessionCallbackImpl();

    public BambooClientManager(File cacheFile) {
        super(cacheFile);
    }

    public synchronized BambooClient getClient(TaskRepository taskRepository) {
        BambooClient client = (BambooClient)((Object)super.getClient(taskRepository));
        AbstractWebLocation location = this.getTaskRepositoryLocationFactory().createWebLocation(taskRepository);
        ConnectionCfg serverCfg = ServerDataUtil.getServerData((AbstractWebLocation)location, (TaskRepository)taskRepository, (boolean)false);
        this.updateHttpSessionCallback(location, serverCfg);
        return client;
    }

    public BambooClient getNewClient(TaskRepository repository) {
        BambooClient client = this.createClient(repository, new BambooClientData(), false);
        AbstractWebLocation location = this.getTaskRepositoryLocationFactory().createWebLocation(repository);
        ConnectionCfg serverCfg = ServerDataUtil.getServerData((AbstractWebLocation)location, (TaskRepository)repository, (boolean)false);
        this.updateHttpSessionCallback(location, serverCfg);
        return client;
    }

    private void updateHttpSessionCallback(AbstractWebLocation location, ConnectionCfg serverCfg) {
        this.clientCallback.updateHostConfiguration(location, serverCfg);
    }

    protected BambooClient createClient(TaskRepository taskRepository, BambooClientData data) {
        return this.createClient(taskRepository, data, false);
    }

    private BambooClient createClient(TaskRepository taskRepository, BambooClientData data, boolean isTemporary) {
        AbstractWebLocation location = this.getTaskRepositoryLocationFactory().createWebLocation(taskRepository);
        ConnectionCfg serverCfg = ServerDataUtil.getServerData((AbstractWebLocation)location, (TaskRepository)taskRepository, (boolean)isTemporary);
        this.configureHttpSessionCallback(location, serverCfg);
        BambooServerFacade2 facade = this.getBambooFacade();
        return new BambooClient(location, serverCfg, facade, data, this.clientCallback);
    }

    private synchronized BambooServerFacade2 getBambooFacade() {
        if (this.bambooServerFacade == null) {
            this.bambooServerFacade = new BambooServerFacadeImpl(LoggerImpl.getInstance(), (HttpSessionCallback)this.clientCallback);
        }
        return this.bambooServerFacade;
    }

    public BambooClient createTempClient(TaskRepository taskRepository, BambooClientData data) {
        return this.createClient(taskRepository, data, true);
    }

    public void deleteTempClient(ConnectionCfg serverData) {
        this.clientCallback.removeClient(serverData);
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        super.repositoryRemoved(repository);
        AbstractWebLocation location = this.getTaskRepositoryLocationFactory().createWebLocation(repository);
        ConnectionCfg serverCfg = ServerDataUtil.getServerData((AbstractWebLocation)location, (TaskRepository)repository, (boolean)false);
        this.clientCallback.removeClient(serverCfg);
        BambooCorePlugin.getBuildPlanManager().repositoryRemoved(repository);
    }

    private void configureHttpSessionCallback(AbstractWebLocation location, ConnectionCfg serverCfg) {
        this.clientCallback.updateHostConfiguration(location, serverCfg);
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        TaskRepositoryLocationFactory parentFactory = super.getTaskRepositoryLocationFactory();
        if (parentFactory == null) {
            return new TaskRepositoryLocationFactory();
        }
        return parentFactory;
    }

    protected BambooClientData createRepositoryConfiguration() {
        return new BambooClientData();
    }

    public HttpSessionCallbackImpl getClientCallback() {
        return this.clientCallback;
    }

    protected BambooClientData getConfiguration(BambooClient client) {
        return client.getClientData();
    }

    protected void updateClientDataMap(Map<String, BambooClient> clientByUrl, Map<String, BambooClientData> clientDataByUrl) {
        for (Map.Entry<String, BambooClient> entry : clientByUrl.entrySet()) {
            String url = entry.getKey();
            if (!clientDataByUrl.containsKey(url)) continue;
            clientDataByUrl.put(url, this.getConfiguration(entry.getValue()));
        }
    }

    protected void removeClient(TaskRepository repository, Map<String, BambooClient> clientByUrl, Map<String, BambooClientData> clientDataByUrl) {
        String url = repository.getRepositoryUrl();
        BambooClient client = clientByUrl.remove(url);
        if (client != null && clientDataByUrl.containsKey(url)) {
            clientDataByUrl.put(url, this.getConfiguration(client));
        }
    }
}

