/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjectIdDictionary {
    private final Map map = new HashMap();
    private int invalidCounter;

    public void associateId(Object obj, Object id) {
        this.map.put(new WeakIdWrapper(obj), id);
        this.cleanup();
    }

    public Object lookupId(Object obj) {
        Object id = this.map.get(new IdWrapper(obj));
        this.cleanup();
        return id;
    }

    public boolean containsId(Object item) {
        boolean b = this.map.containsKey(new IdWrapper(item));
        this.cleanup();
        return b;
    }

    public void removeId(Object item) {
        this.map.remove(new IdWrapper(item));
        this.cleanup();
    }

    public int size() {
        return this.map.size();
    }

    private void cleanup() {
        if (this.invalidCounter > 100) {
            Iterator iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                WeakIdWrapper key = (WeakIdWrapper)iterator.next();
                if (key.get() != null) continue;
                iterator.remove();
            }
            this.invalidCounter = 0;
        }
    }

    private static class IdWrapper
    implements Wrapper {
        private final Object obj;

        public IdWrapper(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object other) {
            return this.obj == ((Wrapper)other).get();
        }

        public String toString() {
            return this.obj.toString();
        }

        public Object get() {
            return this.obj;
        }
    }

    private class WeakIdWrapper
    implements Wrapper {
        private final int hashCode;
        private final WeakReference ref;

        public WeakIdWrapper(Object obj) {
            this.hashCode = System.identityHashCode(obj);
            this.ref = new WeakReference<Object>(obj);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return this.get() == ((Wrapper)other).get();
        }

        public String toString() {
            Object obj = this.get();
            return obj == null ? "(null)" : obj.toString();
        }

        public Object get() {
            Object obj = this.ref.get();
            if (obj == null) {
                ++ObjectIdDictionary.this.invalidCounter;
            }
            return obj;
        }
    }

    private static interface Wrapper {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();

        public Object get();
    }
}

