/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.HyperlinkUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.webflow.ui.editor.WebflowNamespaceUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StateReferenceHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        Node flowNode = WebflowNamespaceUtils.locateFlowRootNode(node);
        NodeList nodes = flowNode.getChildNodes();
        if (nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                String id = BeansEditorUtils.getAttribute((Node)nodes.item(i), (String)"id");
                if (target.equals(id)) {
                    IRegion region = HyperlinkUtils.getHyperlinkRegion((Node)nodes.item(i));
                    return new NodeElementHyperlink(hyperlinkRegion, region, textViewer);
                }
                ++i;
            }
        }
        return null;
    }
}

