/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.TempFile;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.TempFileStorage;

public class UploadFileServlet
extends HttpServlet {
    private static final long serialVersionUID = -3271748843766809687L;
    private static final String PHOTO_PART = "photo";
    private static final String TEMP_PREFIX = "temp";
    private static final String JSON_KEY = "photoUrl";
    private static final String RESOURCE_MAPPING = "/temp-photo/";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String FILE_NAME = "filename";
    private static final String TEXT_HTML = "text/html";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Part photoPart = request.getPart(PHOTO_PART);
        if (photoPart != null) {
            InputStream inputStream = photoPart.getInputStream();
            File file = this.saveAsTempFile(inputStream, photoPart);
            String mimeType = photoPart.getContentType();
            this.SaveTempFileInStrorage(file, mimeType);
            String json = this.generateJSON(file);
            this.sendResponse(response, json);
        } else {
            response.sendError(400);
        }
    }

    private void SaveTempFileInStrorage(File file, String mimeType) {
        TempFile tempFile = new TempFile();
        tempFile.setFile(file);
        tempFile.setMimeType(mimeType);
        TempFileStorage.getTempFileStorage().put(file.getName(), tempFile);
    }

    private void sendResponse(HttpServletResponse response, String json) throws IOException {
        response.setContentType(TEXT_HTML);
        PrintWriter out = response.getWriter();
        out.print(json);
        out.flush();
    }

    private String generateJSON(File tempFile) {
        String url = RESOURCE_MAPPING + tempFile.getName();
        String json = "{\"photoUrl\": \"" + url + "\"}";
        return json;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private File saveAsTempFile(InputStream inputStream, Part part) throws IOException {
        String fileName = this.getFileNameFromPart(part);
        File tempFile = File.createTempFile(TEMP_PREFIX, fileName);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            ((OutputStream)out).write(bytes, 0, read);
        }
        inputStream.close();
        out.flush();
        ((OutputStream)out).close();
        return tempFile;
    }

    private String getFileNameFromPart(Part part) {
        String[] stringArray = part.getHeader(CONTENT_DISPOSITION).split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cd = stringArray[n2];
            if (cd.trim().startsWith(FILE_NAME)) {
                return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            }
            ++n2;
        }
        return null;
    }
}

